<?php

namespace App\PalletLabel\Zpl;

class LabelMapper
{
    public static function convertToZplData(array $labelData): array
    {
        $zplData = [
            'carrier_name' => (strtoupper($labelData['carrier_name']) == "BORDER EXPRESS") ? "BEX" : $labelData['carrier_name'],
            'route_code' => $labelData['routecode'],
            'label_creation_date' => date('d-m-Y', strtotime($labelData['label_create_date'])),
            'pickup_address_from' => 'Shipper',
            'pickup_address_name' => $labelData['shipper_details']['name'],
            'pickup_address_line_1' => $labelData['shipper_details']['street'],
            'pickup_address_city' => $labelData['shipper_details']['city'],
            'pickup_address_code' => $labelData['shipper_details']['state'] . $labelData['shipper_details']['pincode'], // pincode is probably wrong data here
            'consignee_address_line_1' => $labelData['drop_details']['street'],
            'consignee_address_city' => $labelData['drop_details']['city'],
            'consignee_name' => $labelData['drop_details']['name'],
            'consignee_address_line_2' => implode(' ', [$labelData['drop_details']['city'], $labelData['drop_details']['state'], $labelData['drop_details']['pincode']]), // pincode is probably wrong data here
            'consignee_name_right' => $labelData['drop_details']['name'],
            'consignee_phone' => $labelData['drop_details']['phone'],
            'consignee_note_number' => $labelData['consignment_no'],
            'store_code' => empty($labelData["carrier_new_name"]) ? $labelData["carrier_name"] : $labelData["carrier_new_name"],
            'barcode_number_of_label' => $labelData['barcode_no'],
            'logistic_unit' => $labelData['cargo_type'],
            'container_number' => $labelData['container_no'],
            'scanned_quantity' => $labelData['no'],
            'total_quantity' => $labelData['qty'],
            'case_id' => $labelData['caseid'],
            'bar_code' => $labelData['barcode_no'],
            'bar_code_display' => '(00) ' . $labelData['barcode_no'],
            'logo' => $labelData['logo'],
            'staticText' => $labelData['staticText'],
            'specialInstructions' => $labelData['specialInstructions'],
        ];
        return $zplData;
    }
}