<?php

namespace App\PodUploads\Constants;

class DocumentType
{
    public const SIGNATURE = 1;
    public const OTHER = 2;
    public const POD = 3;
    public const PUP = 4;
    public const BOL = 6;
    public const POP = 49;

    public const PICKUP = 'P';
    public const DELIVERY = 'D';

    public const DOCUMENT_NAME_MAPPING = [
        self::SIGNATURE => 'Signature',
        self::OTHER => 'Other',
        self::POD => 'POD',
        self::POP => 'POP',
        self::PUP => 'PUP',
        self::BOL => 'BOL'
    ];

    public const STOP_DOCUMENT_TYPES = [
        self::PICKUP => [self::PUP, self::POP, self::SIGNATURE, self::OTHER, self::BOL],
        self::DELIVERY => [self::POD, self::SIGNATURE, self::OTHER, self::BOL]
    ];

    public const MOBILE_DOCUMENT_TYPES = [
        'take_picture' => 3,
        'signature' => 1,
        'upload_from_device' => 3
    ];

   public const STOP_TYPE_TO_DOCUMENT_TYPE_MAPPING = [
        self::MOBILE_DOCUMENT_TYPES['signature'] => self::SIGNATURE,
        self::MOBILE_DOCUMENT_TYPES['upload_from_device'] => ['P' => self::PUP, 'D' => self::POD]
    ];
}
