<?php

declare(strict_types=1);

namespace App\PodUploads\MakePod;

use App\Time\TimerInterface;

final class PodFilename
{
    private TimerInterface $timer;

    public function __construct(TimerInterface $timer)
    {
        $this->timer = $timer;
    }

    public function getFileName(string $externalOrderId): string
    {
        $filenameFormat = 'POD_%s_%d.pdf';
        $timestamp = $this->timer->getTimestamp();
        $filename = sprintf(
            $filenameFormat,
            $externalOrderId,
            $timestamp
        );
        $fullPath = '/var/www/poduploads/' . $filename;

        if (file_exists($fullPath)) {
            $ci = &get_instance();
            $ci->load->helper('log_helper');
            log_error(sprintf('ePOD was not generated, file %s already exists', $filename));

            sleep(1);

            return $this->getFileName($externalOrderId);
        }

        return $fullPath;
    }
}
