<?php

declare(strict_types=1);

namespace App\PodUploads;

use ZipArchive;

final class PodZipArchive
{
    private const ZIP_ARCHIVE_ABSOLUTE_PATH = '/home/efs/assets/poduploads/documentsziparchive/';
    private const ZIP_ARCHIVE_PATH = NEW_POD_PATH.'documentsziparchive/';

    private string $zipArchiveFileName;

    public function __construct(string $zipArchiveName)
    {
        $this->zipArchiveFileName = $zipArchiveName;

        if (!file_exists(self::ZIP_ARCHIVE_ABSOLUTE_PATH)) {
            mkdir(self::ZIP_ARCHIVE_ABSOLUTE_PATH, 0777, true);
        }
    }

    public function generateZipFile(array $documentsData, string $documentName): bool
    {
        $zip = new ZipArchive();
        if ($zip->open($this->getAbsolutePath(), ZipArchive::CREATE) !== true) {
            log_message("error", "cannot open " . $this->zipArchiveFileName);
            return false;
        }
        foreach ($documentsData as $documents) {
            $fileLink = new PodFile($documents['imgpath']);
            if (strlen($fileLink->getAbsolutePath()) > 0) {
                $zip->addFile($fileLink->getAbsolutePath(), $documentName . DIRECTORY_SEPARATOR . $documents['order_id'] . '_' . pathinfo($fileLink->getAbsolutePath())['basename']);
            }
        }
        return $zip->close();
    }

    public function exists(): bool
    {
        return file_exists(self::ZIP_ARCHIVE_ABSOLUTE_PATH . $this->zipArchiveFileName);
    }

    public function getAbsolutePath(): string
    {
        return self::ZIP_ARCHIVE_ABSOLUTE_PATH . $this->zipArchiveFileName;
    }

    public function getPath(): string
    {
        return self::ZIP_ARCHIVE_PATH . $this->zipArchiveFileName;
    }
}
