<?php

namespace App\ShiftsData;

trait AddressesFromShiftTrait
{
    /**
     * @param array $d
     * @return string[]
     */
    private function addressesFromShift(array $d): array
    {
        $drop = "";
        if (strlen($d["dcity"]) > 0) {
            $drop .= ucfirst(str_replace("_", " ", $d["dcity"])) . " - ";
        }
        if (strlen($d["eplace"]) > 0) {
            $drop .= ucfirst(str_replace("_", " ", $d["eplace"]));
        }

        $pickup = "";
        if (strlen($d["scity"]) > 0) {
            $pickup .= ucfirst(str_replace("_", " ", $d["scity"])) . " - ";
        }
        if (strlen($d["splace"]) > 0) {
            $pickup .= ucfirst(str_replace("_", " ", $d["splace"]));
        }

        return array($pickup, $drop);
    }
}
