<?php

namespace App\ShiftsData;

trait CountPickupDropGateins
{
    /**
     * @param array $shiftData
     * @return array
     */
    private function countPickupDropGateins(array $shiftData): array
    {
        $shipmentId  = $this->db->escape_str($shiftData['shift_id']);

        $gateIns =  $this->db->select(['id', 'stop_type'])
            ->get_where('tb_stop_status',
                        [
                            'shipment_id' => $shipmentId,
                            'status_id' => StopStatuses::GATEIN
                        ])
            ->result();

        $pickupGateinsCount = 0;
        $dropGateinsCount = 0;
        foreach ($gateIns as $gateIn) {
            switch ($gateIn->stop_type) {
                case StopTypes::PICKUP:
                    $pickupGateinsCount++;
                    break;
                case StopTypes::DROP:
                    $dropGateinsCount++;
                    break;
                default:
            }
        }

        $deliveryStopsCount = $this->db->select('id')
            ->get_where('tb_shiporder_stops',
                        [
                            'shipment_id' => $shipmentId,
                            'stoptype' => StopTypes::DROP,
                        ])
            ->num_rows();

        $shiftData['pickupGateinsCount'] = $pickupGateinsCount;
        $shiftData['dropGateinsCount'] = $dropGateinsCount;
        $shiftData['deliveryStopsCount'] = $deliveryStopsCount;
        return $shiftData;
    }
}
