<?php

namespace App\ShiftsData;

trait ExtractShiporderStopsTrait
{

    /**
     * @param array $shiftData
     * @return array
     */
    private function extractShiporderStops(array $shiftData): array
    {
        $chstops = $this->db->select("address")
            ->order_by("ordernumber", "ASC")
            ->get_where("tb_shiporder_stops", ["shipment_id" => $this->getShiftIdEscaped($shiftData)]);
        if ($chstops->num_rows() > 0) {
            $results = $chstops->result();
            $shiftData["saddress"] = array_shift($results)->address;
            $results = $chstops->result();
            $shiftData["daddress"] = array_pop($results)->address;
        }

        return $shiftData;
    }


    /**
     * @param array $d
     * @return array
     */
    private function extractShipOrderStopsWithIds(array $d): array
    {
        $chstops = $this->db->select("id,address")
            ->order_by("ordernumber", "ASC")
            ->get_where("tb_shiporder_stops", array("shipment_id" => $this->getShiftIdEscaped($d)));
        
        $stopscount = $chstops->num_rows();

        if ($stopscount > 0) {
            $result = $chstops->result();
            $first = array_shift($result);
            $d["saddress"] = $first->address;
            $sstop = $first->id;
            $last = array_pop($result);
            $d["daddress"] = $last->address;
            $dstop = $last->id;
        } else {
            $dstop = null;
            $sstop = null;
        }

        return array($stopscount, $dstop, $sstop, $d);
    }

    /**
     * @param array $d
     * @return mixed
     */
    private function getShiftIdEscaped(array $d)
    {
        $shiftId = $d['shift_id'] ?? null;
        return $this->db->escape_str($shiftId);
    }
}
