<?php

namespace App\ShiftsData;

use App\ShiftsData\TbStopStatusFields\StatusId;
use App\ShiftsData\TbStopStatusFields\StopType;

class ProcessStopstatuses
{
    /**
     * @param $stops
     * @return array
     */
    public static function processStopstatuses($stops): array
    {
        $dataStops = [];
        $dataPickupDatetime = "";
        $dataDeliveryDatetime = "";

        if ($stops->num_rows() > 0) {
            foreach ($stops->result() as $sres) {
                $statusId = $sres->status_id;
                $stopType = $sres->stop_type;
                $stsname = $sres->status_name;
                if ($statusId == StatusId::GATEIN && $stopType == StopType::PICKUP) {
                    $stsname = "Pickup Gate In";
                }
                if ($statusId == StatusId::PICKUP_DONE_OR_DELIVERY_DONE && $stopType == StopType::PICKUP) {
                    $dataPickupDatetime = $sres->createdon;
                    $stsname = "Pickup Done";
                }
                if ($statusId == StatusId::GATEOUT && $stopType == StopType::PICKUP) {
                    $stsname = "Pickup Gate Out";
                }
                if ($statusId == StatusId::GATEIN && $stopType == StopType::DROP) {
                    $stsname = "Delivery Gate In";
                }
                if ($statusId == StatusId::PICKUP_DONE_OR_DELIVERY_DONE && $stopType == StopType::DROP) {
                    $dataDeliveryDatetime = $sres->createdon;
                    $stsname = "Delivery Done";
                }
                if ($statusId == StatusId::GATEOUT && $stopType == StopType::DROP) {
                    $stsname = "Delivery Gate Out";
                }
                $locname = "";
                if ($sres->latitude != "") {
                    $locname = getLocationName($sres->latitude, $sres->longitude);
                }
                $dataStops[] = array(
                    "datetime" => $sres->createdon,
                    "status" => $stsname,
                    "truck_no" => $sres->register_number,
                    "driver" => $sres->name,
                    "location" => $locname
                );
            }
        }
        return array($dataStops, $dataPickupDatetime, $dataDeliveryDatetime);
    }
}
