<?php

namespace App\ShipmentStopDetails;

class PrepareShipmentStopDetailsResult
{

    /**
     * @param $city
     * @param $address
     * @return string
     */
    public static function prepareAddress($city, $address): string
    {
        $addressString = "";
        if (strlen($city) > 0) {
            $addressString .= ucfirst(str_replace("_", " ", $city)) . " - ";
        }
        if (strlen($address) > 0) {
            $addressString .= ucfirst(str_replace("_", " ", $address));
        }
        return $addressString;
    }

    /**
     * @param $cargo_orders
     * @param $package
     * @param $content
     * @param array $goods
     * @return array
     */
    public static function extractOrderCargoDetails($cargo_orders, $package, $content, array $goods): array
    {
        if ($cargo_orders->num_rows() > 0) {
            foreach ($cargo_orders->result() as $cargo) {
                $package = $cargo->quantity_type;
                $content = $cargo->cargo_content;
                $quantity = $cargo->quantity;
                $dangerous = ($cargo->dg_goods == 0) ? 'false' : 'true';
                $stackable = ($cargo->stackable == 0) ? 'false' : 'true';
                $grounded = ($cargo->grounded == 0) ? 'false' : 'true';
                $splittable = ($cargo->splittable == 0) ? 'false' : 'true';
                $goods[] = array('dangerous' => $dangerous, 'stackable' => $stackable, 'grounded' => $grounded, 'splittable' => $splittable, 'quantity' => $quantity);
            }
        }
        return array($package, $content, $goods);
    }

    /**
     * @param $stop_sts
     * @param int $k
     * @param array $result
     * @return array
     */
    public static function prepareResult($stop_sts, int $k, array $result): array
    {
        log_message("error","result:::".json_encode($result));
         log_message("error","kkkkk11111111:::".$k);
         log_message("error","stop_sts111111:::".$stop_sts);
        if ($stop_sts == "S" && $k == 1) {
            log_message("error","iff11:::".json_encode($result));
            if (count($result) > 0) {
                log_message("error","iff22:::".json_encode($result));
                $ms = array_column($result, 'milestone');
                array_multisort($ms, SORT_DESC, $result);
            }
        } else {
            log_message("error","kkkkk:::".$k);
             log_message("error","stop_sts:::".$stop_sts);
            if ($stop_sts == "S" && $k == 0) {
                log_message("error","iff00:::".json_encode($result));
                /*if (count($result) > 0) {
                    $result[0]['milestone'] = 1;
                }*/
                if (count($result) > 0) {
                    log_message("error","iff33:::".json_encode($result));
                    for( $i=0;$i<count($result);$i++){
                        $result[$i]['milestone'] = 1;
                    }
                }
            }
        }
        log_message("error","result111:::".json_encode($result));
        return $result;
    }
}
