<?php

namespace App\ShipmentStopDetails;

use App\ApiRequest\DataPreprocessing\BadRequestException;
use App\ApiRequest\DataPreprocessing\PostTimezoneFilter;
use App\ApiRequest\DataPreprocessing\TimezoneNotSpecifiedException;

class PreprocessShipmentStopDetailsData
{

    /**
     * @return array
     * @throws BadRequestException
     * @throws TimezoneNotSpecifiedException
     */
    public static function preprocessPostData(): array
    {
        if (!isset($_POST) && !empty($_POST)) {
            throw new BadRequestException("Insufficient Input Data");
        }
        $shiftVehicleId = $_POST["shift_veh_id"] ?? '';
        if ($shiftVehicleId == "") {
            throw new BadRequestException("Insufficient Input Data");
        }
        $curtz = PostTimezoneFilter::getCurtz($_POST['timezone'] ?? null);
        $shift_id = $_POST["shift_id"] ?? '';
        $stop_id = $_POST["stop_id"] ?? '';
        $trip = $_POST["trip_id"] ?? 0;
        $stop_sts = $_POST["stop_sts"] ?? "N";
        $order_id = $_POST["order_id"] ?? '';
        if ($trip == "") {
            $trip = 0;
        }
        return array($curtz, $shift_id, $stop_id, $trip, $stop_sts, $order_id);
    }
}
