<?php

namespace App\ThrowableHandler;

use App\ApiRequest\DataPreprocessing\MethodNotAllowedException;

class DisplayApiThrowableMessage implements ThrowableHandler
{
    public function handleThrowable(\Throwable $throwable): void
    {
        if ($throwable instanceof MethodNotAllowedException) {
            $status = 405;
        } else {
            $status = 400;
        }
        set_status_header($status);
        $response = ["status" => 0, "message" => $throwable->getMessage()];
        echo json_encode($response);
        exit(1);
    }
}
