<?php
declare(strict_types=1);
namespace App\Time;

final class Timer implements TimerInterface
{
	private const DEFAULT_DATE_TIME_FORMAT = 'Y-m-d H:i:s';
    public function getTimestamp(): int
    {
        return time();
    }

    public function getTimestampForToday(): int
    {
        return strtotime(date('Y-m-d'));
    }

    public function getLocalDateTimeForTimestamp(int $timestamp, \DateTimeZone $timeZone, string $format = null): string
    {
        if ($format && trim($format) === '') {
            throw new \LogicException('Format of DateTime cannot be empty string');
        }
        $localDateTime = new \DateTimeImmutable();
        $localDateTime = $localDateTime->setTimestamp($timestamp);
        $localDateTime = $localDateTime->setTimezone($timeZone);
        return $localDateTime->format($format ?? SELF::DEFAULT_DATE_TIME_FORMAT);
    }
}