<?php
namespace App\Traits;

trait AutoRoutingTrait
{
    /**
     * @param int $orderId
     * @param string $orderStatus
     * @return array|null
     */
    private function verifyRouting(int $orderId, string $orderStatus = 'Ready') : ?array
    {
        $this->load->model('Order');
        $order = $this->Order->getordertoedit( $orderId )->row();
        $transportMode = $this->common->gettblrowdata([
            'code' => $order->transport_mode,
            'company_code' => $order->company_code,
            'branch_code' => $order->branch_code,
            'status' => 1
        ], "id", "tb_transportmode", 0, 0);
        $incoTerm = $this->common->gettblrowdata([
            'name' => $order->incoterm,
            'company_code' => $order->company_code,
            'branch_code' => $order->branch_code,
            'status' => 1
        ], "id", "tb_transportmode", 0, 0);

        $userId =  $this->session->userdata('user_id');
        $conditions = [
            'trans_type' => 2,
            'cust_id' => $order->customer_id,
            'company_code' => $order->company_code,
            'branch_code' => $order->branch_code,
            'triggered_type' => '2',
            'trigger_at' => 1,
            'user_id' => $userId,
            'carrier_id !=' => 0,
            'status' => 1,
            'order_status' => $orderStatus
        ];
        $routingAuto = $this->common->gettbldata($conditions, ['*'], "tb_routing_auto", 0, 0);
        if (empty($routingAuto)) {
            return null;
        }
        $routingAuto = reset($routingAuto);
        $validation = [
            'order_type' => $order->order_type,
            'product' => 76,
            'mot' => $transportMode['id'] ?? null,
            'service' => $order->service,
            'inco_terms' => $incoTerm['id'] ?? '',
            'pick_val' => $this->getRoutingValue($routingAuto['pick_type'], $order, true),
            'deli_val' => $this->getRoutingValue($routingAuto['deli_type'], $order, false)
        ];

        foreach ($validation as $key => $value) {
            if (!empty($routingAuto[$key]) && ( strtoupper($routingAuto[$key]) != strtoupper($value) )) {
                return null;
            }
        }

        $table = 'tb_order_cargodetails';
        $whrr = array( 'order_id' => $order->id, 'status' => 1 );
        $select = 'id, order_id, cargo_id, handling_unit, length, width, height, weight, second_weight, volumetric_weight, volweight_uom, ldm, volume, second_volume, quantity, scanned_quantity, quantity_type, cargo_content';
        $cargoinfo = $this->common->gettbldata( $whrr, $select, $table, 0, 0);
        if ( count( $cargoinfo ) > 0 ) {
            $weight = 0;
            $second_weight = 0;
            $volume = 0;
            $second_volume = 0;
            foreach ( $cargoinfo as $row ) {
                $weight += $row['weight'];
                $second_weight += $row['second_weight'];
                $volume += $row['volume'];
                $second_volume += $row['second_volume'];
            }
            $cargoDetails = compact('weight', 'second_weight', 'volume', 'second_volume');
            /***  validate to constains to create auto trio  ***/
            $checkAuto = $this->checkcargofir_autorout( $cargoDetails, $routingAuto );
            if ($checkAuto == 'no') {
                return null;
            }
        }

        $ordersNewList = $this->checkIdentifireMatch(
            [[
                'order_id' => $order->id,
                'date' => strtotime($order->pickup_datetime),
                'booking_id' => $order->order_id,
                'vehicle_type' => $routingAuto['vehicle_type'],
                'vendor_id' => $routingAuto['carrier_id'],
                'driver_id' => $routingAuto['driver_id']
            ]],
            $routingAuto['ship_identifier'],
            $routingAuto['cons_identifier'],
            $routingAuto['notify_identifier']
        );
        return !empty($ordersNewList) ? reset($ordersNewList) : null;
    }

    /**
     * @param $routingType
     * @param $order
     * @param $isPick
     * @return mixed|string|null
     */
    private function getRoutingValue($routingType, $order, $isPick)
    {
        $value = '';
        switch ($routingType) {
            case 'Location ID':
            case 'Region':
                $country = $isPick ? $order->pickup_country : $order->delivery_country;
                $pincode = $isPick ? $order->pickup_pincode : $order->delivery_pincode;
                $city = $isPick ? $order->pickup_city : $order->delivery_city;

                $country = in_array(strtoupper($country), ['RUSSIA', 'РОССИЯ']) ? 'RU' : $country;
                $country = in_array(strtoupper($country), ['AUSTRALIA', 'AU']) ? 'RU' : $country;
                $value = null;
                if (!empty($pincode)) {
                    $zipRouting = $this->common->gettblrowdata([
                        'postal_code' => $pincode,
                        'country' => $country,
                        'status'=>'1'
                    ], ["region"], "tb_kn_geocodes", 0, 0);

                    if (!empty($zipRouting)) {
                        $value = $zipRouting['region'];
                    } else {
                        $cityRouting = $this->common->gettblrowdata([
                            'city' => $city,
                            'country' => $country,
                            'status'=>'1'
                        ], ["region"], "tb_kn_geocodes", 0, 0);
                        $value = $cityRouting['region'] ?? null;
                    }
                }
                break;
            case 'City':
                $value = $isPick ? $order->pickup_city : $order->delivery_city;
                break;
            case 'State':
                $value = $isPick ? $order->pickup_address2 : $order->delivery_address2;
                break;
            case 'Country':
                $value = $isPick ? $order->pickup_country : $order->delivery_country;
                break;
            case 'Zipcode':
                $value = $isPick ? $order->pickup_pincode : $order->delivery_pincode;
                break;
        }

        return $value;
    }



    /**
     * checkcargofir_autorout
     *
     * validate to cargo details and routing details
     *
     * @param   array $data order details
     * @param  array $rw  touting details
     * @return string
     */
    public  function checkcargofir_autorout(array $data, array $rw) : string
    {
        $weightc = $this->checkwwhite( $data, $rw );
        $weightc_ac = $this->checkwwhite_ac( $data, $rw );
        $volumec = $this->checkvolume( $data, $rw );
        $volumec_ac = $this->checkvolume_sc( $data, $rw );

        if ( $weightc == 'yes' && $weightc_ac == 'yes' && $volumec == 'yes' && $volumec_ac == 'yes' ) {

            return 'yes';
        }

        if ( $volumec_ac == 'yes' && $volumec == 'yes' && $weightc_ac == 'yes' && $weightc != 'false' ) {

            return 'yes';
        }

        if ( $volumec_ac == 'yes' && $volumec == 'yes' && $weightc == 'yes' && $weightc_ac != 'false' ) {

            return 'yes';
        }

        if ( $volumec_ac == 'yes' && $volumec == 'yes' && $weightc != 'false' && $weightc_ac != 'false' ) {

            return 'yes';
        }

        if ( $volumec_ac == 'yes' && $weightc_ac == 'yes' && $weightc == 'yes' && $volumec != 'false' ) {

            return 'yes';
        }

        if ( $volumec_ac == 'yes' && $weightc_ac == 'yes' && $volumec != 'false' && $weightc != 'false' ) {

            return 'yes';
        }

        if ( $volumec_ac == 'yes' && $weightc == 'yes' && $weightc_ac != 'false' && $volumec != 'false' ) {

            return 'yes';
        }

        if ( $volumec_ac == 'yes' && $weightc != 'false' && $weightc_ac != 'false' && $volumec != 'false' ) {

            return 'yes';
        }

        if ( $volumec == 'yes' && $weightc_ac == 'yes' && $weightc == 'yes' && $volumec_ac != 'false' ) {

            return 'yes';
        }

        if ( $volumec == 'yes' && $weightc_ac == 'yes' && $volumec_ac != 'false' && $weightc != 'false' ) {

            return 'yes';
        }

        if ( $volumec == 'yes' && $weightc == 'yes' && $weightc_ac != 'false' && $volumec_ac != 'false' ) {

            return 'yes';
        }
        if ( $volumec == 'yes' && $weightc != 'false' && $weightc_ac != 'false' && $volumec_ac != 'false' ) {

            return 'yes';
        }

        if ( $weightc_ac == 'yes' && $weightc == 'yes' && $volumec != 'false' && $volumec_ac != 'false' ) {

            return 'yes';
        }
        if ( $weightc_ac == 'yes' && $weightc != 'false' && $volumec != 'false' && $volumec_ac != 'false' ) {

            return 'yes';
        }
        if ( $weightc == 'yes' && $weightc_ac != 'false' && $volumec != 'false' && $volumec_ac != 'false' ) {

            return 'yes';
        }

        return 'no';
    }

    /**
     * checkwwhite
     *
     * check weight matching or not
     *
     * @param   array $data order details
     * @param  array $rw  touting details
     * @return string
     */
    public function checkwwhite( $data, $rw ) {

        if ( $rw['min_weight'] >= 0 && $rw['max_weight'] >= 0 ) {

            if ( ( $data['second_weight'] >= $rw['min_weight'] && $data['second_weight'] <= $rw['max_weight'] ) ) {

                return 'yes';
            } else {
                return 'false';
            }
        } else {
            return 'no';
        }
    }

    /**
     * checkwwhite_ac
     *
     * check actaul weight matching or not
     *
     * @param   array $data order details
     * @param  array $rw  touting details
     * @return string
     */
    public function checkwwhite_ac( $data, $rw ) {

        if ( $rw['min_weight_ac'] >= 0 && $rw['max_weight_ac'] >= 0 ) {

            if ( ( $data['weight'] >= $rw['min_weight_ac'] && $data['weight'] <= $rw['max_weight_ac'] ) ) {

                return 'yes';
            } else {
                return 'false';
            }
        } else {
            return 'no';
        }
    }

    /**
     * checkvolume
     *
     * check   volume matching or not
     *
     * @param   array $data order details
     * @param  array $rw  touting details
     * @return string
     */
    public function checkvolume( $data, $rw ) {

        if ( $rw['min_volume'] >= 0 && $rw['max_volume'] >= 0 ) {

            if ( ( $data['second_volume'] >= $rw['min_volume'] && $data['second_volume'] <= $rw['max_volume'] ) ) {

                return 'yes';
            } else {

                return 'false';
            }
        } else {
            return 'no';
        }
    }
    /**
     * checkvolume_sc
     *
     * check actaul volume matching or not
     *
     * @param   array $data order details
     * @param  array $rw  touting details
     * @return string
     */
    public  function checkvolume_sc( $data, $rw ) {

        if ( $rw['min_volume_ac'] >= 0 && $rw['max_volume_ac'] >= 0 ) {

            if ( ( $data['volume'] >= $rw['min_volume_ac'] && $data['volume'] <= $rw['max_volume_ac'] ) ) {

                return 'yes';
            } else {

                return 'false';
            }
        } else {
            return 'no';
        }
    }

    /**
     * @param array $orders_list
     */
    public function inserttripdata(array $orders_list)
    {
        $j =0;

        $user_id =  $this->session->userdata('user_id');
        $company_code = $this->session->userdata('company_code');
        $branch_code = $this->session->userdata('branch_code');

        $userid = $user_id;
        $logdate = date('Y-m-d H:i:s');
        $curdt = $logdate;
        $iMax = count($orders_list);
        $inserted = 0;

        for ($i=0;  $i < $iMax; $i++) {
            $trip_shftid = $orders_list[$j]['trip'];
            $order_shftid = $orders_list[$j]['order_id'];
            $booking_shftid = $orders_list[$j]['order_id'];
            $tpvehicle_type = $orders_list[$j]['vehicle_type'];
            $vendor_id = $orders_list[$j]['vendor_id'];
            $driver_id = $orders_list[$j]['driver_id'];
            $vehicle_id = $orders_list[$j]['vehicle_id'] ?? $tpvehicle_type;
            $count_code=substr($company_code, 0, 2);
            $year=date('y');
            $week=date('W');
            $seq_num=000001;

            if($booking_shftid != ""){
                $seq_num=substr($booking_shftid, -6);
            }

            $shipid = $txnid= "T".$count_code.$week.$year.$seq_num;
            $tripid = $orders_list[$i]['trip'];
            $order_id = $orders_list[$i]['order_id'];

            $where = ["id"=>$order_id];
            $select = "*";
            $table = "tb_orders";
            $order = $this->common->gettblrowdata($where,$select,$table,0,0);

            if(!empty($order)) {
                $shift_idchk = $order['shift_id'];

                if(!$shift_idchk) {
                    $sql = "SELECT oc.id,oc.quantity,oc.width,oc.height,oc.length,oc.weight,im.unit_name
                            FROM tb_order_cargodetails oc,tbl_shipunit_types im
                            WHERE oc.order_id = ? AND im.id = oc.handling_unit AND oc.status='1'";

                    $stops_units = $this->db->query($sql, [$order_id]);
                    $pickup = $order['pickup_address1'];

                    if($pickup == ""){ $pickup = $order['pickup_city']; }
                    $delivery = $order['delivery_address1'];

                    if($delivery == ""){
                        $delivery = $order['delivery_city'];
                    }

                    $address = $dropaddr = "";

                    if($order['pickup_address1'] != ""){
                        $address .= $order['pickup_address1'];
                        $dropaddr .= $order['delivery_address1'];
                    }
                    if($order['pickup_company'] != ""){
                        $address .= ", ".$order['pickup_company'];
                        $dropaddr .= ", ".$order['delivery_company'];
                    }
                    if($order['pickup_country'] != ""){
                        $address .= ", ".$order['pickup_country'];
                        $dropaddr .= ", ".$order['delivery_country'];
                    }
                    if($order['pickup_city'] != ""){
                        $address .= ", ".$order['pickup_city'];
                        $dropaddr .= ", ".$order['delivery_city'];
                    }
                    if($order['pickup_pincode'] != ""){
                        $address .= ", ".$order['pickup_pincode'];
                        $dropaddr .= ", ".$order['delivery_pincode'];
                    }

                    $plat = $order['plat'];
                    $plng = $order['plng'];
                    $dlat = $order['dlat'];
                    $dlng = $order['dlng'];

                    if($i === 0) {
                        $where = ["shipmentid"=>$shipid];
                        $select = "id,splace,slat,slng,eplace,elat,elng,vendor_id,weight,volume,units,vehicle_type";
                        $table = "tb_shifts";
                        $shipment = $this->common->gettblrowdata($where,$select,$table,0,0);

                        if(!count($shipment)) {
                            $curdt = $logdate;
                            $customer_id = $order['customer_id'];
                            $transport_mode= $order['transport_mode'];
                            $weight= $order['weight'];
                            $volume= $order['volume'];
                            $txnid = $shipid;

                            if($tpvehicle_type!='' && $tpvehicle_type != 0){
                                $vtwhere = array("id"=>$tpvehicle_type);
                                $vtselect = "trucktype";
                                $vttable = "tb_trucktypes";

                                $vtorder = $this->common->gettblrowdata($vtwhere,$vtselect,$vttable,0,0);
                                $vehicle_type = (count($vtorder) > 0) ? $vtorder['trucktype'] : $order['vehicle_type'];
                            }else{
                                $vehicle_type = $order['vehicle_type'];
                            }

                            $startdate = $order['pickup_datetime'];
                            $starttime = date('H:i',strtotime($startdate));

                            $enddate = $order['delivery_datetime'];
                            $endtime = date('H:i',strtotime($enddate));

                            $insarr = array('user_id'=>$userid, 'stime'=>$starttime, 'etime'=>$endtime, 'splace'=>$order['pickup_city'], 'slat'=>$plat, 'slng'=>$plng, 'eplace'=>$order['delivery_city'], 'elat'=>$dlat, 'elng'=>$dlng, 'scity'=>$order['pickup_city'], 'dcity'=>$order['delivery_city'], 'zone_id'=>1, 'empshift_start'=>$starttime, 'empshift_end'=>$endtime, 'trip_type'=>0, 'startdate'=>$startdate, 'enddate'=>$enddate, 'shipment_name'=>'Boxes', 'shipment_id'=>0, 'transport_mode'=>$transport_mode, 'customer_id'=>$customer_id, 'vendor_id'=>$vendor_id, 'carrier_type'=>0, 'shipmentid'=>$txnid, 'txnid'=>$txnid,'weight'=>$weight, 'volume'=>$volume, 'units'=>$order['quantity'],'domainname'=>'INFD', 'vehicle_type'=>$vehicle_type, 'status'=>1, "company_code"=>$company_code,"branch_code"=>$branch_code );
                            $ship_id = $this->db->insert("tb_shifts", $insarr) ? $this->db->insert_id() : 0;
                        }else{
                            $ship_id = $shipment['id'];
                        }
                    } else {
                        if($trip_shftid == $tripid){
                            $ship_id = $txnid = "0";
                            $getshiftdata = $this->db->select("shift_id,shipmentid")->get_where("tb_orders",array('id'=>$order_shftid));

                            if($getshiftdata->num_rows() >0){
                                $ship_id = $getshiftdata->row()->shift_id ?? 0;
                                $txnid = $getshiftdata->row()->shipmentid ?? '';
                            }
                        } else {
                            $j =$i;
                            $booking_shftid = $orders_list[$j]['booking_id'];

                            if($booking_shftid != "" && $booking_shftid != ''){
                                $seq_num=substr($booking_shftid, -6);
                            }

                            $shipid = $txnid= "T".$count_code.$week.$year.$seq_num;
                            $where = array("shipmentid"=>$shipid);
                            $select = "id,splace,slat,slng,eplace,elat,elng,vendor_id,weight,volume,units,vehicle_type";
                            $table = "tb_shifts";
                            $shipment = $this->common->gettblrowdata($where,$select,$table,0,0);

                            if(count($shipment)==0){
                                $customer_id = $order['customer_id'];
                                $transport_mode= $order['transport_mode'];
                                $weight= $order['weight'];
                                $volume= $order['volume'];
                                $txnid = $shipid;

                                if($tpvehicle_type!='' && $tpvehicle_type != 0){
                                    $vtwhere = array("id"=>$tpvehicle_type);
                                    $vtselect = "trucktype";
                                    $vttable = "tb_trucktypes";

                                    $vtorder = $this->common->gettblrowdata($vtwhere,$vtselect,$vttable,0,0);
                                    $vehicle_type = (count($vtorder) > 0) ? $vtorder['trucktype'] : $order['vehicle_type'];
                                }else{
                                    $vehicle_type = $order['vehicle_type'];
                                }

                                $startdate = $order['pickup_datetime'];
                                $starttime = date('H:i',strtotime($startdate));

                                $enddate = $order['delivery_datetime'];
                                $endtime = date('H:i',strtotime($enddate));

                                $insarr = ['user_id'=>$userid, 'stime'=>$starttime, 'etime'=>$endtime, 'splace'=>$order['pickup_city'], 'slat'=>$plat, 'slng'=>$plng, 'eplace'=>$order['delivery_city'], 'elat'=>$dlat, 'elng'=>$dlng, 'scity'=>$order['pickup_city'], 'dcity'=>$order['delivery_city'], 'zone_id'=>1, 'empshift_start'=>$starttime, 'empshift_end'=>$endtime, 'trip_type'=>0, 'startdate'=>$startdate, 'enddate'=>$enddate, 'shipment_name'=>'Boxes', 'shipment_id'=>0, 'transport_mode'=>$transport_mode, 'customer_id'=>$customer_id, 'vendor_id'=>$vendor_id, 'carrier_type'=>0, 'shipmentid'=>$txnid, 'txnid'=>$txnid,'weight'=>$weight, 'volume'=>$volume, 'units'=>$order['quantity'],'domainname'=>'INFD', 'vehicle_type'=>$vehicle_type, 'status'=>1, "company_code"=>$company_code,"branch_code"=>$branch_code];
                                $ship_id = $this->db->insert("tb_shifts", $insarr) ? $this->db->insert_id() : 0;
                            }else{
                                $ship_id = $shipment['id'];
                            }

                        }
                    }

                    /*update order table*/
                    $capacity = $order['weight'];

                    if($capacity == ""){
                        $capacity = "0";
                    }

                    $upddt = ['vendor_id'=>$vendor_id,'shift_id'=>$ship_id,"shipmentid"=>$txnid];
                    $updwhr = ["id"=>$order_id];

                    $this->common->updatetbledata("tb_orders",$upddt,$updwhr);
                    makeorderinvolvedpartiestype($vendor_id,$order_id,"CARRIER", $user_id, $company_code);

                    $info = ['ordid'=>$order_id,'carrierid'=>$vendor_id];
                    $this->ratemanagement->addrecodfortripinsertion($info);

                    $insarr = [
                        'assoc_id'=>$txnid, 'pickup'=>$pickup, 'plat'=>$plat,
                        'plng'=>$plng, 'drop'=>$delivery,'dlat'=>$dlat, 'dlng'=>$dlng,
                        'pickup_city'=>$order['pickup_city'], 'drop_city'=>$order['delivery_city'],
                        'pickup_datetime'=>$order['pickup_datetime'], 'drop_datetime'=>$order['delivery_datetime'],
                        'name'=>'Boxes', 'phone'=>$order['customer_phone'],
                        'address'=>$address,'emailid'=>$order['customer_email'],
                        'user_id'=>$userid, 'status'=>1,
                        'createdon'=>$curdt, 'material_id'=>0,
                        'capacity'=>$capacity,
                        'information'=>$order['customer_comments'],
                        'shipment_weight'=>$order['weight'],
                        'shipment_volume'=>$order['volume'],
                        'ship_type'=>'P', 'customer_id'=>$order['customer_id'],
                        'vendor_id'=>$vendor_id, 'shipment_id'=>0, 'startdate'=>$order['pickup_datetime'],
                        'enddate'=>$order['delivery_datetime'], 'shift_id'=>$ship_id, 'stop_order'=>1,
                        'drop_order'=>0, 'basic_stop'=>0, 'stop_id'=>0, 'drop_stopid'=>0, 'order_id'=>$order['order_id'],
                        'pkgitemid'=>'BOXES', 'no_of_pkgs'=>$order['quantity'], 'domainname'=>'INFD'
                    ];

                    $detail_id = $this->db->insert("tb_employee",$insarr) ? $this->db->insert_id() : 0;

                    if($detail_id > 0 ) {
                        if($stops_units->num_rows() > 1) {
                            $odata=$stops_units->row();
                            $this->db->query("UPDATE tb_order_cargodetails set stop_detail_id='$detail_id' WHERE id = '".$odata->id."'");
                        }

                        /*update orders table*/
                        $updwhr = ['id'=>$order_id];
                        $setwhr = ['status'=>2];
                        $this->db->where($updwhr)->update("tb_orders",$setwhr);

                        /*insert stops records */
                        $where = ["shipment_id"=>$ship_id,"stopcity"=>$order['pickup_city'],"stoptype"=>"P"];
                        $select = "id";
                        $table = "tb_shiporder_stops";
                        $chkstop = $this->common->gettblrowdata($where,$select,$table,0,0);

                        if(count($chkstop) == 0){
                            $insarr = ['stopname'=>$order['pickup_city'], 'plat'=>$plat, 'plng'=>$plng, 'stopcity'=>$order['pickup_city'], 'address'=>$address, 'stoptype'=>'P', 'stopstatus'=>0, 'shipment_id'=>$ship_id, 'ordernumber'=>1, 'startdate'=>$order['pickup_datetime'], 'enddate'=>$order['pickup_endtime'], 'weight'=>$order['weight'], 'volume'=>$order['volume'], 'shipmentstopid'=>0, 'ship_units'=>$order['quantity'], 'txncode'=>'NP', 'status'=>1, 'created_on'=>$curdt];
                            $pickupstop_id = $this->db->insert("tb_shiporder_stops",$insarr) ? $this->db->insert_id() : 0;
                        }else{
                            $pickupstop_id = $chkstop['id'];
                        }

                        $where = ["shipment_id"=>$ship_id,"stopcity"=>$order['delivery_city'],"stoptype"=>"D"];
                        $select = "id";
                        $table = "tb_shiporder_stops";
                        $chkstop = $this->common->gettblrowdata($where,$select,$table,0,0);

                        if(count($chkstop) == 0){
                            $insarr = ['stopname'=>$order['delivery_city'], 'plat'=>$dlat, 'plng'=>$dlng, 'stopcity'=>$order['delivery_city'], 'address'=>$dropaddr, 'stoptype'=>'D', 'stopstatus'=>0, 'shipment_id'=>$ship_id, 'ordernumber'=>2, 'startdate'=>$order['delivery_datetime'], 'enddate'=>$order['drop_endtime'], 'weight'=>$order['weight'], 'volume'=>$order['volume'], 'shipmentstopid'=>0, 'ship_units'=>$order['quantity'], 'txncode'=>'NP', 'status'=>1, 'created_on'=>$curdt];
                            $dropstop_id = $this->db->insert("tb_shiporder_stops",$insarr) ? $this->db->insert_id() : 0;
                        }else{
                            $dropstop_id = $chkstop['id'];
                        }

                        /*update pickupstop and drop stop id into details/tb_employee table */
                        $setarr = ['stop_id'=>$pickupstop_id, 'drop_stopid'=>$dropstop_id];
                        $setwhr = ['id'=>$detail_id];

                        $this->db->where($setwhr)->update("tb_employee",$setarr);
                        $chk1 = $this->db->select("id")->get_where("tb_shft_veh", ["shft_id"=>$ship_id],1,0);

                        if($chk1->num_rows() > 0){
                            $shftvehid = $chk1->row()->id ?? 0;
                            $chk = $this->db->select("id")->get_where("tb_shft_veh_emp", ["shft_veh_id"=>$shftvehid,"status"=>1],1,0);

                            if($chk->num_rows() == 0){
                                $getemp = $this->db->select("id,pickup_datetime,drop_datetime")->get_where("tb_employee", ["shift_id"=>$ship_id]);

                                if($getemp->num_rows()>0){
                                    $pri = 1;

                                    foreach($getemp->result() as $gt){
                                        $insveh1 = ["user_id"=>$userid,"shft_veh_id"=>$shftvehid,"emp_id"=>$gt->id,"priority"=>$pri,"pickup_time"=>$gt->pickup_datetime, 'created_on'=>$curdt,'updated_on'=>$curdt,"status"=>1,"drop_time"=>$gt->drop_datetime];
                                        $this->db->insert("tb_shft_veh_emp",$insveh1);
                                        $pri++;
                                    }
                                }
                            }else{
                                $chkemp = $this->db->select("id")->get_where("tb_shft_veh_emp",array("shft_veh_id"=>$shftvehid,"emp_id"=>$detail_id,"status"=>1),1,0);

                                if($chkemp->num_rows() == 0){
                                    $insveh1 = ["user_id"=>$userid,"shft_veh_id"=>$shftvehid,"emp_id"=>$detail_id,"priority"=>3,"pickup_time"=>$order['pickup_datetime'], 'created_on'=>$curdt,'updated_on'=>$curdt,"status"=>1,"drop_time"=>$order['delivery_datetime']];
                                    $this->db->insert("tb_shft_veh_emp",$insveh1);
                                }
                            }
                        } else {
                            if($vehicle_id != ""){
                                $getVehicleNumber = $this->common->gettblrowdata(["id" => $vehicle_id], "register_number", "tb_trucks_data", 0, 0);
                                $vehicleNumber = $getVehicleNumber['register_number'] ?? "";
                                $shftvehid = $this->common->insertTableData("tb_shft_veh", ['user_id' => $userid, 'route_id' => 0, 'shft_id' => $ship_id, 'carrier_id' => $vendor_id, 'vehicle_id' => $vehicle_id, 'register_number' => $vehicleNumber, 'status' => 1]);
                                $getemp = $this->db->select("id,pickup_datetime,drop_datetime")->get_where("tb_employee",array("shift_id"=>$ship_id));

                                if($getemp->num_rows()>0){
                                    $pri = 1;
                                    foreach($getemp->result() as $gt){
                                        $insveh1 = ["user_id"=>$userid,"shft_veh_id"=>$shftvehid,"emp_id"=>$gt->id,"priority"=>$pri,"pickup_time"=>$gt->pickup_datetime, 'created_on'=>$curdt,'updated_on'=>$curdt,"status"=>1,"drop_time"=>$gt->drop_datetime];
                                        $this->db->insert("tb_shft_veh_emp",$insveh1);
                                        $pri++;
                                    }
                                }
                            }

                            if($vehicle_id != "" && $driver_id != ""){
                                $chk = $this->db->select("id,driver_id,status")->order_by("id","DESC")->get_where("tb_vehicles_drivers",array("vehicle_id"=>$vehicle_id));

                                if($chk->num_rows()>0){
                                    if($driver_id == $chk->row()->driver_id){
                                        $this->db->where(array("id"=>$chk->row()->id))->update("tb_vehicles_drivers",array("status"=>1));
                                    }else{
                                        $arr = ['vehicle_id'=>$vehicle_id, 'driver_id'=>$driver_id, 'imei'=>"", 'status'=>1, 'createdon'=>$curdt, 'updatedon'=>$curdt];
                                        $this->db->insert("tb_vehicles_drivers",$arr);
                                    }
                                }else{
                                    $arr = ['vehicle_id'=>$vehicle_id, 'driver_id'=>$driver_id, 'imei'=>"", 'status'=>1, 'createdon'=>$curdt, 'updatedon'=>$curdt];
                                    $this->db->insert("tb_vehicles_drivers",$arr);
                                }

                                $chk11 = $this->db->select("id")->get_where("tbl_assigned_drivers",array("driver_id"=>$driver_id,"vehicle_id"=>$vehicle_id),1,0);

                                if($chk11->num_rows()>0){
                                    $this->db->where(array("id"=>$chk11->row()->id))->update("tbl_assigned_drivers",array("status"=>"1",'updated_on'=>$curdt));
                                }else{
                                    $chk111 = $this->db->select("id")->get_where("tbl_assigned_drivers",array("driver_id <>"=>$driver_id,"vehicle_id"=>$vehicle_id,"status"=>1),1,0);

                                    if($chk111->num_rows() == 0){
                                        $this->db->insert("tbl_assigned_drivers",array("vehicle_id"=>$vehicle_id,"user_id"=>$userid,"driver_id"=>$driver_id,"mobile_no"=>$driver_id,"imei"=>"","from_time"=>$curdt,"to_time"=>$curdt,"status"=>"1",'created_on'=>$curdt));
                                    }else{
                                        $this->db->where(array("id"=>$chk111->row()->id))->update("tbl_assigned_drivers",array("driver_id"=>$driver_id,'updated_on'=>$curdt));
                                    }
                                }
                            }
                        }

                        /* update status */
                        $chk = $this->db->select("id")->get_where("tb_stop_status",array("shipment_id"=>$ship_id,"status_id"=>9),1,0);
                        if($chk->num_rows() == 0){
                            $curtz = $this->session->userdata("usr_tzone")['timezone'];
                            $logdate = date('Y-m-d H:i:s');

                            $getactual = getdatetimebytimezone(DFLT_TZ,$logdate,$curtz);
                            $curdt1 = $getactual['datetime'];

                            $ins = ["shipment_id"=>$ship_id,"stop_id"=>0,"order_id"=>$order_id,"stop_detail_id"=>0,"stop_type"=>"","trip_id"=>0,"status_id"=>9,"status"=>1,"status_code"=>"0100","reason"=>"Coming from E-Booking","createdon"=>$curdt1];
                            $inserted = $this->db->insert("tb_stop_status",$ins) ? $this->db->insert_id() : 0;

                            if (!$inserted) {
                                break;
                            }
                        }
                        $this->checkAutoAcceptanceForVendor($vendor_id,$ship_id,$order_id,$driver_id,$vehicle_id);
                    }
                }
            }
        }
        /* Push notification to mobile using Firebase */
        $orderIds=$bookingIds = $customerIds = $pickUpDates = $createdSource = $customerNames= $shipmentNumbers=$knTrackingNos=[];
        foreach ($orders_list as $eachRow) {
            $orderIds[]= $eachRow['order_id'];
            $bookingIds[]= $eachRow['booking_id'];
            $driverId =$eachRow['driver_id'];
        }
        $orders = $this->common->gettbldata("id IN (" . implode(",", $orderIds) . ")","customer_id,pickup_datetime,shipmentid,created_source","tb_orders",0,0);
        foreach ($orders as $eachRow) {
            $customerIds[] = $eachRow['customer_id'];
            $pickUpDates[]= $eachRow['pickup_datetime'];
            $createdSource[] = $eachRow['created_source'];
            $shipmentNumbers[] = $eachRow['shipmentid'];
        }
        if (!empty($customerIds)) {
            $customerData = $this->common->gettbldata("id IN (" . implode(",", $customerIds) . ")", "name", "tb_customers", 0, 0);
            $customerNames = array_merge($customerNames, array_column($customerData, 'name'));
        }
        if (!empty($createdSource)) {
            $referenceId = in_array(18, $createdSource) ? 'AWB' : 'DQ';
            $whereCondition = "order_id IN (" . implode(",", $orderIds) . ") AND reference_id = '" . $referenceId . "' AND status = '1'";
            $trackingData = $this->common->gettbldata($whereCondition, "ref_value", "tb_order_references", 0, 0);
            $knTrackingNos = array_merge($knTrackingNos, array_column($trackingData, 'ref_value'));
        }
        if ($driverId != "" && $driverId >0) {
            $customerName = implode(", ",array_unique( $customerNames));
            $pickUpDate = implode(
                ", ",
                array_map(function ($date) {
                    return substr($date, 0, 10);
                }, $pickUpDates)
            );
            $bookingID = implode(", ", $bookingIds);
            $tripNo = implode(", ", array_unique($shipmentNumbers));
            $knTrackingNo = implode(", ", $knTrackingNos);
            $message = "New trip is assigned" . " "
                . "Pickup Date: " . $pickUpDate . " "
                . "Customer Name: " . $customerName . " "
                . "Booking ID: " . $bookingID . " "
                . "Trip No: " . $tripNo . " "
                . "KN tracking No: " . $knTrackingNo;
            $messageData = json_encode(["msg" => $message, "info" => (object)[], "type"=>1],JSON_UNESCAPED_UNICODE);
            $this->load->library('sendfirebase');
            $fire_ret = $this->sendfirebase->sendSinglePush(["title" => "Kuehne+Nagel", "message" => $messageData, "emp_id" => $driverId, 'type' => 'Driver']);
        }
        /* END for Push notification to mobile using Firebase */
        return $inserted;
    }

    public function checkAutoAcceptanceForVendor(int $vendorId, int $shiftId, int $orderId, int $driverId, int $vehicleId): void
    {
        $date = date('Y-m-d H:i:s');
        $curtz = $this->session->userdata("usr_tzone")['timezone'];
        $getactual = getdatetimebytimezone(DFLT_TZ,$date,$curtz);
        $driverAcceptanceDate = $getactual['datetime'];
        $checkDriverAcceptence = $this->common->gettblrowdata(['id' => $vendorId, 'tms_auto_accept' => 1], "id", "tb_vendors", 0, 0);
        if (!empty($checkDriverAcceptence)) {
            $checkTrip = $this->common->gettblrowdata(['shift_id' => $shiftId], "id", "tb_trips", 0, 0);
            if (empty($checkTrip)) {
                $tripId = $this->common->insertTableData("tb_trips", [
                    'shift_id' => $shiftId,
                    'vehicle_id' => $vehicleId,
                    'driver_id' => $driverId,
                    'stime' => $date,
                    'splace' => "",
                    'eplace' => "",
                    'start_reading' => 0,
                    'end_reading' => 0,
                    'created_on' => $date,
                    'updated_on' => $date,
                    'status' => 1,
                    'trip_type' => 0,
                    'transit_status' => 0
                ]);
                $acceptId = $this->common->insertTableData("tb_stop_status", [
                    'order_id' => $orderId,
                    "shipment_id" => $shiftId,
                    "stop_id" => 0,
                    "stop_detail_id" => 0,
                    "stop_type" => "",
                    "trip_id" => $tripId,
                    "status_id" => 10,
                    "latitude" => "",
                    "longitude" => "",
                    "status" => 1,
                    "reason" => "From Admin",
                    "vehicle_id" => $vehicleId,
                    "driver_id" => $driverId,
                    "status_code" => '0212',
                    "createdon" => $driverAcceptanceDate
                ]);
                $orderQry = $this->common->gettblrowdata(['id' => $orderId], "order_id,company_code", "tb_orders", 0, 0);
                $companyCode = $orderQry['company_code'] ?? "";
                $checkStatus = "RELATED_2_" . $companyCode . "_CONSIGNEE_NOTIFICATION_STATUSES";
                if (checkAccessConditions('RELATED_2_CONSIGNEE_NOTIFICATION', $companyCode) && checkAccessConditions($checkStatus, '0212')) {
                    $this->load->library('notifytrigger');
                    $this->notifytrigger->sendNotificationToConsignee($orderId, '0212');
                }
                if (checkAccessConditions('WECHAT_COUNTRY', $this->session->userdata('company_code')))
                {
                    $this->load->library('Wechat');
                    $this->wechat->orderId = $orderQry['order_id'];
                    $this->wechat->sendNotificationsToWeChat();
                }

            }else{
                $tripId = $checkTrip['id'];
            }
            $updateOrder = $this->common->updatetbledata("tb_orders", ['trip_id' => $tripId], ['shift_id' => $shiftId]);
        }
    }

    /**
     * @param array $orderList
     * @param string $shiperIdentifier
     * @param string $consineeIdentifier
     * @param string $notifyIdentifier
     * @return array
     */
    public function checkIdentifireMatch(array $orderList, string $shiperIdentifier, string $consineeIdentifier, string $notifyIdentifier): array
    {
        $results = [];
        if (empty($orderList)) {
            return $results;
        }

        $uniqueOrders = [];
        foreach ($orderList as $order) {
            if (!in_array($order, $uniqueOrders)) {
                $uniqueOrders[] = $order;
            }
        }

        $orderList = $uniqueOrders;
        unset($uniqueOrders);
        if (empty($shiperIdentifier) && empty($consineeIdentifier) && empty($notifyIdentifier)) {
            return $orderList;
        }

        $validOrder = [];
        foreach ($orderList as $key) {

            $this->db->select(
                'tb_order_parties.id, tb_order_parties.order_id, tb_order_parties.party_id, tb_order_parties.party_type,tbl_party_types.name,tbl_party_master.code'
            );
            $this->db->from('tb_order_parties');
            $this->db->join('tbl_party_types', 'tb_order_parties.party_type = tbl_party_types.id');
            $this->db->join('tbl_party_master', 'tbl_party_master.id = tb_order_parties.party_id');
            $this->db->where(['tb_order_parties.order_id' => $key['order_id'], 'tb_order_parties.status' => 1]);
            $query = $this->db->get();

            if (!count($query->result())) {
                return [];
            }
            $shipperCode = $consigneeCode = $notifyCode = "";
            foreach ($query->result() as $row) {

                switch ($row->name) {
                    case "Customer":
                        $customerCode = $row->code;
                        break;
                    case "Shipper":
                        $shipperCode = $row->code;
                        break;
                    case "Consignee":
                        $consigneeCode = $row->code;
                        break;
                    case "NOTIFY_PARTY":
                        $notifyCode = $row->code;
                        break;
                    default:
                        log_error("Auto routing: Unable to find party.");
                        break;
                }
            }

            if ($shiperIdentifier && $consineeIdentifier && $notifyIdentifier) {
                if ($shiperIdentifier === $shipperCode && $consineeIdentifier === $consigneeCode && $notifyIdentifier === $notifyCode) {
                    $validOrder[] = [
                        'order_id' => $key['order_id'],
                        'trip' => $key['trip'] ?? 0,
                        'booking_id' => $key['booking_id'],
                        'vehicle_type' => $key['vehicle_type'],
                        'vendor_id' => $key['vendor_id'],
                        'driver_id' => $key['driver_id'],
                        'vehicle_id' => $key['vehicle_id'] ?? 0,
                        'templateId' => $key['templateId'] ?? 0
                    ];
                }
            }

            if ($shiperIdentifier && $consineeIdentifier && empty($notifyIdentifier)) {
                if ($shiperIdentifier === $shipperCode && $consineeIdentifier === $consigneeCode) {
                    $validOrder[] = [
                        'order_id' => $key['order_id'],
                        'trip' => $key['trip'] ?? 0,
                        'booking_id' => $key['booking_id'],
                        'vehicle_type' => $key['vehicle_type'],
                        'vendor_id' => $key['vendor_id'],
                        'driver_id' => $key['driver_id'],
                        'vehicle_id' => $key['vehicle_id'] ?? 0,
                        'templateId' => $key['templateId'] ?? 0
                    ];
                }
            }

            if ($shiperIdentifier && empty($consineeIdentifier) && empty($notifyIdentifier)) {
                if ($shiperIdentifier === $shipperCode) {
                    $validOrder[] = [
                        'order_id' => $key['order_id'],
                        'trip' => $key['trip'] ?? 0,
                        'booking_id' => $key['booking_id'],
                        'vehicle_type' => $key['vehicle_type'],
                        'vendor_id' => $key['vendor_id'],
                        'driver_id' => $key['driver_id'],
                        'vehicle_id' => $key['vehicle_id'] ?? 0,
                        'templateId' => $key['templateId'] ?? 0
                    ];
                }
            }

            if (empty($shiperIdentifier) && $consineeIdentifier && $notifyIdentifier) {
                if ($consineeIdentifier === $consigneeCode && $notifyIdentifier === $notifyCode) {
                    $validOrder[] = [
                        'order_id' => $key['order_id'],
                        'trip' => $key['trip'] ?? 0,
                        'booking_id' => $key['booking_id'],
                        'vehicle_type' => $key['vehicle_type'],
                        'vendor_id' => $key['vendor_id'],
                        'driver_id' => $key['driver_id'],
                        'vehicle_id' => $key['vehicle_id'] ?? 0,
                        'templateId' => $key['templateId'] ?? 0
                    ];
                }
            }

            if (empty($shiperIdentifier) && empty($consineeIdentifier) && $notifyIdentifier) {
                if ($notifyIdentifier === $notifyCode) {
                    $validOrder[] = [
                        'order_id' => $key['order_id'],
                        'trip' => $key['trip'] ?? 0,
                        'booking_id' => $key['booking_id'],
                        'vehicle_type' => $key['vehicle_type'],
                        'vendor_id' => $key['vendor_id'],
                        'driver_id' => $key['driver_id'],
                        'vehicle_id' => $key['vehicle_id'] ?? 0,
                        'templateId' => $key['templateId'] ?? 0
                    ];
                }
            }

            if (empty($shiperIdentifier) && $consineeIdentifier && empty($notifyIdentifier)) {
                if ($consineeIdentifier === $consigneeCode) {
                    $validOrder[] = [
                        'order_id' => $key['order_id'],
                        'trip' => $key['trip'] ?? 0,
                        'booking_id' => $key['booking_id'],
                        'vehicle_type' => $key['vehicle_type'],
                        'vendor_id' => $key['vendor_id'],
                        'driver_id' => $key['driver_id'],
                        'vehicle_id' => $key['vehicle_id'] ?? 0,
                        'templateId' => $key['templateId'] ?? 0
                    ];
                }
            }

            if ($shiperIdentifier && empty($consineeIdentifier) && $notifyIdentifier) {
                if ($shiperIdentifier === $shipperCode && $notifyIdentifier === $notifyCode) {
                    $validOrder[] = [
                        'order_id' => $key['order_id'],
                        'trip' => $key['trip'] ?? 0,
                        'booking_id' => $key['booking_id'],
                        'vehicle_type' => $key['vehicle_type'],
                        'vendor_id' => $key['vendor_id'],
                        'driver_id' => $key['driver_id'],
                        'vehicle_id' => $key['vehicle_id'] ?? 0,
                        'templateId' => $key['templateId'] ?? 0
                    ];
                }
            }
        }

        return $validOrder;
    }
}
