<?php
namespace App\Trip\Models;
use App\Order\Constants\OrderSources;
use App\Order\Constants\OrderStatuses;
use App\Trip\DriverTripListInterface;

class DriverTripList implements DriverTripListInterface
{
    private $db;

    public function __construct()
    {
        $ci = &get_instance();
        $this->db = $ci->db;
    }

    public function getAssignedTripData(string $reswhr, int $offset, int $limit, string $curtzEscaped, int $driverId): array
    {
        $sql = "SELECT o.id as order_id,
                            o.order_id as booking_id,
                            o.created_source,
                            IF(o.created_source = ?, o_ref.ref_value, '') as kn_tracking_no,
                            IFNULL(t.id,'') as id,
                            s.id as shift_id,
                            d.id as driver_id,
                            s.trip_type,
                            convertToClientTZ(s.startdate,?) as startdate,
                            convertToClientTZ(s.enddate,?) as enddate,
                            s.splace,
                            s.eplace,
                            s.scity,
                            s.dcity,
                            s.shipmentid,
                            s.company_code,
                            s.border_type,
                            v.id as shift_veh_id,
                            a.vehicle_id,
                            IFNULL(t.transit_status,'-1') as astatus,
                            s.shift_leg_id
                        FROM tb_shifts s
                            JOIN tb_employee e ON s.id = e.shift_id
                            JOIN tb_orders o ON o.order_id = e.order_id
                            LEFT JOIN tb_order_references o_ref ON o.id = o_ref.order_id AND o_ref.reference_id = 'XSR'
                            JOIN tb_shft_veh v ON s.id = v.shft_id AND v.status=1
                            JOIN tbl_assigned_drivers a ON v.vehicle_id = a.vehicle_id
                            JOIN tb_truck_drivers d ON d.id = a.driver_id
                            LEFT JOIN tb_trips t ON t.shift_id = s.id AND t.driver_id = d.id AND t.status=1
                        WHERE s.status = 1
                            AND e.status = 1
                            AND v.status = 1
                            AND a.status = 1
                            AND a.driver_id = ?
                            AND s.aborted = ? " . $reswhr . "
                        GROUP BY s.id, t.transit_status
                        ORDER BY s.startdate DESC, t.transit_status DESC
                        LIMIT ?, ?";
        $result = $this->db->query($sql, [OrderSources::SALOG, $curtzEscaped, $curtzEscaped, $driverId, 0, $offset, $limit]);
        return $result ? $result->result_array() : [];
    }

    public function getCompletedTripData(string $reswhr, int $offset, int $limit, string $curtzEscaped, int $driverId) : array
    {
        $sql = "SELECT o.id as order_id,
                                o.order_id as booking_id,
                                o.created_source,
                                IF(o.created_source = ?, o_ref.ref_value, '') as kn_tracking_no,
                                s.id as shift_id,
                                t.id,
                                s.trip_type,
                                convertToClientTZ(s.startdate,?) as startdate,
                                convertToClientTZ(s.enddate,?) as enddate,
                                s.splace,
                                s.eplace,
                                s.scity,
                                s.dcity,
                                s.shipmentid,
                                s.company_code,
                                s.border_type,
                                v.id as shift_veh_id,
                                t.vehicle_id,
                                '2' AS astatus,
                                s.shift_leg_id
                        FROM tb_shifts s
                            JOIN tb_employee e ON s.id = e.shift_id
                            JOIN tb_orders o ON o.order_id = e.order_id
                            LEFT JOIN tb_order_references o_ref ON o.id = o_ref.order_id AND o_ref.reference_id = 'XSR'
                            JOIN tb_shft_veh v ON s.id = v.shft_id
                            JOIN tb_trips t ON s.id = t.shift_id AND v.vehicle_id = t.vehicle_id
                        WHERE e.status = 1
                            AND s.status = 0
                            AND t.status = 0
                            AND t.driver_id = ?
                            " . $reswhr . "
                        GROUP BY s.id, t.transit_status
                        ORDER BY s.startdate DESC, t.transit_status DESC
                        LIMIT ?, ?";
        $result = $this->db->query($sql, [OrderSources::SALOG, $curtzEscaped, $curtzEscaped, $driverId, $offset, $limit]);
        return $result ? $result->result_array() : [];
    }

    /**
     * @inheritDoc
     * $status 'true' for completed shipments
     */
    public function getSearches(string $search, int $uid, bool $status): string
    {
        $searches = [];
        if ($search != "") {
            $paramsRefs = [$uid, OrderStatuses::ACTIVE, 1, (int)$status, "%" . $search . "%", "%" . $search . "%", "%" . $search . "%"];
            $queryRefs = $this->db->query("
                                    SELECT o.shift_id
                                    FROM tb_orders o
                                    JOIN tb_shifts s ON s.id=o.shift_id
                                    JOIN tb_order_references r ON o.id=r.order_id
                                    WHERE o.user_id = ?
                                        AND o.status= ?
                                        AND r.status = ?
                                        AND o.trip_sts = ?
                                        AND (r.ref_value LIKE ? OR o.order_id LIKE ? or s.shipmentid LIKE ?)
                                    GROUP BY o.shift_id", $paramsRefs);
            $resultRefs = !$queryRefs ? [] : $queryRefs->result_array();
            $searches = array_map('current', $resultRefs);
        }
        $where = "";
        if (!empty($searches)) {
            $where = " AND s.id IN(" . implode(',', $searches) . ") ";
        }
        return $where;
    }

    public function getLiveTripData(string $reswhr, int $offset, int $limit, string $curtzEscaped, int $driverId): array
    {
        $sql = "SELECT  s.id AS shift_id,
                        o.id AS order_id,
                        o.order_id AS booking_id,
                        o.delivery_datetime,
                        t.id,s.shipmentid,
                        convertToClientTZ(s.startdate,?) AS startdate,
                        convertToClientTZ(s.enddate,?) AS enddate,
                        s.trip_type,
                        s.splace,
                        s.eplace,
                        s.scity,
                        s.dcity,
                        s.company_code,
                        s.border_type
                    FROM tb_shifts s
                    JOIN tb_orders o ON o.shift_id = s.id
                    JOIN tb_shft_veh v ON s.id = v.shft_id
                    JOIN tb_employee e ON s.id = e.shift_id
                    JOIN tb_trips t ON s.id = t.shift_id AND v.vehicle_id = t.vehicle_id
                    LEFT JOIN tb_stop_status ts ON (ts.shipment_id = s.id AND ts.status_id=? AND ts.trip_id=o.trip_id AND ts.status=?)
                    WHERE  e.status = 1
                    AND s.status = 1
                    AND t.status = 1
                    AND t.driver_id = ?
                    AND s.aborted = ? " . $reswhr . "
                    GROUP BY s.id, t.transit_status
                    ORDER BY ts.createdon DESC
                    LIMIT ?, ?";
        $result = $this->db->query($sql, [$curtzEscaped, $curtzEscaped, 10, 1, $driverId, 0, $offset, $limit]);
        return $result ? $result->result_array() : [];
    }

    public function getShipmentsCount(int $driverId, string $status): int
    {
        switch ($status) {
            case "Active":
                $where = "s.status =1  AND o.trip_id != 0 AND o.trip_sts=0 ";
                $whereTripJoin = 'JOIN tb_trips t ON s.id = t.shift_id AND v.vehicle_id = t.vehicle_id';
                $orderByQry = ", t.transit_status DESC";
                $groupbyQry = ", t.transit_status";
                break;
            case "Completed":
                $where = "s.status = 0 AND t.status = 0";
                $whereTripJoin = 'JOIN tb_trips t ON s.id = t.shift_id AND v.vehicle_id = t.vehicle_id';
                $orderByQry = ", t.transit_status DESC";
                $groupbyQry = ", t.transit_status";
                break;

            default:
                $where = "s.status =1  AND o.trip_id = 0 AND o.trip_sts=0 ";
                $whereTripJoin = '';
                $orderByQry = "";
                $groupbyQry = "";
                break;
        }
        $sql = "SELECT count(s.id) as shipmentcount
                        FROM tb_shifts s
                            JOIN tb_orders o ON o.shift_id = s.id
                            LEFT JOIN tb_order_references o_ref ON o.id = o_ref.order_id AND o_ref.reference_id = 'XSR'
                            JOIN tb_shft_veh v ON s.id = v.shft_id AND v.status=1
                            JOIN tbl_assigned_drivers a ON v.vehicle_id = a.vehicle_id
                            JOIN tb_truck_drivers d ON d.id = a.driver_id
                            $whereTripJoin
                        WHERE " . $where . "
                            AND v.status = 1
                            AND a.status = 1
                            AND a.driver_id = ?
                            AND s.aborted = ?
                        GROUP BY s.id $groupbyQry
                        ORDER BY s.startdate DESC $orderByQry";
        $result = $this->db->query($sql, [$driverId, 0]);
        return $result ? $result->num_rows() : 0;
    }

    public function getShipmentsList(int $offset, int $driverId, int $userId, string $curtzEscaped, int $type, int $limit): array
    {
        switch ($type) {
            case 1:
                $where = "s.status =1  AND o.trip_id != 0 AND o.trip_sts=0 ";
                $whereTripJoin = 'JOIN tb_trips t ON s.id = t.shift_id AND v.vehicle_id = t.vehicle_id';
                $selector = ", IFNULL(t.id,'') as id,IFNULL(t.transit_status,'-1') as astatus";
                $orderByQry = ", t.transit_status DESC";
                $groupbyQry = ", t.transit_status";
                break;
            case 2:
                $where = "s.status = 0 AND t.status = 0";
                $whereTripJoin = 'JOIN tb_trips t ON s.id = t.shift_id AND v.vehicle_id = t.vehicle_id';
                $selector = ", IFNULL(t.id,'') as id,IFNULL(t.transit_status,'-1') as astatus";
                $orderByQry = ", t.transit_status DESC";
                $groupbyQry = ", t.transit_status";
                break;

            default:
                $where = "s.status =1  AND o.trip_id = 0 AND o.trip_sts=0 ";
                $whereTripJoin = '';
                $selector = "";
                $orderByQry = "";
                $groupbyQry = "";
                break;
        }
        $sql = "SELECT o.id as order_id,
                            o.order_id as booking_id,
                            o.delivery_datetime,
                            vendor.code as carrier_cid,
                            s.id as shift_id,
                            d.id as driver_id,
                            s.trip_type,
                            convertToClientTZ(s.startdate,?) as startdate,
                            convertToClientTZ(s.enddate,?) as enddate,
                            s.splace,
                            s.eplace,
                            s.scity,
                            s.dcity,
                            s.shipmentid,
                            s.company_code,
                            s.border_type,
                            v.id as shift_veh_id,
                            a.vehicle_id,
                            td.truck_number,
                            s.shift_leg_id
                            $selector
                        FROM tb_shifts s
                            JOIN tb_orders o ON o.shift_id = s.id
                            JOIN tb_vendors vendor ON vendor.id = o.vendor_id
                            LEFT JOIN tb_order_references o_ref ON o.id = o_ref.order_id AND o_ref.reference_id = 'XSR'
                            JOIN tb_shft_veh v ON s.id = v.shft_id AND v.status=1
                            JOIN tbl_assigned_drivers a ON v.vehicle_id = a.vehicle_id
                            JOIN tb_trucks_data td ON a.vehicle_id = td.id
                            JOIN tb_truck_drivers d ON d.id = a.driver_id
                            $whereTripJoin
                        WHERE " . $where . "
                            AND v.status = 1
                            AND a.status = 1
                            AND a.driver_id = ?
                            AND s.aborted = ?
                        GROUP BY s.id $groupbyQry
                        ORDER BY s.startdate DESC $orderByQry
                        LIMIT ?, ?";
        $result = $this->db->query($sql, [$curtzEscaped, $curtzEscaped, $driverId, 0, $offset, $limit]);
        return $result ? $result->result_array() : [];
    }
}
