<?php

namespace App\Trip\Services;

use App\Trip\Models\CancelTrip;

class TripService
{
    /**
     * only trip related to given user can be canceled
     *
     * @param int $shiftId
     * @param int $userId
     * @return bool
     */
    public static function cancel(int $shiftId, int $userId) : bool
    {
        if (!$userId || !$shiftId) {
            return false;
        }

        return (new CancelTrip($shiftId, $userId))->cancel();
    }
}
