<?php
defined('BASEPATH') or exit('No direct script access allowed');

/*
| -------------------------------------------------------------------------
| URI ROUTING
| -------------------------------------------------------------------------
| This file lets you re-map URI requests to specific controller functions.
|
| Typically there is a one-to-one relationship between a URL string
| and its corresponding controller class/method. The segments in a
| URL normally follow this pattern:
|
|    example.com/class/method/id/
|
| In some instances, however, you may want to remap this relationship
| so that a different class/function is called than the one
| corresponding to the URL.
|
| Please see the user guide for complete details:
|
|    https://codeigniter.com/user_guide/general/routing.html
|
| -------------------------------------------------------------------------
| RESERVED ROUTES
| -------------------------------------------------------------------------
|
| There are three reserved routes:
|
|    $route['default_controller'] = 'welcome';
|
| This route indicates which controller class should be loaded if the
| URI contains no data. In the above example, the "welcome" class
| would be loaded.
|
|    $route['404_override'] = 'errors/page_missing';
|
| This route will tell the Router which controller/method to use if those
| provided in the URL cannot be matched to a valid route.
|
|    $route['translate_uri_dashes'] = FALSE;
|
| This is not exactly a route, but allows you to automatically route
| controller and method names that contain dashes. '-' isn't a valid
| class or method name character, so it requires translation.
| When you set this option to TRUE, it will replace ALL dashes in the
| controller and method URI segments.
|
| Examples:    my-controller/index    -> my_controller/index
|        my-controller/my-method    -> my_controller/my_method
 */
$route['default_controller'] = 'login';
$route['admin/(:num)'] = "admin/index/$1";
$route['employee/(:num)'] = 'employee/index/$1';
$route['schedules/(:num)'] = 'schedules/index/$1';
$route['profile/(:num)'] = 'profile/index/$1';
$route['vehicles/(:num)'] = 'vehicles/index/$1';
$route['knmcdbkg/(:any)'] = 'knmcdbkg/index/$1';
$route['fleetmgnt'] = 'vendor/add';
$route['commmgnt'] = 'notifymgmt/index';
$route['partymgnt'] = 'customers/index';
$route['generalmgnt'] = 'statuscode/index';
$route['rtetnmaster'] = 'vendor/add';
$route['404_override'] = '';
$route['translate_uri_dashes'] = false;
$route['eTNOPSREP'] = 'reporttruckvolume/index';
$route['eTNAQUOPSREP'] = 'aquaticareport/index';
$route['delhiveryedi/(:num)'] = 'delhiveryedi/index/$1';

$route['driverapp/(:any)'] = 'Driverapp/index/$1';
$route['driverhome'] = 'Driverapp/home';
$route['driverlogin'] = 'Driverapp/login';
$route['driverdriverapp'] = 'Driverapp/login';
$route['drivershipment_home'] = 'Driverapp/shipment_home';
$route['drivershipment_list'] = 'Driverapp/shipment_list';
$route['drivershipment_list_search'] = 'Driverapp/shipment_list_search';
$route['driverorders'] = 'Driverapp/orders';
$route['driverprofile'] = 'Driverapp/profile';
$route['drivershipment_completed'] = 'Driverapp/shipment_completed';
$route['drivershipment_completed_search'] = 'Driverapp/shipment_completed_search';
$route['driverchange_password'] = 'Driverapp/change_password';
$route['drivercollections'] = 'Driverapp/collections';
$route['drivercomming_soon'] = 'Driverapp/comming_soon';
$route['drivershipment_details'] = 'Driverapp/shipment_details';
$route['drivershipment_details/(:num)/(:num)/(:num)/(:num)'] = 'Driverapp/shipment_details/$1/$2/$3/$4';
$route['drivershipment_details/(:num)/(:num)/(:num)/(:num)/(:num)'] = 'Driverapp/shipment_details/$1/$2/$3/$4/$5';
$route['drivershipment_details/(:num)/(:num)/(:num)'] = 'Driverapp/shipment_details/$1/$2/$3';
$route['driverstatus_view'] = 'Driverapp/status_view';
$route['driverstatus_view/(:num)/(:num)/(:num)/(:num)'] = 'Driverapp/status_view/$1/$2/$3/$4';
$route['driverlogout'] = 'Driverapp/logout';
$route['driverauth'] = 'Driverapp/auth';
$route['driverpod'] = 'Driverapp/pod_pop';
$route['driverpop'] = 'Driverapp/pod_pop';
$route['drivershipment_details_access/(:num)/(:num)/(:num)/(:num)'] = 'Driverapp/shipment_details_access/$1/$2/$3/$4';
$route['driverget_secure_link'] = 'Driverapp/get_secure_link';
$route['driversite_language'] = 'Driverapp/change_site_language';
$route['drivercall_details'] = 'Driverapp/call_screen';
$route['driversentmail'] = 'Driverapp/sentmail';
$route['driversentsms'] = 'Driverapp/sentsms';
$route['driversign_pad'] = 'Driverapp/sign_pad';
$route['driverscan_and_load'] = 'Driverapp/scan_and_load';
$route['driverscan_and_load_multiple'] = 'Driverapp/scan_and_load_multiple';
$route['driverdeviation_ungroup'] = 'Driverapp/deviation_ungroup';
$route['driverdeviation_group'] = 'Driverapp/deviation_group';
$route['driverget_deviation_list'] = 'Driverapp/get_deviation_list';
$route['driverdanger_goods_description'] = 'Driverapp/danger_goods_description';

$route['drivergetdatepickert'] = 'Driverapp/getdatepickert';
$route['driversetshipstopstatus_multiple'] = 'Driverapp/setshipstopstatus_multiple';

$route['driverappv2/(:any)'] = 'Driverappv2/index/$1';
$route['drivershipment_details_accessv2/(:num)/(:num)/(:num)/(:num)'] = 'Driverappv2/shipment_details_access/$1/$2/$3/$4';

$route['xdocapphome'] = 'Xdocapp/home';
$route['xdocapplogin'] = 'Xdocapp/login';
$route['xdocappshipment_home'] = 'Xdocapp/shipment_home';
$route['xdocappshipment_list'] = 'Xdocapp/shipment_list';
$route['xdocappshipment_list_search'] = 'Xdocapp/shipment_list_search';
$route['xdocapporders'] = 'Xdocapp/orders';
$route['xdocappprofile'] = 'Xdocapp/profile';
$route['xdocappshipment_completed'] = 'Xdocapp/shipment_completed';
$route['xdocappshipment_completed_search'] = 'Xdocapp/shipment_completed_search';
$route['xdocappchange_password'] = 'Xdocapp/change_password';
$route['xdocappcollections'] = 'Xdocapp/collections';
$route['xdocappcomming_soon'] = 'Xdocapp/comming_soon';
$route['xdocappshipment_details'] = 'Xdocapp/shipment_details';
$route['xdocappshipment_details/(:num)/(:num)/(:num)/(:num)'] = 'Xdocapp/shipment_details/$1/$2/$3/$4';
$route['xdocappshipment_details/(:num)/(:num)/(:num)/(:num)/(:num)'] = 'Xdocapp/shipment_details/$1/$2/$3/$4/$5';
$route['xdocappshipment_details/(:num)/(:num)/(:num)'] = 'Xdocapp/shipment_details/$1/$2/$3';
$route['xdocappstatus_view'] = 'Xdocapp/status_view';
$route['xdocappstatus_view/(:num)/(:num)/(:num)/(:num)'] = 'Xdocapp/status_view/$1/$2/$3/$4';
$route['xdocapplogout'] = 'Xdocapp/logout';
$route['xdocappauth'] = 'Xdocapp/auth';
$route['xdocapppod'] = 'Xdocapp/pod_pop';
$route['xdocapppop'] = 'Xdocapp/pod_pop';
$route['xdocappshipment_details_access/(:num)/(:num)/(:num)/(:num)'] = 'Xdocapp/shipment_details_access/$1/$2/$3/$4';
$route['xdocappget_secure_link'] = 'Xdocapp/get_secure_link';
$route['xdocappsite_language'] = 'Xdocapp/change_site_language';
$route['xdocappcall_details'] = 'Xdocapp/call_screen';
$route['xdocappsentmail'] = 'Xdocapp/sentmail';
$route['xdocappsentsms'] = 'Xdocapp/sentsms';
$route['xdocappsign_pad'] = 'Xdocapp/sign_pad';
$route['xdocappscan_and_load'] = 'Xdocapp/scan_and_load';
$route['xdocappscan_and_load_multiple'] = 'Xdocapp/scan_and_load_multiple';
$route['xdocappdeviation_ungroup'] = 'Xdocapp/deviation_ungroup';
$route['xdocappdeviation_group'] = 'Xdocapp/deviation_group';
$route['xdocappget_deviation_list'] = 'Xdocapp/get_deviation_list';
$route['xdocappscan_items'] = 'Xdocapp/scan_and_load_using_reader';
$route['xdocappbarcode_reader'] = 'Xdocapp/barcode_reader';
$route['xdocappscan_and_load_items_list'] = 'Xdocapp/scan_and_load_items_list';

//-- this route must be at last position

// $route['(:any)'] = 'Driverapp/index/$1';

// france
/** driver app v2 */
$route['driverdanger_goods_description'] = 'Driverappv2/danger_goods_description';
$route['drivergetdatepickert'] = 'Driverappv2/getdatepickert';
$route['driversetshipstopstatus_multiple'] = 'Driverappv2/setshipstopstatus_multiple';
$route['driverappv2/(:any)'] = 'Driverappv2/index/$1';
$route['drivershipment_details_accessv2/(:num)/(:num)/(:num)/(:num)'] = 'Driverappv2/shipment_details_access/$1/$2/$3/$4';
$route['driversite_language2'] = 'Driverappv2/change_site_language';
/** driver app v2 End  */

/** driver app v3 */
$route['driverdanger_goods_description'] = 'Driverappv3/danger_goods_description';
$route['drivergetdatepickert'] = 'Driverappv3/getdatepickert';
$route['driversetshipstopstatus_multiple'] = 'Driverappv3/setshipstopstatus_multiple';
$route['driverappv3/(:any)'] = 'Driverappv3/index/$1';
$route['drivershipment_details_accessv3/(:num)/(:num)/(:num)/(:num)'] = 'Driverappv3/shipment_details_access/$1/$2/$3/$4';
$route['driversite_language2'] = 'Driverappv3/change_site_language';
/** driver app v3 End */

$route['shurl/(:any)'] = 'Short_url/redirect_url/$1';

$route['knmcdbkg/(:any)'] = 'CarrierMode/verify_jwt/$1';

$route['KNGENQikBkg'] = 'NZGENorders';
$route['KNGENQikBkg/orderglobalsearch'] = 'NZGENorders/orderglobalsearch';
$route['KNGENQikBkg/(:any)'] = 'NZGENorders/index/$1';
$route['KNGENQikBkg/index/(:any)'] = 'NZGENorders/index/$1';
$route['api/trip']['POST'] = 'api/trip/outbound';
$route['api/status-execution'] = 'api/StatusExecution';
$route['api/document-upload'] = 'api/DocumentUpload';

$route['Driverapiv5/shipmentstopdetails'] = Driverapiv5shipmentstopdetails::class . '/shipmentstopdetails';

$route['mobile/v1/trips'] = MobileV1Trips::class . "/index";
$route['mobile/v1/import'] = MobileV1Import::class . "/import";
$route['mobile/v1/trip'] = MobileV1Trip::class . "/index";
$route['mobile/v1/doc'] = MobileV1Doc::class . "/doc";
$route['mobile/v1/doc/delete'] = MobileV1Doc::class . "/delete";
$route['mobile/v1/trip/stops/rank']['post'] = MobileV1TripStops::class . "/rank";

$route['driverapiv3/getshipmentstops'] = Driverapiv3getshipmentstops::class . '/getshipmentstops';
$route['Driverapiv5/getshipmentstops'] = Driverapiv5getshipmentstops::class . '/getshipmentstops';

//Action routes
$route['mobile/v1/action/create'] = MobileV1Action::class . "/create";
$route['mobile/v1/action/update'] = MobileV1Action::class . "/update";
$route['kpireport/(:any)'] = 'kpireport/index/$1';
$route['Transitstatusreport/(:any)'] = 'Transitstatusreport/index/$1';
$route['kpireportoneday/(:any)'] = 'kpireportoneday/index/$1';

$route['shipment'] = 'wechat/shipment/index';
$route['shipment/getShipmentStatus']['GET'] = 'wechat/shipment/getShipmentStatus';
$route['shipment/sendShipment']['POST'] = 'wechat/shipment/sendShipment';

$route['OrderDocumentINB']['POST'] = 'apis/Standardapis/orderDocument';
$route['OrderStatusINB']['POST'] = 'apis/Standardapis/orderStatus';

$route['delhivery_status']['POST'] = 'DelhiveryIndiaEDI/delhiveryStatusWebhook';
$route['delhivery_epod']['POST'] = 'DelhiveryIndiaEDI/delhiveryEPODWebhook';
$route['shipment/getShipmentStatusbytrackingNumber']['GET'] = 'wechat/shipment/getShipmentStatusbytrackingNumber';
$route['delhivery_etn_eta']['POST'] = 'DelhiveryIndiaEDI/delhiveryETNETA';

$route['KNRLGEXTRSH']['POST'] = 'Extrshorders/index';
$route['apidocuments/index.html'] = 'apis/Apidocuments/index';

$route['BufaOccReport']['GET'] = 'CNKNReports/index';
$route['BufaOccReport']['POST'] = 'CNKNReports/ajaxListing';

$route['api/schTO']['POST'] = 'Schaefflerorders/index';

$route['TipCappaReport']['GET'] = 'TipCappaReport/index';
$route['TipCappaReport']['POST'] = 'TipCappaReport/ajaxListing';
$route['BUFAECNReport']['GET'] = 'BUFAECNReport/index';
$route['BUFAECNReport']['POST'] = 'BUFAECNReport/ajaxListing';

