<?php

if (!defined('BASEPATH')) {
    exit('No direct script access allowed');
}

require_once APPPATH . "/third_party/PHPExcel.php";

use App\PodUploads\Builders\CompletedOrderEPodBuilder;
use App\Generators\RandomString;
use App\Integrations\Salog\ePod\AbstractXMLData;
use App\Integrations\Salog\ePod\IntegrationService;
use App\Order\Constants\OrderSources;
use App\PodUploads\Constants\DocumentType;
use App\ApiRequest\SendDocumentGateOut;
use phpseclib\Net\SFTP;

class Admin extends CI_Controller
{
    private const  KNLOGIN_EPOD_PATH = "/pub/inbound/D3/FO";
    private const  SALOG_ORDER_SOURCE = 5;
    private const  SHIPPEO_ORDER_SOURCE = 8;
    private const  ETNQUOTE_ORDER_SOURCE = 9;
    private const  KNLOGIN_ORDER_SOURCE = 11;
    private const  MACADAM_ORDER_SOURCE = 12;
    private const  AMAZON_ORDER_SOURCE = 13;
    private const  ROADLOG_ORDER_SOURCE = 18;
    private const  ROADLOG_POD_DOCTYPE = '545';
    public function __construct()
    {
        parent::__construct();
        if($this->session->userdata('user_id')=='')
        {
            redirect('login');
        }
        $this->load->model(['common','Completedordersmodel','orderrevenuesmodel','Order_details','Roadlogtosalogmodel','MassStatusModel','DeliveryDocumentModel', 'OtmBookingModel']);
        $this->load->helper(["log_helper","thirdparty_helper"]);
        $this->load->library([
            'statusintigration',
            'svkonektquote',
            'shippeostatusintigration',
            'macdamstatusintigration',
            'knlogin',
            'Exchangerate',
            'carriercommonedilib',
            'commonpodedi',
            'OpenboxStatusAccept',
            'Openbox_status_execution',
            'salogintegrateservice',
            'DocumentSequenceLibrary',
            'tollcarrieredi',
            'StatusRemappingService',
            'Roadlogsalogdocument',
            'Standard_document_execution',
            'Standard_status_execution',
            'Altovaordercreation',
            'sendpodtoknservice',
            'carrierstandardtripoutbound',
            'InspectPdfLibrary'
        ]);
    }

    public function index(){
        $this->activeorders();
    }

    public function activeorders(){
        if (!checkUrlAccessForUser('ADMIN-ACTIVEORDERS')) {
            redirect("Forbiddenaccess");
        }
        $data['page_title']=$this->lang->line('menu_active');
        $data['sub_title']=$this->lang->line('active_bookings');
        $data['ord_type'] = "";
        $data['orders'] = array();
        $inp = 0;
        $btype = $this->session->userdata('business_type');
        $branch_user = $data["branch_user"] = isset($_POST["branch_user"]) ? $this->db->escape_str($_POST["branch_user"]) : "-1";
        if(!in_array($btype, ['Country Admin'])){
            $cid = "(".$this->session->userdata("user_id").")";
        }else{
            $admids = $this->session->userdata('country_user_ids');
            if($branch_user != "-1"){
                $cid   = "($branch_user)";
            }else if(count($admids)>0){
                $users  = implode(",", $admids);
                $cid   = "($users)";
            }else{
                $cid   = "(-1)";
            }
        }
        $company_code = $this->session->userdata("company_code");
        $curtz = $this->session->userdata("usr_tzone")['timezone'];
        $input = $this->input->post();
        $whr = "";
        if(!empty($input)){
            if(!empty($input['bookingid'])){
                $input_bookingid = $this->db->escape_str($input['bookingid']);
                $bookids = implode("','", $input_bookingid);
                $inp = 1;
                $whr .= " AND o.order_id IN('".$bookids."')";
            }
            if(isset($input['pickup']) && !empty($input['pickup'])){
                $inp = 1;
                $input_pickup = $this->db->escape_str($input['pickup']);
                $whr .= " AND (o.pickup_country LIKE '%".$input_pickup."%' OR o.pickup_city LIKE '%".$input_pickup."%') ";
            }
            if(isset($input['drop']) && !empty($input['drop'])){
                $inp = 1;
                $input_drop = $this->db->escape_str($input['drop']);
                $whr .= " AND (o.delivery_country LIKE '%".$input_drop."%' OR o.delivery_city LIKE '%".$input_drop."%') ";
            }
            if(isset($input['fromdate_search'])){
                if($input['fromdate_search'] != ""){
                    $input_fromdate_search = $this->db->escape_str($input['fromdate_search']);
                    $getactual = getdatetimebytimezone(DFLT_TZ, $input_fromdate_search, $curtz);
                    $input['fromdate_search'] = $getactual['date'];
                    $inp = 1;
                    $whr .= " AND DATE(o.pickup_datetime)>='".$input['fromdate_search']."' ";
                }
            }

            if(isset($input['todate_search'])){
                if($input['todate_search'] != ""){
                    $input_todate_search = $this->db->escape_str($input['todate_search']);
                    $getactual = getdatetimebytimezone(DFLT_TZ, $input_todate_search, $curtz);
                    $input['todate_search'] = $getactual['date'];
                    $inp = 1;
                    $whr .= " AND DATE(o.delivery_datetime)<='".$input['todate_search']."' ";
                }
            }
            $getords = array();
            if(!empty($input['reference'])){
                $inp = 1;
                $input_reference = $this->db->escape_str($input['reference']);
                $reference = implode("','", $input_reference);
                $getords = $this->getActiveOrdersbyRef($reference);
            }


            if(!empty($input['order_type'])){
                $inp = 1;
                $input_order_type = $this->db->escape_str($input['order_type']);
                $ordtye = implode("','", $input_order_type);
                $getords1 = $this->getActiveOrdersbyRefOT("OT",$ordtye);
                if(!empty($getords1)){
                    $getords = array_merge($getords,$getords1);
                }else{
                    $getords2 = $this->getActiveOrdersdetailsType($ordtye);
                    if(!empty($getords2)){
                        $getords = array_merge($getords,$getords2);
                    }
                }
            }


            if(!empty($getords)){
                $gords = implode("','",$getords);
                $whr .= " AND o.id IN('$gords') ";
            }
        }
        if($inp == 1 && $whr == ""){
            $whr .= " AND o.id IN(0) ";
        }
        $pwhr = "o.user_id IN $cid AND ";
        $permission = checkuserpermissions();
        if(in_array("orders", $permission)){
            $company_code = $this->session->userdata('company_code');
            $pwhr = "o.company_code LIKE '".$company_code."' AND ";
        }else{
            $pwhr = "o.user_id IN $cid AND ";
        }
        $mainqry = "SELECT o.id FROM tb_orders o WHERE ".$pwhr." (o.trip_id!=0 OR (o.trip_id=0 AND (SELECT COUNT(trip_id) FROM tb_employee WHERE order_id=o.order_id)>0)) AND o.status NOT IN (0,3) AND o.trip_sts=0 $whr GROUP BY o.order_id ORDER BY o.pickup_datetime DESC";
        $custord1 = $this->db->query($mainqry);
        $pgcnt = $custord1->num_rows();
        $config = array();
        $config["base_url"] = base_url() . "admin/activeorders";
        $config["total_rows"] = $pgcnt;
        $config["per_page"] = 5;
        $config["uri_segment"] = 3;
        $config['display_pages'] = TRUE;
        $this->pagination->initialize($config);
        $page = ($this->uri->segment(3)) ? (int)$this->uri->segment(3) : 0;

        $mainqry = "SELECT o.id,o.order_id,o.pickup_datetime,o.delivery_datetime,o.pickup_country,o.delivery_country,o.pickup_city,o.delivery_city,o.plat,o.plng FROM tb_orders o WHERE  ".$pwhr." (o.trip_id!=0 OR (o.trip_id=0 AND (SELECT COUNT(trip_id) FROM tb_employee WHERE order_id=o.order_id)>0)) AND o.status NOT IN (0,3) AND o.trip_sts=0 $whr GROUP BY o.order_id ORDER BY o.pickup_datetime DESC";
        $qry = $mainqry . ' LIMIT ?,?';
        $custord = $this->db->query($qry,[$page,$config["per_page"]]);
        if($custord->num_rows()>0){
            $data['orders'] = $custord->result_array();
        }
        $this->newtemplate->dashboard('admin/activeorders',$data);
    }

    function getActiveOrdersbyRef($refid){
        $res = array();
        $cid = $this->session->userdata("user_id");
        if(!empty($refid)){
           
            $whusr = "o.user_id=$cid ";
            $admids = $this->session->userdata('country_user_ids');
            if(isset($admids) && sizeof($admids)>0){
                $users = implode(",", $admids);
                $whusr = "o.user_id IN ($users) ";
            }
            $whusr .= " AND o.trip_id != 0 AND o.trip_sts=0 AND r.ref_value IN('".$refid."') AND r.status=1";
            $qry = $this->orderrevenuesmodel->getordersbyref($whusr);
           
            if($qry->num_rows()>0){
                foreach ($qry->result() as $res1) {
                    $res[] = $res1->order_id;
                }
            }
        }
        return $res;
    }

    function getActiveOrdersbyRefOT($refnum,$refval){
        $res = array();
        $cid = $this->session->userdata("user_id");
        if(!empty($refval)){
           
            $whusr = " o.user_id=$cid ";
            $admids = $this->session->userdata('country_user_ids');
            if(isset($admids) && sizeof($admids)>0){
                $users = implode(",", $admids);
                $whusr = " o.user_id IN ($users) ";
            }
            $whusr .= " AND o.trip_id != 0 AND o.trip_sts=0 AND r.reference_id='".$refnum."' AND r.ref_value IN('".$refval."') AND r.status=1";
            $qry = $this->orderrevenuesmodel->getordersbyref($whusr);
            
            if($qry->num_rows()>0){
                foreach ($qry->result() as $res1) {
                    $res[] = $res1->order_id;
                }
            }
        }
        return $res;
    }
    public function getActiveOrdersdetailsType($otype){
        $res = array();
        $cid = $this->session->userdata("user_id");
        $company_code = $this->session->userdata("company_code");
        if(!empty($otype)){
            $ordertype_id = 0;
            $getordertype_id = $this->db->select('id')->get_where("tb_order_types",array('ordtype_code'=>$otype,'company_code'=>$company_code,'status'=>'1'));
            if($getordertype_id->num_rows()>0){
                $ordertype_id = $getordertype_id->row()->id;
            }else{
                $getordertype = $this->db->select('id')->get_where("tb_order_types",array('ordtype_code'=>$otype,'company_code'=>'SGKN','status'=>'1'));
                if($getordertype->num_rows()>0){
                    $ordertype_id = $getordertype->row()->id;
                }
            }
            if($ordertype_id != 0){
                
                $whusr = " o.user_id=$cid ";
                $admids = $this->session->userdata('country_user_ids');
                if(isset($admids) && sizeof($admids)>0){
                    $users = implode(",", $admids);
                    $whusr = " o.user_id IN ($users) ";
                }
                $whusr .= " AND d.order_type='".$ordertype_id."' ";
                $orderQuery = $this->orderrevenuesmodel->getordersbyOrdertypes($whusr);
                
                if($orderQuery<>"" && $orderQuery->num_rows()>0){
                    foreach ($orderQuery->result() as $res1) {
                        $res[] = $res1->id;
                    }
                }
            }

        }

        return $res;
    }
    function getPendingOrdersbyRef($refid){
        $res = array();
        $cid = $this->session->userdata("user_id");
        $whr = '';
        if($this->session->userdata('company_code') == 'NZKN'){
            $whr .= ' AND (o.order_status != "READY" OR o.order_status IS NULL)';
        }
        
        $whusr = " o.user_id=$cid ";
        $admids = $this->session->userdata('country_user_ids');
        if(isset($admids) && sizeof($admids)>0){
            $users = implode(",", $admids);
            $whusr = " o.user_id IN ($users) ";
        }
        $whusr .= " AND o.trip_id=0 AND r.ref_value IN('".$refid."') AND r.status=1 ".$whr;

        if(!empty($refid)){
            $qry = $this->orderrevenuesmodel->getordersbyref($whusr);
            
            if($qry->num_rows()>0){
                foreach($qry->result() as $res1) {
                    $res[] = $res1->order_id;
                }
            }
        }
        return $res;
    }
    function getPendingOrdersbyRefOT($refnum,$refval){
        $res = array();
        $cid = $this->session->userdata("user_id");
        $whr = '';
        if($this->session->userdata('company_code') == 'NZKN'){
            $whr .= ' AND (o.order_status != "READY" OR o.order_status IS NULL) ';
        }
        
        $whusr = " o.user_id=$cid ";
        $admids = $this->session->userdata('country_user_ids');
        if(isset($admids) && sizeof($admids)>0){
            $users = implode(",", $admids);
            $whusr = " o.user_id IN ($users) ";
        }
        $whusr .= " AND o.trip_id=0 AND o.trip_sts=0 AND r.reference_id='".$refnum."' AND r.ref_value IN('".$refval."') AND r.status=1 ".$whr;
        if(!empty($refval)){
            $qry = $this->orderrevenuesmodel->getordersbyref($whusr);
            
            if($qry->num_rows()>0){
                foreach($qry->result() as $res1) {
                    $res[] = $res1->order_id;
                }
            }
        }
        return $res;
    }

    function getReadyOrdersbyRef($refid){
        $res = array();
        $cid = $this->session->userdata("user_id");
        if(!empty($refid)){
           
            $whusr = " o.user_id=$cid ";
            $admids = $this->session->userdata('country_user_ids');
            if(isset($admids) && sizeof($admids)>0){
                $users = implode(",", $admids);
                $whusr = " o.user_id IN ($users) ";
            }
            $whusr .= " AND o.trip_id=0 AND r.ref_value IN('".$refid."') AND r.status=1 AND o.order_status ='READY' ";
            $qry = $this->orderrevenuesmodel->getordersbyref($whusr);
            
            if($qry->num_rows()>0){
                foreach($qry->result() as $res1) {
                    $res[] = $res1->order_id;
                }
            }
        }
     return $res;
 }

 function getReadyOrdersbyRefOT($refnum,$refval){
    $res = array();
    $cid = $this->session->userdata("user_id");
    if(!empty($refval)){
       
        $whusr = " o.user_id=$cid ";
        $admids = $this->session->userdata('country_user_ids');
        if(isset($admids) && sizeof($admids)>0){
            $users = implode(",", $admids);
            $whusr = " o.user_id IN ($users) ";
        }
        $whusr .= " AND o.trip_id=0 AND o.trip_sts=0 AND r.reference_id='".$refnum."' AND r.ref_value IN('".$refval."') AND r.status=1 AND (o.order_status ='READY' OR o.order_status IS NULL) ";
        $qry = $this->orderrevenuesmodel->getordersbyref($whusr);
        
        if($qry->num_rows()>0){
            foreach($qry->result() as $res1) {
                $res[] = $res1->order_id;
            }
        }
    }
    return $res;
}

function getCompletedOrdersbyRef($refid){
    $res = array();
    $cid = $this->session->userdata("user_id");
    
    $whusr = " o.user_id=$cid ";
    $admids = $this->session->userdata('country_user_ids');
    if(isset($admids) && sizeof($admids)>0){
        $users = implode(",", $admids);
        $whusr = " o.user_id IN ($users) ";
    }
    $whusr .= " AND o.trip_sts=1 AND r.ref_value IN('".$refid."') AND r.status=1 ";
    if(!empty($refid)){
        $qry = $this->orderrevenuesmodel->getordersbyref($whusr);
        
        if($qry->num_rows()>0){
            foreach ($qry->result() as $res1) {
                $res[] = $res1->order_id;
            }
        }
    }
    return $res;
}

function getCompletedOrdersbyRefOT($refnum,$refval){
    $res = array();
    $cid = $this->session->userdata("user_id");
    
    $whusr = " o.user_id=$cid ";
    $admids = $this->session->userdata('country_user_ids');
    if(isset($admids) && sizeof($admids)>0){
        $users = implode(",", $admids);
        $whusr = " o.user_id IN ($users) ";
    }
    $whusr .= " AND o.trip_sts=1 AND r.reference_id='".$refnum."' AND r.ref_value IN('".$refval."') AND r.status=1";
    if(!empty($refval)){
        $qry = $this->orderrevenuesmodel->getordersbyref($whusr);
        
        if($qry->num_rows()>0){
            foreach ($qry->result() as $res1) {
                $res[] = $res1->order_id;
            }
        }
    }
    return $res;
}


public function pendingorders(){
    if (!checkUrlAccessForUser('ADMIN-PENDINGORDERS')) {
        redirect("Forbiddenaccess");
    }
    $data['page_title']=$this->lang->line('menu_pending');
    $data['sub_title']=$this->lang->line('menu_pending')." ".$this->lang->line('bookings');
    $data['ord_type'] = "";
    $data['orders'] = array();
    $inp = 0;
    $btype = $this->session->userdata('business_type');
    $branch_user = $data["branch_user"] = isset($_POST["branch_user"]) ? $_POST["branch_user"] : "-1";
    if(!in_array($btype, ['Country Admin'])){
        $cid = "(".$this->session->userdata("user_id").")";
    }else{
        $admids = $this->session->userdata('country_user_ids');
        if($branch_user != "-1"){
            $cid   = "($branch_user)";
        }else if(count($admids)>0){
            $users  = implode(",", $admids);
            $cid   = "($users)";
        }else{
            $cid   = "(-1)";
        }
    }
    $company_code = $this->session->userdata("company_code");
    $curtz = $this->session->userdata("usr_tzone")['timezone'];
    $input = $this->input->post();
    $whr = "";
    $pwhr = "o.user_id IN $cid AND ";
    $permission = checkuserpermissions();
    if(in_array("orders", $permission)){
        $company_code = $this->session->userdata('company_code');
        $pwhr = "o.company_code LIKE '". $this->db->escape_str($company_code)."' AND ";
    }else{
        $pwhr = "o.user_id IN $cid AND ";
    }
    if(!empty($input)){
        if(!empty($input['bookingid'])){
            $input_bookingid = $this->db->escape_str($input['bookingid']);
            $bookids = implode("','", $input_bookingid);
            $inp = 1;
            $whr .= " AND o.order_id IN('".$bookids."')";
        }
        if(isset($input['pickup']) && !empty($input['pickup'])){
            $inp = 1;
            $input_pickup = $this->db->escape_str($input['pickup']);
            $whr .= " AND (o.pickup_country LIKE '%".$input_pickup."%' OR o.pickup_city LIKE '%".$input_pickup."%') ";
        }
        if(isset($input['drop']) && !empty($input['drop'])){
            $inp = 1;
            $input_drop = $this->db->escape_str($input['drop']);
            $whr .= " AND (o.delivery_country LIKE '%".$input_drop."%' OR o.delivery_city LIKE '%".$input_drop."%') ";
        }
        if(isset($input['fromdate_search'])){
            if($input['fromdate_search'] != ""){
                $inp = 1;
                $input_fromdate_search = $this->db->escape_str($input['fromdate_search']);
                $getactual = getdatetimebytimezone(DFLT_TZ, $input_fromdate_search, $curtz);
                $input['fromdate_search'] = $getactual['date'];
                $whr .= " AND DATE(o.pickup_datetime)>='".$input['fromdate_search']."' ";
            }
        }
        if(isset($input['todate_search'])){
            if($input['todate_search'] != ""){
                $inp = 1;
                $input_todate_search = $this->db->escape_str($input['todate_search']);
                $getactual = getdatetimebytimezone(DFLT_TZ, $input_todate_search, $curtz);
                $input['todate_search'] = $getactual['date'];
                $whr .= " AND DATE(o.delivery_datetime)<='".$input['todate_search']."' ";
            }
        }

        $getords = array();
        if(!empty($input['reference'])){
            $inp = 1;
            $reference = implode("','", $input['reference']);
            $getords = $this->getPendingOrdersbyRef($reference);
        }
        if(!empty($input['order_type'])){
            $inp = 1;
            $input_order_type = $this->db->escape_str($input['order_type']);
            $ordtye = implode("','", $input_order_type);
            $getords1 = $this->getPendingOrdersbyRefOT("OT",$ordtye);
            if(!empty($getords1)){
                $getords = array_merge($getords,$getords1);
            }else{
                $getords2 = $this->getActiveOrdersdetailsType($ordtye);
                if(!empty($getords2)){
                    $getords = array_merge($getords,$getords2);
                }
            }
        }
        if(!empty($getords)){
            $gords = implode("','",$getords);
            $whr .= " AND o.id IN('$gords') ";
        }
    }
    if($inp == 1 && $whr == ""){
        $whr .= " AND o.id IN(0) ";
    }

    if($company_code == 'NZKN'){
        $whr .= ' AND (o.order_status != "READY" OR o.order_status IS NULL) ';
    }

    $mainqry = "SELECT  o.id  FROM tb_orders o WHERE ".$pwhr." o.trip_id=0 AND (`o`.`trip_id` =0 AND (SELECT COUNT(trip_id) FROM tb_employee WHERE order_id=o.order_id) =0) AND o.status!=0 AND o.trip_sts=0 $whr  GROUP BY o.order_id ORDER BY o.pickup_datetime DESC";
    $custord1 = $this->db->query($mainqry);
    $pgcnt = $custord1->num_rows();
    $config = array();
    $config["base_url"] = base_url() . "admin/pendingorders";
    $config["total_rows"] = $pgcnt;
    $config["per_page"] = 5;
    $config["uri_segment"] = 3;
    $config['display_pages'] = TRUE;
    $this->pagination->initialize($config);
    $page = ($this->uri->segment(3)) ? (int)$this->uri->segment(3) : 0;
    $mainqry = "SELECT o.id,o.order_id,o.order_status,convertToClientTZ(o.pickup_datetime,?) as pickup_datetime,o.pickup_city,o.pickup_country,convertToClientTZ(o.delivery_datetime,?) as delivery_datetime,o.delivery_city,o.delivery_country FROM tb_orders o  WHERE  ".$pwhr." o.status!=0 AND o.trip_id=0  $whr AND (`o`.`trip_id` =0 AND (SELECT COUNT(trip_id) FROM tb_employee WHERE order_id=o.order_id) =0) AND o.trip_sts=0 GROUP BY o.order_id  ORDER BY o.pickup_datetime DESC";
    $qry = $mainqry . ' LIMIT ' . $page . ',' . $config["per_page"];
    $custord = $this->db->query($qry, [$curtz,$curtz]);

    if($custord->num_rows()>0){
        $data['orders'] = $custord->result_array();
    }
    $this->newtemplate->dashboard('admin/pendingorders',$data);
}

public function readyorders(){
    if (!checkUrlAccessForUser('READYORDERS')) {
        redirect("Forbiddenaccess");
    }
    $data['page_title']=$this->lang->line('menu_ready');
    $data['sub_title']=$this->lang->line('ready_orders');
    $data['ord_type'] = "";
    $data['orders'] = array();
    $inp = 0;
    $btype = $this->session->userdata('business_type');
    $branch_user = $data["branch_user"] = isset($_POST["branch_user"]) ? $_POST["branch_user"] : "-1";
    if(!in_array($btype, ['Country Admin'])){
        $cid = "(".$this->session->userdata("user_id").")";
    }else{
        $admids = $this->session->userdata('country_user_ids');
        if($branch_user != "-1"){
            $cid   = "($branch_user)";
        }else if(count($admids)>0){
            $users  = implode(",", $admids);
            $cid   = "($users)";
        }else{
            $cid   = "(-1)";
        }
    }
    $company_code = $this->session->userdata("company_code");
    $curtz = $this->session->userdata("usr_tzone")['timezone'];
    $input = $this->input->post();
    $whr = "";
    if(!empty($input)){
        if(!empty($input['bookingid'])){
            $bookids = implode("','", $input['bookingid']);
            $inp = 1;
            $whr .= " AND o.order_id IN('".$bookids."')";
        }
        if(isset($input['pickup']) && !empty($input['pickup'])){
            $inp = 1;
            $whr .= " AND (o.pickup_country LIKE '%".$input['pickup']."%' OR o.pickup_city LIKE '%".$input['pickup']."%') ";
        }
        if(isset($input['drop']) && !empty($input['drop'])){
            $inp = 1;
            $whr .= " AND (o.delivery_country LIKE '%".$input['drop']."%' OR o.delivery_city LIKE '%".$input['drop']."%') ";
        }
        if(isset($input['fromdate_search'])){
            if($input['fromdate_search'] != ""){
                $inp = 1;
                $getactual = getdatetimebytimezone(DFLT_TZ,$input['fromdate_search'],$curtz);
                $input['fromdate_search'] = $getactual['date'];
                $whr .= " AND DATE(o.pickup_datetime)>='".$input['fromdate_search']."' ";
            }
        }
        if(isset($input['todate_search'])){
            if($input['todate_search'] != ""){
                $inp = 1;
                $getactual = getdatetimebytimezone(DFLT_TZ,$input['todate_search'],$curtz);
                $input['todate_search'] = $getactual['date'];
                $whr .= " AND DATE(o.delivery_datetime)<='".$input['todate_search']."' ";
            }
        }

        $getords = array();
        if(!empty($input['reference'])){
            $inp = 1;
            $reference = implode("','", $input['reference']);
            $getords = $this->getReadyOrdersbyRef($reference);
        }
        if(!empty($input['order_type'])){
            $inp = 1;
            $ordtye = implode("','", $input['order_type']);
            $getords1 = $this->getReadyOrdersbyRefOT("OT",$ordtye);
            if(!empty($getords1)){
                $getords = array_merge($getords,$getords1);
            }else{
                $getords2 = $this->getActiveOrdersdetailsType($ordtye);
                if(!empty($getords2)){
                    $getords = array_merge($getords,$getords2);
                }
            }
        }
        if(!empty($getords)){
            $gords = implode("','",$getords);
            $whr .= " AND o.id IN('$gords') ";
        }
    }
    if($inp == 1 && $whr == ""){
        $whr .= " AND o.id IN(0) ";
    }
    $whr .= " AND o.order_status ='READY' ";
    $mainqry = "SELECT count(o.id) as cnt FROM tb_orders o WHERE o.user_id IN $cid AND o.trip_id=0 AND o.status!=0 AND o.trip_sts=0 $whr";
    $custord1 = $this->db->query($mainqry);
    $pgcnt = $custord1->row()->cnt;
    $config = array();
    $config["base_url"] = base_url() . "admin/readyorders";
    $config["total_rows"] = $pgcnt;
    $config["per_page"] = 5;
    $config["uri_segment"] = 3;
    $config['display_pages'] = TRUE;
    $this->pagination->initialize($config);
    $page = ($this->uri->segment(3)) ? (int)$this->uri->segment(3) : 0;
    $mainqry = "SELECT o.id,o.order_id,o.order_status,convertToClientTZ(o.pickup_datetime,?) as pickup_datetime,o.pickup_city,o.pickup_country,convertToClientTZ(o.delivery_datetime,?) as delivery_datetime,o.delivery_city,o.delivery_country,o.order_status FROM tb_orders o WHERE o.user_id IN $cid AND o.status!=0 AND o.trip_id=0 AND o.trip_sts=0 $whr ORDER BY o.pickup_datetime,o.order_status DESC";
    $qry = $mainqry . ' LIMIT ' . $page . ',' . $config["per_page"];
    $custord = $this->db->query($qry,[$curtz,$curtz]);
    if($custord->num_rows()>0){
       $data['orders'] = $custord->result_array();
   }
   $this->newtemplate->dashboard('admin/readyorders',$data);
}

public function doneorders(){
    if (!checkUrlAccessForUser('ADMIN-DONEORDERS')) {
        redirect("Forbiddenaccess");
    }
    $data['page_title']=$this->lang->line('menu_completed');
    $data['sub_title']=$this->lang->line('menu_completed')." ".$this->lang->line('bookings');
    $data['orders'] = array();
    $inp = 0;
    $whusr1 = "";
    $lgusrid = $this->session->userdata("user_id");
    $btype = $this->session->userdata('business_type');
    $branch_user = $data["branch_user"] = isset($_POST["branch_user"]) ? $this->db->escape_str($_POST["branch_user"]) : "-1";
    $company_code = $this->session->userdata("company_code");
    $curtz = $this->session->userdata("usr_tzone")['timezone'];
    $input = $this->input->post();
    $whr = "";
    $permission = checkuserpermissions();
    if(in_array("orders", $permission)){
        $company_code = $this->session->userdata('company_code');
        $whusr1 = "AND o.company_code LIKE '".$company_code."' ";
    }else{
        if(!in_array($btype, ['Country Admin'])){
            $whusr1 = " AND o.user_id IN (".$lgusrid.") ";
        }else{
            $admids = $this->session->userdata('country_user_ids');
            if($branch_user != "-1"){
                $whusr1 = " AND o.user_id IN ($branch_user)";
            }else if(count($admids)>0){
                $users = implode(",", $admids);
                $whusr1 = " AND o.user_id IN ($users)";
            }else{
                $whusr1 = " AND o.user_id IN (-1)";
            }
        }
    }
    if(!empty($input)){
        if(!empty($input['bookingid'])){
            $input_bookingid = $this->db->escape_str($input['bookingid']);
            $bookids = implode("','", $input_bookingid );
            $inp = 1;
            $whr .= " AND o.order_id IN('".$bookids."')";
        }
        if(isset($input['pickup']) && !empty($input['pickup'])){
            $inp = 1;
            $input_pickup = $this->db->escape_str($input['pickup']);
            $whr .= " AND (o.pickup_country LIKE '%".$input_pickup."%' OR o.pickup_city LIKE '%".$input_pickup."%') ";
        }
        if(isset($input['drop']) && !empty($input['drop'])){
            $inp = 1;
            $input_drop = $this->db->escape_str($input['drop']);
            $whr .= " AND (o.delivery_country LIKE '%".$input_drop."%' OR o.delivery_city LIKE '%".$input_drop."%') ";
        }
        if(isset($input['fromdate_search'])){
            if($input['fromdate_search'] != ""){
                $inp = 1;
                $input_fromdate_search = $this->db->escape_str($input['fromdate_search']);
                $getactual = getdatetimebytimezone(DFLT_TZ, $input_fromdate_search, $curtz);
                $input['fromdate_search'] = $getactual['date'];
                $whr .= " AND DATE(o.pickup_datetime)>='".$input['fromdate_search']."' ";
            }
        }
        if(isset($input['todate_search'])){
            if($input['todate_search'] != ""){
                $inp = 1;
                $input_todate_search = $this->db->escape_str($input['todate_search']);
                $getactual = getdatetimebytimezone(DFLT_TZ, $input_todate_search, $curtz);
                $input['todate_search'] = $getactual['date'];
                $whr .= " AND DATE(o.delivery_datetime)<='".$input['todate_search']."' ";
            }
        }

        $getords = array();
        if(!empty($input['reference'])){
            $inp = 1;
            $input_reference = $this->db->escape_str($input['reference']);
            $reference = implode("','", $input_reference);
            $getords = $this->getCompletedOrdersbyRef($reference);
        }
        if(!empty($input['order_type'])){
            $inp = 1;
            $input_order_type = $this->db->escape_str($input['order_type']);
            $ordtye = implode("','", $input_order_type);
            $getords1 = $this->getCompletedOrdersbyRefOT("OT",$ordtye);
            if(!empty($getords1)){
                $getords = array_merge($getords,$getords1);
            }else{
                $getords2 = $this->getActiveOrdersdetailsType($ordtye);
                if(!empty($getords2)){
                    $getords = array_merge($getords,$getords2);
                }
            }
        }
             if(!empty($input['trip_no'])){
                if(!empty($input['carrier_name'])&& !empty($input['driver_name'])){
                    $inp = 1;
                    $input_trip_no = $this->db->escape_str($input['trip_no'],$input['carrier_name']);
                    $getords = $this->Completedordersmodel->getCompletedOrdersbyTripandCarrieranddriver($input_trip_no,$input['carrier_name'],$input['driver_name']);
                   }
                else if(!empty($input['carrier_name'])){

                    $inp = 1;
                    $input_trip_no = $this->db->escape_str($input['trip_no'],$input['carrier_name']);
                    $getords = $this->Completedordersmodel->getCompletedOrdersbyTripandCarrier($input_trip_no,$input['carrier_name']);
                    }
                else if(!empty($input['driver_name'])){

                     $inp = 1;
                $input_trip_no = $this->db->escape_str($input['trip_no']);
                $getords = $this->Completedordersmodel->getCompletedOrdersbyTripanddriver($input_trip_no,$input['driver_name']);
                }
                else{
                $inp = 1;
                $input_trip_no = $this->db->escape_str($input['trip_no']);
                $getords = $this->Completedordersmodel->getCompletedOrdersbyTrip($input_trip_no);
                }

            }


             else if(!empty($input['carrier_name'])){
                if(!empty($input['driver_name'])){

                $inp = 1;
                $input_driver_name = $this->db->escape_str($input['driver_name']);
               $getords = $this->Completedordersmodel->getCompletedOrdersbycarrieranddriver($input['carrier_name'],$input_driver_name);
            }
            else{

                $inp = 1;
                $input_carrier_name = $this->db->escape_str($input['carrier_name']);
                $getords = $this->Completedordersmodel->getCompletedOrdersbyCarrier($input_carrier_name);

                }
            }

            else if(!empty($input['driver_name'])){

                $inp = 1;
                $input_driver_name = $this->db->escape_str($input['driver_name']);
               $getords = $this->Completedordersmodel->getCompletedOrdersbyDriver($input_driver_name);

            }

        if(!empty($getords)){
            $gords = implode("','",$getords);
            $whr .= " AND o.id IN('$gords') ";
        }
    }
    if($inp == 1 && $whr == ""){
        $whr .= " AND o.id IN(0) ";
    }
    $mainqry = "SELECT count(o.id) as cnt FROM tb_orders o WHERE (o.trip_sts=1 OR (o.trip_sts = 0 AND o.status = 3))  $whusr1 $whr";
    $custord = $this->db->query($mainqry);
    $pgcnt = $custord->row()->cnt;
    $config = array();
    $config["base_url"] = base_url() . "admin/doneorders";
    $config["total_rows"] = $pgcnt;
    $config["per_page"] = 5;
    $config["uri_segment"] = 3;
    $config['display_pages'] = TRUE;
    $this->pagination->initialize($config);
    $page = ($this->uri->segment(3)) ? (int)$this->uri->segment(3) : 0;
    $mainqry2 = "SELECT o.id,o.order_id,o.pickup_datetime,o.delivery_datetime,o.pickup_country,o.delivery_country,o.pickup_city,o.delivery_city,o.shift_id,o.trip_id FROM tb_orders o WHERE (o.trip_sts=1 OR (o.trip_sts = 0 AND o.status = 3)) $whusr1 $whr ORDER BY o.updatedon DESC";
    $qry = $mainqry2 . ' LIMIT ' . $page . ',' . $config["per_page"];
    $custord1 = $this->db->query($qry);
    if($custord1->num_rows()>0){
        $data['orders'] = $custord1->result_array();
    }
    $this->newtemplate->dashboard('admin/doneorders',$data);
}

    /**
     * download completed order documents
     *
     * @param Integer Order Id
     * @param bool $asHtml
     * @return void pdf
     */
    public function downloadCompletedOrder(int $id = 0, bool $asHtml = false): void {

        $this->load->model("order");
        if (!($order = $this->order->getOrderById($id))) {
            redirect("admin/doneorders");
        }

        $builder = new CompletedOrderEPodBuilder($order->order_id, $this);

        if ($asHtml) {
            echo $builder->getHtml();
        }
        $builder->createPdf();
    }

    public function download($filename)
    {
        $this->load->helper('download');
        $file = NEW_POD_PATH . $filename;
        force_download($file, null);
    }

    /** this should be kept, because some of created pdf's links here
     * and solution was moved to controller which don't require logged user
     */
    public function download_epod_attachement($chkuuId)
    {
        $this->load->helper('url');
        redirect('/downloadEpod/safelink/'.$chkuuId);
    }

public function orderdetails(){
    $data['ord_type'] = "done";
    if($this->input->post("order_id")){
        $order_id = $this->input->post("order_id");
        $userid = $this->session->userdata('user_id');
        $company_code = $this->session->userdata('company_code');
        $branch_code = $this->session->userdata('branch_code');
        $data['ord_type'] = $this->input->post("type");
        $data['userid'] = $userid;
        $curtz = $this->session->userdata("usr_tzone")['timezone'];
        $logdate = date('Y-m-d H:i:s');
        $getactual = getdatetimebytimezone(DFLT_TZ,$logdate,$curtz);
        $curdt = $getactual['datetime'];
        $data["order"] = $this->db->where(array("id"=>$order_id))->get("tb_orders")->row();
        $party_types = array();
        $partytypes = $this->db->select("id,name")->get_where("tbl_party_types",array("user_id"=>$userid,'company_code'=>$company_code));
        if($partytypes->num_rows() == 0){
            $chk = $this->db->select("name,description")->get_where("tbl_party_types",array("user_id"=>1));
            if($chk->num_rows()>0){
                foreach($chk->result_array() as $res){
                    $ins = array('name'=>$res['name'], 'description'=>$res['description'], 'user_id'=>$userid, 'company_code'=>$company_code, 'branch_code'=>$branch_code, 'status'=>1, 'created_on'=>$curdt);
                    $insqry = $this->db->insert("tbl_party_types",$ins);
                }
            }
            $partytypes = $this->db->select("id,name")->get_where("tbl_party_types",array("user_id"=>$userid,'company_code'=>$company_code));
            $party_types = $partytypes->result_array();
        }else{
            $party_types = $partytypes->result_array();
        }
        $data['party_types'] = $party_types;
        $status = "1";
        $sql = "SELECT r.id,r.reference_id,r.ref_value,t.description FROM tb_order_references r,tb_reference_master t WHERE r.reference_id=t.name AND r.order_id=? AND r.status=? GROUP BY r.id";
        $data["orderref"] = $this->db->query($sql, [$order_id, $status]);
        echo $this->load->view("admin/vieworderdetails",$data,TRUE);
    }
}

public function trackviewmap($ord){
    $data["page_title"] = "MAP";
    if($ord != ""){
        $curtz = $this->session->userdata("usr_tzone")['timezone'];
        $tripinfo = $this->common->gettblrowdata(array("order_id"=>$ord,"trip_id !="=>0),"trip_id","tb_orders",0,0);
        if(count($tripinfo)>0){
            $trip_id = $tripinfo['trip_id'];
            $data["trip_id"] = $trip_id;
            $chktrip = $this->db->select("id,shift_id,vehicle_id,driver_id,status,dlat as latitude,dlng as longitude")->get_where("tb_trips",array("id"=>$trip_id),1,0);
            if($chktrip->num_rows()>0){
                $data["trip"]= $trip = $chktrip->row();
                $driver_row = $this->db->select("id,name,track_type")->where("id",$trip->driver_id)->get("tb_truck_drivers")->row();
                $shipment_id = $trip->shift_id;
                $status = "1";
                $sql = "SELECT id,stopname,stopcity,address,stoptype,convertToClientTZ(startdate,?) as startdate,weight,volume,ship_units from tb_shiporder_stops where shipment_id = ? AND status=? ORDER BY ordernumber ASC";
                $data["stops"] = $this->db->query($sql, [$curtz,$shipment_id, $status]);
                $data["details"] = [];
                foreach($data["stops"]->result() as $stop){
                    $sql = "SELECT id,plat,plng,pickup,stop_id,convertToClientTZ(pickup_datetime,?) as pickup_datetime,dlat,dlng,`drop`,convertToClientTZ(drop_datetime,?) as drop_datetime, shipment_weight, shipment_volume, order_id from tb_employee where (stop_id = ? OR drop_stopid =?) AND status = '1'";
                    $det = $this->db->query($sql, [$curtz,$curtz,$stop->id,$stop->id]);
                    foreach($det->result() as $row){
                        $details=[];
                        if($row->stop_id == $stop->id){
                            $details["lat"] = $row->plat;
                            $details["lng"] = $row->plng;
                            $details["name"] = $row->pickup;
                            $details["time"] = $row->pickup_datetime;
                            $details["type"] = "P";
                        }else{
                            $details["lat"] = $row->dlat;
                            $details["lng"] = $row->dlng;
                            $details["name"] = $row->drop;
                            $details["time"] = $row->drop_datetime;
                            $details["type"] = "D";
                        }
                        $details["weight"] = $row->shipment_weight;
                        $details["volume"] = $row->shipment_volume;

                        $details["stop_id"] = $stop->id;
                        $details["id"] = $row->id;
                        $details["order_id"] = $row->order_id;
                        $details["alphabet"] = getColName(count($data["details"])+1);
                        $details["status"] = "0";
                        $shipment_id = $trip->shift_id;
                        $stop_id = $stop->id;
                        $stop_detail_id =$row->id;
                        $status=1;
                        $sql = "SELECT ss.status_id,ss.latitude,ss.longitude,convertToClientTZ(ss.createdon,?) as createdon,sm.status_name from tb_stop_status ss LEFT JOIN tb_status_master sm ON sm.id=ss.status_id WHERE ss.shipment_id=? AND ss.stop_id =? AND ss.stop_detail_id = ? AND ss.status=? ORDER BY ss.createdon ASC";
                        $done = $this->db->query($sql, [$curtz,$shipment_id, $stop_id,$stop_detail_id,$status]);
                        $status_row=[];
                        if($done->num_rows()>0){
                            foreach($done->result() as $status){
                                $status_row["detail_id"] = $row->id;
                                $status_row["status_id"] = $status->status_id;
                                $status_row["status_name"] = $status->status_name;
                                $status_row["in_lat"] = $status->latitude;
                                $status_row["in_lng"] = $status->longitude;
                                $status_row["in_time"] = $status->createdon;
                                $details["statuses"][] = (Object) $status_row;
                            }
                            $details["status"] = "1";
                        }else{
                            $details["statuses"][] = (Object) $status_row;
                        }
                        $data["details"][] = (Object)$details;
                    }
                }
                $data["drivers"] = $this->db->query("SELECT d.id,d.name,d.contact_num,convertToClientTZ(td.createdon,'".$curtz."') as createdon,d.track_type,td.travelled_km from tb_trip_drivers td LEFT JOIN tb_truck_drivers d ON d.id = td.driver_id WHERE trip_id = $trip_id AND td.status ='1' GROUP BY d.id ORDER BY td.createdon ASC")->result_array();
                $data["drivers"][] = array("id"=>$driver_row->id,"name"=>$driver_row->name,"contact_num"=>$driver_row->name,"createdon"=>null,"track_type"=>$driver_row->track_type,"travelled_km"=>0);
                if($trip->status == 1){
                    $data["record"] = $this->db->query("SELECT latitude,longitude FROM tb_trucks_data WHERE id = '".$trip->vehicle_id."' LIMIT 1")->row();
                }else{
                    $data["record"] = $trip;
                }
                $data["isSimBased"] = "false";
                if (count($data["drivers"])>0){
                    if($data["drivers"][count($data["drivers"])-1]["track_type"] == "1"){
                        $data["isSimBased"] = "true";
                    }
                }
                if($data["isSimBased"]){
                    $trip_id = $this->db->escape($trip_id);
                    $sql = "SELECT latitude,longitude,speed,`timestamp` FROM tb_rtdrive_locations WHERE trip_id = ? order by `timestamp`";
                    $data["records"] = $this->db->query($sql, [$trip_id]);
                }
                $this->settemplate->dashboardtemp('admin/tripMap',$data);
            }else{
                echo "";
            }
        }else{
            echo "";
        }
    }else{
        echo "";
    }
}

public function statusviewdetails(){
    $ordid = $this->input->post("id");
    $ord = $this->input->post("order_id");
    $tripinfo = $this->order_details->getOrderRouteDetails($ord);
    if(count($tripinfo)>0){
        $curtz = $this->session->userdata("usr_tzone")['timezone'];
        $shift_id = $tripinfo['shift_id'];
        $whr = " AND status = 1";
        $dlat = $tripinfo['dlat'];
        $dlng = $tripinfo['dlng'];
        $slat = $tripinfo['plat'];
        $slng = $tripinfo['plng'];
        $order_row_id = $tripinfo['id'];
        $data["drivers"] = array();
        $trip_id = $tripinfo['trip_id'];
        if($trip_id != 0){
            $sql = "SELECT id,vehicle_id,status,dlat as latitude,dlng as longitude FROM tb_trips WHERE id=? ORDER BY id DESC LIMIT 1";
            $qry = $this->db->query($sql, [$trip_id]);
            if($qry->num_rows() > 0){
                $sts = $qry->row()->status;
                if ( $slat == '' && $slng == '' )
                {
                    if ( $sts == 1 ) {
                        $sql = "SELECT latitude,longitude from tb_trucks_data WHERE id =? LIMIT 1";
                        $rec = $this->db->query($sql, [$qry->row()->vehicle_id]);
                        if($rec->num_rows()>0){
                            $slat = $rec->row()->latitude;
                            $slng = $rec->row()->longitude;
                        }
                    }else{
                        $slat = $qry->row()->latitude;
                        $slng = $qry->row()->longitude;
                    }
                }
                $sql = "SELECT d.id,d.name,d.contact_num,convertToClientTZ(td.createdon,?) as createdon from tb_trip_drivers td LEFT JOIN tb_truck_drivers d ON d.id = td.driver_id WHERE td.trip_id =? AND td.status =1 GROUP BY d.id ORDER BY td.createdon ASC";
                $drivers = $this->db->query($sql, [$curtz,$trip_id]);
                if($drivers->num_rows()>0){
                    $data["drivers"] = $drivers->result_array();
                }
            }
        }
        $order_status=array();
        if($this->session->userdata('company_code') == 'AUKN'){
            $order_where=array('s.order_id'=>$ordid);
            $order_status=$this->orderStatus($order_where);
        }
        $data["history1"] = $order_status;
        $data["history"] = $this->statusremappingservice->getOrderStatuses([
            'timeZone' => $curtz,
            'bookingId' => $ord,
            'shiftId' => $shift_id,
            'carrierName' => $tripinfo['name'],
            'companyCode' => $this->session->userdata('company_code'),
            'orderRowId'=>$order_row_id
        ]);
        $data["slat"] = $slat;
        $data["slng"] = $slng;
        $data["dlat"] = $dlat;
        $data["dlng"] = $dlng;
        $data['epod'] = array();
        $data['epodp'] = array();
        $docs = $this->db->select("id,stop_id,stop_type,latitude,longitude,convertToClientTZ(createdon,'".$curtz."') as createdon")->get_where("tb_pod_uploads",array("stop_type"=>"D","doc_type"=>3,"order_id"=>$order_row_id,"status"=>1),1,0);
        if($docs->num_rows()>0){
            $data['epod'] = array("status_code"=>"3060","status_name"=>"ePOD Available","stop_id"=>$docs->row()->stop_id,"stop_type"=>$docs->row()->stop_type,"location"=>getLocationName($docs->row()->latitude,$docs->row()->longitude),"comment"=>"","createdon"=>$docs->row()->createdon);
        }

        $docs = $this->db->query(
            "SELECT id,stop_id,stop_type,latitude,longitude,convertToClientTZ(createdon,'".$curtz."') as createdon,hash
                FROM tb_pod_uploads WHERE stop_type=? AND (doc_type=? OR doc_type=?) AND order_id=? AND status=?
                LIMIT 1",
            ['P',3,4,$order_row_id,1]
        );
        if($docs->num_rows()>0){
            $data['epodp'] = array("status_code"=>"2490","status_name"=>"Goods Loaded for Delivery","stop_id"=>$docs->row()->stop_id,"stop_type"=>$docs->row()->stop_type,"location"=>getLocationName($docs->row()->latitude,$docs->row()->longitude),"comment"=>"","createdon"=>$docs->row()->createdon);
        }
        echo $this->load->view("admin/statusview",$data,TRUE);
    }
}


private function orderStatus($where){
    
        $result = array();
         $curtz = $this->session->userdata("usr_tzone")['timezone'];
        $this->db->select("s.status_id,s.latitude,s.longitude,s.status_code,convertToClientTZ(s.status_date,'".$curtz."') as status_date,sm.status_name");
        $this->db->from('tb_order_status s');
        $this->db->join('tb_status_master sm', 'sm.id=s.status_id', 'LEFT');
        $this->db->where($where);
        $this->db->group_by('s.status_code');
        $this->db->order_by('s.id','ASC');
        $res = $this->db->get();
        if($res){
            if($res->num_rows() > 0){
                $result = $res->result_array();
            }
        }
        return $result;
}

    public function orddocsdetails()
    {
        $ord = $this->input->post("order_id");
        $ordid = $this->input->post("id");
        $data['ord_type'] = "done";
        $tripinfo = $this->common->gettblrowdata(["id" => $ordid], "id,order_id,company_code,branch_code,shift_id,trip_id", "tb_orders", 0, 0);
        if (!empty($tripinfo)) {
            $curtz = $this->session->userdata("usr_tzone")['timezone'];
            $data['ord_type'] = $this->input->post("type");
            $shift_id = $tripinfo['shift_id'];
            $data['ship_id'] = $tripinfo['shift_id'] ?? 0;
            $data['trip_id'] = $tripinfo['trip_id'] ?? 0;
            $sql = "SELECT ts.id,ts.latitude,ts.longitude,ts.stop_id,ts.stop_type,dt.type_name,ts.createdby,convertToClientTZ(ts.createdon,?) as createdon,ts.imgpath from tb_pod_uploads ts
                    LEFT JOIN tb_document_types dt ON dt.id=ts.doc_type
                    WHERE ts.order_id = ? AND ts.status = ?
                    GROUP BY ts.id";
            $sql1 = $this->db->query($sql,[$curtz,$ordid,1]);
            if ($sql1->num_rows() > 0) {
                $i = 1;
                foreach ($sql1->result_array() as $eachRow) {
                    $base64DocumentData = getBase64DocumentData($eachRow['imgpath']);
                    $pods[] = [
                        'sno' => $i,
                        'location' => @getLocationName($eachRow['latitude'], $eachRow['longitude']),
                        'type_name' => $eachRow['type_name'],
                        'driver_name' => @getDrivernameById($eachRow['createdby'])["name"],
                        'stop_id' => $eachRow['stop_id'],
                        'stop_type' => $eachRow['stop_type'],
                        'createdon' => date("d M,y h:i A", strtotime($eachRow['createdon'])),
                        'extention' => $base64DocumentData['extention'],
                        'file_content' => $base64DocumentData['file_content'],
                    ];
                    $i++;
                }
            }
            $data["pods"] = $pods ?? [];
            $data['order_id'] = $ord;
            $data['document_types'] = $this->db->select("id,type_name")->get_where("tb_document_types", ["status" => 1])->result_array();
            $data['stops'] = [];
            $sql = "SELECT o.id,o.stopname
                    FROM tb_shiporder_stops o,tb_employee e
                    WHERE o.shipment_id=e.shift_id AND e.order_id=? AND o.status=1 AND e.status=1
                    ORDER BY o.ordernumber ASC";
            $stops = $this->db->query($sql,[$ord]);
            if ($stops->num_rows() > 0) {
                $data['stops'] = $stops->result_array();
            }
            $data['order'] = (object)$tripinfo;
            echo $this->load->view("admin/managedocuments", $data, true);
        }
    }

public function savenewreference(){
    $reference_id = $this->input->post("reference_id",true);
    $reference_value = $this->input->post("reference_value",true);
    $order_id = $this->input->post("order_id",true);
    $sts = "no";
    if($order_id != "" && $reference_id != "" && $reference_value != ""){
        $curtz = $this->session->userdata("usr_tzone")['timezone'];
        if($reference_id == "ETA"){
            $chkrtime = getdatetimebytimezone(DFLT_TZ,$reference_value,$curtz);
            $reference_value = $chkrtime['datetime'];
        }
        $logdate = date('Y-m-d H:i:s');
        $getactual = getdatetimebytimezone(DFLT_TZ,$logdate,$curtz);
        $curdt = $getactual['datetime'];
        $chk = $this->db->select("id")->get_where("tb_order_references",array("order_id"=>$order_id,"ref_value"=>$reference_value),1,0);
        if($chk->num_rows() == 0){
            $sts = "1";
            $ins = array("order_id"=>$order_id,"reference_id"=>$reference_id,"ref_value"=>$reference_value,"status"=>1,"createdon"=>$curdt);
            $insdata = $this->db->insert("tb_order_references",$ins);
            $insdata = $this->db->insert("tb_order_references_history",$ins);
        }else{
            $sts = "2";
        }
    }
    echo $sts;
}

public function savenewparty(){
    $party_type = $this->input->post("party_type",true);
    $party_identifier = $this->input->post("party_identifier",true);
    $cust_identifier = $this->input->post("cust_identifier",true);
    $party_name = $this->input->post("party_name",true);
    $party_city = $this->input->post("party_city",true);
    $party_state = $this->input->post("party_state",true);
    $party_countrycode = $this->input->post("party_countrycode",true);
    $party_zipcode = $this->input->post("party_zipcode",true);
    $party_street = $this->input->post("party_street",true);
    $order_id = $this->input->post("order_id",true);
    $order_number = $this->input->post("order_number",true);
    $company_code = $this->input->post("company_code",true);
    $branch_code = $this->input->post("branch_code",true);
    $sts = "no";
    $userid = $this->session->userdata('user_id');
    if($order_id != "" && $party_type != "" && $party_name != ""){
        $curtz = $this->session->userdata("usr_tzone")['timezone'];
        $logdate = date('Y-m-d H:i:s');
        $getactual = getdatetimebytimezone(DFLT_TZ,$logdate,$curtz);
        $curdt = $getactual['datetime'];
        $chk = $this->db->select("id")->get_where("tbl_party_master",array("code"=>$cust_identifier),1,0);

        $toSave = [
            'name' => $party_name,
            'location_id' => $party_city,
            'address' => $party_street,
            'pincode' => $party_zipcode,
            'country' => $party_countrycode,
            'state' => $party_state,
            'code' => $cust_identifier,
            'partyindetifier' => $party_identifier,
            'customeridentifier' => $cust_identifier,
            'status' => 1
        ];
        if($chk->num_rows() > 0){
            $pid = $chk->row()->id;
            $upddata = $this->db->where([
                "id" => $pid
            ])->update( "tbl_party_master", $toSave );
        }else{
            $toSave = array_merge( $toSave, [
                'party_type_id' => $party_type,
                'user_id' => $userid,
                'mobile' => $cust_identifier,
                'company_code' => $company_code,
                'branch_code' => $branch_code
            ]);
            $insdata1 = $this->db->insert("tbl_party_master",$toSave);
            $pid = $this->db->insert_id();
        }
        $chk1 = $this->db->select("id")->get_where("tb_order_parties",array("party_id"=>$pid,"order_id"=>$order_id,"party_type"=>$party_type),1,0);
        if($chk1->num_rows() > 0){
            $sts = "2";
        }else{
            $insdata = array("order_id"=>$order_id,"order_number"=>$order_number,"party_id"=>$pid,"party_type"=>$party_type,"status"=>1,"createdon"=>$curdt);
            $insqry = $this->db->insert("tb_order_parties",$insdata);
            $sts = "1";
        }
    }
    echo $sts;
}

function getNumPagesPdf($filepath) {
    $fp = @fopen(preg_replace("/\[(.*?)\]/i", "", $filepath), "r");
    $max = 0;
    if (!$fp) {
        return "Could not open file: $filepath";
    } else {
        while (!@feof($fp)) {
            $line = @fgets($fp, 255);
            if (preg_match('/\/Count [0-9]+/', $line, $matches)) {
                preg_match('/[0-9]+/', $matches[0], $matches2);
                if ($max < $matches2[0]) {
                    $max = trim($matches2[0]);
                    break;
                }
            }
        }
        @fclose($fp);
    }
    return $max;
}

/*public function savenewpod(){
    $order_id = $this->input->post("order_id",true);
    $order_number = $this->input->post("order_number",true);
    $company_code = $this->input->post("company_code",true);
    $branch_code = $this->input->post("branch_code",true);
    $country_code = $this->session->userdata( "usr_tzone" )['country'];
    $ship_id = $this->input->post("ship_id",true);
    $trip_id = $this->input->post("trip_id",true);
    $stop_id = $this->input->post("stop_id",true);
    $doc_type = $this->input->post("doc_type",true);
    $sts = "no";
    $fileName = "";
    $curtz = $this->session->userdata("usr_tzone")['timezone'];
    $logdate = date('Y-m-d H:i:s');
    $getactual = getdatetimebytimezone(DFLT_TZ,$logdate,$curtz);
    $curdt = $getactual['datetime'];
    $userid = $this->session->userdata('user_id');
    $plat = $plng = "";
    if (isset($_FILES)) {
        if (isset($_FILES['file_name']['name'])) {
            $config = array('upload_path'   => NEW_POD_PATH,
                'allowed_types' => 'jpeg|jpg|gif|png|pdf|JPEG|JPG|PNG'
            );
            $file_name = $_FILES['file_name']['name'];
            $file_name = str_replace(" ","",$file_name);
            $files = explode('.',$_FILES['file_name']['name'] ?? '');
            $file_ext= @strtolower(end($files));
            $expensions= array("jpeg","jpg","png","gif","pdf");
            if(in_array($file_ext,$expensions)){
                if ($file_ext == "pdf") {
                    if (!($this->inspectpdflibrary->validatepdf($_FILES['file_name']['tmp_name']))) {
                        echo '3';
                        return;
                    }
                }
                $countryCode = substr($company_code,0,-2);
                $documentId = "";
                $config['file_name'] = "RL".$order_number.".pdf";
                if($doc_type == 3) {
                    $documentId = $this->documentsequencelibrary->getSequence('ETN', $countryCode, $doc_type);
                    $config['file_name'] = $documentId.".pdf";
                }
                if($file_ext == "pdf"){
                    $imgtype = "pdf";
                    $this->load->library('upload', $config);
                    if ($this->upload->do_upload('file_name')) {
                        $imgname = $this->upload->data();
                        $imgtype = $imgname['image_type'];
                        $fileName = $imgname['file_name'];
                        $filePath = NEW_POD_PATH.$fileName;
						$imgSizes = filesize($_FILES['file_name']['tmp_name']);
                    }
                }else{
                    $fileName = date('dmyhis').''.$file_name;
                    $filePath = NEW_POD_PATH.$fileName;
                    $imgsize = getimagesize($_FILES['file_name']['tmp_name']);
                    $imgSizes = filesize($_FILES['file_name']['tmp_name']);
                    if($imgsize == FALSE){ }else{
                        $top_width = $imgsize[0];
                        $top_height = $imgsize[1];
                        $quality = 100;
                        if($file_ext == "png"){
                            $top = @imagecreatefrompng($_FILES['file_name']['tmp_name']);
                            $imgtype = "png";
                        }else{
                            $top = @imagecreatefromjpeg($_FILES['file_name']['tmp_name']);
                            if($file_ext == "jpg" || $file_ext == "jpeg"){
                                $imgtype = "jpeg";
                            }else{
                                $imgtype = $file_ext;
                            }
                        }
                        if($top){
                            header('Content-Type: image/jpeg');
                            @imagejpeg($top,$filePath,$quality);
                            @imagedestroy($top);
                        }else{
                            $fileName = "";
                            $sts = "2";
                        }
                    }
                }
                $createdsource = "";
                if($fileName != "" && $doc_type != ""){
                    $stoptype = $this->db->select("stoptype,plat,plng")->get_where("tb_shiporder_stops",array("id"=>$stop_id,"stoptype"=>"D","status"=>1),1,0);

                    if($stoptype->num_rows()>0){
                        $stype = "D";
                        $plat = $stoptype->row()->plat;
                        $plng = $stoptype->row()->plng;

                    }else{
                        $stype = "P";
                        $stoptype = $this->db->select("stoptype,plat,plng")->get_where("tb_shiporder_stops",array("id"=>$stop_id,"stoptype"=>"P","status"=>1),1,0);
                        if($stoptype->num_rows()>0){
                            $plat = $stoptype->row()->plat;
                            $plng = $stoptype->row()->plng;
                        }
                    }
                    if($stop_id == ""){ $stop_id = 0; }
                    $fileData = "INSERT INTO `tb_pod_uploads` (`stop_id`, `shipment_id`, `trip_id`, `doc_type`, `imgpath`, `stop_type`, `order_id`, `status`, `user_id`, `longitude`, `latitude`, `createdon`, `filesize`, `hash`) VALUES (?,?,?, ?, ?, ?, ?, 1, ?, ?, ?, ?,?, UUID())";
                    $res = $this->db->query($fileData,[$stop_id,$ship_id,$trip_id,$doc_type,$fileName,$stype,$order_id,$userid,$plng,$plat,$curdt,$imgSizes]);
                    if($order_id != "0"){
                        $postdata = array();
                        $postdata['ord_id'] = $order_id;
                        $getOrderDetails = $this->Completedordersmodel->getOrderDetailsWithLatLngs($order_id);
                        if(!empty($getOrderDetails)) {
                            $createdsource = $getOrderDetails['createdSource'];
                            if($createdsource == OrderSources::ETNQUOTE){
                                $postdata['user_id'] = $getOrderDetails['userId'];
                                $postdata['status_code'] = '3060';
                                $postdata['hrs'] = $this->session->userdata("usr_tzone")['hrs'];
                                $updsts = $this->svkonektquote->getstatusresponse($postdata);
                            }
                        }
                        if($stype == 'D' && $doc_type == DocumentType::POD && $createdsource != OrderSources::SALOG){
                            $this->sendnotify('pod_note',$order_id,$filePath);
                        }
                    }
                    if($createdsource != OrderSources::SALOG){
                        $chkref = "XSR";
                        $whrin = " AND reference_id in('XSR','SD') ";
                        $sql = "SELECT reference_id,ref_value FROM tb_order_references WHERE order_id=? $whrin AND ref_value!='' GROUP BY reference_id HAVING count(reference_id)>=1";
                        $chkordtypeqry = $this->db->query($sql,[$order_id]);
                        $refval = $refvalue = "";
                        $iofeof = "EOF";
                        if($chkordtypeqry->num_rows()>1){
                            foreach($chkordtypeqry->result() as $oref){
                                if($oref->reference_id == "XSR"){
                                    $refvalue = $oref->ref_value;
                                }
                                if($oref->reference_id == "SD" && $oref->ref_value == "2"){
                                    $iofeof = "IOF";
                                }
                            }
                            $chkparty = "SELECT party_id,partycontact_id,customer_id,email_note,emailid,party_name FROM tb_contact_notifys WHERE status=1 AND (pod_note=1 OR all_note=1) GROUP BY emailid";
                            $query = $this->db->query($chkparty);
                            if($query->num_rows()>0){
                                $this->load->library('email');
                                foreach($query->result() as $pmails){

                                    $receivename = $pmails->party_name;
                                    $receivemail = $pmails->emailid;
                                    $orders = $this->db->get_where("tb_orders",array("id"=>$order_id),1,0);
                                    if($orders->num_rows()>0){
                                        $orddata = $orders->row_array();
                                        $data['order'] = $orddata;
                                        $data['page_title'] = "Booking ePOD";
                                        $data['receivemail'] = $receivemail;
                                        $data['receivename'] = $receivename;

                                        $sub = $refvalue."#746#".$iofeof;
                                        $this->email->from('svkonekt@kuehne-nagel.com', 'svkonekt');
                                        $this->email->to($receivemail, $receivename);

                                        $this->email->subject($sub);
                                        $this->email->set_mailtype("html");
                                        $body = $this->load->view('mail_forms/bookepod', $data, true);
                                        $this->email->message($body);
                                        $epodpath = sprintf('%s/poduploads/%s', '/var/www/', $fileName);
                                        $this->email->attach($epodpath);

                                        if(!$this->email->send()){
                                            log_message("error",$this->email->print_debugger());
                                        }

                                        $this->email->clear(true);
                                  }

                              }
                          }
                        }
                    }

                    // checking the document types 4 - POP, 3 - POP, 49 - POP , 1 - Signature
                    if ((in_array($doc_type, ['4', '3', '49', '1'])) && ($filePath != "")) {
                        try {
                            $this->commonpodedi->sendpodoutboundxml($order_id, $filePath, $doc_type);
                        } catch (Exception $ex) {
                            log_message("error", "sendpodoutboundxml error  ".$ex->getMessage());
                        }
                    }

                    if ($createdsource == OrderSources::SALOG) {
                        try {
                            $salogXmlData = AbstractXMLData::getDataProvider($doc_type);
                            $salogePodIntegrationService = new IntegrationService();
                            $salogePodIntegrationService->sendePod(
                                $salogXmlData->getData($ship_id, $trip_id, $stop_id, $order_number, $order_id, $plat, $plng),
                                $salogXmlData->getOrderType()
                            );
                        } catch (Exception $ex) {
                            log_message("error", "Salog SFTP: document failed to send!  ".$ex->getMessage());
                        }
                    }
                    if($createdsource == self::KNLOGIN_ORDER_SOURCE){
                        if($doc_type != 3){
                            try {
                                $this->statusintigration->sendPodToKnlogin($doc_type,$order_id);
                            } catch (Exception $ex) {
                                log_message("error", "sendPodToKnlogin error ".$ex->getMessage());
                            }
                        }
                    }

                    $data = [
                        "order_id" => $order_id,
                        "ord_id" => $order_number,
                        'country_code' => $country_code,
                        'company_code' => $company_code,
                        'branch_code' => $branch_code,
                        'shipment_id' => $ship_id,
                        'trip_id' => $trip_id,
                        'stop_id' => $stop_id,
                        'doc_type' => DocumentType::DOCUMENT_NAME_MAPPING[$doc_type],
                        'userid' => $userid,
                        'filename' => $fileName
                    ];
                    try {
                        $this->pushOrderDocumentsToRoadlog($data);
                    } catch (Exception $ex) {
                        log_message("error", "roadlog SFTP: document failed to send!  ".$ex->getMessage());
                    }
                    try {
                        $this->standard_document_execution->sendStandardDocumentXMLtoAltova($data);
                    } catch (Exception $ex) {
                        log_message("error", "sendStandardDocumentXMLtoAltova error  ".$ex->getMessage());
                    }
                    $sts = "1";
                }
            }else{
                $sts = "format";
            }
        }
    }
    echo $sts;
}*/

    private function pushOrderDocumentsToRoadlog(array $data): void
    {
        $orderInfoQuery = "SELECT o.user_id,o.created_source,o.physicalreceiver,o.logicalreceiver,o.physicalsender,o.logicalsender,e.assoc_id
                           FROM tb_orders o
                           LEFT JOIN  tb_employee e ON e.order_id = o.order_id
                           WHERE o.id = ?  AND e.shift_id = ?
                           AND e.order_id = ? AND e.status=1 LIMIT 1 ";
        $orderInfo = $this->db->query($orderInfoQuery, [$data['order_id'], $data['shipment_id'], $data['ord_id']]);
        $knOffice = '';
        $knOfficeRefVal = $this->common->gettblrowdata(['order_id' => $data['order_id'], 'ref_belongs_to' => 'KN OFFICE'], 'id,reference_id,ref_value', 'tb_order_references', 0, 0);
        if (count($knOfficeRefVal) > 0) {
            $knOffice = $knOfficeRefVal['ref_value'];
        }
        $rlgRefVal = $this->common->gettblrowdata(['order_id' => $data['order_id'], 'reference_id' => 'RLG'], 'id,reference_id,ref_value', 'tb_order_references', 0, 0);
        $createdSource = (count($rlgRefVal) > 0) ? "18" : $orderInfo->row()->created_source;
        $RLGTrackingNumber =  (count($rlgRefVal) > 0) ? $rlgRefVal['ref_value'] :  $data['ord_id'];
        if (($orderInfo && $orderInfo->num_rows() > 0) && $createdSource == "18") {
            $roadlog_d3_data = [
                "physical_receiver" => $orderInfo->row()->physicalreceiver,
                "logical_receiver" => $orderInfo->row()->logicalreceiver,
                "physical_sender" => $orderInfo->row()->physicalsender,
                "logical_sender" => $orderInfo->row()->logicalsender,
                "order_id" => $RLGTrackingNumber,
                "assoc_id" => $orderInfo->row()->assoc_id,
                "ref_value_kn_office" => $knOffice,
                "upload_type" => $data['doc_type'],
                "file_path" => NEW_POD_PATH . $data['filename'],
                "branch_code" => $data['branch_code'],
                "company_code" => $data['company_code'],
                "country_code" => $data['country_code'],
                "user_id" => $data['userid'],
                "created_source" => $createdSource,
            ];
            $getDocumentType = $this->common->checkDocumentSentType($RLGTrackingNumber);
            if ($getDocumentType == 1) {
                macadam_d3_dms($roadlog_d3_data);
            } else {
                $roadlogData = $this->common->getRoadlogOrderDetails($data['order_id']);
                if ($data['doc_type'] == "PUP") {
                    $pupStatus = SendDocumentGateOut::sendepopgateoutnotify($roadlogData, $this);
                }
                if ($data['doc_type'] == "POD") {
                    $podStatus = SendDocumentGateOut::sendepodgateoutnotify($roadlogData, $this);
                }

            }

            if ($data['doc_type'] == "PUP") {
                $orderReferenceCount = $this->Roadlogtosalogmodel->getOrderReferenceCount($data['order_id']);
                if ($orderReferenceCount > 1) {
                    $this->roadlogsalogdocument->sendDocumentToSlog($data);
                }
            }
        }
    }

public function massstatus($id = NULL) {
    
    if ($this->session->userdata('user_role_id') === "5") {
        redirect("knops/massstatus");
    }
    if (!checkUrlAccessForUser('GLOBAL-MASSSTATUS')) {
        redirect("Forbiddenaccess");
    }
    if ($id != "") {
        $this->massstatuslist($id);
    } else {
        $this->massstatuslist();
    }
}

    /*public function massstatuslist($id = null)
    {
        
        $data['page_title'] = $this->lang->line('menu_massstsupd');;
        $data['sub_title'] = $this->lang->line('general_search');;
        $uid = $this->session->userdata("user_id");
        $curtz = $this->session->userdata("usr_tzone")['timezone'];
        $chk_usrtype = $this->session->userdata("business_type");
        $excel_uploaddata = [];
        $list_type = 0;

        if ($id != "") {
            if ($id == "01") {
                $filedata = @file_get_contents("assets/ordertemplate/massstatusdata.txt");
                $excel_uploaddata = @json_decode($filedata);
                if (!empty($excel_uploaddata)) {
                    $list_type = 1;
                    @file_put_contents("assets/ordertemplate/massstatusdata.txt", "");
                    $logs = addordertologs($filedata);
                }
            }
        }

        $carrierwhr = "";

        if ($chk_usrtype == "Carrier") {
            $carrierwhr = " AND o.vendor_id=" . $this->session->userdata("id");

            if (checkAccessConditions('RELATED_2_SG_MY', $this->session->userdata('company_code'))) {
                $carrierIds = getCarrierids($this->session->userdata("carrier_code"));

                if (count($carrierIds) > 1) {
                    $carrierIdValues = implode("','", $carrierIds);
                    $carrierwhr = "AND o.vendor_id IN ('" . $carrierIdValues . "')";
                }
            }
        } else {
            $carrierwhr = " AND o.user_id=" . $uid;
        }
        
        

        $config = [];
        $item = "";
        $post = $this->input->post(null, true);

        if (isset($post['searchsubmit']) || isset($post['order_id'])) {
            if (isset($post['searchsubmit'])) {
                $item = trim($this->db->escape_str($post['searchsubmit']));
            } else {
                $item = 1;
            }
        }

        if (isset($item) && $item != "") {
            $where1 = '';
            if (isset($post['bookingid']) && !empty($post['bookingid'])) {
                $where1 = "AND o.order_id IN ('" . implode("','", $post['bookingid']) . "') ";
            }
            if (isset($post['reference']) && !empty($post['reference'])) {
                $ref = $this->MassStatusModel->getOrderRefValues($post['reference']);
                if (!empty($ref)) {
                    foreach ($ref as $result) {
                        $oid[] = $result['order_id'];
                    }
                    $oids = implode(",", $oid);
                    $where1 .= "AND o.id IN ($oids)";
                }else{
                    $where1 = "AND o.id = 0";
                }
            }

            if (isset($post['trip_id']) && $post['trip_id'] != "") {
                $post_trip_id = $this->db->escape_str($post['trip_id']);
                $where1 .= "AND o.shipmentid LIKE '%" . $post_trip_id . "%' ";
            }

            if (isset($post['container_no']) && $post['container_no'] != "") {
                $post_container_no = $this->db->escape_str($post['container_no']);
                $sql = "SELECT order_id FROM tb_order_references WHERE status=1 AND ref_value!='' AND ref_value LIKE '%" . $post_container_no . "%'";
                $ref11 = $this->db->query($sql);
                if ($ref11->num_rows() > 0) {
                    foreach ($ref11->result() as $gh) {
                        $oid11[] = $gh->order_id;
                    }
                    $kk = implode(",", $oid11);
                    $where1 .= "AND o.id IN ($kk) ";
                }
            }

            if (isset($post['driver']) && $post['driver'] != "") {
                $post_driver = addslashes($this->db->escape_str($post['driver']));
                $where1 .= "AND (c.name LIKE '%" . $post_driver . "%' OR c.mobile LIKE '%" . $post_driver . "%' OR d.name LIKE '%" . $post_driver . "%' OR d.contact_num LIKE '%" . $post_driver . "%') ";
            }
            
            if (isset($post['vehicle']) && $post['vehicle'] != "") {
                $post_vehicle = addslashes($this->db->escape_str($post['vehicle']));
                $where1 = "AND v.register_number LIKE '%" . $post_vehicle . "%' ";
            }

            if (isset($post['ref_id']) && $post['ref_id'] != "") {
                $post_ref_id = addslashes($this->db->escape_str($post['ref_id']));
                $ref = $this->db->query("SELECT order_id FROM tb_order_references WHERE status=1 AND ref_value!='' AND ref_value LIKE '%" . $post_ref_id . "%' LIMIT 1");
                if ($ref->num_rows() > 0) {
                    $oid = $ref->row()->order_id;
                    $where1 .= "AND o.id LIKE '%" . $oid . "%' ";
                }
            }

            $searchwhr = " $where1";
            $searchwhr .= " AND o.shift_id > 0 ";
            $mainqry = "SELECT o.id,o.order_id,o.shift_id,o.trip_id,o.shipmentid,v.vehicle_id,a.driver_id,a.imei,d.contact_num,d.track_type,d.track_vendor,d.sim_carrier,t.actual_carrier_acceptance FROM tb_orders o LEFT JOIN tb_trips t ON t.id=o.trip_id,tb_shft_veh v,tb_vendors c,tbl_assigned_drivers a,tb_truck_drivers d,tb_employee tbe WHERE o.shift_id=v.shft_id AND o.order_id=tbe.order_id AND v.carrier_id=c.id AND v.vehicle_id=a.vehicle_id AND a.driver_id=d.id AND v.status=1 AND a.status=1 AND d.status='Active' $searchwhr $carrierwhr AND o.status!=0 AND o.status!=3 AND o.trip_sts=0 GROUP BY o.order_id ORDER BY o.id DESC";
            $shipmentCount = $this->MassStatusModel->getShipmentCount($searchwhr, $carrierwhr);
         /*elseif (isset($post['searchsubmita']) && $post['searchsubmita'] == "Search") {*/
            //$where1 = '';

            

            /*$searchwhr = " $where1";
            $searchwhr .= " AND o.shift_id > 0 ";
            $mainqry = "SELECT o.id,o.order_id,o.shift_id,o.trip_id,o.shipmentid,v.vehicle_id,a.driver_id,a.imei,d.contact_num,d.track_type,d.track_vendor,d.sim_carrier,t.actual_carrier_acceptance FROM tb_orders o LEFT JOIN tb_trips t ON t.id=o.trip_id,tb_shft_veh v,tb_vendors c,tbl_assigned_drivers a,tb_truck_drivers d,tb_employee tbe WHERE o.shift_id=v.shft_id  AND o.order_id=tbe.order_id AND v.carrier_id=c.id AND v.vehicle_id=a.vehicle_id AND a.driver_id=d.id AND v.status=1 AND a.status=1 AND d.status='Active' $searchwhr $carrierwhr AND o.status!=0 AND o.status!=3 AND o.trip_sts=0 GROUP BY o.order_id ORDER BY o.id DESC";
            $shipmentCount = $this->MassStatusModel->getShipmentCount($searchwhr, $carrierwhr);-------------
        } 
        else {
            $where1 = '';

            if (!empty($post)) {
                if (isset($post['bookingid']) && !empty($post['bookingid'])) {
                    $where1 = "AND o.order_id IN ('" . implode("','", $post['bookingid']) . "') ";
                }

                if (isset($post['trip_id']) && $post['trip_id'] != "") {
                    $post_trip_id = $this->db->escape_str($post['trip_id']);
                    $where1 .= "AND o.shipmentid LIKE '%" . $post_trip_id . "%' ";
                }

                if (isset($post['container_no']) && $post['container_no'] != "") {
                    $post_container_no = $this->db->escape_str($post['container_no']);
                    $sql = "SELECT order_id FROM tb_order_references WHERE status=1 AND ref_value!='' AND ref_value LIKE '%" . $post_container_no . "%'";
                    $ref11 = $this->db->query($sql);
                    if ($ref11->num_rows() > 0) {
                        foreach ($ref11->result() as $gh) {
                            $oid11[] = $gh->order_id;
                        }
                        $kk = implode(",", $oid11);
                        $where1 .= "AND o.id IN ($kk) ";
                    }
                }

                if (isset($post['driver']) && $post['driver'] != "") {
                    $post_driver = addslashes($this->db->escape_str($post['driver']));
                    $where1 .= "AND (c.name LIKE '%" . $post_driver . "%' OR c.mobile LIKE '%" . $post_driver . "%' OR d.name LIKE '%" . $post_driver . "%' OR d.contact_num LIKE '%" . $post_driver . "%') ";
                }
                if (isset($post['reference']) && !empty($post['reference'])) {
                    $ref = $this->MassStatusModel->getOrderRefValues($post['reference']);
                    if (!empty($ref)) {
                        foreach ($ref as $result) {
                            $oid[] = $result['order_id'];
                        }
                        $oids = implode(",", $oid);
                        $where1 .= "AND o.id IN ($oids)";
                    }else{
                        $where1 = "AND o.id = 0";
                    }
                }
            }

            $searchwhr = " $where1";
            $searchwhr .= " AND o.shift_id > 0 ";
            $mainqry = "
                    SELECT o.id,o.order_id,o.shift_id,o.trip_id,
                           o.shipmentid,v.vehicle_id,a.driver_id,a.imei,
                           d.contact_num,d.track_type,d.track_vendor,d.sim_carrier,t.actual_carrier_acceptance
                    FROM tb_orders o LEFT JOIN tb_trips t ON t.id=o.trip_id,tb_shft_veh v,tb_vendors c,tbl_assigned_drivers a,tb_truck_drivers d,tb_employee tbe
                    WHERE o.shift_id=v.shft_id
                      AND o.order_id=tbe.order_id
                      AND v.carrier_id=c.id
                      AND v.vehicle_id=a.vehicle_id
                      AND a.driver_id=d.id
                      AND v.status=1
                      AND a.status=1
                      AND d.status='Active'
                          $searchwhr $carrierwhr
                      AND o.status!=0 AND o.status!=3
                      AND o.trip_sts=0
                    GROUP BY o.order_id, o.id
                    ORDER BY o.id DESC";
                    
            $shipmentCount = $this->MassStatusModel->getShipmentCount($searchwhr, $carrierwhr);
        }

        $ordcount = $shipmentCount ?? 0;
        $config["base_url"] = base_url() . "admin/massstatus";
        $config["total_rows"] = $ordcount;
        $config["per_page"] = 10;
        $config["uri_segment"] = 3;
        $config['display_pages'] = true;
        $this->pagination->initialize($config);
        $page = ($this->uri->segment(3)) ? (int)$this->uri->segment(3) : 0;
        if ($page == "01") {
            $page = 0;
        }
        $mainqry = $mainqry . " LIMIT ?,?";
        $custord = $this->db->query($mainqry, [$page, $config["per_page"]]);
       
        $data['tripsdata'] = [];
        if ($custord->num_rows() > 0) {
            $shiftIds = array_column($custord->result(), 'shift_id');
            $orderRowIds = array_column($custord->result(), 'id');
            $bookingIds = array_column($custord->result(), 'order_id');
            $vehicleIds = array_column($custord->result(), 'vehicle_id');
            $shipOrderDetails = $this->MassStatusModel->getShipOrderDetails($shiftIds, $bookingIds);
            $orderReferences = $this->MassStatusModel->getOrderReferenceByOrderIds($orderRowIds);
            $tripData = $this->MassStatusModel->getTripData($shiftIds, $bookingIds);
            $driversData = $this->MassStatusModel->getLatestDriverDataByVehicle(array_unique($vehicleIds));
            $shipOrderStopsByPickOrDropId = $this->MassStatusModel->getShipOrderStopsByPickOrDropId($shiftIds, $bookingIds);
           
            foreach ($custord->result() as $res) {
                $ship_id = $res->shift_id;
                $multiship = 0;
                $tripid = $driver_id = 0;
                $vehicle_id = $res->vehicle_id;
                $shipmentid = $res->shipmentid;
                if ($res->trip_id > 0 && isset($tripData[$res->order_id])) {
                    $eachOrderTripData = $tripData[$res->order_id];
                    if (!empty($eachOrderTripData)) {
                        $tripid = ($eachOrderTripData['trip_id'] > 0) ? $eachOrderTripData['trip_id'] : 0;
                        $vehicle_id = ($eachOrderTripData['vehicle_id'] > 0) ? $eachOrderTripData['vehicle_id'] : 0;
                        $driver_id = ($eachOrderTripData['driver_id'] > 0) ? $eachOrderTripData['driver_id'] : 0;
                    }
                }
                if ($tripid == 0 && $vehicle_id != "") {
                    $driver_id = $driversData[$vehicle_id] ?? 0;
                    if ($driver_id === 0) {
                        $driver_id = $res->driver_id;
                    }
                }
                $tracktype = 0;
                $trackvendor = $simcarrier = $contact_num = "";
                if ($res->track_type == 1) {
                    $tracktype = 1;
                    $trackvendor = $res->track_vendor;
                    $simcarrier = $res->sim_carrier;
                    $contact_num = $res->contact_num;
                }
                $ordid = $res->id;
                $refers = $orderReferences[$res->id] ?? [];
                $saccept = $sgatein = $spickup = $sgateout = $intransit = $dgatein = $dpickup = $dgateout = 0;
                $s_saccept = $s_sgatein = $s_spickup = $s_sgateout = $s_intransit = $s_dgatein = $s_dpickup = $s_dgateout = 0;
                $s_sacceptcr = $s_sgateincr = $s_spickupcr = $s_sgateoutcr = $s_intransitcr = $s_dgateincr = $s_dpickupcr = $s_dgateoutcr = "";
                $pstpid = $dstpid = $pstodetailid = $dstodetailid = "";
                $removeTripFromOrderFlag = false;
                $stopStatusDetails = $this->MassStatusModel->getStopStatusDetails($curtz, $ship_id, $tripid);
               
                if (!empty($stopStatusDetails)) {
                    log_message("error", "stop_destils:" . print_r($stopStatusDetails, true));
                    foreach ($stopStatusDetails as $eachStopDetails) {
                        $status_orderid = $eachStopDetails['order_id'];
                        if ($eachStopDetails['status_code'] == 'SV0610') {
                            $close = $eachStopDetails['sid'];
                        }
                        if ($eachStopDetails['status_code'] == 'SV0120') {
                            if ($eachStopDetails['id'] != "") {
                                $pstpid = $eachStopDetails['stop_id'];
                                $pstodetailid = $eachStopDetails['stop_detail_id'];
                                $saccept = $eachStopDetails['status_id'];
                                $s_saccept = 1;
                                $s_sacceptcr = date('d-m-Y H:i:s', strtotime($eachStopDetails['createdon'] ?? ""));
                                if ($pstpid == "0" || $pstpid == "") {
                                    if (isset($tripData[$res->order_id])) {
                                        $pstpid = $tripData[$res->order_id]['id'];
                                        $pstodetailid = $tripData[$res->order_id]['stopdetailsid'];
                                    }
                                }
                            } else {
                                if (isset($tripData[$res->order_id])) {
                                    $pstpid = $tripData[$res->order_id]['id'];
                                    $pstodetailid = $tripData[$res->order_id]['stopdetailsid'];
                                    $saccept = $eachStopDetails['sid'];
                                }
                            }
                        }
                        if ($eachStopDetails['status_code'] == "SV0130") {
                            if ($eachStopDetails['id'] != "" && $eachStopDetails['stop_type'] == "P") {
                                $pstpid = $eachStopDetails['stop_id'];
                                $pstodetailid = $eachStopDetails['stop_detail_id'];
                                $sgatein = $eachStopDetails['status_id'];
                                if ($status_orderid == $ordid) {
                                    $s_sgatein = 1;
                                    $s_sgateincr = date('d-m-Y H:i:s', strtotime($eachStopDetails['createdon'] ?? ""));
                                }
                            } else {
                                if (isset($shipOrderStopsByPickOrDropId[$res->order_id])) {
                                    $pstpid = $shipOrderStopsByPickOrDropId[$res->order_id]['id'];
                                    $pstodetailid = $shipOrderStopsByPickOrDropId[$res->order_id]['stopdetailsid'];
                                    $sgatein = $eachStopDetails['sid'];
                                }
                            }
                        }

                        if ($eachStopDetails['status_code'] == 'SV0310') {
                            if ($eachStopDetails['id'] != "" && $eachStopDetails['stop_type'] == "D") {
                                $dstpid = $eachStopDetails['stop_id'];
                                $dstodetailid = $eachStopDetails['stop_detail_id'];
                                $dgatein = $eachStopDetails['status_id'];
                                if ($status_orderid == $ordid) {
                                    $s_dgatein = 1;
                                    $s_dgateincr = date('d-m-Y H:i:s', strtotime($eachStopDetails['createdon'] ?? ""));
                                }
                            } else {
                                if (isset($tripData[$res->order_id])) {
                                    $dstpid = $tripData[$res->order_id]['id'];
                                    $dstodetailid = $tripData[$res->order_id]['stopdetailsid'];
                                    $dgatein = $eachStopDetails['sid'];
                                }
                            }
                        }

                        if ($eachStopDetails['status_code'] == 'SV0131') {
                            if ($eachStopDetails['id'] != "" && $eachStopDetails['stop_type'] == "P") {
                                $pstpid = $eachStopDetails['stop_id'];
                                $pstodetailid = $eachStopDetails['stop_detail_id'];
                                $spickup = $eachStopDetails['status_id'];
                                if ($status_orderid == $ordid) {
                                    $s_spickup = 1;
                                    $s_spickupcr = date('d-m-Y H:i:s', strtotime($eachStopDetails['createdon']));
                                }
                            } else {
                                if (isset($tripData[$res->order_id])) {
                                    $pstpid = $tripData[$res->order_id]['id'];
                                    $pstodetailid = $tripData[$res->order_id]['stopdetailsid'];
                                    $spickup = $eachStopDetails['sid'];
                                }
                            }
                        }

                        if ($eachStopDetails['status_code'] == 'SV0410') {
                            if ($eachStopDetails['id'] != "" && $eachStopDetails['stop_type'] == "D") {
                                $dstpid = $eachStopDetails['stop_id'];
                                $dstodetailid = $eachStopDetails['stop_detail_id'];
                                $dpickup = $eachStopDetails['status_id'];
                                if ($status_orderid == $ordid) {
                                    $s_dpickup = 1;
                                    $s_dpickupcr = date('d-m-Y H:i:s', strtotime($eachStopDetails['createdon']));
                                }
                            } else {
                                if (isset($tripData[$res->order_id])) {
                                    $dstpid = $tripData[$res->order_id]['id'];
                                    $dstodetailid = $tripData[$res->order_id]['stopdetailsid'];
                                    $dpickup = $eachStopDetails['sid'];
                                }
                            }
                        }

                        if ($eachStopDetails['status_code'] == 'SV0140') {
                            if ($eachStopDetails['id'] != "" && $eachStopDetails['stop_type'] == "P") {
                                $pstpid = $eachStopDetails['stop_id'];
                                $pstodetailid = $eachStopDetails['stop_detail_id'];
                                $sgateout = $eachStopDetails['status_id'];
                                if ($status_orderid == $ordid) {
                                    $s_sgateout = 1;
                                    $s_sgateoutcr = date('d-m-Y H:i:s', strtotime($eachStopDetails['createdon']));
                                }
                            } else {
                                if (isset($tripData[$res->order_id])) {
                                    $pstpid = $tripData[$res->order_id]['id'];
                                    $pstodetailid = $tripData[$res->order_id]['stopdetailsid'];
                                    $sgateout = $eachStopDetails['sid'];
                                }
                            }
                        }

                        if ($eachStopDetails['status_code'] == 'SV0510') {
                            if ($eachStopDetails['id'] != "" && $eachStopDetails['stop_type'] == "D") {
                                $dstpid = $eachStopDetails['stop_id'];
                                $dstodetailid = $eachStopDetails['stop_detail_id'];
                                $dgateout = $eachStopDetails['status_id'];
                                if ($status_orderid == $ordid) {
                                    $s_dgateout = 1;
                                    $s_dgateoutcr = date('d-m-Y H:i:s', strtotime($eachStopDetails['createdon']));
                                }
                            } else {
                                if (isset($tripData[$res->order_id])) {
                                    $dstpid = $tripData[$res->order_id]['id'];
                                    $dstodetailid = $tripData[$res->order_id]['stopdetailsid'];
                                    $dgateout = $eachStopDetails['sid'];
                                }
                            }
                        }

                        if ($eachStopDetails['status_code'] == 'SV0230') {
                            if ($eachStopDetails['id'] != "") {
                                $pstpid = $eachStopDetails['stop_id'];
                                $pstodetailid = $eachStopDetails['stop_detail_id'];
                                $intransit = $eachStopDetails['status_id'];
                                if ($status_orderid == $ordid) {
                                    $s_intransit = 1;
                                    $s_intransitcr = date('d-m-Y H:i:s', strtotime($eachStopDetails['createdon']));
                                }
                            } else {
                                if (isset($tripData[$res->order_id])) {
                                    $pstpid = $tripData[$res->order_id]['id'];
                                    $pstodetailid = $tripData[$res->order_id]['stopdetailsid'];
                                    $intransit = $eachStopDetails['sid'];
                                }
                            }
                        }
                    }
                } else {
                    if (isset($shipOrderDetails[$res->order_id])) {
                        foreach ($shipOrderDetails[$res->order_id] as $res1) {
                            $close = $statusIds['SV0610'] ?? 0;
                            if ($res1['stoptype'] == "P") {
                                $saccept = $statusIds['SV0120'] ?? 0;
                                $sgatein = $statusIds['SV0130'] ?? 0;
                                $spickup = $statusIds['SV0131'] ?? 0;
                                $sgateout = $statusIds['SV0140'] ?? 0;
                                $intransit = $statusIds['SV0230'] ?? 0;
                                $pstpid = $res1['id'];
                                $pstodetailid = $res1['stopdetailsid'];
                            }
                            if ($res1['stoptype'] == "D") {
                                $dgatein = $statusIds['SV0310'] ?? 0;
                                $dpickup = $statusIds['SV0410'] ?? 0;
                                $dgateout = $statusIds['SV0510'] ?? 0;
                                $dstpid = $res1['id'];
                                $dstodetailid = $res1['stopdetailsid'];
                            }
                        }
                    }
                }
                if ($s_sgateincr != '' || $s_spickupcr != '' || $s_sgateoutcr != '') {
                    $removeTripFromOrderFlag = true;
                }
                $data['tripsdata'][] = [
                    "trip_id" => $tripid,
                    "ship_id" => $ship_id,
                    "ord_id" => $ordid,
                    "shipmentid" => $shipmentid,
                    "order_id" => $res->order_id,
                    "refers" => $refers,
                    "saccept" => $saccept,
                    "sgatein" => $sgatein,
                    "spickup" => $spickup,
                    "sgateout" => $sgateout,
                    "intransit" => $intransit,
                    "dgatein" => $dgatein,
                    "dpickup" => $dpickup,
                    "dgateout" => $dgateout,
                    "s_saccept" => $s_saccept,
                    "s_sgatein" => $s_sgatein,
                    "s_spickup" => $s_spickup,
                    "close" => $close ?? 0,
                    "s_sgateout" => $s_sgateout,
                    "s_intransit" => $s_intransit,
                    "s_dgatein" => $s_dgatein,
                    "s_dpickup" => $s_dpickup,
                    "s_dgateout" => $s_dgateout,
                    "s_sacceptcr" => $s_sacceptcr,
                    "s_sgateincr" => $s_sgateincr,
                    "s_spickupcr" => $s_spickupcr,
                    "s_sgateoutcr" => $s_sgateoutcr,
                    "s_intransitcr" => $s_intransitcr,
                    "s_dgateincr" => $s_dgateincr,
                    "s_dpickupcr" => $s_dpickupcr,
                    "s_dgateoutcr" => $s_dgateoutcr,
                    "pstpid" => $pstpid,
                    "dstpid" => $dstpid,
                    "pstodetailid" => $pstodetailid,
                    "dstodetailid" => $dstodetailid,
                    "vehicle_id" => $vehicle_id,
                    "driver_id" => $driver_id,
                    "tracktype" => $tracktype,
                    "trackvendor" => $trackvendor,
                    "simcarrier" => $simcarrier,
                    "contact_num" => $contact_num,
                    "multiship" => $multiship,
                    "actual_carrier_acceptance" => $res->actual_carrier_acceptance,
                    "removeTripFromOrderFlag" => $removeTripFromOrderFlag
                ]; 
            }
        }
        $data['list_type'] = $list_type;
        $data['excel_uploaddata'] = $excel_uploaddata;
        $data['postdata'] = $post;
        $data['curtz'] = $curtz;
        $this->newtemplate->dashboard("admin/massstatus", $data);
    }*/
    
    public function massstatuslist($id = null)
    {

        $data['page_title'] = $this->lang->line('menu_massstsupd');;
        $data['sub_title'] = $this->lang->line('general_search');;
        $uid = $this->session->userdata("user_id");
        $curtz = $this->session->userdata("usr_tzone")['timezone'];
        $chk_usrtype = $this->session->userdata("business_type");
        $excel_uploaddata = [];
        $list_type = 0;

        if ($id != "") {
            if ($id == "01") {
                $filedata = @file_get_contents("assets/ordertemplate/massstatusdata.txt");
                $excel_uploaddata = @json_decode($filedata);
                if (!empty($excel_uploaddata)) {
                    $list_type = 1;
                    @file_put_contents("assets/ordertemplate/massstatusdata.txt", "");
                    $logs = addordertologs($filedata);
                }
            }
        }

        $carrierwhr = "";

        if ($chk_usrtype == "Carrier") {
            $carrierwhr = " AND o.vendor_id=" . $this->session->userdata("id");

            if (checkAccessConditions('RELATED_2_SG_MY', $this->session->userdata('company_code'))) {
                $carrierIds = getCarrierids($this->session->userdata("carrier_code"));

                if (count($carrierIds) > 1) {
                    $carrierIdValues = implode("','", $carrierIds);
                    $carrierwhr = "AND o.vendor_id IN ('" . $carrierIdValues . "')";
                }
            }
        } else {
            $carrierwhr = " AND o.user_id=" . $uid;
        }



        $config = [];
        $item = "";
        $post = $this->input->post(null, true);

        if (isset($post['searchsubmit']) || isset($post['order_id'])) {
            if (isset($post['searchsubmit'])) {
                $item = trim($this->db->escape_str($post['searchsubmit']));
            } else {
                $item = 1;
            }
        }

        if (isset($item) && $item != "") {
            $where1 = '';
            if (isset($post['bookingid']) && !empty($post['bookingid'])) {
                $where1 = "AND o.order_id IN ('" . implode("','", $post['bookingid']) . "') ";
            }
            if (isset($post['reference']) && !empty($post['reference'])) {
                $ref = $this->MassStatusModel->getOrderRefValues($post['reference']);
                if (!empty($ref)) {
                    foreach ($ref as $result) {
                        $oid[] = $result['order_id'];
                    }
                    $oids = implode(",", $oid);
                    $where1 .= "AND o.id IN ($oids)";
                } else {
                    $where1 = "AND o.id = 0";
                }
            }

            if (isset($post['trip_id']) && $post['trip_id'] != "") {
                $post_trip_id = $this->db->escape_str($post['trip_id']);
                $where1 .= "AND o.shipmentid LIKE '%" . $post_trip_id . "%' ";
            }

            if (isset($post['container_no']) && $post['container_no'] != "") {
                $post_container_no = $this->db->escape_str($post['container_no']);
                $sql = "SELECT order_id FROM tb_order_references WHERE status=1 AND ref_value!='' AND ref_value LIKE '%" . $post_container_no . "%'";
                $ref11 = $this->db->query($sql);
                if ($ref11->num_rows() > 0) {
                    foreach ($ref11->result() as $gh) {
                        $oid11[] = $gh->order_id;
                    }
                    $kk = implode(",", $oid11);
                    $where1 .= "AND o.id IN ($kk) ";
                }
            }

            if (isset($post['driver']) && $post['driver'] != "") {
                $post_driver = addslashes($this->db->escape_str($post['driver']));
                $where1 .= "AND (c.name LIKE '%" . $post_driver . "%' OR c.mobile LIKE '%" . $post_driver . "%' OR d.name LIKE '%" . $post_driver . "%' OR d.contact_num LIKE '%" . $post_driver . "%') ";
            }

            if (isset($post['vehicle']) && $post['vehicle'] != "") {
                $post_vehicle = addslashes($this->db->escape_str($post['vehicle']));
                $where1 = "AND v.register_number LIKE '%" . $post_vehicle . "%' ";
            }

            if (isset($post['ref_id']) && $post['ref_id'] != "") {
                $post_ref_id = addslashes($this->db->escape_str($post['ref_id']));
                $ref = $this->db->query("SELECT order_id FROM tb_order_references WHERE status=1 AND ref_value!='' AND ref_value LIKE '%" . $post_ref_id . "%' LIMIT 1");
                if ($ref->num_rows() > 0) {
                    $oid = $ref->row()->order_id;
                    $where1 .= "AND o.id LIKE '%" . $oid . "%' ";
                }
            }

            $searchwhr = " $where1";
            $searchwhr .= " AND o.shift_id > 0 ";
            $mainqry = "SELECT o.id,o.order_id,o.shift_id,o.trip_id,o.shipmentid,v.vehicle_id,a.driver_id,a.imei,d.contact_num,d.track_type,d.track_vendor,d.sim_carrier,t.actual_carrier_acceptance FROM tb_orders o LEFT JOIN tb_trips t ON t.id=o.trip_id,tb_shft_veh v,tb_vendors c,tbl_assigned_drivers a,tb_truck_drivers d,tb_employee tbe WHERE o.shift_id=v.shft_id AND o.order_id=tbe.order_id AND v.carrier_id=c.id AND v.vehicle_id=a.vehicle_id AND a.driver_id=d.id AND v.status=1 AND a.status=1 AND d.status='Active' $searchwhr $carrierwhr AND o.status!=0 AND o.status!=3 AND o.trip_sts=0 GROUP BY o.order_id ORDER BY o.id DESC";
            $shipmentCount = $this->MassStatusModel->getShipmentCount($searchwhr, $carrierwhr);
            /*elseif (isset($post['searchsubmita']) && $post['searchsubmita'] == "Search") {*/
            //$where1 = '';



            /*$searchwhr = " $where1";
            $searchwhr .= " AND o.shift_id > 0 ";
            $mainqry = "SELECT o.id,o.order_id,o.shift_id,o.trip_id,o.shipmentid,v.vehicle_id,a.driver_id,a.imei,d.contact_num,d.track_type,d.track_vendor,d.sim_carrier,t.actual_carrier_acceptance FROM tb_orders o LEFT JOIN tb_trips t ON t.id=o.trip_id,tb_shft_veh v,tb_vendors c,tbl_assigned_drivers a,tb_truck_drivers d,tb_employee tbe WHERE o.shift_id=v.shft_id  AND o.order_id=tbe.order_id AND v.carrier_id=c.id AND v.vehicle_id=a.vehicle_id AND a.driver_id=d.id AND v.status=1 AND a.status=1 AND d.status='Active' $searchwhr $carrierwhr AND o.status!=0 AND o.status!=3 AND o.trip_sts=0 GROUP BY o.order_id ORDER BY o.id DESC";
            $shipmentCount = $this->MassStatusModel->getShipmentCount($searchwhr, $carrierwhr);*/
        } else {
            $where1 = '';

            if (!empty($post)) {
                if (isset($post['bookingid']) && !empty($post['bookingid'])) {
                    $where1 = "AND o.order_id IN ('" . implode("','", $post['bookingid']) . "') ";
                }

                if (isset($post['trip_id']) && $post['trip_id'] != "") {
                    $post_trip_id = $this->db->escape_str($post['trip_id']);
                    $where1 .= "AND o.shipmentid LIKE '%" . $post_trip_id . "%' ";
                }

                if (isset($post['container_no']) && $post['container_no'] != "") {
                    $post_container_no = $this->db->escape_str($post['container_no']);
                    $sql = "SELECT order_id FROM tb_order_references WHERE status=1 AND ref_value!='' AND ref_value LIKE '%" . $post_container_no . "%'";
                    $ref11 = $this->db->query($sql);
                    if ($ref11->num_rows() > 0) {
                        foreach ($ref11->result() as $gh) {
                            $oid11[] = $gh->order_id;
                        }
                        $kk = implode(",", $oid11);
                        $where1 .= "AND o.id IN ($kk) ";
                    }
                }

                if (isset($post['driver']) && $post['driver'] != "") {
                    $post_driver = addslashes($this->db->escape_str($post['driver']));
                    $where1 .= "AND (c.name LIKE '%" . $post_driver . "%' OR c.mobile LIKE '%" . $post_driver . "%' OR d.name LIKE '%" . $post_driver . "%' OR d.contact_num LIKE '%" . $post_driver . "%') ";
                }
                if (isset($post['reference']) && !empty($post['reference'])) {
                    $ref = $this->MassStatusModel->getOrderRefValues($post['reference']);
                    if (!empty($ref)) {
                        foreach ($ref as $result) {
                            $oid[] = $result['order_id'];
                        }
                        $oids = implode(",", $oid);
                        $where1 .= "AND o.id IN ($oids)";
                    } else {
                        $where1 = "AND o.id = 0";
                    }
                }
            }

            $searchwhr = " $where1";
            $searchwhr .= " AND o.shift_id > 0 ";
            $mainqry = "
                    SELECT o.id,o.order_id,o.shift_id,o.trip_id,
                           o.shipmentid,v.vehicle_id,a.driver_id,a.imei,
                           d.contact_num,d.track_type,d.track_vendor,d.sim_carrier,t.actual_carrier_acceptance
                    FROM tb_orders o LEFT JOIN tb_trips t ON t.id=o.trip_id,tb_shft_veh v,tb_vendors c,tbl_assigned_drivers a,tb_truck_drivers d,tb_employee tbe
                    WHERE o.shift_id=v.shft_id
                      AND o.order_id=tbe.order_id
                      AND v.carrier_id=c.id
                      AND v.vehicle_id=a.vehicle_id
                      AND a.driver_id=d.id
                      AND v.status=1
                      AND a.status=1
                      AND d.status='Active'
                          $searchwhr $carrierwhr
                      AND o.status!=0 AND o.status!=3
                      AND o.trip_sts=0
                    GROUP BY o.order_id, o.id
                    ORDER BY o.id DESC";

            $shipmentCount = $this->MassStatusModel->getShipmentCount($searchwhr, $carrierwhr);
        }

        $ordcount = $shipmentCount ?? 0;
        $config["base_url"] = base_url() . "admin/massstatus";
        $config["total_rows"] = $ordcount;
        $config["per_page"] = 10;
        $config["uri_segment"] = 3;
        $config['display_pages'] = true;
        $this->pagination->initialize($config);
        $page = ($this->uri->segment(3)) ? (int)$this->uri->segment(3) : 0;
        if ($page == "01") {
            $page = 0;
        }
        $mainqry = $mainqry . " LIMIT ?,?";
        $custord = $this->db->query($mainqry, [$page, $config["per_page"]]);

        $data['tripsdata'] = [];
        if ($custord->num_rows() > 0) {
            $shiftIds = array_column($custord->result(), 'shift_id');
            $orderRowIds = array_column($custord->result(), 'id');
            $bookingIds = array_column($custord->result(), 'order_id');
            $vehicleIds = array_column($custord->result(), 'vehicle_id');
            $shipOrderDetails = $this->MassStatusModel->getShipOrderDetails($shiftIds, $bookingIds);
            $orderReferences = $this->MassStatusModel->getOrderReferenceByOrderIds($orderRowIds);
            $tripData = $this->MassStatusModel->getTripData($shiftIds, $bookingIds);
            $driversData = $this->MassStatusModel->getLatestDriverDataByVehicle(array_unique($vehicleIds));
            $shipOrderStopsByPickOrDropId = $this->MassStatusModel->getShipOrderStopsByPickOrDropId($shiftIds, $bookingIds);

            foreach ($custord->result() as $res) {
                $ship_id = $res->shift_id;
                $multiship = 0;
                $tripid = $driver_id = 0;
                $vehicle_id = $res->vehicle_id;
                $shipmentid = $res->shipmentid;
                if ($res->trip_id > 0 && isset($tripData[$res->order_id])) {
                    $eachOrderTripData = $tripData[$res->order_id];
                    if (!empty($eachOrderTripData)) {
                        $tripid = ($eachOrderTripData['trip_id'] > 0) ? $eachOrderTripData['trip_id'] : 0;
                        $vehicle_id = ($eachOrderTripData['vehicle_id'] > 0) ? $eachOrderTripData['vehicle_id'] : 0;
                        $driver_id = ($eachOrderTripData['driver_id'] > 0) ? $eachOrderTripData['driver_id'] : 0;
                    }
                }
                if ($tripid == 0 && $vehicle_id != "") {
                    $driver_id = $driversData[$vehicle_id] ?? 0;
                    if ($driver_id === 0) {
                        $driver_id = $res->driver_id;
                    }
                }
                $tracktype = 0;
                $trackvendor = $simcarrier = $contact_num = "";
                if ($res->track_type == 1) {
                    $tracktype = 1;
                    $trackvendor = $res->track_vendor;
                    $simcarrier = $res->sim_carrier;
                    $contact_num = $res->contact_num;
                }
                $ordid = $res->id;
                $refers = $orderReferences[$res->id] ?? [];
                $saccept = $sgatein = $spickup = $sgateout = $intransit = $dgatein = $dpickup = $dgateout = 0;
                $s_saccept = $s_sgatein = $s_spickup = $s_sgateout = $s_intransit = $s_dgatein = $s_dpickup = $s_dgateout = 0;
                $s_sacceptcr = $s_sgateincr = $s_spickupcr = $s_sgateoutcr = $s_intransitcr = $s_dgateincr = $s_dpickupcr = $s_dgateoutcr = "";
                $pstpid = $dstpid = $pstodetailid = $dstodetailid = "";
                $removeTripFromOrderFlag = false;
                $stopStatusDetails = $this->MassStatusModel->getStopStatusDetails($curtz, $ship_id, $tripid);

                if (!empty($stopStatusDetails)) {
                    log_message("error", "stop_destils:" . print_r($stopStatusDetails, true));
                    foreach ($stopStatusDetails as $eachStopDetails) {
                        $status_orderid = $eachStopDetails['order_id'];
                        if ($eachStopDetails['status_code'] == 'SV0610') {
                            $close = $eachStopDetails['sid'];
                        }
                        if ($eachStopDetails['status_code'] == 'SV0120') {
                            if ($eachStopDetails['id'] != "") {
                                $pstpid = $eachStopDetails['stop_id'];
                                $pstodetailid = $eachStopDetails['stop_detail_id'];
                                $saccept = $eachStopDetails['status_id'];
                                $s_saccept = 1;
                                $s_sacceptcr = date('d-m-Y H:i:s', strtotime($eachStopDetails['createdon'] ?? ""));
                                if ($pstpid == "0" || $pstpid == "") {
                                    if (isset($tripData[$res->order_id])) {
                                        $pstpid = $tripData[$res->order_id]['id'];
                                        $pstodetailid = $tripData[$res->order_id]['stopdetailsid'];
                                    }
                                }
                            } else {
                                if (isset($tripData[$res->order_id])) {
                                    $pstpid = $tripData[$res->order_id]['id'];
                                    $pstodetailid = $tripData[$res->order_id]['stopdetailsid'];
                                    $saccept = $eachStopDetails['sid'];
                                }
                            }
                        }
                        if ($eachStopDetails['status_code'] == "SV0130") {
                            if ($eachStopDetails['id'] != "" && $eachStopDetails['stop_type'] == "P") {
                                $pstpid = $eachStopDetails['stop_id'];
                                $pstodetailid = $eachStopDetails['stop_detail_id'];
                                $sgatein = $eachStopDetails['status_id'];
                                if ($status_orderid == $ordid) {
                                    $s_sgatein = 1;
                                    $s_sgateincr = date('d-m-Y H:i:s', strtotime($eachStopDetails['createdon'] ?? ""));
                                }
                            } else {
                                if (isset($shipOrderStopsByPickOrDropId[$res->order_id])) {
                                    $pstpid = $shipOrderStopsByPickOrDropId[$res->order_id]['id'];
                                    $pstodetailid = $shipOrderStopsByPickOrDropId[$res->order_id]['stopdetailsid'];
                                    $sgatein = $eachStopDetails['sid'];
                                }
                            }
                        }

                        if ($eachStopDetails['status_code'] == 'SV0310') {
                            if ($eachStopDetails['id'] != "" && $eachStopDetails['stop_type'] == "D") {
                                $dstpid = $eachStopDetails['stop_id'];
                                $dstodetailid = $eachStopDetails['stop_detail_id'];
                                $dgatein = $eachStopDetails['status_id'];
                                if ($status_orderid == $ordid) {
                                    $s_dgatein = 1;
                                    $s_dgateincr = date('d-m-Y H:i:s', strtotime($eachStopDetails['createdon'] ?? ""));
                                }
                            } else {
                                if (isset($tripData[$res->order_id])) {
                                    $dstpid = $tripData[$res->order_id]['id'];
                                    $dstodetailid = $tripData[$res->order_id]['stopdetailsid'];
                                    $dgatein = $eachStopDetails['sid'];
                                }
                            }
                        }

                        if ($eachStopDetails['status_code'] == 'SV0131') {
                            if ($eachStopDetails['id'] != "" && $eachStopDetails['stop_type'] == "P") {
                                $pstpid = $eachStopDetails['stop_id'];
                                $pstodetailid = $eachStopDetails['stop_detail_id'];
                                $spickup = $eachStopDetails['status_id'];
                                if ($status_orderid == $ordid) {
                                    $s_spickup = 1;
                                    $s_spickupcr = date('d-m-Y H:i:s', strtotime($eachStopDetails['createdon']));
                                }
                            } else {
                                if (isset($tripData[$res->order_id])) {
                                    $pstpid = $tripData[$res->order_id]['id'];
                                    $pstodetailid = $tripData[$res->order_id]['stopdetailsid'];
                                    $spickup = $eachStopDetails['sid'];
                                }
                            }
                        }

                        if ($eachStopDetails['status_code'] == 'SV0410') {
                            if ($eachStopDetails['id'] != "" && $eachStopDetails['stop_type'] == "D") {
                                $dstpid = $eachStopDetails['stop_id'];
                                $dstodetailid = $eachStopDetails['stop_detail_id'];
                                $dpickup = $eachStopDetails['status_id'];
                                if ($status_orderid == $ordid) {
                                    $s_dpickup = 1;
                                    $s_dpickupcr = date('d-m-Y H:i:s', strtotime($eachStopDetails['createdon']));
                                }
                            } else {
                                if (isset($tripData[$res->order_id])) {
                                    $dstpid = $tripData[$res->order_id]['id'];
                                    $dstodetailid = $tripData[$res->order_id]['stopdetailsid'];
                                    $dpickup = $eachStopDetails['sid'];
                                }
                            }
                        }

                        if ($eachStopDetails['status_code'] == 'SV0140') {
                            if ($eachStopDetails['id'] != "" && $eachStopDetails['stop_type'] == "P") {
                                $pstpid = $eachStopDetails['stop_id'];
                                $pstodetailid = $eachStopDetails['stop_detail_id'];
                                $sgateout = $eachStopDetails['status_id'];
                                if ($status_orderid == $ordid) {
                                    $s_sgateout = 1;
                                    $s_sgateoutcr = date('d-m-Y H:i:s', strtotime($eachStopDetails['createdon']));
                                }
                            } else {
                                if (isset($tripData[$res->order_id])) {
                                    $pstpid = $tripData[$res->order_id]['id'];
                                    $pstodetailid = $tripData[$res->order_id]['stopdetailsid'];
                                    $sgateout = $eachStopDetails['sid'];
                                }
                            }
                        }

                        if ($eachStopDetails['status_code'] == 'SV0510') {
                            if ($eachStopDetails['id'] != "" && $eachStopDetails['stop_type'] == "D") {
                                $dstpid = $eachStopDetails['stop_id'];
                                $dstodetailid = $eachStopDetails['stop_detail_id'];
                                $dgateout = $eachStopDetails['status_id'];
                                if ($status_orderid == $ordid) {
                                    $s_dgateout = 1;
                                    $s_dgateoutcr = date('d-m-Y H:i:s', strtotime($eachStopDetails['createdon']));
                                }
                            } else {
                                if (isset($tripData[$res->order_id])) {
                                    $dstpid = $tripData[$res->order_id]['id'];
                                    $dstodetailid = $tripData[$res->order_id]['stopdetailsid'];
                                    $dgateout = $eachStopDetails['sid'];
                                }
                            }
                        }

                        if ($eachStopDetails['status_code'] == 'SV0230') {
                            if ($eachStopDetails['id'] != "") {
                                $pstpid = $eachStopDetails['stop_id'];
                                $pstodetailid = $eachStopDetails['stop_detail_id'];
                                $intransit = $eachStopDetails['status_id'];
                                if ($status_orderid == $ordid) {
                                    $s_intransit = 1;
                                    $s_intransitcr = date('d-m-Y H:i:s', strtotime($eachStopDetails['createdon']));
                                }
                            } else {
                                if (isset($tripData[$res->order_id])) {
                                    $pstpid = $tripData[$res->order_id]['id'];
                                    $pstodetailid = $tripData[$res->order_id]['stopdetailsid'];
                                    $intransit = $eachStopDetails['sid'];
                                }
                            }
                        }
                    }
                } else {
                    if (isset($shipOrderDetails[$res->order_id])) {
                        foreach ($shipOrderDetails[$res->order_id] as $res1) {
                            $close = $statusIds['SV0610'] ?? 0;
                            if ($res1['stoptype'] == "P") {
                                $saccept = $statusIds['SV0120'] ?? 0;
                                $sgatein = $statusIds['SV0130'] ?? 0;
                                $spickup = $statusIds['SV0131'] ?? 0;
                                $sgateout = $statusIds['SV0140'] ?? 0;
                                $intransit = $statusIds['SV0230'] ?? 0;
                                $pstpid = $res1['id'];
                                $pstodetailid = $res1['stopdetailsid'];
                            }
                            if ($res1['stoptype'] == "D") {
                                $dgatein = $statusIds['SV0310'] ?? 0;
                                $dpickup = $statusIds['SV0410'] ?? 0;
                                $dgateout = $statusIds['SV0510'] ?? 0;
                                $dstpid = $res1['id'];
                                $dstodetailid = $res1['stopdetailsid'];
                            }
                        }
                    }
                }
                if ($s_sgateincr != '' || $s_spickupcr != '' || $s_sgateoutcr != '') {
                    $removeTripFromOrderFlag = true;
                }
                $data['tripsdata'][] = [
                    "trip_id" => $tripid,
                    "ship_id" => $ship_id,
                    "ord_id" => $ordid,
                    "shipmentid" => $shipmentid,
                    "order_id" => $res->order_id,
                    "refers" => $refers,
                    "saccept" => $saccept,
                    "sgatein" => $sgatein,
                    "spickup" => $spickup,
                    "sgateout" => $sgateout,
                    "intransit" => $intransit,
                    "dgatein" => $dgatein,
                    "dpickup" => $dpickup,
                    "dgateout" => $dgateout,
                    "s_saccept" => $s_saccept,
                    "s_sgatein" => $s_sgatein,
                    "s_spickup" => $s_spickup,
                    "close" => $close ?? 0,
                    "s_sgateout" => $s_sgateout,
                    "s_intransit" => $s_intransit,
                    "s_dgatein" => $s_dgatein,
                    "s_dpickup" => $s_dpickup,
                    "s_dgateout" => $s_dgateout,
                    "s_sacceptcr" => $s_sacceptcr,
                    "s_sgateincr" => $s_sgateincr,
                    "s_spickupcr" => $s_spickupcr,
                    "s_sgateoutcr" => $s_sgateoutcr,
                    "s_intransitcr" => $s_intransitcr,
                    "s_dgateincr" => $s_dgateincr,
                    "s_dpickupcr" => $s_dpickupcr,
                    "s_dgateoutcr" => $s_dgateoutcr,
                    "pstpid" => $pstpid,
                    "dstpid" => $dstpid,
                    "pstodetailid" => $pstodetailid,
                    "dstodetailid" => $dstodetailid,
                    "vehicle_id" => $vehicle_id,
                    "driver_id" => $driver_id,
                    "tracktype" => $tracktype,
                    "trackvendor" => $trackvendor,
                    "simcarrier" => $simcarrier,
                    "contact_num" => $contact_num,
                    "multiship" => $multiship,
                    "actual_carrier_acceptance" => $res->actual_carrier_acceptance,
                    "removeTripFromOrderFlag" => $removeTripFromOrderFlag
                ];
            }
        }
        $data['list_type'] = $list_type;
        $data['excel_uploaddata'] = $excel_uploaddata;
        $data['postdata'] = $post;
        $data['curtz'] = $curtz;
        $this->newtemplate->dashboard("admin/massstatus", $data);
    }

    public function checkEarlyLegStatus(array $post): bool
    {
        $shipmentId = $post['shipmentId'];
        $statusId = $post['statusId'];
        $stopType = $post['stopType'];
        if ($shipmentId == "") {
            return false;
        }
        $getShiftId = $this->common->gettblrowdata(['shipmentId' => $shipmentId], "id", "tb_shifts", 0, 0);
        if (empty($getShiftId)) {
            return false;
        }
        $shiftRowId = $getShiftId['id'];
        if ($shiftRowId == 0) {
            return false;
        }
        if ($stopType != "") {
            $where = ['shipment_id' => $shiftRowId, 'status_id' => $statusId, 'status' => '1', 'stop_type' => $stopType];
        } else {
            $where = ['shipment_id' => $shiftRowId, 'status_id' => $statusId, 'status' => '1'];
        }
        $checkStatus = $this->common->gettblrowdata($where, "id", "tb_stop_status", 0, 0);
        if (empty($checkStatus)) {
            return true;
        } else {
            return false;
        }
    }

public function update_order_status(){

    $arr = array();
    $trip_id = $arr['trip'] = $this->input->post("trip_id",true);
    $ship_id = $arr['ship'] = $this->input->post("ship_id",true);
    $ord_id = $arr['ord_id'] = $this->input->post("ord_id",true);
    $orderid = $arr['orderid'] = $this->input->post("orderid",true);
    $stopid = $arr['stopid'] = $this->input->post("stopid",true);
    $stopdetailid = $arr['stopdetailid'] = $this->input->post("stopdetid",true);
    $vehicle_id = $arr['vehicle_id'] = $this->input->post("vehicle_id",true);
    $driver_id = $arr['driver_id'] = $this->input->post("driver_id",true);
    $tracktype = $arr['tracktype'] = $this->input->post("tracktype",true);
    $trackvendor = $arr['trackvendor'] = $this->input->post("trackvendor",true);
    $contact_num = $arr['contact_num'] = $this->input->post("contact_num",true);
    $stype = $arr['stop_type'] = $this->input->post("stop_type",true);
    $stsid = $arr['stsid'] = $this->input->post("stsid",true);
    $sts = $arr['status'] = $this->input->post("status",true);
    $curtz = $arr['timezone'] = $this->session->userdata("usr_tzone")['timezone'];
    $seldt = $stsdate = $this->input->post("sts_date",true);
    
    $company_code = $this->session->userdata('company_code');
    $branch_code = $this->session->userdata('branch_code');
    $crossborder = $this->input->post('crossborder') ?? '0';
    if($crossborder >0){
        $earlyShipmentId = $this->input->post('earlyShipmentId') ?? "";
        $earlyStatusId = $this->input->post('earlystatusId') ?? "";
        $earlyStopTypeId = $this->input->post('earlyStopType') ?? "";
        if($earlyShipmentId != ""){
            if($this->checkEarlyLegStatus(['shipmentId'=>$earlyShipmentId,'statusId'=>$earlyStatusId,'stopType'=>$earlyStopTypeId])){
                echo 3;
                return;
            }
        }
    }
    if ($this->session->userdata('user_role_id') === "5") {
        $statusReason = "From KNOps";
    } else {
        $statusReason = "From Admin";
    }
    if(checkstsvaliddate($seldt)){
        $gentime = getdatetimebytimezone(DFLT_TZ,$seldt,$curtz);
        $stsdate = $gentime['datetime'];
    }else{
        $stsdate = "";
    }
    $arr['sts_date'] = $stsdate;
    $logdate = date('Y-m-d H:i:s');
    $getactual = getdatetimebytimezone(DFLT_TZ,$logdate,$curtz);
    $curdt = $getactual['datetime'];
    $hrs = $this->session->userdata("usr_tzone")['hrs'];
    $lgusrid = $this->session->userdata("user_id");
    $getOrderDetails = $this->Completedordersmodel->getOrderDetailsWithLatLngs($ord_id);
    $createdsource = $getOrderDetails['createdSource'];
    $plat = $getOrderDetails['plat'];
    $plng = $getOrderDetails['plng'];
    $dlat = $getOrderDetails['dlat'];
    $dlng = $getOrderDetails['dlng'];
    $customerId = $getOrderDetails['customer_id'];
    $tripid = $trip_id;
    $resultsts = 2;
       if($stsdate != "" && $sts == "0"){
           if ($vehicle_id > 0) {
               $this->common->updatetbledata("tb_trucks_data", ['latitude' => $stype === 'D' ? $dlat : $plat, 'longitude' => $stype === 'D' ? $dlng : $plng, 'receivedon' => $stsdate], ['id' => $vehicle_id]);
           }
            $stid = $stsid;
            if ($stsid == "273") {
                $stcode = "SV0120";
            }
            if ($stsid == "274" && $stype == "P") {
                $stcode = "SV0130";
            }
            if ($stsid == "285" && $stype == "P") {
                $stcode = "SV0131";
            }
            if ($stsid == "275" && $stype == "P") {
                $stcode = "SV0140";
            }
            if ($stsid == "278") {
                $stcode = "SV0230";
            }
            if ($stsid == "279" && $stype == "D") {
                $stcode = "SV0310";
            }
            if ($stsid == "280" && $stype == "D") {
                $stcode = "SV0410";
            }
            if ($stsid == "281" && $stype == "D") {
                $stcode = "SV0510";
            }
            if ($stsid == "299") {
                $stcode = "SV0610";
            }
           $arr['status_code'] = $stcode;
           if ($this->session->userdata('company_code') == 'UKKN-CG' && $stcode != "SV0120") {
               $this->openbox_status_execution->pushStatusExecutionXml(["status" => $stcode, "order_row_id" => $ord_id, "trip_id" => $arr['trip'], "date_time" => $stsdate, "lat" => $latitude ?? "", "long" => $longitude ?? ""]);
           }

           if($stsid == "273" && $arr['trip'] == "0"){
             $stcode = "SV0120";
             /*start trip*/
             $chqry = $this->db->select("id")->get_where("tb_trips",array('shift_id'=>$arr['ship'], 'vehicle_id'=>$arr['vehicle_id'], 'driver_id'=>$arr['driver_id']),1,0);
             if($chqry->num_rows() == 0){
                if($arr['contact_num'] == ""){
                    $newimei = $this->db->select("imei")->get_where("tbl_assigned_drivers",array('vehicle_id'=>$arr['vehicle_id'],'driver_id'=>$arr['driver_id'],'status'=>1),1,0);
                    if($newimei->num_rows()>0){
                        $arr['contact_num'] = $newimei->row()->imei;
                    }
                }
                $latitude = $plat;
                $longitude = $plng;

                if($this->session->userdata('company_code')=='PLKN'){
                     $getveh = $this->db->select("latitude,longitude")->get_where("tb_trucks_data",array("id"=>$arr['vehicle_id']),1,0);
                    if($getveh->num_rows()>0){
                        $latitude = $getveh->row()->latitude;
                        $longitude = $getveh->row()->longitude;
                    }
                }

                $triparr = array('shift_id'=>$arr['ship'], 'vehicle_id'=>$arr['vehicle_id'], 'driver_id'=>$arr['driver_id'], 'stime'=>$stsdate, 'start_imei'=>$arr['contact_num'], 'splace'=>"", 'eplace'=>"", 'start_reading'=>0, 'end_reading'=>0, 'created_on'=>$stsdate, 'updated_on'=>$curdt, 'status'=>1, 'trip_type'=>0, 'transit_status'=>0,"plat"=>$latitude,"plng"=>$longitude);
                $arr['trip'] = $this->common->insertTableData('tb_trips', $triparr);
                $orders_under_shipment = $this->common->gettbldata(['shift_id' => $arr['ship']], 'id', 'tb_orders', 0, 0);

                    foreach ($orders_under_shipment as $eachOrder) {
                        $insarry = ["order_id" => $eachOrder['id'], "shipment_id" => $arr['ship'], "stop_id" => 0, "stop_detail_id" => 0, "stop_type" => "", "trip_id" => $arr['trip'], "status_id" => $stid, "latitude" => $latitude, "longitude" => $longitude, "status" => 1, "reason" => $statusReason, "vehicle_id" => $arr['vehicle_id'], "driver_id" => $arr['driver_id'], "status_code" => $stcode, "createdon" => $stsdate];
                        $ins = $this->db->insert("tb_stop_status", $insarry);
                    }
                    
                 /*$insarry = ["order_id" => $ord_id, "shipment_id" => $arr['ship'], "stop_id" => 0, "stop_detail_id" => 0, "stop_type" => "", "trip_id" => $arr['trip'], "status_id" => $stid, "latitude" => $latitude, "longitude" => $longitude, "status" => 1, "reason" => $statusReason, "vehicle_id" => $arr['vehicle_id'], "driver_id" => $arr['driver_id'], "status_code" => $stcode, "createdon" => $stsdate];
                 $ins = $this->db->insert("tb_stop_status", $insarry);*/
             }else{
                $arr['trip'] = $chqry->row()->id;
                $chqryx = $this->db->select("id")->get_where("tb_stop_status",array("order_id"=>$ord_id,"shipment_id"=>$arr['ship'],"status_id"=>$stid),1,0);
                if($chqryx->num_rows() == 0){
                    $insarry = ["order_id" => $ord_id, "shipment_id" => $arr['ship'], "stop_id" => 0, "stop_detail_id" => 0, "stop_type" => "", "trip_id" => $arr['trip'], "status_id" => $stid, "latitude" => $latitude, "longitude" => $longitude, "status" => 1, "reason" => $statusReason, "vehicle_id" => $arr['vehicle_id'], "driver_id" => $arr['driver_id'], "status_code" => $stcode, "createdon" => $stsdate];
                    $ins = $this->db->insert("tb_stop_status", $insarry);
                }
            }
            if($arr['trip'] > 0){
                /* update orders table */
                if ($crossborder > 0) {
                    $this->common->updatetbledata("tb_employee", ['trip_id' => $arr['trip']], ["shift_id" => $arr['ship']]);
                } else {
                    $this->common->updatetbledata("tb_orders", ['trip_id' => $arr['trip']], ["shift_id" => $arr['ship']]);
                }
                $postdata = array(
                    "shipment_id" => $arr['ship'],
                    "trip_id"     => $arr['trip'],
                    "driver_id"   => $arr['driver_id'],
                    "vehicle_id"  => $arr['vehicle_id'],
                    "order_id"    => $arr['orderid'],
                    "user_id"    => $lgusrid,
                    "stop_id"     => '',
                    "latitude"    => $latitude,
                    "longitude"   => $longitude,
                    "curtz"   => $curtz,
                    "hrs" => $hrs,
                    "web"  => $seldt,
                    "status_code"  => $stcode,
                    "ord_id"  => $ord_id
                );
                if (checkAccessConditions("CHECK_STS_REFERENCE_COUNTRIES", $company_code)) {
                    $getshipmentOrders = $this->common->gettbldata(['shift_id' => $arr['ship']], "id", "tb_orders", 0, 0);
                    if (!empty($getshipmentOrders)) {
                        foreach ($getshipmentOrders as $shipmentOrder) {
                            $shipmentOrderID = $shipmentOrder['id'];
                            $ins_ref = ['order_id' => $shipmentOrderID, 'reference_id' => 'STS'];
                            $checkSTSRef = $this->common->gettblrowdata($ins_ref, "id", "tb_order_references", 0, 0);
                            if (count($checkSTSRef) == 0) {
                                $ins_ref['ref_value'] = "Active";
                                $this->common->insertTableData("tb_order_references", $ins_ref);
                            } else {
                                $this->common->updatetbledata('tb_order_references', ['ref_value' => "Active"], $ins_ref);
                            }
                        }
                    }
                }
				
					$getvendorname = $this->db->select("vendor_id")->get_where("tb_shifts", ['id' => $arr['ship'], 'status' => '1']);
					if ($getvendorname->num_rows() > 0) {
						$vendor_id = $getvendorname->row()->vendor_id;
						$gettollvendorname = $this->db->select("name")->get_where("tb_vendors", ['id' => $vendor_id, 'name' => 'TOLL NETWORKS (NZ) LTD']);
						if ($gettollvendorname->num_rows() > 0) {
							$getTOLLfile = $this->tollcarrieredi->shipmentdata($arr['ship']);
						}
                        if (checkAccessConditions('CHECK_ALTOVA_NZ_CARRIERS', $vendor_id)) {
                            $carrierStatus = $this->carriercommonedilib->shipmentdata($arr['ship']);
                        }
                        try {
                            $carrierEDIDetails = $this->common->carrierEDIDetails($vendor_id);
                            if (!empty($carrierEDIDetails)) {
                                if ($carrierEDIDetails["editype"] == "P") {
                                    if ($carrierEDIDetails["ediservice"] == "Web Services") {
                                        $response = $this->carrierstandardtripoutbound->shipmentdata($arr['ship']);
                                    }
                                }
                                if ($carrierEDIDetails["editype"] == "T") {
                                    $response = $this->carriercommonedilib->shipmentdata($arr['ship']);
                                }
                            } else {
                                $message = "Carrier Does not have permission " . $arr['ship'] . $vendor_id;
                                $this->carrierstandardtripoutbound->sendEmailNotification($arr['ship'], $message);
                                log_message("error", $message);
                            }
                        } catch (Exception $ex) {
                            $message = "Trip sending Failed to Carrier " . $arr['ship'] . $vendor_id .  $ex->getMessage();
                            $this->carrierstandardtripoutbound->sendEmailNotification($arr['ship'], $message);
                            log_message("error", "Trip sending Failed to Carrier " . $arr['ship'] . $vendor_id .  $ex->getMessage());
                        }
					}

                $resultsts = 1;
                /**
                 * Description:
                  Initially
                  if created Source value = '18' then it will refers Roadlog
                  if created Source value = '8' then it will refers shippeo
                  But Now the process is changed,Both Roadlog and Shippeo will create their orders from the same Source i.e., Roadlog.So, They will represent same created source value i.e., '0'.
                  Now,We will differentiate Roadlog and Shippeo Orders based on ABO Reference values and Company Code.
                  Here,ABO Reference Values taking from Roadlog XML.
                 */
                if($createdsource == self::ROADLOG_ORDER_SOURCE){
                    if(!$isShippeoEventTriggred){
                        $edi_reference = $this->shippeostatusintigration->is_shippeo_order($ord_id, $company_code, $branch_code);
                        if ($edi_reference != 0) {
                            $isShippeoEventTriggred = true;
                            $sts = $this->shippeostatusintigration->shippeo_event_call($ord_id, $postdata, $curtz, $stid, $stype, $arr['vehicle_id'], $edi_reference, $company_code, $branch_code, $lgusrid);
                        }
                    }
                    $sts = $this->statusintigration->roadlogshipmentconfirm($postdata);
                } else if($createdsource == self::SALOG_ORDER_SOURCE){
                    $sts = $this->statusintigration->salogshipmentstatus($postdata);
                } else if($createdsource == self::ETNQUOTE_ORDER_SOURCE){
                    $sts = $this->svkonektquote->getstatusresponse($postdata);
                } else if($createdsource == self::SHIPPEO_ORDER_SOURCE) {

                    if(FALSE){
                        $logdate = date('Y-m-d H:i:s');
                        $getactual = getdatetimebytimezone(DFLT_TZ,$logdate,$curtz);
                        $cur_date = $getactual['datetime'];
                        $postdata['date_transmission'] = $cur_date;
                        $postdata["truck_number"] = null;
                        $vehicle_id = $this->db->escape($arr['vehicle_id']);
                        $sql = "SELECT truck_number FROM tb_trucks_data WHERE id = ? LIMIT 1";
                        $chktruck = $this->db->query($sql, [$vehicle_id]);
                        if($chktruck->num_rows() > 0) {
                            $postdata["truck_number"] = $chktruck->row()->truck_number;
                        }
                        $postdata["edi_reference"] = null;
                        $chkreference = $this->common->gettblrowdata(array('order_id'=>$ord_id,'reference_id'=>'EDI'),'ref_value','tb_order_references',0,0);
                        if(!empty($chkreference)) {
                            $postdata["edi_reference"] = $chkreference['ref_value'];
                        }
                        if($stid == "10") {
                            // Driver Accept
                            $postdata['situation_code'] = 'EML';
                            $postdata['justification_code'] = 'CFM';
                            $sts = $this->shippeostatusintigration->shippeoStatusUpdate($postdata);
                        }
                        if($stid == "2" && $stype == "P") {
                            // GATEIN
                            $postdata['situation_code'] = 'EML';
                            $postdata['justification_code'] = 'ARS';
                            $sts = $this->shippeostatusintigration->shippeoStatusUpdate($postdata);
                        }
                        if($stid == "1" && $stype == "P") {
                            // GATEIN PICKUP
                            $postdata['situation_code'] = 'ECH';
                            $postdata['justification_code'] = 'CFM';
                            $sts = $this->shippeostatusintigration->shippeoStatusUpdate($postdata);
                        }
                        if($stid == "4" && $stype == "P") {
                            // In-Transit
                            $postdata['situation_code'] = 'MLV';
                            $postdata['justification_code'] = 'CFM';
                            $sts = $this->shippeostatusintigration->shippeoStatusUpdate($postdata);
                        }
                        if($stid == "1" && $stype == "D") {
                            // Destination - delivery
                            $postdata['situation_code'] = 'LIV';
                            $postdata['justification_code'] = 'CFM';
                            $sts = $this->shippeostatusintigration->shippeoStatusUpdate($postdata);
                        }
                        if($stid == "3" && $stype == "D") {
                            // Destination - Gateout
                            $session_ccode = $this->session->userdata('company_code');
                            $postdata['situation_code'] = 'LIV';
                            $postdata['justification_code'] = 'DES';
                            $sts = $this->shippeostatusintigration->shippeoStatusUpdate($postdata);
                            if($session_ccode == "PLKN"){
                                $postdata['company_code'] = $session_ccode;
                                $session_currency = $this->session->userdata("usr_tzone")['currency'];
                                $post['currency'] = $session_currency;
                            }
                        }
                    }
                } else if($createdsource == self::MACADAM_ORDER_SOURCE){
                    $sts = $this->macdamstatusintigration->macdamshipmentconfirm($postdata);
                } else if($createdsource == self::KNLOGIN_ORDER_SOURCE) {
                    $sts = $this->knlogin->knloginshipmentstatus($postdata);
                }
                $note = $this->sendnotify('driver_accept',$arr['ord_id']);

                }
               $checkStatus = "RELATED_2_" . $company_code . "_CONSIGNEE_NOTIFICATION_STATUSES";
               if (checkAccessConditions('RELATED_2_CONSIGNEE_NOTIFICATION', $company_code) && checkAccessConditions($checkStatus, $stcode)) {
                   $this->load->library('notifytrigger');
                   $this->notifytrigger->sendNotificationToConsignee($arr['orderid'], $stcode);
               }
                if (checkAccessConditions('WECHAT_COUNTRY', $this->session->userdata('company_code')))
                {
                    $this->load->library('Wechat');
                    $this->wechat->orderId = $arr['orderid'];
                    $this->wechat->sendNotificationsToWeChat();
                }
            }else if($arr['trip'] != "0" && $stid != "299"){
                $statusData = [
                    "order_id"=>$ord_id,
                    "shipment_id"=>$arr['ship'],
                    "stop_id"=>$stopid,
                    "stop_detail_id"=>$stopdetailid,
                    "stop_type"=>$stype,
                    "trip_id"=>$arr['trip'],
                    "status_id"=>$stid
                ];
                $chqry = $this->db->select("id")->get_where("tb_stop_status",$statusData,1,0);
                if($chqry->num_rows() == 0){
                    if($stid == "2" && $stype == "P"){
                        $ttdata = array("id"=>$arr['trip']);
                        $data2["updated_on"] = $curdt;
                        $data2["transit_status"] = '1';
                        $res = $this->db->set($data2)->where($ttdata)->update("tb_trips");
                    }
                    if($stype == "P" || $stid == "4"){
                        $latitude = $plat;
                        $longitude = $plng;
                    }
                    if($stype == "D"){
                        $latitude = $dlat;
                        $longitude = $dlng;
                    }

                    $insarry = ["order_id" => $ord_id, "shipment_id" => $arr['ship'], "stop_id" => $stopid, "stop_detail_id" => $stopdetailid, "stop_type" => $stype, "trip_id" => $arr['trip'], "status_id" => $stid, "latitude" => $latitude, "longitude" => $longitude, "status" => 1, "reason" => $statusReason, "vehicle_id" => $arr['vehicle_id'], "driver_id" => $arr['driver_id'], "status_code" => $stcode, "createdon" => $stsdate];
                    $ins = $this->db->insert("tb_stop_status", $insarry);
                    $chqry1 = $this->db->select("id")->get_where("tb_trip_employee",array("employee_id"=>$stopdetailid,"stop_id"=>$stopid,"trip_id"=>$arr['trip'],"status"=>1),1,0);
                    if($chqry1->num_rows() == 0){
                        $insarr = array("employee_id"=>$stopdetailid,"stop_id"=>$stopid,"trip_id"=>$arr['trip'],"status"=>1, 'driver_late'=>0, 'emp_late'=>0, 'stime'=>$curdt, 'check_in'=>$curdt, 'absent_reason'=>'Closed', 'created_on'=>$curdt, 'updated_on'=>$curdt, 'pd_status'=>1);
                        $ins = $this->db->insert("tb_trip_employee",$insarr);
                    }
                    $postdata = array(
                        "shipment_id" => $arr['ship'],
                        "trip_id"     => $arr['trip'],
                        "driver_id"   => $arr['driver_id'],
                        "stop_id"     => $stopid,
                        "order_id"    => $arr['orderid'],
                        "inc_id"      => 0,
                        "pod_type"    => '',
                        "latitude"    => $latitude,
                        "longitude"   => $longitude,
                        "stop_type" => $stype,
                        "vehicle_id" => $arr['vehicle_id'],
                        "curtz" => $curtz,
                        "hrs" => $hrs,
                        "web"  => $seldt,
                        "status_code"  => $stcode,
                        "ord_id"  => $ord_id
                    );
                    if($stid == "1" && $stype == "P" && $createdsource != self::SALOG_ORDER_SOURCE){
                        $this->sendnotify('pickup_note',$arr['ord_id']);
                    }
                    if($stid == "1" && $stype == "D" && $createdsource != self::SALOG_ORDER_SOURCE) {
                        $this->sendnotify('delivery_note', $arr['ord_id']);
                    }
                    if($createdsource == self::ROADLOG_ORDER_SOURCE){
                        if(!$isShippeoEventTriggred){
                            $edi_reference = $this->shippeostatusintigration->is_shippeo_order($ord_id, $company_code, $branch_code);
                            if ($edi_reference != 0 ) {
                                $isShippeoEventTriggred = true;
                                $sts = $this->shippeostatusintigration->shippeo_event_call($ord_id, $postdata, $curtz, $stid, $stype, $arr['vehicle_id'], $edi_reference, $company_code, $branch_code, $lgusrid);
                            }
                        }
                        if ($stid == "4") {
                            /*send to roadlog*/
                            $sts = $this->statusintigration->roadlogshipmentintransit($postdata);
                        }
                        if ($stid == "2" && $stype == "P") {
                            $sts = $this->statusintigration->roadlogshipmentpgatein($postdata);
                        }
                        if ($stid == "1" && $stype == "P") {
                            $sts = $this->statusintigration->roadlogshipmentpicked($postdata);
                        }
                        if ($stid == "3" && $stype == "P") {
                            $sts = $this->statusintigration->roadlogshipmentpgateout($postdata);
                        }
                        if ($stid == "2" && $stype == "D") {
                            $sts = $this->statusintigration->roadlogshipmentdgatein($postdata);
                        }
                        if ($stid == "1" && $stype == "D") {
                            $sts = $this->statusintigration->roadlogshipmentdelivered($postdata);
                        }
                    }else if($createdsource == self::SALOG_ORDER_SOURCE){
                        if($stid == "1" && $stype == "P"){
                            $sts = $this->statusintigration->salogshipmentstatus($postdata);
                        }
                        if($stid == "1" && $stype == "D"){
                            $sts = $this->statusintigration->salogshipmentstatus($postdata);
                        }
                        if($stid == "3" && $stype == "P"){
                            $sendDocument = $this->salogintegrateservice->sendePodToSalog($postdata, "PUP");
                        }
                        if($stid == "3" && $stype == "D"){
                            $sendDeliverStatus = $this->statusintigration->salogshipmentstatus($postdata);
                            $sendDocument = $this->salogintegrateservice->sendePodToSalog($postdata, "DEL");
                        }
                    }else if($createdsource == self::ETNQUOTE_ORDER_SOURCE){
                        if($stid == '4' || ($stid == "1" && $stype == "P") || ($stid == "3" && $stype == "D")){
                            $postdata['user_id'] = $lgusrid;
                            if($stid == "1" && $stype == "P"){
                            }
                            $sts = $this->svkonektquote->getstatusresponse($postdata);
                        }
                    } else if($createdsource == self::SHIPPEO_ORDER_SOURCE) {
                        if(FALSE){
                            $logdate = date('Y-m-d H:i:s');
                            $getactual = getdatetimebytimezone(DFLT_TZ,$logdate,$curtz);
                            $cur_date = $getactual['datetime'];
                            $postdata['date_transmission'] = $cur_date;
                            $postdata["truck_number"] = null;
                            $vehicle_id = $this->db->escape($arr['vehicle_id']);
                            $sql = "SELECT truck_number FROM tb_trucks_data WHERE id =? LIMIT 1";
                            $chktruck = $this->db->query($sql, [$vehicle_id]);
                            if($chktruck->num_rows() > 0) {
                                $postdata["truck_number"] = $chktruck->row()->truck_number;
                            }
                            $postdata["edi_reference"] = null;
                            $chkreference = $this->common->gettblrowdata(array('order_id'=>$ord_id,'reference_id'=>'EDI'),'ref_value','tb_order_references',0,0);
                            if(!empty($chkreference)) {
                                $postdata["edi_reference"] = $chkreference['ref_value'];
                            }
                            if($stid == "10") {
                            // Driver Accept
                                $postdata['situation_code'] = 'EML';
                                $postdata['justification_code'] = 'CFM';
                                $sts = $this->shippeostatusintigration->shippeoStatusUpdate($postdata);
                            }
                            if($stid == "2" && $stype == "P") {
                            // GATEIN
                                $postdata['situation_code'] = 'EML';
                                $postdata['justification_code'] = 'ARS';
                                $sts = $this->shippeostatusintigration->shippeoStatusUpdate($postdata);
                            }
                            if($stid == "1" && $stype == "P") {
                            // GATEIN PICKUP
                                $postdata['situation_code'] = 'ECH';
                                $postdata['justification_code'] = 'CFM';
                                $sts = $this->shippeostatusintigration->shippeoStatusUpdate($postdata);
                            }
                            if($stid == "4" && $stype == "P") {
                            // In-Transit
                                $postdata['situation_code'] = 'MLV';
                                $postdata['justification_code'] = 'CFM';
                                $sts = $this->shippeostatusintigration->shippeoStatusUpdate($postdata);
                            }
                            if($stid == "1" && $stype == "D") {
                            // Destination - delivery
                                $postdata['situation_code'] = 'LIV';
                                $postdata['justification_code'] = 'CFM';
                                $sts = $this->shippeostatusintigration->shippeoStatusUpdate($postdata);
                            }
                            if($stid == "3" && $stype == "D") {
                            // Destination - Gateout
                                $postdata['situation_code'] = 'LIV';
                                $postdata['justification_code'] = 'DES';
                                $sts = $this->shippeostatusintigration->shippeoStatusUpdate($postdata);
                            }
                        }
                    } else if($createdsource == self::MACADAM_ORDER_SOURCE){
                        if($stid == "4"){
                            $sts = $this->macdamstatusintigration->macdamshipmentintransit($postdata);
                        }
                        if($stid == "2" && $stype == "P"){
                            $sts = $this->macdamstatusintigration->macdamshipmentpgatein($postdata);
                        }
                        if($stid == "1" && $stype == "P"){
                            $sts = $this->macdamstatusintigration->macdamshipmentpicked($postdata);
                        }
                        if($stid == "3" && $stype == "P"){
                            /*send to macdamstatusintigration*/
                            $sts = $this->macdamstatusintigration->macdamshipmentpgateout($postdata);
                        }
                        if($stid == "2" && $stype == "D"){
                            $sts = $this->macdamstatusintigration->macdamshipmentdgatein($postdata);
                        }
                        if($stid == "1" && $stype == "D"){
                            $sts = $this->macdamstatusintigration->macdamshipmentdelivered($postdata);
                        }
                    } else if($createdsource == self::KNLOGIN_ORDER_SOURCE) {
                        $sts = $this->knlogin->knloginshipmentstatus($postdata);
                    }else if($createdsource == self::AMAZON_ORDER_SOURCE){
                        $this->load->library("amazonstatusintegration");
                        if($stid == "2" && $stype == "P"){
                            $postdata['status_code'] = "TL";
                            $sts = $this->amazonstatusintegration->updateOrderStatus($postdata);
                        }
                        if($stid == "1" && $stype == "P"){
                            $postdata['status_code'] = "CL";
                            $sts = $this->amazonstatusintegration->updateOrderStatus($postdata);
                        }
                        if($stid == "3" && $stype == "P"){
                            $postdata['status_code'] = "LY";
                            $sts = $this->amazonstatusintegration->updateOrderStatus($postdata);
                        }
                        if($stid == "2" && $stype == "D"){
                            $postdata['status_code'] = "TL";
                            $sts = $this->amazonstatusintegration->updateOrderStatus($postdata);
                        }
                        if($stid == "1" && $stype == "D"){
                            $postdata['status_code'] = "CL";
                            $sts = $this->amazonstatusintegration->updateOrderStatus($postdata);
                        }
                        if($stid == "3" && $stype == "D"){
                            $postdata['status_code'] = "LY";
                            $sts = $this->amazonstatusintegration->updateOrderStatus($postdata);
                        }
                        if($postdata['status_code'] == "LY"){
                            $chkmuliti = $this->db->select("id")->get_where("tb_orders",array("shift_id"=>$arr['ship'],"trip_sts"=>'0'));
                            if($chkmuliti->num_rows()>1){
                                $upd = $this->db->where(array("id"=>$ord_id,"trip_id !="=>0))->update("tb_orders",array("trip_sts"=>'1'));
                            }else{
                                $updwhr  = array("id" => $arr['ship']);
                                $upddata = array("status" => '0', "updated_on" => $curdt);
                                $upd = $this->db->set($upddata)->where($updwhr)->update("tb_shifts");
                                $data1 = array();
                                $tdata = array("id"=>$arr['trip']);
                                $data1["end_imei"] = $arr['contact_num'];
                                $data1["end_reading"] = '0';
                                $data1["etime"] = $data1["updated_on"] = $curdt;
                                $data1["status"] = '0';
                                $data1["transit_status"] = '1';
                                $res = $this->db->set($data1)->where($tdata)->update("tb_trips");
                                if ($arr['ship'] > 0) {
                                    $upd = $this->db->where(["shift_id" => $arr['ship']])->update("tb_orders", ["trip_sts" => '1']);
                                }
                                $gensum = $this->generatesummary($arr['trip'],$curtz);
                            }
                        }
                    }
                    $resultsts = 1;
                    if($stid == "3" && $stype == "D"){
                        /*send to roadlog*/
                        /**
                         * Description:
                          Initially
                          if created Source value = '0' then it will refers Roadlog
                          if created Source value = '8' then it will refers shippeo
                          But Now the process is changed,Both Roadlog and Shippeo will create their orders from the same Source i.e., Roadlog.So, They will represent same created source value i.e., '0'.
                          Now,We will differentiate Roadlog and Shippeo Orders based on ABO Reference values and Company Code.
                          Here,ABO Reference Values taking from Roadlog XML.
                          added try catch block for any blocker.
                         */
                        try {
                            if ($createdsource == self::ROADLOG_ORDER_SOURCE) {
                               
                                if(!$isShippeoEventTriggred){
                                    $edi_reference = $this->shippeostatusintigration->is_shippeo_order($ord_id, $company_code, $branch_code);
                                    if ($edi_reference != 0) {
                                        $isShippeoEventTriggred = true;
                                        $sts = $this->shippeostatusintigration->shippeo_event_call($ord_id, $postdata, $curtz, $stid, $stype, $arr['vehicle_id'], $edi_reference, $company_code, $branch_code, $lgusrid);
                                    }
                                }
                            } elseif ($createdsource == self::KNLOGIN_ORDER_SOURCE) {
                                $sts = $this->knlogin->knloginshipmentstatus($postdata);
                                $this->statusintigration->sendPodToKnlogin(3,$ord_id);
                            }
                            $postdata['checkEpodForCustomer'] = 0;
                            $postdata['customer_id'] = $customerId;
                            if (checkAccessConditions('SEND_EPOD_TO_SELECTED_CUSTOMERS', $customerId)) {
                                $postdata['checkEpodForCustomer'] = 1;
                            }
                            if ($createdsource == self::ROADLOG_ORDER_SOURCE || ($postdata['checkEpodForCustomer'] == 1)) {
                                $sts = $this->sendepodgateoutnotify($postdata);
                            }
                            $session_ccode = $this->session->userdata('company_code');
                            if ($session_ccode == "PLKN") {
                                $postdata['company_code'] = $session_ccode;
                                $session_currency = $this->session->userdata("usr_tzone")['currency'];
                                $post['currency'] = $session_currency;
                                $exchangerate = $this->exchangerate->updateexchangerate_byorderid($postdata);
                            }
                        } catch (Exception $ex) {
                            log_message("error", "Some Problem occured!, While Sending Status to Road Log and shippeo. " . $ex->getMessage());
                        }
                    }

                }

               $checkStatus = "RELATED_2_" . $company_code . "_CONSIGNEE_NOTIFICATION_STATUSES";
               if (checkAccessConditions('RELATED_2_CONSIGNEE_NOTIFICATION', $company_code) && checkAccessConditions($checkStatus, $stcode)) {
                   $this->load->library('notifytrigger');
                   $this->notifytrigger->sendNotificationToConsignee($arr['orderid'], $stcode);
               }
            }else if($stsid == "299" && $arr['trip'] != 0 && $arr['trip'] != ""){
                $latitude = $dlat;
                $longitude = $dlng;
                $postdata = array(
                    "shipment_id" => $arr['ship'],
                    "trip_id"     => $arr['trip'],
                    "driver_id"   => $arr["driver_id"],
                    "stop_id"     => '',
                    "order_id"    => $arr['orderid'],
                    "latitude"    => $latitude,
                    "longitude"   => $longitude,
                    "curtz"   => $curtz,
                    "hrs" => $hrs,
                    "web"  => $seldt
                );
               $insarry = [
                   "order_id" => $ord_id,
                   "shipment_id" => $arr['ship'],
                   "stop_id" => $stopid,
                   "stop_detail_id" => $stopdetailid,
                   "stop_type" => $stype,
                   "trip_id" => $arr['trip'],
                   "status_id" => $stid,
                   "latitude" => $latitude,
                   "longitude" => $longitude,
                   "status" => 1,
                   "reason" => $statusReason,
                   "vehicle_id" => $arr['vehicle_id'],
                   "driver_id" => $arr['driver_id'],
                   "status_code" => $stcode,
                   "createdon" => $stsdate
               ];
               $ins = $this->db->insert("tb_stop_status", $insarry);
               if (checkAccessConditions('RELATED_TO_KPIREPORTS', $this->session->userdata('company_code'))) {
                   $this->load->library("kpireportinsertion");
                   $this->kpireportinsertion->insertDataIntoKpiReports($ord_id);
               }
               if($crossborder >0){
                   $tripStatusCheck = 0;
                   $shiftIds = [];
                   $whereCondition = "id='".$arr['ship']."' AND shift_leg_id >0";
                   $checkShiftLegs = $this->common->gettblrowdata($whereCondition, "shift_leg_id", "tb_shifts", 0, 0);
                   if(!empty($checkShiftLegs)){
                       $shiftLegId = $checkShiftLegs['shift_leg_id'];
                       $getAllLegIds = $this->common->gettbldata(['shift_leg_id'=>$shiftLegId,'status'=>'1'],"id","tb_shifts",0,0);
                       if(count($getAllLegIds) >1){
                           foreach($getAllLegIds as $eachLegId){
                               $shiftIds[] = $eachLegId['id'];
                           }
                           $updateShifts = $this->common->updatetbledata("tb_shifts", ['status' => '0', 'updated_on' => $stsdate], ['id' => $arr['ship']]);
                           $updateTrips = $this->common->updatetbledata("tb_trips", ['end_imei' => $arr['contact_num'], 'end_reading' => '0', 'etime' => $curdt, 'updated_on' => $stsdate, 'status' => '0', 'transit_status' => '1'], ['id' => $arr['trip']]);
                           $checkPendingLegIds = $this->common->gettblrowdata("id IN (".implode(",",$shiftIds).") AND status ='1'","id","tb_shifts",0,0);
                           if(empty($checkPendingLegIds)){
                               $updateShifts = $this->common->updatetbledata("tb_shifts", ['status'=>'0'], ['id'=>$shiftLegId,'status'=>'1']);
                               $tripStatusCheck = 1;
                           }
                       }else{
                           $shiftIds = [$shiftLegId,$arr['ship']];
                           $updateShifts = $this->common->updatetbledata("tb_shifts", ['status'=>'0'], "id IN (".implode(",",$shiftIds).") AND status ='1'");
                           $updateTrips = $this->common->updatetbledata("tb_trips", ['end_imei'=>$arr['contact_num'],'end_reading'=>'0','etime'=>$curdt,'updated_on'=>$curdt,'status'=>'0','transit_status'=>'1'], ['id'=>$arr['trip']]);
                           $tripStatusCheck = 1;

                       }
                       if(!in_array('0', [$tripStatusCheck, $shiftLegId])){
                           $updateOrder = $this->common->updatetbledata("tb_orders", ['trip_sts'=>'1'], ['shift_id'=>$shiftLegId]);
                       }
                   }
               }else{
                   $chkmuliti = $this->db->select("id")->get_where("tb_orders",array("shift_id"=>$arr['ship'],"trip_sts"=>'0'));
                   if($chkmuliti->num_rows()>1){
                       $upd = $this->db->where(array("id"=>$ord_id,"trip_id !="=>0))->update("tb_orders",array("trip_sts"=>'1'));
                   }else{
                       $updwhr  = array("id" => $arr['ship']);
                       $upddata = array("status" => '0', "updated_on" => $curdt);
                       $upd = $this->db->set($upddata)->where($updwhr)->update("tb_shifts");
                       $data1 = array();
                       $tdata = array("id"=>$arr['trip']);
                       $data1["end_imei"] = $arr['contact_num'];
                       $data1["end_reading"] = '0';
                       $data1["etime"] = $data1["updated_on"] = $curdt;
                       $data1["status"] = '0';
                       $data1["transit_status"] = '1';
                       $res = $this->db->set($data1)->where($tdata)->update("tb_trips");
                       if ($arr['ship'] > 0) {
                           $upd = $this->db->where(["shift_id" => $arr['ship']])->update("tb_orders", ["trip_sts" => '1']);
                       }
                       $gensum = $this->generatesummary($arr['trip'], $curtz);
                   }
               }
               if (checkAccessConditions("CHECK_STS_REFERENCE_COUNTRIES", $company_code)) {
                   $ins_ref = ['order_id' => $ord_id, 'reference_id' => 'STS'];
                   $checkSTSRef = $this->common->gettblrowdata($ins_ref, "id", "tb_order_references", 0, 0);
                   if (count($checkSTSRef) > 0) {
                       $this->common->updatetbledata('tb_order_references', ['ref_value' => "Closed"], $ins_ref);
                   }else{
                       $ins_ref['ref_value'] = "Closed";
                       $this->common->insertTableData("tb_order_references", $ins_ref);
                   }
               }
                /*send to roadlog*/
                /**
                * Description:
                Initially
                if created Source value = '0' then it will refers Roadlog
                if created Source value = '8' then it will refers shippeo
                But Now the process is changed,Both Roadlog and Shippeo will create their orders from the same Source i.e., Roadlog.So, They will represent same created source value i.e., '0'.
                Now,We will differentiate Roadlog and Shippeo Orders based on ABO Reference values and Company Code.
                Here,ABO Reference Values taking from Roadlog XML.
                */
               try {
                   if ($createdsource == self::ROADLOG_ORDER_SOURCE) {
                      
                       if(!$isShippeoEventTriggred){
                           $edi_reference = $this->shippeostatusintigration->is_shippeo_order($ord_id, $company_code, $branch_code);
                           if ($edi_reference != 0) {
                               $sts = $this->shippeostatusintigration->shippeo_event_call($ord_id, $postdata, $curtz, $stid, $stype, $arr['vehicle_id'], $edi_reference, $company_code, $branch_code, $lgusrid);
                           }
                       }
                       $sts = $this->statusintigration->roadlogshipmenttripdelivered($postdata);
                   }
                   if ($createdsource == self::MACADAM_ORDER_SOURCE) {
                       $sts = $this->macdamstatusintigration->macdamshipmenttripdelivered($postdata);
                   } else {
                       if ($createdsource == self::KNLOGIN_ORDER_SOURCE) {
                           $sts = $this->knlogin->knloginshipmentstatus($postdata);
                       }
                   }
               } catch (Exception $ex) {
                   log_message("error", "Some Problem occured!, While Sending Status to Road Log and shippeo.");
               }
               $resultsts = 1;
           }
           if ($this->session->userdata('company_code') == 'UKKN-CG' && $stcode == "0212") {
               $this->openboxstatusaccept->pushStatusXml($arr['trip']);
           }
           if (($createdsource == self::SALOG_ORDER_SOURCE) && in_array($stcode, ['0200', '0220', '0500', '3000'])) {
               $this->load->library('notifytrigger');
               $this->notifytrigger->orderStatusNotification($arr['orderid'], $stcode, $seldt);
           }
            $domainDetails = $this->OtmBookingModel->getDomain($ord_id);
            if (!empty($domainDetails)) {
    			$extOrderId = $domainDetails[0]['external_order_id'];
    			$domainName = $domainDetails[0]['ref_value'];
                $domainCreatedSource = $domainDetails[0]['created_source'];
                if($domainName<>"")
               {
                   $otmRequest = [
                            'glogDate' => date("Ymdhis"),
                            'externalOrderId' => $extOrderId,
                            'orderStatusDateTime' => $stsdate,
                            'domainName' => $domainName,
                            'createdSource'=> $createdsource ? $createdsource :  $domainCreatedSource,
                            'timeZone' =>$curtz ?? "",
                            'orderStatusCode' => $stcode,
                        ];
                        
                    $output = sendOTMStatus($otmRequest);
               }
    		}
           try {
               $this->standard_status_execution->sendStandardXMLtoAltova($arr);
               $this->altovaordercreation->sendOrderToAltova($ord_id, $stcode);
           } catch (Exception $ex) {
               log_message("error", "Some Problem occured!, While Sending Status to Altova " . $ex->getMessage());
           }

       }
       echo $resultsts;
    }


    public function loadconfirmmail($post){
        $data['page_title'] = "Load Confirmed by Driver";
        $data['order_id'] = $post['order_id'];
        $driver_id = $post['driver_id'];
        $vehicle_id = $post['vehicle_id'];
        $data['user_id'] = $post['user_id'];
        $data['driver'] = $data['drivermobile'] = $data['register_number'] = "";
        $chk = $this->db->select("name,contact_num,user_id")->get_where("tb_truck_drivers",array("id"=>$driver_id),1,0);
        if($chk->num_rows()>0){
            $data['driver'] = $chk->row()->name;
            $data['user_id'] = $chk->row()->user_id;
            $data['drivermobile'] = $chk->row()->contact_num;
        }
        $chk1 = $this->db->select("register_number")->get_where("tb_trucks_data",array("id"=>$vehicle_id),1,0);
        if($chk1->num_rows()>0){
            $data['register_number'] = $chk1->row()->register_number;
        }
        $this->load->library('email');
        $chkven = $this->db->select("name,emailid")->get_where("tb_users",array("id"=>$data['user_id']),1,0);
        if($chkven->num_rows()>0){
            $receivename = $chkven->row()->name;
            $receivemail = $chkven->row()->emailid;
            $newsub = "svkonekt: Load Confirmed by Driver for Order#".$data['order_id'];
            $data['receivename'] = $receivename;
            if($receivemail != ""){
                $body = $this->load->view('mail_forms/confirmbydriver', $data, true);
                $this->email->from('svkonekt@kuehne-nagel.com', 'svkonekt');

                $this->email->to($receivemail, $receivename);

                $this->email->subject($newsub);
                $this->email->set_mailtype("html");
                $this->email->message($body);

                if(!$this->email->send()){
                    log_message("error",$this->email->print_debugger());
                }

                $this->email->clear(true);
          }
      }
  }
  /**
 * Send POD document jpl and pod to salog
 *
 *
 *
 * @author    Developer Name external.ram.k@kuehne-nagel.com
 * @date      30-03-2021 11:50:00+05.30
 * @change    Asia
 * @param     Array Order Info
 * @return    Boolean
 */
    public function sendepodgateoutnotify($postdata){
        /*check SDT Ref*/
        $sdtref = getsdtreforder($postdata['ord_id']);
        if($sdtref == "DEL" || $sdtref == ""){
            $order_id = $postdata['order_id'];
            $ship_id = $postdata['shipment_id'];
            $trip_id = $postdata['trip_id'];
            $stop_id = $postdata['stop_id'];
            $driver_id = $postdata['driver_id'];
            $vehicle_id = $postdata['vehicle_id'];
            $checkEpodForCustomer = $postdata['checkEpodForCustomer'] ?? 0;
            $customerId = $postdata['customer_id'] ?? 0;
            $curtz = $postdata['curtz'];
            $createdsource = 18;
            $ord_id = $postdata['ord_id'];
            $sql = "SELECT o.id,o.order_id,o.pickup_company,o.pickup_country,o.pickup_city,
            o.pickup_pincode, o.pickup_address1,o.delivery_company,o.delivery_country,o.delivery_city,
            o.delivery_pincode,o.delivery_address1, o.quantity,o.weight,o.volume,o.customer_id,o.user_id,
            o.created_source,c.name,c.gcm_id,c.company_code, c.branch_code,c.phone,c.code
            FROM tb_orders o,tb_customers c WHERE o.customer_id=c.id AND o.id=? LIMIT 1";
            $chkcust = $this->db->query($sql, [$ord_id]);
            if($chkcust->num_rows()>0){
                $ordid = $chkcust->row()->id;
                $cust_id = $chkcust->row()->customer_id;
                $user_id = $chkcust->row()->user_id;
                $cust_name = $chkcust->row()->name;
                $company_code = $chkcust->row()->company_code;
                $branch_code = $chkcust->row()->branch_code;
                $createdsource = $chkcust->row()->created_source;
                $custcid = $chkcust->row()->phone;
                $custcode = $chkcust->row()->code;
                $order_id = $chkcust->row()->order_id;
                $pickup_company = $chkcust->row()->pickup_company;
                $pickup_country = $chkcust->row()->pickup_country;
                $pickup_city = $chkcust->row()->pickup_city;
                $pickup_pincode = $chkcust->row()->pickup_pincode;
                $pickup_address1 = $chkcust->row()->pickup_address1;
                $delivery_company = $chkcust->row()->delivery_company;
                $delivery_country = $chkcust->row()->delivery_country;
                $delivery_city = $chkcust->row()->delivery_city;
                $delivery_pincode = $chkcust->row()->delivery_pincode;
                $delivery_address1 = $chkcust->row()->delivery_address1;
                $quantity = $chkcust->row()->quantity;
                $weight = $chkcust->row()->weight;
                $volume = $chkcust->row()->volume;
                $sql = "SELECT name,emailid,cc_mails FROM tb_users WHERE id=? AND emailid!='' LIMIT 1";
                $chkadminusr = $this->db->query($sql, [$user_id]);
                if($chkadminusr->num_rows()>0){
                    $receivename = $chkadminusr->row()->name;
                    $receivemail = $chkadminusr->row()->emailid;
                    $ccmail = array();
                    if($chkadminusr->row()->cc_mails != ""){
                        $ccmail[] = $chkadminusr->row()->cc_mails;
                    }
                    $data['order'] = array("order_id"=>$order_id,"pickup_company"=>$pickup_company,"pickup_country"=>$pickup_country,"pickup_city"=>$pickup_city,"pickup_pincode"=>$pickup_pincode,"pickup_address1"=>$pickup_address1,"delivery_company"=>$delivery_company,"delivery_country"=>$delivery_country,"delivery_city"=>$delivery_city,"delivery_pincode"=>$delivery_pincode,"delivery_address1"=>$delivery_address1,"quantity"=>$quantity,"weight"=>$weight,"volume"=>$volume);
                    $data['userid'] = $user_id;
                    $epodpath = "./assets/trippods/RL".$order_id.".pdf";
                    $documentId = $this->documentsequencelibrary->getSequence('ETN', $this->session->userdata("usr_tzone")['country'], '1');
                    $roadlogEpodPath = "./assets/trippods/".$documentId.".pdf";
                    $sql="SELECT ts.id,ts.latitude,ts.longitude,ts.stop_id,ts.stop_type,dt.type_name,ts.createdby,convertToClientTZ(ts.createdon,?) as createdon, ts.imgpath, ts.hash, e.address, e.pickup, e.drop,e.order_id
                        FROM tb_pod_uploads ts
                            INNER JOIN tb_document_types dt ON dt.id=ts.doc_type AND dt.type_name != 'PUP'
                            LEFT JOIN tb_employee e ON e.id = ts.stop_detail_id
                        WHERE ts.order_id = ? AND ts.status=1
                        GROUP BY ts.id
                        ORDER BY ts.createdon ASC";
                    $data["pod"] = $this->db->query($sql,[$curtz,$ordid]);
                    /* get all order references in single row*/
                    $data["orderref"] = $this->common->getallorderreferences($ordid);
                    $this->load->library('m_pdf');

                    if (checkAccessConditions('CHANGE_EPOD_EMAIL_SUBJECT_WITH_DQ_PO', $company_code)) {
                        $checkOrderReferences = $this->common->getOrderDQPOReferences($ordid);
                        $subRef = "";
                        foreach ($checkOrderReferences as $orderReference) {
                            $subRef .= " " . $orderReference->ref_value;
                        }
                        $sub = "svkonekt::Shipment ePOD & Milestone Status #" . $subRef . " ";
                    } else {
                        $sub = "svkonekt::Shipment ePOD & Milestone Status #" . $order_id . " ";
                    }
                    $data['page_title'] = "Trip ePOD";
                    $data['receivemail'] = $receivemail;
                    $data['receivename'] = $receivename;
                    $chkref = "XSR";
                    $whrin = " AND reference_id in('XSR','SD') ";
                    $sql="SELECT reference_id,ref_value FROM tb_order_references WHERE order_id=? $whrin AND ref_value!='' GROUP BY reference_id HAVING count(reference_id)>=1";
                    $chkordtypeqry = $this->db->query($sql,[$ordid]);
                    $refvalue = $newsub = $orderDepartmentCode = "";
                    $iofeof = "EOF";
                    if($chkordtypeqry->num_rows()>1){
                        $refs = array();
                        foreach($chkordtypeqry->result() as $oref){
                            $refs[] = $oref->ref_value;
                            if($oref->reference_id == "XSR"){
                                $refvalue = $oref->ref_value;
                            }
                            if($oref->reference_id == "SD" && $oref->ref_value == "2"){
                                $iofeof = "IOF";
                            }
                        }
                        $newsub = $refvalue."#746#".$iofeof;
                        $sub .= $chkref.":".$refvalue."#746#".$iofeof."";
                        $chkparty = "SELECT emailid,party_name FROM tb_contact_notifys WHERE status=1 AND (pod_note=1 OR all_note=1) GROUP BY emailid";
                        $query = $this->db->query($chkparty);
                        if($query->num_rows()>0){
                            foreach($query->result() as $pmails){
                                $ccmail[] = $pmails->emailid;
                            }
                        }
                    }
                    if($newsub == ""){
                        $newsub = $sub;
                    }
                    $data['mailtype'] = "ePOD";
                    $data['stops'] = array();
                    $data['pickup_datetime'] = "";
                    $data['delivery_datetime'] = "";
                    $shipment_id = $ship_id;
                    $status = "1";
                    $sql = "SELECT ss.stop_type,ss.status_id,ss.latitude,ss.longitude,convertToClientTZ(ss.createdon,?) as createdon,sm.status_name,t.register_number,d.name from tb_stop_status ss LEFT JOIN tb_status_master sm ON sm.id=ss.status_id LEFT JOIN tb_trucks_data t ON ss.vehicle_id=t.id LEFT JOIN tb_truck_drivers d ON ss.driver_id=d.id WHERE ss.shipment_id=? AND ss.status=? ORDER BY ss.createdon ASC";
                    $stops = $this->db->query($sql, [$curtz,$shipment_id, $status]);
                    if($stops->num_rows()>0){
                        foreach($stops->result() as $sres){
                            $stsname = $sres->status_name;
                            if($sres->status_id=="2" && $sres->stop_type == "P"){
                                $stsname = "Pickup Gate In";
                            }
                            if($sres->status_id=="1" && $sres->stop_type == "P"){
                                $data['pickup_datetime'] = $sres->createdon;
                                $stsname = "Pickup Done";
                            }
                            if($sres->status_id=="3" && $sres->stop_type == "P"){
                                $stsname = "Pickup Gate Out";
                            }
                            if($sres->status_id=="2" && $sres->stop_type == "D"){
                                $stsname = "Delivery Gate In";
                            }
                            if($sres->status_id=="1" && $sres->stop_type == "D"){
                                $data['delivery_datetime'] = $sres->createdon;
                                $stsname = "Delivery Done";
                            }
                            if($sres->status_id=="3" && $sres->stop_type == "D"){
                                $stsname = "Delivery Gate Out";
                            }
                            $locname = "";
                            if($sres->latitude != ""){
                                $locname = getLocationName($sres->latitude,$sres->longitude);
                            }
                            $data["stops"][] = array("datetime"=>$sres->createdon,"status"=>$stsname,"truck_no"=>$sres->register_number,"driver"=>$sres->name,"location"=>$locname);
                        }
                    }
                    $html = $this->load->view('settings/bulkepod',$data,true);
                    $chk = @$this->m_pdf->pdf->WriteHTML($html);
                    $chk = @$this->m_pdf->pdf->Output($epodpath,"F");
                    $roadlogDocument = @$this->m_pdf->pdf->Output($roadlogEpodPath,"F");
                    $unique_id = "RL".$order_id.".".date("Ymd").".".date("his");
                    $pagescnt = $this->m_pdf->pdf->pages;
                    $pages = count($pagescnt);
                    if($createdsource == 5){ /* SALog JPL*/
                        $sql = "SELECT reference_id,ref_value FROM tb_order_references WHERE order_id=? AND ref_value!='' GROUP BY reference_id HAVING count(reference_id)>=1";
                        $chkordtypeqry1 = $this->db->query($sql, [$ordid]);

                        $bn = $inn = $iv = $dq = $cmp = $brn = "";
                        if($chkordtypeqry1->num_rows()>1){
                            foreach($chkordtypeqry1->result() as $oref1){
                                if($oref1->reference_id == "BN"){
                                    $bn = $oref1->ref_value;
                                }if($oref1->reference_id == "INN"){
                                    $inn = $oref1->ref_value;
                                }
                                if($oref1->reference_id == "DQ"){
                                    $dq = $oref1->ref_value;
                                }if($oref1->reference_id == "CMP"){
                                    $cmp = $oref1->ref_value;
                                }if($oref1->reference_id == "BRN"){
                                    $brn = $oref1->ref_value;
                                }
                            }
                        }
                        /*get department code for this order*/
                        $departmentCode = $this->common->gettblrowdata(['order_row_id'=>$ordid],"department_code","tb_order_details",0,0);
                        if(!empty($departmentCode)){
                            $orderDepartmentCode = $departmentCode['department_code'];
                        }
                        if($cmp == ""){ $cmp = $company_code;}
                        if($brn == ""){ $brn = $branch_code;}
                        $countrycode = substr($company_code,0,-2);
                        $randomstr = RandomString::generate(10);
                        $jplData = [
                            "country"=>$cmp,
                            "branch"=>$brn,
                            "order_id"=>$order_id,
                            "time"=>date("hi"),
                            "unique_id"=>$unique_id,
                            "date"=>date("d.m.Y"),
                            "pages"=>$pages,
                            "xsr"=>$refvalue,
                            "sd"=>$orderDepartmentCode,
                            "bn"=>$bn,
                            "inn"=>$inn,
                            "iv"=>$iv,
                            "dq"=>$dq,
                            "custcid"=>$custcid,
                            "custcode"=>$custcode,
                            "countrycode"=>$countrycode,
                            "randomstr"=>$randomstr,
                            "doctype"=>746
                        ];
                        $jplFilePath = $this->saveSalogJPF($jplData);
                        $storeftipjpl = $this->uploadSalogKNFile($jplFilePath);
                        $storeftippdf = $this-> uploadSalogKNFile($epodpath);
                    }else{
                        /* Send POD Document to ROADLOG using sendpodtoknservice library */
                        $jplData = [
                            "country"=>substr($company_code,0,-2),
                            "branch"=>substr($branch_code,2),
                            "order_id"=>$order_id,
                            "time"=>date("hi"),
                            "unique_id"=>$documentId,
                            "date"=>date("d.m.Y"),
                            "pages"=>$pages,
                            "doctype"=>self::ROADLOG_POD_DOCTYPE
                        ];
                        $jplFilePath = $this->sendpodtoknservice ->saveROADLOGJPF($jplData);
                        $this->sendpodtoknservice->uploadKNFile($jplFilePath);
                        $this->sendpodtoknservice->uploadKNFile($roadlogEpodPath);
                        $body = $this->load->view('mail_forms/deliveredshipment', $data, true);
                        $this->load->library('email');
                        $this->email->from('svkonekt@kuehne-nagel.com', 'svkonekt');
                        $this->email->to($receivemail, $receivename);
                        if (($checkEpodForCustomer == 1) && ($customerId != "")) {
                            $customerGroupEmailIds = $this->Roadlogtosalogmodel->getCustomerGroupEmailIds($customerId);
                            $ccmail = array_merge($customerGroupEmailIds, $ccmail);
                        }
                        if(!empty($ccmail)){
                            $ccmail = array_unique($ccmail);
                            $cc_mail = implode(", ",$ccmail);
                            $cc_mail = '"'.$cc_mail.'"';
                            $this->email->cc($cc_mail);
                        }
                        $this->email->subject($newsub);
                        $this->email->set_mailtype("html");
                        $fileName = "RL".$order_id.".pdf";
                        $epodpath = sprintf('%s/assets/trippods/%s', FCPATH, $fileName);
                        $this->email->message($body);
                        $this->email->attach($epodpath);
                        try {
                            $this->email->send();
                        } catch (Exception $ex) {
                            log_message("error", "Send POD document jpl and pod to salog not sent " . $ex->getMessage());
                        }
                    }
                if($createdsource == '9'){
                    $this->sendpodgetouttosvkonekt($data,$ordid);
                }
            }
        }
    }
}
/**
 * Send PUP document jpl and pod to salog
 *
 *
 *
 * @author    Developer Name external.ram.k@kuehne-nagel.com
 * @date      30-03-2021 11:50:00+05.30
 * @change    Asia
 * @param     Array Order Info
 * @return    Boolean
 */

public function sendepopgateoutnotify($postdata){
    /*check SDT Ref*/
    $sdtref = getsdtreforder($postdata['ord_id']);
    if($sdtref == "PUP" || $sdtref == ""){
        $order_id = $postdata['order_id'];
        $ship_id = $postdata['shipment_id'];
        $trip_id = $postdata['trip_id'];
        $stop_id = $postdata['stop_id'];
        $driver_id = $postdata['driver_id'];
        $vehicle_id = $postdata['vehicle_id'];
        $curtz = $postdata['curtz'];
        $createdsource = 0;

        $ord_id = $this->db->escape($postdata['ord_id']);
        $sql = "SELECT o.id,o.order_id,o.customer_id,o.user_id,o.created_source,o.pickup_city,o.delivery_city,o.pickup_address1,o.delivery_address1,c.name,c.gcm_id,c.company_code,c.branch_code,c.phone,c.code FROM tb_orders o,tb_customers c WHERE o.customer_id=c.id AND o.id=? LIMIT 1";
        $chkcust = $this->db->query($sql, [$ord_id]);

        if($chkcust->num_rows()>0){
            $ordid = $chkcust->row()->id;
            $cust_id = $chkcust->row()->customer_id;
            $user_id = $chkcust->row()->user_id;
            $cust_name = $chkcust->row()->name;
            $company_code = $chkcust->row()->company_code;
            $branch_code = $chkcust->row()->branch_code;
            $createdsource = $chkcust->row()->created_source;
            $custcid = $chkcust->row()->phone;
            $custcode = $chkcust->row()->code;
            $pickup = $chkcust->row()->pickup_city;
            $delver = $chkcust->row()->delivery_city;
            $pickaddr = $chkcust->row()->pickup_address1;
            $deliveryaddr = $chkcust->row()->delivery_address1;
            $order_id = $chkcust->row()->order_id;
            $ord_id = $this->db->escape($ordid);
            $sql = "SELECT ts.id,ts.latitude,ts.longitude,ts.hash,ts.stop_id,ts.stop_type,dt.type_name,ts.createdby,convertToClientTZ(ts.createdon,?) as createdon,ts.imgpath,? as address,? as pickup,? as `drop`,? as order_id
                    FROM tb_pod_uploads ts
                        INNER JOIN tb_document_types dt ON dt.id=ts.doc_type AND dt.type_name='PUP'
                    WHERE ts.order_id = ? AND ts.status=1
                    GROUP BY ts.id
                    ORDER BY ts.createdon ASC";
            $chkdocs = $this->db->query($sql, [$curtz,$pickaddr,$pickup,$delver,$order_id,$ord_id]);
            if($chkdocs->num_rows() > 0){
                $data['order'] = $orddata = array("order_id"=>$order_id,"pickup_address1"=>$pickaddr,"delivery_address1"=>$deliveryaddr);
                $data['userid'] = $user_id;
                $epodpath = "./assets/trippods/RL".$order_id.".pdf";
                $data["pod"] = $chkdocs;
                /* get all order references in single row*/
                $data["orderref"] = $this->common->getallorderreferences($ordid);
                $refvalue = $orderDepartmentCode = "";
                /*get department code for this order*/
                $departmentCode = $this->common->gettblrowdata(['order_row_id'=>$ordid],"department_code","tb_order_details",0,0);
                if(!empty($departmentCode)){
                    $orderDepartmentCode = $departmentCode['department_code'];
                }
                $data['pickup_datetime'] = "";
                $data['delivery_datetime'] = "";

                $status = "1";
                $sql = "SELECT ss.stop_type,ss.status_id,ss.latitude,ss.longitude,convertToClientTZ(ss.createdon,?) as createdon,sm.status_name from tb_stop_status ss LEFT JOIN tb_status_master sm ON sm.id=ss.status_id WHERE ss.shipment_id=? AND ss.status=? ORDER BY ss.createdon ASC";
                $stops = $this->db->query($sql, [$curtz,$ship_id, $status]);

                if($stops->num_rows()>0){
                    foreach($stops->result() as $sres){
                        if($sres->status_id=="1" && $sres->stop_type == "P"){
                            $data['pickup_datetime'] = $sres->createdon;
                        }
                        if($sres->status_id=="1" && $sres->stop_type == "D"){
                            $data['delivery_datetime'] = $sres->createdon;
                        }
                    }
                }
                $this->load->library('m_pdf');
                $html = $this->load->view('settings/bulkepod',$data,true);
                $chk = @$this->m_pdf->pdf->WriteHTML($html);
                $chk = @$this->m_pdf->pdf->Output($epodpath,"F");
                $unique_id = "RL".$order_id.".".date("Ymd").".".date("his");
                $pagescnt = $this->m_pdf->pdf->pages;
                $pages = count($pagescnt);
                /* SALog JPL*/
                $sql = "SELECT reference_id,ref_value FROM tb_order_references WHERE order_id=? AND ref_value!='' GROUP BY reference_id HAVING count(reference_id)>=1";
                $chkordtypeqry1 = $this->db->query($sql, [$ordid]);
                $bn = $inn = $iv = $dq = $cmp = $brn = "";
                if($chkordtypeqry1->num_rows()>1){
                    foreach($chkordtypeqry1->result() as $oref1){
                        if($oref1->reference_id == "BN"){
                            $bn = $oref1->ref_value;
                        }if($oref1->reference_id == "INN"){
                            $inn = $oref1->ref_value;
                        }if($oref1->reference_id == "IV"){
                            $iv = $oref1->ref_value;
                        }if($oref1->reference_id == "DQ"){
                            $dq = $oref1->ref_value;
                        }if($oref1->reference_id == "CMP"){
                            $cmp = $oref1->ref_value;
                        }if($oref1->reference_id == "BRN"){
                            $brn = $oref1->ref_value;
                        }
                        if($oref1->reference_id == "XSR"){
                            $refvalue = $oref1->ref_value;
                        }
                    }
                }
                if($cmp == ""){ $cmp = $company_code;}
                if($brn == ""){ $brn = $branch_code;}
                $countrycode = substr($company_code,0,-2);
                $randomstr = RandomString::generate(10);
                $jplData = [
                    "country"=>$cmp,
                    "branch"=>$brn,
                    "order_id"=>$order_id,
                    "time"=>date("hi"),
                    "unique_id"=>$unique_id,
                    "date"=>date("d.m.Y"),
                    "pages"=>$pages,
                    "xsr"=>$refvalue,
                    "sd"=>$orderDepartmentCode,
                    "bn"=>$bn,
                    "inn"=>$inn,
                    "iv"=>$iv,
                    "dq"=>$dq,
                    "custcid"=>$custcid,
                    "custcode"=>$custcode,
                    "countrycode"=>$countrycode,
                    "randomstr"=>$randomstr,
                    "doctype"=>171
                ];
                $jplFilePath = $this->saveSalogJPF($jplData);
                $storeftipjpl = $this->uploadSalogKNFile($jplFilePath);
                $storeftippdf = $this->uploadSalogKNFile($epodpath);
            }
        }
    }
}

/* generate trip pod and sending to NZ FTP , updated new method for ftp connection */
public  function sendpodgetouttosvkonekt($data,$ordid)
{
    require 'vendor/autoload.php';
    $mpdf           = new \Mpdf\Mpdf([
        'mode'          => 'utf-8',
        'format'        => [190, 236],
        'margin_left'   => 0,
        'margin_right'  => 0,
        'margin_top'    => 0,
        'margin_bottom' => 0,
        'margin_header' => 0,
        'margin_footer' => 0,
        'tempDir'       => FCPATH .'assets/tmp',
    ]);
    $html = "";
    $name = "";
    if(!empty($data)){
        $etruckhtml = "";
        $getref = $this->common->gettblrowdata(array('order_id'=>$ordid,'reference_id'=>'DQ','status'=>'1'),"ref_value","tb_order_references",0,0);
        if(!empty($getref)){
            $data['order_id'] = $data['order']['order_id'] = $getref['ref_value'];
        }
        $svkonektpath = "./assets/trippods/".$data['order_id'].".pdf";
        $etrunknowhtml = $this->load->view('settings/bulkepod',$data,true);
        $mpdf->WriteHTML($etrunknowhtml);
        $mpdf->Output($svkonektpath, 'F');
        if($svkonektpath != ""){
            $company_code = strtolower($this->session->userdata('company_code'));
            $count_code=substr($company_code, 0, 2);
            $folder_name = "outbound_".$count_code;
            $this->load->library('network/Ftp', ['ftpName' => FTP_NAME_NZ]);
            $name = basename($svkonektpath);
            $new_file = "./pub/".$folder_name."/".$name;
            $uploadepod = $this->ftp->upload($new_file, $svkonektpath, false);
        }
    }
}

public function saveSalogJPF($jplData){
    $content = $this->load->view("jpl_salogtemplate",$jplData,TRUE);
    $order_id = $jplData["order_id"];
    $file_path = "./assets/jpl_files/RL$order_id.jpl";
    $fp = fopen($file_path,"wb");
    fwrite($fp,$content);
    fclose($fp);
    return $file_path;
}

public function uploadSalogKNFile($localfile){
   
    $remotefile = basename($localfile);
    $sftp_url = SALOG_FTP;
    $username = SALOG_FTP_USER;
    $password = SALOG_FTP_PWD;
    $folder_name = "/pub/";
    try{
        $sftp = new SFTP($sftp_url);
        if (!$sftp->login($username, $password)) {
            unset($sftp);
            log_message("error","Cannot login into your SWIFTLOG MTF Test server !");
        }else{
            $sftp->chdir($folder_name);
            $sftp->put($folder_name."/".$remotefile,$localfile,SFTP::SOURCE_LOCAL_FILE);
            unset($sftp);
            return true;
        }
    } catch (Exception $ex) {
        log_message("error","Some Problem occured!, SWIFTLOG MTF Test server, Please Try Again Later.");
    }
}

public function getdriverlatlongs($sim){
    $res = array("","");
    if($sim['trip_id'] > 0){
        $sql="SELECT v.authkey,a.apiurl,a.requesttype,a.requestdata,a.response FROM tb_tracking_vendors v,tb_vendor_apis a WHERE v.id=a.vendor_id AND v.id=? AND a.apiname='Fetch Location' AND a.status=1 LIMIT 1";
        $apiqry = $this->db->query($sql,[$sim['vendor_id']]);
        if($apiqry->num_rows()>0){
            $post['authkey'] = $apiqry->row()->authkey;
            $post['url'] = $apiqry->row()->apiurl;
            $post['reqtype'] = $apiqry->row()->requesttype;
            $post['data'] = array("phoneNumber"=>$sim['mobile']);
            $getdriverlocation = getdriverlocationbysms($post);
            if(!empty($getdriverlocation)){
                if($getdriverlocation['success'] == "true"){
                    if(!empty($getdriverlocation['data'])){
                        $latitude = $getdriverlocation['data']['location'][1];
                        $longitude = $getdriverlocation['data']['location'][0];
                        if($latitude != "" && $longitude != ""){
                            $res = array($latitude,$longitude);
                            $timestamp = $getdriverlocation['data']['timestamp'];
                            $getactual = getdatetimebytimezone(DFLT_TZ,$timestamp,$sim['curtz']);
                            $curdt = $getactual['datetime'];
                            $tripid = $sim['trip_id'];
                            $driver_id = $sim['driver_id'];
                            $vehicle_id = $sim['vehicle_id'];
                            $imei = $sim['mobile'];
                            $insdata = array("driver_id"=>$driver_id,"vehicle_id"=>$vehicle_id,"trip_id"=>$tripid,"latitude"=>$latitude,"longitude"=>$longitude,"accuracy"=>15.00,"speed"=>50,"battery"=>50.0,"bearing"=>50.00,"mobileimei"=>$imei,"timestamp"=>$curdt);
                            $ins = $this->common->insertTableData("tb_rtdrive_locations",$insdata);
                            /*update in vehicle table*/
                            if($vehicle_id != ""){
                                $vehwhr = array("id"=>$vehicle_id);
                                $vehset = array("imei"=>$imei,"latitude"=>$latitude,"longitude"=>$longitude,"speed"=>'50',"battery"=>'50',"bearing"=>'50',"receivedon"=>$curdt);
                                $upd = $this->db->where($vehwhr)->update("tb_trucks_data",$vehset);
                            }
                        }
                    }
                }
            }
        }
    }
    return $res;
}

    public function generatesummary(int $tripId = null, string $timeZone = null): void
    {
        if ($tripId != "") {
            if ($timeZone == "") {
                $timeZone = date_default_timezone_get();
            }
            $logDate = date('Y-m-d H:i:s');
            $getActual = getdatetimebytimezone(DFLT_TZ, $logDate, $timeZone);
            $currentDate = $getActual['datetime'];
            $registerNumber = "";
            $sql = $this->db->query("SELECT shift_id,vehicle_id,driver_id,convertToClientTZ(etime,'" . $timeZone . "') as etime,etime as tetime, start_imei, end_imei, start_reading,end_reading,trip_type,plat,plng FROM tb_trips WHERE id=? AND status=0 LIMIT 1", [$tripId]);
            if ($sql->num_rows() > 0) {
                $data = [];
                $data['driver_name'] = $data['driver_num'] = "";
                $shift = $sql->row()->shift_id;
                $sql1 = $this->db->query("SELECT user_id,stime as setime,convertToClientTZ(startdate,'" . $timeZone . "') as startdate, convertToClientTZ(enddate,'" . $timeZone . "') as enddate,splace,eplace,elat,elng FROM tb_shifts WHERE id=? LIMIT 1", [$shift]);
                $data["trip"] = $sql1->row();
                $employeeDetails = $this->db->query("select e.name,convertToClientTZ(te.stime,'" . $timeZone . "') as in_time,te.status as emp_status,te.driver_late,te.emp_late,te.absent_reason,m.material,e.shipment_volume,e.shipment_weight,e.order_id from tb_employee e,tb_trip_employee te,tb_materials m WHERE te.employee_id=e.id AND m.id=e.material_id AND te.trip_id=?", [$tripId]);
                $getTripEmployee = $this->db->query("SELECT IFNULL(SUM(IF(e.status='1',1,0)),0) AS attcnt, count(e.employee_id) AS totcnt FROM  tb_trip_employee e WHERE e.trip_id=?", [$tripId]);
                $imei = $sql->row()->start_imei;
                $endImei = $sql->row()->end_imei;
                $driverId = $sql->row()->driver_id;
                $vehicleId = $sql->row()->vehicle_id;
                $startTime = $sql1->row()->startdate;
                $endTime = $sql1->row()->enddate;
                $userId = $sql1->row()->user_id;
                $odometerStart = trim($sql->row()->start_reading);
                $odometerEnd = trim($sql->row()->end_reading);
                $tripType = $sql->row()->trip_type;
                $vendorID = 0;
                $dlat = $dlng = "";
                $trucksQuery = $this->db->query("select truck_capacity,register_number,vendor_id,truck_weight,truck_volume,latitude,longitude from tb_trucks_data WHERE id=? LIMIT 1", [$vehicleId]);
                $cabCapacity = $truckWeight = $truckVolume = 0;
                if ($trucksQuery->num_rows() > 0) {
                    $cabCapacity = $trucksQuery->row()->truck_capacity;
                    $registerNumber = $trucksQuery->row()->register_number;
                    $vendorID = $trucksQuery->row()->vendor_id;
                    $truckWeight = $trucksQuery->row()->truck_weight;
                    $truckVolume = $trucksQuery->row()->truck_volume;
                    $dlat = $trucksQuery->row()->latitude;
                    $dlng = $trucksQuery->row()->longitude;
                }
                if ($dlat == "") {
                    $dlat = $sql->row()->plat;
                    $dlng = $sql->row()->plng;
                }
                if ($dlat == $sql->row()->plat) {
                    $dlat = $sql1->row()->elat;
                    $dlng = $sql1->row()->elng;
                }
                $this->common->updatetbledata("tb_trips", ["dlat" => $dlat, "dlng" => $dlng], ["id" => $tripId]);
                $vehicleTripInfo = ["plat" => $sql->row()->plat, "plng" => $sql->row()->plng, "dlat" => $dlat, "dlng" => $dlng];
                $data['tripinfo'] = (object)$vehicleTripInfo;
                if ($cabCapacity == "") {
                    $cabCapacity = 0;
                }
                $getDriversData = $this->db->query("select name,contact_num,vendor_id from tb_truck_drivers WHERE id=? LIMIT 1", [$driverId]);
                if ($getDriversData->num_rows() > 0) {
                    $data['driver_name'] = $getDriversData->row()->name;
                    $data['driver_num'] = $getDriversData->row()->contact_num;
                    $vnid = $getDriversData->row()->vendor_id;
                    if ($vendorID == 0 && $vnid != 0) {
                        $vendorID = $vnid;
                    }
                }
                $sql2 = $this->db->query("select latitude,longitude FROM tb_rtdrive_locations WHERE trip_id =? order by timestamp DESC", [$tripId]);
                $distance = $flag = $lat = $lng = 0;
                $queryResult = $sql2->result_array();
                $finalResult = array_reverse($queryResult);
                foreach ($finalResult as $row) {
                    if ($flag == 0) {
                        $flag = 1;
                    } else {
                        $a = calculateDistance12($lat, $lng, $row['latitude'], $row['longitude']);
                        $distance = $distance + $a;
                    }
                    $lat = $row['latitude'];
                    $lng = $row['longitude'];
                }
                $attendemp = 0;
                $totalEmployee = getempcount($tripId);
                if ($getTripEmployee->num_rows() > 0) {
                    $attendemp = $getTripEmployee->row()->attcnt;
                }
                $data["noofemp"] = $totalEmployee;
                $driverLate = 0.00;
                $startETime = date("Y-m-d H:i:s", strtotime($sql1->row()->setime));
                $toETime = date("Y-m-d H:i:s", strtotime(date("H:i:s", strtotime($sql->row()->tetime))));
                $toTime = strtotime($startETime);
                $fromTime = strtotime($toETime);
                if ($fromTime > $toTime) {
                    $driverLate = round(abs($fromTime - $toTime) / 60, 2);
                }
                $checkTrip = $this->common->gettblrowdata(["trip_id" => $tripId], "id", "tb_trip_summary", 0, 0);
                if (empty($checkTrip)) {
                    $this->common->insertTableData(
                        "tb_trip_summary",
                        ['trip_id' => $tripId, 'vehicle_id' => $vehicleId, 'driver_id' => $driverId, 'vendor_id' => $vendorID, 'trip_distance' => $distance, 'no_of_emp' => $totalEmployee, 'attended_emp' => $attendemp, 'start_imei' => $imei, 'end_imei' => $endImei, 'start_time' => $startTime, 'end_time' => $endTime, 'user_id' => $userId, 'cab_capacity' => $cabCapacity, 'trip_status' => 1, 'trip_type' => $tripType, 'ship_delay' => $driverLate, 'createdon' => $currentDate]
                    );
                }
                $data["trip_id"] = $tripId;
                $shifttime = 0;
                if ($tripType != 2) {
                    $shiftStartDate = $sql1->row()->startdate;
                    $shifttime = date('H:i A', strtotime($shiftStartDate));
                } else {
                    $shifttime = "Empty";
                }
                $data["driver_late"] = $driverLate;
                $data["empshifttime"] = $shifttime;
                $data["distance"] = $distance;
                $data["stime"] = $startTime;
                $data["etime"] = $endTime;
                $data["simei"] = $imei;
                $data["eimei"] = $endImei;
                if ($odometerEnd == "") {
                    $odometerEnd = 0;
                }
                if ($odometerStart == "") {
                    $odometerStart = 0;
                }
                $data["odometer"] = ($odometerEnd - $odometerStart);
                $data["page_title"] = "Trip Report";
                $data["capacity"] = $cabCapacity;
                $data["employees"] = $employeeDetails;
                $data["trip_type"] = $tripType;
                $data["register_number"] = $registerNumber;
                $data["truck_weight"] = $truckWeight;
                $data["truck_volume"] = $truckVolume;
                $data["ep"] = "";
                $getUserMail = $this->db->select("name,emailid,cc_mails,address")->get_where("tb_users", ["id" => $userId, "emailid !=" => ""], 1, 0);
                if ($getUserMail->num_rows() > 0) {
                    $receivemail = $getUserMail->row()->emailid;
                    $receivename = $getUserMail->row()->name;
                    $receivecc = $getUserMail->row()->cc_mails;
                    $data["ep"] = $getUserMail->row()->address;
                    $insertdata = @[
                        'trip_id' => $tripId,
                        'shift_id' => $shift,
                        'splace' => $data["trip"]->splace,
                        'eplace' => $data["trip"]->eplace,
                        'stime' => $startTime,
                        'etime' => $endTime,
                        'capacity' => $cabCapacity,
                        'simei' => $data['simei'],
                        'eimei' => $data['eimei'],
                        'totcnt' => $totalEmployee,
                        'attcnt' => $attendemp,
                        'distance' => $data['distance'],
                        'odometer' => $data['odometer'],
                        'driver_late' => $data['driver_late'],
                        'receivemail' => $receivemail,
                        'receivename' => $receivename,
                        'user_id' => $userId,
                        'createdon' => $currentDate
                    ];
                    $this->common->insertTableData('tb_trips_mails', $insertdata);
                    $this->load->library('email');
                    $this->email->to($receivemail, $receivename);
                    if ($receivecc != "") {
                        $this->email->cc($receivecc);
                    }
                    $this->email->from('svkonekt@kuehne-nagel.com', 'svkonekt');
                    if ($tripType == 1) {
                        $this->email->subject('svkonekt: Return Trip Status');
                    } else {
                        if ($tripType == 2) {
                            $this->email->subject('svkonekt: Empty Trip Status');
                        } else {
                            $this->email->subject('svkonekt: Trip Status');
                        }
                    }
                    $this->email->set_mailtype('html');
                    $body = $this->load->view('mail_forms/basicreport', $data, true);
                    $this->email->message($body);
                    $sendmail = $this->email->send();
                }
            }
        }
    }

    public function massrefnum()
    {
        if (!checkUrlAccessForUser('MASSREFNUM')) {
            redirect("Forbiddenaccess");
        }
        $data['page_title'] = "Mass RefNum Update";
    $data['sub_title'] = "Order Status";
    $uid = $this->session->userdata("user_id");
    $mainqry = "SELECT o.id,o.order_id,o.trip_id FROM tb_orders o WHERE o.user_id=? AND o.trip_id!=0 AND o.trip_sts=0 GROUP BY o.order_id ORDER BY o.trip_id DESC";
    $custord = $this->db->query($mainqry,[$uid]);
    $data['tripsdata'] = array();
    $data['ravailable'] = $ravailable = $pos = array();
    if($custord->num_rows()>0){
        foreach($custord->result() as $res){
            $pos[] = $res->id;
            $refs = array();
            $ord_id=$res->id;
            $sql = "SELECT r.reference_id,GROUP_CONCAT(r.ref_value) as refvalue FROM tb_order_references r WHERE r.order_id=? AND r.status=1 GROUP BY r.reference_id";
            $refqry = $this->db->query($sql, [$ord_id]);

            foreach($refqry->result() as $rf){
                $refid = $rf->reference_id;
                if(!in_array($refid, $ravailable)){
                    $ravailable[] = $refid;
                }
                $refs[$refid] = $rf->refvalue;
            }
            $data['tripsdata'][] = array('ordid'=>$res->id,'trackingid'=>$res->order_id,"refdata"=>$refs);
        }
    }
    $mainqry = "SELECT o.id,o.order_id FROM tb_orders o WHERE o.user_id=$uid AND o.trip_id=0 AND o.trip_sts=0 AND o.status!=0";
    $custord1 = $this->db->query($mainqry);
    if($custord1->num_rows()>0){
        foreach($custord1->result() as $res1){
            $refs = array();
            $refqry = $this->db->query("SELECT r.reference_id,GROUP_CONCAT(r.ref_value) as refvalue FROM tb_order_references r WHERE r.order_id='$res1->id' AND r.status=1 AND r.ref_value != '' GROUP BY r.reference_id");
            foreach($refqry->result() as $rf1){
                $refid = $rf1->reference_id;
                if(!in_array($refid, $ravailable)){
                    $ravailable[] = $refid;
                }
                $refs[$refid] = $rf1->refvalue;
            }
            $data['tripsdata'][] = array('ordid'=>$res1->id,'trackingid'=>$res1->order_id,"refdata"=>$refs);
        }
    }
    $data['ravailable'] = $ravailable;
    $this->settemplate->dashboard('admin/massrefnum',$data);
}

public function saverefnum(){
    $post = $this->input->post();
    $order_id = $this->input->post("order_id",true);
    $availrefs = $this->input->post("availrefs",true);
    $curtz = $this->session->userdata("usr_tzone")['timezone'];
    $logdate = date('Y-m-d H:i:s');
    $getactual = getdatetimebytimezone(DFLT_TZ,$logdate,$curtz);
    $curdt = $getactual['datetime'];
    if(count($order_id)>0){
        for($i=0;$i<count($order_id);$i++){
            if($availrefs != ""){
                $ord_id = $order_id[$i];
                $avref = explode(",", $availrefs);
                foreach($avref as $ar){
                    $chk1 = isset($post[$ar."_".$order_id[$i]]) ? $post[$ar."_".$order_id[$i]] : array();
                    if(count($chk1)>0){
                        foreach($chk1 as $chk){

                            $multichk = explode(",", $chk);
                            foreach($multichk as $mc){
                                if($mc != ""){
                                    $qrychk = $this->db->select("id")->get_where("tb_order_references",array("order_id"=>$ord_id,"reference_id"=>$ar,"ref_value"=>$mc),1,0);
                                    if($qrychk->num_rows() == 0){
                                        $insarr = array("order_id"=>$ord_id,"reference_id"=>$ar,"ref_value"=>$mc,"status"=>1,"createdon"=>$curdt,"updatedon"=>$curdt);
                                        $ins = $this->db->insert("tb_order_references",$insarr);
                                        $ins = $this->db->insert("tb_order_references_history",$insarr);
                                    }
                                }else{
                                    $qrychk = $this->db->select("id")->get_where("tb_order_references",array("order_id"=>$ord_id,"reference_id"=>$ar),1,0);
                                    if($qrychk->num_rows() > 0){
                                        $updarr = array("order_id"=>$ord_id,"reference_id"=>$ar);
                                        $upd = $this->db->delete("tb_order_references",$updarr);
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        $this->session->set_flashdata('success_msg',"Updated Successfully");
    }else{
        $this->session->set_flashdata('error_msg',"Not valid input!");
    }
    redirect("admin/massrefnum");
}

function downloadexcel() {
    ini_set("memory_limit","256M");
    $data['page_title']='Completed';
    $data['sub_title']='Completed Bookings';
    $data['orders'] = array();
    $inputdt = $this->input->post();
    if(isset($inputdt['excel_export'])){
        $ords = array();
        for($i=0;$i<count($inputdt['excel_export']);$i++){
            $ords[] = $inputdt['excel_export'][$i];
        }
        if(!empty($ords)){
            $whr = " o.id IN(".implode(',', $ords).")";
            $d = $s= $t = 0;
            $cid = $this->session->userdata("user_id");
            $curtz = $this->session->userdata("usr_tzone")['timezone'];
           $result = $this->orderrevenuesmodel->donwloadCompletedOrderForExcel($whr);
            $totcnt = $result->num_rows();
            if($totcnt > 0 && $totcnt<=50){
                foreach($result->result() as $res){
                    $epods['pod'] = $epods['signature'] = $epods['others'] = array();
                    $pods = $this->db->query(
                        "SELECT ts.id,ts.latitude,ts.longitude,ts.stop_id,ts.stop_type,ts.doc_type,dt.type_name,ts.createdby,convertToClientTZ(ts.createdon, ?) as createdon,ts.imgpath,ts.hash,e.stopname
                            FROM tb_pod_uploads ts
                                LEFT JOIN tb_document_types dt ON dt.id=ts.doc_type
                                LEFT JOIN tb_shiporder_stops e ON e.id = ts.stop_id
                            WHERE ts.order_id = ? AND ts.status=?
                            GROUP BY ts.id
                            ORDER BY ts.createdon ASC",
                        [$curtz, $res->id, 1]
                    );
                    if($pods->num_rows()>0){
                        foreach($pods->result() as $pres){
                            if($pres->doc_type == '3' || $pres->doc_type == '4'){
                                $epods['pod'][] = array("id"=>$pres->id,"stopname"=>$pres->stopname,"createdon"=>$pres->createdon,"type_name"=>$pres->type_name,"imgpath"=>$pres->imgpath,"latitude"=>$pres->latitude,"longitude"=>$pres->longitude);
                            }
                            if($pres->doc_type == '1'){
                                $epods['signature'][] = array("id"=>$pres->id,"stopname"=>$pres->stopname,"createdon"=>$pres->createdon,"type_name"=>$pres->type_name,"imgpath"=>$pres->imgpath,"latitude"=>$pres->latitude,"longitude"=>$pres->longitude);
                            }
                            if($pres->doc_type == '2'){
                                $epods['others'][] = array("id"=>$pres->id,"stopname"=>$pres->stopname,"createdon"=>$pres->createdon,"type_name"=>$pres->type_name,"imgpath"=>$pres->imgpath,"latitude"=>$pres->latitude,"longitude"=>$pres->longitude);
                            }
                        }
                    }
                    $delivery_datetime = $res->act_etime;
                    if(empty($delivery_datetime)){
                        $delivery_datetime = $res->order_updateddate;
                    }
                    $data['orders'][] = array("id"=>$res->id,"order_id"=>$res->order_id,"ref_num"=>getQRrefsbyorderId($res->order_id),"custid"=>$res->custid,"pickup_company"=>$res->pickup_company,"pickup_country"=>$res->pickup_country,"pickup_city"=>$res->pickup_city,"pickup_pincode"=>$res->pickup_pincode,"pickup_address"=>$res->pickup_address1,"delivery_company"=>$res->delivery_company,"delivery_country"=>$res->delivery_country,"delivery_city"=>$res->delivery_city,"delivery_pincode"=>$res->delivery_pincode,"delivery_address"=>$res->delivery_address1,"pickup_datetime"=>$res->pickup_datetime,"delivery_datetime"=>$delivery_datetime,"epods"=>$epods);
                }
                $styleArray = array(
                    'font'  => array(
                        'bold'  => true,
                        'color' => array('rgb' => 'FFFFFF'),
                        'size'  => 10,
                        'name'  => 'Verdana'
                    ));
                $objPHPExcel = new PHPExcel();
                $objPHPExcel->setActiveSheetIndex(0);
                $objPHPExcel->getActiveSheet()
                ->getStyle('A1:M1')
                ->applyFromArray(
                    array(
                        'fill' => array(
                            'type' => PHPExcel_Style_Fill::FILL_SOLID,
                            'color' => array('rgb' => '0c3b81')
                        )
                    )
                );
                $objPHPExcel->getActiveSheet()->SetCellValue('A1', 'ID');
                $objPHPExcel->getActiveSheet()->getStyle('A1')->applyFromArray($styleArray);
                $objPHPExcel->getActiveSheet()->SetCellValue('B1', 'CUSTOMER ID');
                $objPHPExcel->getActiveSheet()->getStyle('B1')->applyFromArray($styleArray);
                $objPHPExcel->getActiveSheet()->SetCellValue('C1', 'BOOKING ID');
                $objPHPExcel->getActiveSheet()->getStyle('C1')->applyFromArray($styleArray);
                $objPHPExcel->getActiveSheet()->SetCellValue('D1', 'Ref Num');
                $objPHPExcel->getActiveSheet()->getStyle('D1')->applyFromArray($styleArray);
                $objPHPExcel->getActiveSheet()->SetCellValue('E1', 'Pickup Location');
                $objPHPExcel->getActiveSheet()->getStyle('E1')->applyFromArray($styleArray);
                $objPHPExcel->getActiveSheet()->SetCellValue('F1', 'Pickup Address');
                $objPHPExcel->getActiveSheet()->getStyle('F1')->applyFromArray($styleArray);
                $objPHPExcel->getActiveSheet()->SetCellValue('G1', 'Pickup Date');
                $objPHPExcel->getActiveSheet()->getStyle('G1')->applyFromArray($styleArray);
                $objPHPExcel->getActiveSheet()->SetCellValue('H1', 'Delivery Location');
                $objPHPExcel->getActiveSheet()->getStyle('H1')->applyFromArray($styleArray);
                $objPHPExcel->getActiveSheet()->SetCellValue('I1', 'Delivery Address');
                $objPHPExcel->getActiveSheet()->getStyle('I1')->applyFromArray($styleArray);
                $objPHPExcel->getActiveSheet()->SetCellValue('J1', 'Delivered Date');
                $objPHPExcel->getActiveSheet()->getStyle('J1')->applyFromArray($styleArray);
                $objPHPExcel->getActiveSheet()->SetCellValue('K1', 'ePOD');
                $objPHPExcel->getActiveSheet()->getStyle('K1')->applyFromArray($styleArray);
                $objPHPExcel->getActiveSheet()->SetCellValue('L1', 'Signature');
                $objPHPExcel->getActiveSheet()->getStyle('L1')->applyFromArray($styleArray);
                $objPHPExcel->getActiveSheet()->SetCellValue('M1', 'Others');
                $objPHPExcel->getActiveSheet()->getStyle('M1')->applyFromArray($styleArray);
                $rowCount = 2;
                if(count($data['orders'])>0){
                    $i = 1;
                    foreach($data['orders'] as $orderData){
                        showDocumentsInExcel($orderData, $i, $objPHPExcel, $rowCount);
                        $rowCount++;
                        $i++;
                        }
                    }
                    $fileName = 'ORDERS-'.date("Ymdhis").'.xlsx';
    if(headers_sent()){
        foreach (headers_list() as $header) {
            header_remove($header);
        }
    }
                ob_clean();
                header('Content-Type: application/vnd.ms-excel'); //mime type
                header('Content-Disposition: attachment;filename="'.$fileName.'"'); //tell browser what's the file name
                header('Cache-Control: max-age=0'); //no cache
                $objWriter = new PHPExcel_Writer_Excel2007($objPHPExcel);
                ob_end_clean();
                $objWriter->save('php://output');
            }else{
                $this->session->set_flashdata('error_msg',"Max. records should not be more than 50, Please search for required data and download");
                redirect("admin/doneorders");
            }
        }else{
            redirect("admin/doneorders");
        }
    }else{
        redirect("admin/doneorders");
    }
}

    //new code by team for ajax loading dropdowns.
public function getrefinfo($type){
    $btype = $this->session->userdata('business_type');
    $branch_user = isset($_POST["branch_user"]) ? $_POST["branch_user"] : "-1";
    if(!in_array($btype, ['Country Admin'])){
        $cid = "(".$this->session->userdata("user_id").")";
    }else{
        $admids = $this->session->userdata('country_user_ids');
        if($branch_user != "-1"){
            $cid   = "($branch_user)";
        }else if(count($admids)>0){
            $users  = implode(",", $admids);
            $cid   = "($users)";
        }else{
            $cid   = "(-1)";
        }
    }
    $pwhr = "o.user_id IN $cid AND ";
    $permission = checkuserpermissions();
    if(in_array("orders", $permission)){
        $company_code = $this->session->userdata('company_code');
        $pwhr = "o.company_code LIKE '".$this->db->escape_str($company_code)."' AND ";
    }else{
        $pwhr = "o.user_id IN $cid AND ";
    }
    $searchTerm = isset($_POST['searchTerm']) ? $_POST['searchTerm'] : "";
    $whr = "";
    if($searchTerm != ""){
        $whr = "r.ref_value LIKE '%". $this->db->escape_str($searchTerm)."%' AND ";
    }
    $data = array();
    if($type=='pending'){
        if($this->session->userdata('company_code') == 'NZKN'){
            $whr .= ' o.order_status != "READY" AND ';
        }
        $orderref = $this->db->query("SELECT r.id,r.reference_id,r.ref_value FROM tb_order_references r,tb_orders o WHERE ".$whr." r.order_id=o.id AND ".$pwhr." o.trip_id=0 AND o.trip_sts=0 AND r.status=1 GROUP BY r.id");
    }else if($type=='ready'){
        $whr .= ' o.order_status ="READY" AND';
        $orderref = $this->db->query("SELECT r.id,r.reference_id,r.ref_value FROM tb_order_references r,tb_orders o WHERE $whr r.order_id=o.id AND ".$pwhr." o.trip_id=0 AND o.trip_sts=0 AND r.status=1 GROUP BY r.id");
    }else if($type=='active'){
        $orderref = $this->db->query("SELECT r.id,r.reference_id,r.ref_value FROM tb_order_references r,tb_orders o WHERE ".$whr." r.order_id=o.id AND o.trip_id!=0 AND o.trip_sts=0 AND ".$pwhr." r.status=1 GROUP BY r.id");
    }else if($type=='done'){
        $orderref = $this->db->query("SELECT r.id,r.reference_id,r.ref_value FROM tb_order_references r,tb_orders o WHERE ".$whr." r.order_id=o.id AND ".$pwhr." o.trip_sts=1 AND r.status=1 GROUP BY r.id ORDER BY r.updatedon");
    }
    if($orderref->num_rows() >0){
        foreach($orderref->result_array() as $ores){
            $data[] = array("id"=>$ores['ref_value'], "text"=>$ores['ref_value']);
        }
    }
    echo json_encode($data);
}
public function getbookinfo($type){
    $cid='';
    $btype = $this->session->userdata('business_type');
    $branch_user = isset($_POST["branch_user"]) ? $_POST["branch_user"] : "-1";
    if(!in_array($btype, ['Country Admin'])){
        $cid = "(".$this->session->userdata("user_id").")";
    }else{
        $admids = $this->session->userdata('country_user_ids');
        if($branch_user != "-1"){
            $cid   = "($branch_user)";
        }else if(count($admids)>0){
            $users  = implode(",", $admids);
            $cid   = "($users)";
        }else{
            $cid   = "(-1)";
        }
    }
    $pwhr = "o.user_id IN $cid AND ";
    $permission = checkuserpermissions();
    if(in_array("orders", $permission)){
        $company_code = $this->session->userdata('company_code');
        $pwhr = "o.company_code LIKE '". $this->db->escape_str($company_code)."' AND ";
    }else{
        $pwhr = "o.user_id IN $cid AND ";
    }
    $data = array();
    $searchTerm = isset($_POST['searchTerm']) ? $_POST['searchTerm'] : "";
    $whr = "";
    if($searchTerm != ""){
        $whr = "o.order_id LIKE '%". $this->db->escape_str($searchTerm)."%' AND ";
    }
    if($type=='active'){
        $orderref = $this->db->query("SELECT o.order_id FROM tb_orders o,tb_employee tbe WHERE o.order_id=tbe.order_id AND  $whr o.status NOT IN (0,3) AND ".$pwhr." ((o.trip_id=0 AND (SELECT COUNT(trip_id) FROM tb_employee WHERE order_id=o.order_id)>0) OR (o.trip_id!=0 AND (SELECT COUNT(trip_id) FROM tb_employee WHERE order_id=o.order_id)=0))  AND o.trip_sts=0 GROUP BY o.order_id");
    }else if($type=='pending'){
        if($this->session->userdata('company_code') == 'NZKN'){
            $whr .= ' (o.order_status != "READY" OR o.order_status IS NULL) AND ';
        }
        $orderref = $this->db->query("SELECT o.order_id FROM tb_orders o WHERE  $whr o.status!=0 AND ".$pwhr." (o.trip_id=0 AND (SELECT COUNT(trip_id) FROM tb_employee WHERE order_id=o.order_id)=0) AND o.trip_sts=0 GROUP BY o.order_id");
    }else if($type=='ready'){
        $whr .= ' o.order_status = "READY" AND ';
        $orderref = $this->db->query("SELECT o.order_id FROM tb_orders o WHERE $whr o.status!=0 AND ".$pwhr." o.trip_id=0 AND o.trip_sts=0 GROUP BY o.order_id");
    }else if($type=='done'){
        $orderref = $this->db->query("SELECT o.id,o.order_id FROM tb_orders o,tb_employee tbe WHERE o.order_id=tbe.order_id AND  $whr o.status!=0 AND ".$pwhr." (o.trip_sts=1 OR (o.trip_sts = 0 AND o.status = 3)) GROUP BY o.order_id ORDER BY o.updatedon DESC");
    }
    if($orderref->num_rows() >0){
        foreach($orderref->result_array() as $ores){
            $data[] = array("id"=>$ores['order_id'], "text"=>$ores['order_id']);
        }
    }
    echo json_encode($data);
}
public function getordertypeinfo(){
    $data = array();
    $btype = $this->session->userdata('business_type');
    $company_code = $this->session->userdata('company_code');
    if($btype != "Country Admin"){
        $ordertypes = $this->db->select("type_name,ordtype_code")->group_by("type_name")->get_where("tb_order_types",array("company_code"=>$company_code,"status"=>1));
    }else{
        $ordertypes = $this->db->select("type_name,ordtype_code")->group_by("type_name")->get_where("tb_order_types",array("status"=>1));
    }
    if($ordertypes->num_rows() >0){
        foreach($ordertypes->result_array() as $ores){
           $data[] = array("id"=>$ores['ordtype_code'], "text"=>$ores['type_name']);
       }
   }else{
    $ordertypes = $this->db->select("type_name,ordtype_code")->group_by("type_name")->get_where("tb_order_types",array("status"=>1));
    foreach($ordertypes->result_array() as $ores){
       $data[] = array("id"=>$ores['ordtype_code'], "text"=>$ores['type_name']);
   }
}
echo json_encode($data);
}

public function gettripinfo($type){
    $cid='';
    $btype = $this->session->userdata('business_type');
    $post = $this->input->post(NULL,TRUE);
    $branch_user = isset($post["branch_user"]) ? $post["branch_user"] : "-1";
    if(!in_array($btype, ['Country Admin'])){
        $cid = $this->session->userdata("user_id");
    }else{
        $admids = $this->session->userdata('country_user_ids');
        if($branch_user != "-1"){
            $cid   = "($branch_user)";
        }else if(count($admids)>0){
            $users  = implode(",", $admids);
            $cid   = "($users)";
           }else{
            $cid   = "(-1)";
        }
    }
    $pwhr = "o.user_id IN $cid AND ";
    $permission = checkuserpermissions();
    if(in_array("orders", $permission)){
        $company_code = $this->session->userdata('company_code');
        $pwhr = "o.company_code LIKE '".$company_code."' AND ";
    }else{
        $pwhr = "o.user_id IN $cid AND ";
    }
    $data = array();
    $searchTerm = isset($post['searchTerm']) ? $post['searchTerm'] : "";
    $whr = "";
    if($searchTerm != ""){
        $whr = "o.order_id LIKE '%".$searchTerm."%' AND ";
    }
   if($type=='done'){
            $this->db->distinct();
            $this->db->select('o.id,o.shipmentid');
            $this->db->from('tb_orders o');
            $this->db->join('tb_employee tbe','o.order_id=tbe.order_id');
           $this->db->where_in('o.user_id',$cid);
            $this->db->where(array($whr,'o.status !=' => 0,'o.trip_sts'=>1));
            $this->db->group_by('o.shipmentid');
            $this->db->order_by('o.updatedon','DESC');

            $orderref=$this->db->get();

        }
    if(isset($orderref) and $orderref->num_rows() >0){
        foreach($orderref->result_array() as $ores){
            $data[] = array("id"=>$ores['shipmentid'], "text"=>$ores['shipmentid']);
        }
    }
    echo json_encode($data);
}

public function getcarrierinfo($type){
    $cid='';
    $btype = $this->session->userdata('business_type');
    $post = $this->input->post(NULL,TRUE);
    $branch_user = isset($post["branch_user"]) ? $post["branch_user"] : "-1";
    if(!in_array($btype, ['Country Admin'])){
        $cid =$this->session->userdata("user_id");
    }else{
        $admids = $this->session->userdata('country_user_ids');
        if($branch_user != "-1"){
            $cid   = "($branch_user)";
        }else if(count($admids)>0){
            $users  = implode(",", $admids);
            $cid   = "($users)";
        }else{
            $cid   = "(-1)";
        }
    }

    $pwhr = "o.user_id IN $cid AND ";
    $permission = checkuserpermissions();

    if(in_array("orders", $permission)){
        $company_code = $this->session->userdata('company_code');
        $pwhr = "o.company_code LIKE '".$this->db->escape_str($company_code)."' AND ";
    }else{
        $pwhr = "o.user_id IN $cid AND ";
    }

    $data = array();
    $searchTerm = isset($post['searchTerm']) ? $post['searchTerm'] : "";
    $whr = "";
    if($searchTerm != ""){
        $whr = "o.order_id LIKE '%".$this->db->escape_str($searchTerm)."%' AND ";
    }
    if($type=='done'){
        $this->db->distinct();
            $this->db->select('v.id,v.name');
            $this->db->from('tb_orders o');
            $this->db->join('tb_employee tbe','o.order_id=tbe.order_id');
           $this->db->where_in('o.user_id',$cid);
            $this->db->where(array($whr,'o.status !=' => 0,'o.trip_sts'=>1));
             $this->db->join('tb_vendors v','v.id= o.vendor_id');
             $this->db->group_by('o.order_id');
            $this->db->order_by('o.updatedon','DESC');

            $orderref=$this->db->get();
        }

    if(isset($orderref) and $orderref->num_rows() >0){
        foreach($orderref->result_array() as $ores){
            $data[] = array("id"=>$ores['id'], "text"=>$ores['name']);
        }
    }
    echo json_encode($data);
}

public function getdriverinfo($type){
    $cid='';
    $btype = $this->session->userdata('business_type');
    $post = $this->input->post(NULL,TRUE);
    $branch_user = isset($post["branch_user"]) ? $post["branch_user"] : "-1";
    if(!in_array($btype, ['Country Admin'])){
        $cid =$this->session->userdata("user_id");
    }else{
        $admids = $this->session->userdata('country_user_ids');
        if($branch_user != "-1"){
            $cid   = "($branch_user)";
        }else if(count($admids)>0){
            $users  = implode(",", $admids);
            $cid   = "($users)";
        }else{
            $cid   = "(-1)";
        }
    }
    $pwhr = "o.user_id IN $cid AND ";
    $permission = checkuserpermissions();
    if(in_array("orders", $permission)){
        $company_code = $this->session->userdata('company_code');
        $pwhr = "o.company_code LIKE '". $this->db->escape_str($company_code)."' AND ";
    }else{
        $pwhr = "o.user_id IN $cid AND ";
    }
    $data = array();
    $searchTerm = isset($post['searchTerm']) ? $post['searchTerm'] : "";
    $whr = "";
    if($searchTerm != ""){
        $whr = "o.order_id LIKE '%". $this->db->escape_str($searchTerm)."%' AND ";
    }
    if($type=='done'){
        $this->db->distinct();
            $this->db->select('d.id,d.name');
            $this->db->from('tb_orders o');
            $this->db->join('tb_employee tbe','o.order_id=tbe.order_id');
           $this->db->where_in('o.user_id',$cid);
            $this->db->where(array($whr,'o.status !=' => 0,'o.trip_sts'=>1));
             $this->db->join('tb_truck_drivers d','d.vendor_id= o.vendor_id');

            $this->db->group_by('o.order_id');
            $this->db->order_by('o.updatedon','DESC');

            $orderref=$this->db->get();
        }
    if(isset($orderref) and $orderref->num_rows() >0){
        foreach($orderref->result_array() as $ores){
            $data[] = array("id"=>$ores['id'], "text"=>$ores['name']);
        }
    }
    echo json_encode($data);
}


public function sendnotify($action,$orderid,$attach=null){
    if(!empty($orderid)){
        $this->load->library('notifytrigger');
        if($attach != null){
            $info['attachment'] = $attach;
        }
        $info['page_title'] = 'Booking Notification';
        $info['order_id'] = $orderid;
        $info['action'] = $action;
        $orderinfo = $this->common->gettblrowdata(array('id'=>$orderid),'order_id','tb_orders',0,0);
        if(count($orderinfo)>0){
            $info['orderid'] = $bookingId = $orderinfo['order_id'];
            $orderDetails = $this->DeliveryDocumentModel->getOrderCustomerName(0, $bookingId);
            $info['subject'] = "Booking ID:" . $bookingId . " Customer Name: " . $orderDetails[$bookingId]['customerName'] . " Delivery Docs: " . $orderDetails[$bookingId]['reference'];
            $info['cargos'] = $this->common->gettbldata(array('order_id'=>$orderid),'quantity_type,quantity','tb_order_cargodetails',0,0);
            $info['body'] = $this->load->view('mail_forms/notifytrigger/'.$action,$info,true);
            $this->notifytrigger->sendordernotify($info);
        } else {
            log_message('error','No Order data for id : '.$orderid);
        }
    } else {
        log_message('error','Empty Order ');
    }
}
 /*
     * @Description : script is use to re-generate files for epod for salog
     *
     * @author: Nivas Reddy
     * @Dated on 20/08/2021
     *
     *  */

    public function reGenerateEpod() {
        $response = array("status" => 0, "data" => "Failed to Upload salog!");
        if (isset($_REQUEST)) {
            $curtz = "Asia/Singapore";
            $postdata = array(
                "shipment_id" => $_REQUEST['shipment_id'] ?? 0,
                "trip_id" => $_REQUEST['trip_id'] ?? 0,
                "driver_id" => $_REQUEST['driver_id'] ?? 0,
                "stop_id" => $_REQUEST['stop_id'] ?? 0,
                "order_id" => $_REQUEST['order_id'] ?? 0,
                "curtz" => $curtz,
                "ord_id" => $_REQUEST['order_id'] ?? 0,
                "vehicle_id" => $_REQUEST['vehicle_id'] ?? 0
            );
            $this->sendepodgateoutnotify($postdata);
            $response = array("status" => 1, "data" => "Upload salog!");
        }
            echo json_encode($response);
    }

    public function deallocateOrdersFromTrip(): void
    {
        if ($_SERVER['REQUEST_METHOD'] === 'POST') {
            $ids = $this->input->post('deleteids');
            $result = false;
            if (!empty($ids)) {
                $this->common->updatetbledata_where_in('tb_orders', ['trip_sts' => 0, 'shift_id' => 0, 'trip_id' => 0, 'status' => 1, 'shipmentid' => ''], ['col' => 'id', 'arr' => $ids], []);
                $this->common->updatetbledata_where_in('tb_stop_status', ['status' => 0], ['col' => 'order_id', 'arr' => $ids], ['status_code' => '0212']);
                $result = true;
            }
            echo $result ? "success" : "failed";
        }
    }
    
    public function savenewpod(){
        $order_id = $this->input->post("order_id",true);
        $order_number = $this->input->post("order_number",true);
        $company_code = $this->input->post("company_code",true);
        $branch_code = $this->input->post("branch_code",true);
        $country_code = $this->session->userdata( "usr_tzone" )['country'];
        $ship_id = $this->input->post("ship_id",true);
        $trip_id = $this->input->post("trip_id",true);
        $stop_id = $this->input->post("stop_id",true);
        $doc_type = $this->input->post("doc_type",true);

        $sts = "no";
        $fileName = "";
        $curtz = $this->session->userdata("usr_tzone")['timezone'];
        $logdate = date('Y-m-d H:i:s');
        $getactual = getdatetimebytimezone(DFLT_TZ,$logdate,$curtz);
        $curdt = $getactual['datetime'];
        $userid = $this->session->userdata('user_id');
        $plat = $plng = "";
    
        if (isset($_FILES)) {
            if (isset($_FILES['file_name']['name'])) {
                $config = array(
                    'upload_path'   => NEW_POD_PATH,
                    'allowed_types' => 'jpeg|jpg|gif|png|pdf|JPEG|JPG|PNG'
                );
                $file_name = $_FILES['file_name']['name'];
                $file_name = str_replace(" ","",$file_name);
                $files = explode('.',$_FILES['file_name']['name'] ?? '');
                $file_ext= @strtolower(end($files));
                $expensions= array("jpeg","jpg","png","gif","pdf");
    
                if(in_array($file_ext,$expensions)){
                    if ($file_ext == "pdf") {
                        if (!($this->inspectpdflibrary->validatepdf($_FILES['file_name']['tmp_name']))) {
                            echo '3';
                            return;
                        }
                    }
                    $countryCode = substr($company_code,0,-2);
                    $documentId = "";
                    $config['file_name'] = "RL".$order_number.".pdf";
                    if($doc_type == 3) {
                        $documentId = $this->documentsequencelibrary->getSequence('ETN', $countryCode, $doc_type);
                        $config['file_name'] = $documentId.".pdf";
                    }
    
                    if($file_ext == "pdf"){
                        $imgtype = "pdf";
                        $this->load->library('upload', $config);
                        if ($this->upload->do_upload('file_name')) {
                            $imgname = $this->upload->data();
                            $imgtype = $imgname['image_type'];
                            $fileName = $imgname['file_name'];
                            $filePath = NEW_POD_PATH.$fileName;
                            $imgSizes = filesize($_FILES['file_name']['tmp_name']);
    
                            // ✅ Get Base64 for PDF
                            if (file_exists($filePath)) {
                                $fileContent = file_get_contents($filePath);
                                $base64 = 'data:application/pdf;base64,'.base64_encode($fileContent);
                                //log_message('error', 'POD11 PDF Base64 (order_id: '.$order_id.'): '.$base64);
                                
                                $base64String = base64_encode($fileContent);
                            }
                        }
                    } else {
                        $fileName = date('dmyhis').''.$file_name;
                        $filePath = NEW_POD_PATH.$fileName;
                        $imgsize = getimagesize($_FILES['file_name']['tmp_name']);
                        $imgSizes = filesize($_FILES['file_name']['tmp_name']);
                        if($imgsize == FALSE){ }else{
                            $top_width = $imgsize[0];
                            $top_height = $imgsize[1];
                            $quality = 100;
                            if($file_ext == "png"){
                                $top = @imagecreatefrompng($_FILES['file_name']['tmp_name']);
                                $imgtype = "png";
                            }else{
                                $top = @imagecreatefromjpeg($_FILES['file_name']['tmp_name']);
                                if($file_ext == "jpg" || $file_ext == "jpeg"){
                                    $imgtype = "jpeg";
                                }else{
                                    $imgtype = $file_ext;
                                }
                            }
                            if($top){
                                header('Content-Type: image/jpeg');
                                @imagejpeg($top,$filePath,$quality);
                                @imagedestroy($top);
    
                                // ✅ Get Base64 for image
                                if (file_exists($filePath)) {
                                     $fileContent = file_get_contents($filePath);
                                    $base64 = 'data:application/pdf;base64,'.base64_encode($fileContent);
                                    //log_message('error', 'POD11 PDF Base64 (order_id: '.$order_id.'): '.$base64);
                                
                                    $base64String = base64_encode($fileContent);
                                }
                            }else{
                                $fileName = "";
                                $sts = "2";
                            }
                        }
                    }
                    
                   
    
                    // ✅ Rest of your original logic (unchanged)
                    $createdsource = "";
                    if($fileName != "" && $doc_type != ""){
                        $stoptype = $this->db->select("stoptype,plat,plng")->get_where("tb_shiporder_stops",array("id"=>$stop_id,"stoptype"=>"D","status"=>1),1,0);
    
                        if($stoptype->num_rows()>0){
                            $stype = "D";
                            $plat = $stoptype->row()->plat;
                            $plng = $stoptype->row()->plng;
    
                        }else{
                            $stype = "P";
                            $stoptype = $this->db->select("stoptype,plat,plng")->get_where("tb_shiporder_stops",array("id"=>$stop_id,"stoptype"=>"P","status"=>1),1,0);
                            if($stoptype->num_rows()>0){
                                $plat = $stoptype->row()->plat;
                                $plng = $stoptype->row()->plng;
                            }
                        }
                        if($stop_id == ""){ $stop_id = 0; }
                        $fileData = "INSERT INTO `tb_pod_uploads` (`stop_id`, `shipment_id`, `trip_id`, `doc_type`, `imgpath`, `stop_type`, `order_id`, `status`, `user_id`, `longitude`, `latitude`, `createdon`, `filesize`, `hash`) VALUES (?,?,?, ?, ?, ?, ?, 1, ?, ?, ?, ?,?, UUID())";
                        $res = $this->db->query($fileData,[$stop_id,$ship_id,$trip_id,$doc_type,$fileName,$stype,$order_id,$userid,$plng,$plat,$curdt,$imgSizes]);
                        
                        if($stype == 'P' && $doc_type == '4')
                        {
                            $otmDocType='APACPUP';
                        }
                        else if($stype == 'P' && $doc_type == '1')
                        {
                            $otmDocType='APACPUPESIGN';
                        }
                        else if($stype == 'D' && $doc_type == '3')
                        {
                            $otmDocType='APACPOD';
                        }
                        else if($stype == 'D' && $doc_type == '1')
                        {
                            $otmDocType='APACPODESIGN';
                        }
                        else
                        {
                            $otmDocType='APACOTHERS';
                        }
                        
                        $docTypeCnt = $this->common->getCount(
                            ['order_id' => $order_id, 'doc_type' => $doc_type, 'status' => 1],
                            'tb_pod_uploads'
                        );
                        log_message("error","Qryyyy::".$this->db->last_query());
                        log_message("error","docTypeVal::".$docTypeCnt);
                        if($docTypeCnt>1){
                            $otmDocType = $otmDocType . "-" . ($docTypeCnt - 1);
                        }
                        
                        log_message("error","otmDocType:".$otmDocType);
                                
                        $domainDetails = $this->OtmBookingModel->getDomain($order_id);
                        if (!empty($domainDetails)) {
                            $extOrderId = $domainDetails[0]['external_order_id'];
                            $domainName = $domainDetails[0]['ref_value'];
                            $domainCreatedSource = $domainDetails[0]['created_source'];
                            if($domainName<>"")
                            {
                                $otmRequest = [
                                    'glogDate' => date("Ymdhis"),
                                    'externalOrderId' => $extOrderId,
                                    'domainName' => $domainName,
                                    'createdSource'=> $createdsource ? $createdsource :  $domainCreatedSource,
                                    'timeZone' => $curtz ?? "",
                                    'base64String' => $base64String ?? "",
                                    'docType' => $otmDocType ?? ""
                                ];
                                                
                                $output = sendOTMDocuments($otmRequest);
                            }
                        }
                                       
                        if($order_id != "0"){
                            $postdata = array();
                            $postdata['ord_id'] = $order_id;
                            $getOrderDetails = $this->Completedordersmodel->getOrderDetailsWithLatLngs($order_id);
                            if(!empty($getOrderDetails)) {
                                $createdsource = $getOrderDetails['createdSource'];
                                if($createdsource == OrderSources::ETNQUOTE){
                                    $postdata['user_id'] = $getOrderDetails['userId'];
                                    $postdata['status_code'] = '3060';
                                    $postdata['hrs'] = $this->session->userdata("usr_tzone")['hrs'];
                                    // $updsts = $this->svkonektquote->getstatusresponse($postdata);
                                }
                            }
                            if($stype == 'D' && $doc_type == DocumentType::POD && $createdsource != OrderSources::SALOG){
                                $this->sendnotify('pod_note',$order_id,$filePath);
                            }
                        }
                        if($createdsource != OrderSources::SALOG){
                            $chkref = "XSR";
                            $whrin = " AND reference_id in('XSR','SD') ";
                            $sql = "SELECT reference_id,ref_value FROM tb_order_references WHERE order_id=? $whrin AND ref_value!='' GROUP BY reference_id HAVING count(reference_id)>=1";
                            $chkordtypeqry = $this->db->query($sql,[$order_id]);
                            $refval = $refvalue = "";
                            $iofeof = "EOF";
                            if($chkordtypeqry->num_rows()>1){
                                foreach($chkordtypeqry->result() as $oref){
                                    if($oref->reference_id == "XSR"){
                                        $refvalue = $oref->ref_value;
                                    }
                                    if($oref->reference_id == "SD" && $oref->ref_value == "2"){
                                        $iofeof = "IOF";
                                    }
                                }
                                $chkparty = "SELECT party_id,partycontact_id,customer_id,email_note,emailid,party_name FROM tb_contact_notifys WHERE status=1 AND (pod_note=1 OR all_note=1) GROUP BY emailid";
                                $query = $this->db->query($chkparty);
                            }
                        }
    
                        $sts = "1";
                    }
                }else{
                    $sts = "format";
                }
            }
        }
        echo $sts;
    }
    
    /*public function savenewpod(){
        log_message("error","Inn");
        $order_id = $this->input->post("order_id",true);
        $order_number = $this->input->post("order_number",true);
        $company_code = $this->input->post("company_code",true);
        $branch_code = $this->input->post("branch_code",true);
        $country_code = $this->session->userdata( "usr_tzone" )['country'];
        $ship_id = $this->input->post("ship_id",true);
        $trip_id = $this->input->post("trip_id",true);
        $stop_id = $this->input->post("stop_id",true);
        $doc_type = $this->input->post("doc_type",true);
        
        $sts = "no";
        $fileName = "";
        $curtz = $this->session->userdata("usr_tzone")['timezone'];
        $logdate = date('Y-m-d H:i:s');
        $getactual = getdatetimebytimezone(DFLT_TZ,$logdate,$curtz);
        $curdt = $getactual['datetime'];
        $userid = $this->session->userdata('user_id');
        $plat = $plng = "";
        if (isset($_FILES)) {
            if (isset($_FILES['file_name']['name'])) {
                $config = array('upload_path'   => NEW_POD_PATH,
                    'allowed_types' => 'jpeg|jpg|gif|png|pdf|JPEG|JPG|PNG'
                );
                $file_name = $_FILES['file_name']['name'];
                $file_name = str_replace(" ","",$file_name);
                $files = explode('.',$_FILES['file_name']['name'] ?? '');
                $file_ext= @strtolower(end($files));
                $expensions= array("jpeg","jpg","png","gif","pdf");
                if(in_array($file_ext,$expensions)){
                    if ($file_ext == "pdf") {
                        if (!($this->inspectpdflibrary->validatepdf($_FILES['file_name']['tmp_name']))) {
                            echo '3';
                            return;
                        }
                    }
                    $countryCode = substr($company_code,0,-2);
                    $documentId = "";
                    $config['file_name'] = "RL".$order_number.".pdf";
                    if($doc_type == 3) {
                        $documentId = $this->documentsequencelibrary->getSequence('ETN', $countryCode, $doc_type);
                        $config['file_name'] = $documentId.".pdf";
                    }
                    if($file_ext == "pdf"){
                        $imgtype = "pdf";
                        $this->load->library('upload', $config);
                        if ($this->upload->do_upload('file_name')) {
                            $imgname = $this->upload->data();
                            $imgtype = $imgname['image_type'];
                            $fileName = $imgname['file_name'];
                            $filePath = NEW_POD_PATH.$fileName;
    						$imgSizes = filesize($_FILES['file_name']['tmp_name']);
                        }
                    }else{
                        $fileName = date('dmyhis').''.$file_name;
                        $filePath = NEW_POD_PATH.$fileName;
                        $imgsize = getimagesize($_FILES['file_name']['tmp_name']);
                        $imgSizes = filesize($_FILES['file_name']['tmp_name']);
                        if($imgsize == FALSE){ }else{
                            $top_width = $imgsize[0];
                            $top_height = $imgsize[1];
                            $quality = 100;
                            if($file_ext == "png"){
                                $top = @imagecreatefrompng($_FILES['file_name']['tmp_name']);
                                $imgtype = "png";
                            }else{
                                $top = @imagecreatefromjpeg($_FILES['file_name']['tmp_name']);
                                if($file_ext == "jpg" || $file_ext == "jpeg"){
                                    $imgtype = "jpeg";
                                }else{
                                    $imgtype = $file_ext;
                                }
                            }
                            if($top){
                                header('Content-Type: image/jpeg');
                                @imagejpeg($top,$filePath,$quality);
                                @imagedestroy($top);
                            }else{
                                $fileName = "";
                                $sts = "2";
                            }
                        }
                    }
                    $createdsource = "";
                    if($fileName != "" && $doc_type != ""){
                        $stoptype = $this->db->select("stoptype,plat,plng")->get_where("tb_shiporder_stops",array("id"=>$stop_id,"stoptype"=>"D","status"=>1),1,0);
    
                        if($stoptype->num_rows()>0){
                            $stype = "D";
                            $plat = $stoptype->row()->plat;
                            $plng = $stoptype->row()->plng;
    
                        }else{
                            $stype = "P";
                            $stoptype = $this->db->select("stoptype,plat,plng")->get_where("tb_shiporder_stops",array("id"=>$stop_id,"stoptype"=>"P","status"=>1),1,0);
                            if($stoptype->num_rows()>0){
                                $plat = $stoptype->row()->plat;
                                $plng = $stoptype->row()->plng;
                            }
                        }
                        if($stop_id == ""){ $stop_id = 0; }
                        $fileData = "INSERT INTO `tb_pod_uploads` (`stop_id`, `shipment_id`, `trip_id`, `doc_type`, `imgpath`, `stop_type`, `order_id`, `status`, `user_id`, `longitude`, `latitude`, `createdon`, `filesize`, `hash`) VALUES (?,?,?, ?, ?, ?, ?, 1, ?, ?, ?, ?,?, UUID())";
                        $res = $this->db->query($fileData,[$stop_id,$ship_id,$trip_id,$doc_type,$fileName,$stype,$order_id,$userid,$plng,$plat,$curdt,$imgSizes]);
                        if($order_id != "0"){
                            $postdata = array();
                            $postdata['ord_id'] = $order_id;
                            $getOrderDetails = $this->Completedordersmodel->getOrderDetailsWithLatLngs($order_id);
                            if(!empty($getOrderDetails)) {
                                $createdsource = $getOrderDetails['createdSource'];
                                if($createdsource == OrderSources::ETNQUOTE){
                                    $postdata['user_id'] = $getOrderDetails['userId'];
                                    $postdata['status_code'] = '3060';
                                    $postdata['hrs'] = $this->session->userdata("usr_tzone")['hrs'];
                                    // $updsts = $this->svkonektquote->getstatusresponse($postdata);
                                }
                            }
                            if($stype == 'D' && $doc_type == DocumentType::POD && $createdsource != OrderSources::SALOG){
                                $this->sendnotify('pod_note',$order_id,$filePath);
                            }
                        }
                        if($createdsource != OrderSources::SALOG){
                            $chkref = "XSR";
                            $whrin = " AND reference_id in('XSR','SD') ";
                            $sql = "SELECT reference_id,ref_value FROM tb_order_references WHERE order_id=? $whrin AND ref_value!='' GROUP BY reference_id HAVING count(reference_id)>=1";
                            $chkordtypeqry = $this->db->query($sql,[$order_id]);
                            $refval = $refvalue = "";
                            $iofeof = "EOF";
                            if($chkordtypeqry->num_rows()>1){
                                foreach($chkordtypeqry->result() as $oref){
                                    if($oref->reference_id == "XSR"){
                                        $refvalue = $oref->ref_value;
                                    }
                                    if($oref->reference_id == "SD" && $oref->ref_value == "2"){
                                        $iofeof = "IOF";
                                    }
                                }
                                $chkparty = "SELECT party_id,partycontact_id,customer_id,email_note,emailid,party_name FROM tb_contact_notifys WHERE status=1 AND (pod_note=1 OR all_note=1) GROUP BY emailid";
                                $query = $this->db->query($chkparty);
                            }
                        }
    
                        $sts = "1";
                    }
                }else{
                    $sts = "format";
                }
            }
        }
        echo $sts;
    }*/
    
    public function Collins($method = null, $param = null) {
        if ($method === 'SVK_CollinsSTSUpdate') {
            $this->SVK_CollinsSTSUpdate($param);
        } else {
            show_404();
        }
    }
    
    public function SVK_CollinsSTSUpdate($id = NULL) {
        if ($this->session->userdata('user_role_id') === "5") {
            redirect("knops/massstatus");
        }
        if (!checkUrlAccessForUser('GLOBAL-MASSSTATUS')) {
            redirect("Forbiddenaccess");
        }
        if ($id != "") {
            $this->svkstatuslist($id);
        } else {
            $this->svkstatuslist();
        }
    }

    public function svkstatuslist($id = null)
    {
      
        $data['page_title'] = $this->lang->line('menu_massstsupd');;
        $data['sub_title'] = $this->lang->line('general_search');;
        $uid = $this->session->userdata("user_id");
        $curtz = $this->session->userdata("usr_tzone")['timezone'];
        $chk_usrtype = $this->session->userdata("business_type");
        $excel_uploaddata = [];
        $list_type = 0;
       
        if ($id != "") {
            
            if ($id == "01") {
                $filedata = @file_get_contents("assets/ordertemplate/massstatusdata.txt");
                $excel_uploaddata = @json_decode($filedata);
                
                if (!empty($excel_uploaddata)) {
                    $list_type = 1;
                    @file_put_contents("assets/ordertemplate/massstatusdata.txt", "");
                    $logs = addordertologs($filedata);
                   
                }
            }
        }

        $carrierwhr = "";

        if ($chk_usrtype == "Carrier") {
            $carrierwhr = " AND o.vendor_id=" . $this->session->userdata("id");
           

            if (checkAccessConditions('RELATED_2_SG_MY', $this->session->userdata('company_code'))) {
                $carrierIds = getCarrierids($this->session->userdata("carrier_code"));

                if (count($carrierIds) > 1) {
                    $carrierIdValues = implode("','", $carrierIds);
                    $carrierwhr = "AND o.vendor_id IN ('" . $carrierIdValues . "')";
                }
            }
        } else {
            $carrierwhr = " AND o.user_id=" . $uid;
        }

        $config = [];
        $item = "";
        $post = $this->input->post(null, true);

        if (isset($post['searchsubmit']) || isset($post['order_id'])) {
            if (isset($post['searchsubmit'])) {
                $item = trim($this->db->escape_str($post['searchsubmit']));
            } else {
                $item = 1;
            }
        }

        if (isset($item) && $item != "") {
            $where1 = '';
            if (isset($post['bookingid']) && !empty($post['bookingid'])) {
                $where1 = "AND o.order_id IN ('" . implode("','", $post['bookingid']) . "') ";
            }
            if (isset($post['reference']) && !empty($post['reference'])) {
                $ref = $this->MassStatusModel->getOrderRefValues($post['reference']);
                if (!empty($ref)) {
                    foreach ($ref as $result) {
                        $oid[] = $result['order_id'];
                    }
                    $oids = implode(",", $oid);
                    $where1 .= "AND o.id IN ($oids)";
                }else{
                    $where1 = "AND o.id = 0";
                }
            }

            if (isset($post['trip_id']) && $post['trip_id'] != "") {
                $post_trip_id = $this->db->escape_str($post['trip_id']);
                $where1 .= "AND o.shipmentid LIKE '%" . $post_trip_id . "%' ";
            }

            if (isset($post['container_no']) && $post['container_no'] != "") {
                $post_container_no = $this->db->escape_str($post['container_no']);
                $sql = "SELECT order_id FROM tb_order_references WHERE status=1 AND ref_value!='' AND ref_value LIKE '%" . $post_container_no . "%'";
                $ref11 = $this->db->query($sql);
                if ($ref11->num_rows() > 0) {
                    foreach ($ref11->result() as $gh) {
                        $oid11[] = $gh->order_id;
                    }
                    $kk = implode(",", $oid11);
                    $where1 .= "AND o.id IN ($kk) ";
                }
            }

            if (isset($post['driver']) && $post['driver'] != "") {
                $post_driver = addslashes($this->db->escape_str($post['driver']));
                $where1 .= "AND (c.name LIKE '%" . $post_driver . "%' OR c.mobile LIKE '%" . $post_driver . "%' OR d.name LIKE '%" . $post_driver . "%' OR d.contact_num LIKE '%" . $post_driver . "%') ";
            }
            
            if (isset($post['vehicle']) && $post['vehicle'] != "") {
                $post_vehicle = addslashes($this->db->escape_str($post['vehicle']));
                $where1 = "AND v.register_number LIKE '%" . $post_vehicle . "%' ";
            }

            if (isset($post['ref_id']) && $post['ref_id'] != "") {
                $post_ref_id = addslashes($this->db->escape_str($post['ref_id']));
                $ref = $this->db->query("SELECT order_id FROM tb_order_references WHERE status=1 AND ref_value!='' AND ref_value LIKE '%" . $post_ref_id . "%' LIMIT 1");
                if ($ref->num_rows() > 0) {
                    $oid = $ref->row()->order_id;
                    $where1 .= "AND o.id LIKE '%" . $oid . "%' ";
                }
            }

            $searchwhr = " $where1";
            $searchwhr .= " AND o.shift_id > 0 ";
            //$mainqry = "SELECT o.id,o.order_id,o.shift_id,o.trip_id,o.shipmentid,v.vehicle_id,a.driver_id,a.imei,d.contact_num,d.track_type,d.track_vendor,d.sim_carrier,t.actual_carrier_acceptance FROM tb_orders o LEFT JOIN tb_trips t ON t.id=o.trip_id,tb_shft_veh v,tb_vendors c,tbl_assigned_drivers a,tb_truck_drivers d,tb_employee tbe WHERE o.shift_id=v.shft_id AND o.order_id=tbe.order_id AND v.carrier_id=c.id AND v.vehicle_id=a.vehicle_id AND a.driver_id=d.id AND v.status=1 AND a.status=1 AND d.status='Active' $searchwhr $carrierwhr AND o.status!=0 AND o.status!=3 AND o.trip_sts=0 GROUP BY o.order_id ORDER BY o.id DESC";
            //$mainqry = "SELECT o.id,o.order_id,o.shift_id,o.trip_id,o.shipmentid,v.vehicle_id,a.driver_id,a.imei,d.contact_num,d.track_type,d.track_vendor,d.sim_carrier,t.actual_carrier_acceptance FROM tb_orders o LEFT JOIN tb_trips t ON t.id=o.trip_id,tb_shft_veh v,tb_vendors c,tbl_assigned_drivers a,tb_truck_drivers d,tb_employee tbe WHERE o.shift_id=v.shft_id AND o.order_id=tbe.order_id AND v.carrier_id=c.id AND v.vehicle_id=a.vehicle_id AND a.driver_id=d.id AND v.status=1 AND a.status=1 AND d.status='Active' $searchwhr $carrierwhr AND o.status!=0 AND o.status!=3 AND o.trip_sts=0 GROUP BY o.order_id ORDER BY o.id DESC";
            $mainqry = "
                SELECT o.id, o.order_id, o.shift_id, o.trip_id,
                    o.shipmentid, v.vehicle_id, a.driver_id, a.imei,
                    d.contact_num, d.track_type, d.track_vendor, d.sim_carrier,
                    COALESCE(t.actual_carrier_acceptance, '') as actual_carrier_acceptance
                FROM tb_orders o
                LEFT JOIN tb_trips t ON t.id = o.trip_id
                LEFT JOIN tb_shft_veh v ON o.shift_id = v.shft_id
                LEFT JOIN tb_vendors c ON v.carrier_id = c.id
                LEFT JOIN tbl_assigned_drivers a ON v.vehicle_id = a.vehicle_id AND a.status = 1
                LEFT JOIN tb_truck_drivers d ON a.driver_id = d.id AND d.status = 'Active'
                WHERE o.status != 0 AND o.status != 3
                $carrierwhr
                $where1
                GROUP BY o.order_id, o.id
                ORDER BY o.id DESC
            ";            
            $shipmentCount = $this->MassStatusModel->getShipmentCount($searchwhr, $carrierwhr);
            /*elseif (isset($post['searchsubmita']) && $post['searchsubmita'] == "Search") {*/
            //$where1 = '';
            /*$searchwhr = " $where1";
            $searchwhr .= " AND o.shift_id > 0 ";
            $mainqry = "SELECT o.id,o.order_id,o.shift_id,o.trip_id,o.shipmentid,v.vehicle_id,a.driver_id,a.imei,d.contact_num,d.track_type,d.track_vendor,d.sim_carrier,t.actual_carrier_acceptance FROM tb_orders o LEFT JOIN tb_trips t ON t.id=o.trip_id,tb_shft_veh v,tb_vendors c,tbl_assigned_drivers a,tb_truck_drivers d,tb_employee tbe WHERE o.shift_id=v.shft_id  AND o.order_id=tbe.order_id AND v.carrier_id=c.id AND v.vehicle_id=a.vehicle_id AND a.driver_id=d.id AND v.status=1 AND a.status=1 AND d.status='Active' $searchwhr $carrierwhr AND o.status!=0 AND o.status!=3 AND o.trip_sts=0 GROUP BY o.order_id ORDER BY o.id DESC";
            $shipmentCount = $this->MassStatusModel->getShipmentCount($searchwhr, $carrierwhr);*/
        } 
        else {
            $where1 = '';

            if (!empty($post)) {
                if (isset($post['bookingid']) && !empty($post['bookingid'])) {
                    $where1 = "AND o.order_id IN ('" . implode("','", $post['bookingid']) . "') ";
                }

                if (isset($post['trip_id']) && $post['trip_id'] != "") {
                    $post_trip_id = $this->db->escape_str($post['trip_id']);
                    $where1 .= "AND o.shipmentid LIKE '%" . $post_trip_id . "%' ";
                }

                if (isset($post['container_no']) && $post['container_no'] != "") {
                    $post_container_no = $this->db->escape_str($post['container_no']);
                    $sql = "SELECT order_id FROM tb_order_references WHERE status=1 AND ref_value!='' AND ref_value LIKE '%" . $post_container_no . "%'";
                    $ref11 = $this->db->query($sql);
                    if ($ref11->num_rows() > 0) {
                        foreach ($ref11->result() as $gh) {
                            $oid11[] = $gh->order_id;
                        }
                        $kk = implode(",", $oid11);
                        $where1 .= "AND o.id IN ($kk) ";
                    }
                }

                if (isset($post['driver']) && $post['driver'] != "") {
                    $post_driver = addslashes($this->db->escape_str($post['driver']));
                    $where1 .= "AND (c.name LIKE '%" . $post_driver . "%' OR c.mobile LIKE '%" . $post_driver . "%' OR d.name LIKE '%" . $post_driver . "%' OR d.contact_num LIKE '%" . $post_driver . "%') ";
                }
                if (isset($post['reference']) && !empty($post['reference'])) {
                    $ref = $this->MassStatusModel->getOrderRefValues($post['reference']);
                    if (!empty($ref)) {
                        foreach ($ref as $result) {
                            $oid[] = $result['order_id'];
                        }
                        $oids = implode(",", $oid);
                        $where1 .= "AND o.id IN ($oids)";
                    }else{
                        $where1 = "AND o.id = 0";
                    }
                }
            }

            $searchwhr = " $where1";
            $searchwhr .= " AND o.shift_id > 0 ";
    //        $mainqry = "
    //     SELECT o.id, o.order_id, o.shift_id, o.trip_id,
    //            o.shipmentid, v.vehicle_id, a.driver_id, a.imei,
    //            d.contact_num, d.track_type, d.track_vendor, d.sim_carrier,
    //            t.actual_carrier_acceptance
    //     FROM tb_orders o
    //     LEFT JOIN tb_trips t ON t.id = o.trip_id
    //     LEFT JOIN tb_shft_veh v ON o.shift_id = v.shft_id
    //     LEFT JOIN tb_vendors c ON v.carrier_id = c.id
    //     LEFT JOIN tbl_assigned_drivers a ON v.vehicle_id = a.vehicle_id
    //     LEFT JOIN tb_truck_drivers d ON a.driver_id = d.id
    //     LEFT JOIN tb_employee tbe ON o.order_id = tbe.order_id
    //     WHERE o.status != 0 AND o.status != 3
    //       $carrierwhr
    //     GROUP BY o.order_id, o.id
    //     ORDER BY o.id DESC
    // ";
    $mainqry = "
    SELECT o.id, o.order_id, o.shift_id, o.trip_id,
           o.shipmentid, v.vehicle_id, a.driver_id, a.imei,
           d.contact_num, d.track_type, d.track_vendor, d.sim_carrier,
           COALESCE(t.actual_carrier_acceptance, '') as actual_carrier_acceptance
    FROM tb_orders o
    LEFT JOIN tb_trips t ON t.id = o.trip_id AND o.trip_id > 0
    LEFT JOIN tb_shft_veh v ON o.shift_id = v.shft_id
    LEFT JOIN tb_vendors c ON v.carrier_id = c.id
    LEFT JOIN tbl_assigned_drivers a ON v.vehicle_id = a.vehicle_id AND a.status = 1
    LEFT JOIN tb_truck_drivers d ON a.driver_id = d.id AND d.status = 'Active'
    LEFT JOIN tb_employee tbe ON o.order_id = tbe.order_id
    WHERE o.status != 0 AND o.status != 3
      $carrierwhr
    GROUP BY o.order_id, o.id
    ORDER BY o.id DESC
";
   
            $shipmentCount = $this->MassStatusModel->getShipmentCount($searchwhr, $carrierwhr);
        }

        $ordcount = $shipmentCount ?? 0;
        $config["base_url"] = base_url() . "admin/Collins/SVK_CollinsSTSUpdate";
        $config["total_rows"] = $ordcount;
        $config["per_page"] = 10;
        $config["uri_segment"] = 4;
        $config['display_pages'] = true;
        $this->pagination->initialize($config);
        $page = ($this->uri->segment(4)) ? (int)$this->uri->segment(4) : 0;
        if ($page == "01") {
            $page = 0;
        }
        $mainqry = $mainqry . " LIMIT ?,?";
        $custord = $this->db->query($mainqry, [$page, $config["per_page"]]);
       
        $data['tripsdata'] = [];
        if ($custord->num_rows() > 0) {
           
            $shiftIds = array_column($custord->result(), 'shift_id');
            $orderRowIds = array_column($custord->result(), 'id');
            $bookingIds = array_column($custord->result(), 'order_id');
            $vehicleIds = array_column($custord->result(), 'vehicle_id');
            $shipOrderDetails = $this->MassStatusModel->getShipOrderDetails($shiftIds, $bookingIds);
            $orderReferences = $this->MassStatusModel->getOrderReferenceByOrderIds($orderRowIds);
            $tripData = $this->MassStatusModel->getTripData($shiftIds, $bookingIds);
            $driversData = $this->MassStatusModel->getLatestDriverDataByVehicle(array_unique($vehicleIds));
            $shipOrderStopsByPickOrDropId = $this->MassStatusModel->getShipOrderStopsByPickOrDropId($shiftIds, $bookingIds);
            foreach ($custord->result() as $res) {
                $ship_id = $res->shift_id;
                $multiship = 0;
                $tripid = $res->trip_id;
                $vehicle_id = $res->vehicle_id;
                $driver_id = $res->driver_id;
                $shipmentid = $res->shipmentid;
                
                // For shipments with trip
                if ($tripid > 0 && isset($tripData[$res->order_id])) {
                    $eachOrderTripData = $tripData[$res->order_id];
                    if (!empty($eachOrderTripData)) {
                        $tripid = ($eachOrderTripData['trip_id'] > 0) ? $eachOrderTripData['trip_id'] : $tripid;
                        $vehicle_id = ($eachOrderTripData['vehicle_id'] > 0) ? $eachOrderTripData['vehicle_id'] : $vehicle_id;
                        $driver_id = ($eachOrderTripData['driver_id'] > 0) ? $eachOrderTripData['driver_id'] : $driver_id;
                    }
                }
                
                // For shipments without trip, get driver from vehicle assignment
                if ($tripid <= 0) {
                    if ($driver_id === 0 && !empty($vehicle_id)) {
                        $driver_id = $driversData[$vehicle_id] ?? $res->driver_id;
                    }
                }
                if ($tripid == 0 && $vehicle_id != "") {
                    $driver_id = $driversData[$vehicle_id] ?? 0;
                    if ($driver_id === 0) {
                        $driver_id = $res->driver_id;
                    }
                }
                $tracktype = 0;
                $trackvendor = $simcarrier = $contact_num = "";
                if ($res->track_type == 1) {
                    $tracktype = 1;
                    $trackvendor = $res->track_vendor;
                    $simcarrier = $res->sim_carrier;
                    $contact_num = $res->contact_num;
                }
                $ordid = $res->id;
                $refers = $orderReferences[$res->id] ?? [];
                $saccept = $sgatein = $spickup = $sgateout = $intransit = $dgatein = $dpickup = $dgateout = 0;
                $s_saccept = $s_sgatein = $s_spickup = $s_sgateout = $s_intransit = $s_dgatein = $s_dpickup = $s_dgateout = 0;
                $s_sacceptcr = $s_sgateincr = $s_spickupcr = $s_sgateoutcr = $s_intransitcr = $s_dgateincr = $s_dpickupcr = $s_dgateoutcr = "";
                $pstpid = $dstpid = $pstodetailid = $dstodetailid = "";
                $removeTripFromOrderFlag = false;
                // Get stop status details - handle both with and without trip
if ($tripid > 0) {
    $stopStatusDetails = $this->MassStatusModel->getStopStatusDetails($curtz, $ship_id, $tripid);
} else {
    // Create a new function in your model for no-trip shipments
    $stopStatusDetails = $this->MassStatusModel->getStopStatusDetailsNoTrip($curtz, $ship_id, $res->order_id);
}
                if (!empty($stopStatusDetails)) {
                    foreach ($stopStatusDetails as $eachStopDetails) {
                        $status_orderid = $eachStopDetails['order_id'];
                        if ($eachStopDetails['sid'] == 35) {
                            if ($eachStopDetails['id'] != "" && $eachStopDetails['status_id'] == 35) {
                                $pstpid = $eachStopDetails['stop_id'];
                                $pstodetailid = $eachStopDetails['stop_detail_id'];
                                $saccept = $eachStopDetails['status_id'];
                                $s_saccept = 1;
                                $s_sacceptcr = date('d-m-Y H:i:s', strtotime($eachStopDetails['createdon'] ?? ""));
                                if ($pstpid == "0" || $pstpid == "") {
                                    if (isset($tripData[$res->order_id])) {
                                        $pstpid = $tripData[$res->order_id]['id'];
                                        $pstodetailid = $tripData[$res->order_id]['stopdetailsid'];
                                    }
                                }
                            } else {
                                if (isset($tripData[$res->order_id])) {
                                    $pstpid = $tripData[$res->order_id]['id'];
                                    $pstodetailid = $tripData[$res->order_id]['stopdetailsid'];
                                    $saccept = $eachStopDetails['sid'];
                                }
                            }
                        }
                        if ($eachStopDetails['sid'] == 2) {
                            if ($eachStopDetails['id'] != "" && $eachStopDetails['status_id'] == 2 && $eachStopDetails['stop_type'] == "P") {
                                $pstpid = $eachStopDetails['stop_id'];
                                $pstodetailid = $eachStopDetails['stop_detail_id'];
                                $sgatein = $eachStopDetails['status_id'];
                                if ($status_orderid == $ordid) {
                                    $s_sgatein = 1;
                                    $s_sgateincr = date('d-m-Y H:i:s', strtotime($eachStopDetails['createdon'] ?? ""));
                                }
                            } else {
                                if (isset($shipOrderStopsByPickOrDropId[$res->order_id])) {
                                    $pstpid = $shipOrderStopsByPickOrDropId[$res->order_id]['id'];
                                    $pstodetailid = $shipOrderStopsByPickOrDropId[$res->order_id]['stopdetailsid'];
                                    $sgatein = $eachStopDetails['sid'];
                                }
                            }
                            if ($eachStopDetails['id'] != "" && $eachStopDetails['status_id'] == 2 && $eachStopDetails['stop_type'] == "D") {
                                $dstpid = $eachStopDetails['stop_id'];
                                $dstodetailid = $eachStopDetails['stop_detail_id'];
                                $dgatein = $eachStopDetails['status_id'];
                                if ($status_orderid == $ordid) {
                                    $s_dgatein = 1;
                                    $s_dgateincr = date('d-m-Y H:i:s', strtotime($eachStopDetails['createdon'] ?? ""));
                                }
                            } else {
                                if (isset($tripData[$res->order_id])) {
                                    $dstpid = $tripData[$res->order_id]['id'];
                                    $dstodetailid = $tripData[$res->order_id]['stopdetailsid'];
                                    $dgatein = $eachStopDetails['sid'];
                                }
                            }
                        }

                        if ($eachStopDetails['sid'] == 1) {
                            if ($eachStopDetails['id'] != "" && $eachStopDetails['status_id'] == 1 && $eachStopDetails['stop_type'] == "P") {
                                $pstpid = $eachStopDetails['stop_id'];
                                $pstodetailid = $eachStopDetails['stop_detail_id'];
                                $spickup = $eachStopDetails['status_id'];
                                if ($status_orderid == $ordid) {
                                    $s_spickup = 1;
                                    $s_spickupcr = date('d-m-Y H:i:s', strtotime($eachStopDetails['createdon']));
                                }
                            } else {
                                if (isset($tripData[$res->order_id])) {
                                    $pstpid = $tripData[$res->order_id]['id'];
                                    $pstodetailid = $tripData[$res->order_id]['stopdetailsid'];
                                    $spickup = $eachStopDetails['sid'];
                                }
                            }
                            if ($eachStopDetails['id'] != "" && $eachStopDetails['status_id'] == 1 && $eachStopDetails['stop_type'] == "D") {
                                $dstpid = $eachStopDetails['stop_id'];
                                $dstodetailid = $eachStopDetails['stop_detail_id'];
                                $dpickup = $eachStopDetails['status_id'];
                                if ($status_orderid == $ordid) {
                                    $s_dpickup = 1;
                                    $s_dpickupcr = date('d-m-Y H:i:s', strtotime($eachStopDetails['createdon']));
                                }
                            } else {
                                if (isset($tripData[$res->order_id])) {
                                    $dstpid = $tripData[$res->order_id]['id'];
                                    $dstodetailid = $tripData[$res->order_id]['stopdetailsid'];
                                    $dpickup = $eachStopDetails['sid'];
                                }
                            }
                        }
                        if ($eachStopDetails['sid'] == 3) {
                            if ($eachStopDetails['id'] != "" && $eachStopDetails['status_id'] == 3 && $eachStopDetails['stop_type'] == "P") {
                                $pstpid = $eachStopDetails['stop_id'];
                                $pstodetailid = $eachStopDetails['stop_detail_id'];
                                $sgateout = $eachStopDetails['status_id'];
                                if ($status_orderid == $ordid) {
                                    $s_sgateout = 1;
                                    $s_sgateoutcr = date('d-m-Y H:i:s', strtotime($eachStopDetails['createdon']));
                                }
                            } else {
                                if (isset($tripData[$res->order_id])) {
                                    $pstpid = $tripData[$res->order_id]['id'];
                                    $pstodetailid = $tripData[$res->order_id]['stopdetailsid'];
                                    $sgateout = $eachStopDetails['sid'];
                                }
                            }
                            if ($eachStopDetails['id'] != "" && $eachStopDetails['status_id'] == 3 && $eachStopDetails['stop_type'] == "D") {
                                $dstpid = $eachStopDetails['stop_id'];
                                $dstodetailid = $eachStopDetails['stop_detail_id'];
                                $dgateout = $eachStopDetails['status_id'];
                                if ($status_orderid == $ordid) {
                                    $s_dgateout = 1;
                                    $s_dgateoutcr = date('d-m-Y H:i:s', strtotime($eachStopDetails['createdon']));
                                }
                            } else {
                                if (isset($tripData[$res->order_id])) {
                                    $dstpid = $tripData[$res->order_id]['id'];
                                    $dstodetailid = $tripData[$res->order_id]['stopdetailsid'];
                                    $dgateout = $eachStopDetails['sid'];
                                }
                            }
                        }

                        if ($eachStopDetails['sid'] == 4) {
                            if ($eachStopDetails['id'] != "" && $eachStopDetails['status_id'] == 4) {
                                $pstpid = $eachStopDetails['stop_id'];
                                $pstodetailid = $eachStopDetails['stop_detail_id'];
                                $intransit = $eachStopDetails['status_id'];
                                if ($status_orderid == $ordid) {
                                    $s_intransit = 1;
                                    $s_intransitcr = date('d-m-Y H:i:s', strtotime($eachStopDetails['createdon']));
                                }
                            } else {
                                if (isset($tripData[$res->order_id])) {
                                    $pstpid = $tripData[$res->order_id]['id'];
                                    $pstodetailid = $tripData[$res->order_id]['stopdetailsid'];
                                    $intransit = $eachStopDetails['sid'];
                                }
                            }
                        }
                    }
                } else {
                    if (isset($shipOrderDetails[$res->order_id])) {
                        foreach ($shipOrderDetails[$res->order_id] as $res1) {
                            if ($res1['stoptype'] == "P") {
                                $saccept = 35;
                                $sgatein = 2;
                                $spickup = 1;
                                $sgateout = 3;
                                $intransit = 4;
                                $pstpid = $res1['id'];
                                $pstodetailid = $res1['stopdetailsid'];
                            }

                            if ($res1['stoptype'] == "D") {
                                $dgatein = 2;
                                $dpickup = 1;
                                $dgateout = 3;
                                $dstpid = $res1['id'];
                                $dstodetailid = $res1['stopdetailsid'];
                            }
                        }
                    }
                }
                if ($s_sgateincr != '' || $s_spickupcr != '' || $s_sgateoutcr != '') {
                    $removeTripFromOrderFlag = true;
                }
                
                $data['tripsdata'][] = [
                    "trip_id" => $tripid,
                    "ship_id" => $ship_id,
                    "ord_id" => $ordid,
                    "shipmentid" => $shipmentid,
                    "order_id" => $res->order_id,
                    "refers" => $refers,
                    "saccept" => $saccept,
                    "sgatein" => $sgatein,
                    "spickup" => $spickup,
                    "sgateout" => $sgateout,
                    "intransit" => $intransit,
                    "dgatein" => $dgatein,
                    "dpickup" => $dpickup,
                    "dgateout" => $dgateout,
                    "s_saccept" => $s_saccept,
                    "s_sgatein" => $s_sgatein,
                    "s_spickup" => $s_spickup,
                    "s_sgateout" => $s_sgateout,
                    "s_intransit" => $s_intransit,
                    "s_dgatein" => $s_dgatein,
                    "s_dpickup" => $s_dpickup,
                    "s_dgateout" => $s_dgateout,
                    "s_sacceptcr" => $s_sacceptcr,
                    "s_sgateincr" => $s_sgateincr,
                    "s_spickupcr" => $s_spickupcr,
                    "s_sgateoutcr" => $s_sgateoutcr,
                    "s_intransitcr" => $s_intransitcr,
                    "s_dgateincr" => $s_dgateincr,
                    "s_dpickupcr" => $s_dpickupcr,
                    "s_dgateoutcr" => $s_dgateoutcr,
                    "pstpid" => $pstpid,
                    "dstpid" => $dstpid,
                    "pstodetailid" => $pstodetailid,
                    "dstodetailid" => $dstodetailid,
                    "vehicle_id" => $vehicle_id,
                    "driver_id" => $driver_id,
                    "tracktype" => $tracktype,
                    "trackvendor" => $trackvendor,
                    "simcarrier" => $simcarrier,
                    "contact_num" => $contact_num,
                    "multiship" => $multiship,
                    "actual_carrier_acceptance" => $res->actual_carrier_acceptance,
                    "removeTripFromOrderFlag" => $removeTripFromOrderFlag
                ];
            }
        }
        $data['list_type'] = $list_type;
        $data['excel_uploaddata'] = $excel_uploaddata;
        $data['postdata'] = $post;
        $data['curtz'] = $curtz;
       
        $this->newtemplate->dashboard("admin/collinsMassStatus", $data);
    }
    
    public function update_order_svkstatus(){

    $arr = array();
    $trip_id = $arr['trip'] = $this->input->post("trip_id",true);
    $ship_id = $arr['ship'] = $this->input->post("ship_id",true);
    $ord_id = $arr['ord_id'] = $this->input->post("ord_id",true);
    $orderid = $arr['orderid'] = $this->input->post("orderid",true);
    $stopid = $arr['stopid'] = $this->input->post("stopid",true);
    $stopdetailid = $arr['stopdetailid'] = $this->input->post("stopdetid",true);
    $vehicle_id = $arr['vehicle_id'] = $this->input->post("vehicle_id",true);
    $driver_id = $arr['driver_id'] = $this->input->post("driver_id",true);
    $tracktype = $arr['tracktype'] = $this->input->post("tracktype",true);
    $trackvendor = $arr['trackvendor'] = $this->input->post("trackvendor",true);
    $contact_num = $arr['contact_num'] = $this->input->post("contact_num",true);
    $stype = $arr['stop_type'] = $this->input->post("stop_type",true);
    $stsid = $arr['stsid'] = $this->input->post("stsid",true);
    $sts = $arr['status'] = $this->input->post("status",true);
    $curtz = $arr['timezone'] = $this->session->userdata("usr_tzone")['timezone'];
    $seldt = $stsdate = $this->input->post("sts_date",true);
    
    $company_code = $this->session->userdata('company_code');
    $branch_code = $this->session->userdata('branch_code');
    $crossborder = $this->input->post('crossborder') ?? '0';
    if($crossborder >0){
        $earlyShipmentId = $this->input->post('earlyShipmentId') ?? "";
        $earlyStatusId = $this->input->post('earlystatusId') ?? "";
        $earlyStopTypeId = $this->input->post('earlyStopType') ?? "";
        if($earlyShipmentId != ""){
            if($this->checkEarlyLegStatus(['shipmentId'=>$earlyShipmentId,'statusId'=>$earlyStatusId,'stopType'=>$earlyStopTypeId])){
                echo 3;
                return;
            }
        }
    }
    if ($this->session->userdata('user_role_id') === "5") {
        $statusReason = "From KNOps";
    } else {
        $statusReason = "From Admin";
    }
    if(checkstsvaliddate($seldt)){
        $gentime = getdatetimebytimezone(DFLT_TZ,$seldt,$curtz);
        $stsdate = $gentime['datetime'];
    }else{
        $stsdate = "";
    }
    $arr['sts_date'] = $stsdate;
    $logdate = date('Y-m-d H:i:s');
    $getactual = getdatetimebytimezone(DFLT_TZ,$logdate,$curtz);
    $curdt = $getactual['datetime'];
    $hrs = $this->session->userdata("usr_tzone")['hrs'];
    $lgusrid = $this->session->userdata("user_id");
    $getOrderDetails = $this->Completedordersmodel->getOrderDetailsWithLatLngs($ord_id);
    $createdsource = $getOrderDetails['createdSource'];
    $plat = $getOrderDetails['plat'];
    $plng = $getOrderDetails['plng'];
    $dlat = $getOrderDetails['dlat'];
    $dlng = $getOrderDetails['dlng'];
    $customerId = $getOrderDetails['customer_id'];
    $tripid = $trip_id;
    $resultsts = 2;
       if($stsdate != "" && $sts == "0"){
           if ($vehicle_id > 0) {
               $this->common->updatetbledata("tb_trucks_data", ['latitude' => $stype === 'D' ? $dlat : $plat, 'longitude' => $stype === 'D' ? $dlng : $plng, 'receivedon' => $stsdate], ['id' => $vehicle_id]);
           }
        $stid = $stsid;
        if($stsid == "35"){ $stcode = "1600"; }
        if($stsid == "2" && $stype == "P"){ $stcode = "0420"; }
        if($stsid == "1" && $stype == "P"){ $stcode = "0500"; }
        if($stsid == "3" && $stype == "P"){ $stcode = "0191"; }
        if($stsid == "4"){ $stcode = "1550"; }
        if($stsid == "2" && $stype == "D"){ $stcode = "0192"; }
        if($stsid == "1" && $stype == "D"){ $stcode = "2300"; }
        if($stsid == "3" && $stype == "D"){ $stcode = "3000"; }
        if($stsid == "11"){ $stcode = "0218"; }
           $arr['status_code'] = $stcode;
           if ($this->session->userdata('company_code') == 'UKKN-CG' && $stcode != "1600") {
               $this->openbox_status_execution->pushStatusExecutionXml(["status" => $stcode, "order_row_id" => $ord_id, "trip_id" => $arr['trip'], "date_time" => $stsdate, "lat" => $latitude ?? "", "long" => $longitude ?? ""]);
           }

            if ($stsid == "35" && ($arr['trip'] == "0" || $arr['trip'] == "")) {
              $stcode = "1600";
                

             /*start trip*/
             $chqry = $this->db->select("id")->get_where("tb_trips",array('shift_id'=>$arr['ship'], 'vehicle_id'=>$arr['vehicle_id'], 'driver_id'=>$arr['driver_id']),1,0);
             if($chqry->num_rows() == 0){
                if($arr['contact_num'] == ""){
                    $newimei = $this->db->select("imei")->get_where("tbl_assigned_drivers",array('vehicle_id'=>$arr['vehicle_id'],'driver_id'=>$arr['driver_id'],'status'=>1),1,0);
                    if($newimei->num_rows()>0){
                        $arr['contact_num'] = $newimei->row()->imei;
                    }
                }
                $latitude = $plat;
                $longitude = $plng;

                if($this->session->userdata('company_code')=='PLKN'){
                     $getveh = $this->db->select("latitude,longitude")->get_where("tb_trucks_data",array("id"=>$arr['vehicle_id']),1,0);
                    if($getveh->num_rows()>0){
                        $latitude = $getveh->row()->latitude;
                        $longitude = $getveh->row()->longitude;
                    }
                }

                $triparr = array('shift_id'=>$arr['ship'], 'vehicle_id'=>$arr['vehicle_id'], 'driver_id'=>$arr['driver_id'], 'stime'=>$stsdate, 'start_imei'=>$arr['contact_num'], 'splace'=>"", 'eplace'=>"", 'start_reading'=>0, 'end_reading'=>0, 'created_on'=>$stsdate, 'updated_on'=>$curdt, 'status'=>1, 'trip_type'=>0, 'transit_status'=>0,"plat"=>$latitude,"plng"=>$longitude);
                $arr['trip'] = $this->common->insertTableData('tb_trips', $triparr);
                 $insarry = ["order_id" => $ord_id, "shipment_id" => $arr['ship'], "stop_id" => 0, "stop_detail_id" => 0, "stop_type" => "", "trip_id" => $arr['trip'], "status_id" => $stid, "latitude" => $latitude, "longitude" => $longitude, "status" => 1, "reason" => $statusReason, "vehicle_id" => $arr['vehicle_id'], "driver_id" => $arr['driver_id'], "status_code" => $stcode, "createdon" => $stsdate];
                 $ins = $this->db->insert("tb_stop_status", $insarry);
             }else{
                $arr['trip'] = $chqry->row()->id;
                $chqryx = $this->db->select("id")->get_where("tb_stop_status",array("order_id"=>$ord_id,"shipment_id"=>$arr['ship'],"status_id"=>$stid),1,0);
                if($chqryx->num_rows() == 0){
                    $insarry = ["order_id" => $ord_id, "shipment_id" => $arr['ship'], "stop_id" => 0, "stop_detail_id" => 0, "stop_type" => "", "trip_id" => $arr['trip'], "status_id" => $stid, "latitude" => $latitude, "longitude" => $longitude, "status" => 1, "reason" => $statusReason, "vehicle_id" => $arr['vehicle_id'], "driver_id" => $arr['driver_id'], "status_code" => $stcode, "createdon" => $stsdate];
                    $ins = $this->db->insert("tb_stop_status", $insarry);
                }
            }
            if($arr['trip'] > 0){
                /* update orders table */
                if ($crossborder > 0) {
                    $this->common->updatetbledata("tb_employee", ['trip_id' => $arr['trip']], ["shift_id" => $arr['ship']]);
                } else {
                    $this->common->updatetbledata("tb_orders", ['trip_id' => $arr['trip']], ["shift_id" => $arr['ship']]);
                }
                $postdata = array(
                    "shipment_id" => $arr['ship'],
                    "trip_id"     => $arr['trip'],
                    "driver_id"   => $arr['driver_id'],
                    "vehicle_id"  => $arr['vehicle_id'],
                    "order_id"    => $arr['orderid'],
                    "user_id"    => $lgusrid,
                    "stop_id"     => '',
                    "latitude"    => $latitude,
                    "longitude"   => $longitude,
                    "curtz"   => $curtz,
                    "hrs" => $hrs,
                    "web"  => $seldt,
                    "status_code"  => $stcode,
                    "ord_id"  => $ord_id
                );
                if (checkAccessConditions("CHECK_STS_REFERENCE_COUNTRIES", $company_code)) {
                    $getshipmentOrders = $this->common->gettbldata(['shift_id' => $arr['ship']], "id", "tb_orders", 0, 0);
                    if (!empty($getshipmentOrders)) {
                        foreach ($getshipmentOrders as $shipmentOrder) {
                            $shipmentOrderID = $shipmentOrder['id'];
                            $ins_ref = ['order_id' => $shipmentOrderID, 'reference_id' => 'STS'];
                            $checkSTSRef = $this->common->gettblrowdata($ins_ref, "id", "tb_order_references", 0, 0);
                            if (count($checkSTSRef) == 0) {
                                $ins_ref['ref_value'] = "Active";
                                $this->common->insertTableData("tb_order_references", $ins_ref);
                            } else {
                                $this->common->updatetbledata('tb_order_references', ['ref_value' => "Active"], $ins_ref);
                            }
                        }
                    }
                }
				
					$getvendorname = $this->db->select("vendor_id")->get_where("tb_shifts", ['id' => $arr['ship'], 'status' => '1']);
					if ($getvendorname->num_rows() > 0) {
						$vendor_id = $getvendorname->row()->vendor_id;
						$gettollvendorname = $this->db->select("name")->get_where("tb_vendors", ['id' => $vendor_id, 'name' => 'TOLL NETWORKS (NZ) LTD']);
						if ($gettollvendorname->num_rows() > 0) {
							$getTOLLfile = $this->tollcarrieredi->shipmentdata($arr['ship']);
						}
                        if (checkAccessConditions('CHECK_ALTOVA_NZ_CARRIERS', $vendor_id)) {
                            $carrierStatus = $this->carriercommonedilib->shipmentdata($arr['ship']);
                        }
                        try {
                            $carrierEDIDetails = $this->common->carrierEDIDetails($vendor_id);
                            if (!empty($carrierEDIDetails)) {
                                if ($carrierEDIDetails["editype"] == "P") {
                                    if ($carrierEDIDetails["ediservice"] == "Web Services") {
                                        $response = $this->carrierstandardtripoutbound->shipmentdata($arr['ship']);
                                    }
                                }
                                if ($carrierEDIDetails["editype"] == "T") {
                                    $response = $this->carriercommonedilib->shipmentdata($arr['ship']);
                                }
                            } else {
                                $message = "Carrier Does not have permission " . $arr['ship'] . $vendor_id;
                                $this->carrierstandardtripoutbound->sendEmailNotification($arr['ship'], $message);
                                log_message("error", $message);
                            }
                        } catch (Exception $ex) {
                            $message = "Trip sending Failed to Carrier " . $arr['ship'] . $vendor_id .  $ex->getMessage();
                            $this->carrierstandardtripoutbound->sendEmailNotification($arr['ship'], $message);
                            log_message("error", "Trip sending Failed to Carrier " . $arr['ship'] . $vendor_id .  $ex->getMessage());
                        }
					}

                $resultsts = 1;
                /**
                 * Description:
                  Initially
                  if created Source value = '18' then it will refers Roadlog
                  if created Source value = '8' then it will refers shippeo
                  But Now the process is changed,Both Roadlog and Shippeo will create their orders from the same Source i.e., Roadlog.So, They will represent same created source value i.e., '0'.
                  Now,We will differentiate Roadlog and Shippeo Orders based on ABO Reference values and Company Code.
                  Here,ABO Reference Values taking from Roadlog XML.
                 */
                if($createdsource == self::ROADLOG_ORDER_SOURCE){
                    if(!$isShippeoEventTriggred){
                        $edi_reference = $this->shippeostatusintigration->is_shippeo_order($ord_id, $company_code, $branch_code);
                        if ($edi_reference != 0) {
                            $isShippeoEventTriggred = true;
                            $sts = $this->shippeostatusintigration->shippeo_event_call($ord_id, $postdata, $curtz, $stid, $stype, $arr['vehicle_id'], $edi_reference, $company_code, $branch_code, $lgusrid);
                        }
                    }
                    $sts = $this->statusintigration->roadlogshipmentconfirm($postdata);
                } else if($createdsource == self::SALOG_ORDER_SOURCE){
                    $sts = $this->statusintigration->salogshipmentstatus($postdata);
                } else if($createdsource == self::ETNQUOTE_ORDER_SOURCE){
                    $sts = $this->svkonektquote->getstatusresponse($postdata);
                } else if($createdsource == self::SHIPPEO_ORDER_SOURCE) {

                    if(FALSE){
                        $logdate = date('Y-m-d H:i:s');
                        $getactual = getdatetimebytimezone(DFLT_TZ,$logdate,$curtz);
                        $cur_date = $getactual['datetime'];
                        $postdata['date_transmission'] = $cur_date;
                        $postdata["truck_number"] = null;
                        $vehicle_id = $this->db->escape($arr['vehicle_id']);
                        $sql = "SELECT truck_number FROM tb_trucks_data WHERE id = ? LIMIT 1";
                        $chktruck = $this->db->query($sql, [$vehicle_id]);
                        if($chktruck->num_rows() > 0) {
                            $postdata["truck_number"] = $chktruck->row()->truck_number;
                        }
                        $postdata["edi_reference"] = null;
                        $chkreference = $this->common->gettblrowdata(array('order_id'=>$ord_id,'reference_id'=>'EDI'),'ref_value','tb_order_references',0,0);
                        if(!empty($chkreference)) {
                            $postdata["edi_reference"] = $chkreference['ref_value'];
                        }
                        if($stid == "35") {
                            // Driver Accept
                            $postdata['situation_code'] = 'EML';
                            $postdata['justification_code'] = 'CFM';
                            $sts = $this->shippeostatusintigration->shippeoStatusUpdate($postdata);
                        }
                        if($stid == "2" && $stype == "P") {
                            // GATEIN
                            $postdata['situation_code'] = 'EML';
                            $postdata['justification_code'] = 'ARS';
                            $sts = $this->shippeostatusintigration->shippeoStatusUpdate($postdata);
                        }
                        if($stid == "1" && $stype == "P") {
                            // GATEIN PICKUP
                            $postdata['situation_code'] = 'ECH';
                            $postdata['justification_code'] = 'CFM';
                            $sts = $this->shippeostatusintigration->shippeoStatusUpdate($postdata);
                        }
                        if($stid == "4" && $stype == "P") {
                            // In-Transit
                            $postdata['situation_code'] = 'MLV';
                            $postdata['justification_code'] = 'CFM';
                            $sts = $this->shippeostatusintigration->shippeoStatusUpdate($postdata);
                        }
                        if($stid == "1" && $stype == "D") {
                            // Destination - delivery
                            $postdata['situation_code'] = 'LIV';
                            $postdata['justification_code'] = 'CFM';
                            $sts = $this->shippeostatusintigration->shippeoStatusUpdate($postdata);
                        }
                        if($stid == "3" && $stype == "D") {
                            // Destination - Gateout
                            $session_ccode = $this->session->userdata('company_code');
                            $postdata['situation_code'] = 'LIV';
                            $postdata['justification_code'] = 'DES';
                            $sts = $this->shippeostatusintigration->shippeoStatusUpdate($postdata);
                            if($session_ccode == "PLKN"){
                                $postdata['company_code'] = $session_ccode;
                                $session_currency = $this->session->userdata("usr_tzone")['currency'];
                                $post['currency'] = $session_currency;
                            }
                        }
                    }
                } else if($createdsource == self::MACADAM_ORDER_SOURCE){
                    $sts = $this->macdamstatusintigration->macdamshipmentconfirm($postdata);
                } else if($createdsource == self::KNLOGIN_ORDER_SOURCE) {
                    $sts = $this->knlogin->knloginshipmentstatus($postdata);
                }
                $note = $this->sendnotify('driver_accept',$arr['ord_id']);

                }
               $checkStatus = "RELATED_2_" . $company_code . "_CONSIGNEE_NOTIFICATION_STATUSES";
               if (checkAccessConditions('RELATED_2_CONSIGNEE_NOTIFICATION', $company_code) && checkAccessConditions($checkStatus, $stcode)) {
                   $this->load->library('notifytrigger');
                   $this->notifytrigger->sendNotificationToConsignee($arr['orderid'], $stcode);
               }
                if (checkAccessConditions('WECHAT_COUNTRY', $this->session->userdata('company_code')))
                {
                    $this->load->library('Wechat');
                    $this->wechat->orderId = $arr['orderid'];
                    $this->wechat->sendNotificationsToWeChat();
                }
            }else if($arr['trip'] != "0" && $stid != "11"){
                $statusData = [
                    "order_id"=>$ord_id,
                    "shipment_id"=>$arr['ship'],
                    "stop_id"=>$stopid,
                    "stop_detail_id"=>$stopdetailid,
                    "stop_type"=>$stype,
                    "trip_id"=>$arr['trip'],
                    "status_id"=>$stid
                ];
                $chqry = $this->db->select("id")->get_where("tb_stop_status",$statusData,1,0);
                if($chqry->num_rows() == 0){
                    if($stid == "2" && $stype == "P"){
                        $ttdata = array("id"=>$arr['trip']);
                        $data2["updated_on"] = $curdt;
                        $data2["transit_status"] = '1';
                        $res = $this->db->set($data2)->where($ttdata)->update("tb_trips");
                    }
                    if($stype == "P" || $stid == "4"){
                        $latitude = $plat;
                        $longitude = $plng;
                    }
                    if($stype == "D"){
                        $latitude = $dlat;
                        $longitude = $dlng;
                    }

                    $insarry = ["order_id" => $ord_id, "shipment_id" => $arr['ship'], "stop_id" => $stopid, "stop_detail_id" => $stopdetailid, "stop_type" => $stype, "trip_id" => $arr['trip'], "status_id" => $stid, "latitude" => $latitude, "longitude" => $longitude, "status" => 1, "reason" => $statusReason, "vehicle_id" => $arr['vehicle_id'], "driver_id" => $arr['driver_id'], "status_code" => $stcode, "createdon" => $stsdate];
                    $ins = $this->db->insert("tb_stop_status", $insarry);
                    $chqry1 = $this->db->select("id")->get_where("tb_trip_employee",array("employee_id"=>$stopdetailid,"stop_id"=>$stopid,"trip_id"=>$arr['trip'],"status"=>1),1,0);
                    if($chqry1->num_rows() == 0){
                        $insarr = array("employee_id"=>$stopdetailid,"stop_id"=>$stopid,"trip_id"=>$arr['trip'],"status"=>1, 'driver_late'=>0, 'emp_late'=>0, 'stime'=>$curdt, 'check_in'=>$curdt, 'absent_reason'=>'Closed', 'created_on'=>$curdt, 'updated_on'=>$curdt, 'pd_status'=>1);
                        $ins = $this->db->insert("tb_trip_employee",$insarr);
                    }
                    $postdata = array(
                        "shipment_id" => $arr['ship'],
                        "trip_id"     => $arr['trip'],
                        "driver_id"   => $arr['driver_id'],
                        "stop_id"     => $stopid,
                        "order_id"    => $arr['orderid'],
                        "inc_id"      => 0,
                        "pod_type"    => '',
                        "latitude"    => $latitude,
                        "longitude"   => $longitude,
                        "stop_type" => $stype,
                        "vehicle_id" => $arr['vehicle_id'],
                        "curtz" => $curtz,
                        "hrs" => $hrs,
                        "web"  => $seldt,
                        "status_code"  => $stcode,
                        "ord_id"  => $ord_id
                    );
                    if($stid == "1" && $stype == "P" && $createdsource != self::SALOG_ORDER_SOURCE){
                        $this->sendnotify('pickup_note',$arr['ord_id']);
                    }
                    if($stid == "1" && $stype == "D" && $createdsource != self::SALOG_ORDER_SOURCE) {
                        $this->sendnotify('delivery_note', $arr['ord_id']);
                    }
                    if($createdsource == self::ROADLOG_ORDER_SOURCE){
                        if(!$isShippeoEventTriggred){
                            $edi_reference = $this->shippeostatusintigration->is_shippeo_order($ord_id, $company_code, $branch_code);
                            if ($edi_reference != 0 ) {
                                $isShippeoEventTriggred = true;
                                $sts = $this->shippeostatusintigration->shippeo_event_call($ord_id, $postdata, $curtz, $stid, $stype, $arr['vehicle_id'], $edi_reference, $company_code, $branch_code, $lgusrid);
                            }
                        }
                        if ($stid == "4") {
                            /*send to roadlog*/
                            $sts = $this->statusintigration->roadlogshipmentintransit($postdata);
                        }
                        if ($stid == "2" && $stype == "P") {
                            $sts = $this->statusintigration->roadlogshipmentpgatein($postdata);
                        }
                        if ($stid == "1" && $stype == "P") {
                            $sts = $this->statusintigration->roadlogshipmentpicked($postdata);
                        }
                        if ($stid == "3" && $stype == "P") {
                            $sts = $this->statusintigration->roadlogshipmentpgateout($postdata);
                        }
                        if ($stid == "2" && $stype == "D") {
                            $sts = $this->statusintigration->roadlogshipmentdgatein($postdata);
                        }
                        if ($stid == "1" && $stype == "D") {
                            $sts = $this->statusintigration->roadlogshipmentdelivered($postdata);
                        }
                    }else if($createdsource == self::SALOG_ORDER_SOURCE){
                        if($stid == "1" && $stype == "P"){
                            $sts = $this->statusintigration->salogshipmentstatus($postdata);
                        }
                        if($stid == "1" && $stype == "D"){
                            $sts = $this->statusintigration->salogshipmentstatus($postdata);
                        }
                        if($stid == "3" && $stype == "P"){
                            $sendDocument = $this->salogintegrateservice->sendePodToSalog($postdata, "PUP");
                        }
                        if($stid == "3" && $stype == "D"){
                            $sendDeliverStatus = $this->statusintigration->salogshipmentstatus($postdata);
                            $sendDocument = $this->salogintegrateservice->sendePodToSalog($postdata, "DEL");
                        }
                    }else if($createdsource == self::ETNQUOTE_ORDER_SOURCE){
                        if($stid == '4' || ($stid == "1" && $stype == "P") || ($stid == "3" && $stype == "D")){
                            $postdata['user_id'] = $lgusrid;
                            if($stid == "1" && $stype == "P"){
                            }
                            $sts = $this->svkonektquote->getstatusresponse($postdata);
                        }
                    } else if($createdsource == self::SHIPPEO_ORDER_SOURCE) {
                        if(FALSE){
                            $logdate = date('Y-m-d H:i:s');
                            $getactual = getdatetimebytimezone(DFLT_TZ,$logdate,$curtz);
                            $cur_date = $getactual['datetime'];
                            $postdata['date_transmission'] = $cur_date;
                            $postdata["truck_number"] = null;
                            $vehicle_id = $this->db->escape($arr['vehicle_id']);
                            $sql = "SELECT truck_number FROM tb_trucks_data WHERE id =? LIMIT 1";
                            $chktruck = $this->db->query($sql, [$vehicle_id]);
                            if($chktruck->num_rows() > 0) {
                                $postdata["truck_number"] = $chktruck->row()->truck_number;
                            }
                            $postdata["edi_reference"] = null;
                            $chkreference = $this->common->gettblrowdata(array('order_id'=>$ord_id,'reference_id'=>'EDI'),'ref_value','tb_order_references',0,0);
                            if(!empty($chkreference)) {
                                $postdata["edi_reference"] = $chkreference['ref_value'];
                            }
                            if($stid == "35") {
                            // Driver Accept
                                $postdata['situation_code'] = 'EML';
                                $postdata['justification_code'] = 'CFM';
                                $sts = $this->shippeostatusintigration->shippeoStatusUpdate($postdata);
                            }
                            if($stid == "2" && $stype == "P") {
                            // GATEIN
                                $postdata['situation_code'] = 'EML';
                                $postdata['justification_code'] = 'ARS';
                                $sts = $this->shippeostatusintigration->shippeoStatusUpdate($postdata);
                            }
                            if($stid == "1" && $stype == "P") {
                            // GATEIN PICKUP
                                $postdata['situation_code'] = 'ECH';
                                $postdata['justification_code'] = 'CFM';
                                $sts = $this->shippeostatusintigration->shippeoStatusUpdate($postdata);
                            }
                            if($stid == "4" && $stype == "P") {
                            // In-Transit
                                $postdata['situation_code'] = 'MLV';
                                $postdata['justification_code'] = 'CFM';
                                $sts = $this->shippeostatusintigration->shippeoStatusUpdate($postdata);
                            }
                            if($stid == "1" && $stype == "D") {
                            // Destination - delivery
                                $postdata['situation_code'] = 'LIV';
                                $postdata['justification_code'] = 'CFM';
                                $sts = $this->shippeostatusintigration->shippeoStatusUpdate($postdata);
                            }
                            if($stid == "3" && $stype == "D") {
                            // Destination - Gateout
                                $postdata['situation_code'] = 'LIV';
                                $postdata['justification_code'] = 'DES';
                                $sts = $this->shippeostatusintigration->shippeoStatusUpdate($postdata);
                            }
                        }
                    } else if($createdsource == self::MACADAM_ORDER_SOURCE){
                        if($stid == "4"){
                            $sts = $this->macdamstatusintigration->macdamshipmentintransit($postdata);
                        }
                        if($stid == "2" && $stype == "P"){
                            $sts = $this->macdamstatusintigration->macdamshipmentpgatein($postdata);
                        }
                        if($stid == "1" && $stype == "P"){
                            $sts = $this->macdamstatusintigration->macdamshipmentpicked($postdata);
                        }
                        if($stid == "3" && $stype == "P"){
                            /*send to macdamstatusintigration*/
                            $sts = $this->macdamstatusintigration->macdamshipmentpgateout($postdata);
                        }
                        if($stid == "2" && $stype == "D"){
                            $sts = $this->macdamstatusintigration->macdamshipmentdgatein($postdata);
                        }
                        if($stid == "1" && $stype == "D"){
                            $sts = $this->macdamstatusintigration->macdamshipmentdelivered($postdata);
                        }
                    } else if($createdsource == self::KNLOGIN_ORDER_SOURCE) {
                        $sts = $this->knlogin->knloginshipmentstatus($postdata);
                    }else if($createdsource == self::AMAZON_ORDER_SOURCE){
                        $this->load->library("amazonstatusintegration");
                        if($stid == "2" && $stype == "P"){
                            $postdata['status_code'] = "TL";
                            $sts = $this->amazonstatusintegration->updateOrderStatus($postdata);
                        }
                        if($stid == "1" && $stype == "P"){
                            $postdata['status_code'] = "CL";
                            $sts = $this->amazonstatusintegration->updateOrderStatus($postdata);
                        }
                        if($stid == "3" && $stype == "P"){
                            $postdata['status_code'] = "LY";
                            $sts = $this->amazonstatusintegration->updateOrderStatus($postdata);
                        }
                        if($stid == "2" && $stype == "D"){
                            $postdata['status_code'] = "TL";
                            $sts = $this->amazonstatusintegration->updateOrderStatus($postdata);
                        }
                        if($stid == "1" && $stype == "D"){
                            $postdata['status_code'] = "CL";
                            $sts = $this->amazonstatusintegration->updateOrderStatus($postdata);
                        }
                        if($stid == "3" && $stype == "D"){
                            $postdata['status_code'] = "LY";
                            $sts = $this->amazonstatusintegration->updateOrderStatus($postdata);
                        }
                        if($postdata['status_code'] == "LY"){
                            $chkmuliti = $this->db->select("id")->get_where("tb_orders",array("shift_id"=>$arr['ship'],"trip_sts"=>'0'));
                            if($chkmuliti->num_rows()>1){
                                $upd = $this->db->where(array("id"=>$ord_id,"trip_id !="=>0))->update("tb_orders",array("trip_sts"=>'1'));
                            }else{
                                $updwhr  = array("id" => $arr['ship']);
                                $upddata = array("status" => '0', "updated_on" => $curdt);
                                $upd = $this->db->set($upddata)->where($updwhr)->update("tb_shifts");
                                $data1 = array();
                                $tdata = array("id"=>$arr['trip']);
                                $data1["end_imei"] = $arr['contact_num'];
                                $data1["end_reading"] = '0';
                                $data1["etime"] = $data1["updated_on"] = $curdt;
                                $data1["status"] = '0';
                                $data1["transit_status"] = '1';
                                $res = $this->db->set($data1)->where($tdata)->update("tb_trips");
                                if ($arr['ship'] > 0) {
                                    $upd = $this->db->where(["shift_id" => $arr['ship']])->update("tb_orders", ["trip_sts" => '1']);
                                }
                                $gensum = $this->generatesummary($arr['trip'],$curtz);
                            }
                        }
                    }
                    $resultsts = 1;
                    if($stid == "3" && $stype == "D"){
                        /*send to roadlog*/
                        /**
                         * Description:
                          Initially
                          if created Source value = '0' then it will refers Roadlog
                          if created Source value = '8' then it will refers shippeo
                          But Now the process is changed,Both Roadlog and Shippeo will create their orders from the same Source i.e., Roadlog.So, They will represent same created source value i.e., '0'.
                          Now,We will differentiate Roadlog and Shippeo Orders based on ABO Reference values and Company Code.
                          Here,ABO Reference Values taking from Roadlog XML.
                          added try catch block for any blocker.
                         */
                        try {
                            if ($createdsource == self::ROADLOG_ORDER_SOURCE) {
                               
                                if(!$isShippeoEventTriggred){
                                    $edi_reference = $this->shippeostatusintigration->is_shippeo_order($ord_id, $company_code, $branch_code);
                                    if ($edi_reference != 0) {
                                        $isShippeoEventTriggred = true;
                                        $sts = $this->shippeostatusintigration->shippeo_event_call($ord_id, $postdata, $curtz, $stid, $stype, $arr['vehicle_id'], $edi_reference, $company_code, $branch_code, $lgusrid);
                                    }
                                }
                            } elseif ($createdsource == self::KNLOGIN_ORDER_SOURCE) {
                                $sts = $this->knlogin->knloginshipmentstatus($postdata);
                                $this->statusintigration->sendPodToKnlogin(3,$ord_id);
                            }
                            $postdata['checkEpodForCustomer'] = 0;
                            $postdata['customer_id'] = $customerId;
                            if (checkAccessConditions('SEND_EPOD_TO_SELECTED_CUSTOMERS', $customerId)) {
                                $postdata['checkEpodForCustomer'] = 1;
                            }
                            if ($createdsource == self::ROADLOG_ORDER_SOURCE || ($postdata['checkEpodForCustomer'] == 1)) {
                                $sts = $this->sendepodgateoutnotify($postdata);
                            }
                            $session_ccode = $this->session->userdata('company_code');
                            if ($session_ccode == "PLKN") {
                                $postdata['company_code'] = $session_ccode;
                                $session_currency = $this->session->userdata("usr_tzone")['currency'];
                                $post['currency'] = $session_currency;
                                $exchangerate = $this->exchangerate->updateexchangerate_byorderid($postdata);
                            }
                        } catch (Exception $ex) {
                            log_message("error", "Some Problem occured!, While Sending Status to Road Log and shippeo. " . $ex->getMessage());
                        }
                    }

                }

               $checkStatus = "RELATED_2_" . $company_code . "_CONSIGNEE_NOTIFICATION_STATUSES";
               if (checkAccessConditions('RELATED_2_CONSIGNEE_NOTIFICATION', $company_code) && checkAccessConditions($checkStatus, $stcode)) {
                   $this->load->library('notifytrigger');
                   $this->notifytrigger->sendNotificationToConsignee($arr['orderid'], $stcode);
               }
            }else if($stsid == "11" && $arr['trip'] != 0 && $arr['trip'] != ""){
                $latitude = $dlat;
                $longitude = $dlng;
                $postdata = array(
                    "shipment_id" => $arr['ship'],
                    "trip_id"     => $arr['trip'],
                    "driver_id"   => $arr["driver_id"],
                    "stop_id"     => '',
                    "order_id"    => $arr['orderid'],
                    "latitude"    => $latitude,
                    "longitude"   => $longitude,
                    "curtz"   => $curtz,
                    "hrs" => $hrs,
                    "web"  => $seldt
                );
               $insarry = [
                   "order_id" => $ord_id,
                   "shipment_id" => $arr['ship'],
                   "stop_id" => $stopid,
                   "stop_detail_id" => $stopdetailid,
                   "stop_type" => $stype,
                   "trip_id" => $arr['trip'],
                   "status_id" => $stid,
                   "latitude" => $latitude,
                   "longitude" => $longitude,
                   "status" => 1,
                   "reason" => $statusReason,
                   "vehicle_id" => $arr['vehicle_id'],
                   "driver_id" => $arr['driver_id'],
                   "status_code" => $stcode,
                   "createdon" => $stsdate
               ];
               $ins = $this->db->insert("tb_stop_status", $insarry);
               if (checkAccessConditions('RELATED_TO_KPIREPORTS', $this->session->userdata('company_code'))) {
                   $this->load->library("kpireportinsertion");
                   $this->kpireportinsertion->insertDataIntoKpiReports($ord_id);
               }
               if($crossborder >0){
                   $tripStatusCheck = 0;
                   $shiftIds = [];
                   $whereCondition = "id='".$arr['ship']."' AND shift_leg_id >0";
                   $checkShiftLegs = $this->common->gettblrowdata($whereCondition, "shift_leg_id", "tb_shifts", 0, 0);
                   if(!empty($checkShiftLegs)){
                       $shiftLegId = $checkShiftLegs['shift_leg_id'];
                       $getAllLegIds = $this->common->gettbldata(['shift_leg_id'=>$shiftLegId,'status'=>'1'],"id","tb_shifts",0,0);
                       if(count($getAllLegIds) >1){
                           foreach($getAllLegIds as $eachLegId){
                               $shiftIds[] = $eachLegId['id'];
                           }
                           $updateShifts = $this->common->updatetbledata("tb_shifts", ['status' => '0', 'updated_on' => $stsdate], ['id' => $arr['ship']]);
                           $updateTrips = $this->common->updatetbledata("tb_trips", ['end_imei' => $arr['contact_num'], 'end_reading' => '0', 'etime' => $curdt, 'updated_on' => $stsdate, 'status' => '0', 'transit_status' => '1'], ['id' => $arr['trip']]);
                           $checkPendingLegIds = $this->common->gettblrowdata("id IN (".implode(",",$shiftIds).") AND status ='1'","id","tb_shifts",0,0);
                           if(empty($checkPendingLegIds)){
                               $updateShifts = $this->common->updatetbledata("tb_shifts", ['status'=>'0'], ['id'=>$shiftLegId,'status'=>'1']);
                               $tripStatusCheck = 1;
                           }
                       }else{
                           $shiftIds = [$shiftLegId,$arr['ship']];
                           $updateShifts = $this->common->updatetbledata("tb_shifts", ['status'=>'0'], "id IN (".implode(",",$shiftIds).") AND status ='1'");
                           $updateTrips = $this->common->updatetbledata("tb_trips", ['end_imei'=>$arr['contact_num'],'end_reading'=>'0','etime'=>$curdt,'updated_on'=>$curdt,'status'=>'0','transit_status'=>'1'], ['id'=>$arr['trip']]);
                           $tripStatusCheck = 1;

                       }
                       if(!in_array('0', [$tripStatusCheck, $shiftLegId])){
                           $updateOrder = $this->common->updatetbledata("tb_orders", ['trip_sts'=>'1'], ['shift_id'=>$shiftLegId]);
                       }
                   }
               }else{
                   $chkmuliti = $this->db->select("id")->get_where("tb_orders",array("shift_id"=>$arr['ship'],"trip_sts"=>'0'));
                   if($chkmuliti->num_rows()>1){
                       $upd = $this->db->where(array("id"=>$ord_id,"trip_id !="=>0))->update("tb_orders",array("trip_sts"=>'1'));
                   }else{
                       $updwhr  = array("id" => $arr['ship']);
                       $upddata = array("status" => '0', "updated_on" => $curdt);
                       $upd = $this->db->set($upddata)->where($updwhr)->update("tb_shifts");
                       $data1 = array();
                       $tdata = array("id"=>$arr['trip']);
                       $data1["end_imei"] = $arr['contact_num'];
                       $data1["end_reading"] = '0';
                       $data1["etime"] = $data1["updated_on"] = $curdt;
                       $data1["status"] = '0';
                       $data1["transit_status"] = '1';
                       $res = $this->db->set($data1)->where($tdata)->update("tb_trips");
                       if ($arr['ship'] > 0) {
                           $upd = $this->db->where(["shift_id" => $arr['ship']])->update("tb_orders", ["trip_sts" => '1']);
                       }
                       $gensum = $this->generatesummary($arr['trip'], $curtz);
                   }
               }
               if (checkAccessConditions("CHECK_STS_REFERENCE_COUNTRIES", $company_code)) {
                   $ins_ref = ['order_id' => $ord_id, 'reference_id' => 'STS'];
                   $checkSTSRef = $this->common->gettblrowdata($ins_ref, "id", "tb_order_references", 0, 0);
                   if (count($checkSTSRef) > 0) {
                       $this->common->updatetbledata('tb_order_references', ['ref_value' => "Closed"], $ins_ref);
                   }else{
                       $ins_ref['ref_value'] = "Closed";
                       $this->common->insertTableData("tb_order_references", $ins_ref);
                   }
               }
                /*send to roadlog*/
                /**
                * Description:
                Initially
                if created Source value = '0' then it will refers Roadlog
                if created Source value = '8' then it will refers shippeo
                But Now the process is changed,Both Roadlog and Shippeo will create their orders from the same Source i.e., Roadlog.So, They will represent same created source value i.e., '0'.
                Now,We will differentiate Roadlog and Shippeo Orders based on ABO Reference values and Company Code.
                Here,ABO Reference Values taking from Roadlog XML.
                */
               try {
                   if ($createdsource == self::ROADLOG_ORDER_SOURCE) {
                      
                       if(!$isShippeoEventTriggred){
                           $edi_reference = $this->shippeostatusintigration->is_shippeo_order($ord_id, $company_code, $branch_code);
                           if ($edi_reference != 0) {
                               $sts = $this->shippeostatusintigration->shippeo_event_call($ord_id, $postdata, $curtz, $stid, $stype, $arr['vehicle_id'], $edi_reference, $company_code, $branch_code, $lgusrid);
                           }
                       }
                       $sts = $this->statusintigration->roadlogshipmenttripdelivered($postdata);
                   }
                   if ($createdsource == self::MACADAM_ORDER_SOURCE) {
                       $sts = $this->macdamstatusintigration->macdamshipmenttripdelivered($postdata);
                   } else {
                       if ($createdsource == self::KNLOGIN_ORDER_SOURCE) {
                           $sts = $this->knlogin->knloginshipmentstatus($postdata);
                       }
                   }
               } catch (Exception $ex) {
                   log_message("error", "Some Problem occured!, While Sending Status to Road Log and shippeo.");
               }
               $resultsts = 1;
           }
           if ($this->session->userdata('company_code') == 'UKKN-CG' && $stcode == "1600") {
               $this->openboxstatusaccept->pushStatusXml($arr['trip']);
           }
           if (($createdsource == self::SALOG_ORDER_SOURCE) && in_array($stcode, ['0200', '0220', '0500', '3000'])) {
               $this->load->library('notifytrigger');
               $this->notifytrigger->orderStatusNotification($arr['orderid'], $stcode, $seldt);
           }
                      
           $domainDetails = $this->OtmBookingModel->getDomain($ord_id);
    		if (!empty($domainDetails)) {
    			$extOrderId = $domainDetails[0]['external_order_id'];
    			$domainName = $domainDetails[0]['ref_value'];
                $domainCreatedSource = $domainDetails[0]['created_source'];
                if($domainName<>"")
                {
                   $otmRequest = [
                            'glogDate' => date("Ymdhis"),
                            'externalOrderId' => $extOrderId,
                            'orderStatusDateTime' => $stsdate,
                            'domainName' => $domainName,
                            'createdSource'=> $createdsource ? $createdsource :  $domainCreatedSource,
                            'timeZone' =>$curtz ?? "",
                            'orderStatusCode' => $stcode,
                        ];
                        
                        $output = sendOTMStatus($otmRequest);
               }
    		}
           try {
               $this->standard_status_execution->sendStandardXMLtoAltova($arr);
               $this->altovaordercreation->sendOrderToAltova($ord_id, $stcode);
           } catch (Exception $ex) {
               log_message("error", "Some Problem occured!, While Sending Status to Altova " . $ex->getMessage());
           }

       }
       echo $resultsts;
    }
}
