<?php
defined('BASEPATH') or exit('No direct script access allowed');

class AlertsController extends CI_Controller
{
    public function __construct()
    {
        parent::__construct();
        if ($this->session->userdata('user_id') == '') {
            redirect('login');
        }
        $this->load->database();
        $this->load->library(['newtemplate']);
        $this->load->model('AlertsModel'); // Load the model
    }

    public function index():void
    {
        $this->getsearchresult();
    }

    public function getsearchresult(): void
{
    $businessType = $this->session->userdata('business_type');
    $custid = $vendorId = "";
    $userid = $this->session->userdata("user_id");

    if (!empty($this->session->userdata("cust_id"))) {
        $custid = $this->session->userdata("cust_id");
    }
    if (!empty($this->session->userdata('id'))) {
        $vendorId = $this->session->userdata('id');
    }

    $countryUserids = $this->session->userdata("country_user_ids") ?: [];

    if ($businessType === "Customer") {
        $userid = 0;
    }

    $subcusts = $this->session->userdata('sub_cust') ?: [];
    if (!in_array($custid, $subcusts, true) && !empty($custid)) {
        $subcusts[] = $custid;
    }

    $generalArray = [
        'userid' => $userid,
        'custid' => $custid,
        'business_type' => $businessType,
        'country_userids' => $countryUserids,
        'subcusts' => $subcusts,
        'searchids' => [],
        'vendor_id' => $vendorId,
        'ordids' => []
    ];

    $post = $this->input->post(NULL, TRUE);

    // Handle dates safely
    try {
        if (!empty($post['aqufromdate']) && !empty($post['aqutodate'])) {
            $post['aqufromdate'] = $this->AlertsModel->convertDateFormat($post['aqufromdate']);
            $post['aqutodate'] = $this->AlertsModel->convertDateFormat($post['aqutodate']);
            log_message('error', "AlertsController - Converted dates for getsearchresult - From: {$post['aqufromdate']}, To: {$post['aqutodate']}");
        } else {
            // Default last 15 days
            $post['aqutodate'] = date('Y-m-d');
            $post['aqufromdate'] = date('Y-m-d', strtotime('-14 days'));
            log_message('debug', "AlertsController - Using default dates - From: {$post['aqufromdate']}, To: {$post['aqutodate']}");
        }
    } catch (Exception $e) {
        log_message('error', "AlertsController - Date conversion error in getsearchresult: " . $e->getMessage());
        $post['aqutodate'] = date('Y-m-d');
        $post['aqufromdate'] = date('Y-m-d', strtotime('-14 days'));
    }

    // Fetch delay data safely
    try {
        $delayData = $this->AlertsModel->getCustomerDelayData($post, $generalArray);
        log_message('debug', "AlertsController - getsearchresult - Found " . count($delayData) . " records");
    } catch (Exception $e) {
        log_message('error', "AlertsController - Query error in getsearchresult: " . $e->getMessage());
        $delayData = [];
    }

    // Prepare data for the view
    $delayorders = [];
    foreach ($delayData as $res) {
        $delayorders[] = [
            'order_id' => $res['order_id'],
            'shipmentid' => $res['shipmentid'],
            'pickup_datetime' => $res['pickup_datetime'] ? date('d-m-Y H:i', strtotime($res['pickup_datetime'])) : '',
            'delivery_datetime' => $res['delivery_datetime'] ? date('d-m-Y H:i', strtotime($res['delivery_datetime'])) : '',
            'pickup_address1' => $res['pickup_address1'],
            'delivery_address1' => $res['delivery_address1'],
            'carrier' => $res['carrier'],
            'vehicle_register_number' => $res['vehicle_register_number'],
            'truck_type' => $res['truck_type'],
            'driver_name' => $res['driver_name'],
            'latest_status_name' => $res['latest_status_name'],
            'latest_createdon' => $res['latest_createdon'] ? date('d-m-Y H:i', strtotime($res['latest_createdon'])) : '',
            'remark' => $res['remark']
        ];
    }

    $data = [
        'page_title' => $this->lang->line('customer_delay_status'),
        'sub_title' => $this->lang->line('leftmenu_reports'),
        'delayorders' => $delayorders,
        'delay_count' => count($delayorders),
        'custid' => $custid,
        'vendor_id' => $vendorId
    ];

    $this->newtemplate->dashboard("alerts/index", $data);
}


    public function ajaxSearch(): void 
{
    $businessType = $this->session->userdata('business_type');
    $custid = $vendorId = "";
    $userid = $this->session->userdata("user_id");

    if (!empty($this->session->userdata("cust_id"))) {
        $custid = $this->session->userdata("cust_id");
    }
    if (!empty($this->session->userdata('id'))) {
        $vendorId = $this->session->userdata('id');
    }

    $countryUserids = $this->session->userdata("country_user_ids") ?: [];

    if ($businessType === "Customer") {
        $userid = 0;
    }

    $subcusts = $this->session->userdata('sub_cust') ?: [];
    if (!in_array($custid, $subcusts, true) && !empty($custid)) {
        $subcusts[] = $custid;
    }

    $generalArray = [
        'userid' => $userid,
        'custid' => $custid,
        'business_type' => $businessType,
        'country_userids' => $countryUserids,
        'subcusts' => $subcusts,
        'searchids' => [],
        'vendor_id' => $vendorId,
        'ordids' => []
    ];

    $post = $this->input->post(NULL, TRUE);

    // Handle dates safely
    $fromConverted = $toConverted = '';
    try {
        if (!empty($post['aqufromdate']) && !empty($post['aqutodate'])) {
            $fromConverted = $this->AlertsModel->convertDateFormat($post['aqufromdate']);
            $toConverted = $this->AlertsModel->convertDateFormat($post['aqutodate']);

            log_message('error', "AlertsController - Converted dates - From: $fromConverted, To: $toConverted");

            if (!$this->AlertsModel->validateDateRange($fromConverted, $toConverted, 45)) {
                echo "<tr><td colspan='13' class='text-center text-danger'>
                        <strong>Error: Date range exceeds 45 days. Select a smaller range.</strong>
                      </td></tr>";
                return;
            }

            $post['aqufromdate'] = $fromConverted;
            $post['aqutodate'] = $toConverted;
        } else {
            // Default last 15 days
            $post['aqutodate'] = date('Y-m-d');
            $post['aqufromdate'] = date('Y-m-d', strtotime('-15 days'));
            log_message('debug', "AlertsController - Using default dates - From: {$post['aqufromdate']}, To: {$post['aqutodate']}");
        }

    } catch (Exception $e) {
        log_message('error', "AlertsController AJAX Date Exception: " . $e->getMessage());
        echo "<tr><td colspan='13' class='text-center text-danger'>Server error with dates</td></tr>";
        return;
    }

    // Fetch delay data safely
    try {
        $delayData = $this->AlertsModel->getCustomerDelayData($post, $generalArray);
        log_message('debug', "AlertsController - AJAX Search - Found " . count($delayData) . " records");
    } catch (Exception $e) {
        log_message('error', "AlertsController AJAX Query Exception: " . $e->getMessage());
        echo "<tr><td colspan='13' class='text-center text-danger'>Server error fetching data</td></tr>";
        return;
    }

    // Render table rows
    if (!empty($delayData)) {
        foreach ($delayData as $res) {
            echo "<tr>
                    <td>{$res['order_id']}</td>
                    <td>{$res['remark']}</td>
                    <td>{$res['shipmentid']}</td>
                    <td>" . ($res['pickup_datetime'] ? date('d-m-Y H:i', strtotime($res['pickup_datetime'])) : '') . "</td>
                    <td>" . ($res['delivery_datetime'] ? date('d-m-Y H:i', strtotime($res['delivery_datetime'])) : '') . "</td>
                    <td>{$res['pickup_address1']}</td>
                    <td>{$res['delivery_address1']}</td>
                    <td>{$res['carrier']}</td>
                    <td>{$res['vehicle_register_number']}</td>
                    <td>{$res['truck_type']}</td>
                    <td>{$res['driver_name']}</td>
                    <td>{$res['latest_status_name']}</td>
                    <td>" . ($res['latest_createdon'] ? date('d-m-Y H:i', strtotime($res['latest_createdon'])) : '') . "</td>
                  </tr>";
        }
    } else {
        echo "";
    }
}

    // AJAX method to get alert counts for home page
    public function getAlertCounts():void
    {
        $businessType = $this->session->userdata('business_type');
        $custid = $vendorId = "";
        $userid = $this->session->userdata("user_id");
        
        if(!empty($this->session->userdata("cust_id"))) {
            $custid = $this->session->userdata("cust_id");
        }
        if(!empty($this->session->userdata('id'))){
            $vendorId = $this->session->userdata('id');
        }

        $countryUserids = array();
        if(!empty($this->session->userdata("country_user_ids")) && ($this->session->userdata("country_user_ids") != null) && (count($this->session->userdata("country_user_ids")) > 0) ) {
            $countryUserids = $this->session->userdata("country_user_ids");
        }

        if($businessType == "Customer") {
            $userid = 0;
        }

        $subcusts = array();
        if(!empty($custid)) {
            if($this->session->userdata('sub_cust') !== FALSE) {
                $subcusts = $this->session->userdata('sub_cust');
                if(count($subcusts) > 0){
                    array_push($subcusts, $custid);
                } else {
                    $subcusts = array($custid);
                }
            } else {
                $subcusts = array($custid);
            }
        }

        $generalArray = [
            'userid' => $userid,
            'custid' => $custid,
            'business_type' => $businessType,
            'country_userids' => $countryUserids,
            'subcusts' => $subcusts,
            'searchids' => array(),
            'vendor_id' => $vendorId,
            'ordids' => array()
        ];

        // Use model to get count
        $delayCount = $this->AlertsModel->getDelayCount($generalArray);
        echo json_encode([
            'total_count' => $delayCount,
            'delay_count' => $delayCount
        ]);
    }
}