<?php if(!defined('BASEPATH')) exit('No direct script access allowed');

class AllroundbigReport extends CI_Controller {

    public function __construct()
    {
        parent::__construct();
        if ($this->session->userdata('user_id') == '') {
            redirect('login');
        }
        $this->load->model("common");
        $this->load->model('allroundbigreportmodel');
        $this->load->model('truckwaybillmodel');
        $this->load->model('Order');
        if (!checkUrlAccessForUser('ALLROUNDBIGREPORT')) {
            redirect("Forbiddenaccess");
        }
    }


    public function index()
    {
        $this->getsearchresult();
    }

    public function getsearchresult()
    {
        $data['page_title']=$this->lang->line('menu_allroundbigreport');
        $data['sub_title']=$this->lang->line('general_search');
        $order = $country_userids = array();
        $user_id = $this->session->userdata("user_id");
        $custid = $this->session->userdata("cust_id");
        $country_userids = $this->session->userdata("country_user_ids");
        $whr = array();
        $post = array();
        $status_search ="";
        $post1 = $this->input->post(NULL,TRUE);
        log_message("error","Post111:".json_encode($post1));
        if (isset($post1['searchsubmit']) && $post1['searchsubmit'] == "Search") {
            $post = $post1;
        }

        if (!empty($post)) {
            $whr = $this->searchsubmitdata($post);
            $order_status = isset($post['status']) ? $post['status'] :"";
            $ad_orderstatus = isset($post['order_status']) ? $post['order_status'] :"";
            $status_search = $order_status;
            if($status_search == ""){
               $status_search = $ad_orderstatus;
            }

            $subcusts = array();
            $role_id = $this->session->userdata('user_role_id');

            if($role_id == "4"){
                if($this->session->userdata('sub_cust')){
                    $subcusts = $this->session->userdata('sub_cust');
                    if(!empty($subcusts)){
                      array_push($subcusts, $custid);
                    }
                }
            }
            $searchids = array();
            if (isset($post['bookingid']) && $post['bookingid'] != "") {
                $searchids = isset($post['bookingid']) ? $post['bookingid'] : array();
            }
            $orderdata = $this->allroundbigreportmodel->getorderdata($user_id,$status_search,$custid,$country_userids, $whr,$subcusts,$searchids);
            if (!empty($orderdata)) {
                foreach ($orderdata as $res) {
                    $delivery_note = "";
                    $trip_no = $res['shipmentid'] ?? "";
                    $shift_id = $res['shift_id'];
                    $trip_sts = $res['trip_sts'];
                    $trip_id = $res['trip_id'];
                    $order_status = 'PENDING';

                    if($trip_id != 0 && $trip_sts == 0){
                        $order_status = 'ACTIVE';
                    }
                    if($trip_id != 0 && $trip_sts == 1){
                        $order_status = 'CLOSED';
                    }

                    //vendor name
                    $vendor_id = $res['vendor_id'];
                    $vname = "";
                    if($vendor_id > 0) {
                        $getvname = $this->db->select("name")->get_where("tb_vendors",array('id'=>$vendor_id,'status'=>'1'));
                        if($getvname->num_rows() > 0) {
                            $vname = $getvname->row()->name;
                        }
                    }

                   $getdnote = $this->db->select("ref_value")->get_where("tb_order_references",array('order_id'=>$res['id'],'reference_id'=>'DQ'));

                    if($getdnote->num_rows() >0){
                        $delivery_note = $getdnote->row()->ref_value;
                    }

                    $chkdate = '2020-07-01 00:00:00';
                    $createdon = $res['createdon'];
                    $early_pickup = $res['pickup_datetime'];

                    $early_delivery = $res['delivery_datetime'];
                    $curtz = $this->session->userdata("usr_tzone")['timezone'];
                        if($early_pickup != "" && $early_pickup != "0000-00-00 00:00:00"){
                            $epickup = getdatetimebytimezone($curtz,$early_pickup,DFLT_TZ);
                            $early_pickup = $epickup['datetime'];
                        }
                        if($early_delivery != "" && $early_delivery != "0000-00-00 00:00:00"){
                            $edelivery = getdatetimebytimezone($curtz,$early_delivery,DFLT_TZ);
                            $early_delivery = $edelivery['datetime'];
                        }
                    $received_status = "Not Received";
                    $sent_status = "Not Sent";

                    if ($shift_id != 0) {
                        $sql1 = $this->db->query("SELECT count(*) as total_count from tb_pod_uploads WHERE shipment_id = ? and order_id= ? and doc_type='3' and status='1' order by id desc", [$shift_id, $res['id']]);
                        if (($sql1->num_rows() > 0) && ($sql1->row()->total_count > 0)) {
                            $received_status = "Received";
                        }
                        $sql2 = $this->db->query("SELECT count(*) as total_count from tb_pod_uploads WHERE shipment_id = ? and order_id= ? and doc_type!='3' and status='1' order by id desc", [$shift_id, $res['id']]);
                        if (($sql2->num_rows() > 0) && ($sql2->row()->total_count > 0)) {
                            $sent_status = "Sent";
                        }
                    }

                    //pickupdate and delivery info
                    $pickup_date_status = $delivery_datestatus ="";
                    $sql4 = $this->db->query("SELECT convertToClientTZ(tps.createdon, ?) as createdon from `tb_stop_status` tps where tps.stop_type='P' AND tps.status_code='0500' AND tps.order_id= ? order by tps.id desc LIMIT 1", [$curtz, $res['id']]);

                    if($sql4->num_rows() > 0) {
                        $pickupdate_time = $sql4->row()->createdon;
                        if($pickupdate_time != "" && $pickupdate_time != "0000-00-00 00:00:00"){
                            $pickup_date_status = date("Y-m-d H:i A",strtotime($pickupdate_time));
                        }
                    }
                    $sql5 = $this->db->query("select convertToClientTZ(tps.createdon,?) as createdon from `tb_stop_status` tps where tps.stop_type='D' AND tps.status_code='3000' AND tps.order_id=? order by tps.id desc LIMIT 1", [$curtz, $res['id']]);

                    if($sql5->num_rows() > 0) {
                        $delivery_datetime = $sql5->row()->createdon;
                        if($delivery_datetime != "" && $delivery_datetime != "0000-00-00 00:00:00"){
                            $delivery_datestatus = date("Y-m-d H:i A",strtotime($delivery_datetime));
                        }
                    }

                    //addons
                    $addon_html = "";
                    $get_addons = $this->allroundbigreportmodel->getvasdata($res['id']);
                    if(!empty($get_addons)) {
                        foreach($get_addons as $addon) {
                        $addon_html.=$addon['vas_id'].', ';
                        }
                    }

                    $addon_html = rtrim($addon_html,', ');

                    $rev_amount_billed = $rev_amount_pending_billing = $rev_amount_not_transfered = $costs_amount = 0;
                    $rev_status = 'No';

                    $rev_billed_amount = $this->allroundbigreportmodel->get_revenue_amount(0,$res['id'],2);
                    if($rev_billed_amount['total_amount']) {
                        $rev_amount_billed = $rev_amount_billed+$rev_billed_amount['total_amount'];
                    }
                    $rev_pending_amount = $this->allroundbigreportmodel->get_revenue_amount(0,$res['id'],1);
                    if($rev_pending_amount['total_amount']) {
                        $rev_amount_pending_billing = $rev_amount_pending_billing+$rev_pending_amount['total_amount'];
                    }
                    $rev_not_transfered_amount = $this->allroundbigreportmodel->get_revenue_amount(0,$res['id'],0);
                    if($rev_not_transfered_amount['total_amount']) {
                        $rev_amount_not_transfered = $rev_amount_not_transfered+$rev_not_transfered_amount['total_amount'];
                    }
                    $total_costs_amount = $this->allroundbigreportmodel->get_revenue_amount(1,$res['id'],'');
                    if($total_costs_amount['total_amount']) {
                        $costs_amount = $costs_amount+$total_costs_amount['total_amount'];
                    }

                    $html="";

                    $pickup_company = (!empty($res['pickup_company'])) ? $res['pickup_company'].' , ' :  "" ;
                    $delivery_company = (!empty($res['delivery_company'])) ? $res['delivery_company'].' , ' :  "" ;
                    $pickup_address1 = (!empty($res['pickup_address1'])) ? $res['pickup_address1'].' , ' :  "" ;
                    $pickup_address2 = (!empty($res['pickup_address2'])) ? $res['pickup_address2'].' , ' :  "" ;
                    $pickup_city = (!empty($res['pickup_city'])) ? $res['pickup_city'].' , ' :  "" ;
                    $pickup_country = (!empty($res['pickup_country'])) ? $res['pickup_country'].' , ' :  "" ;
                    $pickup_pincode = (!empty($res['pickup_pincode'])) ? $res['pickup_pincode'].' , ' :  "" ;
                    $delivery_address1 = (!empty($res['delivery_address1'])) ? $res['delivery_address1'].' , ' :  "" ;
                    $delivery_address2 = (!empty($res['delivery_address2'])) ? $res['delivery_address2'].' , ' :  "" ;
                    $delivery_city = (!empty($res['delivery_city'])) ? $res['delivery_city'].' , ' :  "" ;
                    $delivery_country = (!empty($res['delivery_country'])) ? $res['delivery_country'].' , ' :  "" ;
                    $delivery_pincode = (!empty($res['delivery_pincode'])) ? $res['delivery_pincode'].' , ' :  "" ;

                    $pickup_address = $pickup_company.$pickup_address1.$pickup_city.$pickup_address2.$pickup_country.$pickup_pincode;
                    $delivery_address = $delivery_company.$delivery_address1.$delivery_city.$delivery_address2.$delivery_country.$delivery_pincode;
                    $origional_deliverycity = (!empty($res['delivery_city'])) ? $res['delivery_city'] :  "" ;
                    $pickup_address = ltrim($pickup_address,' , ');
                    $pickup_address = rtrim($pickup_address,' , ');
                    $delivery_address = ltrim($delivery_address,' , ');
                    $delivery_address = rtrim($delivery_address,' , ');
                    $origional_pickupcity = (!empty($res['pickup_city'])) ? $res['pickup_city'] :  "" ;

                    $getpartydetails = $this->truckwaybillmodel->getpartydetails($res['id']);
                    $customer_details = $payer_details = $drop_details = $shipper_details = array('id'=>"",'name'=>"",'phone'=>"",'email'=>"",'fax'=>"",'code'=>"",'street'=>"",'state'=>"",'city'=>"",'country'=>"",'pincode'=>"",'acon'=>"",'kn_login'=>"",'vat_reg_no'=>"",'tax_payer_no'=>"",'contract_no'=>"",'contract_date'=>"");
                    if(!empty($getpartydetails)){
                        foreach($getpartydetails as $rr){
                            $ptype = $rr['party_type_id'];
                            $chktype = $this->db->select("name")->get_where("tbl_party_types",array("id"=>$ptype),1,0);
                            if($chktype->num_rows()>0){
                                if($chktype->row()->name == "Consignee"){
                                    $drop_details = array('id'=>$rr['customeridentifier'],'name'=>$rr['name'],'phone'=>$rr['mobile'],'email'=>$rr['email'],'fax'=>$rr['fax'],'code'=>$rr['code'],'acon'=>$rr['acon_debitor_code'],'kn_login'=>$rr['kn_login_account'],'vat_reg_no'=>$rr['vat_reg_no'],'tax_payer_no'=>$rr['tax_payer_no'],'contract_no'=>$rr['contract_no'],'contract_date'=>$rr['contract_date'],'house_number'=>$rr['house_number']);
                                }else if($chktype->row()->name == "Shipper"){
                                    $shipper_details = array('id'=>$rr['customeridentifier'],'name'=>$rr['name'],'phone'=>$rr['mobile'],'email'=>$rr['email'],'fax'=>$rr['fax'],'code'=>$rr['code'],'acon'=>$rr['acon_debitor_code'],'kn_login'=>$rr['kn_login_account'],'vat_reg_no'=>$rr['vat_reg_no'],'tax_payer_no'=>$rr['tax_payer_no'],'contract_no'=>$rr['contract_no'],'contract_date'=>$rr['contract_date'],'house_number'=>$rr['house_number']);
                                }
                            }
                        }
                    }

                    /*Shipper ACON Debitor Code Shipper KN Login Account    Shipper VAT Registration Number Shipper Tax Payer ID*/
                    $shipper_details['name'] = $res['pickup'];
                    $shipper_details['street'] = $res['pickup_address1'];

                    if(isset($shipper_details['house_number'])){
                        if($shipper_details['house_number'] != ""){
                          $shipper_details['street'] .= $shipper_details['house_number'];
                        }
                     }

                    $shipper_details['state'] = $res['pickup_address2'];
                    $shipper_details['city'] = $res['pickup_city'];
                    $shipper_details['country'] = $res['pickup_country'];
                    $shipper_details['pincode'] = $res['pickup_pincode'];

                    $drop_details['name'] = $res['delivery'];
                    $drop_details['street'] = $res['delivery_address1'];
                    if(isset($drop_details['house_number'])){
                        if($drop_details['house_number'] != ""){
                          $drop_details['street'] .= $drop_details['house_number'];
                        }
                     }
                    $drop_details['state'] = $res['delivery_address2'];
                    $drop_details['city'] = $res['delivery_city'];
                    $drop_details['country'] = $res['delivery_country'];
                    $drop_details['pincode'] = $res['delivery_pincode'];

                    $getcustdetails = $this->truckwaybillmodel->getcustomerdetails($res['customer_id']);

                    if(!empty($getcustdetails)){
                        if($getcustdetails['contract_date'] == "0000-00-00"){
                          $getcustdetails['contract_date'] = "";
                        }
                        $street = $getcustdetails['street'];
                        if($getcustdetails['house_number'] !=""){
                          $street .= $getcustdetails['house_number'];
                        }
                        $customer_details = array('id'=>$getcustdetails['customeridentifier'],'name'=>$getcustdetails['name'],'phone'=>$getcustdetails['mobile'],'email'=>$getcustdetails['email'],'fax'=>$getcustdetails['fax'],'code'=>$getcustdetails['code'],'street'=>$street,'state'=>$getcustdetails['state'],'city'=>$getcustdetails['location_id'],'country'=>$getcustdetails['country'],'pincode'=>$getcustdetails['pincode'],'acon'=>$getcustdetails['acon_debitor_code'],'kn_login'=>$getcustdetails['kn_login_account'],'vat_reg_no'=>$getcustdetails['vat_reg_no'],'tax_payer_no'=>$getcustdetails['tax_payer_no'],'contract_no'=>$getcustdetails['contract_no'],'contract_date'=>$getcustdetails['contract_date']);
                    }

                    $notify_party=$this->truckwaybillmodel->notify_party($res['order_id']);
                    $notify_address['name'] ="";

                    if($notify_party->num_rows()>0){
                        $notify_address['name']=$notify_party->row()->name;
                    }
                    if($notify_address['name'] == ""){
                       $notify_address['name'] ="Notify Party";
                    }

                    $getstatusdates = $this->getstatusdates($res['order_id']);
                    $getcargodetails = $this->getcargodetails($res['id']);

                    $get_references = $this->truckwaybillmodel->getorderreferences($res['id']);
                    $ref_1_name = $ref_1_description= $ref_1_value = $ref_2_name = $ref_2_description= $ref_2_value = $ref_3_name = $ref_3_description=$ref_3_value = $ref_4_name = $ref_4_description= $ref_4_value = $ref_5_name = $ref_5_description= $ref_5_value = $ruck_val =$rucksn_val ="";

                    if(!empty($get_references)){
                        $i =1;
                        foreach($get_references as $ref){
                            $ref_id = $ref['reference_id'];
                            if(!in_array($ref_id, array('ORD_DLVINST','ORD_PIKINST','RUCK','RUCKSN','DQ','PO'))){
                                if($i ==1){
                                    $ref_1_name = $ref_id;
                                    $ref_1_description = $ref['description'];
                                    $ref_1_value = $ref['ref_value'];
                                }else if($i ==2){
                                    $ref_2_name = $ref_id;
                                    $ref_2_description = $ref['description'];
                                    $ref_2_value = $ref['ref_value'];
                                }else if($i ==3){
                                    $ref_3_name = $ref_id;
                                    $ref_3_description = $ref['description'];
                                    $ref_3_value = $ref['ref_value'];
                                }else if($i ==4){
                                    $ref_4_name = $ref_id;
                                    $ref_4_description = $ref['description'];
                                    $ref_4_value = $ref['ref_value'];
                                }else if($i ==5){
                                    $ref_5_name = $ref_id;
                                    $ref_5_description = $ref['description'];
                                    $ref_5_value = $ref['ref_value'];
                                }
                                $i++;
                            }
                            if($ref_id == 'DQ'){
                                $delivery_note = $ref['ref_value'];
                            }
                            if($ref_id == 'RUCK'){
                                $ruck_val = $ref['ref_value'];
                            }
                            if($ref_id == 'RUCKSN'){
                                $rucksn_val = $ref['ref_value'];
                            }
                        }
                    }

                    $docs_received_datetime = $res['docs_received_datetime'];
                    if($docs_received_datetime != "" && $docs_received_datetime != null){
                        $getactual = getdatetimebytimezone($curtz,$docs_received_datetime,DFLT_TZ);
                        $docs_received_datetime = $getactual['datetime'];
                    }
                    $docs_sent_datetime = $res['docs_sent_datetime'];
                    if($docs_sent_datetime != "" && $docs_sent_datetime != null){
                        $getactual = getdatetimebytimezone($curtz,$docs_sent_datetime,DFLT_TZ);
                        $docs_sent_datetime = $getactual['datetime'];
                    }

                    $info['shift_id'] = $res['shift_id'];
                    $info['trip_id'] = $res['trip_id'];
                    $tripinfo = $this->tripinfo($info);
                    $carrier_details = $tripinfo['carrier_details'];
                    $vehicle_type = $tripinfo['vehicle_type'];
                    $trailer_no = $tripinfo['trailer_no'];
                    $register_number = $tripinfo['register_number'];
                    $driver_name = $tripinfo['driver_name'];
                    $driver_licence_number = $tripinfo['driver_licence_number'];

                    $cust_rev = $this->common->gettblrowdata(array('order_id'=>$res['id'],'recipient_role'=>'Customer','status'=>1),'bill_id','tb_reveneus',0,0);
                    $getpayer = array('id'=>"",'name'=>"",'phone'=>"",'email'=>"",'code'=>"",'acon'=>"",'kn_login'=>"",'vat_reg_no'=>"",'tax_payer_no'=>"",'payer_postal'=>"",'payer_steeet_house'=>"",'payer_country'=>"");
                    if(!empty($cust_rev)){
                        $bill = $this->common->gettblrowdata(array('id'=>$cust_rev['bill_id'],'status !='=>0),'code','tbl_bills',0,0);
                        if(!empty($bill)){
                        $getpayer = $this->getpayerdetails($bill['code']);
                        }
                    }

                    $rev = $this->common->gettblrowdata(array('order_id'=>$res['id'],'type'=>0,'status'=>1),'id,currency,debtor_jfr,bu_jfr,exchange_rate,foreign_currency,invoice_number,invoice_date,credit_note_number,invoice_creation_date,invoice_receivdon_date,invoice_status','tb_reveneus',0,0);
                    $getcharge =  array('chargecode'=>'','chargecodename'=> '','quantity'=>'','value'=>'','rate_id'=>'','amount'=>'','currency'=>'','vat_percentage'=>'','vat_amount'=>'');
                        $rev_foreign_currency = $rev_debtor_jfr = $rev_bu_jfr = $rev_exchange_rate = $rev_invoiceno = $rev_invoicedate = $rev_creditnote = $rev_invoice_creation_date = $rev_invoice_receivdon_date = $rev_invoice_status = '';
                    if(!empty($rev)){
                     $rev_foreign_currency = $rev['foreign_currency'];
                        $rev_debtor_jfr = $rev['debtor_jfr'];
                        $rev_bu_jfr = $rev['bu_jfr'];
                        $rev_exchange_rate = $rev['exchange_rate'];
                        $rev_invoiceno = $rev['invoice_number'];
                        if($rev['invoice_date'] != "0000-00-00 00:00:00"){
                           $rev_invoicedate = $rev['invoice_date'];
                        }
                        $rev_creditnote = $rev['credit_note_number'];
                        if($rev['invoice_creation_date'] != "0000-00-00 00:00:00"){
                           $rev_invoice_creation_date = $rev['invoice_creation_date'];
                        }
                        if($rev['invoice_receivdon_date'] != "0000-00-00 00:00:00"){
                           $rev_invoice_receivdon_date = $rev['invoice_receivdon_date'];
                        }
                        if($rev['invoice_status'] == 1){
                            $rev_invoice_status = "Ready to Invoiced";
                        }else {
                            $rev_invoice_status = "Billed";
                        }
                        $getcharges =$this->getcharges($res['id'],0);
                        if(!empty($getcharges)){
                            $getcharge = $getcharges;
                        }else{
                            $getcharge = array('chargecode'=>"",'chargecodename'=>"",'quantity'=>"",'value'=>"",'rate_id'=>"",'amount'=>"",'currency'=>"",'vat_percentage'=>"",'vat_amount'=>"");
                        }

                    }

                    $cost = $this->common->gettblrowdata(array('order_id'=>$res['id'],'type'=>1,'status'=>1),'id,currency,debtor_jfr,bu_jfr,exchange_rate,foreign_currency,invoice_number,invoice_date,credit_note_number,invoice_creation_date,invoice_receivdon_date,invoice_status','tb_reveneus',0,0);
                    $getcostcharge =  array('chargecode'=>'','chargecodename'=> '','quantity'=>'','value'=>'','rate_id'=>'','amount'=>'','currency'=>'','vat_percentage'=>'','vat_amount'=>'');
                      $cost_foreign_currency = $cost_debtor_jfr = $cost_bu_jfr = $cost_exchange_rate = $cost_invoiceno = $cost_invoicedate = $cost_creditnote = '';
                    if(!empty($cost)){
                        $cost_foreign_currency = $cost['foreign_currency'];
                        $cost_debtor_jfr = $cost['debtor_jfr'];
                        $cost_bu_jfr = $cost['bu_jfr'];
                        $cost_exchange_rate = $cost['exchange_rate'];
                        $getcostcharges =$this->getcharges($res['id'],1);

                        if(!empty($getcostcharges)){
                            $getcostcharge = $getcostcharges;
                        }
                    }

                    $getvasdetails = $this->truckwaybillmodel->getvasdetails($res['id']);
                    $vas_1_name= $vas_1_quantity = $vas_2_name= $vas_2_quantity = $vas_3_name =$vas_3_quantity = $vas_4_name= $vas_4_quantity= $vas_5_name = $vas_5_quantity = "";
                    if(!empty($getvasdetails)){
                        $v= 1;
                        foreach ($getvasdetails as $vas) {
                            if($v ==1){
                                $vas_1_name=$vas['vas_name'];
                                $vas_1_quantity = $vas['quantity'];
                            }else if($v ==2){
                                $vas_2_name=$vas['vas_name'];
                                $vas_2_quantity = $vas['quantity'];
                            }else if($v ==3){
                                $vas_3_name=$vas['vas_name'];
                                $vas_3_quantity = $vas['quantity'];
                            }else if($v ==4){
                                $vas_4_name=$vas['vas_name'];
                                $vas_4_quantity = $vas['quantity'];
                            }else if($v ==5){
                                $vas_5_name=$vas['vas_name'];
                                $vas_5_quantity = $vas['quantity'];
                            }
                            $v++;
                        }
                    }
                    $service_name = "";
                    if($res['service'] > 0){
                        $getservice = $this->common->gettblrowdata(array("id"=>$res['service'],"status"=>1),"name","tb_service_master",0,0);
                        if(!empty($getservice)){
                            $service_name = $getservice['name'];
                        }
                    }
                    $order_type = $delivery_term = "";
                            if($res['order_type'] > 0){
                            $getordertype = $this->db->select("type_name")->get_where("tb_order_types", array('id' => $res['order_type'], 'status' => '1','company_code'=>$res['company_code']));
                            if ($getordertype->num_rows() > 0) {
                                $order_type = $getordertype->row()->type_name;
                            }
                          }
                          if($res['delivery_term'] > 0){
                          $where=array("term_id"=>$res['delivery_term']);
                                $delivery_incoterms = $this->common->gettblrowdata($where,"name","tb_delivery_terms",0,0);
                                if(!empty($delivery_incoterms)){
                                    $delivery_term = $delivery_incoterms['name'];
                                }
                          }

                    $order[] = [
                        'order_row_id' => $res['id'],
                        'order_id' => $res['order_id'],
                        'delivery_note' => $delivery_note,
                        'pickup' => $res['pickup'],
                        'delivery' => $res['delivery'],
                        'trip_no' => $trip_no,
                        'order_status' => $order_status,
                        'transport_mode' => $res['transport_mode'],
                        'createdon' => $createdon,
                        'total_packages' => round($res['totqty']),
                        'vweight'=>$res['totvweight'],
                        'company_code' => $res['company_code'],
                        'branch_code' => $res['branch_code'],
                        'department_code' => $res['department_code'],
                        'delivery_date'=>$early_delivery,
                        'pickup_date'=>$early_pickup,
                        'html'=>$html,
                        'shipper_address'=>$pickup_address,
                        'consignee_address'=>$delivery_address,
                        'addon_html'=>$addon_html,
                        'revenue_amount_billed' => $rev_amount_billed,
                        'revenue_amount_pending_billing'=>$rev_amount_pending_billing,
                        'revenue_amount_not_transfered'=>$rev_amount_not_transfered,
                        'costs_amount'=>$costs_amount,
                        'received_status'=>$received_status,
                        'sent_status'=>$sent_status,
                        'vname' => $vname,
                        'vehicle_no' => $register_number,
                        'pickup_date_status' => $pickup_date_status,
                        'delivery_datestatus'=>$delivery_datestatus,
                        'goods_value'=>$res['goods_value'],
                        'pickup_city'=>$origional_pickupcity,
                        'delivery_city'=>$origional_deliverycity,
                        'order_createdon'=>$res['createdon'],
                        'delivery_orderno'=>$delivery_note,
                        'purchase_orderno'=>$res['purchase_order'],
                        'shipper_id'=>$shipper_details['id'],
                        'shipper_cid'=>$shipper_details['code'],
                        'shipper_acondebtorcode'=>$shipper_details['acon'],
                        'shipper_kn_login'=>$shipper_details['kn_login'],
                        'shipper_vatno'=>$shipper_details['vat_reg_no'],
                        'shipper_taxpayerid'=>$shipper_details['tax_payer_no'],
                        'shipper_name'=>$shipper_details['name'],
                        'shipper_steeet_house'=>$shipper_details['street'],
                        'shipper_city'=>$shipper_details['city'],
                        'shipper_postal'=>$shipper_details['pincode'],
                        'shipper_country'=>$shipper_details['country'],
                        'shipper_phone'=>$shipper_details['phone'],
                        'shipper_email'=>$shipper_details['email'],
                        'consignee_id'=>$drop_details['id'],
                        'consignee_cid'=>$drop_details['code'],
                        'consignee_acondebtor'=>$drop_details['acon'],
                        'consignee_knlogin'=>$drop_details['kn_login'],
                        'consignee_vat_reg_no'=>$drop_details['vat_reg_no'],
                        'consignee_taxpayerid'=>$drop_details['tax_payer_no'],
                        'consignee_name'=>$drop_details['name'],
                        'consignee_steeet_house'=>$drop_details['street'],
                        'consignee_city'=>$drop_details['city'],
                        'consignee_postal'=>$drop_details['pincode'],
                        'consignee_country'=>$drop_details['country'],
                        'consignee_phone'=>$drop_details['phone'],
                        'consignee_email'=>$drop_details['email'],
                        'customer_id'=>$customer_details['id'],
                        'customer_cid'=>$customer_details['code'],
                        'customer_acondebtorcode'=>$customer_details['acon'],
                        'customer_kn_login'=>$customer_details['kn_login'],
                        'customer_vat_reg_no'=>$customer_details['kn_login'],
                        'customer_tax_payerid'=>$customer_details['tax_payer_no'],
                        'customer_name'=>$customer_details['name'],
                        'customer_steeet_house'=>$customer_details['street'],
                        'customer_postal'=>$customer_details['pincode'],
                        'customer_country'=>$customer_details['country'],
                        'customer_phone'=>$customer_details['phone'],
                        'customer_email'=>$customer_details['email'],
                        'country'=>$customer_details['country'],
                        'product'=>$res['product'],
                        'service'=>$service_name,
                        'incoterm'=>$res['incoterm'],
                        'delivery_term'=>$delivery_term,
                        'notify_party'=>$notify_address['name'],
                        'order_type'=>$order_type,
                        'purchase_order'=>$res['purchase_order'],
                        'quantity'=>$getcargodetails['quantity'],
                        'package_type'=>$getcargodetails['package_type'],
                        'length'=>$getcargodetails['length'],
                        'length_unit'=>$getcargodetails['length_unit'],
                        'width'=>$getcargodetails['width'],
                        'width_unit'=>$getcargodetails['width_unit'],
                        'height'=>$getcargodetails['height'],
                        'height_unit'=>$getcargodetails['height_unit'],
                        'weight'=>$getcargodetails['second_weight'],'
                        weight_unit'=>$getcargodetails['weight_unit'],
                        'volume'=>$getcargodetails['second_volume'],
                        'volume_unit'=>$getcargodetails['volume_unit'],
                        'ldm'=>$getcargodetails['ldm'],
                        'volumetric_weight'=>$getcargodetails['volumetric_weight'],
                        'volweight_uom'=>$getcargodetails['volweight_uom'],
                        'stackable'=>$getcargodetails['stackable'],
                        'dg_goods'=>$getcargodetails['dg_goods'],
                        'act_weight'=>$getcargodetails['weight'],
                        'act_volume'=>$getcargodetails['volume'],
                        'vas_1_name'=>$vas_1_name,
                        'vas_1_quantity'=>$vas_1_quantity,
                        'vas_2_name'=>$vas_2_name,
                        'vas_2_quantity'=>$vas_2_quantity,
                        'vas_3_name'=>$vas_3_name,
                        'vas_3_quantity'=>$vas_3_quantity,
                        'vas_4_name'=>$vas_4_name,
                        'vas_4_quantity'=>$vas_4_quantity,
                        'vas_5_name'=>$vas_5_name,
                        'vas_5_quantity'=>$vas_5_quantity,
                        'ref_1_name'=>$ref_1_name,
                        'ref_1_description'=>$ref_1_description,
                        'ref_1_value'=>$ref_1_value,
                        'ref_2_name'=>$ref_2_name,
                        'ref_2_description'=>$ref_2_description,
                        'ref_2_value'=>$ref_2_value,
                        'ref_3_name'=>$ref_3_name,
                        'ref_3_description'=>$ref_3_description,
                        'ref_3_value'=>$ref_3_value,
                        'ref_4_name'=>$ref_4_name,
                        'ref_4_description'=>$ref_4_description,
                        'ref_4_value'=>$ref_4_value,
                        'ref_5_name'=>$ref_5_name,
                        'ref_5_description'=>$ref_5_description,
                        'ref_5_value'=>$ref_5_value,
                        'ruck_val'=>$ruck_val,
                        'rucksn_val'=>$rucksn_val,
                        'status_picked_up_datetime'=>$getstatusdates['statuspickupdate'],
                        'status_delivered_datetime'=>$getstatusdates['statusdeliverydate'],
                        'original_documents_received_datetime'=>$docs_received_datetime,
                        'original_documents_sent_datetime'=>$docs_sent_datetime,
                        'carrier'=>$carrier_details['suppier_name'],
                        'vehicle_number'=>$register_number,
                        'trailer_number'=>$trailer_no,
                        'vehicle_type'=>$vehicle_type,
                        'driver_name'=>$driver_name,
                        'driver_licence_number'=>$driver_licence_number,
                        'payer_role'=>"Customer",
                        'payer_id'=>$getpayer['id'] ?? 0,
                        'payer_name'=>$getpayer['name'] ?? '',
                        'payer_cid'=>$getpayer['code'] ?? '',
                        'payer_acondebtorcode'=>$getpayer['acon'] ?? '',
                        'payer_kn_login_account'=>$getpayer['kn_login'] ?? '',
                        'payer_vat_regno'=>$getpayer['vat_reg_no'] ?? '',
                        'payer_tax_payerid'=>$getpayer['tax_payer_no'] ?? '',
                        'payer_steeet_house'=>$getpayer['payer_steeet_house'] ?? '',
                        'payer_postal'=>$getpayer['payer_postal'] ?? '',
                        'payer_country'=>$getpayer['payer_country'] ?? '',
                        'payer_phone'=>$getpayer['phone'] ?? '',
                        'payer_email'=>$getpayer['email'] ?? '',
                        'revenue_charge_code'=>$getcharge['chargecode'] ?? '',
                        'revenue_chargename'=>$getcharge['chargecodename'] ?? '',
                        'revenue_chargequantity'=>$getcharge['quantity'] ?? 0,
                        'revenue_chargevalue'=>$getcharge['value'] ?? '',
                        'revenue_charge_rateid'=>$getcharge['rate_id'] ?? 0,
                        'revenue_charge_amount'=>$getcharge['amount'] ?? 0,
                        'revenue_charge_currency'=>$getcharge['currency'] ?? 0,
                        'revenue_charge_vat%'=>$getcharge['vat_percentage'] ?? 0,
                        'revenue_charge_vatamount'=>$getcharge['vat_amount'] ?? 0,
                        'revenue_bujfr'=>$rev_bu_jfr,
                        'revenue_jfr'=>$rev_debtor_jfr,
                        'revenue_exchangerate'=>$rev_exchange_rate,
                        'revenue_foreigncurrency'=>$rev_foreign_currency,
                        'revenue_invoiceno'=>$rev_invoiceno,
                        'revenue_invoicedate'=>$rev_invoicedate,
                        'revenue_creditnote_number'=>$rev_creditnote,
                        'revenue_creditnote_date'=>"-",
                        'revenue_invoice_creation_date'=>$rev_invoice_creation_date,
                        'revenue_invoice_receiveddate'=>$rev_invoice_receivdon_date,
                        'revenue_status'=>$rev_invoice_status,
                        'customer_contractnumber'=>$customer_details['contract_no'],
                        'customer_contractdate'=>$customer_details['contract_date'],
                        'invoice_status'=>$rev_invoice_status,'suppier_role'=>"",
                        'suppier_id'=>$carrier_details['suppier_id'],
                        'suppier_name'=>$carrier_details['suppier_name'],
                        'suppier_steeet_house'=>$carrier_details['suppier_steeet_house'],
                        'suppier_postalcode'=>$carrier_details['suppier_postalcode'],
                        'suppier_country'=>$carrier_details['suppier_country'],
                        'suppier_phone'=>$carrier_details['suppier_phone'],
                        'suppier_email'=>$carrier_details['suppier_email'],
                        'cost_charge_code'=>$getcostcharge['chargecode'],
                        'cost_chargename'=>$getcostcharge['chargecodename'],
                        'cost_chargequantity'=>$getcostcharge['quantity'],
                        'cost_chargevalue'=>$getcostcharge['value'],
                        'cost_charge_rateid'=>$getcostcharge['rate_id'],
                        'cost_charge_amount'=>$getcostcharge['amount'],
                        'cost_charge_currency'=>$getcostcharge['currency'],
                        'cost_charge_vat%'=>$getcostcharge['vat_percentage'],
                        'cost_charge_vatamount'=>$getcostcharge['vat_amount'],
                        'cost_bujfr'=>$cost_bu_jfr,
                        'cost_jfr'=>$cost_debtor_jfr,
                        'cost_exchangerate'=>$cost_exchange_rate,
                        'cost_foreigncurrency'=>$cost_foreign_currency
                    ];
                }
            }
        }
        $data['list'] = $order;
        if($this->session->userdata('company_code')=='RUKN'){
            $this->newtemplate->dashboard("allroundbigreport/index", $data);
        }else{
            $this->newtemplate->dashboard("allroundbigreport/allRoundIndexV2", $data);
        }
    }

    public function searchsubmitdata($post)
    {
        $whr = array();
         if (isset($post['pickupfrom']) && $post['pickupfrom'] != "") {
            $pickupfrom                                      = date('Y-m-d', strtotime($post['pickupfrom']));
            $whr["DATE_FORMAT(o.pickup_datetime,'%Y-%m-%d') >="] = $pickupfrom;
        }

        if (isset($post['pickupto']) && $post['pickupto'] != "") {
            $pickupto                                        = date('Y-m-d', strtotime($post['pickupto']));
            $whr["DATE_FORMAT(o.pickup_datetime,'%Y-%m-%d') <="] = $pickupto;
        }
        if (isset($post['fromdate_search']) && $post['fromdate_search'] != "") {
            $fromdate_search                                      = date('Y-m-d', strtotime($post['fromdate_search']));
            $whr["DATE_FORMAT(o.createdon,'%Y-%m-%d') >="] = $fromdate_search;
        }

        if (isset($post['todate_search']) && $post['todate_search'] != "") {
            $todate                                        = date('Y-m-d', strtotime($post['todate_search']));
            $whr["DATE_FORMAT(o.createdon,'%Y-%m-%d') <="] = $todate;
        }

        if (isset($post['booking_id']) && $post['booking_id'] != "") {
            $whr['o.order_id'] = $post['booking_id'];
        }

        if (isset($post['order_id']) && $post['order_id'] != "") {
            $whr['o.order_id'] = $post['order_id'];

        }
        if (isset($post['searchcustomer_id']) && $post['searchcustomer_id'] != "") {
            $getcustomer_id = $this->db->select("id")->get_where("tb_customers",array('code'=>$post['searchcustomer_id']));
            if($getcustomer_id->num_rows() >0){
                $whr['o.customer_id'] = $getcustomer_id->row()->id;
            }
        }

        if (isset($post['custcode']) && $post['custcode'] != "") {
            $getcustomer_id = $this->db->select("id")->get_where("tb_customers",array('code'=>$post['custcode']));
            if($getcustomer_id->num_rows() >0){
                $whr['o.customer_id'] = $getcustomer_id->row()->id;
            }
        }

        if (isset($post['service']) && $post['service'] != "") {
            $whr['d.service'] = $post['service'];

        }

        if (isset($post['order_type']) && $post['order_type'] != "") {
            $whr['d.order_type'] = $post['order_type'];

        }
        if (isset($post['product']) && $post['product'] != "") {
            $whr['o.product'] = $post['product'];

        }
        if (isset($post['modeof_trasnport']) && $post['modeof_trasnport'] != "") {
            $whr['o.transport_mode'] = $post['modeof_trasnport'];

        }
        if (isset($post['searchshipper_id']) && $post['searchshipper_id'] != "") {
            $whr['o.pickup_custid'] = $post['searchshipper_id'];

        }
        if (isset($post['searchconsignee_id']) && $post['searchconsignee_id'] != "") {
            $whr['o.drop_custid'] = $post['searchconsignee_id'];

        }
        if (isset($post['delivery_note']) && $post['delivery_note'] != "") {
            $getdelivery_noteid = $this->db->select("order_id")->get_where("tb_order_references",array('ref_value'=>$post['delivery_note'],'status'=>'1','reference_id'=>'DQ'));
            if($getdelivery_noteid->num_rows() >0){
                $order_id = $getdelivery_noteid->row()->order_id;
                $whr['o.id'] = $order_id;
            }

        }
        if (isset($post['purchase_order']) && $post['purchase_order'] != "") {
            $whr['d.purchase_order'] = $post['purchase_order'];

        }
        if (isset($post['company_code']) && $post['company_code'] != "") {
            $whr['o.company_code'] = $post['company_code'];

        }
        if (isset($post['branch_code']) && $post['branch_code'] != "") {
            $whr['o.branch_code'] = $post['branch_code'];

        }

        return $whr;
    }

    public function getbookingid()
    {
        $uid = $this->session->userdata('user_id');
        $custid="";
        $country_userids = array();
        if(!empty($this->session->userdata("country_user_ids")) && ($this->session->userdata("country_user_ids") != null) && (count($this->session->userdata("country_user_ids")) > 0) ) {
            $country_userids = $this->session->userdata("country_user_ids");
        }
        $business_type = $this->session->userdata('business_type');
        if(!empty($this->session->userdata("cust_id"))) {
            $custid = $this->session->userdata("cust_id");
        }
        $post = $this->input->post(NULL,TRUE);
        $booking_id = isset($post["booking_id"])? $post["booking_id"] : "";
        $booking_id = trim($booking_id);
        $data = $subcusts = array();
        $where = "";
        if($business_type == "Customer") {
            $uid = 0;
        }
        if ($uid != '0') {
            if (!empty($country_userids)) {
                $where = "and user_id in (" . $this->db->escape($country_userids) . ")";
            } else {
                $where = "and user_id = '" . $this->db->escape($uid) . "'";
            }
        }
        if (!empty($custid)) {
            if ($this->session->userdata('sub_cust') !== false) {
                $subcusts = $this->session->userdata('sub_cust');
                if (count($subcusts) > 0) {
                    array_push($subcusts, $custid);
                } else {
                    $subcusts = [$custid];
                }
            } else {
                $subcusts = [$custid];
            }
        }
        if (!empty($subcusts)) {
            $subcusts = implode(',', $subcusts);
            $where = "and customer_id in (" . $this->db->escape($subcusts) . ")";
        } else {
            if ($custid != "") {
                $where = "and customer_id = '" . $this->db->escape($custid) . "'";
            }
        }
        $get_data = $this->db->query("SELECT order_id FROM tb_orders  WHERE order_id like ? $where and STATUS != 0", ["%$booking_id%"]);
        if($get_data->num_rows() > 0){
            foreach ($get_data->result() as $get_data_f) {
                $data[] = $get_data_f->order_id;
            }
        }
        echo json_encode($data);
    }

    public function getcustcode()
    {
        $uid = $this->session->userdata('user_id');
        $post = $this->input->post(NULL,TRUE);
        $custcode = isset($post["custcode"])? $post["custcode"] : "";
        $custcode = trim($custcode);
        $data = array();
        $company_code = $this->session->userdata("company_code");
        $get_data = $this->db->query("SELECT code FROM tb_customers  WHERE code like ? and company_code LIKE ? and status='1' order by id desc", ["%$custcode%", $company_code]);
        if($get_data->num_rows() > 0){
            foreach ($get_data->result() as $get_data_f) {
                $data[] = $get_data_f->code;
            }
        }
        echo json_encode($data);
    }
    /**
     * autocomplete invoice number
     *
     *
     * @author    Developer Name external.pach.b@kuehne-nagel.com
     * @date      28-05-2021 18:09:00
     * @change    Europe
     * @param     Integer Order Id
     * @return    Array
     */
    public function getinvoiceno() {
    $curtz = $this->session->userdata("usr_tzone")['timezone'];

        $uid = $this->session->userdata('user_id');
        $post = $this->input->post(NULL,TRUE);
         $get_currency = $this->common->gettblrowdata(array('cntry_timezone'=>$curtz,'status'=>'1'),'currency','tbl_country_master',0,0);
             if(!empty($get_currency)){
                        $currency = $get_currency['currency'];
                    }
        $searchinvoice_no = isset($post["searchinvoice_no"])? $post["searchinvoice_no"] : "";
        $searchinvoice_no = trim($searchinvoice_no);
        $data = array();
        $select="invoice_number";
       $ref_wh = array('invoice_number'=>$post['searchinvoice_no'],'currency'=>$currency);
          $getordid = $this->common->getordid($select,$ref_wh);
         if(!empty($getordid)){
            foreach ($getordid as $key => $getorderid) {
                $data[]  = $getorderid['invoice_number'];
            }
          }


        echo json_encode($data);
    }

    public function getcargodetails($order_id){
        $getcargodetails = $this->truckwaybillmodel->getcargodetails($order_id);
        $quantity =  $package_type  = $length = $length_unit = $width = $width_unit = $height = $height_unit = $weight=  $weight_unit =  $volume = $volume_unit =  $ldm = $volumetric_weight = $volweight_uom =  $stackable = $dg_goods =$second_weight= $second_volume= array();
        $result_cargodetails = array('quantity'=>$quantity,'package_type'=>$package_type  , 'length'=>$length , 'length_unit'=>$length_unit , 'width'=>$width , 'width_unit'=>$width_unit , 'height'=>$height , 'height_unit'=>$height_unit , 'weight'=>$weight,  'weight_unit'=>$weight_unit ,  'volume'=>$volume , 'volume_unit'=>$volume_unit ,  'ldm'=>$ldm , 'volumetric_weight'=>$volumetric_weight , 'volweight_uom'=>$volweight_uom ,  'stackable'=>$stackable , 'dg_goods'=>$dg_goods, 'second_weight'=>$second_weight, 'second_volume'=>$second_volume);
        if(!empty($getcargodetails)){
            foreach ($getcargodetails as $cargodetails) {
                $quantity[] = $cargodetails['quantity'];
                $package_type[] = $cargodetails['cargo_type'];
                $length[] = $cargodetails['length'];
                $length_unit[] = $cargodetails['length_unit'];
                $width[] = $cargodetails['width'];
                $width_unit[] = $cargodetails['width_unit'];
                $height[] = $cargodetails['height'];
                $height_unit[] = $cargodetails['height_unit'];
                $weight[] = $cargodetails['weight'];
                $weight_unit[] = $cargodetails['weight_unit'];
                $volume[] = $cargodetails['volume'];
                $volume_unit[] = $cargodetails['volume_unit'];
                $ldm[] = $cargodetails['ldm'];
                $volumetric_weight[] = $cargodetails['volumetric_weight'];
                $volweight_uom[] = $cargodetails['volweight_uom'];
                if($cargodetails['stackable'] == 0){
                    $stackable1 = "No";
                }else{
                    $stackable1 = "Yes";
                }
                $stackable[] = $stackable1;
                if($cargodetails['dg_goods'] == 0){
                    $dg_goods1 = "No";
                }else{
                    $dg_goods1 = "Yes";
                }
                $dg_goods[] = $dg_goods1;
                $second_weight[] = $cargodetails['second_weight'];
                $second_volume[] = $cargodetails['second_volume'];
            }
        }
        if(!empty($quantity)){
            $quantity = array_sum($quantity);
        }else{
            $quantity = "-";
        }
        if(!empty($package_type)){
            $package_type = implode(',',$package_type);
        }else{
            $package_type = "-";
        }
        if(!empty($length) && sizeof($length) == 1){
            $length = implode(',',$length);
        }else{
            $length = "-";
        }
        if(!empty($length_unit)){
            $length_unit = implode(',',$length_unit);
        }else{
            $length_unit = "-";
        }
        if(!empty($width) && sizeof($width) == 1){
            $width = implode(',',$width);
        }else{
            $width = "-";
        }
        if(!empty($width_unit)){
            $width_unit = implode(',',$width_unit);
        }else{
            $width_unit = "-";
        }
        if(!empty($height) && sizeof($height) == 1){
            $height = implode(',',$height);
        }else{
            $height = "-";
        }
        if(!empty($height_unit)){
            $height_unit = implode(',',$height_unit);
        }else{
            $height_unit = "-";
        }
        if(!empty($weight) ){
            $weight = array_sum($weight);
        }else{
            $weight = "-";
        }
        if(!empty($weight_unit)){
            $weight_unit = implode(',',$weight_unit);
        }else{
            $weight_unit = "-";
        }
        if(!empty($volume)){
            $volume = array_sum($volume);
        }else{
            $volume = "-";
        }
        if(!empty($volume_unit)){
            $volume_unit = implode(',',$volume_unit);
        }else{
            $volume_unit = "-";
        }
        if(!empty($ldm)){
            $ldm = array_sum($ldm);
        }else{
            $ldm = "-";
        }
        if(!empty($volumetric_weight)){
            $volumetric_weight = array_sum($volumetric_weight);
        }else{
            $volumetric_weight = "-";
        }
        if(!empty($volweight_uom)){
            $volweight_uom = implode(',',$volweight_uom);
        }else{
            $volweight_uom = "-";
        }
        if(!empty($stackable)){
            $stackable = implode(',',$stackable);
        }else{
            $stackable = "-";
        }
        if(!empty($dg_goods)){
            $dg_goods = implode(',',$dg_goods);
        }else{
            $dg_goods = "-";
        }
        if(!empty($second_volume)){
            $second_volume = array_sum($second_volume);
        }else{
            $second_volume = "-";
        }
        if(!empty($second_weight)){
            $second_weight = array_sum($second_weight);
        }else{
            $second_weight = "-";
        }
        $result_cargodetails = array('quantity'=>$quantity,'package_type'=>$package_type  , 'length'=>$length , 'length_unit'=>$length_unit , 'width'=>$width , 'width_unit'=>$width_unit , 'height'=>$height , 'height_unit'=>$height_unit , 'weight'=>$weight,  'weight_unit'=>$weight_unit ,  'volume'=>$volume , 'volume_unit'=>$volume_unit ,  'ldm'=>$ldm , 'volumetric_weight'=>$volumetric_weight , 'volweight_uom'=>$volweight_uom ,  'stackable'=>$stackable , 'dg_goods'=>$dg_goods, 'second_weight'=>$second_weight, 'second_volume'=>$second_volume);
        return $result_cargodetails;
    }

    public function getstatusdates($gene_order_id){
        $zonecode = $this->session->userdata("usr_tzone");
        $curtz = $zonecode['timezone'];
        $data = array('statuspickupdate'=>"",'statusdeliverydate'=>"");
        $getpicanddeldates = $this->truckwaybillmodel->getpicanddeldates($gene_order_id);
        if(!empty($getpicanddeldates)){
            foreach ($getpicanddeldates as $getpicanddeldate) {
                if($getpicanddeldate['stop_type'] == "P"){
                    if($getpicanddeldate['createdon'] != ""){
                        $getactual = getdatetimebytimezone($curtz,$getpicanddeldate['createdon'],DFLT_TZ);
                        $data['statuspickupdate'] = $getactual['datetime'];
                    }
                }
                if($getpicanddeldate['stop_type'] == "D"){
                    if($getpicanddeldate['createdon'] != ""){
                        $getactual = getdatetimebytimezone($curtz,$getpicanddeldate['createdon'],DFLT_TZ);
                        $data['statusdeliverydate'] = $getactual['datetime'];
                    }
                }
            }
        }
        return $data;
    }

    public function tripinfo($data){
        $result = array();
        $carrier_details = array('suppier_role'=>"",'suppier_id'=>"",'suppier_name'=>"",'suppier_steeet_house'=>"",'suppier_postalcode'=>"",'suppier_country'=>"",'suppier_phone'=>"",'suppier_email'=>"");
        $result = array('carrier_details'=>$carrier_details,'vehicle_type'=>'','trailer_no'=>'','register_number'=>'','driver_name'=>'','driver_licence_number'=>'','driver_contact_num'=>'');
        $shift_id = $data['shift_id'];
        $trip_id = $data['trip_id'];
        if($shift_id > 0){
            $getshiftinfo = $this->common->gettblrowdata(array('id'=>$shift_id),"vendor_id,vehicle_type,carrier_instructions","tb_shifts",0,0);
            if(!empty($getshiftinfo)){
                $vendor_id = $getshiftinfo['vendor_id'];
                $result['vehicle_type']  = $getshiftinfo['vehicle_type'];
                if($vendor_id > 0){
                    $getcarrierinfo = $this->common->gettblrowdata(array('id'=>$vendor_id,'status' =>1),"name,mobile,location,address,pincode,country,email,code","tb_vendors",0,0);
                    if(!empty($getcarrierinfo)){
                        $result['carrier_details'] = array('suppier_role'=>"Supplier Role",'suppier_id'=>$getcarrierinfo['code'],'suppier_name'=>$getcarrierinfo['name'],'suppier_steeet_house'=>$getcarrierinfo['address'],'suppier_postalcode'=>$getcarrierinfo['pincode'],'suppier_country'=>$getcarrierinfo['country'],'suppier_phone'=>$getcarrierinfo['mobile'],'suppier_email'=>$getcarrierinfo['email']);
                    }
                }
            }
            $getvehicleinfo =  $this->truckwaybillmodel->vehicelinfo($shift_id);
            if(!empty($getvehicleinfo)){
                $result['trailer_no']  = $getvehicleinfo['truck_number'];
                $result['register_number']  = $getvehicleinfo['register_number'];
            }
            if($trip_id > 0){
                $getdriverinfo = $this->truckwaybillmodel->driverinfo($trip_id);
                if($getdriverinfo->num_rows()>0){
                    $result['driver_name']  = $getdriverinfo->row()->name;
                    $result['driver_contact_num']  = $getdriverinfo->row()->contact_num;
                    $result['driver_licence_number'] = $getdriverinfo->row()->driving_licence_num;
                }
            }
        }
        return $result;
    }

    public function getpayerdetails($customer_code){
        $company_code = $this->session->userdata('company_code');
        $payer_details = array('id'=>"",'name'=>"",'phone'=>"",'email'=>"",'code'=>"",'acon'=>"",'kn_login'=>"",'vat_reg_no'=>"",'tax_payer_no'=>"",'payer_postal'=>"",'payer_steeet_house'=>"",'payer_country'=>"");
        $select = "id,name,mobile,email,code,customeridentifier,country,street,pincode,house_number,acon_debitor_code,kn_login_account,vat_reg_no,tax_payer_no";
        $getpayer = $this->common->gettblrowdata(array("code"=>$customer_code,"company_code"=>$company_code,"status"=>1),$select,"tbl_party_master",0,0);
        if(!empty($getpayer)){
            $payer_details = ['id'=>$getpayer['customeridentifier'],'name'=>$getpayer['name'],'phone'=>$getpayer['mobile'],'email'=>$getpayer['email'],'code'=>$getpayer['code'],'payer_country'=>$getpayer['country'],'acon'=>$getpayer['acon_debitor_code'],'kn_login'=>$getpayer['kn_login_account'],'vat_reg_no'=>$getpayer['vat_reg_no'],'tax_payer_no'=>$getpayer['tax_payer_no'],'payer_postal'=>$getpayer['pincode'],'payer_steeet_house'=>$getpayer['street']." ".$getpayer['house_number']];
        }
        return $payer_details;
    }

    public function getcharges($order_id,$type){
        $charges = array('chargecode'=>'','chargecodename'=>'','quantity'=>'','value'=>'','rate_id'=>'','amount'=>'','currency'=>'','vat_percentage'=>'','vat_amount'=>'');
        $currency = '';
        $chargecode = $chargecodename = $quantity = $value=$rate_id =
        $amount = $vat_percentage = $vat_amount= array();
        $getcharges =$this->allroundbigreportmodel->getchargesbyordid($order_id,$type);
        $amt = $vatamt = $tot_amt = 0;
        if(!empty($getcharges)){
            foreach ($getcharges as $getcharge) {
                $chargecode[] = $getcharge['chargecode'];
                $chargecodename[] = $getcharge['chargecodename'];
                $quantity[] = $getcharge['quantity_unit'];
                $value[] = $getcharge['value'];
                $rate_id[] = $getcharge['rate_id'];
                $amount[] = $getcharge['amount'];
                $currency = $getcharge['currency'];
                $vat_percentage[] = $getcharge['vat_percentage'];
                $vat_amount[] = $getcharge['vat_amount'];
                $amt += $getcharge['amount'];
                $vatamt  += $getcharge['vat_amount'];
            }
        $tot_amt = $amt+$vatamt;
        $charges = array('chargecode'=>implode(',',$chargecode),'chargecodename'=>implode(',',$chargecodename),'quantity'=>implode(',',$quantity),'value'=>implode(',',$value),'rate_id'=>implode(',',$rate_id),'amount'=>$amt,'currency'=>$currency,'vat_percentage'=>implode(',',$vat_percentage),'vat_amount'=>$vatamt);
        }
        return $charges;
    }

    public function buildGenericArray($inputArray){
        $finalArray= [];

        if(!empty($inputArray) && sizeof($inputArray)>0){
            foreach($inputArray as $eachInput){
                $getArray=$this->formatGenericParameters($eachInput);

                if(!empty($getArray) && sizeof($getArray)>0){
                    $x=0;
                    foreach($getArray as $inner){
                            foreach($inner as $key=>$value){
                                $finalArray[$x][$key]=$value;
                                $x++;
                            }
                    }
                }
            }
        }

        return $finalArray;
    }

    public function formatReferenceParameters($refData)
    {
        $finalReqArray = array();
        $referenceDataArray = explode('?????', $refData);
        if (! empty($referenceDataArray) && sizeof($referenceDataArray) > 0) {
            foreach ($referenceDataArray as $eachRefData) {
                $reqArray = $this->giveReferenceParameters($eachRefData);
                $key = $reqArray['type'];
                $value = $reqArray['value'];
                $finalReqArray[$key] = $value;
            }
        }
        return $finalReqArray;
    }

    public function giveReferenceParameters($referenceParam)
    {
        $finalArray = array();
        if (! empty($referenceParam) && $referenceParam != '') {
            $requiredArray = explode('=====', $referenceParam);
            if (! empty($requiredArray) && sizeof($requiredArray) > 0) {
                $finalArray['type'] = trim($requiredArray[0]);
                $finalArray['value'] = trim($requiredArray[1]);
            }
        }
        return $finalArray;
    }

    public function formatGenericParameters($genericData,$type=''){
        $finalReqArray = array();
        $genericDataArray = explode('?????', $genericData);
        if (! empty($genericDataArray) && sizeof($genericDataArray) > 0) {
            foreach ($genericDataArray as $eachRow) {
                $reqArray = $this->getGenericParameters($eachRow,$type);
                array_push($finalReqArray,$reqArray);

            }
        }
        return $finalReqArray;
    }

    public function getGenericParameters($genericParam,$type=''){
        $finalArray= [];

        if($type=='VAS'){
        }else if($type=='PARTY'){
            $finalArray = [
                'id' => '','party_type_id' => '','name' => '','mobile' => '','email' => '','code' => '',
            'customeridentifier' => '','house_number' => '','fax' => '','acon_debitor_code' => '','kn_login_account' => '',
            'vat_reg_no' => '','tax_payer_no' => '', 'contract_no' => '','contract_date' => '','party_type' => '', 'party_type_name'=>''
            ];
        }else if($type=='COST'){
            $finalArray = ['chargecode'=>'','chargecodename'=>'','quantity'=>'','value'=>'','rate_id'=>'','amount'=>0,'currency'=>'','vat_percentage'=>'','vat_amount'=>''];
        }else if($type=='REVENUE'){
            $finalArray = ['type'=>'','foreign_currency'=>'','debtor_jfr'=>'','bu_jfr'=>'','exchange_rate'=>'','invoice_number'=>'','invoice_date'=>'','credit_note_number'=>'','invoice_creation_date'=>'','invoice_receivdon_date'=>'','invoice_status'=>''];
        }else if($type=='REFERENCE'){
            $finalArray = ['reference_id'=>'','description'=>'','ref_value'=>''];
        }

        if (!empty($genericParam) && $genericParam != '') {
            $requiredArray = explode('+++++', $genericParam);
            if (! empty($requiredArray) && sizeof($requiredArray) > 0) {
                foreach($requiredArray as $eachItem){
                    $eachArray = explode('=====', $eachItem);
                    if(!empty($eachArray) && sizeof($eachArray)>0){
                        $key=$value=0;
                        if(isset($eachArray[0])){
                            $key=$eachArray[0];
                        }
                        if(isset($eachArray[1])){
                            $value=$eachArray[1];
                        }
                        $finalArray[$key]=$value;
                    }
                }
            }
        }
        return $finalArray;
    }

    public function ajaxListing(){
        $recordListing = [];

        $wherecondition='';
        $draw  = $this->input->post('draw',true);
        $start = $this->input->post('start',true);
        $limit =  $this->input->post('length',true); // get promo code Id
        $orderBy   =  $this->input->post('order',true);
        $post              = $this->input->post('data',true);
        $userid = $this->session->userdata("user_id");
        $custid = $this->session->userdata("cust_id");
        $dataTableSortOrdering=array();

        $dataTableSortOrdering[0]='tor.id';
        $dataTableSortOrdering[1]='tor.order_id';
        $dataTableSortOrdering[2]='tor.order_id';
        $dataTableSortOrdering[3]='tor.purchase_order';
        $dataTableSortOrdering[4]='tor.createdon';
        $dataTableSortOrdering[5]='tor.pickup_datetime';
        $dataTableSortOrdering[6]='tor.delivery_datetime';
        $dataTableSortOrdering[7]='';
        $dataTableSortOrdering[8]='';
        $dataTableSortOrdering[9]='';
        $dataTableSortOrdering[10]='';
        $dataTableSortOrdering[11]='';
        $dataTableSortOrdering[12]='';
        $dataTableSortOrdering[13]='';
        $dataTableSortOrdering[14]='';
        $dataTableSortOrdering[15]='';
        $dataTableSortOrdering[16]='';
        $dataTableSortOrdering[17]='';
        $dataTableSortOrdering[18]='';
        $dataTableSortOrdering[19]='';

        $dataTableSortOrdering[20]='';
        $dataTableSortOrdering[21]='';
        $dataTableSortOrdering[22]='';
        $dataTableSortOrdering[23]='';
        $dataTableSortOrdering[24]='';
        $dataTableSortOrdering[25]='';
        $dataTableSortOrdering[26]='';
        $dataTableSortOrdering[27]='';
        $dataTableSortOrdering[28]='';
        $dataTableSortOrdering[29]='';
        $dataTableSortOrdering[30]='';
        $dataTableSortOrdering[31]='';
        $dataTableSortOrdering[32]='';
        $dataTableSortOrdering[33]='tcd.cust_customeridentifier';
        $dataTableSortOrdering[34]='tcd.cust_code';
        $dataTableSortOrdering[35]='tcd.cust_acon_debitor_code';
        $dataTableSortOrdering[36]='tcd.cust_kn_login_account';
        $dataTableSortOrdering[37]='tcd.cust_kn_login_account';
        $dataTableSortOrdering[38]='tcd.tax_payer_no';
        $dataTableSortOrdering[39]='tcd.cust_name';

        $dataTableSortOrdering[40]='tcd.street';
        $dataTableSortOrdering[41]='tcd.cust_pincode';
        $dataTableSortOrdering[42]='tcd.cust_country';
        $dataTableSortOrdering[43]='tcd.cust_mobile';
        $dataTableSortOrdering[44]='tcd.cust_email';
        $dataTableSortOrdering[45]='cust_country';
        $dataTableSortOrdering[46]='tor.branch_code';
        $dataTableSortOrdering[47]='tor.department_code';
        $dataTableSortOrdering[48]='tor.product';
        $dataTableSortOrdering[49]='';
        $dataTableSortOrdering[50]='tor.incoterm';
        $dataTableSortOrdering[51]='';
        $dataTableSortOrdering[52]='';
        $dataTableSortOrdering[53]='';
        $dataTableSortOrdering[54]='';
        $dataTableSortOrdering[55]='tor.transport_mode';
        $dataTableSortOrdering[56]='tor.purchase_order';
        $dataTableSortOrdering[57]='c.cargo_total_quantity';
        $dataTableSortOrdering[58]='c.cargo_total_package_type';
        $dataTableSortOrdering[59]='c.cargo_total_length';

        $dataTableSortOrdering[60]='c.cargo_total_length_unit';
        $dataTableSortOrdering[61]='c.cargo_total_width';
        $dataTableSortOrdering[62]='c.cargo_total_width_unit';
        $dataTableSortOrdering[63]='c.cargo_total_height';
        $dataTableSortOrdering[64]='c.cargo_total_height_unit';
        $dataTableSortOrdering[65]='c.cargo_total_second_weight';
        $dataTableSortOrdering[66]='c.cargo_total_weight_unit';
        $dataTableSortOrdering[67]='c.cargo_total_second_volume';
        $dataTableSortOrdering[68]='c.cargo_total_volume_unit';
        $dataTableSortOrdering[69]='c.cargo_total_ldm';
        $dataTableSortOrdering[70]='c.cargo_total_volumetric_weight';
        $dataTableSortOrdering[71]='c.cargo_total_volweight_uom';
        $dataTableSortOrdering[72]='c.cargo_total_stackable';
        $dataTableSortOrdering[73]='c.cargo_total_dg_goods';
        $dataTableSortOrdering[74]='c.carg_total_weight';
        $dataTableSortOrdering[75]='c.cargo_total_weight_unit';
        $dataTableSortOrdering[76]='c.cargo_total_volume';
        $dataTableSortOrdering[77]='c.cargo_total_volume_unit';
        $dataTableSortOrdering[78]='';
        $dataTableSortOrdering[79]='';

        $dataTableSortOrdering[80]='';
        $dataTableSortOrdering[81]='';
        $dataTableSortOrdering[82]='';
        $dataTableSortOrdering[83]='';
        $dataTableSortOrdering[84]='';
        $dataTableSortOrdering[85]='';
        $dataTableSortOrdering[86]='';
        $dataTableSortOrdering[87]='';
        $dataTableSortOrdering[88]='';
        $dataTableSortOrdering[89]='';
        $dataTableSortOrdering[90]='';
        $dataTableSortOrdering[91]='';
        $dataTableSortOrdering[92]='';
        $dataTableSortOrdering[93]='';
        $dataTableSortOrdering[94]='';
        $dataTableSortOrdering[95]='';
        $dataTableSortOrdering[96]='';
        $dataTableSortOrdering[97]='';
        $dataTableSortOrdering[98]='';
        $dataTableSortOrdering[99]='';

        $dataTableSortOrdering[100]='';
        $dataTableSortOrdering[101]='';
        $dataTableSortOrdering[102]='';
        $dataTableSortOrdering[103]='';
        $dataTableSortOrdering[104]='';
        $dataTableSortOrdering[105]='';
        $dataTableSortOrdering[106]='';
        $dataTableSortOrdering[107]='';
        $dataTableSortOrdering[108]='';
        $dataTableSortOrdering[109]='';
        $dataTableSortOrdering[110]='';
        $dataTableSortOrdering[111]='';
        $dataTableSortOrdering[112]='tinfo.trailer_no';
        $dataTableSortOrdering[113]='tinfo.vehicle_type';
        $dataTableSortOrdering[114]='tinfo.driver_name';
        $dataTableSortOrdering[115]='tinfo.driver_licence_number';
        $dataTableSortOrdering[118]='tparty.id';
        $dataTableSortOrdering[119]='tparty.name';

        $dataTableSortOrdering[120]='tparty.code';
        $dataTableSortOrdering[121]='tparty.acon_debitor_code';
        $dataTableSortOrdering[121]='tparty.kn_login_account';
        $dataTableSortOrdering[123]='tparty.vat_reg_no';
        $dataTableSortOrdering[124]='tparty.tax_payer_no';
        $dataTableSortOrdering[125]='tparty.street';
        $dataTableSortOrdering[126]='tparty.pincode';
        $dataTableSortOrdering[127]='tparty.country';
        $dataTableSortOrdering[128]='tparty.mobile';
        $dataTableSortOrdering[129]='tparty.email';
        $dataTableSortOrdering[130]='';
        $dataTableSortOrdering[131]='';
        $dataTableSortOrdering[132]='';
        $dataTableSortOrdering[133]='';
        $dataTableSortOrdering[134]='';
        $dataTableSortOrdering[135]='';
        $dataTableSortOrdering[136]='';
        $dataTableSortOrdering[137]='';
        $dataTableSortOrdering[138]='';
        $dataTableSortOrdering[139]='';

        $dataTableSortOrdering[140]='';
        $dataTableSortOrdering[141]='';
        $dataTableSortOrdering[142]='';
        $dataTableSortOrdering[143]='';
        $dataTableSortOrdering[144]='';
        $dataTableSortOrdering[145]='';
        $dataTableSortOrdering[146]='';
        $dataTableSortOrdering[147]='';
        $dataTableSortOrdering[148]='';
        $dataTableSortOrdering[149]='';
        $dataTableSortOrdering[150]='';
        $dataTableSortOrdering[151]='';
        $dataTableSortOrdering[152]='';
        $dataTableSortOrdering[153]='';
        $dataTableSortOrdering[154]='tinfo.supplier_id';
        $dataTableSortOrdering[155]='tinfo.suppier_name';
        $dataTableSortOrdering[156]='tinfo.suppier_steeet_house';
        $dataTableSortOrdering[157]='tinfo.suppier_postalcode';
        $dataTableSortOrdering[158]='tinfo.suppier_country';
        $dataTableSortOrdering[159]='tinfo.suppier_phone';

        $dataTableSortOrdering[160]='tinfo.suppier_email';
        $dataTableSortOrdering[161]='';
        $dataTableSortOrdering[162]='';
        $dataTableSortOrdering[163]='';
        $dataTableSortOrdering[164]='';
        $dataTableSortOrdering[165]='';
        $dataTableSortOrdering[166]='';
        $dataTableSortOrdering[167]='';
        $dataTableSortOrdering[168]='';
        $dataTableSortOrdering[169]='';
        $dataTableSortOrdering[170]='';
        $dataTableSortOrdering[171]='';
        $dataTableSortOrdering[172]='';
        $dataTableSortOrdering[173]='';

        $orderByCondition='';
        if(isset($orderBy[0]));{
            if($orderBy[0]!=''){
                $ordColIndex= $orderBy[0]['column'];
                $ordColDir= $orderBy[0]['dir'];
                if($ordColDir==''){
                    $ordColDir = 'asc';
                }
                if(isset($dataTableSortOrdering[$ordColIndex]) && $dataTableSortOrdering[$ordColIndex]!='' ){
                    $orderByCondition='  '.$dataTableSortOrdering[$ordColIndex].' '.$ordColDir.' ';
                }
            }
        }

        $whr=$this->searchsubmitdata($post);

        $order_status = isset($post['status']) ? $post['status'] :"";
            $ad_orderstatus = isset($post['order_status']) ? $post['order_status'] :"";
            $status_search = $order_status;
            if($status_search == ""){
               $status_search = $ad_orderstatus;
            }
            $company_code = $this->session->userdata('company_code');
            $branch_code = $this->session->userdata('branch_code');
            $subcusts = array();
            $role_id = $this->session->userdata('user_role_id');
            if($role_id == "4"){
                if($this->session->userdata('sub_cust')){
                    $subcusts = $this->session->userdata('sub_cust');
                    if(!empty($subcusts)){
                      array_push($subcusts, $custid);
                    }
                }
            }
            $searchids = array();
            if (isset($post['bookingid']) && $post['bookingid'] != "") {
                $searchids = isset($post['bookingid']) ? $post['bookingid'] : array();
            }

            $whereArray=array();
            if(!empty($whr) && sizeof($whr)>0){
                foreach($whr as $key=>$value){
                    $value="'$value'";
                    if($key=="DATE_FORMAT(o.createdon,'%Y-%m-%d') >=" || $key=="DATE_FORMAT(o.createdon,'%Y-%m-%d') <=" || $key=="DATE_FORMAT(o.pickup_datetime,'%Y-%m-%d') >=" || $key=="DATE_FORMAT(o.pickup_datetime,'%Y-%m-%d') <="){
                        $whereArray[]= $key.$value;
                    }else{
                        $whereArray[]= $key.' = '.$value;
                    }
                }
            }

            if(!empty($whereArray) && sizeof($whereArray)>0){
                $wherecondition.= 'AND '.implode(' AND ', $whereArray);
            }

            if(!empty($searchids)){
                $tempSearchId='';
                if(!empty($searchids) && sizeof($searchids)>0){
                    foreach($searchids as $eachSearchKey){
                        $tempSearchId .= "$eachSearchKey,";
                    }
                }
                $tempSearchId= trim($tempSearchId,',');
                //$tempSearchId=implode(',',$searchids);

                if($tempSearchId!=''){
                    $wherecondition.=  " and o.order_id in ($tempSearchId) ";
                }
            }

        if($userid != '0'){
            if(!empty($countryuids)){
                $tempCountryId=implode(',',$countryuids);
                $wherecondition.=  " and o.user_id in ($tempCountryId) ";
            }else{
                $wherecondition.=  "  and o.user_id = '$userid' ";
            }
        }

        $searchsts=$status_search;

        if($searchsts == 'PENDING'){
            $wherecondition.=  " and o.trip_id = 0 ";
        }

        if($searchsts == 'ACTIVE'){
            $wherecondition.=  " and o.trip_id != 0  and  o.trip_sts=0 ";
        }

        if($searchsts == 'CLOSED'){
            $wherecondition.=  " and o.trip_id != 0  and  o.trip_sts = 1 ";
        }

        if(!empty($subcusts)){
            $tempSubCusts=implode(',',$subcusts);
            if($tempSubCusts!=''){
                $wherecondition.=  " and o.customer_id in ($tempSubCusts) ";
            }
        } else {
            if($custid != ""){
                $wherecondition.=  " and o.customer_id = ".$this->db->escape($custid)." ";
            }
        }

        $countQuery="select count(o.id) as count from tb_orders o
        left join tb_order_details d on d.order_row_id=o.id
        where o.status!=0  $wherecondition ";
        $countQueryResult=$this->db->query($countQuery);

        $rowCount=$countQueryResult->result();
        $totalRecords=$rowCount[0]->count;
        $wherecondition='"'.$wherecondition.'"';
        $company_code= '"'.$company_code.'"';
        $orderByCondition='"'.$orderByCondition.'"';

        $dataQuery = array($start, $limit, $wherecondition, $orderByCondition, $company_code);
        $query = "CALL `allRoundBigReport`(?, ?, ?, ?, ?);";
        $data = $this->db->query($query, $dataQuery);
        $getRecordListing=$data->result();

        $recordsFiltered=$totalRecords;
        $i                = 0;

            foreach ( $getRecordListing as $res ) {
                $delivery_note = $purchase_order = "";
                $trip_no = $res->shipmentid;

                if($trip_no == '0'){
                    $trip_no = "";
                }

                $early_pickup = $res->pickup_datetime;
                $early_delivery = $res->delivery_datetime;
                $curtz = $this->session->userdata("usr_tzone")['timezone'];

                if($early_pickup != "" && $early_pickup != "0000-00-00 00:00:00"){
                    $epickup = getdatetimebytimezone($curtz,$early_pickup,DFLT_TZ);
                    $early_pickup = $epickup['datetime'];
                }

                if($early_delivery != "" && $early_delivery != "0000-00-00 00:00:00"){
                    $edelivery = getdatetimebytimezone($curtz,$early_delivery,DFLT_TZ);
                    $early_delivery = $edelivery['datetime'];
                }

                //pickupaddress and delivery address
                $pickup_company = (!empty($res->pickup_company)) ? $res->pickup_company.' , ' :  "" ;
                $delivery_company = (!empty($res->delivery_company)) ? $res->delivery_company.' , ' :  "" ;
                $pickup_address1 = (!empty($res->pickup_address1)) ? $res->pickup_address1.' , ' :  "" ;
                $pickup_address2 = (!empty($res->pickup_address2)) ? $res->pickup_address2.' , ' :  "" ;
                $pickup_city = (!empty($res->pickup_city)) ? $res->pickup_city.' , ' :  "" ;
                $pickup_country = (!empty($res->pickup_country)) ? $res->pickup_country.' , ' :  "" ;
                $pickup_pincode = (!empty($res->pickup_pincode)) ? $res->pickup_pincode.' , ' :  "" ;
                $delivery_address1 = (!empty($res->delivery_address1)) ? $res->delivery_address1.' , ' :  "" ;
                $delivery_address2 = (!empty($res->delivery_address2)) ? $res->delivery_address2.' , ' :  "" ;
                $delivery_city = (!empty($res->delivery_city)) ? $res->delivery_city.' , ' :  "" ;
                $delivery_country = (!empty($res->delivery_country)) ? $res->delivery_country.' , ' :  "" ;
                $delivery_pincode = (!empty($res->delivery_pincode)) ? $res->delivery_pincode.' , ' :  "" ;
                $pickup_address = $pickup_company.$pickup_address1.$pickup_city.$pickup_address2.$pickup_country.$pickup_pincode;
                $delivery_address = $delivery_company.$delivery_address1.$delivery_city.$delivery_address2.$delivery_country.$delivery_pincode;
                $pickup_address = ltrim($pickup_address,' , ');
                $delivery_address = ltrim($delivery_address,' , ');

                if($res->partydetails_id!=''){
                    $PartyArray=array( $res->partydetails_id,
                    $res->partydetails_party_type_id,
                    $res->partydetails_name,
                    $res->partydetails_mobile,
                    $res->partydetails_email,
                    $res->partydetails_code,
                    $res->partydetails_customeridentifier,
                    $res->partydetails_house_number,
                    $res->partydetails_fax,
                    $res->partydetails_acon_debitor_code,
                    $res->partydetails_kn_login_account,
                    $res->partydetails_vat_reg_no,
                    $res->partydetails_tax_payer_no,
                    $res->partydetails_contract_no,
                    $res->partydetails_contract_date,
                    $res->partydetails_party_type,
                    $res->partydetails_party_type_name
                    );

                    $getpartydetails=$this->buildGenericArray($PartyArray);
                }

                $customer_details = $payer_details = $drop_details = $shipper_details = array('id'=>"",'name'=>"",'phone'=>"",'email'=>"",'fax'=>"",'code'=>"",'street'=>"",'state'=>"",'city'=>"",'country'=>"",'pincode'=>"",'acon'=>"",'kn_login'=>"",'vat_reg_no'=>"",'tax_payer_no'=>"",'contract_no'=>"",'contract_date'=>"");
                    $notify_address['name'] ="Notify Party";
                    if(!empty($getpartydetails)){
                        foreach($getpartydetails as $rr){
                            if(!isset($rr['customeridentifier'])){
                                $rr['customeridentifier']='';
                            }
                            if(!isset($rr['name'])){
                                $rr['name']='';
                            }
                            if(!isset($rr['mobile'])){
                                $rr['mobile']='';
                            }
                            if(!isset($rr['email'])){
                                $rr['email']='';
                            }
                            if(!isset($rr['fax'])){
                                $rr['fax']='';
                            }
                            if(!isset($rr['code'])){
                                $rr['code']='';
                            }
                            if(!isset($rr['acon_debitor_code'])){
                                $rr['acon_debitor_code']='';
                            }
                            if(!isset($rr['kn_login_account'])){
                                $rr['kn_login_account']='';
                            }
                            if(!isset($rr['vat_reg_no'])){
                                $rr['vat_reg_no']='';
                            }
                            if(!isset($rr['house_number'])){
                                $rr['house_number']='';
                            }
                            if(!isset($rr['contract_no'])){
                                $rr['contract_no']='';
                            }
                            if(!isset($rr['contract_date'])){
                                $rr['contract_date']='';
                            }
                            if(!isset($rr['tax_payer_no'])){
                                $rr['tax_payer_no']='';
                            }
                            if(!isset($rr['party_type_id'])){
                                $rr['party_type_id']='';
                            }
                            $ptype = $rr['party_type_id'];
                            if($rr['party_type_name']!=''){
                                    if($rr['party_type_name'] == "Consignee"){
                                        $drop_details = array('id'=>$rr['customeridentifier'],'name'=>$rr['name'],'phone'=>$rr['mobile'],'email'=>$rr['email'],'fax'=>$rr['fax'],'code'=>$rr['code'],'acon'=>$rr['acon_debitor_code'],'kn_login'=>$rr['kn_login_account'],'vat_reg_no'=>$rr['vat_reg_no'],'tax_payer_no'=>$rr['tax_payer_no'],'contract_no'=>$rr['contract_no'],'contract_date'=>$rr['contract_date'],'house_number'=>$rr['house_number']);
                                    }if($rr['party_type_name'] == "Shipper"){
                                        $shipper_details = array('id'=>$rr['customeridentifier'],'name'=>$rr['name'],'phone'=>$rr['mobile'],'email'=>$rr['email'],'fax'=>$rr['fax'],'code'=>$rr['code'],'acon'=>$rr['acon_debitor_code'],'kn_login'=>$rr['kn_login_account'],'vat_reg_no'=>$rr['vat_reg_no'],'tax_payer_no'=>$rr['tax_payer_no'],'contract_no'=>$rr['contract_no'],'contract_date'=>$rr['contract_date'],'house_number'=>$rr['house_number']);
                                    }
                            }
                            if($rr['party_type_name']=='NOTIFY_PARTY'){
                                $notify_address['name'] =$rr['name'];
                            }
                        }
                    }



                    /*Shipper ACON Debitor Code Shipper KN Login Account    Shipper VAT Registration Number Shipper Tax Payer ID*/
                    #########################################
                    if(isset($res->pickup)){
                        $shipper_details['name'] = $res->pickup;
                    }
                    ###########################################
                    $shipper_details['street'] = $res->pickup_address1;
                    if(isset($shipper_details['house_number'])){
                        if($shipper_details['house_number'] != ""){
                          $shipper_details['street'] .= $shipper_details['house_number'];
                        }
                     }
                    $shipper_details['state'] = $res->pickup_address2;
                    $shipper_details['city'] = $res->pickup_city;
                    $shipper_details['country'] = $res->pickup_country;
                    $shipper_details['pincode'] = $res->pickup_pincode;
                    ##########################################
                    if(isset($res->delivery)){
                        $drop_details['name'] = $res->delivery;
                    }
                    #############################################
                    $drop_details['street'] = $res->delivery_address1;
                    if(isset($drop_details['house_number'])){
                        if($drop_details['house_number'] != ""){
                          $drop_details['street'] .= $drop_details['house_number'];
                        }
                     }
                    $drop_details['state'] = $res->delivery_address2;
                    $drop_details['city'] = $res->delivery_city;
                    $drop_details['country'] = $res->delivery_country;
                    $drop_details['pincode'] = $res->delivery_pincode;

                    if($res->customer_id>0){
                        if($res->cust_contract_date == "0000-00-00"){
                            $res->cust_contract_date = "";
                        }
                        $street = $res->cust_street;
                        if($res->cust_house_number !=""){
                            $street .= $res->cust_house_number;
                        }
                        $customer_details = [
                            'id'=>$res->cust_customeridentifier,
                            'name'=>$res->cust_name,
                            'phone'=>$res->cust_mobile,
                            'email'=>$res->cust_email,
                            'fax'=>$res->cust_fax,
                            'code'=>$res->cust_code,
                            'street'=>$street,
                            'state'=>$res->cust_state,
                            'city'=>$res->cust_location_id,
                            'country'=>$res->cust_country,
                            'pincode'=>$res->cust_pincode,
                            'acon'=>$res->cust_acon_debitor_code,
                            'kn_login'=>$res->cust_kn_login_account,
                            'vat_reg_no'=>$res->cust_vat_reg_no,
                            'tax_payer_no'=>$res->cust_tax_payer_no,
                            'contract_no'=>$res->cust_contract_no,
                            'contract_date'=>$res->cust_contract_date
                        ];
                    }

                    if($res->reference_value!=''){
                        $arrayData= $this->formatGenericParameters($res->reference_value,'REFERENCE');
                    }

                    $ref_1_name = $ref_1_description= $ref_1_value = $ref_2_name = $ref_2_description= $ref_2_value = $ref_3_name = $ref_3_description=$ref_3_value = $ref_4_name = $ref_4_description= $ref_4_value = $ref_5_name = $ref_5_description= $ref_5_value = $ruck_val =$rucksn_val ="";
                    if(!empty($arrayData)){
                        $ctr =1;
                        $ref_id='';
                        foreach($arrayData as $ref){
                            if(isset($ref['reference_id'])){
                                $ref_id = $ref['reference_id'];
                            }
                            if(!in_array($ref_id, array('ORD_DLVINST','ORD_PIKINST','RUCK','RUCKSN','DQ','PO'))){
                                if($ctr ==1){
                                    $ref_1_name = $ref_id;
                                    if(isset($ref['description'])){
                                        $ref_1_description = $ref['description'];
                                    }
                                    if(isset($ref['ref_value'])){
                                        $ref_1_value = $ref['ref_value'];
                                    }
                                }else if($ctr ==2){
                                    $ref_2_name = $ref_id;
                                    if(isset($ref['description'])){
                                        $ref_2_description = $ref['description'];
                                    }
                                    if(isset($ref['ref_value'])){
                                        $ref_2_value = $ref['ref_value'];
                                    }

                                }else if($ctr ==3){
                                    $ref_3_name = $ref_id;
                                    if(isset($ref['description'])){
                                        $ref_3_description = $ref['description'];
                                    }
                                    if(isset($ref['ref_value'])){
                                        $ref_3_value = $ref['ref_value'];
                                    }

                                }else if($ctr ==4){
                                    $ref_4_name = $ref_id;
                                    if(isset($ref['description'])){
                                        $ref_4_description = $ref['description'];
                                    }
                                    if(isset($ref['ref_value'])){
                                        $ref_4_value = $ref['ref_value'];
                                    }

                                }else if($ctr ==5){
                                    $ref_5_name = $ref_id;
                                    if(isset($ref['description'])){
                                        $ref_5_description = $ref['description'];
                                    }
                                    if(isset($ref['ref_value'])){
                                        $ref_5_value = $ref['ref_value'];
                                    }
                                }
                                $ctr++;
                            }
                            if($ref_id == 'DQ'){
                                if(isset($ref['ref_value'])){
                                    $delivery_note = $ref['ref_value'];
                                }
                            }
                            if($ref_id == 'PO'){
                                if(isset($ref['ref_value'])){
                                    $purchase_order = $ref['ref_value'];
                                }
                            }
                            if($ref_id == 'ORD_DLVINST'){
                                if(isset($ref['ref_value'])){
                                    $delivery_inst = $ref['ref_value'];
                                }
                            }
                            if($ref_id == 'ORD_PIKINST'){
                                if(isset($ref['ref_value'])){
                                    $pickup_inst = $ref['ref_value'];
                                }
                            }
                            if($ref_id == 'ORD_PIKINST'){
                                if(isset($ref['ref_value'])){
                                    $pickup_inst = $ref['ref_value'];
                                }
                            }
                            if($ref_id == 'RUCK'){
                                if(isset($ref['ref_value'])){
                                    $ruck_val = $ref['ref_value'];
                                }
                            }
                            if($ref_id == 'RUCKSN'){
                                if(isset($ref['ref_value'])){
                                    $rucksn_val = $ref['ref_value'];
                                }
                            }
                        }
                    }

                    $getstatusdates = array('statuspickupdate'=>"",'statusdeliverydate'=>"");
                    if($res->status_details!=''){
                        $statusArrayData= $this->formatGenericParameters($res->status_details);
                        $zonecode = $this->session->userdata("usr_tzone");
                        $curtz = $zonecode['timezone'];

                        if(!empty($statusArrayData)){
                            foreach ($statusArrayData as $eachRow) {
                                if($eachRow['stop_type'] == "P"){
                                    if($eachRow['createdon'] != ""){
                                        $getactualStatus = getdatetimebytimezone($curtz,$eachRow['createdon'],DFLT_TZ);
                                        if(isset($getactualStatus['datetime'])){
                                            $getstatusdates['statuspickupdate'] = $getactualStatus['datetime'];
                                        }
                                    }
                                }
                                if($eachRow['stop_type'] == "D"){
                                    if($eachRow['createdon'] != ""){
                                        $getactualStatus = getdatetimebytimezone($curtz,$eachRow['createdon'],DFLT_TZ);
                                        if(isset($getactualStatus['datetime'])){
                                            $getstatusdates['statusdeliverydate'] = $getactualStatus['datetime'];
                                        }
                                    }
                                }
                            }
                        }
                    }

                    $docs_received_datetime = $res->docs_received_datetime;
                    if($docs_received_datetime != "" && $docs_received_datetime != null){
                        $getactual = getdatetimebytimezone($curtz,$docs_received_datetime,DFLT_TZ);
                        if(isset($getactual['datetime'])){
                            $docs_received_datetime = $getactual['datetime'];
                        }

                    }
                    $docs_sent_datetime = $res->docs_sent_datetime;
                    if($docs_sent_datetime != "" && $docs_sent_datetime != null){
                        $getactual = getdatetimebytimezone($curtz,$docs_sent_datetime,DFLT_TZ);
                        $docs_sent_datetime = $getactual['datetime'];
                    }

                    $vehicle_type = $res->vehicle_type;
                    $trailer_no = $res->trailer_no;
                    $register_number = $res->register_number;

                    $driver_name = $driver_licence_number = '';
                    if($res->trip_id > 0){
                        $driver_name = $res->driver_name;
                        $driver_licence_number = $res->driver_licence_number;
                    }

                    $getcostcharge = ['chargecode'=>'','chargecodename'=>'','quantity'=>'','value'=>'','rate_id'=>'','amount'=>'','currency'=>'','vat_percentage'=>'','vat_amount'=>''];
                    $amt = $vatamt= $cost_amt = $cost_vatamt = 0;
                    $currency = $cost_currency= '';
                    $chargecode = $chargecodename = $quantity = $value = $rate_id = $amount = $vat_percentage = $vat_amount = [];
                    $cost_chargecode = $cost_chargecodename = $cost_quantity = $cost_value = $cost_rate_id =$cost_amount = $cost_vat_percentage = $cost_vat_amount = [];

                    if($res->chargedetails_type!=''){
                        $chagDetailsArray= [
                            $res->chargedetails_type,
                            $res->chargedetails_chargecode,
                            $res->chargedetails_chargecodename,
                            $res->chargedetails_quantity_unit,
                            $res->chargedetails_value,
                            $res->chargedetails_rate_id,
                            $res->chargedetails_amount,
                            $res->chargedetails_currency,
                            $res->chargedetails_vat_percentage,
                            $res->chargedetails_vat_amount,
                        ];
                        $getchargeData=$this->buildGenericArray($chagDetailsArray);
                        if(!empty($getchargeData)){
                            foreach ($getchargeData as $getcharge) {
                                if(!isset($getcharge['vat_amount']) || $getcharge['vat_amount']==''){
                                    $getcharge['vat_amount']=0;
                                }
                                if(!isset($getcharge['amount']) || $getcharge['amount']==''){
                                    $getcharge['amount']=0;
                                }
                                if(isset($getcharge['type'])){
                                if($getcharge['type']=='0'){
                                        if(isset($getcharge['charge_code'])){
                                            $chargecode[] = $getcharge['charge_code'];
                                        }
                                        if(isset($getcharge['name'])){
                                            $chargecodename[] = $getcharge['name'];
                                        }
                                        if(isset($getcharge['quantity_unit'])){
                                            $quantity[] = $getcharge['quantity_unit'];
                                        }
                                        if(isset($getcharge['value'])){
                                            $value[] = $getcharge['value'];
                                        }
                                        if(isset($getcharge['rate_id'])){
                                            $rate_id[] = $getcharge['rate_id'];
                                        }
                                        if(isset($getcharge['amount'])){
                                            $amount[] = $getcharge['amount'];
                                        }
                                        if(isset($getcharge['currency'])){
                                            $currency = $getcharge['currency'];
                                        }
                                        if(isset($getcharge['vat_percentage'])){
                                            $vat_percentage[] = $getcharge['vat_percentage'];
                                        }
                                        if(isset($getcharge['vat_amount'])){
                                            $vat_amount[] = $getcharge['vat_amount'];
                                        }
                                        if(isset($getcharge['amount'])){
                                            if(is_numeric($getcharge['amount'])){
                                                $amt += $getcharge['amount'];
                                            }
                                        }
                                        if(isset($getcharge['vat_amount'])){
                                            if(is_numeric($getcharge['vat_amount'])){
                                                $vatamt +=  $getcharge['vat_amount'];
                                            }
                                        }
                                }else if($getcharge['type']=='1'){
                                    if(isset($getcharge['charge_code'])){
                                        $cost_chargecode[] = $getcharge['charge_code'];
                                    }
                                    if(isset($getcharge['name'])){
                                        $cost_chargecodename[] = $getcharge['name'];
                                    }
                                    if(isset($getcharge['quantity_unit'])){
                                        $cost_quantity[] = $getcharge['quantity_unit'];
                                    }
                                    if(isset($getcharge['value'])){
                                        $cost_value[] = $getcharge['value'];
                                    }
                                    if(isset($getcharge['rate_id'])){
                                        $cost_rate_id[] = $getcharge['rate_id'];
                                    }
                                    if(isset($getcharge['amount'])){
                                        $cost_amount[] = $getcharge['amount'];
                                    }
                                    if(isset($getcharge['currency'])){
                                        $cost_currency = $getcharge['currency'];
                                    }
                                    if(isset($getcharge['vat_percentage'])){
                                        $cost_vat_percentage[] = $getcharge['vat_percentage'];
                                    }
                                    if(isset($getcharge['vat_amount'])){
                                        $cost_vat_amount[] = $getcharge['vat_amount'];
                                    }
                                    if(isset($getcharge['amount'])){
                                        if($getcharge['amount']>0){
                                            $cost_amt +=    $getcharge['amount'];
                                        }
                                    }
                                    if(isset($getcharge['vat_amount'])){
                                        if($getcharge['vat_amount']>0){
                                            $cost_vatamt += $getcharge['vat_amount'];
                                        }
                                    }
                                }
                            }

                            }

                            $newgetcharge = array('chargecode'=>implode(',',$chargecode),'chargecodename'=>implode(',',$chargecodename),'quantity'=>implode(',',$quantity),'value'=>implode(',',$value),'rate_id'=>implode(',',$rate_id),'amount'=>$amt,'currency'=>$currency,'vat_percentage'=>implode(',',$vat_percentage),'vat_amount'=>$vatamt);
                            $getcostcharge = array('chargecode'=>implode(',',$cost_chargecode),'chargecodename'=>implode(',',$cost_chargecodename),'quantity'=>implode(',',$cost_quantity),'value'=>implode(',',$cost_value),'rate_id'=>implode(',',$cost_rate_id),'amount'=>$cost_amt,'currency'=>$cost_currency,'vat_percentage'=>implode(',',$cost_vat_percentage),'vat_amount'=>$cost_vatamt);
                        }
                    }

                    $revenueDataArray=array();
                    if($res->revenue_details!=''){
                        $cost= [];
                        $getRevenueData= $this->formatGenericParameters($res->revenue_details,'REVENUE');
                        foreach($getRevenueData as $eachData){
                            if(isset($eachData['type'])){
                                $revDataIndex=$eachData['type'];
                                if($eachData['type']=='0'){
                                    if(!array_key_exists('0',$revenueDataArray)){
                                        $revenueDataArray[$revDataIndex]=$eachData;
                                    }
                                }else if($eachData['type']=='1'){
                                    if(!array_key_exists('1',$revenueDataArray)){
                                        $revenueDataArray[$revDataIndex]=$eachData;
                                    }
                                }
                            }
                        }
                    }

                    $rev_foreign_currency=$rev_debtor_jfr=$rev_bu_jfr=$rev_exchange_rate=$rev_invoiceno=$rev_invoicedate=$rev_creditnote=$rev_invoice_creation_date=$rev_invoice_receivdon_date=$rev_invoice_status='';
                    $cost_foreign_currency=$cost_debtor_jfr=$cost_bu_jfr=$cost_exchange_rate=$cost_invoiceno=$cost_invoicedate=$cost_creditnote=$cost_invoice_creation_date=$cost_invoice_receivdon_date=$cost_invoice_status='';
                    if(isset($revenueDataArray[0])){
                        if(isset($revenueDataArray[0]['foreign_currency'])){
                            $rev_foreign_currency = $revenueDataArray[0]['foreign_currency'];
                        }
                        if(isset($revenueDataArray[0]['debtor_jfr'])){
                            $rev_debtor_jfr = $revenueDataArray[0]['debtor_jfr'];
                        }
                        if(isset($revenueDataArray[0]['bu_jfr'])){
                            $rev_bu_jfr = $revenueDataArray[0]['bu_jfr'];
                        }
                        if(isset($revenueDataArray[0]['exchange_rate'])){
                            $rev_exchange_rate = $revenueDataArray[0]['exchange_rate'];
                        }
                        if(isset($revenueDataArray[0]['invoice_number'])){
                            $rev_invoiceno = $revenueDataArray[0]['invoice_number'];
                        }
                        if(isset($revenueDataArray[0]['invoice_date'])){
                            if($revenueDataArray[0]['invoice_date'] != "0000-00-00 00:00:00"){
                                $rev_invoicedate = $revenueDataArray[0]['invoice_date'];
                             }
                        }
                        if(isset($revenueDataArray[0]['credit_note_number'])){
                            $rev_creditnote = $revenueDataArray[0]['credit_note_number'];
                        }
                        if(isset($revenueDataArray[0]['invoice_creation_date'])){
                            if($revenueDataArray[0]['invoice_creation_date'] != "0000-00-00 00:00:00"){
                                $rev_invoice_creation_date = $revenueDataArray[0]['invoice_creation_date'];
                             }
                        }
                        if(isset($revenueDataArray[0]['invoice_receivdon_date'])){
                            if($revenueDataArray[0]['invoice_receivdon_date'] != "0000-00-00 00:00:00"){
                                $rev_invoice_receivdon_date = $revenueDataArray[0]['invoice_receivdon_date'];
                             }
                        }
                        if(isset($revenueDataArray[0]['invoice_status'])){
                            if($revenueDataArray[0]['invoice_status'] == 1){
                                $rev_invoice_status = "Ready to Invoiced";
                            }else {
                                $rev_invoice_status = "Billed";
                            }
                        }else{
                            $rev_invoice_status = "Billed";
                        }


                    }

                    if(isset($revenueDataArray[1])){
                        if(isset($revenueDataArray[1]['foreign_currency'])){
                            $cost_foreign_currency = $revenueDataArray[1]['foreign_currency'];
                        }
                        if(isset($revenueDataArray[1]['debtor_jfr'])){
                            $cost_debtor_jfr = $revenueDataArray[1]['debtor_jfr'];
                        }
                        if(isset($revenueDataArray[1]['bu_jfr'])){
                            $cost_bu_jfr = $revenueDataArray[1]['bu_jfr'];
                        }
                        if(isset($revenueDataArray[1]['exchange_rate'])){
                            $cost_exchange_rate = $revenueDataArray[1]['exchange_rate'];
                        }
                    }


                    $vas_1_name= $vas_1_quantity = $vas_2_name= $vas_2_quantity = $vas_3_name =$vas_3_quantity = $vas_4_name= $vas_4_quantity= $vas_5_name = $vas_5_quantity = "";
                    if($res->vas_details!=''){
                        $vasData= $this->formatGenericParameters($res->vas_details,'VAS');
                        if(!empty($vasData) && sizeof($vasData)>0){
                            $v= 1;
                            foreach ($vasData as $vas) {
                                if(isset($vas['vas_name'])  &&  isset($vas['vas_quantity'])){
                                    if($v ==1){
                                        $vas_1_name=$vas['vas_name'];
                                        $vas_1_quantity = $vas['vas_quantity'];
                                    }else if($v ==2){
                                        $vas_2_name=$vas['vas_name'];
                                        $vas_2_quantity = $vas['vas_quantity'];
                                    }else if($v ==3){
                                        $vas_3_name=$vas['vas_name'];
                                        $vas_3_quantity = $vas['vas_quantity'];
                                    }else if($v ==4){
                                        $vas_4_name=$vas['vas_name'];
                                        $vas_4_quantity = $vas['vas_quantity'];
                                    }else if($v ==5){
                                        $vas_5_name=$vas['vas_name'];
                                        $vas_5_quantity = $vas['vas_quantity'];
                                    }
                                }

                                $v++;
                            }
                        }
                    }

                    $service_name = "";
                    if($res->name_of_service!=''){
                        $service_name = $res->name_of_service;
                    }
                    $order_type = $delivery_term = "";
                    if($res->order_type!=''){
                        $order_type = $res->order_type_name;
                    }
                    if($res->delivery_term_name!=''){
                        $delivery_term = $res->delivery_term_name;
                    }

                $action = '<div class="checkbox checkbox-info">
                <label>
                    <input type="checkbox" name="check_box" id="'.$res->id.'" value="'.$res->id.'">
                    <span class="cr"><i class="cr-icon fa fa-check"></i></span>
                </label>
                </div>';

                    $recordListing[ $i ][0]  = $action;
                    $recordListing[ $i ][1]  = $res->order_id;
                    $recordListing[ $i ][2]  = $delivery_note;
                    $recordListing[ $i ][3]  = $purchase_order;
                    $recordListing[ $i ][4]  = date('d-m-Y',strtotime($res->createdon));
                    $recordListing[ $i ][5]  = $early_pickup;
                    $recordListing[ $i ][6]  = $early_delivery;
                    $recordListing[ $i ][7]  = $shipper_details['id'];
                    $recordListing[ $i ][8]  = $shipper_details['code'];
                    $recordListing[ $i ][9]  = $shipper_details['acon'];
                    $recordListing[ $i ][10] = $shipper_details['kn_login'];
                    $recordListing[ $i ][11] = $shipper_details['vat_reg_no'];
                    $recordListing[ $i ][12] = $shipper_details['tax_payer_no'];
                    $recordListing[ $i ][13] = $shipper_details['name'];
                    $recordListing[ $i ][14] = $shipper_details['street'];
                    $recordListing[ $i ][15] = $shipper_details['city'];
                    $recordListing[ $i ][16] = $shipper_details['pincode'];
                    $recordListing[ $i ][17] = $shipper_details['country'];
                    $recordListing[ $i ][18] = $shipper_details['phone'];
                    $recordListing[ $i ][19] = $shipper_details['email'];

                    $recordListing[ $i ][20] = $drop_details['id'];
                    $recordListing[ $i ][21] = $drop_details['code'];
                    $recordListing[ $i ][22] = $drop_details['acon'];
                    $recordListing[ $i ][23] = $drop_details['kn_login'];
                    $recordListing[ $i ][24] = $drop_details['vat_reg_no'];
                    $recordListing[ $i ][25] = $drop_details['tax_payer_no'];
                    $recordListing[ $i ][26] = $drop_details['name'];
                    $recordListing[ $i ][27] = $drop_details['street'];
                    $recordListing[ $i ][28] = $drop_details['city'];
                    $recordListing[ $i ][29] = $drop_details['pincode'];
                    $recordListing[ $i ][30] = $drop_details['country'];
                    $recordListing[ $i ][31] = $drop_details['phone'];
                    $recordListing[ $i ][32] = $drop_details['email'];
                    $recordListing[ $i ][33] = $customer_details['id'];
                    $recordListing[ $i ][34] = $customer_details['code'];
                    $recordListing[ $i ][35] = $customer_details['acon'];
                    $recordListing[ $i ][36] = $customer_details['kn_login'];
                    $recordListing[ $i ][37] = $customer_details['kn_login'];
                    $recordListing[ $i ][38] = $customer_details['tax_payer_no'];
                    $recordListing[ $i ][39] = $customer_details['name'];
                    $recordListing[ $i ][40] = $customer_details['street'];
                    $recordListing[ $i ][41] = $customer_details['pincode'];
                    $recordListing[ $i ][42] = $customer_details['country'];
                    $recordListing[ $i ][43] = $customer_details['phone'];
                    $recordListing[ $i ][44] = $customer_details['email'];
                    $recordListing[ $i ][45] = $customer_details['country'];

                    $recordListing[ $i ][46] = $res->branch_code;
                    $recordListing[ $i ][47] = $res->department_code;
                    $recordListing[ $i ][48] = $res->product;
                    $recordListing[ $i ][49] = $service_name;
                    $recordListing[ $i ][50] = $res->incoterm;
                    $recordListing[ $i ][51] = $delivery_term;

                    $recordListing[ $i ][52] = $delivery_note;
                    $recordListing[ $i ][53] = $notify_address['name'];
                    $recordListing[ $i ][54] = $order_type;
                    $recordListing[ $i ][55] = $res->transport_mode;
                    $recordListing[ $i ][56] = $purchase_order;
                    $recordListing[ $i ][57] = $res->cargo_total_quantity;
                    $recordListing[ $i ][58] = $res->cargo_total_package_type;
                    $recordListing[ $i ][59] = $res->cargo_total_length;
                    $recordListing[ $i ][60] = $res->cargo_total_length_unit;
                    $recordListing[ $i ][61] = $res->cargo_total_width;
                    $recordListing[ $i ][62] = $res->cargo_total_width_unit;
                    $recordListing[ $i ][63] = $res->cargo_total_height;
                    $recordListing[ $i ][64] = $res->cargo_total_height_unit;
                    $recordListing[ $i ][65] = $res->cargo_total_second_weight;
                    $recordListing[ $i ][66] = $res->cargo_total_weight_unit;
                    $recordListing[ $i ][67] = $res->cargo_total_second_volume;
                    $recordListing[ $i ][68] = $res->cargo_total_volume_unit;
                    $recordListing[ $i ][69] = $res->cargo_total_ldm;
                    $recordListing[ $i ][70] = $res->cargo_total_volumetric_weight;
                    $recordListing[ $i ][71] = $res->cargo_total_volweight_uom;

                    $stackable='';
                    $dgGoods='';
                    $stackableExplode=explode(',',$res->cargo_total_stackable);
                    if(!empty($stackableExplode) && sizeof($stackableExplode)){
                        foreach($stackableExplode as $eachStackable){
                            if($eachStackable=='1'){
                                $stackable=$stackable.'Yes,';
                            }else{
                                $stackable=$stackable.'No,';
                            }
                        }
                    }
                    $dgGoodsExplode=explode(',',$res->cargo_total_dg_goods);
                    if(!empty($dgGoodsExplode) && sizeof($dgGoodsExplode)){
                        foreach($dgGoodsExplode as $eachDg){
                            if($eachDg=='1'){
                                $dgGoods=$dgGoods.'Yes,';
                            }else{
                                $dgGoods=$dgGoods.'No,';
                            }
                        }
                    }
                    $stackable=rtrim($stackable,",");
                    $dgGoods=rtrim($dgGoods,",");

                    $recordListing[ $i ][72] = $stackable;
                    $recordListing[ $i ][73] = $dgGoods;


                    $recordListing[ $i ][74] = $res->carg_total_weight;
                    $recordListing[ $i ][75] = $res->cargo_total_weight_unit;
                    $recordListing[ $i ][76] = $res->cargo_total_volume;
                    $recordListing[ $i ][77] = $res->cargo_total_volume_unit;

                    $recordListing[ $i ][78] = $vas_1_name;
                    $recordListing[ $i ][79] = $vas_1_quantity;
                    $recordListing[ $i ][80] = $vas_2_name;
                    $recordListing[ $i ][81] = $vas_2_quantity;
                    $recordListing[ $i ][82] = $vas_3_name;
                    $recordListing[ $i ][83] = $vas_3_quantity;
                    $recordListing[ $i ][84] = $vas_4_name;
                    $recordListing[ $i ][85] = $vas_4_quantity;
                    $recordListing[ $i ][86] = $vas_5_name;
                    $recordListing[ $i ][87] = $vas_5_quantity;
                    $recordListing[ $i ][88] = $ref_1_name;
                    $recordListing[ $i ][89] = $ref_1_description;
                    $recordListing[ $i ][90] = $ref_1_value;
                    $recordListing[ $i ][91] = $ref_2_name;
                    $recordListing[ $i ][92] = $ref_2_description;
                    $recordListing[ $i ][93] = $ref_2_value;
                    $recordListing[ $i ][94] = $ref_3_name;
                    $recordListing[ $i ][95] = $ref_3_description;
                    $recordListing[ $i ][96] = $ref_3_value;
                    $recordListing[ $i ][97] = $ref_4_name;
                    $recordListing[ $i ][98] = $ref_4_description;
                    $recordListing[ $i ][99] = $ref_4_value;
                    $recordListing[ $i ][100] = $ref_5_name;
                    $recordListing[ $i ][101] = $ref_5_description;

                    $recordListing[ $i ][102] = $ref_5_value;
                    $recordListing[ $i ][103] = $ruck_val;
                    $recordListing[ $i ][104] = $rucksn_val;
                    $recordListing[ $i ][105] = $getstatusdates['statuspickupdate'];
                    $recordListing[ $i ][106] = $getstatusdates['statusdeliverydate'];
                    $recordListing[ $i ][107] = $docs_received_datetime;
                    $recordListing[ $i ][108] = $docs_sent_datetime;

                    $recordListing[ $i ][109] = $trip_no;
                    $recordListing[ $i ][110] = $res->suppier_name;
                    $recordListing[ $i ][111] = $register_number;
                    $recordListing[ $i ][112] = $trailer_no;
                    $recordListing[ $i ][113] = $vehicle_type;
                    $recordListing[ $i ][114] = $driver_name;
                    $recordListing[ $i ][115] = $driver_licence_number;
                    $recordListing[ $i ][116] = '';
                    $recordListing[ $i ][117] = 'Customer';
                    $recordListing[ $i ][118] = $res->payer_id;
                    $recordListing[ $i ][119] = $res->payer_name;
                    $recordListing[ $i ][120] = $res->payer_cid;
                    $recordListing[ $i ][121] = $res->payer_acondebtorcode;
                    $recordListing[ $i ][122] = $res->payer_kn_login_account;
                    $recordListing[ $i ][123] = $res->payer_vat_regno;
                    $recordListing[ $i ][124] = $res->payer_tax_payerid;
                    $recordListing[ $i ][125] = $res->payer_steeet_house;
                    $recordListing[ $i ][126] = $res->payer_postal;

                    $recordListing[ $i ][127] = $res->payer_country ?? '';
                    $recordListing[ $i ][128] = $res->payer_phone ?? '';
                    $recordListing[ $i ][129] = $res->payer_email ?? '';
                    $recordListing[ $i ][130] = $newgetcharge['chargecode'] ?? '';
                    $recordListing[ $i ][131] = $newgetcharge['chargecodename'] ?? '';
                    $recordListing[ $i ][132] = $newgetcharge['quantity'] ?? 0;
                    $recordListing[ $i ][133] = $newgetcharge['value'] ?? '';
                    $recordListing[ $i ][134] = $newgetcharge['rate_id'] ?? 0;
                    $recordListing[ $i ][135] = round($newgetcharge['amount'] ?? 0,2);
                    $recordListing[ $i ][136] = $newgetcharge['currency'] ?? 0;
                    $recordListing[ $i ][137] = $newgetcharge['vat_percentage'] ?? 0;
                    $recordListing[ $i ][138] = $newgetcharge['vat_amount'] ?? 0;
                    $recordListing[ $i ][139] = $rev_bu_jfr;
                    $recordListing[ $i ][140] = $rev_debtor_jfr;
                    $recordListing[ $i ][141] = $rev_exchange_rate;
                    $recordListing[ $i ][142] = $rev_foreign_currency;
                    $recordListing[ $i ][143] = $rev_invoiceno;
                    $recordListing[ $i ][144] = $rev_invoicedate;
                    $recordListing[ $i ][145] = $rev_creditnote;
                    $recordListing[ $i ][146] = '-';
                    $recordListing[ $i ][147] = $rev_invoice_creation_date;
                    $recordListing[ $i ][148] = $rev_invoice_receivdon_date;
                    $recordListing[ $i ][149] = $rev_invoice_status;
                    $recordListing[ $i ][150] = $customer_details['contract_no'] ?? '';
                    $recordListing[ $i ][151] = $customer_details['contract_date'] ?? '';

                    $recordListing[ $i ][152] = $rev_invoice_status;
                    $recordListing[ $i ][153] = '';
                    $recordListing[ $i ][154] = $res->supplier_id;
                    $recordListing[ $i ][155] = $res->suppier_name;
                    $recordListing[ $i ][156] = $res->suppier_steeet_house;
                    $recordListing[ $i ][157] = $res->suppier_postalcode;
                    $recordListing[ $i ][158] = $res->suppier_country;
                    $recordListing[ $i ][159] = $res->suppier_phone;
                    $recordListing[ $i ][160] = $res->suppier_email;
                    $recordListing[ $i ][161] = $getcostcharge['chargecode'] ?? '';
                    $recordListing[ $i ][162] = $getcostcharge['chargecodename'] ?? '';
                    $recordListing[ $i ][163] = $getcostcharge['quantity'] ?? 0;
                    $recordListing[ $i ][164] = $getcostcharge['value'] ?? '';
                    $recordListing[ $i ][165] = $getcostcharge['rate_id'] ?? 0;
                    $recordListing[ $i ][166] = $getcostcharge['amount'] ?? 0;
                    $recordListing[ $i ][167] = $getcostcharge['currency'] ?? '';
                    $recordListing[ $i ][168] = $getcostcharge['vat_percentage'] ?? 0;
                    $recordListing[ $i ][169] = $getcostcharge['vat_amount'] ?? 0;
                    $recordListing[ $i ][170] = $cost_bu_jfr;
                    $recordListing[ $i ][171] = $cost_debtor_jfr;
                    $recordListing[ $i ][172] = $cost_exchange_rate;
                    $recordListing[ $i ][173] = $cost_foreign_currency;

                $i ++;
            }

        $final_data = !empty($recordListing) ? json_encode($recordListing) : '[]';

        echo '{"draw":' . $draw . ',"recordsTotal":' . $totalRecords . ',"recordsFiltered":' . $recordsFiltered . ',"data":' . $final_data . '}';
    }

    public function allRoundReportV2(){
        $recordListing = [];

        $wherecondition='';
        $draw  = $this->input->post('draw',true);
        $start = $this->input->post('start',true);
        $limit =  $this->input->post('length',true); // get promo code Id
        $orderBy   =  $this->input->post('order',true);
        $post              = $this->input->post('data',true);
        $userid = $this->session->userdata("user_id");
        $custid = $this->session->userdata("cust_id");
        $dataTableSortOrdering= [];

        $dataTableSortOrdering[0]='tor.id';
        $dataTableSortOrdering[1]='tor.order_id';
        $dataTableSortOrdering[2]='tor.order_id';
        $dataTableSortOrdering[3]='tor.purchase_order';
        $dataTableSortOrdering[4]='tor.createdon';
        $dataTableSortOrdering[5]='tor.pickup_datetime';
        $dataTableSortOrdering[6]='tor.delivery_datetime';
        $dataTableSortOrdering[7]='';
        $dataTableSortOrdering[8]='';
        $dataTableSortOrdering[9]='';
        $dataTableSortOrdering[10]='';
        $dataTableSortOrdering[11]='';
        $dataTableSortOrdering[12]='';
        $dataTableSortOrdering[13]='';
        $dataTableSortOrdering[14]='';
        $dataTableSortOrdering[15]='';
        $dataTableSortOrdering[16]='';
        $dataTableSortOrdering[17]='';
        $dataTableSortOrdering[18]='';
        $dataTableSortOrdering[19]='';

        $dataTableSortOrdering[20]='';
        $dataTableSortOrdering[21]='';
        $dataTableSortOrdering[22]='';
        $dataTableSortOrdering[23]='';
        $dataTableSortOrdering[24]='';
        $dataTableSortOrdering[25]='';
        $dataTableSortOrdering[26]='';
        $dataTableSortOrdering[27]='';
        $dataTableSortOrdering[28]='';
        $dataTableSortOrdering[29]='';
        $dataTableSortOrdering[30]='';
        $dataTableSortOrdering[31]='';
        $dataTableSortOrdering[32]='';
        $dataTableSortOrdering[33]='tcd.cust_customeridentifier';
        $dataTableSortOrdering[34]='tcd.cust_code';
        $dataTableSortOrdering[35]='tcd.cust_acon_debitor_code';
        $dataTableSortOrdering[36]='tcd.cust_kn_login_account';
        $dataTableSortOrdering[37]='tcd.cust_kn_login_account';
        $dataTableSortOrdering[38]='tcd.tax_payer_no';
        $dataTableSortOrdering[39]='tcd.cust_name';

        $dataTableSortOrdering[40]='tcd.street';
        $dataTableSortOrdering[41]='tcd.cust_pincode';
        $dataTableSortOrdering[42]='tcd.cust_country';
        $dataTableSortOrdering[43]='tcd.cust_mobile';
        $dataTableSortOrdering[44]='tcd.cust_email';
        $dataTableSortOrdering[45]='cust_country';
        $dataTableSortOrdering[46]='tor.branch_code';
        $dataTableSortOrdering[47]='tor.department_code';
        $dataTableSortOrdering[48]='tor.product';
        $dataTableSortOrdering[49]='';
        $dataTableSortOrdering[50]='tor.incoterm';
        $dataTableSortOrdering[51]='';
        $dataTableSortOrdering[52]='';
        $dataTableSortOrdering[53]='';
        $dataTableSortOrdering[54]='';
        $dataTableSortOrdering[55]='tor.transport_mode';
        $dataTableSortOrdering[56]='tor.purchase_order';
        $dataTableSortOrdering[57]='c.cargo_total_quantity';
        $dataTableSortOrdering[58]='c.cargo_total_package_type';
        $dataTableSortOrdering[59]='c.cargo_total_length';

        $dataTableSortOrdering[60]='c.cargo_total_length_unit';
        $dataTableSortOrdering[61]='c.cargo_total_width';
        $dataTableSortOrdering[62]='c.cargo_total_width_unit';
        $dataTableSortOrdering[63]='c.cargo_total_height';
        $dataTableSortOrdering[64]='c.cargo_total_height_unit';
        $dataTableSortOrdering[65]='c.cargo_total_second_weight';
        $dataTableSortOrdering[66]='c.cargo_total_weight_unit';
        $dataTableSortOrdering[67]='c.cargo_total_second_volume';
        $dataTableSortOrdering[68]='c.cargo_total_volume_unit';
        $dataTableSortOrdering[69]='c.cargo_total_ldm';
        $dataTableSortOrdering[70]='c.cargo_total_volumetric_weight';
        $dataTableSortOrdering[71]='c.cargo_total_volweight_uom';
        $dataTableSortOrdering[72]='c.cargo_total_stackable';
        $dataTableSortOrdering[73]='c.cargo_total_dg_goods';
        $dataTableSortOrdering[74]='c.carg_total_weight';
        $dataTableSortOrdering[75]='c.cargo_total_weight_unit';
        $dataTableSortOrdering[76]='c.cargo_total_volume';
        $dataTableSortOrdering[77]='c.cargo_total_volume_unit';
        $dataTableSortOrdering[78]='';
        $dataTableSortOrdering[79]='';

        $dataTableSortOrdering[80]='';
        $dataTableSortOrdering[81]='';
        $dataTableSortOrdering[82]='';
        $dataTableSortOrdering[83]='';
        $dataTableSortOrdering[84]='';
        $dataTableSortOrdering[85]='';
        $dataTableSortOrdering[86]='';
        $dataTableSortOrdering[87]='';
        $dataTableSortOrdering[88]='';
        $dataTableSortOrdering[89]='';
        $dataTableSortOrdering[90]='';
        $dataTableSortOrdering[91]='';
        $dataTableSortOrdering[92]='';
        $dataTableSortOrdering[93]='';
        $dataTableSortOrdering[94]='';
        $dataTableSortOrdering[95]='';
        $dataTableSortOrdering[96]='';
        $dataTableSortOrdering[97]='';
        $dataTableSortOrdering[98]='';
        $dataTableSortOrdering[99]='';

        $dataTableSortOrdering[100]='';
        $dataTableSortOrdering[101]='';
        $dataTableSortOrdering[102]='';
        $dataTableSortOrdering[103]='';
        $dataTableSortOrdering[104]='';
        $dataTableSortOrdering[105]='';
        $dataTableSortOrdering[106]='';
        $dataTableSortOrdering[107]='';
        $dataTableSortOrdering[108]='';
        $dataTableSortOrdering[109]='';
        $dataTableSortOrdering[110]='';
        $dataTableSortOrdering[111]='';
        $dataTableSortOrdering[110]='tinfo.trailer_no';
        $dataTableSortOrdering[111]='tinfo.vehicle_type';
        $dataTableSortOrdering[112]='tinfo.driver_name';
        $dataTableSortOrdering[113]='tinfo.driver_licence_number';
        $dataTableSortOrdering[114]='';
        $dataTableSortOrdering[116]='tparty.id';
        $dataTableSortOrdering[117]='tparty.name';

        $dataTableSortOrdering[118]='tparty.code';
        $dataTableSortOrdering[119]='tparty.acon_debitor_code';
        $dataTableSortOrdering[120]='tparty.kn_login_account';
        $dataTableSortOrdering[121]='tparty.vat_reg_no';
        $dataTableSortOrdering[122]='tparty.tax_payer_no';
        $dataTableSortOrdering[123]='tparty.street';
        $dataTableSortOrdering[124]='tparty.pincode';
        $dataTableSortOrdering[125]='tparty.country';
        $dataTableSortOrdering[126]='tparty.mobile';
        $dataTableSortOrdering[127]='tparty.email';
        $dataTableSortOrdering[130]='';
        $dataTableSortOrdering[131]='';
        $dataTableSortOrdering[132]='';
        $dataTableSortOrdering[133]='';
        $dataTableSortOrdering[134]='';
        $dataTableSortOrdering[135]='';
        $dataTableSortOrdering[136]='';
        $dataTableSortOrdering[137]='';
        $dataTableSortOrdering[138]='';
        $dataTableSortOrdering[139]='';

        $dataTableSortOrdering[140]='';
        $dataTableSortOrdering[141]='';
        $dataTableSortOrdering[142]='';
        $dataTableSortOrdering[143]='';
        $dataTableSortOrdering[144]='';
        $dataTableSortOrdering[145]='';
        $dataTableSortOrdering[146]='';
        $dataTableSortOrdering[147]='';
        $dataTableSortOrdering[148]='';
        $dataTableSortOrdering[149]='';
        $dataTableSortOrdering[150]='';
        $dataTableSortOrdering[151]='';
        $dataTableSortOrdering[152]='';
        $dataTableSortOrdering[153]='';
        $dataTableSortOrdering[152]='tinfo.supplier_id';
        $dataTableSortOrdering[153]='tinfo.suppier_name';
        $dataTableSortOrdering[154]='tinfo.suppier_steeet_house';
        $dataTableSortOrdering[155]='tinfo.suppier_postalcode';
        $dataTableSortOrdering[156]='tinfo.suppier_country';
        $dataTableSortOrdering[157]='tinfo.suppier_phone';

        $dataTableSortOrdering[158]='tinfo.suppier_email';
        $dataTableSortOrdering[161]='';
        $dataTableSortOrdering[162]='';
        $dataTableSortOrdering[163]='';
        $dataTableSortOrdering[164]='';
        $dataTableSortOrdering[165]='';
        $dataTableSortOrdering[166]='';
        $dataTableSortOrdering[167]='';
        $dataTableSortOrdering[168]='';
        $dataTableSortOrdering[169]='';
        $dataTableSortOrdering[170]='';
        $dataTableSortOrdering[171]='';
        $dataTableSortOrdering[172]='';
        $dataTableSortOrdering[173]='';

        $orderByCondition='';
        if(isset($orderBy[0]));
        {
            if ($orderBy[0] != '') {
                $ordColIndex = $orderBy[0]['column'];
                $ordColDir = $orderBy[0]['dir'];
                if ($ordColDir == '') {
                    $ordColDir = 'asc';
                }
                if (isset($dataTableSortOrdering[$ordColIndex]) && $dataTableSortOrdering[$ordColIndex] != '') {
                    $orderByCondition = '  ' . $dataTableSortOrdering[$ordColIndex] . ' ' . $ordColDir . ' ';
                }
            }
        }

        $whr=$this->searchsubmitdata($post);

        $order_status = isset($post['status']) ? $post['status'] :"";
            $ad_orderstatus = isset($post['order_status']) ? $post['order_status'] :"";
            $status_search = $order_status;
            if($status_search == ""){
               $status_search = $ad_orderstatus;
           	}
           	$company_code = $this->session->userdata('company_code');
            $branch_code = $this->session->userdata('branch_code');
           	$subcusts = array();
           	$role_id = $this->session->userdata('user_role_id');
           	if($role_id == "4"){
                if($this->session->userdata('sub_cust')){
                    $subcusts = $this->session->userdata('sub_cust');
                    if(!empty($subcusts)){
                      array_push($subcusts, $custid);
                    }
                }
           	}
            $searchids = array();
            if (isset($post['bookingid']) && $post['bookingid'] != "") {
                $searchids = isset($post['bookingid']) ? $post['bookingid'] : array();
            }

            $whereArray=array();
            if(!empty($whr) && sizeof($whr)>0){
                foreach($whr as $key=>$value){
                    $value="'$value'";
                    if($key=="DATE_FORMAT(o.createdon,'%Y-%m-%d') >=" || $key=="DATE_FORMAT(o.createdon,'%Y-%m-%d') <=" || $key=="DATE_FORMAT(o.pickup_datetime,'%Y-%m-%d') >=" || $key=="DATE_FORMAT(o.pickup_datetime,'%Y-%m-%d') <="){
                        $whereArray[]= $key.$value;
                    }else{
                        $whereArray[]= $key.' = '.$value;
                    }
                }
            }

            if(!empty($whereArray) && sizeof($whereArray)>0){
                $wherecondition.= 'AND '.implode(' AND ', $whereArray);
            }

            if(!empty($searchids)){
                $tempSearchId='';
                if(!empty($searchids) && sizeof($searchids)>0){
                    foreach($searchids as $eachSearchKey){
                        $tempSearchId.="'$eachSearchKey',";
                    }
                }

                $tempSearchId= trim($tempSearchId,',');

                if($tempSearchId!=''){
                    $wherecondition.=  " and o.order_id in ($tempSearchId) ";
                }
            }

        if($userid != '0'){
            if(!empty($countryuids)){
                $tempCountryId=implode(',',$countryuids);
                $wherecondition.=  " and o.user_id in ($tempCountryId) ";
            }else{
                $wherecondition.=  "  and o.user_id = '$userid' ";
            }
        }

        $searchsts=$status_search;

        if($searchsts == 'PENDING'){
            $wherecondition.=  " and o.trip_id = 0 ";
        }

        if($searchsts == 'ACTIVE'){
            $wherecondition.=  " and o.trip_id != 0  and  o.trip_sts=0 ";
        }

        if($searchsts == 'CLOSED'){
            $wherecondition.=  " and o.trip_id != 0  and  o.trip_sts = 1 ";
        }

        if(!empty($subcusts)){
            $tempSubCusts=implode(',',$subcusts);
            if($tempSubCusts!=''){
                $wherecondition.=  " and o.customer_id in ($tempSubCusts) ";
            }
        } else {
            if($custid != ""){
                $wherecondition.=  " and o.customer_id = '$custid' ";
            }
        }

        if($post['shipper_name']!='' || $post['consignee_name']!='' ){
            $shipper_name_cond=$this->db->escape($post['shipper_name']);
            $consignee_name_cond=$this->db->escape($post['consignee_name']);

            if($consignee_name_cond!=''){
                $wherecondition.=  " and o.delivery_company like '%$consignee_name_cond%' ";
            }
            if($shipper_name_cond!=''){
                $wherecondition.=  " and o.pickup_company like '%$shipper_name_cond%' ";
            }
        }

        $countQuery="select count(o.id) as count from tb_orders o
        left join tb_order_details d on d.order_row_id=o.id
        where o.status!=0  $wherecondition ";
        $countQueryResult=$this->db->query($countQuery);

        $rowCount=$countQueryResult->result();
        $totalRecords=$rowCount[0]->count;
        $wherecondition='"'.$wherecondition.'"';
        $company_code= '"'.$company_code.'"';
        $orderByCondition='"'.$orderByCondition.'"';

        $dataQuery = array($start, $limit, $wherecondition, $orderByCondition, $company_code);
        $query = "CALL `allRoundBigReportV2`(?, ?, ?, ?, ?);";
        $data = $this->db->query($query, $dataQuery);
        $getRecordListing=$data->result();
        $recordsFiltered=$totalRecords;
        $i                = 0;

            foreach ( $getRecordListing as $res ) {
                $delivery_note = $purchase_order = "";
                $trip_no = $res->shipmentid;

                if($trip_no == '0'){
                    $trip_no = "";
                }

                $trip_sts = $res->trip_sts;
                $trip_id = $res->trip_id;
                $vendor_id = $res->vendor_id;

                $chkdate = '2020-07-01 00:00:00';
                $createdon = $res->createdon;
                $early_pickup = $res->pickup_datetime;

                $early_delivery = $res->delivery_datetime;
                $curtz = $this->session->userdata("usr_tzone")['timezone'];

                if($early_pickup != "" && $early_pickup != "0000-00-00 00:00:00"){
                    $epickup = getdatetimebytimezone($curtz,$early_pickup,DFLT_TZ);
                    $early_pickup = $epickup['datetime'];
                }
                if($early_delivery != "" && $early_delivery != "0000-00-00 00:00:00"){
                    $edelivery = getdatetimebytimezone($curtz,$early_delivery,DFLT_TZ);
                    $early_delivery = $edelivery['datetime'];
                }

                //pickupaddress and delivery address
                $pickup_company = (!empty($res->pickup_company)) ? $res->pickup_company.' , ' :  "" ;
                $delivery_company = (!empty($res->delivery_company)) ? $res->delivery_company.' , ' :  "" ;
                $pickup_address1 = (!empty($res->pickup_address1)) ? $res->pickup_address1.' , ' :  "" ;
                $pickup_address2 = (!empty($res->pickup_address2)) ? $res->pickup_address2.' , ' :  "" ;
                $pickup_city = (!empty($res->pickup_city)) ? $res->pickup_city.' , ' :  "" ;
                $pickup_country = (!empty($res->pickup_country)) ? $res->pickup_country.' , ' :  "" ;
                $pickup_pincode = (!empty($res->pickup_pincode)) ? $res->pickup_pincode.' , ' :  "" ;
                $delivery_address1 = (!empty($res->delivery_address1)) ? $res->delivery_address1.' , ' :  "" ;
                $delivery_address2 = (!empty($res->delivery_address2)) ? $res->delivery_address2.' , ' :  "" ;
                $delivery_city = (!empty($res->delivery_city)) ? $res->delivery_city.' , ' :  "" ;
                $delivery_country = (!empty($res->delivery_country)) ? $res->delivery_country.' , ' :  "" ;
                $delivery_pincode = (!empty($res->delivery_pincode)) ? $res->delivery_pincode.' , ' :  "" ;
                $pickup_address = $pickup_company.$pickup_address1.$pickup_city.$pickup_address2.$pickup_country.$pickup_pincode;
                $delivery_address = $delivery_company.$delivery_address1.$delivery_city.$delivery_address2.$delivery_country.$delivery_pincode;
                $pickup_address = ltrim($pickup_address,' , ');
                $delivery_address = ltrim($delivery_address,' , ');

                if($res->partydetails_id!=''){
                    $PartyArray= [
                        $res->partydetails_id,
                        $res->partydetails_party_type_id,
                        $res->partydetails_name,
                        $res->partydetails_mobile,
                        $res->partydetails_email,
                        $res->partydetails_code,
                        $res->partydetails_customeridentifier,
                        $res->partydetails_house_number,
                        $res->partydetails_fax,
                        $res->partydetails_acon_debitor_code,
                        $res->partydetails_kn_login_account,
                        $res->partydetails_vat_reg_no,
                        $res->partydetails_tax_payer_no,
                        $res->partydetails_contract_no,
                        $res->partydetails_contract_date,
                        $res->partydetails_party_type,
                        $res->partydetails_party_type_name
                    ];

                    $getpartydetails=$this->buildGenericArray($PartyArray);
                }

                $customer_details = $drop_details = $shipper_details = ['id'=>"",'name'=>"",'phone'=>"",'email'=>"",'fax'=>"",'code'=>"",'street'=>"",'state'=>"",'city'=>"",'country'=>"",'pincode'=>"",'acon'=>"",'kn_login'=>"",'vat_reg_no'=>"",'tax_payer_no'=>"",'contract_no'=>"",'contract_date'=>""];
                    $notify_address['name'] ="Notify Party";

                    if(!empty($getpartydetails)){
                        foreach($getpartydetails as $rr){
                            if(!isset($rr['customeridentifier'])){
                                $rr['customeridentifier']='';
                            }
                            if(!isset($rr['name'])){
                                $rr['name']='';
                            }
                            if(!isset($rr['mobile'])){
                                $rr['mobile']='';
                            }
                            if(!isset($rr['email'])){
                                $rr['email']='';
                            }
                            if(!isset($rr['fax'])){
                                $rr['fax']='';
                            }
                            if(!isset($rr['code'])){
                                $rr['code']='';
                            }
                            if(!isset($rr['acon_debitor_code'])){
                                $rr['acon_debitor_code']='';
                            }
                            if(!isset($rr['kn_login_account'])){
                                $rr['kn_login_account']='';
                            }
                            if(!isset($rr['vat_reg_no'])){
                                $rr['vat_reg_no']='';
                            }
                            if(!isset($rr['house_number'])){
                                $rr['house_number']='';
                            }
                            if(!isset($rr['contract_no'])){
                                $rr['contract_no']='';
                            }
                            if(!isset($rr['contract_date'])){
                                $rr['contract_date']='';
                            }
                            if(!isset($rr['tax_payer_no'])){
                                $rr['tax_payer_no']='';
                            }
                            if(!isset($rr['party_type_id'])){
                                $rr['party_type_id']='';
                            }
                            $ptype = $rr['party_type_id'];
                            if($rr['party_type_name']!=''){
                                    if($rr['party_type_name'] == "Consignee"){
                                        $drop_details = array('id'=>$rr['customeridentifier'],'name'=>$rr['name'],'phone'=>$rr['mobile'],'email'=>$rr['email'],'fax'=>$rr['fax'],'code'=>$rr['code'],'acon'=>$rr['acon_debitor_code'],'kn_login'=>$rr['kn_login_account'],'vat_reg_no'=>$rr['vat_reg_no'],'tax_payer_no'=>$rr['tax_payer_no'],'contract_no'=>$rr['contract_no'],'contract_date'=>$rr['contract_date'],'house_number'=>$rr['house_number']);
                                    }if($rr['party_type_name'] == "Shipper"){
                                        $shipper_details = array('id'=>$rr['customeridentifier'],'name'=>$rr['name'],'phone'=>$rr['mobile'],'email'=>$rr['email'],'fax'=>$rr['fax'],'code'=>$rr['code'],'acon'=>$rr['acon_debitor_code'],'kn_login'=>$rr['kn_login_account'],'vat_reg_no'=>$rr['vat_reg_no'],'tax_payer_no'=>$rr['tax_payer_no'],'contract_no'=>$rr['contract_no'],'contract_date'=>$rr['contract_date'],'house_number'=>$rr['house_number']);
                                    }
                            }
                            if($rr['party_type_name']=='NOTIFY_PARTY'){
                                $notify_address['name'] =$rr['name'];
                            }
                        }
                    }



                    /*Shipper ACON Debitor Code	Shipper KN Login Account	Shipper VAT Registration Number	Shipper Tax Payer ID*/
                    #########################################
                    if(isset($res->pickup)){
                        $shipper_details['name'] = $res->pickup;
                    }
                    ###########################################
                    $shipper_details['street'] = $res->pickup_address1;
                    if(isset($shipper_details['house_number'])){
                        if($shipper_details['house_number'] != ""){
                          $shipper_details['street'] .= $shipper_details['house_number'];
                        }
                     }
                    $shipper_details['state'] = $res->pickup_address2;
                    $shipper_details['city'] = $res->pickup_city;
                    $shipper_details['country'] = $res->pickup_country;
                    $shipper_details['pincode'] = $res->pickup_pincode;
                    ##########################################
                    if(isset($res->delivery)){
                        $drop_details['name'] = $res->delivery;
                    }
                    #############################################
                    $drop_details['street'] = $res->delivery_address1;
                    if(isset($drop_details['house_number'])){
                        if($drop_details['house_number'] != ""){
                          $drop_details['street'] .= $drop_details['house_number'];
                        }
                     }
                    $drop_details['state'] = $res->delivery_address2;
                    $drop_details['city'] = $res->delivery_city;
                    $drop_details['country'] = $res->delivery_country;
                    $drop_details['pincode'] = $res->delivery_pincode;

                    if($res->customer_id>0){
                        if($res->cust_contract_date == "0000-00-00"){
                            $res->cust_contract_date = "";
                        }
                        $street = $res->cust_street;
                        if($res->cust_house_number !=""){
                            $street .= $res->cust_house_number;
                        }
                        $customer_details = [
                            'id'=>$res->cust_customeridentifier,
                            'name'=>$res->cust_name,
                            'phone'=>$res->cust_mobile,
                            'email'=>$res->cust_email,
                            'fax'=>$res->cust_fax,
                            'code'=>$res->cust_code,
                            'street'=>$street,
                            'state'=>$res->cust_state,
                            'city'=>$res->cust_location_id,
                            'country'=>$res->cust_country,
                            'pincode'=>$res->cust_pincode,
                            'acon'=>$res->cust_acon_debitor_code,
                            'kn_login'=>$res->cust_kn_login_account,
                            'vat_reg_no'=>$res->cust_vat_reg_no,
                            'tax_payer_no'=>$res->cust_tax_payer_no,
                            'contract_no'=>$res->cust_contract_no,
                            'contract_date'=>$res->cust_contract_date
                        ];
                    }

                    if($res->reference_value!=''){
                        $arrayData= $this->formatGenericParameters($res->reference_value,'REFERENCE');
                    }

                    $ref_1_name = $ref_1_description= $ref_1_value = $ref_2_name = $ref_2_description= $ref_2_value = $ref_3_name = $ref_3_description=$ref_3_value = $ref_4_name = $ref_4_description= $ref_4_value = $ref_5_name = $ref_5_description= $ref_5_value = $ruck_val =$rucksn_val ="";
					if(!empty($arrayData)){
                        $ctr =1;
                        $ref_id='';
						foreach($arrayData as $ref){
                            if(isset($ref['reference_id'])){
                                $ref_id = $ref['reference_id'];
                            }

                            if(!in_array($ref_id, array('ORD_DLVINST','ORD_PIKINST','DQ','PO'))){
								if($ctr ==1){
                                    $ref_1_name = $ref_id;
                                    if(isset($ref['description'])){
                                        $ref_1_description = $ref['description'];
                                    }
                                    if(isset($ref['ref_value'])){
                                        $ref_1_value = $ref['ref_value'];
                                    }
								}else if($ctr ==2){
                                    $ref_2_name = $ref_id;
                                    if(isset($ref['description'])){
                                        $ref_2_description = $ref['description'];
                                    }
                                    if(isset($ref['ref_value'])){
                                        $ref_2_value = $ref['ref_value'];
                                    }

								}else if($ctr ==3){
                                    $ref_3_name = $ref_id;
                                    if(isset($ref['description'])){
                                        $ref_3_description = $ref['description'];
                                    }
                                    if(isset($ref['ref_value'])){
                                        $ref_3_value = $ref['ref_value'];
                                    }

								}else if($ctr ==4){
                                    $ref_4_name = $ref_id;
                                    if(isset($ref['description'])){
                                        $ref_4_description = $ref['description'];
                                    }
                                    if(isset($ref['ref_value'])){
                                        $ref_4_value = $ref['ref_value'];
                                    }

								}else if($ctr ==5){
                                    $ref_5_name = $ref_id;
                                    if(isset($ref['description'])){
                                        $ref_5_description = $ref['description'];
                                    }
                                    if(isset($ref['ref_value'])){
                                        $ref_5_value = $ref['ref_value'];
                                    }
								}
								$ctr++;
							}
							if($ref_id == 'DQ'){
                                if(isset($ref['ref_value'])){
                                    $delivery_note = $ref['ref_value'];
                                }
							}
                            if($ref_id == 'PO'){
                                if(isset($ref['ref_value'])){
                                    $purchase_order = $ref['ref_value'];
                                }
                            }
							if($ref_id == 'ORD_DLVINST'){
                                if(isset($ref['ref_value'])){
                                    $delivery_inst = $ref['ref_value'];
                                }
							}
							if($ref_id == 'ORD_PIKINST'){
                                if(isset($ref['ref_value'])){
                                    $pickup_inst = $ref['ref_value'];
                                }
						    }
                            if($ref_id == 'ORD_PIKINST'){
                                if(isset($ref['ref_value'])){
                                    $pickup_inst = $ref['ref_value'];
                                }
                            }
					    }
                    }

                    $getstatusdates = ['statuspickupdate'=>"",'statusdeliverydate'=>""];

                    if($res->status_details!=''){
                        $statusArrayData= $this->formatGenericParameters($res->status_details);
                        $zonecode = $this->session->userdata("usr_tzone");
                        $curtz = $zonecode['timezone'];

                        if(!empty($statusArrayData)){
                            foreach ($statusArrayData as $eachRow) {
                                if($eachRow['stop_type'] == "P"){
                                    if($eachRow['createdon'] != ""){
                                        $getactualStatus = getdatetimebytimezone($curtz,$eachRow['createdon'],DFLT_TZ);
                                        if(isset($getactualStatus['datetime'])){
                                            $getstatusdates['statuspickupdate'] = $getactualStatus['datetime'];
                                        }
                                    }
                                }

                                if($eachRow['stop_type'] == "D"){
                                    if($eachRow['createdon'] != ""){
                                        $getactualStatus = getdatetimebytimezone($curtz,$eachRow['createdon'],DFLT_TZ);
                                        if(isset($getactualStatus['datetime'])){
                                            $getstatusdates['statusdeliverydate'] = $getactualStatus['datetime'];
                                        }
                                    }
                                }
                            }
                        }
                    }

                    $docs_received_datetime = $res->docs_received_datetime;
					if($docs_received_datetime != "" && $docs_received_datetime != null){
                        $getactual = getdatetimebytimezone($curtz,$docs_received_datetime,DFLT_TZ);
                        if(isset($getactual['datetime'])){
                            $docs_received_datetime = $getactual['datetime'];
                        }

                    }
                    $docs_sent_datetime = $res->docs_sent_datetime;

                    if($docs_sent_datetime != "" && $docs_sent_datetime != null){
                        $getactual = getdatetimebytimezone($curtz,$docs_sent_datetime,DFLT_TZ);
						$docs_sent_datetime = $getactual['datetime'];
                    }

                    $vehicle_type = $res->vehicle_type;
					$trailer_no = $res->trailer_no;
                    $register_number = $res->register_number;
                    $driver_name = $driver_licence_number = '';

                    if($res->trip_id > 0){
                        $driver_name = $res->driver_name;
                        $driver_licence_number = $res->driver_licence_number;
                    }

                    $getcharge= $getcostcharge = ['chargecode'=>'','chargecodename'=>'','quantity'=>'','value'=>'','rate_id'=>'','amount'=>'','currency'=>'','vat_percentage'=>'','vat_amount'=>''];
                    $amt = $vatamt= $cost_amt = $cost_vatamt = 0;
                    $currency = $cost_currency= '';
                    $chargecode = $chargecodename = $quantity = $value = $rate_id = $amount = $vat_percentage = $vat_amount = array();
                    $cost_chargecode = $cost_chargecodename = $cost_quantity = $cost_value = $cost_rate_id =$cost_amount = $cost_vat_percentage = $cost_vat_amount = [];

                    if($res->chargedetails_type!=''){
                        $chagDetailsArray= [
                            $res->chargedetails_type,
                            $res->chargedetails_chargecode,
                            $res->chargedetails_chargecodename,
                            $res->chargedetails_quantity_unit,
                            $res->chargedetails_value,
                            $res->chargedetails_rate_id,
                            $res->chargedetails_amount,
                            $res->chargedetails_currency,
                            $res->chargedetails_vat_percentage,
                            $res->chargedetails_vat_amount,
                        ];

                        $getchargeData=$this->buildGenericArray($chagDetailsArray);

                        if(!empty($getchargeData)){
                            foreach ($getchargeData as $getcharge) {
                                if(!isset($getcharge['vat_amount']) || $getcharge['vat_amount']==''){
                                    $getcharge['vat_amount']=0;
                                }
                                if(!isset($getcharge['amount']) || $getcharge['amount']==''){
                                    $getcharge['amount']=0;
                                }
                                if(isset($getcharge['type'])){
                                if($getcharge['type']=='0'){
                                        if(isset($getcharge['charge_code'])){
                                            $chargecode[] = $getcharge['charge_code'];
                                        }
                                        if(isset($getcharge['name'])){
                                            $chargecodename[] = $getcharge['name'];
                                        }
                                        if(isset($getcharge['quantity_unit'])){
                                            $quantity[] = $getcharge['quantity_unit'];
                                        }
                                        if(isset($getcharge['value'])){
                                            $value[] = $getcharge['value'];
                                        }
                                        if(isset($getcharge['rate_id'])){
                                            $rate_id[] = $getcharge['rate_id'];
                                        }
                                        if(isset($getcharge['amount'])){
                                            $amount[] = $getcharge['amount'];
                                        }
                                        if(isset($getcharge['currency'])){
                                            $currency = $getcharge['currency'];
                                        }
                                        if(isset($getcharge['vat_percentage'])){
                                            $vat_percentage[] = $getcharge['vat_percentage'];
                                        }
                                        if(isset($getcharge['vat_amount'])){
                                            $vat_amount[] = $getcharge['vat_amount'];
                                        }
                                        if(isset($getcharge['amount'])){
                                            if($getcharge['amount']>0){
                                                $amt +=	$getcharge['amount'];
                                            }
                                        }
                                        if(isset($getcharge['vat_amount'])){
                                            if($getcharge['vat_amount']>0){
                                                $vatamt += $getcharge['vat_amount'];
                                            }
                                        }
                                }else if($getcharge['type']=='1'){
                                    if(isset($getcharge['charge_code'])){
                                        $cost_chargecode[] = $getcharge['charge_code'];
                                    }
                                    if(isset($getcharge['name'])){
                                        $cost_chargecodename[] = $getcharge['name'];
                                    }
                                    if(isset($getcharge['quantity_unit'])){
                                        $cost_quantity[] = $getcharge['quantity_unit'];
                                    }
                                    if(isset($getcharge['value'])){
                                        $cost_value[] = $getcharge['value'];
                                    }
                                    if(isset($getcharge['rate_id'])){
                                        $cost_rate_id[] = $getcharge['rate_id'];
                                    }
                                    if(isset($getcharge['amount'])){
                                        $cost_amount[] = $getcharge['amount'];
                                    }
                                    if(isset($getcharge['currency'])){
                                        $cost_currency = $getcharge['currency'];
                                    }
                                    if(isset($getcharge['vat_percentage'])){
                                        $cost_vat_percentage[] = $getcharge['vat_percentage'];
                                    }
                                    if(isset($getcharge['vat_amount'])){
                                        $cost_vat_amount[] = $getcharge['vat_amount'];
                                    }
                                    if(isset($getcharge['amount'])){
                                        if($getcharge['amount']>0){
                                            $cost_amt +=	$getcharge['amount'];
                                        }
                                    }
                                    if(isset($getcharge['vat_amount'])){
                                        if($getcharge['vat_amount']>0){
                                            $cost_vatamt +=	$getcharge['vat_amount'];
                                        }
                                    }
                                }
                            }

                            }

                            $getcharge = ['chargecode'=>implode(',',$chargecode),'chargecodename'=>implode(',',$chargecodename),'quantity'=>implode(',',$quantity),'value'=>implode(',',$value),'rate_id'=>implode(',',$rate_id),'amount'=>$amt,'currency'=>$currency,'vat_percentage'=>implode(',',$vat_percentage),'vat_amount'=>$vatamt];
                            $getcostcharge = ['chargecode'=>implode(',',$cost_chargecode),'chargecodename'=>implode(',',$cost_chargecodename),'quantity'=>implode(',',$cost_quantity),'value'=>implode(',',$cost_value),'rate_id'=>implode(',',$cost_rate_id),'amount'=>$cost_amt,'currency'=>$cost_currency,'vat_percentage'=>implode(',',$cost_vat_percentage),'vat_amount'=>$cost_vatamt];
                        }
                    }

                    $invoiced_bu_jfr=$billed_bu_jfr='';
                    $revenueDataArray=array();
                    if($res->revenue_details!=''){
                        $cost= [];
                        $getRevenueData= $this->formatGenericParameters($res->revenue_details,'REVENUE');

                        foreach($getRevenueData as $eachData){
                            if(isset($eachData['type'])){
                                $revDataIndex=$eachData['type'];
                                if($eachData['type']=='0' && $eachData['recipient_role']!='Internal BU'){
                                    if(!array_key_exists('0',$revenueDataArray)){
                                        $revenueDataArray[$revDataIndex]=$eachData;
                                    }
                                }else if($eachData['type']=='1' && $eachData['recipient_role']!='Internal BU'){
                                    if(!array_key_exists('1',$revenueDataArray)) {
                                        $revenueDataArray[$revDataIndex] = $eachData;
                                    }
                                }

                               if($eachData['recipient_role']=='Internal BU'){
                                    if($eachData['type']=='0'){
                                        $invoiced_bu_jfr=$eachData['bu_jfr'];
                                    }else if($eachData['type']=='1'){
                                        $billed_bu_jfr=$eachData['bu_jfr'];
                                    }
                               }

                            }
                        }
                    }

                    $rev_foreign_currency=$rev_debtor_jfr=$rev_exchange_rate=$rev_invoiceno=$rev_invoicedate=$rev_creditnote=$rev_invoice_creation_date=$rev_invoice_receivdon_date=$rev_invoice_status='';
                    $cost_foreign_currency=$cost_debtor_jfr=$cost_exchange_rate=$cost_invoice_status='';

                    if(isset($revenueDataArray[0])){
                        if(isset($revenueDataArray[0]['foreign_currency'])){
                            $rev_foreign_currency = $revenueDataArray[0]['foreign_currency'];
                        }
                        if(isset($revenueDataArray[0]['debtor_jfr'])){
                            $rev_debtor_jfr = $revenueDataArray[0]['debtor_jfr'];
                        }
                        if(isset($revenueDataArray[0]['exchange_rate'])){
                            $rev_exchange_rate = $revenueDataArray[0]['exchange_rate'];
                        }
                        if(isset($revenueDataArray[0]['invoice_number'])){
                            $rev_invoiceno = $revenueDataArray[0]['invoice_number'];
                        }
                        if(isset($revenueDataArray[0]['invoice_date'])){
                            if($revenueDataArray[0]['invoice_date'] != "0000-00-00 00:00:00"){
                                $rev_invoicedate = $revenueDataArray[0]['invoice_date'];
                             }
                        }
                        if(isset($revenueDataArray[0]['credit_note_number'])){
                            $rev_creditnote = $revenueDataArray[0]['credit_note_number'];
                        }
                        if(isset($revenueDataArray[0]['invoice_creation_date'])){
                            if($revenueDataArray[0]['invoice_creation_date'] != "0000-00-00 00:00:00"){
                                $rev_invoice_creation_date = $revenueDataArray[0]['invoice_creation_date'];
                             }
                        }
                        if(isset($revenueDataArray[0]['invoice_receivdon_date'])){
                            if($revenueDataArray[0]['invoice_receivdon_date'] != "0000-00-00 00:00:00"){
                                $rev_invoice_receivdon_date = $revenueDataArray[0]['invoice_receivdon_date'];
                             }
                        }
                        if(isset($revenueDataArray[0]['invoice_status'])){
                            if($revenueDataArray[0]['invoice_status'] == 0){
                                $rev_invoice_status = "To Be Billed";
                            }else if($revenueDataArray[0]['invoice_status'] == 1){
                                $rev_invoice_status = "Ready to Billed";
                            }else if($revenueDataArray[0]['invoice_status'] == 2) {
                                $rev_invoice_status = "Billed";
                            }
                        }else{
                            $rev_invoice_status = "";
                        }
                    }


                    if(isset($revenueDataArray[1])){
                        if(isset($revenueDataArray[1]['foreign_currency'])){
                            $cost_foreign_currency = $revenueDataArray[1]['foreign_currency'];
                        }
                        if(isset($revenueDataArray[1]['debtor_jfr'])){
                            $cost_debtor_jfr = $revenueDataArray[1]['debtor_jfr'];
                        }

                        if(isset($revenueDataArray[1]['exchange_rate'])){
                            $cost_exchange_rate = $revenueDataArray[1]['exchange_rate'];
                        }

                        if(isset($revenueDataArray[1]['invoice_status'])) {
                            if(isset($revenueDataArray[1]['invoice_status'])){
                                if((int)$revenueDataArray[1]['invoice_status'] === 0){
                                    $cost_invoice_status = "To Be Invoiced";
                                }else if((int)$revenueDataArray[1]['invoice_status'] === 1){
                                    $cost_invoice_status = "Ready to Invoiced";
                                }else if((int)$revenueDataArray[1]['invoice_status'] === 2) {
                                    $cost_invoice_status = "Invoiced";
                                }
                            }else{
                                $cost_invoice_status = "";
                            }

                        }
                    }

                    $vas_1_name= $vas_1_quantity = $vas_2_name= $vas_2_quantity = $vas_3_name =$vas_3_quantity = $vas_4_name= $vas_4_quantity= $vas_5_name = $vas_5_quantity = "";

                    if($res->vas_details!=''){
                        $vasData= $this->formatGenericParameters($res->vas_details,'VAS');

                        if(!empty($vasData) && sizeof($vasData)>0){
                            $v= 1;

                            foreach ($vasData as $vas) {
                                if(isset($vas['vas_name'])  &&  isset($vas['vas_quantity'])){
                                    if($v ==1){
                                        $vas_1_name=$vas['vas_name'];
                                        $vas_1_quantity = $vas['vas_quantity'];
                                    }else if($v ==2){
                                        $vas_2_name=$vas['vas_name'];
                                        $vas_2_quantity = $vas['vas_quantity'];
                                    }else if($v ==3){
                                        $vas_3_name=$vas['vas_name'];
                                        $vas_3_quantity = $vas['vas_quantity'];
                                    }else if($v ==4){
                                        $vas_4_name=$vas['vas_name'];
                                        $vas_4_quantity = $vas['vas_quantity'];
                                    }else if($v ==5){
                                        $vas_5_name=$vas['vas_name'];
                                        $vas_5_quantity = $vas['vas_quantity'];
                                    }
                                }
                                $v++;
                            }
                        }
                    }

                    $service_name = "";
                    if($res->name_of_service!=''){
                        $service_name = $res->name_of_service;
                    }
                    $order_type = $delivery_term = "";
                    if($res->order_type!=''){
                        $order_type = $res->order_type_name;
                    }
                    if($res->delivery_term_name!=''){
                        $delivery_term = $res->delivery_term_name;
                    }

                    $pod_available = $res->pod_available;
                    if($pod_available != "" && $pod_available != "0000-00-00 00:00:00" && $pod_available != "0"){
                        $poddate      = getdatetimebytimezone( $curtz, $pod_available, DFLT_TZ );
                        $pod_available = date('Y-m-d h:i A',strtotime($poddate['datetime']));
                    }

                    $accepted='';
                    if($res->driver_acceptance_date!=''){
                        $accepted = $res->driver_acceptance_date;
                        if($accepted != "" && $accepted != "0000-00-00 00:00:00" && $accepted != "0"){
                            $acceptdate      = getdatetimebytimezone( $curtz, $accepted, DFLT_TZ );
                            $accepted = date('Y-m-d h:i A',strtotime($acceptdate['datetime']));
                        }
                    }

                    $shipment_status=$res->generic_status_status_name;
                    if($res->generic_status_status_code=='0100'){
                        $shipment_status='Booked By Supplier';
                    }else if($res->generic_status_status_code=='0212'){
                        $shipment_status='Accepted By Driver';
                    }else if($res->generic_status_status_code=='0420'){
                        $shipment_status='Gate In';
                    }else if($res->generic_status_status_code=='0500'){
                        $shipment_status='Pickup';
                    }else if($res->generic_status_status_code=='0191'){
                        $shipment_status='Gate Out';
                    }else if($res->generic_status_status_code=='1550'){
                        $shipment_status='In-Transit';
                    }else if($res->generic_status_status_code=='0192'){
                        $shipment_status='Gate In (Destination)';
                    }else if($res->generic_status_status_code=='3000'){
                        $shipment_status='Delivered';
                    }else if($res->generic_status_status_code=='2300'){
                        $shipment_status='Gate Out (Destination)';
                    }

                    if($res->trip_sts==1){
                        $shipment_status='Delivered';
                    }

                $action = '<div class="checkbox checkbox-info">
                <label>
                    <input type="checkbox" name="check_box" id="'.$res->id.'" value="'.$res->id.'">
                    <span class="cr"><i class="cr-icon fa fa-check"></i></span>
                </label>
                </div>';

                    $recordListing[ $i ][0]  = $action;
                    $recordListing[ $i ][1]  = $res->order_id;
                    $recordListing[ $i ][2]  = $delivery_note;
                    $recordListing[ $i ][3]  = $purchase_order;
                    $recordListing[ $i ][4]  = date('d-m-Y',strtotime($res->createdon));
                    $recordListing[ $i ][5]  = $early_pickup;
                    $recordListing[ $i ][6]  = $early_delivery;
                    $recordListing[ $i ][7]  = $shipper_details['id'];
                    $recordListing[ $i ][8]  = $shipper_details['code'];
                    $recordListing[ $i ][9]  = $shipper_details['acon'];
                    $recordListing[ $i ][10] = $shipper_details['kn_login'];
                    $recordListing[ $i ][11] = $shipper_details['vat_reg_no'];
                    $recordListing[ $i ][12] = $shipper_details['tax_payer_no'];
                    $recordListing[ $i ][13] = $shipper_details['name'];
                    $recordListing[ $i ][14] = $shipper_details['street'];
                    $recordListing[ $i ][15] = $shipper_details['city'];
                    $recordListing[ $i ][16] = $shipper_details['pincode'];
                    $recordListing[ $i ][17] = $shipper_details['country'];
                    $recordListing[ $i ][18] = $shipper_details['phone'];
                    $recordListing[ $i ][19] = $shipper_details['email'];

                    $recordListing[ $i ][20] = $drop_details['id'];
                    $recordListing[ $i ][21] = $drop_details['code'];
                    $recordListing[ $i ][22] = $drop_details['acon'];
                    $recordListing[ $i ][23] = $drop_details['kn_login'];
                    $recordListing[ $i ][24] = $drop_details['vat_reg_no'];
                    $recordListing[ $i ][25] = $drop_details['tax_payer_no'];
                    $recordListing[ $i ][26] = $drop_details['name'];
                    $recordListing[ $i ][27] = $drop_details['street'];
                    $recordListing[ $i ][28] = $drop_details['city'];
                    $recordListing[ $i ][29] = $drop_details['pincode'];
                    $recordListing[ $i ][30] = $drop_details['country'];
                    $recordListing[ $i ][31] = $drop_details['phone'];
                    $recordListing[ $i ][32] = $drop_details['email'];
                    $recordListing[ $i ][33] = $customer_details['id'];
                    $recordListing[ $i ][34] = $customer_details['code'];
                    $recordListing[ $i ][35] = $customer_details['acon'];
                    $recordListing[ $i ][36] = $customer_details['kn_login'];
                    $recordListing[ $i ][37] = $customer_details['kn_login'];
                    $recordListing[ $i ][38] = $customer_details['tax_payer_no'];
                    $recordListing[ $i ][39] = $customer_details['name'];
                    $recordListing[ $i ][40] = $customer_details['street'];
                    $recordListing[ $i ][41] = $customer_details['pincode'];
                    $recordListing[ $i ][42] = $customer_details['country'];
                    $recordListing[ $i ][43] = $customer_details['phone'];
                    $recordListing[ $i ][44] = $customer_details['email'];
                    $recordListing[ $i ][45] = $customer_details['country'];

                    $recordListing[ $i ][46] = $res->branch_code;
                    $recordListing[ $i ][47] = $res->department_code;
                    $recordListing[ $i ][48] = $res->product;
                    $recordListing[ $i ][49] = $service_name;
                    $recordListing[ $i ][50] = $res->incoterm;
                    $recordListing[ $i ][51] = $delivery_term;

                    $recordListing[ $i ][52] = $delivery_note;
                    $recordListing[ $i ][53] = $notify_address['name'];
                    $recordListing[ $i ][54] = $order_type;
                    $recordListing[ $i ][55] = $res->transport_mode;
                    $recordListing[ $i ][56] = $purchase_order;
                    $recordListing[ $i ][57] = $res->cargo_total_quantity;
                    $recordListing[ $i ][58] = $res->cargo_total_package_type;
                    $recordListing[ $i ][59] = $res->cargo_total_length;
                    $recordListing[ $i ][60] = $res->cargo_total_length_unit;
                    $recordListing[ $i ][61] = $res->cargo_total_width;
                    $recordListing[ $i ][62] = $res->cargo_total_width_unit;
                    $recordListing[ $i ][63] = $res->cargo_total_height;
                    $recordListing[ $i ][64] = $res->cargo_total_height_unit;
                    $recordListing[ $i ][65] = $res->cargo_total_second_weight;
                    $recordListing[ $i ][66] = $res->cargo_total_weight_unit;
                    $recordListing[ $i ][67] = $res->cargo_total_second_volume;
                    $recordListing[ $i ][68] = $res->cargo_total_volume_unit;
                    $recordListing[ $i ][69] = $res->cargo_total_ldm;
                    $recordListing[ $i ][70] = $res->cargo_total_volumetric_weight;
                    $recordListing[ $i ][71] = $res->cargo_total_volweight_uom;

                    $stackable='';
                    $dgGoods='';
                    $stackableExplode=explode(',',$res->cargo_total_stackable);

                    if(!empty($stackableExplode) && sizeof($stackableExplode)){
                        foreach($stackableExplode as $eachStackable){
                            if($eachStackable=='1'){
                                $stackable=$stackable.'Yes,';
                            }else{
                                $stackable=$stackable.'No,';
                            }
                        }
                    }
                    $dgGoodsExplode=explode(',',$res->cargo_total_dg_goods);

                    if(!empty($dgGoodsExplode) && sizeof($dgGoodsExplode)){
                        foreach($dgGoodsExplode as $eachDg){
                            if($eachDg=='1'){
                                $dgGoods=$dgGoods.'Yes,';
                            }else{
                                $dgGoods=$dgGoods.'No,';
                            }
                        }
                    }
                    $stackable=rtrim($stackable,",");
                    $dgGoods=rtrim($dgGoods,",");

                    $recordListing[ $i ][72] = $stackable;
                    $recordListing[ $i ][73] = $dgGoods;


                    $recordListing[ $i ][74] = $res->carg_total_weight;
                    $recordListing[ $i ][75] = $res->cargo_total_weight_unit;
                    $recordListing[ $i ][76] = $res->cargo_total_volume;
                    $recordListing[ $i ][77] = $res->cargo_total_volume_unit;

                    $recordListing[ $i ][78] = $vas_1_name;
                    $recordListing[ $i ][79] = $vas_1_quantity;
                    $recordListing[ $i ][80] = $vas_2_name;
                    $recordListing[ $i ][81] = $vas_2_quantity;
                    $recordListing[ $i ][82] = $vas_3_name;
                    $recordListing[ $i ][83] = $vas_3_quantity;
                    $recordListing[ $i ][84] = $vas_4_name;
                    $recordListing[ $i ][85] = $vas_4_quantity;
                    $recordListing[ $i ][86] = $vas_5_name;
                    $recordListing[ $i ][87] = $vas_5_quantity;
                    $recordListing[ $i ][88] = $ref_1_name;
                    $recordListing[ $i ][89] = $ref_1_description;
                    $recordListing[ $i ][90] = $ref_1_value;
                    $recordListing[ $i ][91] = $ref_2_name;
                    $recordListing[ $i ][92] = $ref_2_description;
                    $recordListing[ $i ][93] = $ref_2_value;
                    $recordListing[ $i ][94] = $ref_3_name;
                    $recordListing[ $i ][95] = $ref_3_description;
                    $recordListing[ $i ][96] = $ref_3_value;
                    $recordListing[ $i ][97] = $ref_4_name;
                    $recordListing[ $i ][98] = $ref_4_description;
                    $recordListing[ $i ][99] = $ref_4_value;
                    $recordListing[ $i ][100] = $ref_5_name;
                    $recordListing[ $i ][101] = $ref_5_description;

                    $recordListing[ $i ][102] = $ref_5_value;
                    //$recordListing[ $i ][103] = $ruck_val;
                    //$recordListing[ $i ][104] = $rucksn_val;


                    $recordListing[ $i ][103] = $getstatusdates['statuspickupdate'];
                    $recordListing[ $i ][104] = $getstatusdates['statusdeliverydate'];
                    $recordListing[ $i ][105] = $docs_received_datetime;
                    $recordListing[ $i ][106] = $docs_sent_datetime;

                    $recordListing[ $i ][107] = $trip_no;
                    $recordListing[ $i ][108] = $res->suppier_name;
                    $recordListing[ $i ][109] = $register_number;
                    $recordListing[ $i ][110] = $trailer_no;
                    $recordListing[ $i ][111] = $vehicle_type;
                    $recordListing[ $i ][112] = $driver_name;
                    $recordListing[ $i ][113] = $driver_licence_number;
                    $recordListing[ $i ][114] = '';
                    $recordListing[ $i ][115] = 'Customer';
                    $recordListing[ $i ][116] = $res->payer_id;
                    $recordListing[ $i ][117] = $res->payer_name;
                    $recordListing[ $i ][118] = $res->payer_cid;
                    $recordListing[ $i ][119] = $res->payer_acondebtorcode;
                    $recordListing[ $i ][120] = $res->payer_kn_login_account;
                    $recordListing[ $i ][121] = $res->payer_vat_regno;
                    $recordListing[ $i ][122] = $res->payer_tax_payerid;
                    $recordListing[ $i ][123] = $res->payer_steeet_house;
                    $recordListing[ $i ][124] = $res->payer_postal;

                    $recordListing[ $i ][125] = $res->payer_country;
                    $recordListing[ $i ][126] = $res->payer_phone;
                    $recordListing[ $i ][127] = $res->payer_email;
                    $recordListing[ $i ][128] = $getcharge['chargecode'];
                    $recordListing[ $i ][129] = $getcharge['chargecodename'];
                    $recordListing[ $i ][130] = $getcharge['quantity'];
                    $recordListing[ $i ][131] = $getcharge['value'];
                    $recordListing[ $i ][132] = $getcharge['rate_id'];
                    $recordListing[ $i ][133] = $getcharge['amount'];
                    $recordListing[ $i ][134] = $getcharge['currency'];
                    $recordListing[ $i ][135] = $getcharge['vat_percentage'];
                    $recordListing[ $i ][136] = $getcharge['vat_amount'];
                    $recordListing[ $i ][137] = $invoiced_bu_jfr;
                    $recordListing[ $i ][138] = $rev_debtor_jfr;
                    $recordListing[ $i ][139] = $rev_exchange_rate;
                    $recordListing[ $i ][140] = $rev_foreign_currency;
                    $recordListing[ $i ][141] = $rev_invoiceno;
                    $recordListing[ $i ][142] = $rev_invoicedate;
                    $recordListing[ $i ][143] = $rev_creditnote;
                    $recordListing[ $i ][144] = '-';
                    $recordListing[ $i ][145] = $rev_invoice_creation_date;
                    $recordListing[ $i ][146] = $rev_invoice_receivdon_date;
                    $recordListing[ $i ][147] = $rev_invoice_status;
                    $recordListing[ $i ][148] = $customer_details['contract_no'];
                    $recordListing[ $i ][149] = $customer_details['contract_date'];
                    $recordListing[ $i ][150] = $cost_invoice_status;
                    $recordListing[ $i ][151] = '';
                    $recordListing[ $i ][152] = $res->supplier_id;
                    $recordListing[ $i ][153] = $res->suppier_name;
                    $recordListing[ $i ][154] = $res->suppier_steeet_house;
                    $recordListing[ $i ][155] = $res->suppier_postalcode;
                    $recordListing[ $i ][156] = $res->suppier_country;
                    $recordListing[ $i ][157] = $res->suppier_phone;
                    $recordListing[ $i ][158] = $res->suppier_email;
                    $recordListing[ $i ][159] = $getcostcharge['chargecode'];
                    $recordListing[ $i ][160] = $getcostcharge['chargecodename'];
                    $recordListing[ $i ][161] = $getcostcharge['quantity'];
                    $recordListing[ $i ][162] = $getcostcharge['value'];
                    $recordListing[ $i ][163] = $getcostcharge['rate_id'];
                    $recordListing[ $i ][164] = $getcostcharge['amount'];
                    $recordListing[ $i ][165] = $getcostcharge['currency'];
                    $recordListing[ $i ][166] = $getcostcharge['vat_percentage'];
                    $recordListing[ $i ][167] = $getcostcharge['vat_amount'];
                    $recordListing[ $i ][168] = $billed_bu_jfr;
                    $recordListing[ $i ][169] = $cost_debtor_jfr;
                    $recordListing[ $i ][170] = $cost_exchange_rate;
                    $recordListing[ $i ][171] = $cost_foreign_currency;
                    $recordListing[ $i ][172] = $pod_available;
                    $recordListing[ $i ][173] = $accepted;
                    $recordListing[ $i ][174] = $shipment_status;

                $i ++;
            }

        $final_data = !empty($recordListing) ? json_encode($recordListing) : '[]';

        echo '{"draw":' . $draw . ',"recordsTotal":' . $totalRecords . ',"recordsFiltered":' . $recordsFiltered . ',"data":' . $final_data . '}';
	}
}
