<?php if (!defined('BASEPATH')) {
    exit('No direct script access allowed');
}

class AllroundbigReportV3 extends CI_Controller
{

    public function __Construct()
    {
        parent::__Construct();
        if ($this->session->userdata('user_id') == '') {
            redirect('login');
        }
        $this->load->model("common");
    }

    public function searchsubmitdata($post)
    {
        $whr = [];
        $whr['ordids'] = [];

        if (isset($post['pickupfrom']) && $post['pickupfrom'] != "") {
            $pickupfrom = date('Y-m-d', strtotime($post['pickupfrom']));
            $whr["DATE_FORMAT(o.pickup_datetime,'%Y-%m-%d') >="] = $pickupfrom;
        }

        if (isset($post['pickupto']) && $post['pickupto'] != "") {
            $pickupto = date('Y-m-d', strtotime($post['pickupto']));
            $whr["DATE_FORMAT(o.pickup_datetime,'%Y-%m-%d') <="] = $pickupto;
        }

        if (isset($post['fromdate_search']) && $post['fromdate_search'] != "") {
            $fromdate_search = date('Y-m-d', strtotime($post['fromdate_search']));
            $whr["DATE_FORMAT(o.createdon,'%Y-%m-%d') >="] = $fromdate_search;
        }

        if (isset($post['todate_search']) && $post['todate_search'] != "") {
            $todate = date('Y-m-d', strtotime($post['todate_search']));
            $whr["DATE_FORMAT(o.createdon,'%Y-%m-%d') <="] = $todate;
        }

        if (isset($post['booking_id']) && $post['booking_id'] != "") {
            $whr['o.order_id'] = $post['booking_id'];
        }

        if (isset($post['order_id']) && $post['order_id'] != "") {
            $whr['o.order_id'] = $post['order_id'];

        }

        if (isset($post['searchcustomer_id']) && $post['searchcustomer_id'] != "") {
            $getcustomer_id = $this->db->select("id")->get_where("tb_customers",
                ['code' => $post['searchcustomer_id']]);
            if ($getcustomer_id->num_rows() > 0) {
                $whr['o.customer_id'] = $getcustomer_id->row()->id;
            }
        }

        if (isset($post['custcode']) && $post['custcode'] != "") {
            $getcustomer_id = $this->db->select("id")->get_where("tb_customers", ['code' => $post['custcode']]);
            if ($getcustomer_id->num_rows() > 0) {
                $whr['o.customer_id'] = $getcustomer_id->row()->id;
            }
        }

        if (isset($post['service']) && $post['service'] != "") {
            $whr['d.service'] = $post['service'];

        }

        if (isset($post['order_type']) && $post['order_type'] != "") {
            $whr['d.order_type'] = $post['order_type'];

        }

        if (isset($post['product']) && $post['product'] != "") {
            $whr['o.product'] = $post['product'];

        }

        if (isset($post['modeof_trasnport']) && $post['modeof_trasnport'] != "") {
            $whr['o.transport_mode'] = $post['modeof_trasnport'];

        }

        if (isset($post['searchshipper_id']) && $post['searchshipper_id'] != "") {
            $whr['o.pickup_custid'] = $post['searchshipper_id'];

        }

        if (isset($post['searchconsignee_id']) && $post['searchconsignee_id'] != "") {
            $whr['o.drop_custid'] = $post['searchconsignee_id'];

        }

        if (isset($post['delivery_note']) && $post['delivery_note'] != "") {
            $ref_whr = ['refid' => 'DQ', 'refvals' => $post['delivery_note']];
            $getordids = $this->common->getordids($ref_whr);

            if (!empty($getordids)) {
                foreach ($getordids as $key => $getordid){
                    $whr['ordids'][] = $getordid['order_id'];
                }
            }
        }
        if (isset($post['purchase_order']) && $post['purchase_order'] != "") {
            $ref_whr = ['refid' => 'PO', 'refvals' => $post['purchase_order']];
            $getordids = $this->common->getordids($ref_whr);

            if (!empty($getordids)) {
                foreach ($getordids as $key => $getordid){
                    $whr['ordids'][] = $getordid['order_id'];
                }
            }
        }

        if (isset($post['company_code']) && $post['company_code'] != "") {
            $whr['o.company_code'] = $post['company_code'];

        }
        if (isset($post['branch_code']) && $post['branch_code'] != "") {
            $whr['o.branch_code'] = $post['branch_code'];

        }
        return $whr;
    }

    public function ajaxListing()
    {
        $this->load->model('DataArrayFormatter_model');
        $this->load->model('DataQueryFormatter_model');
        $this->load->model('Datatables_model');

        $wherecondition = '';
        $draw = $this->input->post('draw', true);
        $post = $this->input->post('data', true);

        $userid = $this->session->userdata("user_id");
        $custid = $this->session->userdata("cust_id");

        $whr = $this->searchsubmitdata($post);

        $order_status = isset($post['status']) ? $post['status'] : "";
        $ad_orderstatus = isset($post['order_status']) ? $post['order_status'] : "";
        $status_search = $order_status;

        if ($status_search == "") {
            $status_search = $ad_orderstatus;
        }

        $subcusts = [];
        $role_id = $this->session->userdata('user_role_id');

        if ($role_id == "4") {
            if ($this->session->userdata('sub_cust')) {
                $subcusts = $this->session->userdata('sub_cust');

                if (!empty($subcusts)) {
                    array_push($subcusts, $custid);
                }
            }
        }

        $searchids = [];

        if (isset($post['bookingid']) && $post['bookingid'] != "") {
            $searchids = $post['bookingid'] ?? [];
        }

        $whereArray = $ordids = [];

        if (isset($whr['ordids'])) {
            if (!empty($whr['ordids'])) {
                $ordids = $whr['ordids'];
            }
        }

        unset($whr['ordids']);

        if (!empty($whr) && sizeof($whr) > 0) {
            foreach ($whr as $key => $value){
                $value = "'$value'";

                if ($key == "DATE_FORMAT(o.createdon,'%Y-%m-%d') >=" || $key == "DATE_FORMAT(o.createdon,'%Y-%m-%d') <=" || $key == "DATE_FORMAT(o.pickup_datetime,'%Y-%m-%d') >=" || $key == "DATE_FORMAT(o.pickup_datetime,'%Y-%m-%d') <=") {
                    $whereArray[] = $key . $value;
                } else {
                    $whereArray[] = $key . ' = ' . $value;
                }
            }
        }

        if (!empty($whereArray) && sizeof($whereArray) > 0) {
            $wherecondition .= 'AND ' . implode(' AND ', $whereArray);
        }

        if (!empty($searchids)) {
            $tempSearchId = '';

            if (!empty($searchids) && sizeof($searchids) > 0) {
                foreach ($searchids as $eachSearchKey){
                    $tempSearchId .= $this->db->escape($eachSearchKey) . ",";
                }
            }

            $tempSearchId = trim($tempSearchId, ',');

            if ($tempSearchId != '') {
                $wherecondition .= " and o.order_id in ($tempSearchId) ";
            }
        }

        if (!empty($ordids)) {
            if (!empty($ordids) && sizeof($ordids) > 0) {
                $searchordids = implode("','", $ordids);
                $wherecondition .= " AND o.id IN('" . $searchordids . "')";
            }
        }

        if ($userid != '0') {
            if (!empty($countryuids)) {
                $tempCountryId = implode(',', $countryuids);
                $wherecondition .= " and o.user_id in ($tempCountryId) ";
            } else {
                $wherecondition .= "  and o.user_id = " . $this->db->escape($userid) . " ";
            }
        }

        $searchsts = $status_search;

        if ($searchsts == 'PENDING') {
            $wherecondition .= " and o.trip_id = 0 ";
        }

        if ($searchsts == 'ACTIVE') {
            $wherecondition .= " and o.trip_id != 0  and  o.trip_sts=0 ";
        }

        if ($searchsts == 'CLOSED') {
            $wherecondition .= " and o.trip_id != 0  and  o.trip_sts = 1 ";
        }

        if (!empty($subcusts)) {
            $tempSubCusts = implode(',', $subcusts);
            if ($tempSubCusts != '') {
                $wherecondition .= " and o.customer_id in ($tempSubCusts) ";
            }
        } else {
            if ($custid != "") {
                $wherecondition .= " and o.customer_id = " . $this->db->escape($custid) . " ";
            }
        }

        if (($post['shipper_name'] ?? "") != '' || ($post['consignee_name'] ?? "") != '') {
            $shipper_name_cond = $this->db->escape($post['shipper_name']);
            $consignee_name_cond = $this->db->escape($post['consignee_name']);

            if ($consignee_name_cond != '') {
                $wherecondition .= " and o.delivery_company like '%$consignee_name_cond%' ";
            }
            if ($shipper_name_cond != '') {
                $wherecondition .= " and o.pickup_company like '%$shipper_name_cond%' ";
            }
        }

        $countQuery = "select count(o.id) as count from tb_orders o left join tb_order_details d on d.order_row_id=o.id where o.status!=0  $wherecondition ";
        $countQueryResult = $this->db->query($countQuery);

        $rowCount = $countQueryResult->result();
        $totalRecords = $rowCount[0]->count ?? 0;

        $selectColumns = [
            'o.id',
            'o.order_id',
            'o.pickup_datetime',
            'o.delivery_datetime',
            'o.pickup_company',
            'o.delivery_company',
            'o.transport_mode',
            'o.company_code',
            'o.branch_code',
            'o.shipment_id',
            'o.status',
            'o.order_status',
            'o.trip_sts',
            'o.shift_id',
            'o.trip_id',
            'o.shipmentid',
            'o.createdon',
            'o.pickup_address1',
            'o.delivery_address1',
            'o.pickup_country',
            'o.pickup_city',
            'o.delivery_city',
            'o.pickup_pincode',
            'o.delivery_country',
            'o.delivery_pincode',
            'o.pickup_address2',
            'o.delivery_address2',
            'o.vendor_id',
            'o.goods_value',
            'o.product',
            'o.customer_id',
            'd.delivery_note',
            'd.department_code',
            'd.service',
            'd.incoterm',
            'd.delivery_term',
            'd.order_type',
            'd.purchase_order',
            'd.docs_received_datetime',
            'd.docs_sent_datetime',
            'v.name as vendor_name',
            'smas.name as name_of_service',
            'ot.type_name as order_type_name',
            'dt.name as delivery_term_name'
        ];

        $table_name = 'tb_orders o';
        $indexColumn = 'o.id';
        $groupBy = 'o.id';
        $excludeCountQuery = 'Yes';

        $joinsArray[] = [
            'table_name' => 'tb_order_details as d',
            'condition' => "o.id=d.order_row_id",
            'join_type' => 'left'
        ];
        $joinsArray[] = ['table_name' => 'tb_vendors as v', 'condition' => "v.id=o.id", 'join_type' => 'left'];
        $joinsArray[] = [
            'table_name' => 'tb_service_master as smas',
            'condition' => "smas.id=d.service and smas.status=1",
            'join_type' => 'left'
        ];
        $joinsArray[] = [
            'table_name' => 'tb_order_types as ot',
            'condition' => "ot.id=d.order_type and  ot.company_code=o.company_code and  ot.status=1",
            'join_type' => 'left'
        ];
        $joinsArray[] = [
            'table_name' => 'tb_delivery_terms as dt',
            'condition' => "dt.term_id=d.delivery_term",
            'join_type' => 'left'
        ];


        $wherecondition = $indexColumn . "!='' " . $wherecondition;
        $recordsFiltered = $totalRecords;

        $dataTableSortOrdering = [];
        
        $getRecordListing = $this->Datatables_model->datatablesQuery($selectColumns, $dataTableSortOrdering,
            $table_name, $joinsArray, $wherecondition, $indexColumn, 'TRUE', $groupBy, $excludeCountQuery, 'POST');

        $reqData = ['id', 'order_id', 'shift_id', 'customer_id'];
        $this->db->query('SET SESSION  group_concat_max_len=10240');
        $formattedData = $this->DataArrayFormatter_model->getCommaSeparatedFields($reqData, $getRecordListing['data']);

        if (isset($formattedData['commaSeparated']['id']) && $formattedData['commaSeparated']['id'] != '') {
            $formattedData = $this->DataQueryFormatter_model->getRevenueDetails($formattedData['commaSeparated']['id'], $formattedData);
            $formattedData = $this->DataQueryFormatter_model->getOrderReferences($formattedData['commaSeparated']['id'], $formattedData);
            $formattedData = $this->DataQueryFormatter_model->getPartyDetails($formattedData['commaSeparated']['id'], $formattedData);
            $formattedData = $this->DataQueryFormatter_model->getValueAddedServices($formattedData['commaSeparated']['id'], $formattedData);
            $formattedData = $this->DataQueryFormatter_model->getBillDetails($formattedData['commaSeparated']['id'], $formattedData);
            $formattedData = $this->DataQueryFormatter_model->getCompleteOrderCargoDetails($formattedData['commaSeparated']['id'], $formattedData);
            $formattedData = $this->DataQueryFormatter_model->getChargeInfo($formattedData['commaSeparated']['id'], $formattedData);
            $formattedData = $this->DataQueryFormatter_model->getPODDelivered($formattedData['commaSeparated']['id'], $formattedData);
        }

        if (isset($formattedData['commaSeparated']['customer_id']) && $formattedData['commaSeparated']['customer_id'] != '') {
            $customerDetailsArray = $this->DataQueryFormatter_model->getCustomerDetails($formattedData['commaSeparated']['customer_id']);
        }

        if (isset($formattedData['commaSeparated']['order_id']) && $formattedData['commaSeparated']['order_id'] != '') {
            $statusDatesArray = $this->DataQueryFormatter_model->getStatusDates($formattedData['commaSeparated']['order_id']);
        }

        if (isset($formattedData['commaSeparated']['shift_id']) && $formattedData['commaSeparated']['shift_id'] != '') {
            $tripInfoArray = $this->DataQueryFormatter_model->getTripInfo($formattedData['commaSeparated']['shift_id']);
            $genericStatusArray = $this->DataQueryFormatter_model->getStopStatusGenericAllround($formattedData['commaSeparated']['shift_id']);
            $driverAcceptanceArray = $this->DataQueryFormatter_model->getDriverAcceptance($formattedData['commaSeparated']['shift_id']);
        }

        if (isset($formattedData['orders'])) {
            $getRecordListing = $formattedData['orders'];
            krsort($getRecordListing);
        } else {
            $getRecordListing = [];
        }
        
        $i = 0;
        
        foreach ($getRecordListing as $res) {
            $undefinedVariables = [
                'vendor_name',
                'revenue_order_count',
                'partydetails_id',
                'partydetails_party_type_id',
                'partydetails_name',
                'partydetails_mobile',
                'partydetails_email',
                'partydetails_code',
                'partydetails_customeridentifier',
                'partydetails_house_number',
                'partydetails_fax',
                'partydetails_acon_debitor_code',
                'partydetails_kn_login_account',
                'partydetails_vat_reg_no',
                'partydetails_tax_payer_no',
                'partydetails_contract_no',
                'partydetails_contract_date',
                'partydetails_party_type',
                'partydetails_party_type_name',
                'pickup',
                'delivery',
                'reference_value',
                'status_details',
                'docs_received_datetime',
                'docs_sent_datetime',
                'chargedetails_type',
                'chargedetails_chargecode',
                'chargedetails_chargecodename',
                'chargedetails_quantity_unit',
                'chargedetails_value',
                'chargedetails_rate_id',
                'chargedetails_amount',
                'chargedetails_currency',
                'chargedetails_vat_percentage',
                'chargedetails_vat_amount',
                'revenue_details',
                'vas_details',
                'name_of_service',
                'order_type_name',
                'delivery_term_name',
                'pod_available',
                'driver_acceptance_date',
                'payer_id',
                'payer_name',
                'payer_cid',
                'payer_acondebtorcode',
                'payer_kn_login_account',
                'payer_vat_regno',
                'payer_tax_payerid',
                'payer_steeet_house',
                'payer_postal',
                'payer_country',
                'payer_phone',
                'payer_email',
                'cargo_total_quantity',
                'cargo_total_package_type',
                'cargo_total_length',
                'cargo_total_length_unit',
                'cargo_total_width',
                'cargo_total_width_unit',
                'cargo_total_height',
                'cargo_total_height_unit',
                'cargo_total_second_weight',
                'cargo_total_weight_unit',
                'cargo_total_second_volume',
                'cargo_total_volume_unit',
                'cargo_total_ldm',
                'cargo_total_volumetric_weight',
                'cargo_total_volweight_uom',
                'cargo_total_stackable',
                'cargo_total_dg_goods',
                'carg_total_weight',
                'cargo_total_weight_unit',
                'cargo_total_volume',
                'cargo_total_volume_unit'
            ];

            foreach ($undefinedVariables as $eachVar) {
                if (!isset($res[$eachVar])) {
                    $res[$eachVar] = '';
                }
            }

            $delivery_note = $purchase_order = "";
            $trip_no = $res['shipmentid'] ?? 0;

            if ($trip_no == '0') {
                $trip_no = "";
            }

            $early_pickup = $res['pickup_datetime'] ?? '';
            $early_delivery = $res['delivery_datetime'] ?? '';
            $curtz = $this->session->userdata("usr_tzone")['timezone'];

            if ($early_pickup != "" && $early_pickup != "0000-00-00 00:00:00") {
                $epickup = getdatetimebytimezone($curtz, $early_pickup, DFLT_TZ);
                $early_pickup = $epickup['datetime'];
            }

            if ($early_delivery != "" && $early_delivery != "0000-00-00 00:00:00") {
                $edelivery = getdatetimebytimezone($curtz, $early_delivery, DFLT_TZ);
                $early_delivery = $edelivery['datetime'];
            }

            if ($res['partydetails_id'] != '') {
                $PartyArray = [
                    $res['partydetails_id'],
                    $res['partydetails_party_type_id'],
                    $res['partydetails_name'],
                    $res['partydetails_mobile'],
                    $res['partydetails_email'],
                    $res['partydetails_code'],
                    $res['partydetails_customeridentifier'],
                    $res['partydetails_house_number'],
                    $res['partydetails_fax'],
                    $res['partydetails_acon_debitor_code'],
                    $res['partydetails_kn_login_account'],
                    $res['partydetails_vat_reg_no'],
                    $res['partydetails_tax_payer_no'],
                    $res['partydetails_contract_no'],
                    $res['partydetails_contract_date'],
                    $res['partydetails_party_type'],
                    $res['partydetails_party_type_name']
                ];
                
                $getpartydetails = $this->DataArrayFormatter_model->buildGenericArray($PartyArray);
            }

            $customer_details = $drop_details = $shipper_details = [
                'id' => "",
                'name' => "",
                'phone' => "",
                'email' => "",
                'fax' => "",
                'code' => "",
                'street' => "",
                'state' => "",
                'city' => "",
                'country' => "",
                'pincode' => "",
                'acon' => "",
                'kn_login' => "",
                'vat_reg_no' => "",
                'tax_payer_no' => "",
                'contract_no' => "",
                'contract_date' => ""
            ];
            $notify_address['name'] = "Notify Party";

            if (!empty($getpartydetails)) {
                foreach ($getpartydetails as $rr){
                    if (!isset($rr['customeridentifier'])) {
                        $rr['customeridentifier'] = '';
                    }
                    if (!isset($rr['name'])) {
                        $rr['name'] = '';
                    }
                    if (!isset($rr['mobile'])) {
                        $rr['mobile'] = '';
                    }
                    if (!isset($rr['email'])) {
                        $rr['email'] = '';
                    }
                    if (!isset($rr['fax'])) {
                        $rr['fax'] = '';
                    }
                    if (!isset($rr['code'])) {
                        $rr['code'] = '';
                    }
                    if (!isset($rr['acon_debitor_code'])) {
                        $rr['acon_debitor_code'] = '';
                    }
                    if (!isset($rr['kn_login_account'])) {
                        $rr['kn_login_account'] = '';
                    }
                    if (!isset($rr['vat_reg_no'])) {
                        $rr['vat_reg_no'] = '';
                    }
                    if (!isset($rr['house_number'])) {
                        $rr['house_number'] = '';
                    }
                    if (!isset($rr['contract_no'])) {
                        $rr['contract_no'] = '';
                    }
                    if (!isset($rr['contract_date'])) {
                        $rr['contract_date'] = '';
                    }
                    if (!isset($rr['tax_payer_no'])) {
                        $rr['tax_payer_no'] = '';
                    }
                    if (!isset($rr['party_type_id'])) {
                        $rr['party_type_id'] = '';
                    }

                    if ($rr['party_type_name'] != '') {
                        if ($rr['party_type_name'] == "Consignee") {
                            $drop_details = [
                                'id' => $rr['customeridentifier'],
                                'name' => $rr['name'],
                                'phone' => $rr['mobile'],
                                'email' => $rr['email'],
                                'fax' => $rr['fax'],
                                'code' => $rr['code'],
                                'acon' => $rr['acon_debitor_code'],
                                'kn_login' => $rr['kn_login_account'],
                                'vat_reg_no' => $rr['vat_reg_no'],
                                'tax_payer_no' => $rr['tax_payer_no'],
                                'contract_no' => $rr['contract_no'],
                                'contract_date' => $rr['contract_date'],
                                'house_number' => $rr['house_number']
                            ];
                        }
                        if ($rr['party_type_name'] == "Shipper") {
                            $shipper_details = [
                                'id' => $rr['customeridentifier'],
                                'name' => $rr['name'],
                                'phone' => $rr['mobile'],
                                'email' => $rr['email'],
                                'fax' => $rr['fax'],
                                'code' => $rr['code'],
                                'acon' => $rr['acon_debitor_code'],
                                'kn_login' => $rr['kn_login_account'],
                                'vat_reg_no' => $rr['vat_reg_no'],
                                'tax_payer_no' => $rr['tax_payer_no'],
                                'contract_no' => $rr['contract_no'],
                                'contract_date' => $rr['contract_date'],
                                'house_number' => $rr['house_number']
                            ];
                        }
                    }
                    if ($rr['party_type_name'] == 'NOTIFY_PARTY') {
                        $notify_address['name'] = $rr['name'];
                    }
                }
            }

            /*Shipper ACON Debitor Code	Shipper KN Login Account	Shipper VAT Registration Number	Shipper Tax Payer ID*/
            #########################################
            if (isset($res['pickup'])) {
                $shipper_details['name'] = $res['pickup'];
            }
            ###########################################
            $shipper_details['street'] = $res['pickup_address1'] ?? '';
            
            if (isset($shipper_details['house_number'])) {
                if ($shipper_details['house_number'] != "") {
                    $shipper_details['street'] .= $shipper_details['house_number'];
                }
            }
            $shipper_details['state'] = $res['pickup_address2'] ?? '';
            $shipper_details['city'] = $res['pickup_city'] ?? '';
            $shipper_details['country'] = $res['pickup_country'] ?? '';
            $shipper_details['pincode'] = $res['pickup_pincode'] ?? '';
            ##########################################
            if (isset($res['delivery'])) {
                $drop_details['name'] = $res['delivery'] ?? '';
            }
            #############################################
            $drop_details['street'] = $res['delivery_address1'] ?? '';
            if (isset($drop_details['house_number'])) {
                if ($drop_details['house_number'] != "") {
                    $drop_details['street'] .= $drop_details['house_number'];
                }
            }
            $drop_details['state'] = $res['delivery_address2'] ?? '';
            $drop_details['city'] = $res['delivery_city'] ?? '';
            $drop_details['country'] = $res['delivery_country'] ?? '';
            $drop_details['pincode'] = $res['delivery_pincode'] ?? '';

            if (($res['customer_id'] ?? 0) > 0) {
                if (isset($res['customer_id'])) {
                    $customerIndex = $res['customer_id'] ?? '';
                    if (isset($customerDetailsArray[$customerIndex])) {
                        if ($customerDetailsArray[$customerIndex]['cust_contract_date'] == "0000-00-00") {
                            $customerDetailsArray[$customerIndex]['cust_contract_date'] = '';
                        }

                        $street = $customerDetailsArray[$customerIndex]['cust_street'] ?? '';

                        if ($customerDetailsArray[$customerIndex]['cust_house_number'] != "") {
                            $street .= $customerDetailsArray[$customerIndex]['cust_house_number'] ?? '';
                        }

                        $customer_details = [
                            'id' => $customerDetailsArray[$customerIndex]['cust_customeridentifier'] ?? '',
                            'name' => $customerDetailsArray[$customerIndex]['cust_name'] ?? '',
                            'phone' => $customerDetailsArray[$customerIndex]['cust_mobile'] ?? '',
                            'email' => $customerDetailsArray[$customerIndex]['cust_email'] ?? '',
                            'fax' => $customerDetailsArray[$customerIndex]['cust_fax'] ?? '',
                            'code' => $customerDetailsArray[$customerIndex]['cust_code'] ?? '',
                            'street' => $street,
                            'state' => $customerDetailsArray[$customerIndex]['cust_state'] ?? '',
                            'city' => $customerDetailsArray[$customerIndex]['cust_location_id'] ?? '',
                            'country' => $customerDetailsArray[$customerIndex]['cust_country'] ?? '',
                            'pincode' => $customerDetailsArray[$customerIndex]['cust_pincode'] ?? '',
                            'acon' => $customerDetailsArray[$customerIndex]['cust_acon_debitor_code'] ?? '',
                            'kn_login' => $customerDetailsArray[$customerIndex]['cust_kn_login_account'] ?? '',
                            'vat_reg_no' => $customerDetailsArray[$customerIndex]['cust_vat_reg_no'] ?? '',
                            'tax_payer_no' => $customerDetailsArray[$customerIndex]['cust_tax_payer_no'] ?? '',
                            'contract_no' => $customerDetailsArray[$customerIndex]['cust_contract_no'] ?? '',
                            'contract_date' => $customerDetailsArray[$customerIndex]['cust_contract_date'] ?? ''
                        ];
                    }
                }
            }

            if (isset($res['reference_value'])) {
                if ($res['reference_value'] != '') {
                    $arrayData = $this->DataArrayFormatter_model->formatGenericParameters($res['reference_value'] ?? '', 'REFERENCE');
                }
            }

            $ref_1_name = $ref_1_description = $ref_1_value = $ref_2_name = $ref_2_description = $ref_2_value = $ref_3_name = $ref_3_description = $ref_3_value = $ref_4_name = $ref_4_description = $ref_4_value = $ref_5_name = $ref_5_description = $ref_5_value = $ruck_val = $rucksn_val = "";

            if (!empty($arrayData)) {
                $ctr = 1;
                $ref_id = '';
                foreach ($arrayData as $ref){
                    if (isset($ref['reference_id'])) {
                        $ref_id = $ref['reference_id'];
                    }

                    if (!in_array($ref_id, ['ORD_DLVINST', 'ORD_PIKINST', 'DQ', 'PO'])) {
                        if ($ctr == 1) {
                            $ref_1_name = $ref_id;
                            if (isset($ref['description'])) {
                                $ref_1_description = $ref['description'];
                            }
                            if (isset($ref['ref_value'])) {
                                $ref_1_value = $ref['ref_value'];
                            }
                        } else {
                            if ($ctr == 2) {
                                $ref_2_name = $ref_id;
                                if (isset($ref['description'])) {
                                    $ref_2_description = $ref['description'];
                                }
                                if (isset($ref['ref_value'])) {
                                    $ref_2_value = $ref['ref_value'];
                                }

                            } else {
                                if ($ctr == 3) {
                                    $ref_3_name = $ref_id;
                                    if (isset($ref['description'])) {
                                        $ref_3_description = $ref['description'];
                                    }
                                    if (isset($ref['ref_value'])) {
                                        $ref_3_value = $ref['ref_value'];
                                    }

                                } else {
                                    if ($ctr == 4) {
                                        $ref_4_name = $ref_id;
                                        if (isset($ref['description'])) {
                                            $ref_4_description = $ref['description'];
                                        }
                                        if (isset($ref['ref_value'])) {
                                            $ref_4_value = $ref['ref_value'];
                                        }
                                    } elseif ($ctr == 5) {
                                        $ref_5_name = $ref_id;
                                        if (isset($ref['description'])) {
                                            $ref_5_description = $ref['description'];
                                        }
                                        if (isset($ref['ref_value'])) {
                                            $ref_5_value = $ref['ref_value'];
                                        }
                                    }
                                }
                            }
                        }
                        $ctr++;
                    }
                    if ($ref_id == 'DQ') {
                        if (isset($ref['ref_value'])) {
                            $delivery_note = $ref['ref_value'];
                        }
                    }
                    if ($ref_id == 'PO') {
                        if (isset($ref['ref_value'])) {
                            $purchase_order = $ref['ref_value'];
                        }
                    }
                }
            }

            $getstatusdates = array('statuspickupdate' => "", 'statusdeliverydate' => "");

            $res['status_details'] = '';
            
            if (isset($res['order_id'])) {
                $orderIndex = $res['order_id'] ?? '';
                
                if (isset($statusDatesArray[$orderIndex])) {
                    $res['status_details'] = $statusDatesArray[$orderIndex]['status_details'] ?? '';
                }
            }

            if ($res['status_details'] != '') {
                $statusArrayData = $this->DataArrayFormatter_model->formatGenericParameters($res['status_details'] ?? '');
                $zonecode = $this->session->userdata("usr_tzone");
                $curtz = $zonecode['timezone'] ?? '';

                if (!empty($statusArrayData)) {
                    foreach ($statusArrayData as $eachRow){
                        if ($eachRow['stop_type'] == "P") {
                            if ($eachRow['createdon'] != "") {
                                $getactualStatus = getdatetimebytimezone($curtz, $eachRow['createdon'], DFLT_TZ);
                                if (isset($getactualStatus['datetime'])) {
                                    $getstatusdates['statuspickupdate'] = $getactualStatus['datetime'];
                                }
                            }
                        }
                        if ($eachRow['stop_type'] == "D") {
                            if ($eachRow['createdon'] != "") {
                                $getactualStatus = getdatetimebytimezone($curtz, $eachRow['createdon'], DFLT_TZ);
                                if (isset($getactualStatus['datetime'])) {
                                    $getstatusdates['statusdeliverydate'] = $getactualStatus['datetime'];
                                }
                            }
                        }
                    }
                }
            }

            $docs_received_datetime = $res['docs_received_datetime'];
            if ($docs_received_datetime != "" && $docs_received_datetime != null) {
                $getactual = getdatetimebytimezone($curtz, $docs_received_datetime, DFLT_TZ);

                if (isset($getactual['datetime'])) {
                    $docs_received_datetime = $getactual['datetime'];
                }

            }
            $docs_sent_datetime = $res['docs_sent_datetime'];
            if ($docs_sent_datetime != "" && $docs_sent_datetime != null) {
                $getactual = getdatetimebytimezone($curtz, $docs_sent_datetime, DFLT_TZ);
                $docs_sent_datetime = $getactual['datetime'];
            }

            $shiftIndex = $res['shift_id'] ?? 0;
            $vehicle_type = $trailer_no = $register_number = '';
            $res['supplier_id'] = $res['suppier_name'] = $res['suppier_steeet_house'] = $res['suppier_postalcode'] = $res['suppier_country'] = $res['suppier_phone'] = $res['suppier_email'] = '';
            $driver_name = $driver_licence_number = '';

            if (isset($tripInfoArray[$shiftIndex])) {
                $vehicle_type = $tripInfoArray[$shiftIndex]['vehicle_type'];
                $trailer_no = $tripInfoArray[$shiftIndex]['trailer_no'];
                $register_number = $tripInfoArray[$shiftIndex]['register_number'];

                if ($res['trip_id'] > 0) {
                    $driver_name = $tripInfoArray[$shiftIndex]['driver_name'];
                    $driver_licence_number = $tripInfoArray[$shiftIndex]['driver_licence_number'];
                }

                $res['supplier_id'] = $tripInfoArray[$shiftIndex]['supplier_id'] ?? 0;
                $res['suppier_name'] = $tripInfoArray[$shiftIndex]['suppier_name'] ?? '';
                $res['suppier_steeet_house'] = $tripInfoArray[$shiftIndex]['suppier_steeet_house'] ?? '';
                $res['suppier_postalcode'] = $tripInfoArray[$shiftIndex]['suppier_postalcode'] ?? '';
                $res['suppier_country'] = $tripInfoArray[$shiftIndex]['suppier_country'] ?? '';
                $res['suppier_phone'] = $tripInfoArray[$shiftIndex]['suppier_phone'] ?? '';
                $res['suppier_email'] = $tripInfoArray[$shiftIndex]['suppier_email'] ?? '';
            }

            $getcharge = $getcostcharge = [
                'chargecode' => '',
                'chargecodename' => '',
                'quantity' => '',
                'value' => '',
                'rate_id' => '',
                'amount' => '',
                'currency' => '',
                'vat_percentage' => '',
                'vat_amount' => ''
            ];
            $amt = $vatamt = $cost_amt = $cost_vatamt = 0;
            $currency = $cost_currency = '';
            $chargecode = $chargecodename = $quantity = $value = $rate_id = $amount = $vat_percentage = $vat_amount = [];
            $cost_chargecode = $cost_chargecodename = $cost_quantity = $cost_value = $cost_rate_id = $cost_amount = $cost_vat_percentage = $cost_vat_amount = [];

            if ($res['chargedetails_type'] != '') {
                $chagDetailsArray = [
                    $res['chargedetails_type'] ?? '',
                    $res['chargedetails_chargecode'] ?? '',
                    $res['chargedetails_chargecodename'] ?? '',
                    $res['chargedetails_quantity_unit'] ?? '',
                    $res['chargedetails_value'] ?? '',
                    $res['chargedetails_rate_id'] ?? '',
                    $res['chargedetails_amount'] ?? 0,
                    $res['chargedetails_currency'] ?? '',
                    $res['chargedetails_vat_percentage'] ?? 0,
                    $res['chargedetails_vat_amount'] ?? 0,
                ];

                $getchargeData = $this->DataArrayFormatter_model->buildGenericArray($chagDetailsArray);

                if (!empty($getchargeData)) {
                    foreach ($getchargeData as $getcharge){
                        if (!isset($getcharge['vat_amount']) || $getcharge['vat_amount'] == '') {
                            $getcharge['vat_amount'] = 0;
                        }
                        if (!isset($getcharge['amount']) || $getcharge['amount'] == '') {
                            $getcharge['amount'] = 0;
                        }
                        if (isset($getcharge['type'])) {
                            if ($getcharge['type'] == '0') {
                                if (isset($getcharge['charge_code'])) {
                                    $chargecode[] = $getcharge['charge_code'];
                                }
                                if (isset($getcharge['name'])) {
                                    $chargecodename[] = $getcharge['name'];
                                }
                                if (isset($getcharge['quantity_unit'])) {
                                    $quantity[] = $getcharge['quantity_unit'];
                                }
                                if (isset($getcharge['value'])) {
                                    $value[] = $getcharge['value'];
                                }
                                if (isset($getcharge['rate_id'])) {
                                    $rate_id[] = $getcharge['rate_id'];
                                }
                                if (isset($getcharge['amount'])) {
                                    $amount[] = $getcharge['amount'];
                                }
                                if (isset($getcharge['currency'])) {
                                    $currency = $getcharge['currency'];
                                }
                                if (isset($getcharge['vat_percentage'])) {
                                    $vat_percentage[] = $getcharge['vat_percentage'];
                                }
                                if (isset($getcharge['vat_amount'])) {
                                    $vat_amount[] = $getcharge['vat_amount'];
                                }
                                if (isset($getcharge['amount'])) {
                                    if ($getcharge['amount'] > 0) {
                                        $amt += $getcharge['amount'];
                                    }
                                }
                                if (isset($getcharge['vat_amount'])) {
                                    if ($getcharge['vat_amount'] > 0) {
                                        $vatamt += $getcharge['vat_amount'];
                                    }
                                }
                            } else {
                                if ($getcharge['type'] == '1') {
                                    if (isset($getcharge['charge_code'])) {
                                        $cost_chargecode[] = $getcharge['charge_code'];
                                    }
                                    if (isset($getcharge['name'])) {
                                        $cost_chargecodename[] = $getcharge['name'];
                                    }
                                    if (isset($getcharge['quantity_unit'])) {
                                        $cost_quantity[] = $getcharge['quantity_unit'];
                                    }
                                    if (isset($getcharge['value'])) {
                                        $cost_value[] = $getcharge['value'];
                                    }
                                    if (isset($getcharge['rate_id'])) {
                                        $cost_rate_id[] = $getcharge['rate_id'];
                                    }
                                    if (isset($getcharge['amount'])) {
                                        $cost_amount[] = $getcharge['amount'];
                                    }
                                    if (isset($getcharge['currency'])) {
                                        $cost_currency = $getcharge['currency'];
                                    }
                                    if (isset($getcharge['vat_percentage'])) {
                                        $cost_vat_percentage[] = $getcharge['vat_percentage'];
                                    }
                                    if (isset($getcharge['vat_amount'])) {
                                        $cost_vat_amount[] = $getcharge['vat_amount'];
                                    }
                                    if (isset($getcharge['amount'])) {
                                        if ($getcharge['amount'] > 0) {
                                            $cost_amt += $getcharge['amount'];
                                        }
                                    }
                                    if (isset($getcharge['vat_amount'])) {
                                        if ($getcharge['vat_amount'] > 0) {
                                            $cost_vatamt += $getcharge['vat_amount'];
                                        }
                                    }
                                }
                            }
                        }

                    }

                    $getcharge = [
                        'chargecode' => implode(',', $chargecode),
                        'chargecodename' => implode(',', $chargecodename),
                        'quantity' => implode(',', $quantity),
                        'value' => implode(',', $value),
                        'rate_id' => implode(',', $rate_id),
                        'amount' => $amt,
                        'currency' => $currency,
                        'vat_percentage' => implode(',', $vat_percentage),
                        'vat_amount' => $vatamt
                    ];
                    $getcostcharge = [
                        'chargecode' => implode(',', $cost_chargecode),
                        'chargecodename' => implode(',', $cost_chargecodename),
                        'quantity' => implode(',', $cost_quantity),
                        'value' => implode(',', $cost_value),
                        'rate_id' => implode(',', $cost_rate_id),
                        'amount' => $cost_amt,
                        'currency' => $cost_currency,
                        'vat_percentage' => implode(',', $cost_vat_percentage),
                        'vat_amount' => $cost_vatamt
                    ];
                }
            }

            $invoiced_bu_jfr = $billed_bu_jfr = '';
            $revenueDataArray = [];

            if (($res['revenue_details'] ?? '') != '') {
                $getRevenueData = $this->DataArrayFormatter_model->formatGenericParameters($res['revenue_details'],
                    'REVENUE');

                foreach ($getRevenueData as $eachData){
                    if (isset($eachData['type'])) {
                        $revDataIndex = $eachData['type'];

                        if ($eachData['type'] == '0' && $eachData['recipient_role'] != 'Internal BU') {
                            if (array_key_exists('0', $revenueDataArray)) {
                                //do nothing
                            } else {
                                $revenueDataArray[$revDataIndex] = $eachData;
                            }
                        } else {
                            if ($eachData['type'] == '1' && $eachData['recipient_role'] != 'Internal BU') {
                                if (array_key_exists('1', $revenueDataArray)) {
                                    //do nothing
                                } else {
                                    $revenueDataArray[$revDataIndex] = $eachData;
                                }
                            }
                        }

                        if ($eachData['recipient_role'] == 'Internal BU') {
                            if ($eachData['type'] == '0') {
                                $invoiced_bu_jfr = $eachData['bu_jfr'];
                            } else {
                                if ($eachData['type'] == '1') {
                                    $billed_bu_jfr = $eachData['bu_jfr'];
                                }
                            }
                        }

                    }
                }
            }

            $rev_foreign_currency = $rev_debtor_jfr = $rev_exchange_rate = $rev_invoiceno = $rev_invoicedate = $rev_creditnote = $rev_invoice_creation_date = $rev_invoice_receivdon_date = $rev_invoice_status = '';
            $cost_foreign_currency = $cost_debtor_jfr = $cost_exchange_rate = $cost_invoice_status = '';

            if (isset($revenueDataArray[0])) {
                if (isset($revenueDataArray[0]['foreign_currency'])) {
                    $rev_foreign_currency = $revenueDataArray[0]['foreign_currency'];
                }
                if (isset($revenueDataArray[0]['debtor_jfr'])) {
                    $rev_debtor_jfr = $revenueDataArray[0]['debtor_jfr'];
                }
                if (isset($revenueDataArray[0]['exchange_rate'])) {
                    $rev_exchange_rate = $revenueDataArray[0]['exchange_rate'];
                }
                if (isset($revenueDataArray[0]['invoice_number'])) {
                    $rev_invoiceno = $revenueDataArray[0]['invoice_number'];
                }
                if (isset($revenueDataArray[0]['invoice_date'])) {
                    if ($revenueDataArray[0]['invoice_date'] != "0000-00-00 00:00:00") {
                        $rev_invoicedate = $revenueDataArray[0]['invoice_date'];
                    }
                }
                if (isset($revenueDataArray[0]['credit_note_number'])) {
                    $rev_creditnote = $revenueDataArray[0]['credit_note_number'];
                }
                if (isset($revenueDataArray[0]['invoice_creation_date'])) {
                    if ($revenueDataArray[0]['invoice_creation_date'] != "0000-00-00 00:00:00") {
                        $rev_invoice_creation_date = $revenueDataArray[0]['invoice_creation_date'];
                    }
                }
                if (isset($revenueDataArray[0]['invoice_receivdon_date'])) {
                    if ($revenueDataArray[0]['invoice_receivdon_date'] != "0000-00-00 00:00:00") {
                        $rev_invoice_receivdon_date = $revenueDataArray[0]['invoice_receivdon_date'];
                    }
                }
                if (isset($revenueDataArray[0]['invoice_status'])) {
                    if ($revenueDataArray[0]['invoice_status'] == 0) {
                        $rev_invoice_status = "To Be Billed";
                    } else {
                        if ($revenueDataArray[0]['invoice_status'] == 1) {
                            $rev_invoice_status = "Ready to Billed";
                        } else {
                            if ($revenueDataArray[0]['invoice_status'] == 2) {
                                $rev_invoice_status = "Billed";
                            }
                        }
                    }
                } else {
                    $rev_invoice_status = "";
                }
            }

            if (isset($revenueDataArray[1])) {
                if (isset($revenueDataArray[1]['foreign_currency'])) {
                    $cost_foreign_currency = $revenueDataArray[1]['foreign_currency'];
                }
                if (isset($revenueDataArray[1]['debtor_jfr'])) {
                    $cost_debtor_jfr = $revenueDataArray[1]['debtor_jfr'];
                }
                if (isset($revenueDataArray[1]['exchange_rate'])) {
                    $cost_exchange_rate = $revenueDataArray[1]['exchange_rate'];
                }

                if (isset($revenueDataArray[1]['invoice_status'])) {
                    if (isset($revenueDataArray[1]['invoice_status'])) {
                        if ($revenueDataArray[1]['invoice_status'] == 0) {
                            $cost_invoice_status = "To Be Invoiced";
                        } else {
                            if ($revenueDataArray[1]['invoice_status'] == 1) {
                                $cost_invoice_status = "Ready to Invoiced";
                            } else {
                                if ($revenueDataArray[1]['invoice_status'] == 2) {
                                    $cost_invoice_status = "Invoiced";
                                }
                            }
                        }
                    } else {
                        $cost_invoice_status = "";
                    }

                }
            }

            $vas_1_name = $vas_1_quantity = $vas_2_name = $vas_2_quantity = $vas_3_name = $vas_3_quantity = $vas_4_name = $vas_4_quantity = $vas_5_name = $vas_5_quantity = "";

            if (($res['vas_details'] ?? '') != '') {
                $vasData = $this->DataArrayFormatter_model->formatGenericParameters($res['vas_details'], 'VAS');
                if (!empty($vasData) && sizeof($vasData) > 0) {
                    $v = 1;
                    foreach ($vasData as $vas){
                        if (isset($vas['vas_name']) && isset($vas['vas_quantity'])) {
                            if ($v == 1) {
                                $vas_1_name = $vas['vas_name'];
                                $vas_1_quantity = $vas['vas_quantity'];
                            } else {
                                if ($v == 2) {
                                    $vas_2_name = $vas['vas_name'];
                                    $vas_2_quantity = $vas['vas_quantity'];
                                } else {
                                    if ($v == 3) {
                                        $vas_3_name = $vas['vas_name'];
                                        $vas_3_quantity = $vas['vas_quantity'];
                                    } else {
                                        if ($v == 4) {
                                            $vas_4_name = $vas['vas_name'];
                                            $vas_4_quantity = $vas['vas_quantity'];
                                        } else {
                                            if ($v == 5) {
                                                $vas_5_name = $vas['vas_name'];
                                                $vas_5_quantity = $vas['vas_quantity'];
                                            }
                                        }
                                    }
                                }
                            }
                        }
                        $v++;
                    }
                }
            }

            $service_name = "";
            if (($res['name_of_service'] ?? '') != '') {
                $service_name = $res['name_of_service'];
            }
            $order_type = $delivery_term = "";
            if (($res['order_type'] ?? '') != '') {
                $order_type = $res['order_type_name'];
            }
            if (($res['delivery_term_name'] ?? '') != '') {
                $delivery_term = $res['delivery_term_name'];
            }

            $pod_available = $res['pod_available'] ?? '';

            if ($pod_available != "" && $pod_available != "0000-00-00 00:00:00" && $pod_available != "0") {
                $poddate = getdatetimebytimezone($curtz, $pod_available, DFLT_TZ);
                $pod_available = date('Y-m-d h:i A', strtotime($poddate['datetime']));
            }

            $accepted = '';
            $res['driver_acceptance_date'] = $res['driver_acceptance_date'] ?? '';
            $shiftIndex = $res['shift_id'] ?? 0;

            if (isset($driverAcceptanceArray[$shiftIndex])) {
                $res['driver_acceptance_date'] = $driverAcceptanceArray[$shiftIndex]['driver_acceptance_date'];
            }


            if ($res['driver_acceptance_date'] != '') {
                $accepted = $res['driver_acceptance_date'] ?? '';

                if ($accepted != "" && $accepted != "0000-00-00 00:00:00" && $accepted != "0") {
                    $acceptdate = getdatetimebytimezone($curtz, $accepted, DFLT_TZ);
                    $accepted = date('Y-m-d h:i A', strtotime($acceptdate['datetime']));
                }
            }

            $shiftIndex = $res['shift_id'] ?? 0;
            $res['generic_status_status_name'] = $res['generic_status_status_code'] = '';
            
            if (isset($genericStatusArray[$shiftIndex])) {
                $res['generic_status_status_name'] = $genericStatusArray[$shiftIndex]['generic_status_status_name'];
                $res['generic_status_status_code'] = $genericStatusArray[$shiftIndex]['generic_status_status_code'];
            }

            $shipment_status = $res['generic_status_status_name'];
            if ($res['generic_status_status_code'] == '0100') {
                $shipment_status = 'Booked By Supplier';
            } else {
                if ($res['generic_status_status_code'] == '0212') {
                    $shipment_status = 'Accepted By Driver';
                } else {
                    if ($res['generic_status_status_code'] == '0420') {
                        $shipment_status = 'Gate In';
                    } else {
                        if ($res['generic_status_status_code'] == '0500') {
                            $shipment_status = 'Pickup';
                        } else {
                            if ($res['generic_status_status_code'] == '0191') {
                                $shipment_status = 'Gate Out';
                            } else {
                                if ($res['generic_status_status_code'] == '1550') {
                                    $shipment_status = 'In-Transit';
                                } else {
                                    if ($res['generic_status_status_code'] == '0192') {
                                        $shipment_status = 'Gate In (Destination)';
                                    } else {
                                        if ($res['generic_status_status_code'] == '3000') {
                                            $shipment_status = 'Delivered';
                                        } else {
                                            if ($res['generic_status_status_code'] == '2300') {
                                                $shipment_status = 'Gate Out (Destination)';
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }

            if (($res['trip_sts'] ?? 0) == 1) {
                $shipment_status = 'Delivered';
            }

            $tempResId = $res['id'] ?? 0;
            $action = '<div class="checkbox checkbox-info">
                <label>
                    <input type="checkbox" name="check_box" id="' . $tempResId . '" value="' . $tempResId . '">
                    <span class="cr"><i class="cr-icon fa fa-check"></i></span>
                </label>
                </div>';

            $recordListing[$i][0] = $action;
            $recordListing[$i][1] = $res['order_id'] ?? '';
            $recordListing[$i][2] = $delivery_note;
            $recordListing[$i][3] = $purchase_order;
            $recordListing[$i][4] = date('d-m-Y', strtotime($res['createdon'] ?? ''));
            $recordListing[$i][5] = $early_pickup;
            $recordListing[$i][6] = $early_delivery;
            $recordListing[$i][7] = $shipper_details['id'] ?? 0;
            $recordListing[$i][8] = $shipper_details['code'] ?? '';
            $recordListing[$i][9] = $shipper_details['acon'] ?? '';
            $recordListing[$i][10] = $shipper_details['kn_login'] ?? '';
            $recordListing[$i][11] = $shipper_details['vat_reg_no'] ?? '';
            $recordListing[$i][12] = $shipper_details['tax_payer_no'] ?? '';
            $recordListing[$i][13] = $shipper_details['name'] ?? '';
            $recordListing[$i][14] = $shipper_details['street'] ?? '';
            $recordListing[$i][15] = $shipper_details['city'] ?? '';
            $recordListing[$i][16] = $shipper_details['pincode'] ?? '';
            $recordListing[$i][17] = $shipper_details['country'] ?? '';
            $recordListing[$i][18] = $shipper_details['phone'] ?? '';
            $recordListing[$i][19] = $shipper_details['email'] ?? '';

            $recordListing[$i][20] = $drop_details['id'] ?? 0;
            $recordListing[$i][21] = $drop_details['code'] ?? '';
            $recordListing[$i][22] = $drop_details['acon'] ?? '';
            $recordListing[$i][23] = $drop_details['kn_login'] ?? '';
            $recordListing[$i][24] = $drop_details['vat_reg_no'] ?? '';
            $recordListing[$i][25] = $drop_details['tax_payer_no'] ?? '';
            $recordListing[$i][26] = $drop_details['name'] ?? '';
            $recordListing[$i][27] = $drop_details['street'] ?? '';
            $recordListing[$i][28] = $drop_details['city'] ?? '';
            $recordListing[$i][29] = $drop_details['pincode'] ?? '';
            $recordListing[$i][30] = $drop_details['country'] ?? '';
            $recordListing[$i][31] = $drop_details['phone'] ?? '';
            $recordListing[$i][32] = $drop_details['email'] ?? '';
            $recordListing[$i][33] = $customer_details['id'] ?? 0;
            $recordListing[$i][34] = $customer_details['code'] ?? '';
            $recordListing[$i][35] = $customer_details['acon'] ?? '';
            $recordListing[$i][36] = $customer_details['kn_login'] ?? '';
            $recordListing[$i][37] = $customer_details['kn_login'] ?? '';
            $recordListing[$i][38] = $customer_details['tax_payer_no'] ?? '';
            $recordListing[$i][39] = $customer_details['name'] ?? '';
            $recordListing[$i][40] = $customer_details['street'] ?? '';
            $recordListing[$i][41] = $customer_details['pincode'] ?? '';
            $recordListing[$i][42] = $customer_details['country'] ?? '';
            $recordListing[$i][43] = $customer_details['phone'] ?? '';
            $recordListing[$i][44] = $customer_details['email'] ?? '';
            $recordListing[$i][45] = $customer_details['country'] ?? '';

            $recordListing[$i][46] = $res['branch_code'] ?? '';
            $recordListing[$i][47] = $res['department_code'] ?? '';
            $recordListing[$i][48] = $res['product'] ?? '';
            $recordListing[$i][49] = $service_name;
            $recordListing[$i][50] = $res['incoterm'] ?? '';
            $recordListing[$i][51] = $delivery_term;

            $recordListing[$i][52] = $delivery_note;
            $recordListing[$i][53] = $notify_address['name'] ?? '';
            $recordListing[$i][54] = $order_type;
            $recordListing[$i][55] = $res['transport_mode'] ?? '';
            $recordListing[$i][56] = $purchase_order;
            $recordListing[$i][57] = $res['cargo_total_quantity'] ?? 0;
            $recordListing[$i][58] = $res['cargo_total_package_type'] ?? 0;
            $recordListing[$i][59] = $res['cargo_total_length'] ?? 0;
            $recordListing[$i][60] = $res['cargo_total_length_unit'] ?? 0;
            $recordListing[$i][61] = $res['cargo_total_width'] ?? 0;
            $recordListing[$i][62] = $res['cargo_total_width_unit'] ?? 0;
            $recordListing[$i][63] = $res['cargo_total_height'] ?? 0;
            $recordListing[$i][64] = $res['cargo_total_height_unit'] ?? 0;
            $recordListing[$i][65] = $res['cargo_total_second_weight'] ?? 0;
            $recordListing[$i][66] = $res['cargo_total_weight_unit'] ?? 0;
            $recordListing[$i][67] = $res['cargo_total_second_volume'] ?? 0;
            $recordListing[$i][68] = $res['cargo_total_volume_unit'] ?? 0;
            $recordListing[$i][69] = $res['cargo_total_ldm'] ?? 0;
            $recordListing[$i][70] = $res['cargo_total_volumetric_weight'] ?? 0;
            $recordListing[$i][71] = $res['cargo_total_volweight_uom'] ?? 0;

            $stackable = '';
            $dgGoods = '';
            $stackableExplode = explode(',', $res['cargo_total_stackable']);

            if (!empty($stackableExplode) && sizeof($stackableExplode)) {
                foreach ($stackableExplode as $eachStackable){
                    if ($eachStackable == '1') {
                        $stackable = $stackable . 'Yes,';
                    } else {
                        $stackable = $stackable . 'No,';
                    }
                }
            }

            $dgGoodsExplode = explode(',', $res['cargo_total_dg_goods']);

            if (!empty($dgGoodsExplode) && sizeof($dgGoodsExplode)) {
                foreach ($dgGoodsExplode as $eachDg){
                    if ($eachDg == '1') {
                        $dgGoods = $dgGoods . 'Yes,';
                    } else {
                        $dgGoods = $dgGoods . 'No,';
                    }
                }
            }
            $stackable = rtrim($stackable, ",");
            $dgGoods = rtrim($dgGoods, ",");

            $recordListing[$i][72] = $stackable;
            $recordListing[$i][73] = $dgGoods;

            $recordListing[$i][74] = $res['carg_total_weight'];
            $recordListing[$i][75] = $res['cargo_total_weight_unit'];
            $recordListing[$i][76] = $res['cargo_total_volume'];
            $recordListing[$i][77] = $res['cargo_total_volume_unit'];

            $recordListing[$i][78] = $vas_1_name;
            $recordListing[$i][79] = $vas_1_quantity;
            $recordListing[$i][80] = $vas_2_name;
            $recordListing[$i][81] = $vas_2_quantity;
            $recordListing[$i][82] = $vas_3_name;
            $recordListing[$i][83] = $vas_3_quantity;
            $recordListing[$i][84] = $vas_4_name;
            $recordListing[$i][85] = $vas_4_quantity;
            $recordListing[$i][86] = $vas_5_name;
            $recordListing[$i][87] = $vas_5_quantity;
            $recordListing[$i][88] = $ref_1_name;
            $recordListing[$i][89] = $ref_1_description;
            $recordListing[$i][90] = $ref_1_value;
            $recordListing[$i][91] = $ref_2_name;
            $recordListing[$i][92] = $ref_2_description;
            $recordListing[$i][93] = $ref_2_value;
            $recordListing[$i][94] = $ref_3_name;
            $recordListing[$i][95] = $ref_3_description;
            $recordListing[$i][96] = $ref_3_value;
            $recordListing[$i][97] = $ref_4_name;
            $recordListing[$i][98] = $ref_4_description;
            $recordListing[$i][99] = $ref_4_value;
            $recordListing[$i][100] = $ref_5_name;
            $recordListing[$i][101] = $ref_5_description;
            $recordListing[$i][102] = $ref_5_value;
            $recordListing[$i][103] = $getstatusdates['statuspickupdate'];
            $recordListing[$i][104] = $getstatusdates['statusdeliverydate'];
            $recordListing[$i][105] = $docs_received_datetime;
            $recordListing[$i][106] = $docs_sent_datetime;

            $recordListing[$i][107] = $trip_no;
            $recordListing[$i][108] = $res['suppier_name'];
            $recordListing[$i][109] = $register_number;
            $recordListing[$i][110] = $trailer_no;
            $recordListing[$i][111] = $vehicle_type;
            $recordListing[$i][112] = $driver_name;
            $recordListing[$i][113] = $driver_licence_number;
            $recordListing[$i][114] = '';
            $recordListing[$i][115] = 'Customer';
            $recordListing[$i][116] = $res['payer_id'] ?? 0;
            $recordListing[$i][117] = $res['payer_name'] ?? '';
            $recordListing[$i][118] = $res['payer_cid'] ?? '';
            $recordListing[$i][119] = $res['payer_acondebtorcode'] ?? '';
            $recordListing[$i][120] = $res['payer_kn_login_account'] ?? '';
            $recordListing[$i][121] = $res['payer_vat_regno'] ?? '';
            $recordListing[$i][122] = $res['payer_tax_payerid'] ?? '';
            $recordListing[$i][123] = $res['payer_steeet_house'] ?? '';
            $recordListing[$i][124] = $res['payer_postal'] ?? '';

            $recordListing[$i][125] = $res['payer_country'] ?? '';
            $recordListing[$i][126] = $res['payer_phone'] ?? '';
            $recordListing[$i][127] = $res['payer_email'] ?? '';
            $recordListing[$i][128] = $getcharge['chargecode'] ?? '';
            $recordListing[$i][129] = $getcharge['chargecodename'] ?? '';
            $recordListing[$i][130] = $getcharge['quantity'] ?? 0;
            $recordListing[$i][131] = $getcharge['value'] ?? '';
            $recordListing[$i][132] = $getcharge['rate_id'] ?? 0;
            $recordListing[$i][133] = $getcharge['amount'] ?? 0;
            $recordListing[$i][134] = $getcharge['currency'];
            $recordListing[$i][135] = $getcharge['vat_percentage'] ?? 0;
            $recordListing[$i][136] = $getcharge['vat_amount'] ?? 0;
            $recordListing[$i][137] = $invoiced_bu_jfr;
            $recordListing[$i][138] = $rev_debtor_jfr;
            $recordListing[$i][139] = $rev_exchange_rate;
            $recordListing[$i][140] = $rev_foreign_currency;
            $recordListing[$i][141] = $rev_invoiceno;
            $recordListing[$i][142] = $rev_invoicedate;
            $recordListing[$i][143] = $rev_creditnote;
            $recordListing[$i][144] = '-';
            $recordListing[$i][145] = $rev_invoice_creation_date;
            $recordListing[$i][146] = $rev_invoice_receivdon_date;
            $recordListing[$i][147] = $rev_invoice_status;
            $recordListing[$i][148] = $customer_details['contract_no'];
            $recordListing[$i][149] = $customer_details['contract_date'];

            $recordListing[$i][150] = $cost_invoice_status;
            $recordListing[$i][151] = '';
            $recordListing[$i][152] = $res['supplier_id'] ?? '';
            $recordListing[$i][153] = $res['suppier_name'] ?? '';
            $recordListing[$i][154] = $res['suppier_steeet_house'] ?? '';
            $recordListing[$i][155] = $res['suppier_postalcode'] ?? '';
            $recordListing[$i][156] = $res['suppier_country'] ?? '';
            $recordListing[$i][157] = $res['suppier_phone'] ?? '';
            $recordListing[$i][158] = $res['suppier_email'] ?? '';
            $recordListing[$i][159] = $getcostcharge['chargecode'] ?? '';
            $recordListing[$i][160] = $getcostcharge['chargecodename'] ?? '';
            $recordListing[$i][161] = $getcostcharge['quantity'] ?? '';
            $recordListing[$i][162] = $getcostcharge['value'] ?? '';
            $recordListing[$i][163] = $getcostcharge['rate_id'] ?? '';
            $recordListing[$i][164] = $getcostcharge['amount'] ?? '';
            $recordListing[$i][165] = $getcostcharge['currency'] ?? '';
            $recordListing[$i][166] = $getcostcharge['vat_percentage'] ?? '';
            $recordListing[$i][167] = $getcostcharge['vat_amount'] ?? '';
            $recordListing[$i][168] = $billed_bu_jfr;
            $recordListing[$i][169] = $cost_debtor_jfr;
            $recordListing[$i][170] = $cost_exchange_rate;
            $recordListing[$i][171] = $cost_foreign_currency;
            $recordListing[$i][172] = $pod_available;
            $recordListing[$i][173] = $accepted;
            $recordListing[$i][174] = $shipment_status;

            $i++;
        }

        $final_data = !empty($recordListing) ? json_encode($recordListing) : '[]';
        
        echo '{"draw":' . $draw . ',"recordsTotal":' . $totalRecords . ',"recordsFiltered":' . $recordsFiltered . ',"data":' . $final_data . '}';
    }
}
