<?php if (!defined('BASEPATH')) {
	exit('No direct script access allowed');
}
class Amazoneditest extends CI_Controller {

    public function __Construct()
    {
        parent::__Construct();
        $this->load->model('common');
    }

    /**
     * Process Amazonin EDI.
     *
     * @return void
     */
    public function index() {
      $filePath  =  './assets/amazon.txt';
      if (file_exists($filePath)) {
          $filePath  =  './assets/amazon.txt';
      } else {
        log_message('error','File not found');
        return;
      }
      $filePermission = fopen($filePath, 'r');
      $fileContent = fread($filePermission, filesize($filePath));
      $explodedContents = explode('~', $fileContent);
      $explodedContents = array_filter($explodedContents); // Remove empty values from explodedContents array.
      fclose($filePermission);
      $generalInfo = [];
      $shipmentInfo = [];
      $orderInfo = [];
      $itemInfo = [];
      for($i=0; $i<count($explodedContents); $i++) {
        if(isset($explodedContents[$i])) {
          // ###### general Info ######
          if(strpos($explodedContents[$i], 'ST') !== false) {
            $STDetails = array_filter(explode('*', $explodedContents[$i]));
            if($STDetails['1'] == '856') {
              $generalInfo['ST856Details']['code0'] = $STDetails['0'];
              $generalInfo['ST856Details']['code1'] = $STDetails['1'];
              $generalInfo['ST856Details']['code2'] = $STDetails['2'];
            }
          } else {
            log_message('error','ST not found'.$explodedContents[$i]);
          }
          if(strpos($explodedContents[$i], 'ISA') !== false) {
            $ISADetails = array_filter(explode('*', $explodedContents[$i]));
            $generalInfo['ISADetails']['isaValue0'] = $ISADetails['0'];
            $generalInfo['ISADetails']['isaValue1'] = $ISADetails['1'];
            $generalInfo['ISADetails']['isaValue2'] = $ISADetails['2'];
            $generalInfo['ISADetails']['isaValue3'] = $ISADetails['3'];
            $generalInfo['ISADetails']['isaValue4'] = $ISADetails['4'];
            $generalInfo['ISADetails']['isaValue5'] = $ISADetails['5'];
            $generalInfo['ISADetails']['isaValue6'] = $ISADetails['6'];
            $generalInfo['ISADetails']['isaValue7'] = $ISADetails['7'];
            $generalInfo['ISADetails']['isaValue8'] = $ISADetails['8'];
            $generalInfo['ISADetails']['isaValue9'] = $ISADetails['9'];
            $generalInfo['ISADetails']['isaValue10'] = $ISADetails['10'];
            $generalInfo['ISADetails']['isaValue11'] = $ISADetails['11'];
            $generalInfo['ISADetails']['isaValue12'] = $ISADetails['12'];
            $generalInfo['transactionId'] = $ISADetails['13'];
          } else {
            log_message('error','ISA not found'.$explodedContents[$i]);
          }
          if(strpos($explodedContents[$i], 'BSN') !== false) {
            $BSNDetails = array_filter(explode('*', $explodedContents[$i]));
            $generalInfo['BSNInfo']['bsnVal1'] = $BSNDetails['1'];
            $generalInfo['BSNInfo']['shipmentId'] = $BSNDetails['2'];
            $generalInfo['BSNInfo']['bsnVal2'] = $BSNDetails['3'];
            $generalInfo['BSNInfo']['bsnVal3'] = $BSNDetails['4'];
            $generalInfo['BSNInfo']['bsnVal4'] = $BSNDetails['5'];
          } else {
            log_message('error','BSN not found'.$explodedContents[$i]);
          }

          if(strpos($explodedContents[$i], 'DTM') !== false) {
            $DTMDetails = array_filter(explode('*', $explodedContents[$i]));
            if($DTMDetails[1] == '017') { // Estimated Delivery
              $generalInfo['DTMDetails']['DTMValue1'] = $DTMDetails['1'];
              $generalInfo['DTMDetails']['estimatedDate'] = $DTMDetails['2'];
              $generalInfo['DTMDetails']['estimatedTime'] = $DTMDetails['3'];
              $generalInfo['DTMDetails']['DTMValue4'] = $DTMDetails['4'];
            } else if($DTMDetails[1] == '050') {
              $generalInfo['DTMDetails']['receivedValue1'] = $DTMDetails['1'];
              $generalInfo['DTMDetails']['receivedDate'] = $DTMDetails['2'];
              $generalInfo['DTMDetails']['receivedTime'] = $DTMDetails['3'];
              $generalInfo['DTMDetails']['receivedValue4'] = $DTMDetails['4'];
            } else {
              log_message('error','DTM not found'.$explodedContents[$i]);
            }
          }
          // ###### generalInfo ends ######
          // ***** shipmentInfo starts *****
          if(strpos($explodedContents[$i], 'HL') !== false) {
            $HLDetails = array_filter(explode('*', $explodedContents[$i]));
              if ($HLDetails[1] == 1) {
                $shipmentInfo['shipmentDetails']['shipmentLevel'] = $HLDetails['1'];
                $shipmentInfo['shipmentDetails']['shipmentVal1'] = $HLDetails['3'];
              } else {
              log_message('error','HL not found'.$explodedContents[$i]);
            }
          }

          //TD1 Package Info.
          if(strpos($explodedContents[$i], 'TD1') !== false) {
            $packageDetails = array_filter(explode('*', $explodedContents[$i]));
            $shipmentInfo['shipmentDetails']['packageCode'] = $packageDetails['1'];
            $shipmentInfo['shipmentDetails']['number'] = (isset($packageDetails['2']) ? $packageDetails['2'] : '');
            $shipmentInfo['shipmentDetails']['packageVal'] = (isset($packageDetails['6']) ? $packageDetails['6'] : '');
            $shipmentInfo['shipmentDetails']['weight'] = $packageDetails['7'];
            $shipmentInfo['shipmentDetails']['unit'] = $packageDetails['8'];
            $shipmentInfo['shipmentDetails']['unit'] = $packageDetails['9'];
            $shipmentInfo['shipmentDetails']['volumeUnit'] = $packageDetails['10'];
          } else {
            log_message('error','TD1 not found'.$explodedContents[$i]);
          }

          if(strpos($explodedContents[$i], 'TD5') !== false) {
            $TD5Details = array_filter(explode('*', $explodedContents[$i]));
            if(count($TD5Details) == 3) {
              $shipmentInfo['shipmentDetails']['carrierId'] = $TD5Details['2'];
              $shipmentInfo['shipmentDetails']['carrierCode'] = $TD5Details['3']; 
            }
          } else {
            log_message('error','TD1 not found'.$explodedContents[$i]);
          }

          if(strpos($explodedContents[$i], 'TD3') !== false) {
            $TD3Details = array_filter(explode('*', $explodedContents[$i]));
            $shipmentInfo['shipmentDetails']['equipmentCode'] = $TD3Details['1'];
            $shipmentInfo['shipmentDetails']['equipmentInitial'] = $TD3Details['2'];
            $shipmentInfo['shipmentDetails']['equipmentNumber'] = $TD3Details['3'];
            $shipmentInfo['shipmentDetails']['grossWeight'] = $TD3Details['5'];
            $shipmentInfo['shipmentDetails']['weight'] = $TD3Details['5'];
            $shipmentInfo['shipmentDetails']['unit'] = $TD3Details['6'];
            $shipmentInfo['shipmentDetails']['seal'] = $TD3Details['9'];
            $shipmentInfo['shipmentDetails']['equipmentType'] = $TD3Details['10'];
          } else {
            log_message('error','TD1 not found'.$explodedContents[$i]);
          }

          // Reference details.
          if(strpos($explodedContents[$i], 'REF') !== false) {
            $REFDetails = array_filter(explode('*', $explodedContents[$i]));
            foreach($REFDetails as $refKey => $refValues) {
                if (strpos($REFDetails[$refKey], 'BM') !== false) {
                  $shipmentInfo['shipmentDetails']['billCode'] = $REFDetails['1'];
                  $shipmentInfo['shipmentDetails']['billNumber'] = $REFDetails['2'];
                }

                if (strpos($REFDetails[$refKey], 'ZZ') !== false) {
                  $shipmentInfo['shipmentDetails']['serviceCode'] = $REFDetails['1'];
                  $shipmentInfo['shipmentDetails']['serviceType'] = $REFDetails['2'];
                }

                if (strpos($REFDetails[$refKey], 'WU') !== false) {
                  $shipmentInfo['shipmentDetails']['vesselType'] = $REFDetails['1'];
                  $shipmentInfo['shipmentDetails']['vesselMode'] = $REFDetails['2'];
                  $shipmentInfo['shipmentDetails']['vesselNumber'] = $REFDetails['3'];
                }

                if (strpos($REFDetails[$refKey], 'SN') !== false) {
                  $shipmentInfo['shipmentDetails']['sealType'] = $REFDetails['1'];
                  $shipmentInfo['shipmentDetails']['sealMode'] = $REFDetails['2'];
                }

                if (strpos($REFDetails[$refKey], 'XY') !== false) {
                  $shipmentInfo['movementRef']['movementType'] = $REFDetails['1'];
                  $shipmentInfo['movementRef']['movementMode'] = $REFDetails['2'];
                }

                if (strpos($REFDetails[$refKey], 'FN') !== false) {
                  $shipmentInfo['shipmentDetails']['forwardersType'] = $REFDetails['1'];
                  $shipmentInfo['shipmentDetails']['forwardersNumber'] = $REFDetails['2'];
                }
            }
          } else {
            log_message('error','REF BM not found'.$explodedContents[$i]);
          }

          if(strpos($explodedContents[$i], 'DTM') !== false) {
            $DTMDetails = array_filter(explode('*', $explodedContents[$i]));
            if($DTMDetails[1] == '011') {
              $shipmentInfo['shipmentDetails']['DTMValue1'] = $DTMDetails['1'];
              $shipmentInfo['shipmentDetails']['estimatedDate'] = $DTMDetails['2'];
              $shipmentInfo['shipmentDetails']['estimatedTime'] = isset($DTMDetails['3']) ? $DTMDetails['3'] : '';
              $shipmentInfo['shipmentDetails']['DTMValue4'] = $DTMDetails['4'];
            }
          }

          // Address details.
          if(strpos($explodedContents[$i], 'N1') !== false) {
            $addressDetails = array_filter(explode('*', $explodedContents[$i]));
            foreach($addressDetails as $addKey => $addValues) {
                if (strpos($addressDetails[$addKey], 'ST') !== false) {
                  $shipmentInfo['shipmentDetails']['shipToAddress'][$addKey]['addressType'] = $addressDetails['1'];
                  $shipmentInfo['shipmentDetails']['shipToAddress'][$addKey]['countryName'] = $addressDetails['2'];
                  $shipmentInfo['shipmentDetails']['shipToAddress'][$addKey]['code'] = $addressDetails['3'];
                  $shipmentInfo['shipmentDetails']['shipToAddress'][$addKey]['airportCode'] = $addressDetails['4'];
                }

                 if (strpos($addressDetails[$addKey], 'SF') !== false) {
                  $shipmentInfo['shipmentDetails']['shipFromAddress'][$addKey]['addressType'] = $addressDetails['1'];
                  $shipmentInfo['shipmentDetails']['shipFromAddress'][$addKey]['countryName'] = $addressDetails['2'];
                  $shipmentInfo['shipmentDetails']['shipFromAddress'][$addKey]['code'] = $addressDetails['3'];
                  $shipmentInfo['shipmentDetails']['shipFromAddress'][$addKey]['airportCode'] = $addressDetails['4'];
                }
            }
          } else {
            log_message('error','Address details not found'.$explodedContents[$i]);
          }

          // Vessel info
          if(strpos($explodedContents[$i], 'V1') !== false) {
            $vesselDetails = array_filter(explode('*', $explodedContents[$i]));
            $shipmentInfo['shipmentDetails']['vesselCode'] = $vesselDetails['1'];
            $shipmentInfo['shipmentDetails']['vesselName'] = $vesselDetails['2'];
            $shipmentInfo['shipmentDetails']['vesselNumber'] = $vesselDetails['4'];
            $shipmentInfo['shipmentDetails']['vesselSCAC'] = $vesselDetails['5'];
            $shipmentInfo['shipmentDetails']['air'] = $vesselDetails['9'];
          } else {
            log_message('error','Vessel not found'.$explodedContents[$i]);
          }

          // Route info
          if(strpos($explodedContents[$i], 'R4') !== false) {
            $routeDetails = array_filter(explode('*', $explodedContents[$i]));
            if(isset($routeDetails[1]) && $routeDetails[1] == 'L') {
              $shipmentInfo['shipmentDetails']['polCode'] = $routeDetails['1'];
              $shipmentInfo['shipmentDetails']['unCode'] = $routeDetails['2'];
              $shipmentInfo['shipmentDetails']['unLocation'] = $routeDetails['3'];
              $shipmentInfo['shipmentDetails']['countryCode'] = $routeDetails['5'];
            } else if(isset($routeDetails[1]) && $routeDetails[1] == 'D') {
              $shipmentInfo['shipmentDetails']['podCode'] = $routeDetails['1'];
              $shipmentInfo['shipmentDetails']['unCode'] = $routeDetails['2'];
              $shipmentInfo['shipmentDetails']['unLocation'] = $routeDetails['3'];
              $shipmentInfo['shipmentDetails']['countryCode'] = $routeDetails['5'];
            }
          } else {
            log_message('error','Vessel not found'.$explodedContents[$i]);
          }

          if(strpos($explodedContents[$i], 'DTM') !== false) {
            $DTMDetails = array_filter(explode('*', $explodedContents[$i]));
            if($DTMDetails[1] == '370') { // Estimated Delivery
              $shipmentInfo['shipmentDetails']['actualDepartureDate'] = $DTMDetails['2'];
            } else if($DTMDetails[1] == 'AFD') {
              $shipmentInfo['shipmentDetails']['aDC'] = $DTMDetails['2'];
            }  else if($DTMDetails[1] == 'AAA') {
              $shipmentInfo['shipmentDetails']['arrivalInCountry'] = $DTMDetails['2'];
            } else {
              log_message('error','DTM not found'.$explodedContents[$i]);
            } // generalInfo ends.
          }

          // Payment terms
          if(strpos($explodedContents[$i], 'FOB') !== false) {
            $paymentTermDetails = array_filter(explode('*', $explodedContents[$i]));
            $shipmentInfo['shipmentDetails']['paymentTermCode'] = $paymentTermDetails['1'];
          } else {
            log_message('error','Payment terms not found'.$explodedContents[$i]);
          }
          // ***** shipmentInfo ends *****

          // $$$$$ orderLevel Info starts $$$$$
          if(strpos($explodedContents[$i], 'HL') !== false) {
            $HLDetails = array_filter(explode('*', $explodedContents[$i]));
            if ($HLDetails[1] == 3) {
              $orderInfo['orderHL3']['code1'] = $HLDetails['1'];
              $orderInfo['orderHL3']['code2'] = $HLDetails['2'];
              $orderInfo['orderHL3']['orderType'] = $HLDetails['3'];
            }
          } else {
            log_message('error','HL not found'.$explodedContents[$i]);
          }

          if(strpos($explodedContents[$i], 'REF') !== false) {
            $REFDetails = array_filter(explode('*', $explodedContents[$i]));
            foreach($REFDetails as $refKey => $refValues) {
                if (strpos($REFDetails[$refKey], 'CN') !== false) {
                  $orderInfo['carrierReferenceNumber'] = $REFDetails['2'];
                }
            }
          }          

          if(strpos($explodedContents[$i], 'REF') !== false) {
            $REFDetails = array_filter(explode('*', $explodedContents[$i]));
            foreach($REFDetails as $refKey => $refValues) {
                if (strpos($REFDetails[$refKey], 'SI') !== false) {
                  $orderInfo['shipperDetails']['billCode'] = $REFDetails['1'];
                  $orderInfo['shipperDetails']['billNumber'] = $REFDetails['2'];
                }
            }
          } else {
            log_message('error','REF BM not found'.$explodedContents[$i]);
          }

          if(strpos($explodedContents[$i], 'DTM') !== false) {
            $DTMDetails = array_filter(explode('*', $explodedContents[$i]));
            if($DTMDetails[1] == '537') {
              $orderInfo['DTM537Details']['DTMValue1'] = $DTMDetails['1'];
              $orderInfo['DTM537Details']['estimatedDate'] = $DTMDetails['2'];
              $orderInfo['DTM537Details']['estimatedTime'] = $DTMDetails['3'];
              $orderInfo['DTM537Details']['DTMValue4'] = $DTMDetails['4'];
            } else {
              log_message('error','DTM not found'.$explodedContents[$i]);
            }
          }

          if(strpos($explodedContents[$i], 'HL') !== false) {
            $HL6Details = array_filter(explode('*', $explodedContents[$i]));
              if ($HL6Details[1] == 6) {
                $orderInfo['HL6Details']['shipmentLevel'] = $HL6Details['1'];
                $orderInfo['HL6Details']['shipmentVal1'] = $HL6Details['3'];
              } else {
              log_message('error','HL not found'.$explodedContents[$i]);
            }
          }

          if(strpos($explodedContents[$i], 'PRF') !== false) {
            $PRFDetails = array_filter(explode('*', $explodedContents[$i]));
            $orderInfo['prfDetails']['poRef'] = $PRFDetails['1'];
            $orderInfo['prfDetails']['poDate'] = $PRFDetails['4'];
          } else {
            log_message('error','REF BM not found'.$explodedContents[$i]);
          }

          // Shipment details.
          if(strpos($explodedContents[$i], 'SN1') !== false) {
            $shipmentDetails = array_filter(explode('*', $explodedContents[$i]));
            if ($shipmentDetails[2] == 20) {
              $orderInfo['SN1Code1'] = $shipmentDetails['1'];
              $orderInfo['SN1Code2'] = $shipmentDetails['2'];
              $orderInfo['SN1OrderType'] = $shipmentDetails['3'];
            }
          } else {
            log_message('error','Shipment details not found'.$explodedContents[$i]);
          }

          // TD1 details.
          if(strpos($explodedContents[$i], 'TD1') !== false) {
            if(isset($explodedContents['56'])) {
              $TD1Details = array_filter(explode('*', $explodedContents[$i]));
              $packageDetails = array_filter(explode('*', $explodedContents[$i]));
              $orderInfo['TD1Details']['packageCode'] = $TD1Details['1'];
              $orderInfo['TD1Details']['number'] = (isset($TD1Details['2']) ? $TD1Details['2'] : '');
              $orderInfo['TD1Details']['packageVal'] = (isset($TD1Details['6']) ? $TD1Details['6'] : '');
              $orderInfo['TD1Details']['weight'] = $TD1Details['7'];
              $orderInfo['TD1Details']['unit'] = $TD1Details['8'];
              $orderInfo['TD1Details']['unit'] = $TD1Details['9'];
              $orderInfo['TD1Details']['volumeUnit'] = $TD1Details['10'];
            }
          } else {
            log_message('error','Shipment details not found'.$explodedContents[$i]);
          }
          // $$$$$ orderLevel Info ends $$$$$

          // @@@@@ itemInfo starts @@@@@
          if(strpos($explodedContents[$i], 'HL') !== false) {
            $HLDetails = array_filter(explode('*', $explodedContents[$i]));
            if ($HLDetails[1] == 8) {
              $itemInfo['orderHL8']['code1'] = $HLDetails['1'];
              $itemInfo['orderHL8']['code2'] = $HLDetails['2'];
              $itemInfo['orderHL8']['orderType'] = $HLDetails['3'];
            }
          } else {
            log_message('error','HL not found'.$explodedContents[$i]);
          }

          if(strpos($explodedContents[$i], 'LIN') !== false) {
            $lineDetails = array_filter(explode('*', $explodedContents[$i]));
            foreach($lineDetails as $lineKey => $lineValues) {
              $itemInfo['lineInfo'][$i]['lineKey'.$lineKey] = $lineDetails[$lineKey];
            }
          } else {
            log_message('error','Line details not found'.$explodedContents[$i]);
          }
          
          if(strpos($explodedContents[$i], 'SN1') !== false) {
            $snDetails = array_filter(explode('*', $explodedContents[$i]));
            foreach($snDetails as $snKey => $snValues) {
              $itemInfo['SNInfo'][$i]['snKey'.$snKey] = $snDetails[$snKey];
            }
            $itemInfo['lineInfo'] = array_merge($itemInfo['lineInfo'], $itemInfo['SNInfo']);
            unset($itemInfo['SNInfo']);
          } else {
            log_message('error','Shipment details not found'.$explodedContents[$i]);
          }

          if(strpos($explodedContents[$i], 'DTM') !== false) {
            $DTMDetails = array_filter(explode('*', $explodedContents[$i]));
            foreach($DTMDetails as $DTMDKey => $DTMDValues) {
              $itemInfo['DTM537Details'][$i]['DTMDKey'.$DTMDKey] = $DTMDetails[$DTMDKey];
            }
          } else {
            log_message('error','DTM not found'.$explodedContents[$i]);
          }

          if(strpos($explodedContents[$i], 'HL') !== false) {
            $HLDetails = array_filter(explode('*', $explodedContents[$i]));
            foreach($HLDetails as $HLDKey => $HLDValues) {
              $itemInfo['HLDetails'][$i]['HLDKey'.$HLDKey] = $HLDetails[$HLDKey];
            }
          } else {
            log_message('error','HL not found'.$explodedContents[$i]);
          }
          // @@@@@ itemInfo ends @@@@@
        } // end for loop
      }
      $itemInfo['lineInfo'] = array_merge($itemInfo['lineInfo'], $itemInfo['DTM537Details']);
      $itemInfo['lineInfo'] = array_merge($itemInfo['lineInfo'], $itemInfo['HLDetails']);
      /*$result = $this->saveOrderInfo($orderInfo, $generalInfo, $shipmentInfo);*/
      unset($itemInfo['DTM537Details']);
      unset($itemInfo['HLDetails']);
      echo "<pre>";
      echo "orderInfo";
      print_r($orderInfo);
      echo "shipmentInfo";
      print_r($shipmentInfo);
      echo "generalInfo";
      print_r($generalInfo);
      echo "itemInfo";
      print_r($itemInfo);
      exit;
      // $this->saveGeneralInfo($orderInfo, $generalInfo, $shipmentInfo);
      /*$this->saveShipmentInfo($orderInfo, $generalInfo, $shipmentInfo);
      $this->saveItemInfo($orderInfo, $generalInfo, $shipmentInfo, $itemInfo);*/
      //echo $result;
    }

    /**
     * save Item Info.
     * @param  array $orderInfo   
     * @param  array $generalInfo 
     * @param  array $shipmentInfo
     * @param  array $itemInfo    
     * @return void
     */
    private function saveItemInfo($orderInfo, $generalInfo, $shipmentInfo, $itemInfo) {
      $estimatedDate  = $orderInfo['DTM537Details']['estimatedDate'].''.$orderInfo['DTM537Details']['estimatedTime'];
      $estimatedDate  = date('Y-m-d H:i:s',strtotime($estimatedDate));
      $currentTimezone = date_default_timezone_get();
      $estimatedDate = getdatetimebytimezone(DFLT_TZ,$estimatedDate,$currentTimezone);

      $receivedDate  = $generalInfo['DTMDetails']['receivedDate'].''.$generalInfo['DTMDetails']['receivedTime'];
      $receivedDate  = date('Y-m-d H:i:s',strtotime($receivedDate));
      $currentTimezone = date_default_timezone_get();
      $receivedDate = getdatetimebytimezone(DFLT_TZ,$receivedDate,$currentTimezone);
      $i = 1;
      foreach($itemInfo as $itemData) {
        // Order data
        $orderData = array('order_id' => $generalInfo['BSNInfo']['shipmentId'],
                      'pickup_datetime' =>  isset($receivedDate) ? $receivedDate['datetime'] : '',
                      'delivery_datetime' => isset($estimatedDate) ? $estimatedDate['datetime'] : '',
                      'pickup_company' => isset($shipmentInfo['shipmentDetails']['carrierCode']) ? $shipmentInfo['shipmentDetails']['carrierCode'] : null,
                      'delivery_company' => isset($shipmentInfo['shipmentDetails']['vesselSCAC']) ? $shipmentInfo['shipmentDetails']['vesselSCAC'] : null, 
                      'pickup_country' =>  isset($shipmentInfo['shipmentDetails']['countryCode']) ? $shipmentInfo['shipmentDetails']['countryCode'] : null,
                      'delivery_country' => isset($orderInfo['shipToAddress'][$i]['code']) ? $orderInfo['shipToAddress'][$i]['code'] : null,
                      'pickup_city' => isset($orderInfo['shipFromAddress'][$i]['countryName']) ? $orderInfo['shipFromAddress'][$i]['countryName'] : null,
                      'delivery_city' => isset($orderInfo['shipFromAddress'][$i]['countryName']) ? $orderInfo['shipFromAddress'][$i]['countryName'] : null,
                      'pickup_pincode' => isset($orderInfo['shipFromAddress'][$i]['code']) ? $orderInfo['shipFromAddress'][$i]['code'] : null, 
                      'delivery_pincode' => isset($orderInfo['shipToAddress'][$i]['code']) ? $orderInfo['shipToAddress'][$i]['code'] : null, 
                      'pickup_address1' => null, 
                      'delivery_address1' => isset($orderInfo['shipToAddress'][$i]['addressType']) ? $orderInfo['shipToAddress'][$i]['addressType'] : null,
                      'quantity' => isset($itemData['0']['lineKey6']) ? $itemData['0']['lineKey6'] : null, 
                      'weight' => isset($shipmentInfo['shipmentDetails']['weight']) ? $shipmentInfo['shipmentDetails']['weight'] : null, 
                      'volume' => isset($shipmentInfo['shipmentDetails']['unit']) ? $shipmentInfo['shipmentDetails']['unit'] : null, 
                      'goods_value' => null, 
                      'transport_mode' => isset($itemData['0']['lineKey10']) ? $itemData['0']['lineKey10'] : null,
                      'dedicated_vehicle' => 0, 
                      'vehicle_type' => isset($shipmentInfo['shipmentDetails']['vesselMode']) ? $shipmentInfo['shipmentDetails']['vesselMode'] : null, 
                      'user_id' => 1, 
                      'customer_id' => null, 
                      'vendor_id' => null, 
                      'customer_name' => null,
                      'customer_code' => null, 
                      'customer_area' => null,
                      'customer_phone' => null, 
                      'customer_email' => null,
                      'vendor_name' =>  isset($itemData['0']['lineKey9']) ? $itemData['0']['lineKey9'] : null, 
                      'vendor_code' => isset($itemData['0']['lineKey2']) ? $itemData['0']['lineKey2'] : null, 
                      'vendor_area' => null, 
                      'vendor_phone' => null, 
                      'vendor_email' => null, 
                      'plat' => null, 
                      'plng' => null, 
                      'dlat' => null, 
                      'dlng' => null,
                      'status' => 1,
                      'is_created' => 1,
                      'createdon' => null,
                      "created_source" => "amazon_edi");
        $result = $this->common->insertTableData("tb_orders",$orderData);
        $i++;
        }
    }

    /**
     * save Shipment Info
     *
     * @param  mixed $shipmentInfo
     * @return void
     */
    private function saveShipmentInfo($orderInfo, $generalInfo, $shipmentInfo) {
      // Shippment Info.
      $shipmentData = array('shipid' => $generalInfo['BSNInfo']['shipmentId'],
                        'txnid' => $generalInfo['BSNInfo']['shipmentId'],
                        'trucktype' => $shipmentInfo['shipmentDetails']['vesselType'],
                        'pickupcnt' => '1',
                        'dropcnt' => '1',
                        'unitspec' => 1,
                        'insertusr' => null,
                        'carrier' => isset($shipmentInfo['shipmentDetails']['carrierCode']) ? $shipmentInfo['shipmentDetails']['carrierCode'] : null,
                        'insertuserdate' => date("Y-m-d H:i:s"),
                        'enddate' => date("Y-m-d H:i:s"),
                        'insdate' => date("Y-m-d H:i:s"),
                        'upddate' => date("Y-m-d H:i:s"),
                        'reason' => 'SHIPMENT',
                        'purpose' => 'SEND INTEGRATION',
                        'ship_object' => 'SHIPMENT',
                        'logdate' => date("Y-m-d H:i:s"),
                        'transport_mode' => $shipmentInfo['shipmentDetails']['vesselMode'],
                        'domainname' => null,
                        'company_code' => $shipmentInfo['shipmentDetails']['unCode'],
                        'branch_code' => $shipmentInfo['shipmentDetails']['unLocation'],
                        'product' => $shipmentInfo['shipmentDetails']['equipmentCode'],
                        'freight_term' => '60',
                        'freight_termname' => 'Free of Charge',
                        'incoterm' => null,
                        'modeoftransport' => $shipmentInfo['shipmentDetails']['vesselMode']);
          $orderdetid = $this->common->insertTableData("tb_shipments",$shipmentData);

          $cargoData = array('cargo_type' =>  $shipmentInfo['shipmentDetails']['vesselName'], 
                             'goods_description' =>  $shipmentInfo['shipmentDetails']['vesselName'], 
                             'quantity' => null, 
                             'length' => $shipmentInfo['shipmentDetails']['grossWeight'], 
                             'length_unit' => 'M', 
                             'width' => $shipmentInfo['shipmentDetails']['grossWeight'], 
                             'width_unit' => 'M', 
                             'height' => $shipmentInfo['shipmentDetails']['grossWeight'], 
                             'height_unit' => 'M', 
                             'weight' => $shipmentInfo['shipmentDetails']['grossWeight'], 
                             'weight_unit' => $shipmentInfo['shipmentDetails']['packageVal'], 
                             'volume' => $shipmentInfo['shipmentDetails']['packageVal'], 
                             'volume_unit' => $shipmentInfo['shipmentDetails']['volumeUnit'], 
                             'stackable' => null, 
                             'createdby' => null, 'createdon' => date('Y-m-d'));
          $cargoResult = $this->common->insertTableData("tb_cargo_details",$cargoData);
          
          $cargoDetails  = array('order_id' => $generalInfo['BSNInfo']['shipmentId'], 
                              'cargo_id' => $cargoResult, 
                              'handling_unit' => $cargoResult, 
                              'length' => $shipmentInfo['shipmentDetails']['grossWeight'],
                              'width' => $shipmentInfo['shipmentDetails']['grossWeight'], 
                              'height' => $shipmentInfo['shipmentDetails']['grossWeight'], 
                              'weight' => $shipmentInfo['shipmentDetails']['grossWeight'], 
                              'quantity' => null, 
                              'status' => 1, 
                              'createdon' => date('Y-m-d'));
          $ordcargo_id = $this->common->insertTableData("tb_order_cargodetails", $cargoDetails);
    }
        
    /**
     * save Amazon Order Data
     *
     * @param  mixed $orderInfo
     * @return void
     */
    private function saveOrderInfo($orderInfo, $generalInfo, $shipmentInfo) {
      $estimatedDate  = $orderInfo['DTM537Details']['estimatedDate'].''.$orderInfo['DTM537Details']['estimatedTime'];
      $estimatedDate  = date('Y-m-d H:i:s',strtotime($estimatedDate));
      $currentTimezone = date_default_timezone_get();
      $estimatedDate = getdatetimebytimezone(DFLT_TZ,$estimatedDate,$currentTimezone);

      $receivedDate  = $generalInfo['DTMDetails']['receivedDate'].''.$generalInfo['DTMDetails']['receivedTime'];
      $receivedDate  = date('Y-m-d H:i:s',strtotime($receivedDate));
      $currentTimezone = date_default_timezone_get();
      $receivedDate = getdatetimebytimezone(DFLT_TZ,$receivedDate,$currentTimezone);
      try {
        $i = 1;
        foreach($orderInfo as $amazonData) {
          // Order data
          $orderData = array('order_id' => $generalInfo['BSNInfo']['shipmentId'],
                        'pickup_datetime' =>  isset($receivedDate) ? $receivedDate['datetime'] : '',
                        'delivery_datetime' => isset($estimatedDate) ? $estimatedDate['datetime'] : '',
                        'pickup_company' => isset($shipmentInfo['shipmentDetails']['carrierCode']) ? $shipmentInfo['shipmentDetails']['carrierCode'] : null,
                        'delivery_company' => isset($shipmentInfo['shipmentDetails']['vesselSCAC']) ? $shipmentInfo['shipmentDetails']['vesselSCAC'] : null, 
                        'pickup_country' =>  isset($shipmentInfo['shipmentDetails']['countryCode']) ? $shipmentInfo['shipmentDetails']['countryCode'] : null,
                        'delivery_country' => isset($orderInfo['shipToAddress'][$i]['code']) ? $orderInfo['shipToAddress'][$i]['code'] : null,
                        'pickup_city' => isset($orderInfo['shipFromAddress'][$i]['countryName']) ? $orderInfo['shipFromAddress'][$i]['countryName'] : null,
                        'delivery_city' => isset($orderInfo['shipFromAddress'][$i]['countryName']) ? $orderInfo['shipFromAddress'][$i]['countryName'] : null,
                        'pickup_pincode' => isset($orderInfo['shipFromAddress'][$i]['code']) ? $orderInfo['shipFromAddress'][$i]['code'] : null, 
                        'delivery_pincode' => isset($orderInfo['shipToAddress'][$i]['code']) ? $orderInfo['shipToAddress'][$i]['code'] : null, 
                        'pickup_address1' => null, 
                        'delivery_address1' => isset($orderInfo['shipToAddress'][$i]['addressType']) ? $orderInfo['shipToAddress'][$i]['addressType'] : null,
                        'quantity' => null, 
                        'weight' => isset($shipmentInfo['shipmentDetails']['weight']) ? $shipmentInfo['shipmentDetails']['weight'] : null, 
                        'volume' => isset($shipmentInfo['shipmentDetails']['unit']) ? $shipmentInfo['shipmentDetails']['unit'] : null, 
                        'goods_value' => null, 
                        'transport_mode' => isset($shipmentInfo['shipmentDetails']['vesselMode']) ? $shipmentInfo['shipmentDetails']['vesselMode'] : null,
                        'dedicated_vehicle' => 0, 
                        'vehicle_type' => isset($shipmentInfo['shipmentDetails']['vesselMode']) ? $shipmentInfo['shipmentDetails']['vesselMode'] : null, 
                        'user_id' => 1, 
                        'customer_id' => null, 
                        'vendor_id' => null, 
                        'customer_name' => null,
                        'customer_code' => null, 
                        'customer_area' => null,
                        'customer_phone' => null, 
                        'customer_email' => null,
                        'vendor_name' => null, 
                        'vendor_code' => null, 
                        'vendor_area' => null, 
                        'vendor_phone' => null, 
                        'vendor_email' => null, 
                        'plat' => null, 
                        'plng' => null, 
                        'dlat' => null, 
                        'dlng' => null,
                        'status' => 1,
                        'is_created' => 1,
                        'createdon' => null,
                        "created_source" => "amazon_edi");
          $result = $this->common->insertTableData("tb_orders",$orderData);
          $ordDetails = array('order_row_id'=>$result, 
                              'order_id'=>$result, 
                              'order_status'=>'', 
                              'order_type'=>'N', 
                              'shipper_id'=>$generalInfo['BSNInfo']['shipmentId'],
                              'service'=>isset($shipmentInfo['shipmentDetails']['serviceCode']) ? $shipmentInfo['shipmentDetails']['serviceCode'] : null,
                              'delivery_term'=>60, 
                              'incoterm'=>'DAP', 
                              'delivery_note'=>null, 
                              'purchase_order'=>$orderInfo['prfDetails']['poRef'], 
                              'notify_party'=>null, 
                              'lane_reference'=>"", 
                              'distance'=>"", 
                              'customs_required'=>0, 
                              'high_cargo_value'=>0, 
                              'valorance_insurance'=>0, 
                              'temperature_control'=>0, 
                              'department_code'=>$shipmentInfo['shipmentDetails']['paymentTermCode'], 
                              'character_id'=>null, 
                              'character_name'=>null, 
                              'revenue_price'=>$orderInfo['TD1Details']['packageVal'], 
                              'revenue_currency'=>null, 
                              'goods_description'=>null, 
                              'status'=>1, 
                              'createdon'=>date('Y-m-d'));
          $orderdetid = $this->common->insertTableData("tb_order_details",$ordDetails);
          
          $orderReferenceData = array('order_id' => $result,
                       'reference_id' => $orderInfo['TD1Details']['volumeUnit'],
                       'ref_value' => $orderInfo['carrierReferenceNumber'], 
                       'status' => 1, 
                       'createdon' => date('Y-m-d'));
          $orderReferenceResult = $this->common->insertTableData("tb_order_references", $orderReferenceData);

          $partyData = array('order_id'=>$result,
                            'order_number'=>$generalInfo['BSNInfo']['shipmentId'],
                            'party_id'=>$shipmentInfo['shipmentDetails']['carrierCode'],
                            'party_type'=>$shipmentInfo['shipmentDetails']['vesselType'], 
                            'status'=>1,
                            'createdon'=>date('Y-m-d'));
          $partyResult = $this->common->insertTableData("tb_order_parties",$partyData);
          $i++;
        }
      } catch (Exception $e) {
        return $e;
      }
      return $result;
    }
}