<?php

defined('BASEPATH') or exit('No direct script access allowed');

class Amazonexceldto extends CI_Controller
{
    public function __construct()
    {
        parent::__construct();
        $this->load->library('amazonexceldtohandler');
    }

    public function index()
    {
        ini_set('max_execution_time', 300);
        $postData = file_get_contents('php://input');
        if (empty($postData)) {
            echo "Please Send Proper XML";
            return;
        }

        try {
            $response = json_decode(json_encode(simplexml_load_string($postData, "SimpleXMLElement", LIBXML_NOCDATA)), true, 512, JSON_THROW_ON_ERROR);
            $this->amazonexceldtohandler->pullAmazonOrderXml($response);
        } catch (Exception $ex) {
            log_message("error", "Some Problem occured!, While Inserting Amazon Order " . $ex->getMessage());
        }
    }
}
