<?php if (!defined('BASEPATH')) {
exit('No direct script access allowed');
}

require_once APPPATH . "/third_party/PHPExcel.php";
require_once APPPATH . "/third_party/PHPExcel/Writer/Excel2007.php";

class Auexcleimportorders extends CI_Controller {

	public function __construct() {
		parent::__construct();
		if ($this->session->userdata('user_id') == '') {
			redirect('login');
		}
		$this->load->model("common");
		$this->load->model('aureportsmodel');
	}

	public function index()
	{
		echo "Upload AU Orders Data";
	}

	public function orderbooking()
	{	
		ini_set("max_input_time",2000);
		ini_set("max_execution_time",2000);
		ini_set("max_input_vars",20000);
		ini_set("upload_max_size","2048M");
		ini_set("post_max_size",0);
		ini_set("memory_limit","2048M");
		$user_id      = $this->session->userdata('user_id');
		$company_code = $this->session->userdata('company_code');
		$branch_code  = $this->session->userdata('branch_code');
		$curtz        = $this->session->userdata("usr_tzone")['timezone'];
		$all_data = array();
		$data =  $errorline= $message  = $order_details = array();
		$data['order_details'] = array();
		if (isset($_FILES['import_file'])) {
      		$path = $_FILES['import_file']['tmp_name'];
    		$objPHPExcel = PHPExcel_IOFactory::load($path);
    		$cell_collection = $objPHPExcel->getActiveSheet()->getCellCollection();
    		$data["arr_data"]=array();
    		foreach ($cell_collection as $cell) {
      			$column = $objPHPExcel->getActiveSheet()->getCell($cell)->getColumn();
      			$row = $objPHPExcel->getActiveSheet()->getCell($cell)->getRow();
      			$data_value = $objPHPExcel->getActiveSheet()->getCell($cell)->getValue();
      			$newdtat[] = $column;
      			if ($row == 2) {
          			$data["header"][$row][$column] = $data_value;
      			} else if($row > 2){
          			$data["arr_data"][$row][$column] = $data_value;
      			}
    		}
    		$row = 3;
	        $arr=[];
	        $sno="";
	        foreach ($data["arr_data"] as $value[$row]) {
	        	$dnote = isset($value[$row]['A']) ? $value[$row]['A'] : ""; 
				if($dnote != ""){
					$row = $row;
					$delivery_note = $dnote.$row;
					if($sno != $delivery_note){
						if($delivery_note != ""){
							$sno = $delivery_note;
							$value[$row]['row'] = $row;
							$arr[$sno][]=$value[$row];
							$row++;
						}else{
							$value[$row]['row'] = $row;
							$arr[$sno][]=$value[$row];
							$row++;
						}
					}else{
						$value[$row]['row'] = $row;
						$arr[$sno][]=$value[$row];
						$row++;
					}
				}
	        }
	        $arrdata = array();
	        if(!empty($arr)){
	        	foreach($arr as $ar){
      				$arrdata[] = $ar;
    			}
	        }
	       
	        if(!empty($arrdata)){
	        	for($i=0;$i<count($arrdata);$i++){
	        		$rowno =  isset($arrdata[$i]['0']['row']) ? trim($arrdata[$i]['0']['row']) : "";
		            $mainrowno =  $rowno;
		            $store_id = isset($arrdata[$i]['0']['A']) ? trim($arrdata[$i]['0']['A']) : "";
		            if($store_id == ""){
		              $message[] = "Store ID empty on line: ".$rowno;
		              $errorline[] = "store_id".$rowno;
		            }
		            $company_code = isset($arrdata[$i]['0']['B']) ? trim($arrdata[$i]['0']['B']) : "";
		            if($company_code == ""){
		              $message[] = "Company Code empty on line: ".$rowno;
		              $errorline[] = "company_code".$rowno;
		            }
		            $branch_code = isset($arrdata[$i]['0']['C']) ? trim($arrdata[$i]['0']['C']) : "";
		            if($branch_code == ""){
		              $message[] = "Branch Code empty on line: ".$rowno;
		              $errorline[] = "branch_code".$rowno;
		            }
		            $customer_id = isset($arrdata[$i]['0']['D']) ? trim($arrdata[$i]['0']['D']) : "";
		            if($customer_id == ""){
		              $message[] = "Customer ID empty on line: ".$rowno;
		              $errorline[] = "customer_id".$rowno;
		            }
		            $pickup_id = isset($arrdata[$i]['0']['E']) ? trim($arrdata[$i]['0']['E']) : "";
		            if($pickup_id == ""){
		              $message[] = "Pickup ID empty on line: ".$rowno;
		              $errorline[] = "pickup_id".$rowno;
		            }
		            $pickup_name = isset($arrdata[$i]['0']['F']) ? trim($arrdata[$i]['0']['F']) : "";
		            if($pickup_name == ""){
		              $message[] = "Pickup Name empty on line: ".$rowno;
		              $errorline[] = "pickup_name".$rowno;
		            }
		            $pickup_street = isset($arrdata[$i]['0']['G']) ? trim($arrdata[$i]['0']['G']) : "";
		            if($pickup_street == ""){
		              $message[] = "Pickup Street empty on line: ".$rowno;
		              $errorline[] = "pickup_street".$rowno;
		            }
		            $pickup_city = isset($arrdata[$i]['0']['H']) ? trim($arrdata[$i]['0']['H']) : "";
		            if($pickup_city == ""){
		              $message[] = "Pickup City empty on line: ".$rowno;
		              $errorline[] = "pickup_city".$rowno;
		            }
		            $pickup_state = isset($arrdata[$i]['0']['I']) ? trim($arrdata[$i]['0']['I']) : "";
		            if($pickup_state == ""){
		              $message[] = "Pickup State empty on line: ".$rowno;
		              $errorline[] = "pickup_state".$rowno;
		            }
		            $pickup_country = isset($arrdata[$i]['0']['J']) ? trim($arrdata[$i]['0']['J']) : "";
		            if($pickup_country == ""){
		              $message[] = "Pickup Country empty on line: ".$rowno;
		              $errorline[] = "pickup_country".$rowno;
		            }
		            $pickup_zipcode = isset($arrdata[$i]['0']['K']) ? trim($arrdata[$i]['0']['K']) : "";
		            if($pickup_zipcode == ""){
		              $message[] = "Pickup Zipcode empty on line: ".$rowno;
		              $errorline[] = "pickup_zipcode".$rowno;
		            }
		            $pickup_phone = isset($arrdata[$i]['0']['L']) ? trim($arrdata[$i]['0']['L']) : "";
		            if($pickup_phone == ""){
		              $message[] = "Pickup Phone empty on line: ".$rowno;
		              $errorline[] = "pickup_phone".$rowno;
		            }
		            $drop_id = isset($arrdata[$i]['0']['M']) ? trim($arrdata[$i]['0']['M']) : "";
		            if($drop_id == ""){
		              $message[] = "Drop ID empty on line: ".$rowno;
		              $errorline[] = "drop_id".$rowno;
		            }
		            $drop_name = isset($arrdata[$i]['0']['N']) ? trim($arrdata[$i]['0']['N']) : "";
		            if($drop_name == ""){
		              $message[] = "Drop Name empty on line: ".$rowno;
		              $errorline[] = "drop_name".$rowno;
		            }
		            $drop_street = isset($arrdata[$i]['0']['O']) ? trim($arrdata[$i]['0']['O']) : "";
		            if($drop_street == ""){
		              $message[] = "Drop Street empty on line: ".$rowno;
		              $errorline[] = "drop_street".$rowno;
		            }
		            $drop_city = isset($arrdata[$i]['0']['P']) ? trim($arrdata[$i]['0']['P']) : "";
		            if($drop_street == ""){
		              $message[] = "Drop City empty on line: ".$rowno;
		              $errorline[] = "drop_street".$rowno;
		            }
		            $drop_state = isset($arrdata[$i]['0']['Q']) ? trim($arrdata[$i]['0']['Q']) : "";
		            if($drop_state == ""){
		              $message[] = "Drop State empty on line: ".$rowno;
		              $errorline[] = "drop_state".$rowno;
		            }
		            $drop_country = isset($arrdata[$i]['0']['R']) ? trim($arrdata[$i]['0']['R']) : "";
		            if($drop_country == ""){
		              $message[] = "Drop Country empty on line: ".$rowno;
		              $errorline[] = "drop_country".$rowno;
		            }
		            $drop_zipcode = isset($arrdata[$i]['0']['S']) ? trim($arrdata[$i]['0']['S']) : "";
		            if($drop_zipcode == ""){
		              $message[] = "Drop Zipcode empty on line: ".$rowno;
		              $errorline[] = "drop_zipcode".$rowno;
		            }
		            $drop_phone = isset($arrdata[$i]['0']['T']) ? trim($arrdata[$i]['0']['T']) : "";
		            if($drop_phone == ""){
		              $message[] = "Drop Phone empty on line: ".$rowno;
		              $errorline[] = "drop_phone".$rowno;
		            }
		            $carrier = isset($arrdata[$i]['0']['U']) ? trim($arrdata[$i]['0']['U']) : "";
		            if($carrier == ""){
		              $message[] = "Carrier empty on line: ".$rowno;
		              $errorline[] = "carrier".$rowno;
		            }
		            $purchase_order = isset($arrdata[$i]['0']['V']) ? trim($arrdata[$i]['0']['V']) : "";
		            if($purchase_order == ""){
		              $message[] = "Purchase Order empty on line: ".$rowno;
		              $errorline[] = "purchase_order".$rowno;
		            }
		            $cargo_type = isset($arrdata[$i]['0']['W']) ? trim($arrdata[$i]['0']['W']) : "";
		            if($cargo_type == ""){
		              $message[] = "Cargo Type empty on line: ".$rowno;
		              $errorline[] = "cargo_type".$rowno;
		            }
		            $quantity = isset($arrdata[$i]['0']['X']) ? trim($arrdata[$i]['0']['X']) : "";
		            if($quantity == ""){
		              $message[] = "Quantity empty on line: ".$rowno;
		              $errorline[] = "quantity".$rowno;
		            }
		            $palletised = isset($arrdata[$i]['0']['Y']) ? trim($arrdata[$i]['0']['Y']) : "";
		            if($palletised == ""){
		              $message[] = "Palletised empty on line: ".$rowno;
		              $errorline[] = "palletised".$rowno;
		            }
		            $weight = isset($arrdata[$i]['0']['Z']) ? trim($arrdata[$i]['0']['Z']) : "";
		            if($weight == ""){
		              $message[] = "Weight empty on line: ".$rowno;
		              $errorline[] = "weight".$rowno;
		            }
		            $volume = isset($arrdata[$i]['0']['AA']) ? trim($arrdata[$i]['0']['AA']) : "";
		            if($volume == ""){
		              $message[] = "Volume empty on line: ".$rowno;
		              $errorline[] = "volume".$rowno;
		            }
		            $data['order_details'][] = array('store_id'=>$store_id,'rowno'=>$mainrowno,'company_code'=>$company_code,'branch_code'=>$branch_code,'pickup_id'=>$pickup_id,'pickup_name'=>$pickup_name,'pickup_street'=>$pickup_street,'pickup_city'=>$pickup_city,'pickup_state'=>$pickup_state,'pickup_country'=>$pickup_country,'pickup_pincode'=>$pickup_zipcode,'pickup_phone'=>$pickup_phone,'drop_id'=>$drop_id,'drop_name'=>$drop_name,'drop_street'=>$drop_street,'drop_city'=>$drop_city,'drop_state'=>$drop_state,'drop_country'=>$drop_country,'drop_pincode'=>$drop_zipcode,'drop_phone'=>$drop_phone,'carrier'=>$carrier,'purchase_order'=>$purchase_order,'cargo_type'=>$cargo_type,'quantity'=>$quantity,'palletised'=>$palletised,'weight'=>$weight,'volume'=>$volume,'customer_id'=>$customer_id);
	        	}
	        }
      	}
      	$data['errorline']   = $errorline;          
	    $data["message"]     = $message;
	    $data["page_title"]  = "Import Orders"; 
	    $this->settemplate->dashboard("orders/auimport",$data);  
	}

	public function insertordersdata(){
		ini_set("max_input_time",2000);
	    ini_set("max_execution_time",2000);
	    ini_set("max_input_vars",20000);
	    ini_set("upload_max_size","2048M");
	    ini_set("post_max_size",0);
	    ini_set("memory_limit","2048M");
		$orderslist = $nobooking_ids = $excel_forders = $excel_sorders = array();
		$cdate = date('Y-m-d H:i:s');
		$user_id     = $this->session->userdata('user_id');
    	$company_code= $this->session->userdata('company_code');
    	$branch_code = $this->session->userdata('branch_code');
    	$curtz = $this->session->userdata("usr_tzone")['timezone'];
		$post = $this->input->post(NULL,TRUE);
		$childid = 0;
	    if($this->session->userdata('childid')){
	        $childid = $this->session->userdata('childid');
	    }
		if(!empty($post)){
			if(!empty($post['orders'])){
				foreach ($post['orders'] as $row) {
					$company_code       = mb_strtoupper(isset($row['company_code']) ? trim($row['company_code']) : "");
      				$branch_code        = mb_strtoupper(isset($row['branch_code']) ? trim($row['branch_code']) : "");
      				$store_id           = mb_strtoupper(isset($row['store_id']) ? trim($row['store_id']) : "");
      				$customer_id        = mb_strtoupper(isset($row['customer_id']) ? trim($row['customer_id']) : "");
      				$pickup_id          = mb_strtoupper(isset($row['pickup_id']) ? trim($row['pickup_id']) : "");
      				$pickup_name        = mb_strtoupper(isset($row['pickup_name']) ? trim($row['pickup_name']) : "");
      				$pickup_street      = mb_strtoupper(isset($row['pickup_street']) ? trim($row['pickup_street']) : "");
      				$pickup_city        = mb_strtoupper(isset($row['pickup_city']) ? trim($row['pickup_city']) : "");
      				$pickup_state       = mb_strtoupper(isset($row['pickup_state']) ? trim($row['pickup_state']) : "");
      				$pickup_country     = mb_strtoupper(isset($row['pickup_country']) ? trim($row['pickup_country']) : "");
      				$pickup_pincode     = mb_strtoupper(isset($row['pickup_pincode']) ? trim($row['pickup_pincode']) : "");
      				$pickup_phone       = mb_strtoupper(isset($row['pickup_phone']) ? trim($row['pickup_phone']) : "");
      				$drop_id            = mb_strtoupper(isset($row['drop_id']) ? trim($row['drop_id']) : "");
      				$drop_name          = mb_strtoupper(isset($row['drop_name']) ? trim($row['drop_name']) : "");
      				$drop_street        = mb_strtoupper(isset($row['drop_street']) ? trim($row['drop_street']) : "");
      				$drop_city          = mb_strtoupper(isset($row['drop_city']) ? trim($row['drop_city']) : "");
      				$drop_state         = mb_strtoupper(isset($row['drop_state']) ? trim($row['drop_state']) : "");
      				$drop_country       = mb_strtoupper(isset($row['drop_country']) ? trim($row['drop_country']) : "");
      				$drop_pincode       = mb_strtoupper(isset($row['drop_pincode']) ? trim($row['drop_pincode']) : "");
      				$drop_phone         = mb_strtoupper(isset($row['drop_phone']) ? trim($row['drop_phone']) : "");
      				$carrier            = mb_strtoupper(isset($row['carrier']) ? trim($row['carrier']) : "");
      				$purchase_order     = mb_strtoupper(isset($row['purchase_order']) ? trim($row['purchase_order']) : "");
      				$quantity           = mb_strtoupper(isset($row['quantity']) ? trim($row['quantity']) : "");
      				$cargo_type         = mb_strtoupper(isset($row['cargo_type']) ? trim($row['cargo_type']) : "");
      				$weight             = mb_strtoupper(isset($row['weight']) ? trim($row['weight']) : "");
      				$volume             = mb_strtoupper(isset($row['volume']) ? trim($row['volume']) : "");
      				$palletised         = mb_strtoupper(isset($row['palletised']) ? trim($row['palletised']) : "");
      				$customer_row_id = "";
					$getuserid = $this->common->gettblrowdata(array('company_code'=>$company_code,'branch_code'=>$branch_code,'status'=>'Active'),"id","tb_users",0,0);
					if(!empty($getuserid)){
						$user_id = $getuserid['id'];
					}
      				if($customer_id != ""){
      					$customer_row_id = $customer_id;
      					$getcustomer_rowid = $this->common->gettblrowdata(array('code'=>$customer_id,'company_code'=>$company_code,'status'=>'1'),"id","tb_customers",0,0);
      					if(!empty($getcustomer_rowid)){
      						$customer_row_id = $getcustomer_rowid['id'];
      					}
      					$vendor_id  = 0;
						$aukncompany_code = "AUKN";
      					if($carrier != ""){
      						$chkvendor = $this->common->gettblrowdata(array('name'=>$carrier,'company_code'=>$aukncompany_code,'status'=>'1'),"id","tb_vendors",0,0);
      						if(!empty($chkvendor)){
      							$vendor_id = $chkvendor['id'];
      						}

      					}
						$ship_row_id = 0;
      					if($customer_row_id != ""){
            				$shipment_number = $shipid = "SVK".time();
            				$enddate = $cdate;
					       	$ship_arr = array('unitspec'=>$cargo_type,'shipid'=>$shipid,'txnid'=>$shipment_number,'trucktype'=>'','pickupcnt'=>'1','dropcnt'=>'1','insertusr'=>$pickup_id,'carrier'=>$vendor_id,'insertuserdate'=>$cdate,'enddate'=>$enddate,'insdate'=>$cdate,'upddate'=>$cdate,'reason'=>'SHIPMENT','purpose'=>'SEND INTEGRATION','ship_object'=>'SHIPMENT','logdate'=>$cdate,'transport_mode'=>'','domainname'=>$branch_code,'company_code'=>$company_code,'branch_code'=>$branch_code,'product'=>'','freight_term'=>'60','freight_termname'=>'Free of Charge','incoterm'=>'','modeoftransport'=>'0');
							$chk_shipid = $this->common->gettblrowdata(array('shipid'=>$shipid,'status'=>'1'),"id","tb_shipments",0,0);
					       	if(!empty($chk_shipid)){
					       		$ship_row_id = $chk_shipid['id'];
								$up_shipid = $this->common->updatetbledata("tb_shipments",$ship_arr,array('id'=>$ship_row_id));
					      	}else{
					      		$ship_arr['createdon'] = $cdate;
								$ship_row_id = $this->common->insertTableData("tb_shipments",$ship_arr);
					      	}
					      	if($ship_row_id == 0){
					      		$nobooking_ids[] = $customer_id.$store_id;
	                			$excel_forders[] = array('booking_id'=>'-','customer_id'=>$customer_id,'delivery_note'=>$store_id,'status'=>'Fail');
					      	}else{
					      		$pickup = array('code'=>$pickup_id,'name'=>$pickup_name,'street'=>$pickup_street,'city'=>$pickup_city,'state'=>$pickup_state,'country'=>$pickup_country,'pincode'=>$pickup_pincode,'phone'=>$pickup_phone,'user_id'=>$user_id,'company_code'=>$company_code,'branch_code'=>$branch_code);
	      						$shipper_row_id = $this->chkpartymaster($pickup,'SHIPPER');
	      						if($shipper_row_id == 0){
	      							$nobooking_ids[] = $customer_id.$store_id;
	                				$excel_forders[] = array('booking_id'=>'-','customer_id'=>$customer_id,'delivery_note'=>$store_id,'status'=>'Fail');
	      						}
	      						$drop = array('code'=>$drop_id,'name'=>$drop_name,'street'=>$drop_street,'city'=>$drop_city,'state'=>$drop_state,'country'=>$drop_country,'pincode'=>$drop_pincode,'phone'=>$drop_phone,'user_id'=>$user_id,'company_code'=>$company_code,'branch_code'=>$branch_code);
	      						$drop_row_id = $this->chkpartymaster($drop,'CONSIGNEE');
	      						if($drop_row_id == 0){
	      							$nobooking_ids[] = $customer_id.$store_id;
	                				$excel_forders[] = array('booking_id'=>'-','customer_id'=>$customer_id,'delivery_note'=>$store_id,'status'=>'Fail');
	      						}
	      						$loc = [];
	      						$lat1 = $lng1 = $lat2 = $lng2 = "";
	    						$add1 = implode(",",[$pickup_street,$pickup_city,$pickup_country,$pickup_pincode]);
							    $add2 = implode(",",[$drop_street,$drop_city,$drop_country,$drop_pincode]);
							    $loc = getlatlngsbyplace($add1);
							    $lat1 = @$loc[0];
							    $lng1 = @$loc[1];
							    $loc = [];
							    $loc = getlatlngsbyplace($add2);
							    $lat2 = @$loc[0];
						    	$lng2 = @$loc[1]; 
	      						$order_ins = array('pickup_company'=>$pickup_name,'delivery_company'=>$drop_name,'pickup_country'=>$pickup_country,'delivery_country'=>$drop_country,'pickup_city'=>$pickup_city,'delivery_city'=>$drop_city,'pickup_pincode'=>$pickup_pincode,'delivery_pincode'=>$drop_pincode,'pickup_address1'=>$pickup_street,'delivery_address1'=>$drop_street,'pickup_address2'=>$pickup_state,'delivery_address2'=>$drop_state,'quantity'=>$quantity,'weight'=>$weight,'volume'=>$volume,'user_id'=>$user_id,'sub_uid'=>$childid,'customer_id'=>$customer_row_id,'vendor_id'=>$vendor_id,'plat'=>$lat1,'plng'=>$lng1,'dlat'=>$lat2,'dlng'=>$lng2,'company_code'=>$company_code,'branch_code'=>$branch_code,'status'=>'1','is_created'=>'1','createdon'=>$cdate,'created_source'=>'4');
	      						$order_id = $this->common->insertTableData("tb_orders",$order_ins);
								$country_code = $this->session->userdata( "usr_tzone" )['phone_code'];
								$company_code = $this->session->userdata( "company_code" );
		      					if($order_id >0){
									$get_country = $this->common->gettblrowdata(array('id'=>$user_id),"country_code,company_code","tb_users",0,0);
									if(!empty($get_country)){
										$country_code  = $get_country['country_code'];
	      								$company_code  = $get_country['company_code'];
									}
	      							$genord = array("user_id"=>$user_id,"order_id"=>$order_id,"country_code"=>$country_code,"company_code"=>$company_code);
	      							$booking_id = generatebookingid($genord);
	      							if(in_array($customer_id.$store_id, $nobooking_ids)){
							        }else{
							        	$excel_sorders[] = array('booking_id'=>$booking_id,'customer_id'=>$customer_id,'delivery_note'=>$store_id,'status'=>'Success');
        							}
	      							$upd = $this->common->updatetbledata("tb_orders",array('order_id'=>$booking_id),array('id'=>$order_id)); 
	      							$invtypes = makeorderinvolvedpartiestype($customer_row_id,$order_id,"CUSTOMER", $user_id, $company_code);
	      							$details = array('service'=>'0','department_code'=>'','delivery_term'=>'0','incoterm'=>'','purchase_order'=>'','notify_party'=>'','lane_reference'=>'','distance'=>'','temperature_control'=>'0','valorance_insurance'=>'0','high_cargo_value'=>'0','customs_required'=>'0','order_id'=>$booking_id,'order_row_id'=>$order_id,'createdon'=>$cdate,'shipper_id'=>'0','order_type'=>'','consignment_note'=>$booking_id,'num_of_pallets'=>$palletised,'mail_notify'=>'0');
	      							$this->common->insertTableData("tb_order_details",$details);
	      							$shipper_type_id = $drop_type_id = '1';
	      							$chkpartytype = $this->common->gettblrowdata(array('name'=>'SHIPPER','user_id'=>$user_id,'status'=>'1'),"id","tbl_party_types",0,0);
									if(!empty($chkpartytype)){
										$shipper_type_id = $chkpartytype['id'];
									}
									$chkpartytype1 = $this->common->gettblrowdata(array('name'=>'CONSIGNEE','user_id'=>$user_id,'status'=>'1'),"id","tbl_party_types",0,0);
									if(!empty($chkpartytype1)){
										$drop_type_id = $chkpartytype1['id'];
									}
	      							if($shipper_row_id != 0){
										$order_parties = array('order_id'=>$order_id,'party_id'=>$shipper_row_id,'status'=>'1','createdon'=>$cdate,'party_type'=>$shipper_type_id);
										$ins_order_parties = $this->common->insertTableData("tb_order_parties",$order_parties);
										$address = $pickup_street.",".$pickup_city.",".$pickup_state.",".$pickup_country;
										$shipper_address = array('order_id'=>$order_id,'party_master_id'=>$shipper_row_id,'location_id'=>$pickup_city,'street'=>$pickup_street,'state'=>$pickup_state,'address'=>$address,'pincode'=>$pickup_pincode,'country'=>$pickup_country,'user_id'=>$user_id);
										$chk_shipperaddress = $this->common->gettblrowdata(array('order_id'=>$order_id,'party_master_id'=>$shipper_row_id),"id","tbl_orderparty_address",0,0);
										if(!empty($chk_shipperaddress)){
											$shipperadd_id = $chk_shipperaddress['id'];
											$upd_add  = $this->common->updatetbledata("tbl_orderparty_address",$shipper_address,array('id'=>$shipperadd_id));
										}
										else{
											$shipper_address['createdon'] = $cdate;
											$shipperadd_id = $this->common->insertTableData("tbl_orderparty_address",$shipper_address);
										}
									}
									if($drop_row_id != 0){
										$order_parties = array('order_id'=>$order_id,'party_id'=>$drop_row_id,'status'=>'1','createdon'=>$cdate,'party_type'=>$drop_type_id);
										$ins_order_parties = $this->common->insertTableData("tb_order_parties",$order_parties);
										$daddress = $drop_street.",".$drop_city.",".$drop_state.",".$drop_country;
										$drop_address = array('order_id'=>$order_id,'party_master_id'=>$drop_row_id,'location_id'=>$drop_city,'street'=>$drop_street,'state'=>$drop_state,'address'=>$daddress,'pincode'=>$drop_pincode,'country'=>$drop_country,'user_id'=>$user_id);
										$chk_dropaddress = $this->common->gettblrowdata(array('order_id'=>$order_id,'party_master_id'=>$drop_row_id),"id","tbl_orderparty_address",0,0);
										if(!empty($chk_dropaddress)){
											$dropadd_id = $chk_dropaddress['id'];
											$upd_add  = $this->common->updatetbledata("tbl_orderparty_address",$drop_address,array('id'=>$dropadd_id));
										}
										else{
											$drop_address['createdon'] = $cdate;
											$dropadd_id = $this->common->insertTableData("tbl_orderparty_address",$drop_address);
										}
									}
									$single_weight = $weight;
									$single_volume = $volume;
									if($weight >0 && $quantity >0){
										$single_weight = $weight/$quantity;	
									}
									if($volume >0 && $quantity >0){
										$single_volume = $volume/$quantity;
									}
									if($quantity == 0){
										$quantity = 1;
									}
										
									$length_uom = $width_uom = $height_uom =  "M";
									$volume_uom = "CBM";
									$weight_uom = "KG";
									for($i=1;$i<=$quantity;$i++){
										$single_quantity = $length = $width = $height ='1'; 
										$cargo_details = array('cargo_type'=>$cargo_type,'goods_description'=>'','quantity'=>$single_quantity,'length'=>$length,'length_unit'=>$length_uom,'width'=>$width,'width_unit'=>$width_uom,'height'=>$height,'height_unit'=>$height_uom,'weight'=>$single_weight,'weight_unit'=>$weight_uom,'volume'=>$single_volume,'volume_unit'=>$volume_uom,'createdby'=>$user_id,'createdon'=>$cdate);
	      								$cargo_row_id = $this->common->insertTableData("tb_cargo_details",$cargo_details);
	      								
	      								$gethandling_unit = $this->common->gettblrowdata(array('unit_name'=>$cargo_type,'status'=>'1'),"id","tbl_shipunit_types",0,0);
	          							$handling_unit = "";
	          							if(!empty($gethandling_unit)){
	            							$handling_unit = $gethandling_unit['id'];
	          							}else{
	            							$handlingunit_ar = array('unit_name'=>$cargo_type,'description'=>$cargo_type,'user_id'=>$user_id,'created_at'=>$cdate,'status'=>'1');
	            							$handling_unit = $this->common->insertTableData("tbl_shipunit_types",$handlingunit_ar);
	          							}
	          							$order_cargo = array('order_id'=>$order_id,'quantity'=>$single_quantity,'cargo_id'=>$cargo_row_id,'status'=>'1','createdon'=>$cdate,'cargo_content'=>'','quantity_type'=>$cargo_type,'length'=>$length,'width'=>$width,'height'=>$height,'weight'=>$single_weight,'volume'=>$single_volume,'handling_unit'=>$handling_unit);
	     								$insert_cargo_order = $this->common->insertTableData("tb_order_cargodetails",$order_cargo);
									}
									$info = $this->manifestoverride($order_id);
									if($store_id != ""){
									    $ref_ins = array('reference_id'=>'COI','ref_value'=>$store_id,'order_id'=>$order_id,'createdon'=>$cdate);
									    $this->common->insertTableData("tb_order_references",$ref_ins);
									}
								  	if($purchase_order != ""){
								    	$ref_ins = array('reference_id'=>'PO','ref_value'=>$purchase_order,'order_id'=>$order_id,'createdon'=>$cdate);
								    	$this->common->insertTableData("tb_order_references",$ref_ins);
								  	}
									if(!empty($booking_id)){
										$ref_ins = array('reference_id'=>'DQ','ref_value'=>$booking_id,'order_id'=>$order_id,'createdon'=>$cdate);
								    	$this->common->insertTableData("tb_order_references",$ref_ins);
									}
		      					}else{
	      							$nobooking_ids[] = $customer_id.$store_id;
	                				$excel_forders[] = array('booking_id'=>'-','customer_id'=>$customer_id,'delivery_note'=>$store_id,'status'=>'Fail');
	      						}
					      	}
      					}
      				}
				}
			}
		}
		$excel_orders = array_merge($excel_forders,$excel_sorders);
	  	if(!empty($excel_orders)){
	    	@file_put_contents("assets/ordertemplate/excelauuploaddata.txt", json_encode($excel_orders));
	  	}
		redirect('orders/orderslist/01');
	}

	public function manifestoverride($order_id)
    {
    	$data = array();
            $consign = $this->common->gettblrowdata(array(
                'order_row_id' => $order_id
            ), 'consignment_note', 'tb_order_details', 0, 0);
            if (count($consign) > 0) {
                $data['consignment_no'] = $consign['consignment_note'];
            }
            if (! empty($data['consignment_no'])) {
                $cargos = $this->common->gettbldata(array(
                    'status' => 1,
                    'order_id' => $order_id
                ), 'id,cargo_id,order_id,quantity', 'tb_order_cargodetails', 0, 0);
                $i = 1;

                foreach ($cargos as $cargo) {
                    $newbarcode = $this->genbarcode($data['consignment_no'], $order_id);
                    $insarray = array(
                        'cargo_id' => $cargo['cargo_id'],
                        'order_id' => $cargo['order_id'],
                        'pallet_id' => $cargo['id'],
                        'bar_code' => $newbarcode,
                        'status' => 1
                    );
                    $ins = $this->common->insertTableData("tb_order_cargo_labels", $insarray);
                   
                }
            }
        return $data;
    }

    public function genbarcode($consignment_no, $order_id)
    {
        $barcodestart = "0001";
		$whr = "bar_code LIKE '" . $consignment_no . "%' AND order_id=$order_id";
		$rcent = $this->aureportsmodel->checkbarcode_basedonconsignmentnote($whr);
        if ($rcent->num_rows() > 0) {
            $newbarcode1 = $rcent->row()->bar_code;
            $getlasts4 = substr($newbarcode1, - 4);
            $getlasts4 ++;
            $inc_length = strlen($getlasts4);
            $getlast4 = $getlasts4;
            if ($inc_length == 1) {
                $getlast4 = "000" . $getlast4;
            } else if ($inc_length == 2) {
                $getlast4 = "00" . $getlast4;
            } else if ($inc_length == 3) {
                $getlast4 = "0" . $getlast4;
            }
            $newbarcode = $consignment_no . "" . $getlast4;
            $getlast4 = "";
        } else {
            $newbarcode = $consignment_no . "" . $barcodestart;
        }
        return $newbarcode;
    }

	public function chkpartymaster($info,$type){
		$party_type_id= 1;
		$ins_id = 0;
		$company_code = $this->session->userdata('company_code');
		if(!empty($info)){
			$code = $info['code'];
			$user_id = $info['user_id'];
			$chkpartytype = $this->common->gettblrowdata(array('name'=>$type,'company_code'=>$company_code,'status'=>'1'),"id","tbl_party_types",0,0);
			if(!empty($chkpartytype)){
				$party_type_id = $chkpartytype['id'];
			}
			$address = $info['street'].",".$info['city'].",".$info['state'].",".$info['country'];
			$ins = array('party_type_id'=>$party_type_id,'name'=>$info['name'],'mobile'=>$info['phone'],'company_code'=>$company_code,'company_code'=>$info['company_code'],'branch_code'=>$info['branch_code'],'location_id'=>$info['city'],'address'=>$address,'country'=>$info['country'],'state'=>$info['state'],'street'=>$info['street'],'pincode'=>$info['pincode'],'status'=>'1');
			if($code == ""){
				$chkaddress = $this->common->gettblrowdata(array('name'=>$info['name'],'location_id'=>$info['city'],'country'=>$info['country'],'state'=>$info['state'],'street'=>$info['street'],'pincode'=>$info['pincode'],'company_code'=>$company_code,'status'=>'1'),"id","tbl_party_master",0,0);
				if(!empty($chkaddress)){
					$ins_id = $chkaddress['id'];
				}else{
					$ins_id = $this->common->insertTableData("tbl_party_master",$ins);
					$country_code = $this->session->userdata("usr_tzone")['phone_code'];
					$year              = date('y');
					$week              = date('W');
					$code = $country_code.$year.$week.$ins_id;
					$this->common->updatetbledata("tbl_party_master",array('code'=>$code),array('id'=>$ins_id));
				}
			}else{
				$ins['code'] = $code;
 				$chkcode = $this->common->gettblrowdata(array('code'=>$code,'company_code'=>$company_code,'status'=>'1'),"id","tbl_party_master",0,0);
				if(empty($chkcode)){
					$chkaddress = $this->common->gettblrowdata(array('name'=>$info['name'],'location_id'=>$info['city'],'country'=>$info['country'],'state'=>$info['state'],'street'=>$info['street'],'pincode'=>$info['pincode'],'company_code'=>$company_code,'status'=>'1'),"id","tbl_party_master",0,0);
					if(!empty($chkaddress)){
						$ins_id = $chkaddress['id'];
					}else{
						$ins_id = $this->common->insertTableData("tbl_party_master",$ins);
					}
				}else{
					$ins_id = $chkcode['id'];
				}
			}
		}
		return $ins_id;
	}

}

?>