<?php
if (! defined('BASEPATH')) {
    exit('No direct script access allowed');
}

class Aulabel extends CI_Controller
{

    public function __construct()
    {
        parent::__construct();
        $this->load->library('session');
        if ($this->session->userdata('user_id') == '') {
            redirect('login');
        }
        $this->load->model('Order');
        $this->load->model('common');
        $this->load->model('aulabelmodel');
    }

    public function index()
    {
        $get = $this->input->get();
        /*log_message("error","aulabel-get ".json_encode($get));*/
        /*
         * echo "<pre/>";
         * print_r($get);
         * exit;
         */
        $ordcargoid          = $get['order_car_id'];
        $data                = $order_types                = [];
        $data['carrier_img'] = "";
        require 'vendor/autoload.php';
        $reference            = $shipmentnumber            = $communication_reference            = $date            = "";
        $drop_details['name'] = $drop_details['street'] = $drop_details['country'] = $drop_details['pincode'] = $shipper_details['name'] = $shipper_details['street'] = $shipper_details['country'] = $shipper_details['pincode'] = $shipper_details['city'] = $data['count'] = $data['weight'] = $data['delivery_ins'] = "";
        $cargos               = $drop_details               = $shipper_details               = [];
        $cargoqry             = $this->db->query(
            "SELECT c.quantity,c.cargo_type,c.weight,o.cargo_content,o.order_id,o.qr_code,o.cargo_id
            FROM tb_order_cargodetails o,tb_cargo_details c
            WHERE o.cargo_id=c.id AND o.id = ? ",
            [$ordcargoid]
        );
        /*log_message("error","cargoqry ".$this->db->last_query());*/
        if ($cargoqry->num_rows() > 0) {
            $res      = $cargoqry->row();
            $qty      = $res->quantity;
            $order_id = $res->order_id;

            $where = [
                "order_id"     => $order_id,
                'status'       => '1',
                'reference_id' => 'ORD_DLVINST',
            ];
            $select   = "order_id,ref_value";
            $table    = "tb_order_references";
            $data_ref = $this->common->gettblrowdata($where, $select, $table, 0, 0);
            if (! empty($data_ref)) {
                $data['delivery_ins'] = $data_ref['ref_value'];
            }
            $data['orderId'] = $order_id;
            $barcodes        = $this->common->gettblrowdata([
                'cargo_id' => $res->cargo_id,
                'status'   => 1,
            ], 'bar_code,createdon', 'tb_order_cargo_labels', 0, 0);
            /*log_message("error","barcode ".$this->db->last_query());*/
            // $barcode[0]['bar_code'] = 'SRGK10000001';
            // $barcode[0]['createdon'] = date('Y-m-d H:i:s');
            if (! empty($barcodes)) {
                $cargos[] = ['weight' => $res->weight,
                    'qty'                      => $res->quantity,
                    'cargo_type'               => $res->cargo_type,
                    'cargo_content'            => $res->cargo_content,
                    'barcode_no'               => $barcodes['bar_code'],
                    'label_create_date'        => $barcodes['createdon'],
                    'qr_code'                  => $res->qr_code];

                /*foreach ($barcodes as $barcode) {
                    $cargos[] = array(
                        'weight' => $res->weight,
                        'qty' => $res->quantity,
                        'cargo_type' => $res->cargo_type,
                        'cargo_content' => $res->cargo_content,
                        'barcode_no' => $barcode['bar_code'],
                        'label_create_date' => $barcode['createdon'],
                        'qr_code' => $res->qr_code
                    );
                }*/
            }
        }
        /*
          log_message("error","order_id ".json_encode($order_id));
          log_message("error","aulable-cargos ".json_encode($cargos));*/

        if ($order_id != "" && ! empty($cargos)) {
            $chkorder = $this->Order->getordertoedit($order_id);
            if ($chkorder->num_rows() > 0) {
                $shipmentnumber = $chkorder->row()->order_id;
                $chekparty      = $this->db->query(
                    "SELECT p.id,p.party_type_id, p.name, p.mobile, p.email,p.code,p.fax,o.party_type
                        FROM tbl_party_master p
                            INNER JOIN tb_order_parties o ON p.id=o.party_id AND o.status=1
                        WHERE p.status=1 AND o.order_id= ?
                        GROUP BY o.party_type",
                    [$order_id]
                );
                if ($chekparty->num_rows() > 0) {
                    foreach ($chekparty->result() as $rr) {
                        $ptype   = $rr->party_type;
                        $chktype = $this->db->select("name")->get_where("tbl_party_types", [
                            "id" => $ptype,
                        ], 1, 0);
                        if ($chktype->num_rows() > 0) {
                            if ($chktype->row()->name == "Consignee") {
                                $drop_details = [
                                    'id'       => $rr->id,
                                    'name'     => $rr->name,
                                    'phone'    => $rr->mobile,
                                    'email'    => $rr->email,
                                    'fax'      => $rr->fax,
                                    'party_id' => $rr->code,
                                ];
                            } else if ($chktype->row()->name == "Shipper") {
                                $shipper_details = [
                                    'id'       => $rr->id,
                                    'name'     => $rr->name,
                                    'phone'    => $rr->mobile,
                                    'email'    => $rr->email,
                                    'fax'      => $rr->fax,
                                    'party_id' => $rr->code,
                                ];
                            }
                        }
                    }
                }
                $carrier_details = $this->common->gettblrowdata([
                    'id' => $chkorder->row()->vendor_id,
                ], 'name', 'tb_vendors', 0, 0);
                $data['carrier_name'] = ! empty($carrier_details['name']) ? $carrier_details['name'] : ' ';

                $data['carrier_name']     = (strtoupper($data['carrier_name']) == "BORDER EXPRESS") ? "BEX" : $data['carrier_name'];
                $data['carrier_new_name'] = "";

                if (strtoupper($data['carrier_name']) == "BEX") {
                    $data['carrier_img']      = "BEX.jpg";
                    $data['carrier_new_name'] = "REGIONAL";
                } elseif (strtoupper($data['carrier_name']) == "BONDS TRANSPORT") {
                    $data['carrier_img']      = "Bonds.jpg";
                    $data['carrier_new_name'] = "METRO";
                } elseif (strtoupper($data['carrier_name']) == "BONDS DC") {
                    $data['carrier_img']      = "DC.jpg";
                    $data['carrier_new_name'] = "DC";
                } else {
                    $data['carrier_img'] = "";
                }

                $data['delivery_date']  = date('d/m/Y', strtotime($chkorder->row()->delivery_datetime));
                $data['pickup_date']    = date('d/m/Y', strtotime($chkorder->row()->pickup_datetime));
                $data['consignment_no'] = $chkorder->row()->consignment_note;
                // $data['consignment_no'] = "SRGK100000";
                $shipper_details['name']    = $chkorder->row()->pickup;
                $shipper_details['street']  = $chkorder->row()->pickup_address1;
                $shipper_details['state']   = $chkorder->row()->pickup_address2;
                $shipper_details['city']    = $chkorder->row()->pickup_city;
                $shipper_details['country'] = $chkorder->row()->pickup_country;
                $shipper_details['pincode'] = $chkorder->row()->pickup_pincode;

                $drop_details['name']    = $chkorder->row()->delivery;
                $drop_details['street']  = $chkorder->row()->delivery_address1;
                $drop_details['state']   = $chkorder->row()->delivery_address2;
                $drop_details['city']    = $chkorder->row()->delivery_city;
                $drop_details['country'] = $chkorder->row()->delivery_country;
                $drop_details['pincode'] = $chkorder->row()->delivery_pincode;
            }

            $data['container_no'] = '';
            $reference            = $this->common->gettblrowdata([
                'order_id'     => $order_id,
                'reference_id' => 'CTR',
            ], 'ref_value', 'tb_order_references', 0, 0);
            if (! empty($reference)) {
                $data['container_no'] = $reference['ref_value'];
            }
            $data['drop_details']    = $drop_details;
            $data['shipper_details'] = $shipper_details;
            $data['reference']       = $reference;
            $data['shipmentnumber']  = $shipmentnumber;
            $data['cargos']          = $cargos;
            /* $routeinfo = $this->common->gettblrowdata(array(
                'postalcode' => $drop_details['pincode'],
                'status' => 1,
                'type' => 2
            ), 'routing_code', 'tb_au_carrier_postalcodes', 0, 0);*/

            /**
             *  Border and Bonds routing codes
             */
            $routeinfo['routing_code'] = "";
            if ($data['carrier_name'] == 'BONDS TRANSPORT') {
                $routeinfo = $this->common->gettblrowdata([
                    'correct_zip'  => $drop_details['pincode'],
                    'status'       => 1,
                    'carrier_name' => 'Bonds',
                ], 'headport', 'tb_au_carrier_headports', 0, 0);
                $routeinfo['routing_code'] = $routeinfo['headport'] ?? '';
            } else {

                $routeinfo = $this->common->gettblrowdata([
                    'postalcode' => $drop_details['pincode'],
                    'suburb'     => $drop_details['city'],
                    'state'      => $drop_details['state'],
                    'status'     => 1,
                    'type'       => 2,
                ], 'routing_code', 'tb_au_carrier_postalcodes', 0, 0);
                if (empty($routeinfo)) {
                    $routeinfo = $this->common->gettblrowdata([
                        'postalcode' => $drop_details['pincode'],
                        'state'      => $drop_details['state'],
                        'status'     => 1,
                        'type'       => 2,
                    ], 'routing_code', 'tb_au_carrier_postalcodes', 0, 0);
                }
            }
            $data['routecode'] = ! empty($routeinfo['routing_code']) ? $routeinfo['routing_code'] : '';
            $data['generator'] = new Picqer\Barcode\BarcodeGeneratorPNG();

            $mpdf = new \Mpdf\Mpdf([
                'tempDir'       => FCPATH . 'assets/tmp',
                'mode'          => 'utf-8',
                'format'        => [
                    112.0,
                    152.0,
                ],
                'tempDir'       => FCPATH . 'assets/tmp',
                'margin_left'   => 0,
                'margin_right'  => 0,
                'margin_top'    => 0,
                'margin_bottom' => 0,
                'margin_header' => 0,
                'margin_footer' => 0,
            ]);

            $store_timings = $this->storetimings($data);
            if (! empty($store_timings)) {
                $data['store_timings'] = $store_timings;
            }

            $html          = "";
            $i             = 1;
            $data['count'] = count($cargos);
            $barcode_arr   = [];
            foreach ($cargos as $cargo) {
                if (! in_array($cargo['barcode_no'], $barcode_arr)) {
                    $barcode_arr[]         = $cargo['barcode_no'];
                    $data['weight']        = $cargo['weight'];
                    $data['cargo_type']    = $cargo['cargo_type'];
                    $data['cargo_content'] = $cargo['cargo_content'];

                    /* $data['qty'] = $cargo['qty'];
                    $data['qty'] = $get['tot'];
                    $data['no'] = $i;
                    $data['no'] = $get['cargo_row_id']; */
                    $request_data = [
                        'order_id' => $order_id,
                        'cargo_id' => $ordcargoid,
                    ];
                    $get_cargo_qty = $this->gettotalcargos($request_data);
                    /* log_message('error',json_encode($get_cargo_qty)); */
                    $data['qty'] = $get_cargo_qty['carton_qty'];
                    $data['no']  = $get_cargo_qty['carton_num'];

                    $data['caseid']            = $cargo['qr_code'];
                    $data['barcode_no']        = $cargo['barcode_no'];
                    $curtz                     = $this->session->userdata("usr_tzone")['timezone'];
                    $data['label_create_date'] = getdatetimebytimezone($curtz, $cargo['label_create_date'], DFLT_TZ)['datetime'];
                    $html .= $this->load->view('orders/aulabel', $data, true);
                    $i++;
                }
            }
            $data1['labelcontent'] = $html;
            /*log_message("error","215 ".json_encode($data1));*/
            $output = $this->load->view('orders/order_label', $data1, true);
            $mpdf->WriteHTML($output);
            $mpdf->Output($shipmentnumber . "_" . date('YmdHis') . ".pdf", 'I');
        }
    }

    private function storetimings($data)
    {
        $store_code = 0;
        $get_data   = [];
        if (! empty($data) && isset($data['drop_details']) && ! empty($data['drop_details'])) {
            if (isset($data['order_id']) && ! empty($data['order_id'])) {
                $reference = $this->common->gettblrowdata([
                    'order_id'     => $data['order_id'],
                    'reference_id' => 'COI',
                ], 'ref_value', 'tb_order_references', 0, 0);
                if (! empty($reference)) {
                    $store_code = $reference['ref_value'];
                }

            }

            $where = [
                'city'      => isset($data['drop_details']['city']) ? $data['drop_details']['city'] : '',
                'state'     => isset($data['drop_details']['state']) ? $data['drop_details']['state'] : '',
                'post_code' => isset($data['drop_details']['pincode']) ? $data['drop_details']['pincode'] : '',
                'name'      => isset($data['drop_details']['name']) ? $data['drop_details']['name'] : '',
                'status'    => 1,
            ];
            if (! empty($store_code)) {
                $where['store_code'] = $store_code;
            }
            $store_data = $this->common->gettblrowdata($where, 'dock_hours,days', 'tb_au_store_timings', 0, 0);
            if (! empty($store_data) && ! empty($store_data['dock_hours'])) {
                $get_data = $store_data;

            } else {
                unset($where['city']);
                unset($where['name']);
                $store_data = $this->common->gettblrowdata($where, 'dock_hours,days', 'tb_au_store_timings', 0, 0);
                if (! empty($store_data) && ! empty($store_data['dock_hours'])) {
                    $get_data = $store_data;

                } else {
                    unset($where['state']);
                    $store_data = $this->common->gettblrowdata($where, 'dock_hours,days', 'tb_au_store_timings', 0, 0);
                    if (! empty($store_data) && ! empty($store_data['dock_hours'])) {
                        $get_data = $store_data;
                    }
                }
            }

        }
        return $get_data;
    }

    public function getmanifestfiles()
    {
        $deletepath = './assets/manifestdocs/';
        $this->load->helper("file");
        delete_files($deletepath, true);
        $orderids = implode(',', $this->input->post('order_id'));
        /* log_message('error', $orderids); */
        $files  = [];
        $result = 1;
        $res    = $this->db->query(
            'select id
                from tb_order_references
                where order_id in ? AND reference_id = ? AND status = 1',
            [$this->input->post('order_id'), 'MN']
        );
        if ($res->num_rows() > 0) {
            // $result = 0;
        } else {
            $ordquery = $this->db->query(
                'select group_concat(id) orderids
                    from tb_orders
                    where id in ?
                    GROUP BY vendor_id',
                [$this->input->post('order_id')]
            )->result_array();
            foreach ($ordquery as $li) {
                $files[] = $this->generatemanifest($li['orderids']);
            }
            $result = 1;
        }
        /* log_message('error', implode(',', $files)); */
        echo json_encode([
            'result' => $result,
            'files'  => $files,
        ]);
    }

    public function downloadmanifest($ordid)
    {
        $this->load->model('truckwaybillmodel');
        $ref = $this->common->gettblrowdata([
            'order_id'     => $ordid,
            'reference_id' => 'MN',
        ], 'ref_value', 'tb_order_references', 0, 0);
        $manifestno          = $ref['ref_value'];
        $data['manifest_no'] = $manifestno;
        $data['items_count'] = $data['tot_weight'] = $data['tot_vol'] = $data['tot_pallet'] = 0;
        $data['cargo_type']  = '';
        $data['isDG']        = 'No';
        $refinfo             = $this->db->query(
            'select group_concat(order_id) orderids
                from tb_order_references
                where reference_id = ? AND ref_value=?',
            ['MN', $manifestno]
        );
        $orderids = $refinfo->row('orderids');
        $orders   = $this->db->query(
            'select o.id,o.plat,o.plng,o.customer_id,o.vendor_id,o.pickup_city,o.pickup_address2,o.pickup_pincode,o.pickup_address1,o.delivery_address2,o.delivery_pincode,o.delivery_city,od.consignment_note,od.num_of_pallets
                from tb_orders o
                    LEFT JOIN tb_order_details od ON od.order_row_id = o.id
                where o.id in ?',
            [explode(',', str_replace(' ', '', $orderids))]
        )->result_array();

        foreach ($orders as $ord) {
            $ordref = $this->common->gettblrowdata([
                'order_id'     => $ord['id'],
                'reference_id' => 'BN',
            ], 'ref_value', 'tb_order_references', 0, 0);
            $delnote = $this->common->gettblrowdata([
                'order_id'     => $ord['id'],
                'reference_id' => 'DQ',
            ], 'ref_value', 'tb_order_references', 0, 0);
            $receiverinfo = $this->truckwaybillmodel->getshipper($ord['id'], 'Consignee');
            $pickupinfo   = $this->truckwaybillmodel->getshipper($ord['id'], 'Shipper');
            $customer     = $this->common->gettblrowdata([
                'id' => $ord['customer_id'],
            ], 'name', 'tb_customers', 0, 0);
            // print_r($this->db->last_query()); exit;
            $order_cargos = $this->common->gettbldata([
                "order_id" => $ord['id'],
                'status'   => 1,
            ], 'cargo_id,quantity,weight,volume', 'tb_order_cargodetails', 0, 0);
            $ord['total_items'] = $ord['total_weight'] = $ord['total_volume'] = 0;
            $cargolist          = [];
            foreach ($order_cargos as $cargo) {
                $cargoinfo = $this->common->gettblrowdata([
                    'id' => $cargo['cargo_id'],
                ], 'dg_goods,cargo_type', 'tb_cargo_details', 0, 0);
                $data['isDG'] = ($cargoinfo['dg_goods'] == 0) ? 'No' : 'Yes';
                $ord['total_items'] += $cargo['quantity'];
                $ord['total_weight'] += $cargo['weight'];
                $ord['total_volume'] += $cargo['volume'];
                $data['cargo_type'] = $cargoinfo['cargo_type'];
            }
            $ord['palletno'] = $ord['num_of_pallets'];
            $data['items_count'] += $ord['total_items'];
            $data['tot_weight'] += $ord['total_weight'];
            $data['tot_pallet'] += $ord['palletno'];
            $data['tot_vol'] += $ord['total_volume'];
            $ord['service']        = "EXPRESS";
            $ord['ref_value']      = isset($ordref['ref_value']) ? $ordref['ref_value'] : '';
            $ord['delivery_note']  = isset($delnote['ref_value']) ? $delnote['ref_value'] : '';
            $ord['consignee_name'] = $receiverinfo['name'];
            $ord['customer_name']  = isset($customer['name']) ? $customer['name'] : '';
            $vendor_id             = $ord['vendor_id'];
            $vendor                = $this->common->gettblrowdata([
                'id' => $ord['vendor_id'],
            ], 'name', 'tb_vendors', 0, 0);
            $ord['vendor_name'] = ! empty($vendor['name']) ? $vendor['name'] : '';
            $ord['cargolist']   = $cargolist;
            $ordinfo[]          = $ord;
        }
        $data['shipper_name']  = $pickupinfo['name'];
        $data['customer_name'] = $ord['customer_name'];

        $data['orders']        = $ordinfo;
        $data['vendor_name']   = ! empty($vendor['name']) ? $vendor['name'] : '';
        $data['pick_city']     = $ordinfo[0]['pickup_city'];
        $data['del_city']      = $ordinfo[0]['delivery_city'];
        $data['pick_state']    = $ordinfo[0]['pickup_address2'];
        $data['del_state']     = $ordinfo[0]['delivery_address2'];
        $data['pick_pincode']  = $ordinfo[0]['pickup_pincode'];
        $data['pick_address1'] = $ordinfo[0]['pickup_address1'];
        require 'vendor/autoload.php';
        $data['generator'] = new Picqer\Barcode\BarcodeGeneratorPNG();

        $mpdf = new \Mpdf\Mpdf([
            'tempDir'           => FCPATH . 'assets/tmp',
            'default_font_size' => 9,
            'format'            => 'A4',
            'tempDir'           => FCPATH . 'assets/tmp',
        ]);
        $mpdf->setAutoBottomMargin = 'stretch';
        $company_code              = $this->session->userdata('company_code');
        $data['company_code']      = $company_code;
        $html                      = $this->load->view('manifestdoc/index', $data, true);
        $mpdf->WriteHTML($html);
        $filename = "mnf" . $vendor_id . date('YmdHis') . ".pdf";
        $mpdf->Output($filename, 'D');
    }

    public function generatemanifest($orderids)
    {
        $this->load->model('common');
        $this->load->model('truckwaybillmodel');
        $data         = [];
        $current_data = $this->db->query(
            "select ref_value
                from tb_order_references
                where reference_id = ?
                order by id DESC
                limit 1", ['MN']
        )->row_array();
        if (empty($current_data)) {
            $latestid = '000ETN000';
        } else {
            $latestid = $current_data['ref_value'];
        }
        $num = substr($latestid, 6);
        $num++;
        $numlength = strlen((string) $num);
        if ($numlength == 1) {
            $finalid = '000ETN000' . $num;
        } else if ($numlength == 2) {
            $finalid = '000ETN00' . $num;
        } else if ($numlength == 3) {
            $finalid = '000ETN0' . $num;
        } else {
            $finalid = '000ETN' . $num;
        }
        $data['manifest_no'] = $finalid;
        $data['items_count'] = $data['tot_weight'] = $data['tot_vol'] = $data['tot_pallet'] = 0;
        $data['cargo_type']  = '';
        $data['isDG']        = 'No';
        $orders              = $this->db->query(
            'select o.id,o.plat,o.plng,o.customer_id,o.vendor_id,o.pickup_city,o.pickup_address2,o.pickup_pincode,o.pickup_address1,o.delivery_address2,o.delivery_pincode,o.delivery_city,od.consignment_note,od.num_of_pallets
                from tb_orders o
                    LEFT JOIN tb_order_details od ON od.order_row_id = o.id
                where o.id in ?',
            [
                // this way, because I think method parameter is passed as string not array
                is_array($orderids) ? $orderids : explode(',', str_replace(' ', '', $orderids)),
            ]
        )->result_array();
        foreach ($orders as $ord) {
            $ordref = $this->common->gettblrowdata([
                'order_id'     => $ord['id'],
                'reference_id' => 'BN',
            ], 'ref_value', 'tb_order_references', 0, 0);
            $delnote = $this->common->gettblrowdata([
                'order_id'     => $ord['id'],
                'reference_id' => 'DQ',
            ], 'ref_value', 'tb_order_references', 0, 0);
            $receiverinfo = $this->truckwaybillmodel->getshipper($ord['id'], 'Consignee');
            $pickupinfo   = $this->truckwaybillmodel->getshipper($ord['id'], 'Shipper');
            $customer     = $this->common->gettblrowdata([
                'id' => $ord['customer_id'],
            ], 'name', 'tb_customers', 0, 0);
            // print_r($this->db->last_query()); exit;
            $order_cargos = $this->common->gettbldata([
                "order_id" => $ord['id'],
                'status'   => 1,
            ], 'cargo_id,quantity,weight,volume', 'tb_order_cargodetails', 0, 0);
            $ord['total_items']  = 0;
            $ord['total_weight'] = 0;
            $ord['total_volume'] = 0;
            $cargolist           = [];
            foreach ($order_cargos as $cargo) {
                $cargoinfo = $this->common->gettblrowdata([
                    'id' => $cargo['cargo_id'],
                ], 'dg_goods,cargo_type', 'tb_cargo_details', 0, 0);
                $data['isDG'] = ($cargoinfo['dg_goods'] == 0) ? 'No' : 'Yes';
                $ord['total_items'] += $cargo['quantity'];
                $ord['total_weight'] += $cargo['weight'];
                $ord['total_volume'] += $cargo['volume'];
                $data['cargo_type'] = $cargoinfo['cargo_type'];
            }
            $ord['palletno'] = $ord['num_of_pallets'];
            $data['tot_pallet'] += $ord['num_of_pallets'];
            $data['items_count'] += $ord['total_items'];
            $data['tot_weight'] += $ord['total_weight'];
            $data['tot_vol'] += $ord['total_volume'];
            $ord['service']        = "EXPRESS";
            $ord['ref_value']      = isset($ordref['ref_value']) ? $ordref['ref_value'] : '';
            $ord['delivery_note']  = isset($delnote['ref_value']) ? $delnote['ref_value'] : '';
            $ord['consignee_name'] = $receiverinfo['name'];
            $ord['customer_name']  = isset($customer['name']) ? $customer['name'] : '';
            $vendor_id             = $ord['vendor_id'];
            $vendor                = $this->common->gettblrowdata([
                'id' => $ord['vendor_id'],
            ], 'name', 'tb_vendors', 0, 0);
            $ord['vendor_name']    = ! empty($vendor['name']) ? $vendor['name'] : '';
            $ord['cargolist']      = $cargolist;
            $ordinfo[]             = $ord;
            $data['shipper_name']  = $pickupinfo['name'];
            $data['customer_name'] = $ord['customer_name'];
            /* Inserting manifest no in order reference */
            $dt       = date('Y-m-d h:i:s');
            $del_date = date('Y-m-d h:i:s', strtotime('+ 6 days'));
            $ins_ar   = [
                'order_id'     => $ord['id'],
                'reference_id' => 'MN',
            ];
            $chkqry = $this->common->gettblrowdata($ins_ar, 'id', 'tb_order_references', 0, 0);
            if (empty($chkqry)) {
                $ins_ar['ref_value'] = $data['manifest_no'];
                $ins_ar['status']    = 1;
                $ins_ar['createdon'] = $dt;
                $ins                 = $this->db->insert('tb_order_references', $ins_ar);
            } else {
                $upd['updatedon'] = $dt;
                $up               = $this->common->updatetbledata('tb_order_references', [
                    'ref_value' => $data['manifest_no'],
                ], [
                    'id' => $chkqry['id'],
                ]);
            }
            $update = $this->common->updatetbledata('tb_orders', [
                'pickup_datetime'   => $dt,
                'delivery_datetime' => $del_date,
            ], [
                'id' => $ord['id'],
            ]);
        }

        $data['orders']        = $ordinfo;
        $data['vendor_name']   = ! empty($vendor['name']) ? $vendor['name'] : '';
        $data['pick_city']     = $ordinfo[0]['pickup_city'];
        $data['del_city']      = $ordinfo[0]['delivery_city'];
        $data['pick_state']    = $ordinfo[0]['pickup_address2'];
        $data['del_state']     = $ordinfo[0]['delivery_address2'];
        $data['pick_pincode']  = $ordinfo[0]['pickup_pincode'];
        $data['pick_address1'] = $ordinfo[0]['pickup_address1'];
        require 'vendor/autoload.php';
        $data['generator'] = new Picqer\Barcode\BarcodeGeneratorPNG();

        $mpdf = new \Mpdf\Mpdf([
            'tempDir'           => FCPATH . 'assets/tmp',
            'default_font_size' => 9,
            'format'            => 'A4',
            'tempDir'           => FCPATH . 'assets/tmp',
        ]);
        $mpdf->setAutoBottomMargin = 'stretch';
        $company_code              = $this->session->userdata('company_code');
        $data['company_code']      = $company_code;
        $html                      = $this->load->view('manifestdoc/index', $data, true);
        $mpdf->WriteHTML($html);
        $filename = "mnf" . $vendor_id . date('YmdHis') . ".pdf";
        $filepath = "./assets/manifestdocs/" . $filename;
        $mpdf->Output($filepath, 'F');
        // $mpdf->Output(date('YmdHis') . ".pdf", 'I');
        return $filename;
    }

    public function manifestwithtrip()
    {
        $orderids     = implode(',', $this->input->post('order_id'));
        $company_code = $this->session->userdata('company_code');
        $manifest     = $trip     = $vendor     = $scanqty     = $pallets     = 0;
        $popup        = $pallet_msg        = $scan_msg        = '';
        $list         = [];
        $chkqry       = 'select id from tb_order_references where order_id in ? AND reference_id = ? and status=1';
        $res          = $this->db->query($chkqry, [$this->input->post('order_id'), 'MN']);
        if ($res->num_rows() > 0) {
            $manifest = 1;
        }
        $tripqry = 'select order_id,vendor_id from tb_orders where id in ? AND shift_id > 0';
        $tripres = $this->db->query($tripqry, [$this->input->post('order_id')]);
        if ($tripres->num_rows() > 0) {
            $trip = 1;
        }

        if ($company_code === 'AUKN') {
            $scanqry = 'select sum(oc.quantity) tot_qty,sum(oc.scanned_quantity) tot_scan_qty,o.order_id
                from tb_order_cargodetails oc
                    left join tb_orders o on o.id = oc.order_id
                where oc.order_id in ? and oc.status = 1
                group by oc.order_id';
            $scanres = $this->db->query($scanqry, [$this->input->post('order_id')]);
            if ($scanres->num_rows() > 0) {
                $scaninfo = $scanres->result_array();
                $scan_msg = 'Please Scan the all Cartons for this Orders : ';
                foreach ($scaninfo as $scan) {
                    if ($scan['tot_qty'] != $scan['tot_scan_qty']) {
                        $scanqty    = 1;
                        $scanlist[] = $scan['order_id'];
                    }
                }
                if ($scanqty == 1) {
                    $scan_msg .= implode(',', $scanlist);
                }
            }
        }

        $palletsqry = 'select order_row_id,order_id,num_of_pallets from tb_order_details where order_row_id in ? and status = 1';
        $palletsres = $this->db->query($palletsqry, [$this->input->post('order_id')]);
        if ($palletsres->num_rows() > 0) {
            $palletslist = $palletsres->result_array();
            $pallet_msg  = 'Please Input the Pallet Quantity There is No Pallets for this Orders : ';
            foreach ($palletslist as $pallet) {
                if (empty($pallet['num_of_pallets'])) {
                    $palletlist[] = $pallet['order_id'];
                    $pallets      = 1;
                }
            }
            if ($pallets == 1) {
                $pallet_msg .= implode(',', $palletlist);
            }
        }
        $venqry = 'select id from tb_orders where id in ? and vendor_id = 0';
        $venres = $this->db->query($venqry, [$this->input->post('order_id')]);
        if ($venres->num_rows() > 0) {
           
            if ($company_code == 'KNAU') {
                $vendor = 0; // Vendor Id can be 0 if KUAN since we are selecting carrier from select box
            } else {
                $vendor = 1;
            }
            
        }

        if ($trip == 0 && $manifest == 0 && $vendor == 0 && $scanqty == 0) {
            $tripqry = 'select group_concat(o.id) orderids,o.vendor_id,v.name as vendor_name
                from tb_orders o
                    left join tb_vendors v on v.id = o.vendor_id where o.id in ?
                group by vendor_id
                order by o.vendor_id desc';
            $tripres   = $this->db->query($tripqry, [$this->input->post('order_id')]);
            $carriers  = $tripres->result_array();
            $latest_mn = $this->db->query("select ref_value
                from tb_order_references
                where reference_id = 'MN'
                order by ref_value DESC
                limit 1")->row_array();
            if (empty($latest_mn)) {
                $latestid = '000ETN000';
            } else {
                $latestid = $latest_mn['ref_value'];
            }
            $i = 1;
            foreach ($carriers as $carrier) {
                $num = substr($latestid, 6);
                $num += $i;
                $numlength = strlen((string) $num);
                if ($numlength == 1) {
                    $finalid = '000ETN000' . $num;
                } else if ($numlength == 2) {
                    $finalid = '000ETN00' . $num;
                } else if ($numlength == 3) {
                    $finalid = '000ETN0' . $num;
                } else {
                    $finalid = '000ETN' . $num;
                }
                $carrier['manifest_no'] = $finalid;
                $list[]                 = $carrier;
                $i++;
            }
            $data['carriers']     = $list;
            $data['orderids']     = $orderids;
            $data['company_code'] = $company_code;
            $popup                = $this->load->view("orders/manifestwithtrip", $data, true);
        }
        echo json_encode([
            'manifest'   => $manifest,
            'trip'       => $trip,
            'vendor'     => $vendor,
            'scanqty'    => $scanqty,
            'scan_msg'   => $scan_msg,
            'pallets'    => $pallets,
            'pallet_msg' => $pallet_msg,
            'popup'      => $popup,
        ]);
    }

    public function manifestoverride($order_id)
    {
        $scaninfo = $this->common->gettblrowdata([
            'order_id' => $order_id,
        ], "sum(quantity) tot_qty,sum(scanned_quantity) tot_scan_qty", "tb_order_cargodetails", 0, 0);
        if (! empty($scaninfo) && round($scaninfo['tot_qty']) == round($scaninfo['tot_scan_qty'])) {
            $data['msg'][] = "all cartoons are scanned";
        } else {
            $consign = $this->common->gettblrowdata([
                'order_row_id' => $order_id,
            ], 'consignment_note', 'tb_order_details', 0, 0);
            if (count($consign) > 0) {
                $data['consignment_no'] = $consign['consignment_note'];
            }
            if (! empty($data['consignment_no'])) {
                $cargos = $this->common->gettbldata([
                    'status'   => 1,
                    'order_id' => $order_id,
                ], 'id,cargo_id,order_id,quantity', 'tb_order_cargodetails', 0, 0);
                foreach ($cargos as $cargo) {
                    $getLabelData = $this->aulabelmodel->getCargoLabelData(
                        $cargo['order_id'],
                        $cargo['cargo_id']);
                    if (! empty($getLabelData) && ! empty($getLabelData['scanned_quantity'])) {
                        continue;
                    }
                    /* genrate a new bar code */
                    $newbarcode = $this->genbarcode($data['consignment_no'], $order_id);
                    /* log_message('error',"new bar code:".$newbarcode."<--"); */
                    /* check and add in tb_order_cargo_labels */
                    $insarray = [
                        'cargo_id'  => $cargo['cargo_id'],
                        'order_id'  => $cargo['order_id'],
                        'pallet_id' => $cargo['id'],
                        'bar_code'  => $newbarcode,
                        'status'    => 1,
                    ];
                    $ins = $this->common->insertTableData("tb_order_cargo_labels", $insarray);
                    /* log_message('error',"tb_order_cargo_labels ins::".$this->db->last_query()."<--"); */
                    $upd_car['scanned_quantity'] = 1;
                    $scanned_quantity            = 1;
                    if ($cargo['quantity'] == $scanned_quantity) {
                        $upd_car['pallet_close'] = 0;
                    }
                    $upd_outer = $this->db->where([
                        'id' => $cargo['id'],
                    ])->update("tb_order_cargodetails", $upd_car);
                    /* log_message('error',"tb_order_cargodetails ins::".$this->db->last_query()."<--"); */
                }
                /* Scanned status updation if all cartons scanned */
                $res = $this->statusupdate($order_id);
            }
            $data['msg'][] = "scanning completed successfully";
        }
        echo json_encode($data);
    }

    public function statusupdate($order_id)
    {
        $curdt    = date('Y-m-d H:i:s');
        $scaninfo = $this->common->gettblrowdata([
            'order_id' => $order_id,
        ], "sum(quantity) tot_qty,sum(scanned_quantity) tot_scan_qty", "tb_order_cargodetails", 0, 0);
        /* log_message('error',"scaninfo::".json_encode($scaninfo)."<--"); */
        $stsins = "";
        if (! empty($scaninfo)) {
            $code       = '2491';
            $statusinfo = $this->common->gettblrowdata([
                "status_name LIKE" => "scanned%",
                'status'           => 1,
            ], 'id', 'tb_status_master', 0, 0);
            if (empty($statusinfo)) {
                $stsarr = [
                    "status_name" => 'scanned',
                    "status_type" => 'yes',
                    "customer_id" => 0,
                    "status"      => 1,
                    "createdon"   => $curdt,
                ];
                $sts_id     = $this->common->insertTableData("tb_status_master", $stsarr);
                $statusinfo = $this->common->gettblrowdata([
                    "status_name LIKE" => "scanned%",
                    'status'           => 1,
                ], 'id', 'tb_status_master', 0, 0);
            }
            // print_r($this->db->last_query());
            /* log_message('error',"scaninfo::".$this->db->last_query()."<--"); */
            // exit;
            if (! empty($statusinfo) && round($scaninfo['tot_qty']) == round($scaninfo['tot_scan_qty'])) {
                $dt    = date('Y-m-d H:i:s');
                $curtz = isset($_POST['timezone']) ? $_POST['timezone'] : '';
                if ($curtz == "") {
                    $curtz = "Australia/Sydney";
                }
                $gentime    = getdatetimebytimezone(DFLT_TZ, $dt, $curtz);
                $dt         = $gentime['datetime'];
                $status_id  = $statusinfo['id'];
                $innr_array = [
                    'order_id'    => $order_id,
                    'status_id'   => $status_id,
                    'status_code' => $code,
                    'status'      => 1,
                    'updatedon'   => $dt,
                ];
                $check_array = [
                    'order_id'    => $order_id,
                    'status_id'   => $status_id,
                    'status_code' => $code,
                    'status'      => 1,
                ];
                $chk_qry = $this->db->select("id")->get_where('tb_order_status', $check_array);
                /* log_message('error',"tb_order_status ins::".$this->db->last_query()."<--"); */
                if ($chk_qry->num_rows() == 0) {
                    $innr_array['createdon']   = $dt;
                    $innr_array['status_date'] = $dt;
                    $stsins                    = $this->db->insert('tb_order_status', $innr_array);
                }
            }
        }
        return $stsins;
    }

    private function genbarcode($consignment_no, $order_id)
    {
        $barcodestart = "0001";
        // $newbarcode=0;
        $rcent = $this->db->query(
            "SELECT bar_code
                FROM tb_order_cargo_labels
                WHERE bar_code LIKE ? AND order_id = ?
                ORDER BY id DESC
                LIMIT 1",
            [$consignment_no . '%', $order_id]
        );
        if ($rcent->num_rows() > 0) {
            $newbarcode1 = $rcent->row()->bar_code;
            /* log_message('error',"newbarcode1::".$newbarcode1."<--"); */
            $getlasts4 = substr($newbarcode1, -4);
            $getlasts4++;
            $inc_length = strlen($getlasts4);
            $getlast4   = $getlasts4;
            if ($inc_length == 1) {
                $getlast4 = "000" . $getlast4;
            } else if ($inc_length == 2) {
                $getlast4 = "00" . $getlast4;
            } else if ($inc_length == 3) {
                $getlast4 = "0" . $getlast4;
            }
            $newbarcode = $consignment_no . "" . $getlast4;
            $getlast4   = "";
        } else {
            $newbarcode = $consignment_no . "" . $barcodestart;
        }
        return $newbarcode;
    }

    public function manualscan($order_id)
    {
        $consign = $this->common->gettblrowdata([
            'order_row_id' => $order_id,
        ], 'consignment_note', 'tb_order_details', 0, 0);
        if (count($consign) > 0) {
            $data['consignment_no'] = $consign['consignment_note'];
        }
        if (! empty($data['consignment_no'])) {
            $cargos = $this->common->gettbldata([
                'status'   => 1,
                'order_id' => $order_id,
            ], 'id,cargo_id,order_id,quantity', 'tb_order_cargodetails', 0, 0);
            $i            = 1;
            $barcodestart = "0001";
            foreach ($cargos as $cargo) {
                $rcent = $this->db->query(
                    "SELECT bar_code
                        FROM tb_order_cargo_labels
                        WHERE bar_code LIKE ? AND order_id = ?
                        ORDER BY id DESC
                        LIMIT 1",
                    [$data['consignment_no'] . '%', $order_id]
                );
                if ($rcent->num_rows() > 0) {
                    $newbarcode1 = $rcent->row()->bar_code;
                    $getlasts4   = substr($newbarcode1, -4);
                    $getlasts4++;
                    $inc_length = strlen($getlasts4);
                    $getlast4   = $getlasts4;
                    if ($inc_length == 1) {
                        $getlast4 = "000" . $getlast4;
                    } else if ($inc_length == 2) {
                        $getlast4 = "00" . $getlast4;
                    } else if ($inc_length == 3) {
                        $getlast4 = "0" . $getlast4;
                    }
                    $newbarcode = $data['consignment_no'] . "" . $getlast4;
                    $getlast4   = "";
                } else {
                    $newbarcode = $data['consignment_no'] . "" . $barcodestart;
                }
                /* check and add in tb_order_cargo_labels */
                $insarray = [
                    'cargo_id'  => $cargo['cargo_id'],
                    'order_id'  => $cargo['order_id'],
                    'pallet_id' => $cargo['id'],
                    'bar_code'  => $newbarcode,
                    'status'    => 1,
                ];
                $ins = $this->common->insertTableData("tb_order_cargo_labels", $insarray);

                $upd_car['scanned_quantity'] = 1;
                $scanned_quantity            = 1;
                if ($cargo['quantity'] == $scanned_quantity) {
                    $upd_car['pallet_close'] = 0;
                }
                $upd_outer = $this->db->where([
                    'id' => $cargo['id'],
                ])->update("tb_order_cargodetails", $upd_car);
            }
            /* Scanned status updation if all cartons scanned */
            $scaninfo = $this->common->gettblrowdata([
                'order_id' => $order_id,
            ], "sum(quantity) tot_qty,sum(scanned_quantity) tot_scan_qty", "tb_order_cargodetails", 0, 0);
            if (! empty($scaninfo)) {
                $code       = '2491';
                $statusinfo = $this->common->gettblrowdata([
                    "status_code" => $code,
                    'status'      => 1,
                ], 'id', 'tb_status_master', 0, 0);
                if (! empty($statusinfo) && round($scaninfo['tot_qty']) == round($scaninfo['tot_scan_qty'])) {
                    $dt    = date('Y-m-d H:i:s');
                    $curtz = isset($_POST['timezone']) ? $_POST['timezone'] : '';
                    if ($curtz == "") {
                        $curtz = "Australia/Sydney";
                    }
                    $gentime    = getdatetimebytimezone(DFLT_TZ, $dt, $curtz);
                    $dt         = $gentime['datetime'];
                    $status_id  = $statusinfo['id'];
                    $innr_array = [
                        'order_id'    => $order_id,
                        'status_id'   => $status_id,
                        'status_code' => $code,
                        'status'      => 1,
                        'updatedon'   => $dt,
                    ];
                    $check_array = [
                        'order_id'    => $order_id,
                        'status_id'   => $status_id,
                        'status_code' => $code,
                        'status'      => 1,
                    ];
                    $chk_qry = $this->db->select("id")->get_where('tb_order_status', $check_array);
                    if ($chk_qry->num_rows() == 0) {
                        $innr_array['createdon']   = $dt;
                        $innr_array['status_date'] = $dt;
                        $stsins                    = $this->db->insert('tb_order_status', $innr_array);
                        echo $stsins;
                    }
                }
            }
        }
    }

    /**
     * Get total number of cartons per order and carton serial number
     * @param $res_arr
     * @return int[]
     */
    public function gettotalcargos($res_arr): array
    {
        $data = [
            'carton_num' => 1,
            'carton_qty' => 1,
        ];
        $order_id = $res_arr['order_id'];
        $cargo_id = $res_arr['cargo_id'];
        $res      = $this->aulabelmodel->getcargolabelsorted($order_id);
        if (! empty($res)) {
            $final_res  = array_column($res, 'id');
            $carton_num = array_search($cargo_id, $final_res, true);
            $carton_num++;
            $data['carton_num'] = ! empty($carton_num) ? $carton_num : 1;
        }
        $getCargoIds = $this->common->gettblrowdata(
            ['order_id' => $order_id, 'status' => 1],
            "count(id) idCount", "tb_order_cargodetails", 0, 0);
        $data['carton_qty'] = ! empty($getCargoIds['idCount']) ? $getCargoIds['idCount'] : 1;
        return $data;
    }
}
