<?php

if (!defined('BASEPATH')) {
    exit('No direct script access allowed');
}
ini_set('memory_limit', '4096M');
require_once APPPATH . "/third_party/PHPExcel.php";

class Autoreportmis extends CI_Controller
{
    public function __construct()
    {
        parent::__construct();
        $this->load->model(['Misautoreportmodel', 'DeliveryDocumentModel']);
        $this->load->library(['email', 'envelope']);
    }

    public function index(): void
    {
        $this->load->model('DataArrayFormatter_model');
        $this->load->model('DataQueryFormatter_model');
        $this->load->model('misautoreportmodel');
        $branchAndCustomerIds = $this->Misautoreportmodel->getCustomersForMisReports();
        if (empty($branchAndCustomerIds)) {
            return;
        }
        foreach ($branchAndCustomerIds as $eachCustomer) {
            $customerBranchEmailIds[$eachCustomer['id']] = $eachCustomer['branch_email'];
            $customerIds[] = $eachCustomer['id'];
        }
        $orderDetailsWithIds = $this->Misautoreportmodel->getOrdersDataByCustomerCodes($customerIds);
        if (empty($orderDetailsWithIds['customer_email_ids'])) {
            return;
        }
        $customerEmailIds = $orderDetailsWithIds['customer_email_ids'];
        $orderIds = $orderDetailsWithIds['all_order_ids'];
        $customerWiseOrderIds = $orderDetailsWithIds['customer_order_ids'];
        $customerCodes = $orderDetailsWithIds['customerCodes'];
        $userIds = $orderDetailsWithIds['userIds'];
        $userTimeZones = $this->Misautoreportmodel->getUserTimeZones(array_unique($userIds));
        $ordersDataWithIds = $this->Misautoreportmodel->getOrdersDataWithIds($orderIds);
        $shiftIds = array_unique(array_column($ordersDataWithIds, 'shift_id'));
        $ordersLastKnownStatus = $this->Misautoreportmodel->getOrdersLastKnownStatus($shiftIds);
        $vehiclesData = $this->DeliveryDocumentModel->getVehicleData(0, $orderIds);
        $cargoDetails = $this->Misautoreportmodel->getCargoDetails($orderIds);
        $ordersPartyNames = $this->DeliveryDocumentModel->getOrderPartyData(['Consignee'], 0, $orderIds);
        $tripCreationDates = $this->Misautoreportmodel->getTripCreationDates($shiftIds, $userTimeZones);
        $tripGateOutDetails = $this->Misautoreportmodel->getOrderGateOutDetails($orderIds, $userTimeZones, $userIds);
        foreach ($customerWiseOrderIds as $key => $eachCustomerOrderIds) {
            $i = 1;
            $excelRow = [];
            foreach ($eachCustomerOrderIds as $eachOrderId) {
                $orderRowId=$eachOrderId['id'];
                $bookingId = $eachOrderId['order_id'];
                $addresses = $this->getAddress($ordersDataWithIds[$orderRowId]);
                $eachShiftId = $ordersDataWithIds[$orderRowId]['shift_id'];
                $eachTripCreatedOn = $tripCreationDates[$eachShiftId] ?? '';
                if ($eachTripCreatedOn != '') {
                    $eachTripCreatedOn = date("d-m-Y H:i:s", strtotime($eachTripCreatedOn ?? ''));
                }
                $livetrackLink = base_url('tracking/ordertracking/') . $bookingId;
                $excelRow[] = [
                    'serial_no' => $i,
                    'invoice_no' => '',
                    'invoice_date' => '',
                    'eWay_bill_number' => '',
                    'consignment_no' => $ordersDataWithIds[$orderRowId]['consignment_no'] ?? '',
                    'trip_creation_timestamp' => $eachTripCreatedOn,
                    'booking_date' => date("d-m-Y", strtotime($ordersDataWithIds[$orderRowId]['createdon'] ?? date("d-m-Y"))),
                    'pickup_location' => $addresses['pickup_address'] ?? '',
                    'delivery_location' => $addresses['delivery_address'] ?? '',
                    'consignee_name' => $ordersPartyNames[$orderRowId]['consignee'] ?? '',
                    'goods_quantity' => $cargoDetails[$orderRowId]['quantity'] ?? '',
                    'vehicle_type' => $vehiclesData[$orderRowId]['trucktype'] ?? '',
                    'freight_amount' => '',
                    'weight' => $cargoDetails[$orderRowId]['weight'] ?? '' . $cargoDetails[$orderRowId]['weight_unit'] ?? '',
                    'vehicle_no' => $vehiclesData[$orderRowId]['register_number'] ?? '',
                    'last_known_status' => $ordersLastKnownStatus[$orderRowId] ?? '',
                    'tat' => '',
                    'eta' => date("d-m-Y H:i:s", strtotime($ordersDataWithIds[$orderRowId]['drop_endtime'] ?? '')),
                    'reached_at_destination' => $tripGateOutDetails[$orderRowId]['location'] ?? '',
                    'unloading_date' => $tripGateOutDetails[$orderRowId]['time'] ?? '',
                    'remarks' => '',
                    'tracking_link' => $livetrackLink,
                ];
                $i++;
            }
            echo "<pre>";
            print_r($excelRow);
            $fileName = $this->generateExcelReport($excelRow ?? [], $customerCodes[$key] ?? "");
            $branchEmailId = $customerBranchEmailIds[$key] ?? 'info@svkonekt.com';
            $customerEmailId = $customerEmailIds[$key] ?? 'info@svkonekt.com';

            if ($fileName != "") {
                $this->sendMailToCustomers($fileName, [$customerEmailId, $branchEmailId]);
            }
        }
    }

    private function getAddress(array $getOrderData): array
    {
        $pickupStreet = empty($getOrderData['pickup_address2'])
            ? $getOrderData['pickup_address1']
            : $getOrderData['pickup_address1'] . "\n" . $getOrderData['pickup_address2'];
        $deliveryStreet = empty($getOrderData['delivery_address2'])
            ? $getOrderData['delivery_address1']
            : $getOrderData['delivery_address1'] . "\n" . $getOrderData['delivery_address2'];
        $addresses['pickup_address'] = $getOrderData['pickup_company'].','.$getOrderData['pickup_city'];
        $addresses['delivery_address'] = $getOrderData['delivery_city'];
        return $addresses;
    }

    private function generateExcelReport(array $data, string $customerCode): string
    {
        $fileName = "";
        if (!empty($data)) {
            $styleArray = [
                'font' => [
                    'bold' => true,
                    'color' => ['rgb' => 'FFFFFF'],
                    'size' => 10,
                    'name' => 'Verdana'
                ]
            ];

            $cacheMethod = PHPExcel_CachedObjectStorageFactory::cache_to_sqlite;
            $cacheSettings = ['memoryCacheSize' => '512MB'];
            PHPExcel_Settings::setCacheStorageMethod($cacheMethod, $cacheSettings);

            $objPHPExcel = new PHPExcel();
            $objPHPExcel->setActiveSheetIndex(0);
            $objPHPExcel->getActiveSheet()
                ->getStyle('A1:V1')
                ->applyFromArray(
                    [
                        'fill' => [
                            'type' => PHPExcel_Style_Fill::FILL_SOLID,
                            'color' => ['rgb' => '0c3b81']
                        ]
                    ]
                );

            $objPHPExcel->getActiveSheet()->SetCellValue('A1', 'S.No');
            $objPHPExcel->getActiveSheet()->getStyle('A1')->applyFromArray($styleArray);
            $objPHPExcel->getActiveSheet()->SetCellValue('B1', 'Invoice No');
            $objPHPExcel->getActiveSheet()->getStyle('B1')->applyFromArray($styleArray);
            $objPHPExcel->getActiveSheet()->SetCellValue('C1', 'Invoice Date ');
            $objPHPExcel->getActiveSheet()->getStyle('C1')->applyFromArray($styleArray);
            $objPHPExcel->getActiveSheet()->SetCellValue('D1', 'E-way Bill Number');
            $objPHPExcel->getActiveSheet()->getStyle('D1')->applyFromArray($styleArray);
            $objPHPExcel->getActiveSheet()->SetCellValue('E1', 'Consignee.No');
            $objPHPExcel->getActiveSheet()->getStyle('E1')->applyFromArray($styleArray);
            $objPHPExcel->getActiveSheet()->SetCellValue('F1', 'Indent Date & Time');
            $objPHPExcel->getActiveSheet()->getStyle('F1')->applyFromArray($styleArray);
            $objPHPExcel->getActiveSheet()->SetCellValue('G1', 'Booking Date');
            $objPHPExcel->getActiveSheet()->getStyle('G1')->applyFromArray($styleArray);
            $objPHPExcel->getActiveSheet()->SetCellValue('H1', 'Booking Location');
            $objPHPExcel->getActiveSheet()->getStyle('H1')->applyFromArray($styleArray);
            $objPHPExcel->getActiveSheet()->SetCellValue('I1', 'Destination');
            $objPHPExcel->getActiveSheet()->getStyle('I1')->applyFromArray($styleArray);
            $objPHPExcel->getActiveSheet()->SetCellValue('J1', 'Consignee Name');
            $objPHPExcel->getActiveSheet()->getStyle('J1')->applyFromArray($styleArray);
            $objPHPExcel->getActiveSheet()->SetCellValue('K1', 'No.of Packages');
            $objPHPExcel->getActiveSheet()->getStyle('K1')->applyFromArray($styleArray);
            $objPHPExcel->getActiveSheet()->SetCellValue('L1', 'Vehicle Type');
            $objPHPExcel->getActiveSheet()->getStyle('L1')->applyFromArray($styleArray);
            $objPHPExcel->getActiveSheet()->SetCellValue('M1', 'Freight Amount');
            $objPHPExcel->getActiveSheet()->getStyle('M1')->applyFromArray($styleArray);
            $objPHPExcel->getActiveSheet()->SetCellValue('N1', 'Weight(Kgs)');
            $objPHPExcel->getActiveSheet()->getStyle('N1')->applyFromArray($styleArray);
            $objPHPExcel->getActiveSheet()->SetCellValue('O1', 'Vehicle No');
            $objPHPExcel->getActiveSheet()->getStyle('O1')->applyFromArray($styleArray);
            $objPHPExcel->getActiveSheet()->SetCellValue('P1', 'Status');
            $objPHPExcel->getActiveSheet()->getStyle('P1')->applyFromArray($styleArray);
            $objPHPExcel->getActiveSheet()->SetCellValue('Q1', 'TAT');
            $objPHPExcel->getActiveSheet()->getStyle('Q1')->applyFromArray($styleArray);
            $objPHPExcel->getActiveSheet()->SetCellValue('R1', 'ETA');
            $objPHPExcel->getActiveSheet()->getStyle('R1')->applyFromArray($styleArray);
            $objPHPExcel->getActiveSheet()->SetCellValue('S1', 'Reached At Destination');
            $objPHPExcel->getActiveSheet()->getStyle('S1')->applyFromArray($styleArray);
            $objPHPExcel->getActiveSheet()->SetCellValue('T1', 'Unloading Date');
            $objPHPExcel->getActiveSheet()->getStyle('T1')->applyFromArray($styleArray);
            $objPHPExcel->getActiveSheet()->SetCellValue('U1', 'Remark -1');
            $objPHPExcel->getActiveSheet()->getStyle('U1')->applyFromArray($styleArray);
            $objPHPExcel->getActiveSheet()->SetCellValue('V1', 'Tracking Link');
            $objPHPExcel->getActiveSheet()->getStyle('V1')->applyFromArray($styleArray);
            $activeWorksheet = $objPHPExcel->getActiveSheet();
            $rowCount = 2;
            try {
                foreach ($data as $result) {
                    $activeWorksheet->SetCellValue('A' . $rowCount, $result['serial_no']);
                    $activeWorksheet->SetCellValue('B' . $rowCount, $result['invoice_no']);
                    $activeWorksheet->SetCellValue('C' . $rowCount, $result['invoice_date']);
                    $activeWorksheet->SetCellValue('D' . $rowCount, $result['eWay_bill_number']);
                    $activeWorksheet->SetCellValue('E' . $rowCount, $result['consignment_no']);
                    $activeWorksheet->SetCellValue('F' . $rowCount, $result['trip_creation_timestamp']);
                    $activeWorksheet->SetCellValue('G' . $rowCount, $result['booking_date']);
                    $activeWorksheet->SetCellValue('H' . $rowCount, $result['pickup_location']);
                    $activeWorksheet->SetCellValue('I' . $rowCount, $result['delivery_location']);
                    $activeWorksheet->SetCellValue('J' . $rowCount, $result['consignee_name']);
                    $activeWorksheet->SetCellValue('K' . $rowCount, $result['goods_quantity']);
                    $activeWorksheet->SetCellValue('L' . $rowCount, $result['vehicle_type']);
                    $activeWorksheet->SetCellValue('M' . $rowCount, $result['freight_amount']);
                    $activeWorksheet->SetCellValue('N' . $rowCount, $result['weight']);
                    $activeWorksheet->SetCellValue('O' . $rowCount, $result['vehicle_no']);
                    $activeWorksheet->SetCellValue('P' . $rowCount, $result['last_known_status']);
                    $activeWorksheet->SetCellValue('Q' . $rowCount, $result['tat']);
                    $activeWorksheet->SetCellValue('R' . $rowCount, $result['eta']);
                    $activeWorksheet->SetCellValue('S' . $rowCount, $result['reached_at_destination']);
                    $activeWorksheet->SetCellValue('T' . $rowCount, $result['unloading_date']);
                    $activeWorksheet->SetCellValue('U' . $rowCount, $result['remarks']);
                    $activeWorksheet->SetCellValue('V' . $rowCount, $result['tracking_link']);
                    $rowCount++;
                }
            } catch (\Throwable $exception) {
            }
            $fileName = 'AutoReportMis-' . $customerCode . "-" . date("d-M") . '.xlsx';
            $objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel2007');

            if (!file_exists('assets/autoreportmis')) {
                mkdir('assets/autoreportmis', 0710, true);
            }
            try {
                $objWriter->save(str_replace(__FILE__, 'assets/autoreportmis/' . $fileName, __FILE__));
            } catch (PHPExcel_Writer_Exception $e) {
            }
        }
        //log_message("error", json_encode($fileName));
        return $fileName;
    }

    private function sendMailToCustomers(string $filename, array $emailIds): void
    {
        $emailIds = array_unique($emailIds);
        foreach ($emailIds as $eachEmailId) {
            $this->envelope->from('svkonekt@kuehne-nagel.com', 'svkonekt');
            $this->envelope->to($eachEmailId);
            $sub = "Daily MIS";
            $message = "Dear Customer,";
            $message .= "Please find the attachment for Mis Shipment Report";
            $message .= "Thank you for using Kuehne + Nagel Road Logistics.<br><br><br><br>";
            $message .= "Best Regards,<br>";
            $message .= "Kuehne + Nagel Road Logistics.";
            $this->envelope->subject($sub);
            $this->envelope->set_mailtype("html");
            $this->envelope->message($message);
            $attachmentPath = sprintf('%s/assets/autoreportmis/%s', FCPATH, $filename);
            $this->envelope->attach($attachmentPath);
            $this->envelope->send();
            $this->envelope->clear(true);
        }
    }
}
