<?php

defined('BASEPATH') or exit('No direct script access allowed');

require_once APPPATH . "/third_party/PHPExcel.php";

class Autoreports extends CI_Controller {

    public function __construct() {
        parent::__construct();
        if ($this->session->userdata('user_id') == "") {
            redirect("login");
        }
        $this->load->model("common");
        $this->load->model("autoreportsmodel");
        $this->load->model("sendautoreportnotificationmodel");
        if (!checkUrlAccessForUser('AUTOREPORTS')) {
            redirect("Forbiddenaccess");
        }
    }

    public function index() {
        $data["page_title"] = $this->lang->line('menu_autoreports');
        $data["sub_title"] = $this->lang->line('cust_search');

        $post = $whr = $where = $reports_list = $reports_array = $searchdata = array();

        $where['am.user_id'] = $this->session->userdata('user_id');
        // common where.
        $whr['am.company_code'] = $this->session->userdata('company_code');
        $whr['am.branch_code'] = $this->session->userdata('branch_code');

        if (isset($_POST['searchsubmit']) && $_POST['searchsubmit'] == "Search") {
            $post = $_POST;
        }

        if (!empty($post)) {
            $where = $this->search_data($post);
            if (isset($post['description']) && $post['description'] != "") {
                $description    = $post['description'];
                $whr["am.description"] = $description;
            }
        }

        if (isset($post['status']) && $post['status'] != "") {
            $status  = $post['status'];
            $where["am.status="] = $status;
        } else {
            $where['am.status']=1;
        }

        $reports_list = $this->autoreportsmodel->getsearchdata($whr, $where);

        foreach($reports_list as $report) {
            $reportname = explode(',', $report['reports_name']);
            $reports_array = $this->autoreportsmodel->getpagenames($reportname);
            $i=0;
            $report_str = "";
            foreach($reports_array as $key => $val) {
                $report_str.= $this->lang->line($val['page']).',';
            }
            $report_str = rtrim($report_str,',');
            $searchdata[] = ['report_id' => $report['report_id'],'reports_name'=>$report_str,'startDate' => $report['schedule_fromdatetime'],'endDate' => $report['schedule_todatetime'],'email_ids' => $report['customer_email_ids'],'customer_name' => $report['uname'],'description'=>$report['description'],'company_code'=>$report['company_code'],'branch_code'=>$report['branch_code'],'id'=>$report['id'],'status'=>$report['status'],'from_date'=>$report['from_date'],'to_date'=>$report['to_date']];
        }

        $data['reports_list'] = $searchdata;
        $this->newtemplate->dashboard("autoreports/index", $data);
    }

    public function search_data($post)
    {
        $whr = array();
        if (isset($post['fromdate']) && $post['fromdate'] != "") {
            $fromdate                                      = date('Y-m-d', strtotime($post['fromdate']));
            $whr["DATE_FORMAT(am.createdon,'%Y-%m-%d') >="] = $fromdate;
        }

        if (isset($post['todate']) && $post['todate'] != "") {
            $todate                                        = date('Y-m-d', strtotime($post['todate']));
            $whr["DATE_FORMAT(am.createdon,'%Y-%m-%d') <="] = $todate;
        }

        if (isset($post['schedular_fromdate']) && $post['schedular_fromdate'] != "") {
            $startDate                                      = date('Y-m-d', strtotime($post['schedular_fromdate']));
            $whr["DATE_FORMAT(am.schedule_fromdatetime,'%Y-%m-%d') ="] = $startDate;
        }

        if (isset($post['schedular_todate']) && $post['schedular_todate'] != "") {
            $endDate                                      = date('Y-m-d', strtotime($post['schedular_todate']));
            $whr["DATE_FORMAT(am.schedule_todatetime,'%Y-%m-%d') ="] = $endDate;
        }

        if (isset($post['report_id1']) && $post['report_id1'] != "") {
            $report_id1  = $post['report_id1'];
            $whr["am.report_id="] = $report_id1;
        }

        if (isset($post['report_id']) && $post['report_id'] != "") {
            $report_id  = $post['report_id'];
            $whr["am.report_id="] = $report_id;
        }

        if (isset($post['customer_code']) && $post['customer_code'] != "") {
            $customer_code  = $post['customer_code'];
            $whr["am.customer_code="] = $customer_code;
        }

        if (isset($post['customer_code1']) && $post['customer_code1'] != "") {
            $customer_code1  = $post['customer_code1'];
            $whr["am.customer_code="] = $customer_code1;
        }

        return $whr;
    }

    public function getreportID()
    {
        $uid = $this->session->userdata('user_id');

        $report_id = $_REQUEST["report_id"] ?? "";
        $branch_code = $this->session->userdata('branch_code');
        $company_code = $this->session->userdata('company_code');

        $report_id = trim($report_id);
        $data = [];

        $get_data = $this->db->query(
            "SELECT report_id
                FROM tb_auto_msireports
                WHERE report_id like ? and user_id = ? and branch_code= ? and company_code= ? and status='1' ",
            ['%' . $report_id . '%', $uid, $branch_code, $company_code]
        );

        if($get_data->num_rows() > 0){

            foreach ($get_data->result() as $get_data_f) {

                $data[] = $get_data_f->report_id;

            }
        }

        echo json_encode($data);
    }

    public function getcustcode()
    {
        $uid = $this->session->userdata('user_id');

        $customer_code = $_REQUEST["customer_code"] ?? "";
        $branch_code = $this->session->userdata('branch_code');
        $company_code = $this->session->userdata('company_code');

        $customer_code = trim($customer_code);

        $data = [];

        $get_data = $this->db->query(
            "SELECT customer_code
                FROM tb_auto_msireports
                WHERE customer_code like ? and user_id=? and branch_code=? and company_code=? and status='1' ",
            ['%' . $customer_code . '%', $uid, $branch_code, $company_code]
        );
        if($get_data->num_rows() > 0) {

            foreach ($get_data->result() as $get_data_f) {

                $data[] = $get_data_f->customer_code;

            }

        }

        echo json_encode($data);
    }

    public function add() {
        $company_code = $this->session->userdata('company_code');
        $branch_code = $this->session->userdata('branch_code');
        $user_id = $this->session->userdata('user_id');
        $data['company_code'] = $company_code;
        $data['branch_code'] = $branch_code;
        $data['user_id'] = $user_id;
        $role_id = $this->session->userdata('user_role_id');
        $get_moduleid = $this->db->select('id')->get_where("tb_modules", "name='menu_reports' and status='1'");
        $module_id = "";
        if ($get_moduleid->num_rows() > 0) {
            $module_id = $get_moduleid->row()->id;
        }
        $data['reports_data'] = $this->autoreportsmodel->getReports($role_id, $module_id);

        $data["page_title"] = $this->lang->line('menu_autoreports');
        $data["sub_title"] = $this->lang->line('general_add');

        $this->newtemplate->dashboard("autoreports/add", $data);
    }

    public function update() {
        $id = $this->input->post('auto_report_id');
        if (!is_numeric($id))
            return json_encode(FALSE);
        $post = $_POST;
        if(isset($post) && !empty($post)) {
            $name = ($post['reports']) ? ($post['reports']) : array();
            $name = implode(',', $name);
            $schedule_fromdatetime = ($post['schedular_fromdate']) ? ($post['schedular_fromdate']) : '';
            $schedule_todatetime = ($post['schedular_todate']) ? ($post['schedular_todate']) : '';
            $customer_email_ids = ($post['email_array']) ? ($post['email_array']) : "";
            $email_array = explode(',', $customer_email_ids);
            $email_str = "";
            foreach($email_array as $email) {
                $email_str.=substr($email, 0,-1).', ';
            }
            $email_str = rtrim($email_str,', ');
            $customer_id = ($post['party_id']) ? ($post['party_id']) : '';
            $customer_code = ($post['customer_code']) ? ($post['customer_code']) : '';
            $company_code = ($post['company_code']) ? ($post['company_code']) : '';
            $branch_code = ($post['branch_code']) ? ($post['branch_code']) : '';
            $description = ($post['description']) ? ($post['description']) : '';
            $status = ($post['status']) ? ($post['status']) : '';
            $user_id = $this->session->userdata('user_id');
            $updatedon = date("Y-m-d H:i:s");
            $data = array(
                'reports_name' => $name,'schedule_fromdatetime' => $schedule_fromdatetime,
                'schedule_todatetime' => $schedule_todatetime,'customer_email_ids' =>$email_str,
                'customer_id' => $customer_id,'customer_code' => $customer_code,'description' => $description, 'company_code' => $company_code, 'branch_code' => $branch_code, 'status' => $status,'updatedon' => $updatedon
            );

            $table = 'tb_auto_msireports';
            $whr = array(
                'id' => $id
            );
            $result = $this->common->updatetbledata($table, $data, $whr);
            $chkqry = $this->db->query(
                "SELECT * from tb_autoreports_mailstatus where report_id = ?",
                [ $id ]
            );
            // log_message("error",$this->db->last_query());

            if($chkqry->num_rows() > 0) {
                $curtz = $this->session->userdata("usr_tzone")['timezone'];
                $updated_at = getdatetimebytimezone($curtz,date("Y-m-d H:i:s"),DFLT_TZ);
                $updatedat = $updated_at['datetime'];
                $res = $this->common->updatetbledata('tb_autoreports_mailstatus', ['status' => $status,'updated_at'=>$updatedat], ['report_id' => $id]);
            }
            echo json_encode($result);
        }
    }

    public function edit($id) {
        $data["page_title"] = $this->lang->line('menu_autoreports');
        $data["sub_title"] = $this->lang->line('cutomer_edit');

        $company_code = $this->session->userdata('company_code');
        $user_id = $this->session->userdata('user_id');
        $branch_code = $this->session->userdata('branch_code');

        $data['company_code'] = $company_code;
        $data['branch_code'] = $branch_code;
        $data['user_id'] = $user_id;
        $role_id = $this->session->userdata('user_role_id');
        $get_moduleid = $this->db->select('id')->get_where("tb_modules", "name='menu_reports' and status='1'");
        $module_id = "";
        if ($get_moduleid->num_rows() > 0) {
            $module_id = $get_moduleid->row()->id;
        }
        $data['reports_data'] = $this->autoreportsmodel->getReports($role_id, $module_id);
        $data['auto_report'] = $this->autoreportsmodel->editdata($id,$company_code,$branch_code);
        if ($data['auto_report']) {
            $this->newtemplate->dashboard('autoreports/edit', $data);
        } else {
            redirect('autoreports/add');
        }
    }

    public function view($id) {
        $data["page_title"] = $this->lang->line('menu_autoreports');
        $company_code = $this->session->userdata('company_code');
        $branch_code = $this->session->userdata('branch_code');
        $profile_list = array();
        $data["sub_title"] = $this->lang->line('view_view');
        $auto_reports_list = $this->autoreportsmodel->viewdata($id, $company_code, $branch_code);
        $reportname = "";
        $reports_array = array();
        $report_str = "";
        $viewdata = array();

        $reportname = explode(',', $auto_reports_list['reports_name']);
        $reports_array = $this->autoreportsmodel->getpagenames($reportname);
        foreach($reports_array as $key => $val) {
            $report_str.=$this->lang->line($val['page']).',';
        }

        $report_str = rtrim($report_str,',');

        $viewdata = ['report_id' => $auto_reports_list['report_id'],'reports_name'=>$report_str,'startDate' => $auto_reports_list['schedule_fromdatetime'],'endDate' => $auto_reports_list['schedule_todatetime'],'email_ids' => $auto_reports_list['customer_email_ids'],'customer_name' => $auto_reports_list['uname'],'description'=>$auto_reports_list['description'],'company_code'=>$auto_reports_list['company_code'],'branch_code'=>$auto_reports_list['branch_code'],'id'=>$auto_reports_list['id'],'status'=>$auto_reports_list['status'],'customer_code'=>$auto_reports_list['customer_code'],'from_date' => $auto_reports_list['from_date'],'to_date'=>$auto_reports_list['to_date']];

        $data['auto_reports_list'] = $viewdata;

        if ($auto_reports_list) {
            $this->newtemplate->dashboard('autoreports/view', $data);
        } else {
            redirect('autoreports/add');
        }
    }

    public function delete($id) {
        if ($id != '' && is_numeric($id)) {
            $company_code = $this->session->userdata('company_code');
            $branch_code = $this->session->userdata('branch_code');
            $this->db->where(array('id' => $id));
            $this->db->set('status', 0);
            $curtz = $this->session->userdata("usr_tzone")['timezone'];
            $updated_at = getdatetimebytimezone($curtz,date("Y-m-d H:i:s"),DFLT_TZ);
            $updatedat = $updated_at['datetime'];
            $result = $this->db->update('tb_auto_msireports');
            $res = $this->common->updatetbledata("tb_autoreports_mailstatus",['status'=>0,'updated_at'=>$updatedat],['report_id'=>$id]);
            // log_message("error",$this->db->last_query());
            if ($result) {
                echo "1";
            } else {
                echo "0";
            }
        }
    }

    public function save() {
        $post = $_POST;
        if(isset($post) && !empty($post)) {
            $report_id  = $this->reportidgen();
            $name = ($post['reports']) ? ($post['reports']) : array();
            $name = implode(',', $name);
            $schedule_fromdatetime = ($post['schedular_fromdate']) ? ($post['schedular_fromdate']) : '';
            $schedule_todatetime = ($post['schedular_todate']) ? ($post['schedular_todate']) : '';
            $from_date = ($post['from_date']) ? ($post['from_date']) : '';
            $to_date = ($post['to_date']) ? ($post['to_date']) : '';
            $customer_email_ids = ($post['email_array']) ? ($post['email_array']) : "";
            $email_array = explode(',', $customer_email_ids);
            $email_str = "";
            foreach($email_array as $email) {
                $email_str.=substr($email, 0,-1).', ';
            }
            $email_str = rtrim($email_str,', ');
            $customer_id = ($post['party_id']) ? ($post['party_id']) : '';
            $customer_code = ($post['customer_code']) ? ($post['customer_code']) : '';
            $company_code = ($post['company_code']) ? ($post['company_code']) : '';
            $branch_code = ($post['branch_code']) ? ($post['branch_code']) : '';
            $description = ($post['description']) ? ($post['description']) : '';
            $user_id = $this->session->userdata('user_id');
            $createdon = date("Y-m-d H:i:s");

            $data = array(
                'report_id' => $report_id,
                'reports_name' => $name,
                'schedule_fromdatetime' => $schedule_fromdatetime,
                'schedule_todatetime' => $schedule_todatetime,
                'from_date' => $from_date,
                'to_date' => $to_date,
                'customer_email_ids' => $email_str,
                'customer_id' => $customer_id,
                'customer_code' => $customer_code,
                'description' => $description,
                'company_code' => $company_code,
                'branch_code' => $branch_code,
                'user_id' => $user_id,
                'status' => 1,
                'createdon' => $createdon
            );

            $table = 'tb_auto_msireports';
            $result = $this->common->insertTableData($table, $data);
            echo json_encode($result);
        }
    }

    public function getpartymaster() {
        $company_code = $this->session->userdata('company_code');
        $user_id = $this->session->userdata('user_id');
        if (isset($_POST)) {
            $result = array();
            $chkqry = $this->db->select('id,name,phone,email_id,code,street,pincode')->get_where("tb_customers", "code IS NOT NULL and code !='' and code !=0 and user_id='$user_id' and company_code='$company_code' and status='1' group by code order by id desc");
            if ($chkqry->num_rows() > 0) {
                foreach ($chkqry->result() as $res) {
                    $res->code;
                    $check = '<input type="radio" name="listcompany" id="listcompany_' . $res->id . '" class="listcompany" onchange="selectPartyMaster(' . "'" . $res->id . "'" . ',' . "'" . $res->code . "'" . ')" value="' . $res->id . '">';
                    $result[] = array('check' => $check,'name'=>$res->name,'mobile'=>$res->phone,'street'=>$res->street,'pincode'=>$res->pincode,'code' => $res->code);
                }
            }
            echo json_encode($result);
        }
    }

    public function getcustomerCode()
    {
        $uid = $this->session->userdata('user_id');
        $code = trim($_REQUEST["code"] ?? "");
        $data = [];

        $get_data = $this->db->query(
            "SELECT code,id,name
                FROM tb_customers
                WHERE code like ? and user_id= ? and status=1",
            ['%' . $code . '%', $uid]
        );

        if($get_data->num_rows() > 0){

            foreach ($get_data->result() as $get_data_f) {

                $data[] = $get_data_f->code;

            }

        }

        echo json_encode($data);
    }

    public function getcustomerdatabycode()
    {
        $items = [];
        $uid = $this->session->userdata('user_id');
        $code = $_POST['code'];
        $qry = $this->db->query(
            "SELECT *
                FROM tb_customers
                WHERE status='1' and code LIKE ? and user_id=?
                LIMIT 1",
            ['%' . $code . '%', $uid]
        );

        if ($qry->num_rows() > 0) {
            foreach ($qry->result() as $res) {
                $items[] = array('id' => $res->id, 'code' => $res->code);
            }
        }
        echo json_encode($items);
    }

    public function reportidgen()
    {
        $company_code = $this->session->userdata('company_code');
        $year = date('y');
        $week = date('W');
        $country_code = substr($company_code, 0, 2);
        $report_res = $this->db->query(
            "SELECT report_id FROM tb_auto_msireports ORDER BY id DESC LIMIT 1"
        );
        if ($report_res->num_rows() > 0) {
            $get_report_id = $report_res->row()->report_id;
            $get_report_id_c = strlen($get_report_id);
            $previous_weeknumber = substr($get_report_id, 6, 2);
            $get_report_id1 = substr($get_report_id, 8);
            $get_report_id2 = ltrim($get_report_id1, 0);
            if ($previous_weeknumber < $week) {
                    $id1 = '0001';
             } else {
               $i_id = $get_report_id2;
               $i_id ++;
               $idlength = strlen($i_id);
               if ($idlength == '1') {
                   $id1 = "000" . $i_id;
               } else if ($idlength == '2') {
                   $id1 = "00" . $i_id;
               } else if ($idlength == '3') {
                   $id1 = "0" . $i_id;
               } else if ($idlength == '4') {
                   $id1 = $i_id;
               } else {
                   $id1 = $i_id;
               }
            }
            $report_id1 = "RP" . $country_code . $year . $week . $id1;
            $chk = $this->db->query(
                "select report_id FROM tb_auto_msireports WHERE report_id= ?",
                [$report_id1]
            );

            if ($chk->num_rows() > 0) {
                $iid = $id1;
                $iid ++;
                $ii_d = $iid;
                $id_length = strlen($iid);
                if ($id_length == '1') {
                    $ii_d = "000" . $iid;
                } else if ($id_length == '2') {
                    $ii_d = "00" . $iid;
                } else if ($id_length == '3') {
                    $ii_d = "0" . $iid;
                } else if ($id_length == '4') {
                    $ii_d = $iid;
                } else {
                    $ii_d = $iid;
                }
                $report_id1 = "RP" . $country_code . $year . $week . $ii_d;
            } else {
                $report_id1 = $report_id1;
            }
        } else {
            $i_id = 1;
            $id1 = '000' . $i_id;
            $report_id1 = "RP" . $country_code . $year . $week . $id1;
        }
        return $report_id1;
    }

    public function get_emailids()
    {
        $items   = array();
        $auto_report_id = $_POST['auto_report_id'];
        $qry = $this->db->query(
            "SELECT customer_email_ids FROM tb_auto_msireports WHERE id= ? ",
            [$auto_report_id]
        );
        if ($qry->num_rows() > 0) {
            $res = $qry->row_array();
            $items[] = ['email_ids' => $res['customer_email_ids']];
        }
        echo json_encode($items);
    }

    public function checkreport()
    {
        $post = $this->input->post();

        $party_id = isset($post['party_id']) ? $post['party_id'] : "";

        $company_code = isset($post['company_code']) ? $post['company_code'] : "";

        $branch_code = isset($post['branch_code']) ? $post['branch_code'] : "";

        $id = isset($post['id']) ? $post['id'] : "";

        $user_id = $this->session->userdata('user_id');

        $status = 1;

        $where = array(

            'customer_id' => $party_id,

            'branch_code' => $branch_code,

            'company_code' => $company_code,

            'user_id' => $user_id,

            'status' => $status

        );

        if ($id) {

            $where['id !='] = $id;

        }

        $check_report_data = $this->common->gettblrowdata($where, '*', 'tb_auto_msireports', 0, 0);

        if (empty($check_report_data)) {

            echo "2";

        } else {

            echo "1";

        }
    }

    public function sendreportstomail($id = null)
    {
        if ($id) {
            $attachments = array();
            $check_report_data = $this->db->query(
                "select * from tb_auto_msireports where id= ? ",
                [$id]
            )->row_array();
            if (!empty($check_report_data)) {
                $report_ids = explode(',', $check_report_data['reports_name']);
                foreach($report_ids as $report_id) {
                   $attachments[] =  $this->prepareExcelSheet($report_id,$check_report_data);
                }
                $customer_id = $check_report_data['customer_id'];
                $customer_data = $this->db->query(
                    "select * from tb_customers where id= ? ",
                    [$customer_id]
                )->row_array();
                $email_ids = $check_report_data['customer_email_ids'];
                $send_email= ['email_ids' => $email_ids,'username'=>$customer_data['name'],'subject' => "Auto Report Notification",'attachments'=> $attachments];
                $this->sendreports($send_email);
            }
        }
    }

    public function prepareExcelSheet($report_id,$report_arr)
    {
        $get_page_name = $this->db->query(
            "select page from tb_pages where id= ? ",
            [$report_id]
        );
        $page_name = "";
        if($get_page_name->num_rows() > 0) {
            $page_name = $get_page_name->row()->page;
        }
        $attachment_arr = array();

        if ($page_name == "financial_report") {
            $attachment_arr = $this->getfinancialreport($report_arr);
        }

        if($page_name == 'basic_shipment_report') {
           $attachment_arr =  $this->getinbasicshipmentreport($report_arr);
        }

        if($page_name == 'trucker_volume') {
           $attachment_arr =  $this->gettruckervolumereport($report_arr);
        }
        return $attachment_arr;
    }

    public function getfinancialreport($report_arr)
    {
        ini_set("memory_limit","256M");
        $finacial_data = $order_data = $finacialdata= array();
        $userid = $this->session->userdata('user_id');
        $whr = array();

        $from_date = $to_date = $email_ids = $customer_id = "";
        if(!empty($report_arr)) {
            $from_date = $report_arr['from_date'];
            $to_date = $report_arr['to_date'];
            $email_ids = $report_arr['customer_email_ids'];
            $customer_id = $report_arr['customer_id'];
        }
        $customer_data = $this->db->query(
            "select * from tb_customers where id= ? ",
            [$customer_id]
        )->row_array();
        $lr_num = $cust_reference_num = "NA";
        $pickup_date_status = $estimate_deliverydate = $delivery_date = "";
        $staus_fin = "";
        $last_status_name = $last_loc = "";
        $delivery_status = "Not Delivered";
        $attachment = "";
        $company_code = $this->session->userdata('company_code');
        $branch_code = $this->session->userdata('branch_code');
        $whr['order_id >']=0;
        $whr['status=']=1;
        $whr['type=']=0;
        $whr['user_id=']=$userid;

        if ($from_date != "") {
            $fromdate = date('Y-m-d', strtotime($from_date));
            $whr["DATE_FORMAT(updatedon,'%Y-%m-%d') >="] = $fromdate;
        }

        if ($to_date != "") {
            $todate = date('Y-m-d', strtotime($to_date));
            $whr["DATE_FORMAT(updatedon,'%Y-%m-%d') <="] = $todate;
        }

        $finacialdata = $this->sendautoreportnotificationmodel->financialdata($whr);
        /* get Revene data Revene Table */
        if (! empty($finacialdata)) {
            foreach ($finacialdata as $res) {

                /* order data get */
                $whr_or = array(
                    'o.id' => $res['order_id']
                );
                $order_data = $this->sendautoreportnotificationmodel->getorderdata($whr_or);

                /* get reference value */
                $lr_ref_no = $this->sendautoreportnotificationmodel->getreferenceorderdetails($res['order_id'], 'PO');

                if ($lr_ref_no->num_rows() > 0) {
                    $lr_num = $lr_ref_no->row()->ref_value;
                }

                $cust_ref_no = $this->sendautoreportnotificationmodel->getreferenceorderdetails($res['order_id'], 'DQ');
                if ($cust_ref_no->num_rows() > 0) {
                    $cust_reference_num = $cust_ref_no->row()->ref_value;
                }

                if (isset($res['invoice_status']) && $res['invoice_status'] != "") {
                    if ($res['invoice_status'] == 0) {
                        $staus_fin = "To Be Billed";
                    } else if ($res['invoice_status'] == 1) {
                        $staus_fin = "Ready To Billed";
                    } else if ($res['invoice_status'] == 2) {
                        $staus_fin = "Billed";
                    } else {
                        $staus_fin = "";
                    }
                }

                /* get Good description */
                $qry = $this->db->query(
                    "SELECT o.cargo_content
                        FROM tb_order_cargodetails o
                        WHERE o.order_id = ? AND o.status= ?",
                    [$order_data['order_id'], 1]
                );
                $cargo_content = '';
                $title = "";
                if ($qry->num_rows() > 0) {
                    foreach ($qry->result() as $row) {
                        if ($row->cargo_content != '') {
                            $out = strlen($row->cargo_content) > 10 ? substr($row->cargo_content, 0, 5) . "..." : $row->cargo_content;
                            $cargo_content .= $out . ',';
                            $title .= $row->cargo_content . ',';
                        } else {
                            $cargo_content = '';
                        }
                    }
                }
                $cargo_content = rtrim($cargo_content, ',');
                $title = rtrim($title, ',');
                $cargo_content_arr = explode(',', $cargo_content);
                $array_tmp = $array_new = [];
                foreach ($cargo_content_arr as $k => $v) {
                    $index = $v;
                    $array_tmp[$index][] = $v;
                }
                foreach ($array_tmp as $k => $v) {
                    if (count($v) > 1) {
                        foreach ($v as $k2 => $v2) {
                            $array_new[] = $v2;
                        }
                    }
                }
                if (count($array_new)) {
                    $get_cargo_content = $array_new[0];
                    if (in_array($get_cargo_content, $cargo_content_arr)) {
                        $key_value = array_search($get_cargo_content, $cargo_content_arr);
                        unset($cargo_content_arr[$key_value]);
                    }
                }
                $final_cargo_content_str = implode(',', $cargo_content_arr);

                /* get carrier name */
                $carrier_name = '';
                $truckinfo = $this->db->query(
                    "SELECT v.name FROM tb_vendors v,tb_employee e WHERE e.order_id = ? AND e.vendor_id=v.id and v.id= ? ",
                    [$order_data['order_id'], $order_data['vendor_id']]
                );

                if ($truckinfo->num_rows() > 0) {
                    $carrier_name = $truckinfo->row()->name;
                }

                $shift_id = $order_data['shift_id'];
                /* Get pickup Date */
                $early_pickup = $order_data['pickup_datetime'];
                $sql4 = $this->sendautoreportnotificationmodel->getpickupshipdateils($res['order_id']);
                if($sql4->num_rows() > 0) {
                    $pickupdate_time = $sql4->row()->createdon;
                    if($pickupdate_time != "" && $pickupdate_time != "0000-00-00 00:00:00") {
                        $pickup_date_status = date("d M Y",strtotime($pickupdate_time));
                    }
                } else {
                    if($early_pickup != "" && $early_pickup != "0000-00-00 00:00:00") {
                        $pickup_date_status = date("d M Y",strtotime($early_pickup));
                    }
                }

                /** Estimated Delivered Date **/
                $estimate_de_date = $order_data['delivery_datetime'];
                if($estimate_de_date != "" && $estimate_de_date != "0000-00-00 00:00:00") {
                    $estimate_deliverydate = date("d M Y",strtotime($estimate_de_date));
                }

                /** get last status,delivery date,location,delivery date **/
                if($shift_id != 0) {
                    $get_laststatusinfo = $this->sendautoreportnotificationmodel->getlaststoptransdetails($res['order_id'],$shift_id);
                    $delivery_status = "Not Delivered";
                    if($order_data['trip_sts'] == 1){
                        $last_status_name = "Delivered";
                        $delivery_status = "Delivered";
                    }
                    if($get_laststatusinfo->num_rows() > 0 ) {
                        $last_status_name = $get_laststatusinfo->row()->status_name;
                        if(($last_status_name == "Delivered to Consignee") || ($get_laststatusinfo->row()->id == 1 && $get_laststatusinfo->row()->stop_type="D")){
                            $delivery_date = $get_laststatusinfo->row()->createdon;
                            $last_status_name = "Delivered";
                        }else{
                            if($get_laststatusinfo->row()->id == 1 && $get_laststatusinfo->row()->stop_type == "P") {
                                $last_status_name = "Pickedup";
                            }else if($get_laststatusinfo->row()->id == 1 && $get_laststatusinfo->row()->stop_type == "D"){
                                $last_status_name = "Delivered";
                            }
                        }
                        if($delivery_date == ""){
                            $status_code = $get_laststatusinfo->row()->status_code;
                            $stop_type = $get_laststatusinfo->row()->stop_type;
                            $status_id = $get_laststatusinfo->row()->status_id;
                            if($status_id == '3' && $status_code == '3000' && $stop_type == 'D') {
                                $d_time = getEDAofNZShipmentbyord($res['id']);
                                $d_date = $d_time['time'];
                                $delivery_status = "Delivered";
                                if(isset($d_date) && $d_date !=""){
                                    $date = '0000-00-00 00:00:00';
                                    if(($d_date != $date) || (strtotime($d_date) > 0)) {
                                        $delivery_date = date("d M Y",strtotime($d_date));
                                    } else {
                                        $delivery_date = "";
                                    }
                                }
                            }
                        }
                        if($get_laststatusinfo->row()->loc_name != null) {
                            $last_loc = $get_laststatusinfo->row()->loc_name;
                        } else {
                            $lat = $get_laststatusinfo->row()->latitude;
                            $lng = $get_laststatusinfo->row()->longitude;
                            $last_loc = getLocationName($lat, $lng);
                        }
                    }
                }

                /*get epods for order_id*/
                $epods = [];
                if($shift_id != 0) {
                    $epod_doc = $this->sendautoreportnotificationmodel->getEpodDoc($res['id'],$shift_id);
                    if(count($epod_doc)>0){
                        $i = 1;
                        $imglink = "";
                        foreach($epod_doc as $epd){
                                $imglink = checkimageintmsorknlmv($epd['imgpath']);
                                $link1 = '=hyperlink("' . $imglink . '")';
                                $epods[]= $link1;
                            $i++;
                        }
                    }
                }

                $finacial_data[] = array(
                    'id' => $res['id'],
                    'recipient_code' => $res['recipient_code'],
                    'recipient_name' => $res['recipient_name'],
                    'debtor_jfr' => $res['debtor_jfr'],
                    'cust_reference_num' => $cust_reference_num,
                    'lr_num' => $lr_num,
                    'finacial_status' => $staus_fin,
                    'goods_value' => $order_data['goods_value'],
                    'transport_mode' => $order_data['transport_mode'],
                    'shipper_address' => $order_data['pickup'],
                    'shipper_city' => $order_data['pickup_city'],
                    'consignee_address' => $order_data['delivery'],
                    'consignee_city' => $order_data['delivery_city'],
                    'goods_desc' => $final_cargo_content_str,
                    'title' => $title,
                    'pieces' => $order_data['totqty'],
                    'weight' => $order_data['totwg'],
                    'volumetric_weight' => $order_data['volumetric_weight'],
                    'carriername' => $carrier_name,
                    'pickup_date' => $pickup_date_status,
                    'estimate_d_date' => $estimate_deliverydate,
                    'delivery_status' => $delivery_status,
                    'delivery_date' => $delivery_date,
                    'last_status_name' => $last_status_name,
                    'last_loc' => $last_loc,
                    'order_row_id' => $res['order_id'],
                    'order_id' => $order_data['order_id'],
                    'epod' => $epods
                );
            }
        }

        $finacialdata = $finacial_data;
        if(count($finacialdata)> 0) {
            $styleArray = array(
                    'font'  => array(
                    'bold'  => true,
                    'color' => array('rgb' => 'FFFFFF'),
                    'size'  => 10,
                    'name'  => 'Verdana'
                ));
            $objPHPExcel = new PHPExcel();
            $objPHPExcel->setActiveSheetIndex(0);
            $objPHPExcel->getActiveSheet()
            ->getStyle('A1:AH1')
            ->applyFromArray(
                array(
                    'fill' => array(
                        'type' => PHPExcel_Style_Fill::FILL_SOLID,
                        'color' => array('rgb' => '0c3b81')
                    )
                )
            );
            $objPHPExcel->getActiveSheet()->SetCellValue('A1', 'TrackingNo');
            $objPHPExcel->getActiveSheet()->getStyle('A1')->applyFromArray($styleArray);
            $objPHPExcel->getActiveSheet()->SetCellValue('B1', 'Cust RefNo');
            $objPHPExcel->getActiveSheet()->getStyle('B1')->applyFromArray($styleArray);
            $objPHPExcel->getActiveSheet()->SetCellValue('C1', 'LR Number');
            $objPHPExcel->getActiveSheet()->getStyle('C1')->applyFromArray($styleArray);
            $objPHPExcel->getActiveSheet()->SetCellValue('D1', 'Customer ID');
            $objPHPExcel->getActiveSheet()->getStyle('D1')->applyFromArray($styleArray);
            $objPHPExcel->getActiveSheet()->SetCellValue('E1', 'Customer Name');
            $objPHPExcel->getActiveSheet()->getStyle('E1')->applyFromArray($styleArray);
            $objPHPExcel->getActiveSheet()->SetCellValue('F1', 'Revenue Line');
            $objPHPExcel->getActiveSheet()->getStyle('F1')->applyFromArray($styleArray);
            $objPHPExcel->getActiveSheet()->SetCellValue('G1', 'Job File Number');
            $objPHPExcel->getActiveSheet()->getStyle('G1')->applyFromArray($styleArray);
            $objPHPExcel->getActiveSheet()->SetCellValue('H1', 'Revenue Status');
            $objPHPExcel->getActiveSheet()->getStyle('H1')->applyFromArray($styleArray);
            $objPHPExcel->getActiveSheet()->SetCellValue('I1', 'Goods Value');
            $objPHPExcel->getActiveSheet()->getStyle('I1')->applyFromArray($styleArray);
            $objPHPExcel->getActiveSheet()->SetCellValue('J1', 'Mode Of Transport');
            $objPHPExcel->getActiveSheet()->getStyle('J1')->applyFromArray($styleArray);
            $objPHPExcel->getActiveSheet()->SetCellValue('K1', 'Shipper Name');
            $objPHPExcel->getActiveSheet()->getStyle('K1')->applyFromArray($styleArray);
            $objPHPExcel->getActiveSheet()->SetCellValue('L1', 'Shipper City');
            $objPHPExcel->getActiveSheet()->getStyle('L1')->applyFromArray($styleArray);
            $objPHPExcel->getActiveSheet()->SetCellValue('M1', 'Consignee Name');
            $objPHPExcel->getActiveSheet()->getStyle('M1')->applyFromArray($styleArray);
            $objPHPExcel->getActiveSheet()->SetCellValue('N1', 'Consignee City');
            $objPHPExcel->getActiveSheet()->getStyle('N1')->applyFromArray($styleArray);
            $objPHPExcel->getActiveSheet()->SetCellValue('O1', 'Goods Description');
            $objPHPExcel->getActiveSheet()->getStyle('O1')->applyFromArray($styleArray);
            $objPHPExcel->getActiveSheet()->SetCellValue('P1', 'Total Pkgs');
            $objPHPExcel->getActiveSheet()->getStyle('P1')->applyFromArray($styleArray);
            $objPHPExcel->getActiveSheet()->SetCellValue('Q1', 'Weight(Kgs)');
            $objPHPExcel->getActiveSheet()->getStyle('Q1')->applyFromArray($styleArray);
            $objPHPExcel->getActiveSheet()->SetCellValue('R1', 'Volumetric Weight');
            $objPHPExcel->getActiveSheet()->getStyle('R1')->applyFromArray($styleArray);
            $objPHPExcel->getActiveSheet()->SetCellValue('S1', 'Picked Up Date');
            $objPHPExcel->getActiveSheet()->getStyle('S1')->applyFromArray($styleArray);
            $objPHPExcel->getActiveSheet()->SetCellValue('T1', 'Estimated Delivery Date');
            $objPHPExcel->getActiveSheet()->getStyle('T1')->applyFromArray($styleArray);
            $objPHPExcel->getActiveSheet()->SetCellValue('U1', 'Delivery Status');
            $objPHPExcel->getActiveSheet()->getStyle('U1')->applyFromArray($styleArray);
            $objPHPExcel->getActiveSheet()->SetCellValue('V1', 'Delivery Date');
            $objPHPExcel->getActiveSheet()->getStyle('V1')->applyFromArray($styleArray);
            $objPHPExcel->getActiveSheet()->SetCellValue('W1', 'Last Status');
            $objPHPExcel->getActiveSheet()->getStyle('W1')->applyFromArray($styleArray);
            $objPHPExcel->getActiveSheet()->SetCellValue('X1', 'Last Location');
            $objPHPExcel->getActiveSheet()->getStyle('X1')->applyFromArray($styleArray);
            $objPHPExcel->getActiveSheet()->SetCellValue('Y1', 'Manage Documents');
            $objPHPExcel->getActiveSheet()->getStyle('Y1')->applyFromArray($styleArray);
            $rowCount = 2;

            foreach ($finacialdata as $result) {
                $objPHPExcel->getActiveSheet()->SetCellValue('A' . $rowCount, $result['order_id']);
                $objPHPExcel->getActiveSheet()->SetCellValue('B' . $rowCount, $result['cust_reference_num']);
                $objPHPExcel->getActiveSheet()->SetCellValue('C' . $rowCount, $result['lr_num']);
                $objPHPExcel->getActiveSheet()->SetCellValue('D' . $rowCount, $result['recipient_code']);
                $objPHPExcel->getActiveSheet()->SetCellValue('E' . $rowCount, $result['recipient_name']);
                $objPHPExcel->getActiveSheet()->SetCellValue('F' . $rowCount, $result['id']);
                $objPHPExcel->getActiveSheet()->SetCellValue('G' . $rowCount, $result['debtor_jfr']);
                $objPHPExcel->getActiveSheet()->SetCellValue('H' . $rowCount, $result['finacial_status']);
                $objPHPExcel->getActiveSheet()->SetCellValue('I' . $rowCount, $result['goods_value']);
                $objPHPExcel->getActiveSheet()->SetCellValue('J' . $rowCount, $result['transport_mode']);
                $objPHPExcel->getActiveSheet()->SetCellValue('K' . $rowCount, $result['shipper_address']);
                $objPHPExcel->getActiveSheet()->SetCellValue('L' . $rowCount, $result['shipper_city']);
                $objPHPExcel->getActiveSheet()->SetCellValue('M' . $rowCount, $result['consignee_address']);
                $objPHPExcel->getActiveSheet()->SetCellValue('N' . $rowCount, $result['consignee_city']);
                $objPHPExcel->getActiveSheet()->SetCellValue('O' . $rowCount, $result['goods_desc']);
                $objPHPExcel->getActiveSheet()->SetCellValue('P' . $rowCount, $result['pieces']);
                $objPHPExcel->getActiveSheet()->SetCellValue('Q' . $rowCount, $result['weight']);
                $objPHPExcel->getActiveSheet()->SetCellValue('R' . $rowCount, $result['volumetric_weight']);
                $objPHPExcel->getActiveSheet()->SetCellValue('S' . $rowCount, $result['pickup_date']);
                $objPHPExcel->getActiveSheet()->SetCellValue('T' . $rowCount, $result['estimate_d_date']);
                $objPHPExcel->getActiveSheet()->SetCellValue('U' . $rowCount, $result['delivery_status']);
                $objPHPExcel->getActiveSheet()->SetCellValue('V' . $rowCount, $result['delivery_date']);
                $objPHPExcel->getActiveSheet()->SetCellValue('W' . $rowCount, $result['last_status_name']);
                $objPHPExcel->getActiveSheet()->SetCellValue('X' . $rowCount, $result['last_loc']);
                if(is_array($result['epod']) && count($result['epod']) >=1) {
                    $col = 24;
                        foreach($result['epod'] as $key=>$value) {
                            $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($col, $rowCount, $value);
                            $col++;
                        }
                    }
                $rowCount++;
            }

            $fileName = 'FinancialReport-'.date("Ymdhis").'-'.$customer_data['id'].'.xlsx';
            $objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel2007');
            $objWriter->save(str_replace(__FILE__,'assets/trigger_now_reports/'.$fileName,__FILE__));
        }
        $attachment = $fileName;
        return $attachment;
    }

    public function getinbasicshipmentreport($report_arr)
    {
        ini_set("memory_limit","256M");
        $shipment_data = $order_data = $shipment_report= array();
        $userid = $this->session->userdata('user_id');
        $from_date = $to_date = $email_ids = $customer_id = "";
        $attachment = "";
        if(!empty($report_arr)) {
            $from_date = $report_arr['from_date'];
            $to_date = $report_arr['to_date'];
            $email_ids = $report_arr['customer_email_ids'];
            $customer_id = $report_arr['customer_id'];
        }
        $customer_data = $this->db->query(
            "select * from tb_customers where id= ? ",
            [ $customer_id]
        )->row_array();

        $whr = array();
        $lr_num = $cust_reference_num = "NA";
        $pickup_date_status = $estimate_deliverydate = "";
        $whr['user_id=']=$userid;

        if ($from_date != "") {
            $fromdate = date('Y-m-d', strtotime($from_date));
            $whr["DATE_FORMAT(o.createdon,'%Y-%m-%d') >="] = $fromdate;
        }

        if ($to_date != "") {
            $todate = date('Y-m-d', strtotime($to_date));
            $whr["DATE_FORMAT(o.createdon,'%Y-%m-%d') <="] = $todate;
        }

        $shipment_report = $this->sendautoreportnotificationmodel->getinshipmentdata($whr);

        /* get shipment data from orders Table */
        if (! empty($shipment_report)) {
            foreach ($shipment_report as $res) {

                /* get reference value */
                $lr_ref_no = $this->sendautoreportnotificationmodel->getreferenceorderdetails($res['id'], 'PO');

                if ($lr_ref_no->num_rows() > 0) {
                    $lr_num = $lr_ref_no->row()->ref_value;
                }

                $cust_ref_no = $this->sendautoreportnotificationmodel->getreferenceorderdetails($res['id'], 'DQ');
                if ($cust_ref_no->num_rows() > 0) {
                    $cust_reference_num = $cust_ref_no->row()->ref_value;
                }

                /* get Good description */
                $qry = $this->db->query(
                    "SELECT o.cargo_content
                        FROM tb_order_cargodetails o
                        WHERE o.order_id = ? AND o.status='1'
                        order by o.id desc",
                    [$res['id']]
                );
                $cargo_content = '';
                $title = "";
                if ($qry->num_rows() > 0) {
                    foreach ($qry->result() as $row) {
                        if ($row->cargo_content != '') {
                            $out = strlen($row->cargo_content) > 10 ? substr($row->cargo_content, 0, 5) . "..." : $row->cargo_content;
                            $cargo_content .= $out . ',';
                            $title .= $row->cargo_content . ',';
                        } else {
                            $cargo_content = '';
                        }
                    }
                }
                $cargo_content = rtrim($cargo_content, ',');
                $title = rtrim($title, ',');
                $cargo_content_arr = explode(',', $cargo_content);
                $array_tmp = $array_new = [];
                foreach ($cargo_content_arr as $k => $v) {
                    $index = $v;
                    $array_tmp[$index][] = $v;
                }
                foreach ($array_tmp as $k => $v) {
                    if (count($v) > 1) {
                        foreach ($v as $k2 => $v2) {
                            $array_new[] = $v2;
                        }
                    }
                }
                if (count($array_new)) {
                    $get_cargo_content = $array_new[0];
                    if (in_array($get_cargo_content, $cargo_content_arr)) {
                        $key_value = array_search($get_cargo_content, $cargo_content_arr);
                        unset($cargo_content_arr[$key_value]);
                    }
                }
                $final_cargo_content_str = implode(',', $cargo_content_arr);

                /* get carrier name */
                $carrier_name = '';
                $truckinfo = $this->db->query(
                    "SELECT v.name
                        FROM tb_vendors v,tb_employee e
                        WHERE e.order_id= ? AND e.vendor_id=v.id and v.id= ?",
                    [$res['order_id'], $res['vendor_id']]
                );

                if ($truckinfo->num_rows() > 0) {
                    $carrier_name = $truckinfo->row()->name;
                }

                $shift_id = $res['shift_id'];

                /* Get pickup Date */
                $early_pickup = $res['pickup_datetime'];
                $sql4 = $this->sendautoreportnotificationmodel->getpickupshipdateils($res['order_id']);
                if($sql4->num_rows() > 0) {
                    $pickupdate_time = $sql4->row()->createdon;
                    if($pickupdate_time != "" && $pickupdate_time != "0000-00-00 00:00:00") {
                        $pickup_date_status = date("d M Y",strtotime($pickupdate_time));
                    }
                } else {
                    if($early_pickup != "" && $early_pickup != "0000-00-00 00:00:00") {
                        $pickup_date_status = date("d M Y",strtotime($early_pickup));
                    }
                }

                /** Estimated Delivered Date **/
                $estimate_de_date = $res['delivery_datetime'];
                if($estimate_de_date != "" && $estimate_de_date != "0000-00-00 00:00:00") {
                    $estimate_deliverydate = date("d M Y",strtotime($estimate_de_date));
                }

                /** get last status,delivery status,location,delivery date **/
                $last_status_name = $last_loc = $delivery_date = $delivery_status = "";
                if($shift_id !=0) {
                  $get_laststatusinfo = $this->sendautoreportnotificationmodel->getlaststoptransdetails($res['order_id'],$shift_id);
                    $delivery_status = "Not Delivered";
                    if($res['trip_sts'] == 1){
                        $last_status_name = "Delivered";
                        $delivery_status = "Delivered";
                    }
                    if($get_laststatusinfo->num_rows() > 0 ) {
                        $last_status_name = $get_laststatusinfo->row()->status_name;
                        if(($last_status_name == "Delivered to Consignee") || ($get_laststatusinfo->row()->id == 1 && $get_laststatusinfo->row()->stop_type="D")){
                            $delivery_date = $get_laststatusinfo->row()->createdon;
                            $last_status_name = "Delivered";
                        }else{
                            if($get_laststatusinfo->row()->id == 1 && $get_laststatusinfo->row()->stop_type == "P") {
                                $last_status_name = "Pickedup";
                            }else if($get_laststatusinfo->row()->id == 1 && $get_laststatusinfo->row()->stop_type == "D"){
                                $last_status_name = "Delivered";
                            }
                        }
                        if($delivery_date == ""){
                            $status_code = $get_laststatusinfo->row()->status_code;
                            $stop_type = $get_laststatusinfo->row()->stop_type;
                            $status_id = $get_laststatusinfo->row()->status_id;
                            if($status_id == '3' && $status_code == '3000' && $stop_type == 'D') {
                                $d_time = getEDAofNZShipmentbyord($res['id']);
                                $d_date = $d_time['time'];
                                $delivery_status = "Delivered";
                                if(isset($d_date) && $d_date !=""){
                                    $date = '0000-00-00 00:00:00';
                                    if(($d_date != $date) || (strtotime($d_date) > 0)) {
                                        $delivery_date = date("d M Y",strtotime($d_date));
                                    } else {
                                        $delivery_date = "";
                                    }
                                }
                            }
                        }
                        if($get_laststatusinfo->row()->loc_name != null) {
                            $last_loc = $get_laststatusinfo->row()->loc_name;
                        } else {
                            $lat = $get_laststatusinfo->row()->latitude;
                            $lng = $get_laststatusinfo->row()->longitude;
                            $last_loc = getLocationName($lat, $lng);
                        }
                    }
                }

                /*get epods for order_id*/
                $epods = [];
                if($shift_id != 0) {
                    $epod_doc = $this->sendautoreportnotificationmodel->getEpodDoc($res['id'],$shift_id);
                    if(count($epod_doc)>0){
                        $i = 1;
                        $imglink = "";
                        foreach($epod_doc as $epd){
                              $imglink = checkimageintmsorknlmv($epd['imgpath']);
                                $link1 = '=hyperlink("' . $imglink . '")';
                                $epods[]= $link1;
                            $i++;
                        }
                    }
                }

                $shipmentid = $res['shipmentid'];
                $sid = 0;
                $stops_arr=[];

                if (!empty($shipmentid)) {
                    $sql3 = $this->db->query(
                        "select id
                            from tb_shifts
                            where status = 1 and shipmentid = ?
                            GROUP BY id ORDER BY id DESC",
                        [$shipmentid]
                    );
                    if ($sql3->num_rows() > 0) {
                        $sid = $sql3->row()->id;
                        $stops = $this->db->query(
                            "SELECT id
                                from tb_shiporder_stops
                                WHERE status = '1' AND shipment_id= ?
                                ORDER BY ordernumber",
                            [$sid]
                        );
                        if ($stops->num_rows() > 0) {
                            $stops_arr = $stops->result_array();
                        }
                    }
                }

                $oid = "";
                $livetrack_link = "";
                if(count($stops_arr)>0){
                    $oid = @getOrderIds($stops_arr[0]["id"]);
                }
                $parts = explode(",",$oid);
                if(count($parts)>0){
                    $oid = $parts[0];
                }

                if(!empty($oid)) {
                    $livetrack_link = base_url('livetrack/etnshipment/')."/".$res['order_id']."?inner";
                    $livetrack_link = '=hyperlink("' . $livetrack_link . '")';
                }

                $order_data[] = array('order_row_id'=>$res['id'],'order_id'=>$res['order_id'],'pieces'=>$res['totqty'],
                    'weight'=>$res['totwg'],
                    'volumetric_weight' => $res['volumetric_weight'],
                    'goods_desc' => $final_cargo_content_str,'pickup'=>$res['pickup'],
                    'delivery'=>$res['delivery'],
                    'carriername'=>$carrier_name,'shipper_address'=>$res['pickup'],'shipper_city'=>$res['pickup_city'],
                    'consignee_address'=>$res['delivery'],'consignee_city'=>$res['delivery_city'],
                    'pickup_date'=>$pickup_date_status,
                    'estimate_d_date'=>$estimate_deliverydate,
                    'delivery_date'=>$delivery_date,
                    'cust_reference_num'=>$cust_reference_num,'lr_num' => $lr_num,
                    'goods_value' => $res['goods_value'],'transport_mode' => $res['transport_mode'],
                    'delivery_status' => $delivery_status,
                    'last_status_name' => $last_status_name,
                    'last_loc' => $last_loc,
                    'title' => $title,
                    'epod' => $epods,
                    'livetrack_link' => $livetrack_link
                );
            }
        }

        $shipment_data = $order_data;
        if(count($shipment_data)> 0) {
            $styleArray = array(
                    'font'  => array(
                    'bold'  => true,
                    'color' => array('rgb' => 'FFFFFF'),
                    'size'  => 10,
                    'name'  => 'Verdana'
                ));
            $objPHPExcel = new PHPExcel();
            $objPHPExcel->setActiveSheetIndex(0);
            $objPHPExcel->getActiveSheet()
            ->getStyle('A1:AH1')
            ->applyFromArray(
                array(
                    'fill' => array(
                        'type' => PHPExcel_Style_Fill::FILL_SOLID,
                        'color' => array('rgb' => '0c3b81')
                    )
                )
            );
            $objPHPExcel->getActiveSheet()->SetCellValue('A1', 'TrackingNo');
            $objPHPExcel->getActiveSheet()->getStyle('A1')->applyFromArray($styleArray);
            $objPHPExcel->getActiveSheet()->SetCellValue('B1', 'Cust RefNo');
            $objPHPExcel->getActiveSheet()->getStyle('B1')->applyFromArray($styleArray);
            $objPHPExcel->getActiveSheet()->SetCellValue('C1', 'LR Number');
            $objPHPExcel->getActiveSheet()->getStyle('C1')->applyFromArray($styleArray);
            $objPHPExcel->getActiveSheet()->SetCellValue('D1', 'Goods Value');
            $objPHPExcel->getActiveSheet()->getStyle('D1')->applyFromArray($styleArray);
            $objPHPExcel->getActiveSheet()->SetCellValue('E1', 'Mode Of Transport');
            $objPHPExcel->getActiveSheet()->getStyle('E1')->applyFromArray($styleArray);
            $objPHPExcel->getActiveSheet()->SetCellValue('F1', 'Shipper Name');
            $objPHPExcel->getActiveSheet()->getStyle('F1')->applyFromArray($styleArray);
            $objPHPExcel->getActiveSheet()->SetCellValue('G1', ' Shipper City');
            $objPHPExcel->getActiveSheet()->getStyle('G1')->applyFromArray($styleArray);
            $objPHPExcel->getActiveSheet()->SetCellValue('H1', 'Consignee Name');
            $objPHPExcel->getActiveSheet()->getStyle('H1')->applyFromArray($styleArray);
            $objPHPExcel->getActiveSheet()->SetCellValue('I1', 'Consignee City');
            $objPHPExcel->getActiveSheet()->getStyle('I1')->applyFromArray($styleArray);
            $objPHPExcel->getActiveSheet()->SetCellValue('J1', 'Goods Description');
            $objPHPExcel->getActiveSheet()->getStyle('J1')->applyFromArray($styleArray);
            $objPHPExcel->getActiveSheet()->SetCellValue('K1', 'Total Pkgs');
            $objPHPExcel->getActiveSheet()->getStyle('K1')->applyFromArray($styleArray);
            $objPHPExcel->getActiveSheet()->SetCellValue('L1', 'Weight(Kgs)');
            $objPHPExcel->getActiveSheet()->getStyle('L1')->applyFromArray($styleArray);
            $objPHPExcel->getActiveSheet()->SetCellValue('M1', ' Volumetric Weight');
            $objPHPExcel->getActiveSheet()->getStyle('M1')->applyFromArray($styleArray);
            $objPHPExcel->getActiveSheet()->SetCellValue('N1', ' Vendor Name');
            $objPHPExcel->getActiveSheet()->getStyle('N1')->applyFromArray($styleArray);
            $objPHPExcel->getActiveSheet()->SetCellValue('O1', ' Picked Up Date');
            $objPHPExcel->getActiveSheet()->getStyle('O1')->applyFromArray($styleArray);
            $objPHPExcel->getActiveSheet()->SetCellValue('P1', 'Estimated Delivery Date');
            $objPHPExcel->getActiveSheet()->getStyle('P1')->applyFromArray($styleArray);
            $objPHPExcel->getActiveSheet()->SetCellValue('Q1', 'Delivery Status');
            $objPHPExcel->getActiveSheet()->getStyle('Q1')->applyFromArray($styleArray);
            $objPHPExcel->getActiveSheet()->SetCellValue('R1', 'Delivery Date');
            $objPHPExcel->getActiveSheet()->getStyle('R1')->applyFromArray($styleArray);
            $objPHPExcel->getActiveSheet()->SetCellValue('S1', 'Last Status');
            $objPHPExcel->getActiveSheet()->getStyle('S1')->applyFromArray($styleArray);
            $objPHPExcel->getActiveSheet()->SetCellValue('T1', 'Last location');
            $objPHPExcel->getActiveSheet()->getStyle('T1')->applyFromArray($styleArray);
            $objPHPExcel->getActiveSheet()->SetCellValue('U1', 'Live Track Link');
            $objPHPExcel->getActiveSheet()->getStyle('U1')->applyFromArray($styleArray);
            $objPHPExcel->getActiveSheet()->SetCellValue('V1', 'Managedocuments');
            $objPHPExcel->getActiveSheet()->getStyle('V1')->applyFromArray($styleArray);
            $rowCount = 2;
            foreach($shipment_data as $order) {
                $objPHPExcel->getActiveSheet()->SetCellValue('A' . $rowCount, $order['order_id']);
                $objPHPExcel->getActiveSheet()->SetCellValue('B' . $rowCount, $order['cust_reference_num']);
                $objPHPExcel->getActiveSheet()->SetCellValue('C' . $rowCount, $order['lr_num']);
                $objPHPExcel->getActiveSheet()->SetCellValue('D' . $rowCount, $order['goods_value']);
                $objPHPExcel->getActiveSheet()->SetCellValue('E' . $rowCount, $order['transport_mode']);
                $objPHPExcel->getActiveSheet()->SetCellValue('F' . $rowCount, $order['shipper_address']);
                $objPHPExcel->getActiveSheet()->SetCellValue('G' . $rowCount, $order['shipper_city']);
                $objPHPExcel->getActiveSheet()->SetCellValue('H' . $rowCount, $order['consignee_address']);
                $objPHPExcel->getActiveSheet()->SetCellValue('I' . $rowCount, $order['consignee_city']);
                $objPHPExcel->getActiveSheet()->SetCellValue('J' . $rowCount, $order['goods_desc']);
                $objPHPExcel->getActiveSheet()->SetCellValue('K' . $rowCount, $order['pieces']);
                $objPHPExcel->getActiveSheet()->SetCellValue('L' . $rowCount, $order['weight']);
                $objPHPExcel->getActiveSheet()->SetCellValue('M' . $rowCount, $order['volumetric_weight']);
                $objPHPExcel->getActiveSheet()->SetCellValue('N' . $rowCount, $order['carriername']);
                $objPHPExcel->getActiveSheet()->SetCellValue('O' . $rowCount, $order['pickup_date']);
                $objPHPExcel->getActiveSheet()->SetCellValue('P' . $rowCount, $order['estimate_d_date']);
                $objPHPExcel->getActiveSheet()->SetCellValue('Q' . $rowCount, $order['delivery_status']);
                $objPHPExcel->getActiveSheet()->SetCellValue('R' . $rowCount, $order['delivery_date']);
                $objPHPExcel->getActiveSheet()->SetCellValue('S' . $rowCount, $order['last_status_name']);
                $objPHPExcel->getActiveSheet()->SetCellValue('T' . $rowCount, $order['last_loc']);
                $objPHPExcel->getActiveSheet()->SetCellValue('U' . $rowCount, $order['livetrack_link']);
                if(is_array($order['epod']) && count($order['epod']) >=1) {
                    $col = 21;
                        foreach($order['epod'] as $key=>$value) {
                            $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($col, $rowCount, $value);
                            $col++;
                        }
                    }
                $rowCount++;
            }

            $fileName = 'InBasicShipmentReport-'.date("Ymdhis").'-'.$customer_id.'.xlsx';
            $objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel2007');
            $objWriter->save(str_replace(__FILE__,'assets/trigger_now_reports/'.$fileName,__FILE__));
        }
        $attachment = $fileName;
        return $attachment;
    }

    public function gettruckervolumereport($report_arr)
    {
        ini_set("memory_limit","256M");
        $truck_data = $order_data = $trucker_report= array();
        $userid = $this->session->userdata('user_id');
        $from_date = $to_date = $email_ids = $customer_id = "";
        $attachment = "";
        if(!empty($report_arr)) {
            $from_date = $report_arr['from_date'];
            $to_date = $report_arr['to_date'];
            $email_ids = $report_arr['customer_email_ids'];
            $customer_id = $report_arr['customer_id'];
        }
        $customer_data = $this->db->query(
            "select * from tb_customers where id= ? ",
            [$customer_id]
        )->row_array();

        $whr = array();
        $whr['user_id=']=$userid;

        if ($from_date != "") {
            $fromdate = date('Y-m-d', strtotime($from_date));
            $whr["DATE_FORMAT(o.createdon,'%Y-%m-%d') >="] = $fromdate;
        }

        if ($to_date != "") {
            $todate = date('Y-m-d', strtotime($to_date));
            $whr["DATE_FORMAT(o.createdon,'%Y-%m-%d') <="] = $todate;
        }

        $trucker_report = $this->sendautoreportnotificationmodel->gettruckerreport($whr);

        /* get shipment data from orders Table */
        if (! empty($trucker_report)) {
            foreach ($trucker_report as $res) {

                /* get carrier name */
                $carrier_name = '';
                $truckinfo = $this->db->query(
                    "SELECT v.name
                        FROM tb_vendors v,tb_employee e
                        WHERE e.order_id = ? AND e.vendor_id=v.id and v.id= ?",
                    [$res['order_id'], $res['vendor_id']]
                );

                if ($truckinfo->num_rows() > 0) {
                    $carrier_name = $truckinfo->row()->name;
                }

                $trip_sts = $res['trip_sts'];
                $trip_id = $res['trip_id'];

                $order_status = 'PENDING';
                if($trip_id != 0 && $trip_sts == 0){
                    $order_status = 'ACTIVE';
                }
                if($trip_id != 0 && $trip_sts == 1){
                    $order_status = 'CLOSED';
                }

                /** delivery note **/
                $getdnote = $this->db->select("ref_value")->get_where("tb_order_references",array('order_id'=>$res['id'],'reference_id'=>'DQ'));
                if($getdnote->num_rows() >0){
                    $delivery_note = $getdnote->row()->ref_value;
                } else {
                    $delivery_note = "";
                }

                $order_data[] = array(
                    'order_row_id'=>$res['id'],
                    'order_id'=>$res['order_id'],
                    'pieces'=>$res['totqty'],
                    'weight'=>$res['totwg'],
                    'volume'=>$res['totvol'],
                    'createdon'=>date("Y-m-d",strtotime($res['createdon'])),
                    'pickup'=>$res['pickup'],
                    'delivery'=>$res['delivery'],
                    'shipid'=>$delivery_note,
                    'order_status' => $order_status,
                    'carriername'=>$carrier_name
                );
            }
        }

        $truck_data = $order_data;
        if(count($truck_data)> 0) {

            $styleArray = array(
                    'font'  => array(
                    'bold'  => true,
                    'color' => array('rgb' => 'FFFFFF'),
                    'size'  => 10,
                    'name'  => 'Verdana'
                ));
            $objPHPExcel = new PHPExcel();
            $objPHPExcel->setActiveSheetIndex(0);
            $objPHPExcel->getActiveSheet()
            ->getStyle('A1:AH1')
            ->applyFromArray(
                array(
                    'fill' => array(
                        'type' => PHPExcel_Style_Fill::FILL_SOLID,
                        'color' => array('rgb' => '0c3b81')
                    )
                )
            );
            $objPHPExcel->getActiveSheet()->SetCellValue('A1', 'Order ID');
            $objPHPExcel->getActiveSheet()->getStyle('A1')->applyFromArray($styleArray);
            $objPHPExcel->getActiveSheet()->SetCellValue('B1', 'Delivery Note');
            $objPHPExcel->getActiveSheet()->getStyle('B1')->applyFromArray($styleArray);
            $objPHPExcel->getActiveSheet()->SetCellValue('C1', 'Pickup');
            $objPHPExcel->getActiveSheet()->getStyle('C1')->applyFromArray($styleArray);
            $objPHPExcel->getActiveSheet()->SetCellValue('D1', 'Delivery');
            $objPHPExcel->getActiveSheet()->getStyle('D1')->applyFromArray($styleArray);
            $objPHPExcel->getActiveSheet()->SetCellValue('E1', 'Status');
            $objPHPExcel->getActiveSheet()->getStyle('E1')->applyFromArray($styleArray);
            $objPHPExcel->getActiveSheet()->SetCellValue('F1', 'Pieces');
            $objPHPExcel->getActiveSheet()->getStyle('F1')->applyFromArray($styleArray);
            $objPHPExcel->getActiveSheet()->SetCellValue('G1', 'Weight(Kgs)');
            $objPHPExcel->getActiveSheet()->getStyle('G1')->applyFromArray($styleArray);
            $objPHPExcel->getActiveSheet()->SetCellValue('H1', 'Volume');
            $objPHPExcel->getActiveSheet()->getStyle('H1')->applyFromArray($styleArray);
            $objPHPExcel->getActiveSheet()->SetCellValue('I1', 'Trucker');
            $objPHPExcel->getActiveSheet()->getStyle('I1')->applyFromArray($styleArray);
            $objPHPExcel->getActiveSheet()->SetCellValue('J1', 'Created Date');
            $objPHPExcel->getActiveSheet()->getStyle('J1')->applyFromArray($styleArray);
            $rowCount = 2;

            foreach($truck_data as $order) {
                $objPHPExcel->getActiveSheet()->SetCellValue('A' . $rowCount, $order['order_id']);
                $objPHPExcel->getActiveSheet()->SetCellValue('B' . $rowCount, $order['shipid']);
                $objPHPExcel->getActiveSheet()->SetCellValue('C' . $rowCount, $order['pickup']);
                $objPHPExcel->getActiveSheet()->SetCellValue('D' . $rowCount, $order['delivery']);
                $objPHPExcel->getActiveSheet()->SetCellValue('E' . $rowCount, $order['order_status']);
                $objPHPExcel->getActiveSheet()->SetCellValue('F' . $rowCount, $order['pieces']);
                $objPHPExcel->getActiveSheet()->SetCellValue('G' . $rowCount, $order['weight']);
                $objPHPExcel->getActiveSheet()->SetCellValue('H' . $rowCount, $order['volume']);
                $objPHPExcel->getActiveSheet()->SetCellValue('I' . $rowCount, $order['carriername']);
                $objPHPExcel->getActiveSheet()->SetCellValue('J' . $rowCount, $order['createdon']);
                $rowCount++;
            }
            $fileName = 'TruckerVolumeReport-'.date("Ymdhis").'-'.$customer_id.'.xlsx';
            $objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel2007');
            $objWriter->save(str_replace(__FILE__,'assets/trigger_now_reports/'.$fileName,__FILE__));
        }
        $attachment = $fileName;
        return $attachment;
    }

    public function sendreports($data) {
        $this->load->library('email');

        $cemailids = explode(", ",$data['email_ids']);
        $cemailids = array_unique($cemailids);
        $cc_mail = implode(", ",$cemailids);
        $cc_mail = '"'.$cc_mail.'"';

        $this->email->set_newline("\r\n");
        $this->email->from('svkonekt@kuehne-nagel.com', 'svkonekt');
        $this->email->to(implode(", ",$cemailids), $data['username']);
        $this->email->subject($data['subject']);

        $this->email->set_mailtype("html");
        $mdata = ['username' => $data['username'],'page_title' => 'Auto Report Notification'];
        $body = $this->load->view('mail_forms/autoreports/send_reports', $mdata, true);
        $this->email->message($body);
        if(isset($data['attachments']) && !empty($data['attachments'])) {
            foreach($data['attachments'] as $attachment) {
                $file = base_url()."assets/trigger_now_reports/".$attachment;
                $this->email->attach($file);
            }
        }
        if(!$this->email->send()){
            log_message('error',' notification mail failed MailID: '.$cc_mail);
            log_message("error",$this->email->print_debugger());
        }
        return true;
    }
}
