<?php
if (!defined('BASEPATH')) {
    exit('No direct script access allowed');
}

class BUFAECNReport extends CI_Controller
{
    public function __construct()
    {
        parent::__construct();
        if ($this->session->userdata('user_id') === null) {
            redirect('login');
        }
    }

    public function index(): void
    {
        $this->newtemplate->dashboard("bufaoccecnreports/index", []);
    }

    public function ajaxListing(): void
    {
        $draw = $this->input->post('draw', true);
        $start = $this->input->post('start', true);
        $length = $this->input->post('length', true);
        $limit = $length;
        $offset = $start * $draw;
        $limitCondition = ($limit == -1) ? "" : "LIMIT " . $limit;
        if($offset > 0){
            $limitCondition = "LIMIT ".$limit." OFFSET ".$offset;
        }
        $fromDate = $this->input->post('fromDate', true);
        $toDate = $this->input->post('toDate', true);
        $fromDate = date("Y-m-d", strtotime($fromDate));
        $toDate = date("Y-m-d", strtotime($toDate));
        $sql = "SELECT Date(t.pt) 'pickupDatetime',
        'CNKN',
        t.brn 'branchCode', (
        CASE
                  WHEN t.sdt = 'PUP' THEN 'AE'
                  ELSE 'AI'
        END ) 'departmentCode',
        'SHANO' AS 'Party',
        t.rem 'remValue',
        t.a1 AS 'TN',
        t.a  AS 'aVal',
        t.awbnumber 'RefNo',
        NULL 'Shipper',
        t.a2 AS 'Pieces',
        t.w 'GW',
        t.v 'Volume', (
        CASE
                  WHEN (
                                      v/0.006)> w THEN (v/0.006)
                  ELSE w
        END) AS 'CW' ,
        NULL 'State',
    --  NULL 'TaskName',
        t.carriername 'carrierName',
        NULL 'DueDate',
        NULL 'PickUpCity',
        NULL 'val1',
        NULL 'val2',
        NULL 'val3',
        NULL 'PricingValue',
        NULL 'PricingCurrency',
        NULL 'ChargeCode',
        NULL 'AllowRepeat',
        NULL 'val4',
        t.aa 'aaVal',
        t.sla1 'sla',
        t.dla1 'dla'
FROM      (
                  SELECT    tos.order_id                                            aa,
                            Substr(sac.ref_value,1 , Instr(sac.ref_value,'@')-1) AS a ,
                            xsr.ref_value                                           a1,
                            tos.quantity                                            a2,
                            'PCS'                                                   a3,
                            tos.weight                                              w ,
                            tos.gross_weight_uom                                    w1,
                            tos.volume                                              v ,
                            -- cds.cargo_id ,
                            date_add(tos.pickup_datetime ,interval 8 hour)                                                                                                                   pt,
                            date_add(time(tos.pickup_datetime), interval 8 hour)                                                                                                             ptt,
                            rem.ref_value                                                                                                                                                    AS rem,
                            replace(substring_index( substring_index(replace(rem.ref_value,' ',''),'|',1), 'ä¸­æ–‡åœ°å€ï¼šæè´§åœ°å€:', -1 ) ,char(10),'') AS b,
                            replace(substring_index( substring_index(replace(rem.ref_value,' ',''),'|',2), 'æè´§è”ç³»äººï¼š', -1 ) ,                      char(10),'') AS d,
                            replace(substring_index( substring_index(replace(rem.ref_value,' ',''),'|',3), 'é€è´§åœ°å€ï¼š', -1) ,                            char(10),'') AS c,
                            replace(substring_index( substring_index(replace(rem.ref_value,' ',''),'|',4), 'é€è´§è”ç³»äººï¼š', -1) ,                      char(10),'') AS e,
                            sla.ref_value                                                                                                                                                       sla1,
                            dla.ref_value                                                                                                                                                       dla1,
                            tos.customer_id                                                                                                                                                     tcid,
                            awb.ref_value                                                                                                                                                       awbnumber,
                            sad.ref_value                                                                                                                                                       sadrv,
                            sdt.ref_value                                                                                                                                                       sdt,
                            brn.ref_value                                                                                                                                                       brn,
                            tv.NAME                                                                                                                                                             carriername
                  FROM      `tb_orders` tos
                  LEFT JOIN tb_order_references xsr
                  ON        tos.id = xsr.order_id
                  AND       xsr.reference_id = 'xsr'
                  LEFT JOIN tb_order_references sac
                  ON        tos.id = sac.order_id
                  AND       sac.reference_id = 'SAC'
                  LEFT JOIN tb_order_references rem
                  ON        tos.id = rem.order_id
                  AND       rem.reference_id = 'rem'
                  LEFT JOIN tb_order_references sad
                  ON        tos.id = sad.order_id
                  AND       sad.reference_id = 'SAD'
                  LEFT JOIN tb_order_references sla
                  ON        tos.id = sla.order_id
                  AND       sla.reference_id = 'SLA'
                  LEFT JOIN tb_order_references dla
                  ON        tos.id = dla.order_id
                  AND       dla.reference_id = 'DLA'
                  LEFT JOIN tb_order_references awb
                  ON        tos.id = awb.order_id
                  AND       awb.reference_id = 'AWB'
                  LEFT JOIN tb_order_references sdt
                  ON        tos.id = sdt.order_id
                  AND       sdt.reference_id = 'SDT'
                  LEFT JOIN tb_order_references brn
                  ON        tos.id = brn.order_id
                  AND       brn.reference_id = 'BRN'
                  LEFT JOIN tb_vendors tv
                  ON        tv.id = tos.vendor_id
                  AND       tv.NAME != 'James Test Carrier'
                  WHERE     tos.company_code = 'CNKN'
                  AND       tos.branch_code = 'CNSHA'
                   AND       date(tos.createdon) >= '$fromDate'
                  AND       date(tos.createdon) <= '$toDate'
                 GROUP BY tos.id ORDER BY tos.id DESC {$limitCondition}) t
LEFT JOIN tb_customers tcs
ON        tcs.id = t.tcid";

        $results = $this->db->query($sql)->result();
        $data = [];
        if (count($results) > 0) {
            foreach ($results as $result) {
                $data[] = [
                    'pickupDate' => $result->pickupDatetime,
                    'companyCode' => $result->CNKN,
                    'branchCode' => $result->branchCode,
                    'departmentCode' => $result->departmentCode,
                    'Party' => $result->Party,
                    'remValue' => $result->remValue,
                    'TN' => $result->TN,
                    'aVal' => $result->aVal,
                    'RefNo' => $result->RefNo,
                    'Shipper' => $result->Shipper,
                    'Pieces' => $result->Pieces,
                    'GW' => $result->GW,
                    'Volume' => $result->Volume,
                    'CW' => $result->CW,
                    'State' => $result->State,
                    // 'TaskName' => $result->TaskName,
                    'carrierName' => $result->carrierName,
                    'DueDate' => $result->DueDate,
                    'PickUpCity' => $result->PickUpCity,
                    'val1' => $result->val1,
                    'val2' => $result->val2,
                    'val3' => $result->val3,
                    'PricingValue' => $result->PricingValue,
                    'PricingCurrency' => $result->PricingCurrency,
                    'ChargeCode' => $result->ChargeCode,
                    'AllowRepeat' => $result->AllowRepeat,
                    'val4' => $result->val4,
                    'aaVal' => $result->aaVal,
                    'sla' => $result->sla,
                    'dla' => $result->dla

                ];
            }
        }
        echo json_encode($data);
    }
}
