<?php

if (!defined('BASEPATH')) {
    exit('No direct script access allowed');
}
require_once APPPATH . "/third_party/PHPExcel.php";

class Basicshipmentreport extends CI_Controller
{
    public function __construct()
    {
        parent::__construct();
        $this->load->model('aquaticamodel');
        $this->load->model('common');
        if ($this->session->userdata('user_id') == '') {
            redirect('login');
        }
        $this->load->helper('report_helper');
        if (!checkUrlAccessForUser('BASICSHIPMENTREPORT')) {
            redirect("Forbiddenaccess");
        }
    }

    public function index()
    {
        $this->session->set_userdata('edi_received', false);
        $this->getsearchresult();
    }

    public function ediReceivedBsr()
    {
        $this->session->set_userdata('edi_received', true);
        $this->getsearchresult();
    }

    public function getsearchresult()
    {
        $business_type = $this->session->userdata('business_type');
        if ($business_type == 'Carrier') {
            redirect('/');
        }
        $cdate = date('Y-m-d h:i:s');
        $custid = "";
        $data['page_title'] = $this->lang->line('basic_shipment');
        $data['sub_title'] = $this->lang->line('leftmenu_reports');
        $userid = $this->session->userdata("user_id");
        $company_code = $this->session->userdata("company_code");
        if($this->session->userdata('edi_received')){
            $data['page_title'] = $this->lang->line('basic_shipment_auku');
        }
        $curtz = $this->session->userdata("usr_tzone")['timezone'];
        if (!empty($this->session->userdata("cust_id"))) {
            $custid = $this->session->userdata("cust_id");
        }
        $aquorder = $country_userids = $whr = $post = $where = $other_checks = $wherein = $subcusts = $general_array = [];
        if (!empty($this->session->userdata("country_user_ids")) && ($this->session->userdata("country_user_ids") != null) && (count($this->session->userdata("country_user_ids")) > 0)) {
            $country_userids = $this->session->userdata("country_user_ids");
        }

        $status_search = "";
        if ($company_code == "AUKN") {
            $where = [
                "company_code" => "AUKN",
                "status" => 1
            ];
        } else {
            if ($company_code == "INKN") {
                $user_role_id = $this->session->userdata('user_role_id');
                if ($user_role_id == '4') {
                    $where = [
                        "company_code" => "INKN",
                        "status" => 1,
                        "custid" => $custid
                    ];
                } else {
                    $where = [
                        "company_code" => "INKN",
                        "status" => 1
                    ];
                }
            } else {
                $where = [
                    "user_id" => $userid,
                    "status" => 1
                ];
            }
        }

        $select = "id,name";
        $table = "tb_vendors";
        $carrierlist = $this->common->gettbldata($where, $select, $table, 0, 0);
        $data['carrierlist'] = $carrierlist;
        $post = [];
        $post1 = $this->input->post(null, true);
        $aqucarrier = isset($post1['aqucarrier']) ? $post1['aqucarrier'] : [];
        $data['aqucarrierid'] = $aqucarrier;
        $aqucarrierid_adv = isset($post1['aqucarrierid_adv']) ? $post1['aqucarrierid_adv'] : [];
        $data['aqucarrierid_adv'] = $aqucarrierid_adv;

        if (isset($post1['searchsubmit']) && $post1['searchsubmit'] == "Search") {
            $post = $post1;
        }

        if (!empty($post)) {
            $whr = $this->searchorders($post);
            $order_status = isset($post['aquordtype']) ? $post['aquordtype'] : "";
            /* log_message('error',"manifest:".$order_status); */
            $ad_orderstatus = isset($post['order_status']) ? $post['order_status'] : "";

            if (isset($post['aqucarrier']) && $post['aqucarrier'] != []) {
                $wherein['vendor_id'] = $post['aqucarrier'];
            }

            if (isset($post['aqucarrierid_adv']) && $post['aqucarrierid_adv'] != []) {
                $wherein['vendor_id'] = $post['aqucarrierid_adv'];
            }

            if (!empty($order_status)) {
                $status_search = $order_status;
            }

            if (!empty($ad_orderstatus)) {
                $status_search = $ad_orderstatus;
            }

            $other_checks['status_search'] = $status_search;

            if (isset($post['shipper_name']) && $post['shipper_name'] != "") {
                $other_checks['shipper_name'] = $post['shipper_name'];
            }

            if (isset($post['consignee_name']) && $post['consignee_name'] != "") {
                $other_checks['consignee_name'] = $post['consignee_name'];
            }

            if (isset($post['lr_number']) && $post['lr_number'] != "") {
                $other_checks['lr_number'] = $post['lr_number'];
            }

            if (isset($post['customer_reference_number']) && $post['customer_reference_number'] != "") {
                $other_checks['customer_reference_number'] = $post['customer_reference_number'];
            }

            if (isset($post['qbook_pickupdatetime']) && $post['qbook_pickupdatetime'] != "") {
                $other_checks['qbook_pickupdatetime'] = $post['qbook_pickupdatetime'];
            }
            if ($company_code == "AUKN" || $company_code == "INKN") {
                if (isset($post['container_num']) && $post['container_num'] != "") {
                    $other_checks['container_num'] = trim($post['container_num']);
                }
            }
            $other_checks['closed_from_date'] = $other_checks['closed_to_date'] = "";
            if ($this->session->userdata('company_code') == 'AUKN') {
                if ($other_checks['status_search'] == 'CLOSED') {
                    if (isset($post['aqufromdate']) && $post['aqufromdate'] != "") {
                        $other_checks['closed_from_date'] = date('Y-m-d', strtotime($post['aqufromdate']));
                        if (isset($post['aqutodate'])) {
                            if ($post['aqutodate'] == "") {
                                $other_checks['closed_to_date'] = date('Y-m-d', strtotime($cdate));
                            }
                        } else {
                            $other_checks['closed_to_date'] = date('Y-m-d', strtotime($cdate));
                        }
                        if (isset($post['aqutodate']) && $post['aqutodate'] != "") {
                            $other_checks['closed_to_date'] = date('Y-m-d', strtotime($post['aqutodate']));
                        }
                    }
                }
            }
            if ($this->session->userdata('user_role_id') == "Customer") {
                $userid = 0;
            }

            if (!empty($custid)) {
                if ($this->session->userdata('sub_cust') !== false) {
                    $subcusts = $this->session->userdata('sub_cust');
                    if (!empty($subcusts)) {
                        array_push($subcusts, $custid);
                    } else {
                        $subcusts = [
                            $custid
                        ];
                    }
                } else {
                    $subcusts = [
                        $custid
                    ];
                }
            }

            $general_array = [
                'userid' => $userid,
                'custid' => $custid,
                'business_type' => $business_type,
                'country_userids' => $country_userids,
                'subcusts' => $subcusts,
                'company_code' => $company_code
            ];

            $orderdata = $this->aquaticamodel->getorderdata($whr, $wherein, $other_checks, $general_array);
            //echo "<pre>";print_r($orderdata);exit;

            /*   log_message("error","order query".$this->db->last_query()); */

            if (!empty($orderdata)) {
                foreach ($orderdata as $res) {
                    if (isset($res['cargo_content'])) {
                        $tempContentArray = explode('?????', $res['cargo_content']);
                        $tempContentArray = array_unique($tempContentArray);
                        $res['cargo_content'] = implode(',', $tempContentArray);
                    } else {
                        $res['cargo_content'] = '';
                    }


                    $out = strlen($res['cargo_content']) > 10 ? substr($res['cargo_content'], 0, 5) . "..." : $res['cargo_content'];
                    $title = $res['cargo_content'];
                    $cargo_content = $out;
                    $cargo_content = rtrim($cargo_content, ',');

                    // echo $cargo_content;exit;

                    $title = rtrim($title, ',');
                    $cargo_content_arr = explode(',', $cargo_content);
                    $array_tmp = $array_new = [];
                    foreach ($cargo_content_arr as $k => $v) {
                        $index = $v;
                        $array_tmp[$index][] = $v;
                    }
                    foreach ($array_tmp as $k => $v) {
                        if (count($v) > 1) {
                            foreach ($v as $k2 => $v2) {
                                $array_new[] = $v2;
                            }
                        }
                    }
                    if (count($array_new)) {
                        $get_cargo_content = $array_new[0];
                        if (in_array($get_cargo_content, $cargo_content_arr)) {
                            $key_value = array_search($get_cargo_content, $cargo_content_arr);
                            unset($cargo_content_arr[$key_value]);
                        }
                    }
                    $final_cargo_content_str = implode(',', $cargo_content_arr);


                    if($business_type != 'Customer' || !checkAccessConditions('DISPLAY_CARRIER_NAME_IN_REPORTS', $this->session->userdata('company_code'))) {
                        if (isset($res['vendor_name'])) {
                            $carrier_name = $res['vendor_name'];
                        } else {
                            $carrier_name = '';
                        }
                    }

                    $curtz = $this->session->userdata("usr_tzone")['timezone'];
                    $pickupdate = $gateout = $transit = $accepted = $order_cdate = $delivered_time = $manifestdated = $scanned_date = "";
                    if ($this->session->userdata('company_code') == "AUKN" && ($this->session->userdata('user_role_id') == '2' || $this->session->userdata('user_role_id') == '1')) {
                        $order_cdate = $res['createdon'];
                        if ($order_cdate != "" && $order_cdate != "0000-00-00 00:00:00" && $order_cdate != "0") {
                            $ocreatedon = getdatetimebytimezone($curtz, $order_cdate, DFLT_TZ);
                            $order_cdate = date('Y-m-d h:i A', strtotime($ocreatedon['datetime']));
                        }
                        $scanned_date = $res['scanned_date'];
                        if ($scanned_date != "" && $scanned_date != "0000-00-00 00:00:00" && $scanned_date != "0") {
                            $scanneddate = getdatetimebytimezone($curtz, $scanned_date, DFLT_TZ);
                            $scanned_date = date('Y-m-d h:i A', strtotime($scanneddate['datetime']));
                        }
                        $manifestdated = $res['manifestdated'];
                        if ($manifestdated != "" && $manifestdated != "0000-00-00 00:00:00" && $manifestdated != "0") {
                            $mdate = getdatetimebytimezone($curtz, $manifestdated, DFLT_TZ);
                            $manifestdated = date('Y-m-d h:i A', strtotime($mdate['datetime']));
                        }
                        $accepted = $res['accepted'];
                        if ($accepted != "" && $accepted != "0000-00-00 00:00:00" && $accepted != "0") {
                            $acceptdate = getdatetimebytimezone($curtz, $accepted, DFLT_TZ);
                            $accepted = date('Y-m-d h:i A', strtotime($acceptdate['datetime']));
                        }
                        $transit = $res['transit'];
                        if ($transit != "" && $transit != "0000-00-00 00:00:00" && $transit != "0") {
                            $transitdate = getdatetimebytimezone($curtz, $transit, DFLT_TZ);
                            $transit = date('Y-m-d h:i A', strtotime($transitdate['datetime']));
                        }
                        $gateout = $res['gateout'];
                        if ($gateout != "" && $gateout != "0000-00-00 00:00:00" && $gateout != "0") {
                            $gateoutdate = getdatetimebytimezone($curtz, $gateout, DFLT_TZ);
                            $gateout = date('Y-m-d h:i A', strtotime($gateoutdate['datetime']));
                        }
                        $pickupdate = $res['pickupdate'];
                        if ($pickupdate != "" && $pickupdate != "0000-00-00 00:00:00" && $pickupdate != "0") {
                            $pdate = getdatetimebytimezone($curtz, $pickupdate, DFLT_TZ);
                            $pickupdate = date('Y-m-d h:i A', strtotime($pdate['datetime']));
                        }
                        $delivered_time = $res['delivered_time'];
                        if ($delivered_time != "" && $delivered_time != "0000-00-00 00:00:00" && $delivered_time != "0") {
                            $deliverydate = getdatetimebytimezone($curtz, $delivered_time, DFLT_TZ);
                            $delivered_time = date('Y-m-d h:i A', strtotime($deliverydate['datetime']));
                        }

                        if ($accepted != "" && $delivered_time != "") {
                            if ($accepted > $delivered_time) {
                                $pickup_datetime = $res['pickup_datetime'];
                                if ($pickup_datetime != "" && $pickup_datetime != "0000-00-00 00:00:00" && $pickup_datetime != "0") {
                                    $paccept = getdatetimebytimezone($curtz, $pickup_datetime, DFLT_TZ);
                                    $pdatetime = date('Y-m-d H:i:s', strtotime($paccept['datetime']));
                                    $accepted = date('Y-m-d h:i:A', strtotime('+1 hour', strtotime($pdatetime)));
                                }
                            }
                        }
                    }
                    if ($this->session->userdata('company_code') == "INKN") {
                        $order_cdate = $res['createdon'];
                        if ($order_cdate != "" && $order_cdate != "0000-00-00 00:00:00" && $order_cdate != "0") {
                            $ocreatedon = getdatetimebytimezone($curtz, $order_cdate, DFLT_TZ);
                            $order_cdate = date('Y-m-d h:i A', strtotime($ocreatedon['datetime']));
                        }
                        $scanned_date = $res['scanned_date'];
                        if ($scanned_date != "" && $scanned_date != "0000-00-00 00:00:00" && $scanned_date != "0") {
                            $scanneddate = getdatetimebytimezone($curtz, $scanned_date, DFLT_TZ);
                            $scanned_date = date('Y-m-d h:i A', strtotime($scanneddate['datetime']));
                        }
                        $manifestdated = $res['manifestdated'];
                        if ($manifestdated != "" && $manifestdated != "0000-00-00 00:00:00" && $manifestdated != "0") {
                            $mdate = getdatetimebytimezone($curtz, $manifestdated, DFLT_TZ);
                            $manifestdated = date('Y-m-d h:i A', strtotime($mdate['datetime']));
                        }
                        $accepted = $res['accepted'];
                        if ($accepted != "" && $accepted != "0000-00-00 00:00:00" && $accepted != "0") {
                            $acceptdate = getdatetimebytimezone($curtz, $accepted, DFLT_TZ);
                            $accepted = date('Y-m-d h:i A', strtotime($acceptdate['datetime']));
                        }
                        $transit = $res['transit'];
                        if ($transit != "" && $transit != "0000-00-00 00:00:00" && $transit != "0") {
                            $transitdate = getdatetimebytimezone($curtz, $transit, DFLT_TZ);
                            $transit = date('Y-m-d h:i A', strtotime($transitdate['datetime']));
                        }
                        $gateout = $res['gateout'];
                        if ($gateout != "" && $gateout != "0000-00-00 00:00:00" && $gateout != "0") {
                            $gateoutdate = getdatetimebytimezone($curtz, $gateout, DFLT_TZ);
                            $gateout = date('Y-m-d h:i A', strtotime($gateoutdate['datetime']));
                        }
                        $pickupdate = $res['pickupdate'];
                        if ($pickupdate != "" && $pickupdate != "0000-00-00 00:00:00" && $pickupdate != "0") {
                            $pdate = getdatetimebytimezone($curtz, $pickupdate, DFLT_TZ);
                            $pickupdate = date('Y-m-d h:i A', strtotime($pdate['datetime']));
                        }
                        $delivered_time = $res['delivered_time'];
                        if ($delivered_time != "" && $delivered_time != "0000-00-00 00:00:00" && $delivered_time != "0") {
                            $deliverydate = getdatetimebytimezone($curtz, $delivered_time, DFLT_TZ);
                            $delivered_time = date('Y-m-d h:i A', strtotime($deliverydate['datetime']));
                        }

                        if ($accepted != "" && $delivered_time != "") {
                            if ($accepted > $delivered_time) {
                                $pickup_datetime = $res['pickup_datetime'];
                                if ($pickup_datetime != "" && $pickup_datetime != "0000-00-00 00:00:00" && $pickup_datetime != "0") {
                                    $paccept = getdatetimebytimezone($curtz, $pickup_datetime, DFLT_TZ);
                                    $pdatetime = date('Y-m-d H:i:s', strtotime($paccept['datetime']));
                                    $accepted = date('Y-m-d h:i:A', strtotime('+1 hour', strtotime($pdatetime)));
                                }
                            }
                        }
                    }

                    $imgpath = $receiver_name = "";
                    $pod_available = $res['pod_available'];
                    $receiver_name = $res['receiver_name'];
                    $imgpath = $res['imgpath'];
                    if ($pod_available != "" && $pod_available != "0000-00-00 00:00:00" && $pod_available != "0") {
                        $poddate = getdatetimebytimezone($curtz, $pod_available, DFLT_TZ);
                        $pod_available = date('Y-m-d h:i A', strtotime($poddate['datetime']));
                    }

                    $cust_reference_num = $lr_num = $delconsignee_date = $delivery_status = $container_num = $store_code = $load_plan_connote = '';
                    $referenceData = '';
                    if (isset($res['order_reference_value'])) {
                        $referenceData = $res['order_reference_value'];
                    }
                    // echo $referenceData="DQ ===== DQR857463?????PO ===== 6541287?????BN ===== 369852";
                    // $tempData="DQ ===== KN1599123842?????PO";

                    if ($referenceData != '') {
                        $arrayData = $this->formatReferenceParameters($referenceData);
                        if ($business_type == 'Customer') {
                            if (isset($arrayData['BN'])) {
                                $lr_num = $arrayData['BN'];
                            }
                        } else {
                            // admin
                            if (isset($arrayData['PO'])) {
                                $lr_num = $arrayData['PO'];
                            }
                        }
                        // customer reference number
                        if (isset($arrayData['DQ'])) {
                            $cust_reference_num = $arrayData['DQ'];
                        }
                        if (isset($arrayData['CTR'])) {
                            $container_num = $arrayData['CTR'];
                        }
                        if (isset($arrayData['COI'])) {
                            $store_code = $arrayData['COI'];
                        }
                        if (isset($arrayData['LPC'])) {
                            $load_plan_connote = $arrayData['LPC'];
                        }
                    }

                    /*
                     * // customer
                     * if ($business_type == 'Customer') {
                     * $lr_ref_no = $this->aquaticamodel->getreferenceorderdetails($res['id'], 'BN');
                     * } else {
                     * // admin
                     * $lr_ref_no = $this->aquaticamodel->getreferenceorderdetails($res['id'], 'PO');
                     * }
                     * if ($lr_ref_no->num_rows() > 0) {
                     * $lr_num = $lr_ref_no->row()->ref_value;
                     * //echo $lr_num;exit;
                     * }
                     * $cust_ref_no = $this->aquaticamodel->getreferenceorderdetails($res['id'], 'DQ');
                     * if ($cust_ref_no->num_rows() > 0) {
                     * $cust_reference_num = $cust_ref_no->row()->ref_value;
                     * }
                     */

                    /*
                     * $getpickupdateils = $this->aquaticamodel->getpickupshipdateils($res['order_id'], $status_id = 10);
                     * if ($getpickupdateils->num_rows() > 0) {
                     * $date = '0000-00-00 00:00:00';
                     * $createdon = $getpickupdateils->row()->createdon;
                     * // $pickup_date = getEDAofNZShipmentbyord($res['id']);
                     * // $pickup_date = $pickup_date['time'];
                     * $estimate_d_date = $getpickupdateils->row()->estimate_d_date;
                     *
                     * if (($createdon != $date) && ($createdon != null)) {
                     * $pickup_date = date("d M Y", strtotime($createdon));
                     * } else {
                     * $pickup_date = date("d M Y", strtotime($res['pickup_datetime']));
                     * }
                     * if (($estimate_d_date != $date) && ($estimate_d_date != null)) {
                     * $estimate_de_date = date("d M Y", strtotime($estimate_d_date));
                     * } else {
                     * $estimate_de_date = date("d M Y", strtotime($res['drop_endtime']));
                     * }
                     * } else {
                     * $pickup_date = date("d M Y", strtotime($res['pickup_datetime']));
                     * $estimate_de_date = date("d M Y", strtotime($res['drop_endtime']));
                     * }
                     */

                    $date = '0000-00-00 00:00:00';
                    if (isset($res['estimated_pickup_time'])) {
                        $createdon = $res['estimated_pickup_time'];
                    } else {
                        $createdon = '';
                    }

                    if (isset($res['estimate_d_date'])) {
                        $estimate_d_date = $res['estimate_d_date'];
                    } else {
                        $estimate_d_date = '';
                    }
                    /* log_message('error','estimate_d_date ::'.$estimate_d_date.' createdon::'.$createdon.'-------------------------------------->');


                    log_message('error','pickup_datetime ::'.$res['pickup_datetime'].' drop_endtime::'.$res['drop_endtime'].'-------------------------------------->');
 */
                    if ($createdon != '' || $estimate_d_date != '') {
                        if (($createdon != $date) && ($createdon != null)) {
                            $pickup_date = date("d M Y", strtotime($createdon));
                        } else {
                            $pickup_date = date("d M Y", strtotime($res['pickup_datetime']));
                        }

                        if (($estimate_d_date != $date) && ($estimate_d_date != null)) {
                            $estimate_de_date = date("d M Y", strtotime($estimate_d_date));
                        } else {
                            $estimate_de_date = date("d M Y", strtotime($res['drop_endtime']));
                        }
                    } else {
                        $pickup_date = date("d M Y", strtotime($res['pickup_datetime']));
                        $estimate_de_date = date("d M Y", strtotime($res['drop_endtime']));
                    }

                    /*  log_message('error','pickup_datetime ::'.$pickup_date.' drop_endtime::'.$estimate_de_date.'-------------------------------------->'); */

                    if ($company_code == "AUKN") {
                        $pickup_date = date("d M Y", strtotime($res['pickup_datetime']));
                        $estimate_de_date = date("d M Y", strtotime($res['delivery_datetime']));
                    }

                    $get_laststatusinfo = $this->aquaticamodel->getlaststoptransdetails($res['order_id'], $res['shift_id']);
                    /* log_message('error',"delivery date:->".$this->db->last_query()); */
                    $last_status_name = $last_loc = $delivery_date = "";
                    $delivery_status = "Not Delivered";
                    if ((!empty($res['shift_id'])) && ($get_laststatusinfo->num_rows() > 0)) {
                        $last_status_name = $get_laststatusinfo->row()->status_name;
                        if ($get_laststatusinfo->row()->id == 1) {
                            if ($get_laststatusinfo->row()->stop_type == "P") {
                                $last_status_name = "Pickedup";
                            } else {
                                $last_status_name = "Delivered";
                            }
                        }

                        $status_code = $get_laststatusinfo->row()->status_code;
                        $stop_type = $get_laststatusinfo->row()->stop_type;
                        $status_id = $get_laststatusinfo->row()->status_id;

                        if ($status_code == '3000' && $stop_type == 'D') {
                            if (checkAccessConditions('RELATED_2_AU_IN', $company_code)) {
                                $last_status_name = "Delivered";
                            }
                            $date = '0000-00-00 00:00:00';
                            $d_time = getEDAofNZShipmentbyord($res['id']);
                            $d_date = $d_time['time'];
                            $delivery_status = "Delivered";
                            if (isset($d_date) && $d_date != "") {
                                if (($d_date != $date) || (strtotime($d_date) > 0)) {
                                    $delivery_date = date("d M Y", strtotime($d_date));
                                } else {
                                    $delivery_date = "";
                                }
                            }
                            if ($company_code == "AUKN" && empty($delivery_date || $company_code == 'INKN')) {
                                $d_createdon = $get_laststatusinfo->row()->createdon;
                                if (isset($d_createdon) && !empty($d_createdon)) {
                                    if (($d_createdon != $date) || (strtotime($d_createdon) > 0)) {
                                        $d_d_date = getdatetimebytimezone($curtz, $d_createdon, DFLT_TZ);
                                        $d_createdon = $d_d_date['datetime'];
                                        $delivery_date = date("d M Y", strtotime($d_createdon));
                                    } else {
                                        $delivery_date = "";
                                    }
                                }
                            }
                        }

                        if ($get_laststatusinfo->row()->loc_name != null) {
                            $last_loc = $get_laststatusinfo->row()->loc_name;
                        } else {
                            $lat = $get_laststatusinfo->row()->latitude;
                            $lng = $get_laststatusinfo->row()->longitude;
                            $last_loc = getLocationName($lat, $lng);
                        }
                    }

                    $trip_id = $res['trip_id'];

                    $trip_sts = $res['trip_sts'];

                    $shift_id = $res['shift_id'];

                    /* get epods for order_id */
                    $epods = "";
                    /*
                     * $epod_doc = $this->aquaticamodel->getEpodDoc($res['id'], $shift_id);
                     *
                     * if (count($epod_doc) > 0) {
                     * $i = 1;
                     * foreach ($epod_doc as $epd) {
                     * if (file_exists("assets/poduploads/" . $epd['imgpath'])) {
                     * $link = base_url() . "assets/poduploads/" . $epd['imgpath'];
                     * $epods .= $link . ' ; ';
                     * }
                     * $i ++;
                     * }
                     * }
                     */
                    /* get container number */
                    // $container_num = $this->getrefnum($res['id'], "CTR");
                    /* get ASN reference order number */
                    $ref_order_num = '';
                    if ($this->session->userdata('company_code') == "AUKN") {
                        $ref_order_num = $this->getrefordernum($res['id']);
                        $load_plan_connote = $this->getloadplanconnote($res['id']);
                    }
                    /* get Store code */
                    // $store_code = $this->getrefnum($res['id'], "COI");

                    $carrierservice = "";
                    if ($company_code == "AUKN") {
                        $this->load->helper('border_helper');
                        $vendor_res = checkborderCarrier($res['vendor_id']);
                        if (!empty($vendor_res)) {
                            if ($res['totqty'] < 20) {
                                $carrierservice = "BORDER PALLETS";
                            } else {
                                $carrierservice = "BORDER BULK";
                            }
                        }
                    }

                    $service_type = (!empty($res['num_of_pallets'])) ? "PALLETS" : "CARTONS";

                    if ($company_code == "INKN") {
                        $carrierservice = $service_type;
                    }
                    // $epods = rtrim($epods, " ; ");
                    $aquorder[] = [
                        'order_row_id' => $res['id'],
                        'order_id' => $res['order_id'],
                        'pieces' => $res['totqty'],
                        'weight' => $res['totwg'],
                        'volumetric_weight' => $res['volumetric_weight'],
                        'volume' => $res['totvolume'],
                        'consignment_note' => $res['consignment_note'],
                        'container_num' => $container_num,
                        'ref_order_num' => $ref_order_num,
                        'scanned_quantity' => $res['scanned_quantity'],
                        'goods_desc' => $final_cargo_content_str,
                        'pickup' => $res['pickup'],
                        'delivery' => $res['delivery'],
                        'carriername' => $carrier_name,
                        'shipper_address' => $res['pickup'],
                        'shipper_city' => $res['pickup_city'],
                        'consignee_address' => $res['delivery'],
                        'consignee_city' => $res['delivery_city'],
                        'shipper_state' => $res['shipper_state'],
                        'consignee_state' => $res['consignee_state'],
                        'delivery_pincode' => $res['delivery_pincode'],
                        'pickup_date' => $pickup_date,
                        'estimate_d_date' => $estimate_de_date,
                        'delivery_date' => $delivery_date,
                        'cust_reference_num' => $cust_reference_num,
                        'lr_num' => $lr_num,
                        'goods_value' => $res['goods_value'],
                        'transport_mode' => $res['transport_mode'],
                        'delivery_status' => $delivery_status,
                        'last_status_name' => $last_status_name,
                        'last_loc' => $last_loc,
                        'title' => $title,
                        'epod' => $epods,
                        'store_code' => $store_code,
                        'service_type' => $carrierservice,
                        'pickupdate' => $pickupdate,
                        'gateout' => $gateout,
                        'transit' => $transit,
                        'accepted' => $accepted,
                        'order_cdate' => $order_cdate,
                        'deliver_toconsignee' => $delivered_time,
                        'load_plan_connote' => $load_plan_connote,
                        'scanned_date' => $scanned_date,
                        'manifestdated' => $manifestdated,
                        'imgpath' => $imgpath,
                        'pod_available' => $pod_available,
                        'receiver_name' => $receiver_name,
                        'customer_name' => $res['customer_name'] . "(" . $res['customer_code'] . ")",

                    ];
                }
            }
        }
        $data['australiaCarrierNameCondition'] = checkAccessConditions('RELATED_2_AUKN_KNAU', $company_code);
        $data['company_code'] = $this->session->userdata('company_code');
        $data['aquorder'] = $aquorder;
        $data['company_code'] = $this->session->userdata('company_code');
        // print_r($data['aquorder']);die();
        /* log_message("error","aquorder".json_encode($aquorder)); */
        $this->newtemplate->dashboard("reportshipment/index", $data);
    }

    public function formatReferenceParameters($refData)
    {
        $finalReqArray = [];
        $referenceDataArray = explode('?????', $refData);
        if (!empty($referenceDataArray) && sizeof($referenceDataArray) > 0) {
            foreach ($referenceDataArray as $eachRefData) {
                $reqArray = $this->giveReferenceParameters($eachRefData);
                $key = $reqArray['type'];
                $value = $reqArray['value'];
                $finalReqArray[$key] = $value;
            }
        }
        return $finalReqArray;
    }

    public function giveReferenceParameters($referenceParam)
    {
        $finalArray = [];
        if (!empty($referenceParam) && $referenceParam != '') {
            $requiredArray = explode('=====', $referenceParam);
            if (!empty($requiredArray) && sizeof($requiredArray) > 0) {
                $finalArray['type'] = trim($requiredArray[0]);
                $finalArray['value'] = trim($requiredArray[1]);
            }
        }
        return $finalArray;
    }

    /**
     * get reference number
     * @deprecated
    */
    private function getrefnum($id, $ref_id)
    {
        $ref_num = "";
        $res = $this->common->gettblrowdata([
            'order_id' => $id,
            'reference_id' => $ref_id,
            'status' => 1
        ], 'ref_value', 'tb_order_references', 0, 0);
        if (!empty($res)) {
            $ref_num = (!empty($res['ref_value'])) ? $res['ref_value'] : "";
        }
        return $ref_num;
    }

    /* get ASN reference order number */
    public function getrefordernum($id)
    {
        $ref_order_num = "";
        $whr = [
            'c.order_id' => $id,
            'i.status' => 1,
            'c.status' => 1
        ];
        $res = $this->aquaticamodel->getaurefnums($whr);
        /*
         * $this->common->gettbldata(array('order_id'=>$id,'status'=>1),'reference_order_num','tb_order_cargodetails',0,0);
         * log_message('error',$this->db->last_query());
         */
        if (!empty($res)) {
            $res = array_column($res, 'ref_order_num');
            $res = array_unique($res);
            $ref_ordernum = implode(" , ", $res);
            $ref_order_num = (!empty($ref_ordernum)) ? $ref_ordernum : "";
        }
        return $ref_order_num;
    }

    public function getloadplanconnote($id)
    {
        $load_plan_connote = "";
        $whr = [
            'r.order_id' => $id,
            'r.reference_id' => 'LPC',
            'r.status' => 1
        ];
        $res = $this->aquaticamodel->getauloadplanconnote($whr);
        /*
         * $this->common->gettbldata(array('order_id'=>$id,'status'=>1),'reference_order_num','tb_order_cargodetails',0,0);
         * log_message('error',$this->db->last_query());
         */
        if (!empty($res)) {
            $res = array_column($res, 'ref_value');
            $res = array_unique($res);
            $load_plan_connote = implode(" , ", $res);
            $load_plan_connote = (!empty($load_plan_connote)) ? $load_plan_connote : "";
        }
        return $load_plan_connote;
    }


    public function searchorders($post)
    {
        $whr = [];
        $status_search = isset($post['aquordtype']) ? $post['aquordtype'] : "";
        if ($status_search == 'MANIFESTED') {
            if (isset($post['aqufromdate']) && $post['aqufromdate'] != "") {
                $aqufromdate = date('Y-m-d', strtotime($post['aqufromdate']));
                $whr["DATE_FORMAT(o.pickup_datetime,'%Y-%m-%d') >="] = $aqufromdate;
            }
            if (isset($post['aqutodate']) && $post['aqutodate'] != "") {
                $todate = date('Y-m-d', strtotime($post['aqutodate']));
                $whr["DATE_FORMAT(o.pickup_datetime,'%Y-%m-%d') <="] = $todate;
            }

            if (isset($post['booking_id']) && $post['booking_id'] != "") {
                $whr['o.order_id'] = $post['booking_id'];
            }
        } else {
            if (($status_search == "CLOSED") && ($this->session->userdata('company_code') == 'AUKN')) {
                if (isset($post['booking_id']) && $post['booking_id'] != "") {
                    $whr['o.order_id'] = $post['booking_id'];
                }
            } else {
                if (isset($post['aqufromdate']) && $post['aqufromdate'] != "") {
                    $aqufromdate = date('Y-m-d', strtotime($post['aqufromdate']));
                    $whr["DATE_FORMAT(o.createdon,'%Y-%m-%d') >="] = $aqufromdate;
                }
                if (isset($post['aqutodate']) && $post['aqutodate'] != "") {
                    $todate = date('Y-m-d', strtotime($post['aqutodate']));
                    $whr["DATE_FORMAT(o.createdon,'%Y-%m-%d') <="] = $todate;
                }

                if (isset($post['booking_id']) && $post['booking_id'] != "") {
                    $whr['o.order_id'] = $post['booking_id'];
                }
            }
        }
        return $whr;
    }

    public function getbookingid()
    {
        $uid = $this->session->userdata('user_id');
        $custid = "";
        $country_userids = [];
        if (!empty($this->session->userdata("country_user_ids")) && ($this->session->userdata("country_user_ids") != null) && (count($this->session->userdata("country_user_ids")) > 0)) {
            $country_userids = $this->session->userdata("country_user_ids");
        }
        $business_type = $this->session->userdata('business_type');
        if (!empty($this->session->userdata("cust_id"))) {
            $custid = $this->session->userdata("cust_id");
        }
        /*  log_message("error","getbookingid ".json_encode($_REQUEST));
          log_message("error","getbookingid-post ".json_encode($_POST));*/
        $booking_id = isset($_POST["booking_id"]) ? $_POST["booking_id"] : "";
        $booking_id = trim($booking_id);
        $data = $subcusts = [];

        if (!empty($custid)) {
            if ($this->session->userdata('sub_cust') !== false) {
                $subcusts = $this->session->userdata('sub_cust');
                if (count($subcusts) > 0) {
                    array_push($subcusts, $custid);
                } else {
                    $subcusts = [
                        $custid
                    ];
                }
            } else {
                $subcusts = [
                    $custid
                ];
            }
        }

        if ($custid || !empty($subcusts)) {
            $get_data = $this->db->query(
                "SELECT order_id
                    FROM tb_orders
                    WHERE order_id LIKE ?
                    AND customer_id IN ?
                    AND status > ?",
                ['%' . $booking_id . '%', !empty($subcusts) ? $subcusts : [$custid], '0']
            );
        } else {
            $get_data = $this->db->query(
                "SELECT order_id
                    FROM tb_orders
                    WHERE order_id LIKE ?
                    AND status > ?",
                ['%' . $booking_id . '%', '0']
            );
        }

        if ($get_data->num_rows() > 0) {
            foreach ($get_data->result() as $get_data_f) {
                $data[] = $get_data_f->order_id;
            }
        }
        echo json_encode($data);
    }

    public function getrefdetails()
    {
        $uid = $this->session->userdata('user_id');
        $custid = "";
        $country_userids = [];
        if (!empty($this->session->userdata("country_user_ids")) && ($this->session->userdata("country_user_ids") != null) && (count($this->session->userdata("country_user_ids")) > 0)) {
            $country_userids = $this->session->userdata("country_user_ids");
        }
        if (!empty($this->session->userdata("cust_id"))) {
            $custid = $this->session->userdata("cust_id");
        }
        $business_type = $this->session->userdata('business_type');
        $lr_number = isset($_POST["lr_number"]) ? $_POST["lr_number"] : "";
        $lr_numer = trim($lr_number);
        $customer_reference_number = isset($_POST["customer_reference_number"]) ? $_POST["customer_reference_number"] : "";
        $customer_reference_number = trim($customer_reference_number);
        $data = $subcusts = [];
        $like = "";

        if ($business_type == "Customer") {
            $uid = 0;
        }

        $referenceIdCondition = '';
        if ($lr_number) {
            $like = $lr_number;
            // customer
            if ($business_type == "Customer") {
                $referenceIdCondition = 'BN';
            } else {
                // admin
                $referenceIdCondition = 'PO';
            }
        }
        if ($customer_reference_number) {
            $like = $customer_reference_number;
            $referenceIdCondition = 'DQ';
        }

        $userIdCondition = $uid != '0'
            ? (!empty($country_userids) ? $country_userids : [$uid])
            : [];

        if (!empty($custid)) {
            if ($this->session->userdata('sub_cust') !== false) {
                $subcusts = $this->session->userdata('sub_cust');
                if (count($subcusts) > 0) {
                    array_push($subcusts, $custid);
                } else {
                    $subcusts = [
                        $custid
                    ];
                }
            } else {
                $subcusts = [
                    $custid
                ];
            }
        }

        $this->db->select('r.ref_value')
            ->from('tb_order_references r, tb_orders o')
            ->like('r.ref_value', $like)
            ->where('r.status', 1)
            ->where('o.status !=', 0)
            ->where('r.order_id = o.id');
        if ($referenceIdCondition) {
            $this->where('reference_id', $referenceIdCondition);
        }
        if ($custid || !empty($subcusts)) {
            $this->db->whereIn('customer_id', !empty($subcusts) ? $subcusts : [$custid]);
        }
        if (!empty($userIdCondition)) {
            $this->db->whereIn('user_id', $userIdCondition);
        }
        $get_data = $this->db->get();

        if ($get_data->num_rows() > 0) {
            foreach ($get_data->result() as $get_data_f) {
                $data[] = $get_data_f->ref_value;
            }
        }
        echo json_encode($data);
    }

    public function orddocsdetails()
    {
        $ord = $this->input->post("order_id", true);
        $ordid = $this->input->post("id", true);
        $data['ord_type'] = "done";
        $tripinfo = $this->common->gettblrowdata([
            "id" => $ordid
        ], "id,order_id,company_code,branch_code,shift_id,trip_id", "tb_orders", 0, 0);
        if (!empty($tripinfo)) {
            $curtz = $this->session->userdata("usr_tzone")['timezone'];
            $data['ord_type'] = $this->input->post("type", true);
            $data['ship_id'] = $tripinfo['shift_id'] ?? 0;
            $data['trip_id'] = $tripinfo['trip_id'] ?? 0;


            $this->db->select(
                "ts.id,ts.latitude,ts.longitude,ts.stop_id,ts.stop_type, dt.type_name,ts.createdby,
                convertToClientTZ(ts.createdon, '" . $curtz . "') as createdon,ts.imgpath"
            )
                ->from('tb_pod_uploads ts')
                ->join('tb_document_types dt', 'dt.id=ts.doc_type', 'LEFT')
                ->where('ts.status', '1')
                ->group_start()
                ->where('dt.type_name', 'POD')
                ->or_where('dt.type_name', 'Signature')
                ->group_end();
                $this->db->where('ts.order_id', $ordid);
                $this->db->group_by('ts.id');

            $sql = $this->db->get();
            if ($sql->num_rows() > 0) {
                $i = 1;
                foreach ($sql->result_array() as $eachRow) {
                    $base64DocumentData = getBase64DocumentData($eachRow['imgpath']);
                    $pods[] = [
                        'sno' => $i,
                        'location' => @getLocationName($eachRow['latitude'], $eachRow['longitude']),
                        'type_name' => $eachRow['type_name'],
                        'driver_name' => @getDrivernameById($eachRow['createdby'])["name"],
                        'stop_id' => $eachRow['stop_id'],
                        'stop_type' => $eachRow['stop_type'],
                        'createdon' => date("d M,y h:i A", strtotime($eachRow['createdon'])),
                        'extention' => $base64DocumentData['extention'],
                        'file_content' => $base64DocumentData['file_content'],
                    ];
                    $i++;
                }
            }
            $data["pods"] = $pods ?? [];

            echo $this->load->view("reportshipment/managedocuments", $data, true);
        }
    }

    public function export_excel()
    {
        ini_set("memory_limit", "256M");
        $data['page_title'] = 'Basicshipmentreport';
        $data['sub_title'] = 'Reports';
        $business_type = $this->session->userdata('business_type');
        //echo "<pre>";print_r($this->input->post());exit;
        $inputdt = $this->input->post(null, true);
        if ($business_type == 'Carrier') {
            redirect('/');
        }

        $custid = $status_search = "";

        $userid = $this->session->userdata("user_id");
        if (!empty($this->session->userdata("cust_id"))) {
            $custid = $this->session->userdata("cust_id");
        }

        $aquorder = $country_userids = $subcusts = $general_array = $other_checks = $post_array = $whr = $wherein = [];

        if (!empty($this->session->userdata("country_user_ids")) && ($this->session->userdata("country_user_ids") != null) && (count($this->session->userdata("country_user_ids")) > 0)) {
            $country_userids = $this->session->userdata("country_user_ids");
        }

        if ($business_type == "Customer") {
            $userid = 0;
        }

        if (!empty($custid)) {
            if ($this->session->userdata('sub_cust') !== false) {
                $subcusts = $this->session->userdata('sub_cust');
                if (count($subcusts) > 0) {
                    array_push($subcusts, $custid);
                } else {
                    $subcusts = [
                        $custid
                    ];
                }
            } else {
                $subcusts = [
                    $custid
                ];
            }
        };
        $general_array = [
            'userid' => $userid,
            'custid' => $custid,
            'business_type' => $business_type,
            'country_userids' => $country_userids,
            'subcusts' => $subcusts
        ];
        //echo count(array_filter($inputdt));exit;
        if (count(array_filter($inputdt)) > 0) {
            if (isset($inputdt['fromDatesearch']) && !empty($inputdt['fromDatesearch'])) {
                $post_array['aqufromdate'] = $inputdt['fromDatesearch'];
            }

            if (isset($inputdt['toDatesearch']) && !empty($inputdt['toDatesearch'])) {
                $post_array['aqutodate'] = $inputdt['toDatesearch'];
            }

            if (isset($inputdt['booking_idSearch']) && !empty($inputdt['booking_idSearch'])) {
                $post_array['booking_id'] = $inputdt['booking_idSearch'];
            }

            $order_status = isset($inputdt['selectstatusSearch']) ? $inputdt['selectstatusSearch'] : "";
            $ad_orderstatus = isset($inputdt['advstatusSearch']) ? $inputdt['advstatusSearch'] : "";
            if (isset($inputdt['carrieridSearch']) && $inputdt['carrieridSearch'] != '') {
                $wherein['vendor_id'] = explode(',', $inputdt['carrieridSearch']);
            }

            if (isset($inputdt['advcarrieridSearch']) && $inputdt['advcarrieridSearch'] != "") {
                $wherein['vendor_id'] = explode(',', $inputdt['advcarrieridSearch']);
            }

            if (!empty($order_status)) {
                $status_search = $order_status;
            }

            if (!empty($ad_orderstatus)) {
                $status_search = $ad_orderstatus;
            }

            $other_checks['status_search'] = $status_search;

            if (isset($inputdt['shipper_name_Search']) && $inputdt['shipper_name_Search'] != "") {
                $other_checks['shipper_name'] = $inputdt['shipper_name_Search'];
            }

            if (isset($inputdt['consignee_name_Search']) && $inputdt['consignee_name_Search'] != "") {
                $other_checks['consignee_name'] = $inputdt['consignee_name_Search'];
            }

            if (isset($inputdt['lr_numberSearch']) && $inputdt['lr_numberSearch'] != "") {
                $other_checks['lr_number'] = $inputdt['lr_numberSearch'];
            }

            if (isset($inputdt['cust_refSearch']) && $inputdt['cust_refSearch'] != "") {
                $other_checks['customer_reference_number'] = $inputdt['cust_refSearch'];
            }

            if (isset($inputdt['pickupdate_Search']) && $inputdt['pickupdate_Search'] != "") {
                $other_checks['qbook_pickupdatetime'] = $inputdt['pickupdate_Search'];
            }
            $whr = $this->searchorders($post_array);

            $orderdata = $this->aquaticamodel->getorderdata($whr, $wherein, $other_checks, $general_array);
            //echo "<pre>";print_r($orderdata);exit;

            if (!empty($orderdata)) {
                foreach ($orderdata as $res) {
                    if (isset($res['cargo_content'])) {
                        $tempContentArray = explode('?????', $res['cargo_content']);
                        $tempContentArray = array_unique($tempContentArray);
                        $res['cargo_content'] = implode(',', $tempContentArray);
                    } else {
                        $res['cargo_content'] = '';
                    }


                    $out = strlen($res['cargo_content']) > 10 ? substr($res['cargo_content'], 0, 5) . "..." : $res['cargo_content'];
                    $title = $res['cargo_content'];
                    $cargo_content = $out;
                    $cargo_content = rtrim($cargo_content, ',');

                    // echo $cargo_content;exit;

                    $title = rtrim($title, ',');
                    $cargo_content_arr = explode(',', $cargo_content);
                    $array_tmp = $array_new = [];
                    foreach ($cargo_content_arr as $k => $v) {
                        $index = $v;
                        $array_tmp[$index][] = $v;
                    }
                    foreach ($array_tmp as $k => $v) {
                        if (count($v) > 1) {
                            foreach ($v as $k2 => $v2) {
                                $array_new[] = $v2;
                            }
                        }
                    }
                    if (count($array_new)) {
                        $get_cargo_content = $array_new[0];
                        if (in_array($get_cargo_content, $cargo_content_arr)) {
                            $key_value = array_search($get_cargo_content, $cargo_content_arr);
                            unset($cargo_content_arr[$key_value]);
                        }
                    }
                    $final_cargo_content_str = implode(',', $cargo_content_arr);


                    if($business_type != 'Customer' || !checkAccessConditions('DISPLAY_CARRIER_NAME_IN_REPORTS', $this->session->userdata('company_code'))) {
                        if (isset($res['vendor_name'])) {
                            $carrier_name = $res['vendor_name'];
                        } else {
                            $carrier_name = '';
                        }
                    }

                    $cust_reference_num = $lr_num = $delconsignee_date = $delivery_status = '';

                    $referenceData = '';
                    if (isset($res['order_reference_value'])) {
                        $referenceData = $res['order_reference_value'];
                    }
                    // echo $referenceData="DQ ===== DQR857463?????PO ===== 6541287?????BN ===== 369852";
                    // $tempData="DQ ===== KN1599123842?????PO";

                    if ($referenceData != '') {
                        $arrayData = $this->formatReferenceParameters($referenceData);
                        if ($business_type == 'Customer') {
                            if (isset($arrayData['BN'])) {
                                $lr_num = $arrayData['BN'];
                            }
                        } else {
                            // admin
                            if (isset($arrayData['PO'])) {
                                $lr_num = $arrayData['PO'];
                            }
                        }
                        // customer reference number
                        if (isset($arrayData['DQ'])) {
                            $cust_reference_num = $arrayData['DQ'];
                        }
                        if (isset($arrayData['CTR'])) {
                            $container_num = $arrayData['CTR'];
                        }
                        if (isset($arrayData['COI'])) {
                            $store_code = $arrayData['COI'];
                        }
                        if (isset($arrayData['LPC'])) {
                            $load_plan_connote = $arrayData['LPC'];
                        }
                    }


                    $date = '0000-00-00 00:00:00';
                    if (isset($res['estimated_pickup_time'])) {
                        $createdon = $res['estimated_pickup_time'];
                    } else {
                        $createdon = '';
                    }

                    if (isset($res['estimate_d_date'])) {
                        $estimate_d_date = $res['estimate_d_date'];
                    } else {
                        $estimate_d_date = '';
                    }

                    if ($createdon != '' || $estimate_d_date != '') {
                        if (($createdon != $date) && ($createdon != null)) {
                            $pickup_date = date("d M Y", strtotime($createdon));
                        } else {
                            $pickup_date = date("d M Y", strtotime($res['pickup_datetime']));
                        }

                        if (($estimate_d_date != $date) && ($estimate_d_date != null)) {
                            $estimate_de_date = date("d M Y", strtotime($estimate_d_date));
                        } else {
                            $estimate_de_date = date("d M Y", strtotime($res['drop_endtime']));
                        }
                    } else {
                        $pickup_date = date("d M Y", strtotime($res['pickup_datetime']));
                        $estimate_de_date = date("d M Y", strtotime($res['drop_endtime']));
                    }


                    $get_laststatusinfo = $this->aquaticamodel->getlaststoptransdetails($res['order_id'], $res['shift_id']);
                    $last_status_name = $last_loc = $delivery_date = "";
                    $delivery_status = "Not Delivered";
                    if ($get_laststatusinfo->num_rows() > 0) {
                        $last_status_name = $get_laststatusinfo->row()->status_name;
                        if ($get_laststatusinfo->row()->id == 1) {
                            if ($get_laststatusinfo->row()->stop_type == "P") {
                                $last_status_name = "Pickedup";
                            } else {
                                $last_status_name = "Delivered";
                            }
                        }

                        $status_code = $get_laststatusinfo->row()->status_code;
                        $stop_type = $get_laststatusinfo->row()->stop_type;
                        $status_id = $get_laststatusinfo->row()->status_id;
                        if ($status_id == '3' && $status_code == '3000' && $stop_type == 'D') {
                            $d_time = getEDAofNZShipmentbyord($res['id']);
                            $d_date = $d_time['time'];
                            $delivery_status = "Delivered";
                            if (isset($d_date) && $d_date != "") {
                                $date = '0000-00-00 00:00:00';
                                if (($d_date != $date) || (strtotime($d_date) > 0)) {
                                    $delivery_date = date("d M Y", strtotime($d_date));
                                } else {
                                    $delivery_date = "";
                                }
                            }
                        }

                        if ($get_laststatusinfo->row()->loc_name != null) {
                            $last_loc = $get_laststatusinfo->row()->loc_name;
                        } else {
                            $lat = $get_laststatusinfo->row()->latitude;
                            $lng = $get_laststatusinfo->row()->longitude;
                            $last_loc = getLocationName($lat, $lng);
                        }
                    }

                    $shift_id = $res['shift_id'];

                    /* get epods for order_id */

                    $epod_doc = $this->aquaticamodel->getEpodDoc($res['id'], $shift_id);
                    $epods = [];
                    if (count($epod_doc) > 0) {
                        $i = 1;
                        foreach ($epod_doc as $epd) {
                            // if(file_exists("assets/poduploads/".$epd['imgpath'])) {
                            $base_url = base_url();
                            if ($base_url == "https://elog360.app/svkonekt_test/") {
                                $base_url = "https://elog360.app/svkonekt_test/";
                            } else {
                                $base_url = "https://elog360.app/svkonekt_test/";
                            }
                            $link = $base_url . 'downloadEpod/safelink/'. $epd['hash']. '.epod';
                            $visible_name = "123";
                            $link1 = '=hyperlink("' . $link . '")';
                            $epods[] = $link1;
                            // }
                            $i++;
                        }
                    }

                    $aquorder[] = [
                        'order_row_id' => $res['id'],
                        'order_id' => $res['order_id'],
                        'pieces' => $res['totqty'],
                        'weight' => $res['totwg'],
                        'volumetric_weight' => $res['volumetric_weight'],
                        'goods_desc' => $final_cargo_content_str,
                        'pickup' => $res['pickup'],
                        'delivery' => $res['delivery'],
                        'carriername' => $carrier_name,
                        'shipper_address' => $res['pickup'],
                        'shipper_city' => $res['pickup_city'],
                        'consignee_address' => $res['delivery'],
                        'consignee_city' => $res['delivery_city'],
                        'pickup_date' => $pickup_date,
                        'estimate_d_date' => $estimate_de_date,
                        'delivery_date' => $delivery_date,
                        'cust_reference_num' => $cust_reference_num,
                        'lr_num' => $lr_num,
                        'goods_value' => $res['goods_value'],
                        'transport_mode' => $res['transport_mode'],
                        'delivery_status' => $delivery_status,
                        'last_status_name' => $last_status_name,
                        'last_loc' => $last_loc,
                        'title' => $title,
                        'epod' => $epods
                    ];

                    if ($business_type != 'Customer' || !checkAccessConditions('DISPLAY_CARRIER_NAME_IN_REPORTS', $this->session->userdata('company_code'))) {
                        unset($aquorder['carriername']);
                    }
                }
            }
        }
        /*
         * echo "<pre>";
         * //$query=$this->db->last_query();
         * //echo "hai:".$query
         * print_r($aquorder);
         * exit;
         */
        $styleArray = [
            'font' => [
                'bold' => true,
                'color' => [
                    'rgb' => 'FFFFFF'
                ],
                'size' => 10,
                'name' => 'Verdana'
            ]
        ];

        //ob_end_clean();
        $objPHPExcel = new PHPExcel();
        $objPHPExcel->setActiveSheetIndex(0);
        $objPHPExcel->getActiveSheet()
            ->getStyle('A1:AH1')
            ->applyFromArray([
                'fill' => [
                    'type' => PHPExcel_Style_Fill::FILL_SOLID,
                    'color' => [
                        'rgb' => '0c3b81'
                    ]
                ]
            ]);
        $objPHPExcel->getActiveSheet()->SetCellValue('A1', 'TrackingNo');
        $objPHPExcel->getActiveSheet()
            ->getStyle('A1')
            ->applyFromArray($styleArray);
        $objPHPExcel->getActiveSheet()->SetCellValue('B1', 'Cust RefNo');
        $objPHPExcel->getActiveSheet()
            ->getStyle('B1')
            ->applyFromArray($styleArray);
        $objPHPExcel->getActiveSheet()->SetCellValue('C1', 'LR Number');
        $objPHPExcel->getActiveSheet()
            ->getStyle('C1')
            ->applyFromArray($styleArray);
        $objPHPExcel->getActiveSheet()->SetCellValue('D1', 'Goods Value');
        $objPHPExcel->getActiveSheet()
            ->getStyle('D1')
            ->applyFromArray($styleArray);
        $objPHPExcel->getActiveSheet()->SetCellValue('E1', 'Mode Of Transport');
        $objPHPExcel->getActiveSheet()
            ->getStyle('E1')
            ->applyFromArray($styleArray);
        $objPHPExcel->getActiveSheet()->SetCellValue('F1', 'Shipper Name');
        $objPHPExcel->getActiveSheet()
            ->getStyle('F1')
            ->applyFromArray($styleArray);
        $objPHPExcel->getActiveSheet()->SetCellValue('G1', ' Shipper City');
        $objPHPExcel->getActiveSheet()
            ->getStyle('G1')
            ->applyFromArray($styleArray);
        $objPHPExcel->getActiveSheet()->SetCellValue('H1', 'Consignee Name');
        $objPHPExcel->getActiveSheet()
            ->getStyle('H1')
            ->applyFromArray($styleArray);
        $objPHPExcel->getActiveSheet()->SetCellValue('I1', 'Consignee City');
        $objPHPExcel->getActiveSheet()
            ->getStyle('I1')
            ->applyFromArray($styleArray);
        $objPHPExcel->getActiveSheet()->SetCellValue('J1', 'Goods Description');
        $objPHPExcel->getActiveSheet()
            ->getStyle('J1')
            ->applyFromArray($styleArray);
        $objPHPExcel->getActiveSheet()->SetCellValue('K1', 'Total Pkgs');
        $objPHPExcel->getActiveSheet()
            ->getStyle('K1')
            ->applyFromArray($styleArray);
        $objPHPExcel->getActiveSheet()->SetCellValue('L1', 'Weight(Kgs)');
        $objPHPExcel->getActiveSheet()
            ->getStyle('L1')
            ->applyFromArray($styleArray);
        $objPHPExcel->getActiveSheet()->SetCellValue('M1', ' Volumetric Weight');
        $objPHPExcel->getActiveSheet()
            ->getStyle('M1')
            ->applyFromArray($styleArray);

        if($business_type != 'Customer' || !checkAccessConditions('DISPLAY_CARRIER_NAME_IN_REPORTS', $this->session->userdata('company_code'))) {
            $objPHPExcel->getActiveSheet()->SetCellValue('N1', ' Vendor Name');
        }

        $objPHPExcel->getActiveSheet()
            ->getStyle('N1')
            ->applyFromArray($styleArray);
        $objPHPExcel->getActiveSheet()->SetCellValue('O1', ' Picked Up Date');
        $objPHPExcel->getActiveSheet()
            ->getStyle('O1')
            ->applyFromArray($styleArray);
        $objPHPExcel->getActiveSheet()->SetCellValue('P1', ' Estimated Delivery Date');
        $objPHPExcel->getActiveSheet()
            ->getStyle('P1')
            ->applyFromArray($styleArray);
        $objPHPExcel->getActiveSheet()->SetCellValue('Q1', ' Delivery Status');
        $objPHPExcel->getActiveSheet()
            ->getStyle('Q1')
            ->applyFromArray($styleArray);
        $objPHPExcel->getActiveSheet()->SetCellValue('R1', ' Delivery Date');
        $objPHPExcel->getActiveSheet()
            ->getStyle('R1')
            ->applyFromArray($styleArray);
        $objPHPExcel->getActiveSheet()->SetCellValue('S1', ' Last Status');
        $objPHPExcel->getActiveSheet()
            ->getStyle('S1')
            ->applyFromArray($styleArray);
        $objPHPExcel->getActiveSheet()->SetCellValue('T1', ' Last location');
        $objPHPExcel->getActiveSheet()
            ->getStyle('T1')
            ->applyFromArray($styleArray);
        $objPHPExcel->getActiveSheet()->SetCellValue('U1', 'Managedocuments');
        $objPHPExcel->getActiveSheet()
            ->getStyle('U1')
            ->applyFromArray($styleArray);
        $rowCount = 2;
        if (count($aquorder) > 0) {
            foreach ($aquorder as $order) {
                $objPHPExcel->getActiveSheet()->SetCellValue('A' . $rowCount, $order['order_id']);
                $objPHPExcel->getActiveSheet()->SetCellValue('B' . $rowCount, $order['cust_reference_num']);
                $objPHPExcel->getActiveSheet()->SetCellValue('C' . $rowCount, $order['lr_num']);
                $objPHPExcel->getActiveSheet()->SetCellValue('D' . $rowCount, $order['goods_value']);
                $objPHPExcel->getActiveSheet()->SetCellValue('E' . $rowCount, $order['transport_mode']);
                $objPHPExcel->getActiveSheet()->SetCellValue('F' . $rowCount, $order['shipper_address']);
                $objPHPExcel->getActiveSheet()->SetCellValue('G' . $rowCount, $order['shipper_city']);
                $objPHPExcel->getActiveSheet()->SetCellValue('H' . $rowCount, $order['consignee_address']);
                $objPHPExcel->getActiveSheet()->SetCellValue('I' . $rowCount, $order['consignee_city']);
                $objPHPExcel->getActiveSheet()->SetCellValue('J' . $rowCount, $order['goods_desc']);
                $objPHPExcel->getActiveSheet()->SetCellValue('K' . $rowCount, $order['pieces']);
                $objPHPExcel->getActiveSheet()->SetCellValue('L' . $rowCount, $order['weight']);
                $objPHPExcel->getActiveSheet()->SetCellValue('M' . $rowCount, $order['volumetric_weight']);

                if($business_type != 'Customer' || !checkAccessConditions('DISPLAY_CARRIER_NAME_IN_REPORTS', $this->session->userdata('company_code'))) {
                    $objPHPExcel->getActiveSheet()->SetCellValue('N' . $rowCount, $order['carriername']);
                }

                $objPHPExcel->getActiveSheet()->SetCellValue('O' . $rowCount, $order['pickup_date']);
                $objPHPExcel->getActiveSheet()->SetCellValue('P' . $rowCount, $order['estimate_d_date']);
                $objPHPExcel->getActiveSheet()->SetCellValue('Q' . $rowCount, $order['delivery_status']);
                $objPHPExcel->getActiveSheet()->SetCellValue('R' . $rowCount, $order['delivery_date']);
                $objPHPExcel->getActiveSheet()->SetCellValue('S' . $rowCount, $order['last_status_name']);
                $objPHPExcel->getActiveSheet()->SetCellValue('T' . $rowCount, $order['last_loc']);
                if (is_array($order['epod']) && count($order['epod']) >= 1) {
                    $col = 20;
                    foreach ($order['epod'] as $key => $value) {
                        $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($col, $rowCount, $value);
                        $col++;
                    }
                }
                $rowCount++;
            }
        }

        $fileName = 'Basicshipmentreport-' . date("Ymdhis") . '.xlsx';
        header('Content-Type: application/vnd.ms-excel'); /* mime type */
        header('Content-Disposition: attachment;filename="' . $fileName . '"'); /* tell browser what's the file name */
        header('Cache-Control: max-age=0'); /* no cache */
        $objWriter = new PHPExcel_Writer_Excel2007($objPHPExcel);

        $objWriter->save('php://output');
    }

}
