<?php

use Mpdf\Tag\P;

if (!defined('BASEPATH')) {
    exit('No direct script access allowed');
}
require_once APPPATH . "/third_party/PHPExcel.php";

class Billingexcelexport extends CI_Controller
{

    public function __construct()
    {
        parent::__construct();
        if ($this->session->userdata('user_id') == "") {
            redirect("login");
        }
        $this->load->model(['billingexcelexportmodel', 'Datatables_model', 'DataQueryFormatter_model', 'DataArrayFormatter_model', 'common']);
    }


    public function index()
    {
        echo "Download Billing Data into Excel";
    }

    public function downloadexcel(): void
    {
        ini_set('max_execution_time', 300);
        $post = $this->input->post();
        $billIds = $allRevenueAmountData = [];
        $tobebilled = 0;
        if (!empty($post)) {
            $whereCondition = $this->searchbills($post);
            if (isset($post['hidden_billed']) && $post['hidden_billed'] != "") {
                $tobebilled = $post['hidden_billed'];
            }
            if (isset($post['hidden_billingparty']) && $post['hidden_billingparty'] != "") {
                $anotherWhereCondition['r.recipient_name'] = $post['search_billparty'];
            }
        }
        $userId = $this->session->userdata('user_id');
        $orderJfr = $post['hidden_order_jfr'] ?? "";
        $companyCode = $this->session->userdata('company_code');
        $orderTableCondition = $orderIds = $revenueData = $bookingDetails = $finalArray = [];
        $billingTableWhere = "";
        $selectColumns = ['b.*,g.name as billgroup,s.name as billstatus'];
        $tableName = 'tbl_bills b';
        $indexColumn = 'b.id';
        $groupBy = 'b.id';
        $excludeCountQuery = 'Yes';
        if (!empty($whereCondition)) {
            foreach ($whereCondition as $key => $value) {
                $value = "'$value'";
                if ($key == "b.invoice_date <=" || $key == "b.invoice_date >=") {
                    $orderTableCondition[] = $key . $value;
                } else {
                    $orderTableCondition[] = $key . ' = ' . $value;
                }
            }
        }
        $orderTableCondition[] = "b.status IN ('1','2','3','4')";
        if ($companyCode == "RUKN") {
            $orderTableCondition[] = "b.company_code LIKE '" . $companyCode . "' ";
        } else {
            $orderTableCondition[] = "b.user_id ='" . $userId . "' ";
        }
        if ($tobebilled == 1) {
            $getBillStatusId = $this->db->select("id")->get_where("tb_billstatus_master", ['name' => "Billed"]);
            if ($getBillStatusId->num_rows() > 0) {
                $orderTableCondition[] = "b.invoice_status ='" . $getBillStatusId->row()->id . "'";
            }
        }
        if (strlen($orderJfr) == 14) {
            $getbillingids = $this->common->gettbldata(['type' => '0', 'debtor_jfr' => $orderJfr, 'invoice_status>' => '0', 'status' => '1', 'bill_id>' => '0'], 'bill_id', 'tb_reveneus', 0, 0);
            if (!empty($getbillingids)) {
                foreach ($getbillingids as $bill) {
                    if ($bill['bill_id'] > 0) {
                        $billIds[] = $bill['bill_id'];
                    } else {
                        $billIds[] = 0;
                    }
                }
            } else {
                $billIds[] = 0;
            }
        } else {
            $billIds[] = 0;
        }
        if ($orderJfr != "") {
            if (!empty($billIds)) {
                $orderTableCondition[] = "b.id IN (" . implode(',', $billIds) . ")";
            }
        }
        $billingTableWhere = implode(' AND ', $orderTableCondition);
        if ($billingTableWhere != '') {
            $billingTableWhere = " and $billingTableWhere ";
        }
        $wherecondition = $indexColumn . "!='' " . $billingTableWhere;
        $dataTableSortOrdering = [];
        if ($tobebilled == 2) {
            $this->toBeBilledRevenees($anotherWhereCondition);
        } else {
            $joinsArray[] = ['table_name' => 'tb_billstatus_master s', 'condition' => "s.id = b.invoice_status", 'join_type' => 'left'];
            $joinsArray[] = ['table_name' => 'tb_billgroup_master as g', 'condition' => "g.id = b.bill_group", 'join_type' => 'left'];
            $getRecordListing = $this->Datatables_model->datatablesQuery($selectColumns, $dataTableSortOrdering, $tableName, $joinsArray, $wherecondition, $indexColumn, 'TRUE', $groupBy, $excludeCountQuery, 'POST');
            $requestData = ['id'];
            $formattedData = $this->DataArrayFormatter_model->getCommaSeparatedFields($requestData, $getRecordListing['data']);
            if (isset($formattedData['commaSeparated']['id'])) {
                $revenueDataResponse = $this->billingexcelexportmodel->getRevenueDetailsBy_Billid($formattedData['commaSeparated']['id']);
                if (!empty($revenueDataResponse)) {
                    $revenueData = $revenueDataResponse['revdata'];
                    $orderIds = $revenueDataResponse['order_ids'];
                }
                if (!empty($orderIds)) {
                    $bookingDetails = $this->billingexcelexportmodel->getBookingID_ForRevenue($orderIds);
                    if (!empty($revenueData)) {
                        foreach ($revenueData as $revenue) {
                            $orderRowId = $revenue['order_id'];
                            $billId = $revenue['bill_id'];
                            $billIds[] = $revenue['bill_id'];
                            if ($orderRowId > 0 && $billId > 0) {
                                $bookingId = $bookingDetails[$orderRowId] ?? '';
                                if ($bookingId != "") {
                                    $revenueData[$orderRowId . "_" . $billId]['booking_id'] = $bookingId;
                                }
                            }
                        }
                    }
                    $allRevenueAmount = $dummyBillIds = [];
                    if (!empty($billIds)) {
                        $getRevenueAmount = $this->db->query("SELECT id,amount,bill_id FROM tb_reveneus WHERE bill_id IN ? AND status = ?", [$billIds, '1']);
                        $allRevenueAmount = $getRevenueAmount->result_array();
                    }
                    foreach ($allRevenueAmount as $eachRevenueAmount) {
                        $billId = $eachRevenueAmount['bill_id'];
                        $amount = 0;
                        if(in_array($billId,$dummyBillIds)){
                            $amount += $eachRevenueAmount['amount'];
                        }else{
                            $amount = $eachRevenueAmount['amount'];
                        }
                        $allRevenueAmountData[$billId] = $amount;
                        $dummyBillIds[] = $billId;
                    }
                    $formattedDataRev = $formattedData['orders'];
                    foreach ($revenueData as $revenue) {
                        $billId = $revenue['bill_id'];
                        if ($billId > 0) {
                            $temporaryArray = $formattedDataRev[$billId] ?? [];
                            if (!empty($temporaryArray)) {
                                $orderId = $revenue['order_id'] ?? "";
                                $debotorJfr = $revenue['debtor_jfr'] ?? "";
                                $bookingId = $revenue['booking_id'] ?? "";
                                $billGroupName = $temporaryArray['billgroup'];
                                $billGroupInvoice = $billGroupAccrual = $invoiceStatus = $accrualStatus = "";
                                if (strtoupper($billGroupName) == "BILL") {
                                    $billGroupInvoice = "Invoice";
                                    $billGroupAccrual = "Accrual";
                                } elseif (strtoupper($billGroupName) == "CREDIT NOTE") {
                                    $billGroupInvoice = "Credit Note";
                                    $billGroupAccrual = "";
                                } elseif (strtoupper($billGroupName) == "INVOICE") {
                                    $billGroupInvoice = "";
                                    $billGroupAccrual = "Accrual";
                                } elseif (strtoupper($billGroupName) == "DEBIT NOTE") {
                                    $billGroupInvoice = "";
                                    $billGroupAccrual = "Debit Note";
                                }
                                if ($billGroupInvoice != "") {
                                    $aconInvoiceStatus = $temporaryArray['acon_invoice_status'];
                                    if ($aconInvoiceStatus == "1") {
                                        $invoiceStatus = $billGroupInvoice . " Send To Account";
                                    } else {
                                        $invoiceStatus = $billGroupInvoice . " Not Send To Account";
                                    }
                                }
                                $aconAccrualStatus = $temporaryArray['acon_accrual_status'];
                                if ($billGroupAccrual != "") {
                                    if ($aconAccrualStatus == "1") {
                                        $accrualStatus = $billGroupAccrual . " Send To Account";
                                    } else {
                                        $accrualStatus = $billGroupAccrual . " Not Send To Account";
                                    }
                                }
                                $status = "";
                                if ($invoiceStatus != "") {
                                    if ($accrualStatus != "") {
                                        $status .= $invoiceStatus . " \r/\r ";
                                    } else {
                                        $status .= $invoiceStatus;
                                    }
                                }
                                if ($accrualStatus != "") {
                                    $status .= $accrualStatus;
                                }
                                $totalRevAmount = $allRevenueAmountData[$billId] ?? 0;
                                $finalArray[] = [
                                    'id' => $temporaryArray['id'],
                                    'revenue_id' => $temporaryArray['revenue_id'],
                                    'tracking_no' => $temporaryArray['tracking_no'],
                                    'bill_party' => $temporaryArray['bill_party'],
                                    'bill_type' => $temporaryArray['bill_type'],
                                    'bill_group' => $temporaryArray['billgroup'],
                                    'recipient_type' => $temporaryArray['recipient_type'],
                                    'invoice_no' => $temporaryArray['invoice_no'],
                                    'invoice_date' => $temporaryArray['invoice_date'],
                                    'invoice_status' => $temporaryArray['billstatus'],
                                    'acon_code' => $temporaryArray['acon_code'],
                                    'total_amount' => $temporaryArray['total_amount'],
                                    'currency' => $temporaryArray['currency'],
                                    'customer_code' => $temporaryArray['customer_code'],
                                    'code' => $temporaryArray['code'],
                                    'company_code' => $temporaryArray['company_code'],
                                    'branch_code' => $temporaryArray['branch_code'],
                                    'department_code' => $temporaryArray['department_code'],
                                    'parent_billid' => $temporaryArray['parent_billid'],
                                    'user_id' => $temporaryArray['user_id'],
                                    'status' => $temporaryArray['status'],
                                    'acon_invoice_status' => $temporaryArray['acon_invoice_status'],
                                    'acon_accrual_status' => $temporaryArray['acon_accrual_status'],
                                    'created_on' => $temporaryArray['created_on'],
                                    'updated_on' => $temporaryArray['updated_on'],
                                    'invoice_description' => $temporaryArray['invoice_description'],
                                    'billgroup' => $temporaryArray['billgroup'],
                                    'billstatus' => $temporaryArray['billstatus'],
                                    'order_id' => $orderId,
                                    'debtor_jfr' => $debotorJfr,
                                    'booking_id' => $bookingId,
                                    'acon_send_status' => $status,
                                    'totalRevAmount' => $totalRevAmount
                                ];
                            }
                        }
                    }
                }
            }
            $this->donwloadbillingexcel($finalArray);
        }
    }

    public function toBeBilledRevenees($anotherWhereCondition): void
    {
        $toBeBilledCondition = $ordersData = $finalArray = $dataTableSortOrdering = [];
        $tobeSelected = ["r.id,r.recipient_role,r.recipient_code,r.recipient_name,r.debtor_jfr,r.amount,r.currency,r.invoice_status,r.status,o.order_id,o.company_code,o.branch_code"];
        $tobebilledtable = "tb_reveneus r";
        $toBeBilledindexColumn = 'r.id';
        $tbBeBilledgroupBy = 'r.id';
        if (!empty($anotherWhereCondition)) {
            foreach ($anotherWhereCondition as $key => $value) {
                $value = "'$value'";
                $toBeBilledCondition[] = $key . ' = ' . $value;
            }
        }
        $toBeBilledCondition[] = "o.status !='0'";
        $toBeBilledCondition[] = "r.invoice_status='1'";
        $toBeBilledCondition[] = "r.status='1'";
        $companyCode = $this->session->userdata('company_code');
        $userId = $this->session->userdata('user_id');
        if ($companyCode == "RUKN") {
            $toBeBilledCondition[] = "o.company_code LIKE '" . $companyCode . "' ";
        } else {
            $toBeBilledCondition[] = "o.user_id ='" . $userId . "' ";
        }
        $toBeBilledWhere = implode(' AND ', $toBeBilledCondition);
        if ($toBeBilledWhere != '') {
            $toBeBilledWhere = " and $toBeBilledWhere ";
        }
        $tobebilled_wherecondition = $toBeBilledindexColumn . "!='' " . $toBeBilledWhere;
        $tobebilled_joinsArray[] = ['table_name' => 'tb_orders o', 'condition' => "r.order_id=o.id", 'join_type' => 'INNER'];
        $excludeCountQuery = 'Yes';
        $getRecordListing = $this->Datatables_model->datatablesQuery($tobeSelected, $dataTableSortOrdering, $tobebilledtable, $tobebilled_joinsArray, $tobebilled_wherecondition, $toBeBilledindexColumn, 'TRUE', $tbBeBilledgroupBy, $excludeCountQuery, 'POST');
        $requestData = ['id'];
        $formattedData = $this->DataArrayFormatter_model->getCommaSeparatedFields($requestData, $getRecordListing['data']);
        if (!empty($formattedData)) {
            $ordersData = $formattedData['orders'];
        }
        if (!empty($ordersData)) {
            foreach ($ordersData as $bill) {
                $finalArray[] = [
                    'id' => $bill['id'],
                    'booking_id' => $bill['order_id'],
                    'bill_party' => $bill['recipient_name'],
                    'bill_type' => "",
                    'bill_group' => "",
                    'recipient_type' => $bill['recipient_role'],
                    'invoice_no' => "",
                    'invoice_date' => "",
                    'invoice_status' => "",
                    'acon_code' => '',
                    'debtor_jfr' => $bill['debtor_jfr'],
                    'currency' => $bill['currency'],
                    'customer_code' => "",
                    'code' => "",
                    'company_code' => $bill['company_code'],
                    'branch_code' => $bill['branch_code'],
                    'department_code' => "",
                    'status' => $bill['status'],
                    'acon_status' => 1,
                    'acon_send_status' => '',
                    'totalRevAmount' => $bill['amount']
                ];
            }
        }
        $this->donwloadbillingexcel($finalArray);
    }

    public function donwloadbillingexcel($data): void
    {
        $styleArray = [
            'font' => [
                'bold' => true,
                'color' => ['rgb' => 'FFFFFF'],
                'size' => 10,
                'name' => 'Verdana'
            ]
        ];
        $objPHPExcel = new PHPExcel();
        $objPHPExcel->setActiveSheetIndex(0);
        $objPHPExcel->getActiveSheet()
            ->getStyle('A1:O1')
            ->applyFromArray(
                [
                    'fill' => [
                        'type' => PHPExcel_Style_Fill::FILL_SOLID,
                        'color' => ['rgb' => '0c3b81']
                    ]
                ]
            );
        $objPHPExcel->getActiveSheet()->SetCellValue('A1', 'Invoice Number');
        $objPHPExcel->getActiveSheet()->getStyle('A1')->applyFromArray($styleArray);
        $objPHPExcel->getActiveSheet()->SetCellValue('B1', 'Tracking Number');
        $objPHPExcel->getActiveSheet()->getStyle('B1')->applyFromArray($styleArray);
        $objPHPExcel->getActiveSheet()->SetCellValue('C1', 'JFR');
        $objPHPExcel->getActiveSheet()->getStyle('C1')->applyFromArray($styleArray);
        $objPHPExcel->getActiveSheet()->SetCellValue('D1', 'Billing Party');
        $objPHPExcel->getActiveSheet()->getStyle('D1')->applyFromArray($styleArray);
        $objPHPExcel->getActiveSheet()->SetCellValue('E1', 'Billing Type');
        $objPHPExcel->getActiveSheet()->getStyle('E1')->applyFromArray($styleArray);
        $objPHPExcel->getActiveSheet()->SetCellValue('F1', 'Billing Group');
        $objPHPExcel->getActiveSheet()->getStyle('F1')->applyFromArray($styleArray);
        $objPHPExcel->getActiveSheet()->SetCellValue('G1', 'Revenue');
        $objPHPExcel->getActiveSheet()->getStyle('G1')->applyFromArray($styleArray);
        $objPHPExcel->getActiveSheet()->SetCellValue('H1', 'Recipient Type');
        $objPHPExcel->getActiveSheet()->getStyle('H1')->applyFromArray($styleArray);
        $objPHPExcel->getActiveSheet()->SetCellValue('I1', 'Invoice Date');
        $objPHPExcel->getActiveSheet()->getStyle('I1')->applyFromArray($styleArray);
        $objPHPExcel->getActiveSheet()->SetCellValue('J1', 'Invoice Status');
        $objPHPExcel->getActiveSheet()->getStyle('J1')->applyFromArray($styleArray);
        $objPHPExcel->getActiveSheet()->SetCellValue('K1', 'Account Status');
        $objPHPExcel->getActiveSheet()->getStyle('K1')->applyFromArray($styleArray);
        $objPHPExcel->getActiveSheet()->SetCellValue('L1', 'Account Code');
        $objPHPExcel->getActiveSheet()->getStyle('L1')->applyFromArray($styleArray);
        $objPHPExcel->getActiveSheet()->SetCellValue('M1', 'Billing Currency');
        $objPHPExcel->getActiveSheet()->getStyle('M1')->applyFromArray($styleArray);
        $objPHPExcel->getActiveSheet()->SetCellValue('N1', 'Company Code');
        $objPHPExcel->getActiveSheet()->getStyle('N1')->applyFromArray($styleArray);
        $objPHPExcel->getActiveSheet()->SetCellValue('O1', 'Branch Code');
        $objPHPExcel->getActiveSheet()->getStyle('O1')->applyFromArray($styleArray);
        $rowCount = 2;
        if (!empty($data)) {
            foreach ($data as $result) {
                $objPHPExcel->getActiveSheet()->SetCellValue('A' . $rowCount, $result['invoice_no']);
                $objPHPExcel->getActiveSheet()->SetCellValue('B' . $rowCount, $result['booking_id']);
                $objPHPExcel->getActiveSheet()->SetCellValue('C' . $rowCount, $result['debtor_jfr']);
                $objPHPExcel->getActiveSheet()->SetCellValue('D' . $rowCount, $result['bill_party']);
                $billtype = $result['bill_type'];
                if ($billtype == "1") {
                    $bill_type = "Single";
                } else {
                    $bill_type = "Bulk";
                }
                $objPHPExcel->getActiveSheet()->SetCellValue('E' . $rowCount, $bill_type);
                $objPHPExcel->getActiveSheet()->SetCellValue('F' . $rowCount, $result['bill_group']);
                $objPHPExcel->getActiveSheet()->SetCellValue('G' . $rowCount, $result['totalRevAmount']);
                $objPHPExcel->getActiveSheet()->SetCellValue('H' . $rowCount, $result['recipient_type']);
                $objPHPExcel->getActiveSheet()->SetCellValue('I' . $rowCount, $result['invoice_date']);
                $objPHPExcel->getActiveSheet()->SetCellValue('J' . $rowCount, $result['invoice_status']);
                $objPHPExcel->getActiveSheet()->SetCellValue('K' . $rowCount, $result['acon_send_status']);
                $objPHPExcel->getActiveSheet()->SetCellValue('L' . $rowCount, $result['acon_code']);
                $objPHPExcel->getActiveSheet()->SetCellValue('M' . $rowCount, $result['currency']);
                $objPHPExcel->getActiveSheet()->SetCellValue('N' . $rowCount, $result['company_code']);
                $objPHPExcel->getActiveSheet()->SetCellValue('O' . $rowCount, $result['branch_code']);
                $rowCount++;
            }
        }
        $fileName = 'Billing' . "_" . date("Ymdhis") . '.xlsx';
        @ob_end_clean();
        header('Content-Type: application/vnd.ms-excel');
        header('Content-Disposition: attachment;filename="' . $fileName . '"');
        header('Cache-Control: max-age=0');
        $objWriter = new PHPExcel_Writer_Excel2007($objPHPExcel);
        $objWriter->save('php://output');
    }


    public function searchbills($post): array
    {
        $whereCondition = [];
        if (isset($post['hidden_billingparty']) && $post['hidden_billingparty'] != "") {
            $whereCondition['b.bill_party'] = $post['hidden_billingparty'];
        }
        if (isset($post['hidden_billtype']) && $post['hidden_billtype'] != "") {
            $whereCondition['b.bill_type'] = $post['hidden_billtype'];
        }
        if (isset($post['hidden_customercode']) && $post['hidden_customercode'] != "") {
            $whereCondition['b.customer_code'] = $post['hidden_customercode'];
        }
        if (isset($post['hidden_fromdate']) && $post['hidden_fromdate'] != "") {
            $fromdate = date('Y-m-d', strtotime($post['hidden_fromdate']));
            $whereCondition['b.invoice_date >='] = $fromdate;
        }
        if (isset($post['hidden_todate']) && $post['hidden_todate'] != "") {
            $todate = date('Y-m-d', strtotime($post['hidden_todate']));
            $whereCondition['b.invoice_date <='] = $todate;
        }
        if (isset($post['hidden_shipmentno']) && $post['hidden_shipmentno'] != "") {
            $whereCondition['b.tracking_no'] = $post['hidden_shipmentno'];
        }
        if (isset($post['hidden_billgroup']) && $post['hidden_billgroup'] != "") {
            $whereCondition['b.bill_group'] = $post['hidden_billgroup'];
        }
        if (isset($post['hidden_billstatus']) && $post['hidden_billstatus'] != "") {
            $whereCondition['b.invoice_status'] = $post['hidden_billstatus'];
        }
        if (isset($post['hidden_invoiceno']) && $post['hidden_invoiceno'] != "") {
            $whereCondition['b.invoice_no'] = $post['hidden_invoiceno'];
        }
        if (isset($post['hidden_cid']) && $post['hidden_cid'] != "") {
            $whereCondition['b.code'] = $post['hidden_cid'];
        }
        if (isset($post['hidden_debitorcode']) && $post['hidden_debitorcode'] != "") {
            $whereCondition['b.acon_code'] = $post['hidden_debitorcode'];
        }
        if (isset($post['hidden_companycode']) && $post['hidden_companycode'] != "") {
            $whereCondition['b.company_code'] = $post['hidden_companycode'];
        }
        if (isset($post['hidden_branchcode']) && $post['hidden_branchcode'] != "") {
            $whereCondition['b.branch_code'] = $post['hidden_branchcode'];
        }
        return $whereCondition;
    }
}

?>
