<?php

class Blowhornorderstatusevent extends CI_Controller
{
    public function __construct()
    {
        parent::__construct();
        $this->load->model(['common', 'blowhornorderstatusmodel', 'Singlestatusmodel']);
        $this->load->library('blowhornorderstatuslib');
    }

    public function orderStatusHistoryAltova(): void
    {
        $blowhornOrders = $this->getOrderList();
        if (empty($blowhornOrders)) {
            log_message("error", "There is no orders allocate to BLOW HORN Carrier ");
            return;
        }
        echo $this->getBlowhornOrderStatus($blowhornOrders);
    }

    private function getOrderList(): array
    {
        $blowhormOrderList = $this->blowhornorderstatusmodel->getblowhormOrderList();
        if (empty($blowhormOrderList)) {
            log_message("error", "There is no orders allocate to BLOW HORN Carrier ");
            return [];
        }

        foreach ($blowhormOrderList as $orders) {
            $orderStatus = $this->blowhornorderstatusmodel->getPendingOrderList($orders['id']);
            if ($orderStatus == 0) {
                $blowhornOrders[] = $orders['ref_value'];
            }
        }
        return $blowhornOrders ?? [];
    }


    private function getBlowhornOrderStatus(array $blowhornOrders): string
    {
        if (empty($blowhornOrders)) {
            log_message("error", "There is no orders allocate to BLOW HORN Carrier ");
            return "Fail";
        }
        foreach ($blowhornOrders as $key => $value) {
            $orderStatusResponse = $this->getOrderStatus($blowhornOrders[$key]);
            log_message("error", "Altova Response" . $orderStatusResponse);
        }
        return $orderStatusResponse;
    }

    private function getOrderStatus(string $orderId): string
    {
        try {
            log_message("error", "BLOWHORN Status Request to Altova: " . $orderId);
            $data = 'orderId=' . $orderId;
            $curl = curl_init(BLOWHORN_STATUS_HISTORY_URL);
            curl_setopt($curl, CURLOPT_URL, BLOWHORN_STATUS_HISTORY_URL);
            curl_setopt($curl, CURLOPT_POST, true);
            curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
            $headers = ["Content-Type: application/x-www-form-urlencoded"];
            curl_setopt($curl, CURLOPT_HTTPHEADER, $headers);
            curl_setopt($curl, CURLOPT_POSTFIELDS, $data);
            $resp = curl_exec($curl);
            if ($resp === false) {
                log_message('error', ' BLOWHORN request failed: ' . curl_error($curl));
            }
            log_message("error", "BLOWHORN Status  Response" . $resp);
            curl_close($curl);
        } catch (Exception $ex) {
            $resp = "";
            log_message("error", "Some Problem occured!, While receiving Order Status from Altova " . $ex->getMessage());
        }
        return $resp;
    }

    public function orderStatusHistory(): void
    {
        $blowhornOrders = $this->getOrderList();
        if (empty($blowhornOrders)) {
            log_message("error", "There is no orders allocate to BLOW HORN Carrier ");
            return;
        }
        echo $this->getBlowhornOrderStatusHistory($blowhornOrders);
    }

    public function orderStatus($id = null): string
    {
        $orderAWBNoRes = $this->blowhornorderstatusmodel->getOrderAWBNumber($id);
        $orderAWBNo = $orderAWBNoRes['ref_value'] ?? "";
        if (empty($orderAWBNoRes)) {
            log_message("error", "Tehre is no AWB number for this Order " . $id);
            return "Fail";
        }

        $orderStatusResponse = $this->getOrderStatusHistory($orderAWBNo);
        log_message("error", "BLOWHORN_API_URL Response" . $orderStatusResponse);
        try {
            $this->blowhornorderstatuslib->insertOrderStatus($orderAWBNo, $orderStatusResponse,"History");
        } catch (JsonException $ex) {
            log_message("error", "Some Problem occured!, While Sending Trip Notification XML to Altova " . $ex->getMessage());
        }
        return "success";
    }

    private function getBlowhornOrderStatusHistory(array $blowhornOrders): string
    {
        if (empty($blowhornOrders)) {
            log_message("error", "There is no orders allocate to BLOW HORN Carrier ");
            return "Fail";
        }
        foreach ($blowhornOrders as $key => $value) {
            $orderStatusResponse = $this->getOrderStatusHistory($blowhornOrders[$key]);
            log_message("error", "BLOWHORN_API_URL Response" . $orderStatusResponse);
            try {
                $this->blowhornorderstatuslib->insertOrderStatus($blowhornOrders[$key], $orderStatusResponse,"History");
            } catch (JsonException $e) {
            }
        }
        return "Success";
    }

    private function getOrderStatusHistory(string $orderId): string
    {
        try {
            $curl = curl_init();
            curl_setopt_array($curl, [
                CURLOPT_URL => BLOWHORN_API_URL . '/orders/' . $orderId . '/status/history',
                CURLOPT_RETURNTRANSFER => true,
                CURLOPT_ENCODING => '',
                CURLOPT_MAXREDIRS => 10,
                CURLOPT_TIMEOUT => 0,
                CURLOPT_FOLLOWLOCATION => true,
                CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                CURLOPT_CUSTOMREQUEST => 'GET',
                CURLOPT_HTTPHEADER => ['API_KEY: ' . BLOWHORN_API_KEY],
            ]);
            $response = curl_exec($curl);
            curl_close($curl);
        } catch (Exception $ex) {
            $response = "";
            log_message("error", "Some Problem occured!, While receiving Order Status from Altova " . $ex->getMessage());
        }
        return $response;
    }

    public function orderStatusWebhook(): string
    {
        ini_set('max_execution_time', 300);
        $postData = json_decode(file_get_contents("php://input"), true, 512, JSON_THROW_ON_ERROR);
        if (empty($postData)) {
            return "Please Send Proper Format";
        }
        $orderAWBNo = $postData['AWB'];
        if ($orderAWBNo == "") {
            return "Please Provide Proper AWB NUMBER";
        }
        try {
            $this->blowhornorderstatuslib->insertOrderStatus($orderAWBNo, json_encode($postData),"Web");
        } catch (JsonException $ex) {
            log_message("error", "Some Problem occured!, While Sending Trip Notification XML to Altova " . $ex->getMessage());
        }
        return "success";
    }

    public function orderStatusTracking(): string
    {
        $StatusData = json_decode(file_get_contents("php://input"), true, 512, JSON_THROW_ON_ERROR);
        if (empty($StatusData)) {
            return "Fail";
        }
        log_message("error", "Order Status Webhook" . json_encode($StatusData));

        try {
            $curl = curl_init();
            curl_setopt_array($curl, [
                CURLOPT_URL => BLOWHORN_STATUS_WEBHOOK,
                CURLOPT_RETURNTRANSFER => true,
                CURLOPT_ENCODING => '',
                CURLOPT_MAXREDIRS => 10,
                CURLOPT_TIMEOUT => 0,
                CURLOPT_FOLLOWLOCATION => true,
                CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                CURLOPT_CUSTOMREQUEST => 'POST',
                CURLOPT_POSTFIELDS => json_encode($StatusData),
                CURLOPT_HTTPHEADER => [
                    'Content-Type: application/json'
                ],
            ]);
            $response = curl_exec($curl);
            curl_close($curl);
        } catch (Exception $ex) {
            $response = "";
            log_message("error", "Some Problem occured!, While sending Status to Altova " . $ex->getMessage());
        }

        return $response == "" ? "FAil" : "Success";
    }
}
