<?php
defined('BASEPATH') or exit('No direct script access allowed');

use phpseclib\Net\SSH2;
use phpseclib\Net\SFTP;

class Bondsedi extends CI_Controller
{

    public function __construct()
    {
        parent::__construct();
        $this->load->model("common");
        $this->load->model("Aulabelmodel");
        $this->load->library('uuid');
    }

    function getUserTimeZone($uid, $cmpcode)
    {
        $getqry = $this->db->query("SELECT country_code,cntry_timezone,cntry_hrs,currency FROM tbl_country_master WHERE (country_code='" . $cmpcode . "' OR country_name='" . $cmpcode . "') AND status=1 LIMIT 1");
        $res = array(
            "currency" => "SGD",
            "timezone" => "Asia/Singapore",
            "hrs" => "+08.00",
            "country" => "SG"
        );
        if ($getqry->num_rows() > 0) {
            $res = array(
                "currency" => $getqry->row()->currency,
                "timezone" => $getqry->row()->cntry_timezone,
                "hrs" => $getqry->row()->cntry_hrs,
                'country' => $getqry->row()->country_code
            );
        }
        return $res;
    }

    public function labelcron()
    {
        $query = $this->db->query("select order_id,job_id,line_no from tb_bondscar_edi where job_id NOT IN (select job_id from tb_bondscar_edi where msg_type = 'JOBLABEL' and msg_status ='CONFIRMED') AND order_id NOT IN (select order_id from tb_bondscar_edi where msg_type='JOBLABEL' AND msg_status='ERROR') AND msg_type='BOOKING' and msg_status='CONFIRMED' group by order_id,job_id");
        if ($query->num_rows() > 0) {
            foreach ($query->result() as $res) {
                $this->labelupload($res->order_id, $res->job_id);
            }
        }
    }

    public function statuscron()
    {
        $query = $this->db->query("SELECT o.id,r.ref_value as job_id FROM `tb_orders`  as o
            INNER join tb_order_references as r on o.id=r.order_id and r.reference_id='BN'
            WHERE o.company_code in ('AUKN','KNAU') AND o.trip_sts=0 AND o.shift_id > 1
            and o.id not in(SELECT order_id from tb_bondscar_edi WHERE msg_status ='ERROR' GROUP BY order_id)
            GROUP BY o.id"
        );
        if ($query->num_rows() > 0) {
            foreach ($query->result() as $res) {
                $this->statusupdate($res->id, $res->job_id);
            }
        }
    }

    public function trackcron()
    {
        $query = $this->db->query("select order_id,job_id,line_no from tb_bondscar_edi where job_id NOT IN (select job_id from tb_bondscar_edi where msg_type = 'STATUS' and msg_status ='DELIVERED') AND order_id NOT IN (select order_id from tb_bondscar_edi where msg_type='TRACKING' AND msg_status='ERROR') AND msg_type='STATUS' and msg_status ='PICKUP' group by order_id,job_id");
        if ($query->num_rows() > 0) {
            foreach ($query->result() as $res) {
                $ordinfo1 = $this->db->query('SELECT o.id,o.trip_id,t.vehicle_id,t.driver_id,t.start_imei from tb_orders o LEFT JOIN tb_trips t on t.id = o.trip_id WHERE o.id = ' . $res->order_id);
                if ($ordinfo1->num_rows() > 0) {
                    $ordinfo = $ordinfo1->row_array();
                    $ordinfo['job_id'] = $res->job_id;
                    $this->trackjob($ordinfo);
                }
            }
        }
    }

    public function statusupdate($order_row_id, $job_id)
    {
        $log_edi_arr = array();
        $status_id = $code = 0;
        $this->load->library("statusintigration");
        $createdon = date('Y-m-d H:i:s');
        $curtz = "Australia/Sydney";
                $orderdata = $this->common->gettblrowdata(array(
                    'id' => $order_row_id
                ), 'order_id,user_id,company_code,branch_code,vendor_id', 'tb_orders', 0, 0);
                $log_edi_arr['order_id'] = $orderdata['order_id'];
                $log_edi_arr['user_id'] = $orderdata['user_id'];
                $log_edi_arr['company_code'] = $orderdata['company_code'];
                $log_edi_arr['branch_code'] = $orderdata['branch_code'];
                $log_edi_arr['vendor_id'] = $orderdata['vendor_id'];
                $log_edi_arr['order_row_id'] = isset($order_row_id)?$order_row_id:0;
                $log_edi_arr['status'] = 1;
                $account = $this->accountInfo($orderdata['company_code'], $orderdata['branch_code']);
                $request = '';
                $request .= '<?xml version="1.0" encoding="ISO-8859-1"?>';
                $request .= '<job xmlns:xi="http://www.w3.org/2001/XInclude" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xsi:noNamespaceSchemaLocation="job-bond-status.xsd">';
                $request .= '<job_action>STATUS</job_action>';
                $request .= '<job_id>' . $job_id . '</job_id>';
                $request .= '<account>' . $account['account'] . '</account>';
                $request .= '<authorization_code>' . $account['auth_code'] . '</authorization_code>';
                $request .= '</job>';
                $log_edi_arr['request'] = $request;
                $resname = date("Ymdhis");
                $filenm = "statusreq" . $resname . ".xml";
                $dom = new DOMDocument();
                $dom->preserveWhiteSpace = FALSE;
                $dom->loadXML($request);
                $dom->save('xml/borderapi/' . $filenm);
                $fileName = FCPATH . "/xml/borderapi/" . $filenm;
                /*
                 * $cFile = new CURLFile($fileName);
                 * $postdata = array(
                 * "uploadfile" => $cFile
                 * );
                 */
                $postdata = array(
                    "filename" => $fileName,
                    'filenm' => $filenm
                );
                $serviceurl = BONDS_URL;
                $headers = array(
                    'Content-Type: multipart/form-data'
                );
                $res = bondscarriercurl($serviceurl, $headers, $postdata);

                $log_edi_arr['response'] = $res;
                $response = json_decode(json_encode(simplexml_load_string($res)), true);
                $edists = isset($response['msg_status']) ? $response['msg_status'] : "";
                $curdt = date("Y-m-d H:i:s");
                if (! is_numeric($edists)) {
                    $edists = 5;
                }
                /*
                 * response empty check
                 */
                if ($response) {
                    $job_id = (isset($response['job_details']['job_id'])) ? $response['job_details']['job_id'] : 0;
                    $line_no = (isset($response['job_details']['line_no'])) ? $response['job_details']['line_no'] : 0;
                    /*
                     * check the status type
                     */

                    if ($response['msg_status'] != 'ERROR') {

                        if (empty($response['job_details']['time_allocated']) && empty($response['job_details']['time_picked_up']) && empty($response['job_details']['time_delivered'])) {
                            $status = "BOOKED"; // "Job is booked";
                            $status_name = 'Booked by Supplier';
                            $stop_type = "P";
                            $log_edi_arr['obj_type_name'] = 'BOOKED';
                            $code = '0100';
                        } else if (! empty($response['job_details']['time_allocated']) && empty($response['job_details']['time_picked_up']) && empty($response['job_details']['time_delivered'])) {
                            $status = "ALLOCATED"; // "Job is allocated to a driver";
                            $status_name = "Accepted by Driver";
                            $stop_type = "P";
                            $log_edi_arr['obj_type_name'] = 'ALLOCATED';
                        } else if (! empty($response['job_details']['time_allocated']) && ! empty($response['job_details']['time_picked_up']) && empty($response['job_details']['time_delivered'])) {
                           
                            if (! empty($response['job_legs']['job_leg'][0]['event_date']) && ! empty($response['job_legs']['job_leg'][0]['event_time'])) {
                                $date = $response['job_legs']['job_leg'][0]['event_date'];
                                $time = $response['job_legs']['job_leg'][0]['event_time'];
                                $puckup_date = date('Y-m-d H:i:s', strtotime("$date $time"));
                                $getactual = getdatetimebytimezone(DFLT_TZ, $puckup_date, $curtz);
                                $createdon = $getactual['datetime'];
                            }elseif(! empty($response['job_legs']['job_leg'][0]['event_time']) && ! empty($response['job_details']['job_date'])){
                                $date = $response['job_details']['job_date'];
                                $time = $response['job_legs']['job_leg'][0]['event_time'];
                                $puckup_date = date('Y-m-d H:i:s', strtotime("$date $time"));
                                $getactual = getdatetimebytimezone(DFLT_TZ, $puckup_date, $curtz);
                                $createdon = $getactual['datetime'];
                            }
                            $this->load->helper('bonds_helper');
                            $au_trip_check = $this->common->gettblrowdata(array(
                                'id' => $order_row_id,
                                'trip_id' => 0
                            ), 'id', 'tb_orders', 0, 0);
                            /*
                             * driver accept checking
                             *
                             */
                            if (! empty($au_trip_check)) {
                                $au_res_accept = auupdatestatusbymanifest($au_trip_check['id'], $createdon);
                                $log_edi_arr['obj_type_name'] = 'Accepted-by-Driver';
                                $this->edilogtransactions($log_edi_arr);
                            }

                            $status = "PICKUP"; // "Job is picked up";
                            $status_name = 'Pickup Or Drop';
                            $log_edi_arr['obj_type_name'] = 'PICKUP';
                            $stop_type = "P";
                            $code = '0500';
                            /*
                             * if(isset($response['job_tracking'])){
                             * if(isset($response['job_tracking']['coordinates'])){
                             * $trk = array("latlng"=>$response['job_tracking']['coordinates'],"trkurl"=>$response['job_tracking']['url']);
                             * $this->trackjob($trk,$order_row_id,$job_id);
                             * }
                             * }
                             */
                        } else if (! empty($response['job_details']['time_allocated']) && ! empty($response['job_details']['time_picked_up']) && ! empty($response['job_details']['time_delivered'])) {

                            $status = "DELIVERED"; // "Job is delivered";
                            $status_name = 'Delivered to Consignee';
                            $stop_type = "D";
                            $log_edi_arr['obj_type_name'] = 'DELIVERED';
                            $code = '3000';
                            
                            if (! empty($response['job_legs']['job_leg'][1]['event_date']) && ! empty($response['job_legs']['job_leg'][1]['event_time'])) {
                                $date = $response['job_legs']['job_leg'][1]['event_date'];
                                $time = $response['job_legs']['job_leg'][1]['event_time'];
                                $delivey_date = date('Y-m-d H:i:s', strtotime("$date $time"));
                                $getactual = getdatetimebytimezone(DFLT_TZ, $delivey_date, $curtz);
                                $createdon = $getactual['datetime'];
                            }elseif(! empty($response['job_legs']['job_leg'][1]['event_time']) && ! empty($response['job_details']['job_date'])){
                                $date = $response['job_details']['job_date'];
                                $time = $response['job_legs']['job_leg'][1]['event_time'];
                                $delivey_date = date('Y-m-d H:i:s', strtotime("$date $time"));
                                $getactual = getdatetimebytimezone(DFLT_TZ, $delivey_date, $curtz);
                                $createdon = $getactual['datetime'];
                            }
                        }
                    } else {
                        $log_edi_arr['obj_type_name'] = 'Status Error';
                        $status = 'ERROR';
                        $log_edi_arr['status'] = 0;
                        $this->edilogtransactions($log_edi_arr);
                    }

                    /*
                     * tb_bondscar_edi insert array
                     */
                    $order = $this->common->gettblrowdata(array(
                        'id' => $order_row_id
                    ), 'order_id,shift_id,trip_id,pickup_pincode,delivery_pincode,plat,plng,dlat,dlng,vendor_id,user_id', 'tb_orders', 0, 0);

                    $res_array = array(
                        'order_id' => $order_row_id,
                        'msg_type' => $response['msg_type'],
                        'msg_status' => $status,
                        'request_path' => $filenm,
                        'response' => $res,
                        'job_id' => $job_id,
                        'line_no' => $line_no
                    );
                    /*
                     * tb_bondscar_edi table checking
                     */
                    $check = $this->common->gettblrowdata(array(
                        'order_id' => $order_row_id,
                        'job_id' => $job_id,
                        'msg_status' => $status,
                        'msg_type' => $response['msg_type']
                    ), 'id,request_path', 'tb_bondscar_edi', 0, 0);

                    if ($check) {
                        $this->common->updatetbledata("tb_bondscar_edi", array(
                            'request_path' => $filenm,
                            'response' => $res
                        ), array(
                            "id" => $check['id']
                        ));
                        unlink(FCPATH . "/xml/borderapi/" . $check['request_path']);
                    } else {

                        $this->common->insertTableData('tb_bondscar_edi', $res_array);
                        /* log_message('error', "insert tb_bondscar_edi::" . $this->db->last_query() . "------------------->"); */
                        if ($response['msg_status'] != 'ERROR') {
                           /* $code = '000';*/

                            $location = '';
                            $shipment_id = $stop_id = $stop_detail_id = $trip_id = $status_id = $lat = $lng = $status_code = $status = $driver_id = $vehicle_id = 0;

                            /* getting status code and id from status master */
                            $select = "id,status_code";
                            $table = "tb_status_master";
                           /* $where = array(
                                "status_name" => $status_name
                            );*/
                            if (! empty($code)) {
                                $where = array(
                                    "status_code" => $code,
                                    'status' => 1
                                );
                                $statusinfo = $this->common->gettblrowdata($where, $select, $table, 0, 0);
                                if (count($statusinfo) > 0) {
                                    $status_id = $statusinfo['id'];
                                }
                            } else {
                                $where = array(
                                    "status_name" => $status_name,
                                    'status' => 1
                                );
                                $statusinfo = $this->common->gettblrowdata($where, $select, $table, 0, 0);
                                if (count($statusinfo) > 0) {
                                    $status_id = $statusinfo['id'];
                                    $code = $statusinfo['status_code'];
                                }
                            }
                            /*$statusinfo = $this->common->gettblrowdata($where, $select, $table, 0, 0);
                            if (count($statusinfo) > 0) {
                                $status_id = $statusinfo['id'];
                                $code = $statusinfo['status_code'];
                            }*/

                            $reason = 'From Bonds Express';

                            /* Getting vehicle and driver from trips table */
                            $where = array(
                                'shift_id' => $order['shift_id']
                            );
                            $select = "vehicle_id,driver_id";
                            $table = "tb_trips";
                            $dvinfo = $this->common->gettblrowdata($where, $select, $table, 0, 0);
                            if (count($dvinfo) > 0) {
                                $driver_id = $dvinfo['driver_id'];
                                $vehicle_id = $dvinfo['vehicle_id'];
                            }

                            /*
                             * if($location!=''){
                             * $data = getlatlngsbyplace($location);
                             * $lat = @$data[0];
                             * $lng = @$data[1];
                             * }
                             */

                            /* getting stop data */
                            $select = "id";
                            $table = "tb_shiporder_stops";
                            $where = array(
                                "shipment_id" => $order['shift_id'],
                                'stoptype' => $stop_type,
                                "status" => 1
                            );
                            $stopidinfo = $this->common->gettblrowdata($where, $select, $table, 0, 0);
                            if (count($stopidinfo) > 0) {
                                $stop_id = $stopidinfo['id'];
                            }

                            // get the recent lat lng values from tb_trucks_data
                            if (! empty($vehicle_id)) {
                                $veh_qry = $this->db->query("SELECT latitude,longitude from tb_trucks_data WHERE id = " . $vehicle_id);
                                if ($veh_qry->num_rows() == 0) {
                                    $lat = $veh_qry->row()->latitude;
                                    $lng = $veh_qry->row()->longitude;
                                }
                            }

                            if ($status_name != "Accepted by Driver") { // bcz we have added stop status in driver creation in driver accept case

                                $innr_array = array(
                                    'order_id' => $order_row_id,
                                    'shipment_id' => $order['shift_id'],
                                    'stop_id' => $stop_id,
                                    'stop_detail_id' => $stop_detail_id,
                                    'stop_type' => $stop_type,
                                    'trip_id' => $order['trip_id'],
                                    'status_id' => $status_id,
                                    'status_code' => $code,
                                    'status' => 1,
                                    'reason' => $reason,
                                    'latitude' => $lat,
                                    'longitude' => $lng,
                                    'createdon' => $createdon,
                                    'loc_name' => $location,
                                    'driver_id' => $driver_id,
                                    'vehicle_id' => $vehicle_id
                                );
                                $check_array = array(
                                    'order_id' => $order_row_id,
                                    'shipment_id' => $order['shift_id'],
                                    'stop_id' => $stop_id,
                                    'stop_detail_id' => $stop_detail_id,
                                    'stop_type' => $stop_type,
                                    'trip_id' => $order['trip_id'],
                                    'status_id' => $status_id,
                                    'status_code' => $code,
                                    'loc_name' => $location,
                                    'driver_id' => $driver_id,
                                    'vehicle_id' => $vehicle_id
                                );
                                if(isset($status) &&  $status == "DELIVERED"){
                                    $check_staus_data=$this->checkstatus($response,$innr_array,$check_array,$log_edi_arr);
                                }
                                $chk_qry = $this->db->select("id")->get_where('tb_stop_status', $check_array);
                                if ($chk_qry->num_rows() == 0) {
                                    $stsins = $this->db->insert('tb_stop_status', $innr_array);
                                    /* edi logs insertion */
                                    $this->edilogtransactions($log_edi_arr);
                                } else {
                                    $stsins = $this->db->where_in("id", array(
                                        "id" => $chk_qry->row()->id
                                    ))
                                        ->update("tb_stop_status", $innr_array);
                                }
                            }

                            /* check trip close */
                            if ($status_name == "Delivered to Consignee") {
                                $upd = $this->common->updatetbledata("tb_bondscar_edi", array(
                                    "status" => 0
                                ), array(
                                    "order_id" => $order_row_id,
                                    'job_id' => $job_id
                                ));
                                $upd = $this->common->updatetbledata("tb_orders", array(
                                    "trip_sts" => 1
                                ), array(
                                    "id" => $order_row_id
                                ));
                                $upd = $this->common->updatetbledata("tb_shifts", array(
                                    "status" => 0
                                ), array(
                                    "id" => $order['shift_id']
                                ));
                                $upd = $this->common->updatetbledata("tb_trips", array(
                                    "status" => 0
                                ), array(
                                    "id" => $order['trip_id']
                                ));
                                /* Generated Summary */
                                $curtz = "";
                                $user = $this->db->select("id,country_code")
                                    ->get_where("tb_users", array(
                                    "id" => $order['user_id']
                                ), 1, 0)
                                    ->row_array();
                                $tz = $this->getUserTimeZone($user['id'], $user['country_code']);
                                $curtz = $tz['timezone'];

                                $gensum = $this->generatesummary($order['trip_id'], $curtz);
                            }
                        }
                    }

        }
    }

    public function labelupload($order_row_id, $job_id)
    {
        $orderdata = $this->common->gettblrowdata(array(
            'id' => $order_row_id
        ), 'order_id,user_id,company_code,branch_code', 'tb_orders', 0, 0);
        $account = $this->accountInfo($orderdata['company_code'], $orderdata['branch_code']);
        $req = '';
        $req .= '<?xml version="1.0" encoding="ISO-8859-1"?>';
        $req .= '<job xmlns:xi="http://www.w3.org/2001/XInclude" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xsi:noNamespaceSchemaLocation="job-bond-joblabel.xsd">';
        $req .= '<job_action>JOBLABEL</job_action>';
        $req .= '<job_id>' . $job_id . '</job_id>';
        $req .= '<account>' . $account['account'] . '</account>';
        $req .= '<authorization_code>' . $account['auth_code'] . '</authorization_code>';
        $req .= '</job>';
        $resname = date("Ymdhis");
        $filenm = "labelreq" . $resname . ".xml";
        $dom = new DOMDocument();
        $dom->preserveWhiteSpace = FALSE;
        $dom->loadXML($req);
        $dom->save('xml/borderapi/' . $filenm);
        $fileName = FCPATH . "/xml/borderapi/" . $filenm;
        /*
         * $cFile = new CURLFile($fileName);
         * $postdata = array(
         * "uploadfile" => $cFile
         * );
         */
        $postdata = array(
            "filename" => $fileName,
            'filenm' => $filenm
        );
        $serviceurl = BONDS_URL;
        $headers = array(
            'Content-Type: multipart/form-data'
        );
        $res = bondscarriercurl($serviceurl, $headers, $postdata);
        $response = json_decode(json_encode(simplexml_load_string($res)), true);
        $edists = isset($response['msg_status']) ? $response['msg_status'] : "";
        $edidata = array(
            "status" => $edists,
            "txn_obj_id" => $orderdata['order_id'],
            'bounded_type' => 2,
            'edi_type' => 2,
            'transaction_id' => time(),
            'edi_id' => 6,
            'edi_name' => 'BONDS TRANSPORT',
            'edi_format_type' => 'XML',
            'obj_type' => 1,
            'user_id' => $orderdata['user_id'],
            'company_code' => $orderdata['company_code'],
            'branch_code' => $orderdata['branch_code'],
            "edi_request" => $req,
            "edi_response" => $res
        );
        /* $edilog = $this->common->insertTableData("tb_etn_edi_transactions", $edidata); */
        if ($response) {
            $job_id = (isset($response['job_details']['job_id'])) ? $response['job_details']['job_id'] : 0;
            $line_no = (isset($response['job_details']['line_no'])) ? $response['job_details']['line_no'] : 0;
            $res_array = array(
                'order_id' => $order_row_id,
                'msg_type' => $response['msg_type'],
                'msg_status' => $response['msg_status'],
                'request_path' => $filenm,
                'response' => $res,
                'job_id' => $job_id,
                'line_no' => $line_no
            );
            $this->common->insertTableData('tb_bondscar_edi', $res_array);
            if ($response['msg_status'] == 'ERROR') {
                log_message('error', 'Border label api error order_id ' . $order_row_id);
            } else {
                $orderinfo = $this->common->gettblrowdata(array(
                    'id' => $order_row_id
                ), 'id,user_id,plat,plng,trip_id,shift_id', 'tb_orders', 0, 0);
                $doctype = $this->common->gettblrowdata(array(
                    'type_name' => 'Others'
                ), 'id', 'tb_document_types', 0, 0);
                $lbname = 'lbl' . date("Ymdhis") . '.pdf';
                copy($response['job_label_file'], NEW_POD_PATH . $lbname);
                $insert['order_id'] = $orderinfo['id'];
                $insert['trip_id'] = $orderinfo['trip_id'];
                $insert['shipment_id'] = $orderinfo['shift_id'];
                $insert['stop_id'] = 0;
                $insert['stop_detail_id'] = 0;
                $insert['stop_type'] = 'P';
                $insert['doc_type'] = $doctype['id'];
                $insert['latitude'] = $orderinfo['plat'];
                $insert['longitude'] = $orderinfo['plng'];
                $insert['user_id'] = $orderinfo['user_id'];
                $insert['status'] = 1;
                $insert['createdon'] = $insert['updatedon'] = date('Y-m-d H:i:s');
                $insert['imgpath'] = $lbname;
                $imageSize = filesize(NEW_POD_PATH.$lbname);
                $insert['filesize'] = $imageSize;
                $newUuid = $this->uuid->v4();
                $insert['hash'] = $newUuid;
                $this->common->insertTableData("tb_pod_uploads", $insert);
            }
        } else {
            log_message('error', 'border edi label request failed');
        }
    }

    public function trackjob($ordinfo)
    {
        $orderdata = $this->common->gettblrowdata(array(
            'id' => $ordinfo['id']
        ), 'order_id,user_id,company_code,branch_code', 'tb_orders', 0, 0);
        $account = $this->accountInfo($orderdata['company_code'], $orderdata['branch_code']);
        $jobid = $ordinfo['job_id'];
        $track = array();
        $request = '';
        $request .= '<?xml version="1.0" encoding="ISO-8859-1"?>';
        $request .= '<job xmlns:xi="http://www.w3.org/2001/XInclude" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xsi:noNamespaceSchemaLocation="job-bond-tracking.xsd">';
        $request .= '<job_action>TRACKING</job_action>';
        $request .= '<job_id>' . $jobid . '</job_id>';
        $request .= '<account>' . $account['account'] . '</account>';
        $request .= '<authorization_code>' . $account['auth_code'] . '</authorization_code>';
        $request .= '</job>';
        $resname = date("Ymdhis");
        $filenm = "trackreq" . $resname . ".xml";
        $dom = new DOMDocument();
        $dom->preserveWhiteSpace = FALSE;
        $dom->loadXML($request);
        $dom->save('xml/borderapi/' . $filenm);
        $fileName = FCPATH . "/xml/borderapi/" . $filenm;
        /*
         * $cFile = new CURLFile($fileName);
         * $postdata = array(
         * "uploadfile" => $cFile
         * );
         */
        $postdata = array(
            "filename" => $fileName,
            'filenm' => $filenm
        );
        $serviceurl = BONDS_URL;
        $headers = array(
            'Content-Type: multipart/form-data'
        );
        $res = bondscarriercurl($serviceurl, $headers, $postdata);
        $response = json_decode(json_encode(simplexml_load_string($res)), true);
        $edists = isset($response['msg_status']) ? $response['msg_status'] : "";
        $edidata = array(
            "status" => $edists,
            "txn_obj_id" => $orderdata['order_id'],
            'bounded_type' => 2,
            'edi_type' => 2,
            'transaction_id' => time(),
            'edi_id' => 6,
            'edi_name' => 'BONDS TRANSPORT',
            'edi_format_type' => 'XML',
            'obj_type' => 1,
            'user_id' => $orderdata['user_id'],
            'company_code' => $orderdata['company_code'],
            'branch_code' => $orderdata['branch_code'],
            "edi_request" => $request,
            "edi_response" => $res
        );
        /* $edilog = $this->common->insertTableData("tb_etn_edi_transactions", $edidata); */
        if ($response) {
            $job_id = (isset($response['job_details']['job_id'])) ? $response['job_details']['job_id'] : 0;
            $line_no = (isset($response['job_details']['line_no'])) ? $response['job_details']['line_no'] : 0;
            $res_array = array(
                'order_id' => $ordinfo['id'],
                'msg_type' => $response['msg_type'],
                'msg_status' => $response['msg_status'],
                'request_path' => $filenm,
                'response' => $res,
                'job_id' => $job_id,
                'line_no' => $line_no
            );
            $this->common->insertTableData('tb_bondscar_edi', $res_array);
            /* store lat lng in tb_rtdrive_locations and update lat,lng , current date in tb_trucks_data */
            if ($response['msg_status'] != 'ERROR') {
                $trip_id = $ordinfo['trip_id'];
                $vehicle_id = $ordinfo['vehicle_id'];
                $driver_id = $ordinfo['driver_id'];
                $mobile_imei = $ordinfo['start_imei'];
                if (empty($mobile_imei)) {
                    $mobile_imei = "0000000000";
                }
                $coordinates = explode(',', $response['job_tracking']['coordinates']);
                $lat1 = $coordinates[0];
                $lng1 = $coordinates[1];
                if ($vehicle_id != '') {
                    $createdon = date('Y-m-d H:i:s');
                    $drive_loc = array(
                        'driver_id' => $driver_id,
                        'vehicle_id' => $vehicle_id,
                        'trip_id' => $trip_id,
                        'latitude' => $lat1,
                        'longitude' => $lng1,
                        'accuracy' => 50,
                        'speed' => 0,
                        'battery' => 0,
                        'bearing' => 50,
                        'timestamp' => $createdon,
                        'mobileimei' => $mobile_imei
                    );
                    $check_drive_loc = array(
                        'driver_id' => $driver_id,
                        'vehicle_id' => $vehicle_id,
                        'trip_id' => $trip_id,
                        'latitude' => $lat1,
                        'longitude' => $lng1
                    );
                    /* store in tb_rtdrive_locations */
                    if ($lat1 != '' && $lat1 != 0) {
                        $chk_qry = $this->db->select("id")->get_where('tb_rtdrive_locations', $check_drive_loc);
                        if ($chk_qry->num_rows() == 0) {
                            $vehins = $this->db->insert('tb_rtdrive_locations', $drive_loc);
                        } else {
                            $vehins = $this->db->where_in("id", array(
                                "id" => $chk_qry->row()->id
                            ))
                                ->update("tb_rtdrive_locations", $drive_loc);
                        }
                    }
                    /* tb_trucks_data updating */
                    $veh_info = array(
                        'latitude' => $lat1,
                        'longitude' => $lng1,
                        'speed' => 0,
                        'battery' => 0,
                        'bearing' => 50,
                        'receivedon' => $createdon
                    );
                    if ($lat1 != '' && $lat1 != 0) {
                        $vehins = $this->db->where_in("id", array(
                            "id" => $vehicle_id
                        ))->update("tb_trucks_data", $veh_info);
                    }
                }
            }
        }
    }

    /**
     * @param null $companyCode
     * @param null $branchCode
     * @return string[]
     */
    private function accountInfo($companyCode = null, $branchCode = null): array
    {
        $where = [
            'branch_code' => $branchCode,
            'company_code' => $companyCode,
            'status' => 1
        ];
        $bondsAccountData = $this->common->gettblrowdata($where, 'account_code,auth_code', 'tb_au_bonds_account_code', 0, 0);
        return [
            'account' => $bondsAccountData['account_code'] ?? '',
            'auth_code' => $bondsAccountData['auth_code'] ?? ''
        ];
    }


    function driver_creation($ordid, $userid, $shift_id, $sloc, $order)
    {
        $vehicle_id = $driver_id = '';
        $plat = $order['plat'];
        $plng = $order['plng'];
        $dlat = $order['dlat'];
        $dlng = $order['dlng'];
        $vendor_id = $order['vendor_id'];
        $curdt = date('Y-m-d H:i:s');
        $where = array(
            'truck_number' => 'VEHICLE',
            'register_number' => 'BONDSVEHICLE',
            'user_id' => $userid
        );
        $select = "id";
        $table = "tb_trucks_data";
        $chkemp = $this->common->gettblrowdata($where, $select, $table, 0, 0);
        if (count($chkemp) == 0) {
            $inn_arr = array(
                'truck_number' => 'VEHICLE',
                'truck_type' => 1,
                'register_number' => 'BONDSVEHICLE',
                'route' => 'VEHICLE',
                'user_id' => $userid,
                'status' => 'Active',
                'createdon' => $curdt
            );
            $vehicle_id = $this->common->insertTableData("tb_trucks_data", $inn_arr);
        } else {
            $vehicle_id = $chkemp['id'];
        }
        $where = array(
            'name' => 'BONDSdriver',
            'user_id' => $userid
        );
        $select = "id";
        $table = "tb_truck_drivers";
        $dricheck = $this->common->gettblrowdata($where, $select, $table, 0, 0);
        if (count($dricheck) == 0) {
            $inn_arr = array(
                'name' => 'BONDSdriver',
                'password' => 'TVRJek5EVTI=',
                'user_id' => $userid,
                'createdby' => $userid,
                'status' => 'Active',
                'createdon' => $curdt
            );
            $driver_id = $this->common->insertTableData("tb_truck_drivers", $inn_arr);
        } else {
            $driver_id = $dricheck['id'];
        }
        if ($vehicle_id != "" && $driver_id != "") {
            $stid = 10;
            $stcode = "0212";
            $chqry = $this->db->select("id")->get_where("tb_trips", array(
                'shift_id' => $shift_id,
                'vehicle_id' => $vehicle_id,
                'driver_id' => $driver_id
            ), 1, 0);
            if ($chqry->num_rows() == 0) {
                $latitude = $plat;
                $longitude = $plng;
                $triparr = array(
                    'shift_id' => $shift_id,
                    'vehicle_id' => $vehicle_id,
                    'driver_id' => $driver_id,
                    'stime' => $curdt,
                    'splace' => "",
                    'eplace' => "",
                    'start_reading' => 0,
                    'end_reading' => 0,
                    'created_on' => $curdt,
                    'updated_on' => $curdt,
                    'status' => 1,
                    'trip_type' => 0,
                    'transit_status' => 0,
                    "plat" => $latitude,
                    "plng" => $longitude
                );
                $tripid = $this->common->insertTableData('tb_trips', $triparr);
                $insarry = array(
                    "shipment_id" => $shift_id,
                    "stop_id" => 0,
                    "stop_detail_id" => 0,
                    "stop_type" => "",
                    "trip_id" => $tripid,
                    "status_id" => $stid,
                    "latitude" => $latitude,
                    "longitude" => $longitude,
                    "status" => 1,
                    "reason" => "From Spoton",
                    "vehicle_id" => $vehicle_id,
                    "driver_id" => $driver_id,
                    "status_code" => $stcode,
                    "createdon" => $curdt,
                    'loc_name' => $sloc
                );
                $ins = $this->db->insert("tb_stop_status", $insarry);
                /* update orders table */
                $ordwhr = array(
                    "shift_id" => $shift_id
                );
                $ordset = array(
                    "trip_id" => $tripid
                );
                $upd = $this->db->set($ordset)
                    ->where($ordwhr)
                    ->update("tb_orders");
            }
            $where = array(
                'shft_id' => $shift_id,
                'user_id' => $userid,
                "status" => 1
            );
            $select = "id";
            $table = "tb_shft_veh";
            $shiftcheck = $this->common->gettblrowdata($where, $select, $table, 0, 0);
            if (count($shiftcheck) > 0) {
                $upd = $this->db->where(array(
                    "shft_id" => $shift_id
                ))->update("tb_shft_veh", array(
                    "vehicle_id" => $vehicle_id
                ));
            }
            $where = array(
                'vendor_id' => $vendor_id,
                'vehicle_id' => $vehicle_id,
                "status" => 1
            );
            $select = "id";
            $table = "tb_vendor_vehicles";
            $ven_veh_check = $this->common->gettblrowdata($where, $select, $table, 0, 0);
            if (count($ven_veh_check) == 0) {
                $arr = array(
                    'vehicle_id' => $vehicle_id,
                    'vendor_id' => $vendor_id,
                    'status' => 1,
                    'createdon' => $curdt
                );
                $ins = $this->common->insertTableData("tb_vendor_vehicles", $arr);
            }
            $chk = $this->db->select("id,driver_id,status")
                ->order_by("id", "DESC")
                ->get_where("tb_vehicles_drivers", array(
                "vehicle_id" => $vehicle_id
            ));
            if ($chk->num_rows() > 0) {
                if ($driver_id == $chk->row()->driver_id) {
                    $upd = $this->db->where(array(
                        "id" => $chk->row()->id
                    ))
                        ->update("tb_vehicles_drivers", array(
                        "status" => 1
                    ));
                } else {
                    $arr = array(
                        'vehicle_id' => $vehicle_id,
                        'driver_id' => $driver_id,
                        'imei' => "",
                        'status' => 1,
                        'createdon' => $curdt,
                        'updatedon' => $curdt
                    );
                    $ins = $this->common->insertTableData("tb_vehicles_drivers", $arr);
                }
            } else {
                $arr = array(
                    'vehicle_id' => $vehicle_id,
                    'driver_id' => $driver_id,
                    'imei' => "",
                    'status' => 1,
                    'createdon' => $curdt,
                    'updatedon' => $curdt
                );
                $ins = $this->common->insertTableData("tb_vehicles_drivers", $arr);
            }
            $chk11 = $this->db->select("id")->get_where("tbl_assigned_drivers", array(
                "driver_id" => $driver_id,
                "vehicle_id" => $vehicle_id
            ), 1, 0);
            if ($chk11->num_rows() > 0) {
                $upd = $this->db->where(array(
                    "id" => $chk11->row()->id
                ))
                    ->update("tbl_assigned_drivers", array(
                    "status" => "1",
                    'updated_on' => $curdt
                ));
            } else {
                $chk111 = $this->db->select("id")->get_where("tbl_assigned_drivers", array(
                    "driver_id <>" => $driver_id,
                    "vehicle_id" => $vehicle_id,
                    "status" => 1
                ), 1, 0);
                if ($chk111->num_rows() == 0) {
                    $ins = $this->common->insertTableData("tbl_assigned_drivers", array(
                        "vehicle_id" => $vehicle_id,
                        "user_id" => $userid,
                        "driver_id" => $driver_id,
                        "mobile_no" => $driver_id,
                        "from_time" => $curdt,
                        "to_time" => $curdt,
                        "status" => "1",
                        'created_on' => $curdt
                    ));
                } else {
                    $upd = $this->db->where(array(
                        "id" => $chk111->row()->id
                    ))
                        ->update("tbl_assigned_drivers", array(
                        "driver_id" => $driver_id,
                        'updated_on' => $curdt
                    ));
                }
            }
        }
    }

    public function generatesummary($tripid = null, $curtz = null)
    {
        if ($tripid != "") {
            $dist = $trip_type = $totalemp = $uid = 0;
            if ($curtz == "") {
                $curtz = date_default_timezone_get();
            }
            $logdate = date('Y-m-d H:i:s');
            $getactual = getdatetimebytimezone(DFLT_TZ, $logdate, $curtz);
            $curdt = $getactual['datetime'];
            $reg = "";
            $sql = $this->db->query("SELECT shift_id,vehicle_id,driver_id,convertToClientTZ(stime,'" . $curtz . "') as stime,convertToClientTZ(etime,'" . $curtz . "') as etime,etime as tetime, start_imei, end_imei, start_reading,end_reading,trip_type,plat,plng FROM tb_trips WHERE id=$tripid AND status=0 LIMIT 1");
            if ($sql->num_rows() > 0) {
                $data = array();
                $data['driver_name'] = $data['driver_num'] = "";
                $shift = $sql->row()->shift_id;
                $sql1 = $this->db->query("SELECT user_id,stime as setime,convertToClientTZ(startdate,'" . $curtz . "') as startdate, convertToClientTZ(enddate,'" . $curtz . "') as enddate,splace,eplace,elat,elng FROM tb_shifts WHERE id=" . $shift . " LIMIT 1");
                $data["trip"] = $sql1->row();
                /* $emp1 = $this->db->query("select e.name,convertToClientTZ(te.stime,'".$curtz."') as in_time,te.status as emp_status,te.driver_late,te.emp_late,te.absent_reason,m.material,e.shipment_volume,e.shipment_weight,e.order_id from tb_employee e,tb_trip_employee te,tb_materials m WHERE te.employee_id=e.id AND m.id=e.material_id AND te.trip_id=".$tripid); */
                $emp = $this->db->query("SELECT IFNULL(SUM(IF(e.status='1',1,0)),0) AS attcnt, count(e.employee_id) AS totcnt FROM  tb_trip_employee e WHERE e.trip_id=" . $tripid);
                $start = $sql->row()->stime;
                $end = $sql->row()->etime;
                $imei = $sql->row()->start_imei;
                $eimei = $sql->row()->end_imei;
                $driverid = $sql->row()->driver_id;
                $vehicleid = $sql->row()->vehicle_id;
                $stime = $sql1->row()->startdate;
                $etime = $sql1->row()->enddate;
                $uid = $sql1->row()->user_id;
                $odometer_start = trim($sql->row()->start_reading);
                $odometer_end = trim($sql->row()->end_reading);
                $trip_type = $sql->row()->trip_type;
                $vendor_id = 0;
                $dlat = $dlng = "";
                $trucks_query = $this->db->query("select truck_capacity,register_number,vendor_id,truck_weight,truck_volume,latitude,longitude from tb_trucks_data WHERE id=$vehicleid LIMIT 1");
                $cab_capacity = $truck_weight = $truck_volume = 0;
                if ($trucks_query->num_rows() > 0) {
                    $cab_capacity = $trucks_query->row()->truck_capacity;
                    $reg = $trucks_query->row()->register_number;
                    $vendor_id = $trucks_query->row()->vendor_id;
                    $truck_weight = $trucks_query->row()->truck_weight;
                    $truck_volume = $trucks_query->row()->truck_volume;
                    $dlat = $trucks_query->row()->latitude;
                    $dlng = $trucks_query->row()->longitude;
                }
                if ($dlat == "") {
                    $dlat = $sql->row()->plat;
                    $dlng = $sql->row()->plng;
                }
                if ($dlat == $sql->row()->plat) {
                    $dlat = $sql1->row()->elat;
                    $dlng = $sql1->row()->elng;
                }
                /* update end lat lng in trips */
                $whrtrip = array(
                    "id" => $tripid
                );
                $settrip = array(
                    "dlat" => $dlat,
                    "dlng" => $dlng
                );
                $upd = $this->db->where($whrtrip)->update("tb_trips", $settrip);
                $vtripinfo = array(
                    "plat" => $sql->row()->plat,
                    "plng" => $sql->row()->plng,
                    "dlat" => $dlat,
                    "dlng" => $dlng
                );
                $data['tripinfo'] = (object) $vtripinfo;
                if ($cab_capacity == "") {
                    $cab_capacity = 0;
                }
                $regg = $this->db->query("select name,contact_num,vendor_id from tb_truck_drivers WHERE id=$driverid LIMIT 1");
                if ($regg->num_rows() > 0) {
                    $data['driver_name'] = $regg->row()->name;
                    $data['driver_num'] = $regg->row()->contact_num;
                    $vnid = $regg->row()->vendor_id;
                    if ($vendor_id == 0 && $vnid != 0) {
                        $vendor_id = $vnid;
                    }
                }
                $sql2 = $this->db->query("select latitude,longitude,convertToClientTZ(`timestamp`,'" . $curtz . "') as timestamp FROM tb_rtdrive_locations WHERE mobileimei='" . $imei . "' and timestamp<='$end' and timestamp>='$start' order by timestamp asc");
                $flag = 0;
                $lat = $lng = 0;
                $wflag = 0;
                $dist = 0;
                if ($sql2->num_rows() > 0) {
                    foreach ($sql2->result() as $row) {
                        if ($flag == 0) {
                            $flag = 1;
                        } else {
                            $a = calculateDistance12($lat, $lng, $row->latitude, $row->longitude);
                            $dist = $dist + $a;
                        }
                        $lat = $row->latitude;
                        $lng = $row->longitude;
                    }
                }
                $attendemp = 1;
                $totalemp = getempcount($tripid);
                if ($emp->num_rows() > 0) {
                    $attendemp = $emp->row()->attcnt;
                }
                $data["noofemp"] = $totalemp;
                $driver_late = 0.00;
                $setime = date("Y-m-d H:i:s", strtotime($sql1->row()->setime));
                $tetime = date("Y-m-d H:i:s", strtotime(date("H:i:s", strtotime($sql->row()->tetime))));
                $to_time = strtotime($setime);
                $from_time = strtotime($tetime);
                if ($from_time > $to_time) {
                    $driver_late = round(abs($from_time - $to_time) / 60, 2);
                }
                $arr = array(
                    'trip_id' => $tripid,
                    'vehicle_id' => $vehicleid,
                    'driver_id' => $driverid,
                    'vendor_id' => $vendor_id,
                    'trip_distance' => $dist,
                    'no_of_emp' => $totalemp,
                    'attended_emp' => $attendemp,
                    'start_imei' => $imei,
                    'end_imei' => $eimei,
                    'start_time' => $stime,
                    'end_time' => $etime,
                    'user_id' => $uid,
                    'cab_capacity' => $cab_capacity,
                    'trip_status' => 1,
                    'trip_type' => $trip_type,
                    'ship_delay' => $driver_late,
                    'createdon' => $curdt
                );
                $chktrip = $this->db->select("id")->get_where("tb_trip_summary", array(
                    "trip_id" => $tripid
                ), 1, 0);
                if ($chktrip->num_rows() == 0) {
                    $res = $this->db->insert("tb_trip_summary", $arr);
                }
            }
        }
    }

    public function bordersapi($ordid)
    {
        $this->load->helper('border_helper');
        borderconsignment(array(
            'ordid' => $ordid
        ),'callapi');
    }

    /*
     * Bound pod ftp connection
     */
    public function bondspodftpcon()
    {
        $folder = BOUNDS_POD_OUTBOUND_PATH;
        $sftp_url = BOUNDS_POD_SERVER_IP;
        $username = BOUNDS_POD__USERNAME;
        $pwd = BOUNDS_POD__PWD;

        $sftp = new SFTP($sftp_url);
        if (! $sftp->login($username, $pwd)) {
            log_message("error", "Bonds Transit FTP Issue");
            unset($sftp);
            exit('Login Failed');
        } else {
            $sftp->chdir($folder);
            $files_list = $sftp->nlist();
            if (! empty($files_list)) {
                foreach ($files_list as $index => $filename) {
                    $file_path_parts = pathinfo($filename);
                    $file_ext = strtoupper($file_path_parts['extension']);
                    if ($file_ext == "XML") {
                        $server_file = $folder . '/' . $filename;
                        $file_content = $sftp->get($folder . '/' . $filename);
                        /* move to backup folder */
                        $bkp_file = "/pub/Outbound_bkp/" . $filename;
                        $move = $sftp->put($bkp_file, $sftp->get($server_file));
                        $getPodStatus = $this->podupload($file_content, $filename);
                        if (!empty($getPodStatus)) {
                            $sftp->delete($server_file, false);
                        }
                    }
                }
            }
        }
        unset($sftp);
    }

    /*
     * Bound pod xml processing
     */
    public function podupload($file_content, $filename)
    {
        $log_edi_arr = [];
        $log_edi_arr['response'] = (isset($file_content) && !empty($file_content)) ? $file_content : "Epod";
        $log_edi_arr['obj_type_name'] = 'ePOD';
        $getarr = @json_decode(json_encode(simplexml_load_string($file_content)), true);
        /*
         * $msg_status = isset($getarr['msg_status'])?strtoupper($getarr['msg_status']):"";
         * $msg_status = isset($getarr['msg_status'])?strtoupper($getarr['msg_status']):"";
         */
        $job_id = isset($getarr['job_details']['job_id']) ? $getarr['job_details']['job_id'] : 0;

        $curtz = "Australia/Sydney";

        if (!empty($job_id)) {
            $line_no = $getarr['job_details']['line_no'];
            $job_id = trim($job_id);
            $select = "order_id";
            $where = [
                'reference_id' => "BN",
                'ref_value' => $job_id,
                "status" => 1
            ];
            $table = "tb_order_references";
            $chkref = $this->common->gettblrowdata($where, $select, $table, 0, 0);
            if (empty($chkref)) {
                return false;
            }
            $order_row_id = $chkref['order_id'];
            $select = "id,order_id,user_id,shift_id,trip_id,company_code,branch_code,vendor_id";
            $where = [
                'id' => $order_row_id,
                'status!=' => '0'
            ];
            $table = "tb_orders";
            $order_res = $this->common->gettblrowdata($where, $select, $table, 0, 0);
            if (!empty($order_res)) {
                $order_res['filename'] = isset($filename) ? $filename : "xml";
                $order_res['job_id'] = $job_id;
                $order_res['line_no'] = $line_no;
                $log_edi_arr['order_id'] = $order_res['order_id'];
                $log_edi_arr['user_id'] = $order_res['user_id'];
                $log_edi_arr['company_code'] = $order_res['company_code'];
                $log_edi_arr['branch_code'] = $order_res['branch_code'];
                $log_edi_arr['vendor_id'] = $order_res['vendor_id'];
                $log_edi_arr['order_row_id'] = $order_res['id'];
                $log_edi_arr['request'] = "ePOD through FTP";
                $log_edi_arr['status'] = 0;
                $edidata = [
                    "status" => 'ePOD',
                    "txn_obj_id" => $order_res['order_id'],
                    'bounded_type' => 2,
                    'edi_type' => 1,
                    'transaction_id' => time(),
                    'edi_id' => 6,
                    'edi_name' => 'BONDS TRANSPORT',
                    'edi_format_type' => 'XML',
                    'obj_type' => 1,
                    'user_id' => $order_res['user_id'],
                    'company_code' => $order_res['company_code'],
                    'branch_code' => $order_res['branch_code'],
                    "edi_request" => $order_row_id,
                    "edi_response" => $file_content
                ];
                /* $edilog = $this->common->insertTableData("tb_etn_edi_transactions", $edidata); */
                $order_res['curdt'] = date("Y-m-d H:i:s");
                $order_res['doctype'] = $order_res['lat'] = $order_res['lng'] = "";

                foreach ($getarr['job_legs'] as $result) {
                    foreach ($result as $res) {
                        /*
                         * get latitude,longitude
                         */
                        $xml_status = strtoupper($res['status']);
                        if (isset($res['event_latlng']) && !empty($res['event_latlng']) && $xml_status == "DELIVERED") {
                            $event_latlng = explode(",", $res['event_latlng']);
                            $order_res['lat'] = $event_latlng[0];
                            $order_res['lng'] = $event_latlng[1];
                        }

                        /*
                         * get receiver name
                         */
                        $order_res['receiver_name'] = "";
                        if (isset($res['pod']) && !empty($res['pod']) && $xml_status == "DELIVERED") {
                            $order_res['receiver_name'] = $res['pod'];
                            /*log_message("error","receiver_name-isset ".json_encode($res['pod']));*/
                        }
                        /*log_message("error","receiver_name ".json_encode($order_res['receiver_name']));*/

                        /*
                         * delivered date
                         */

                        if (isset($res['event_date']) && !empty($res['event_date']) && $xml_status == "DELIVERED") {
                            $date = $res['event_date'];
                            $time = $res['event_time'];
                            $delivey_date = date('Y-m-d H:i:s', strtotime("$date $time"));
                            $getactual = getdatetimebytimezone(DFLT_TZ, $delivey_date, $curtz);
                            $curdt = $getactual['datetime'];
                            $order_res['curdt'] = $curdt;
                        }
                        /*
                         * get signature url
                         */
                        if (isset($res['signature_url']) && !empty($res['signature_url'])) {
                            $order_res['doctype'] = 1;
                            $sig_url_path = $this->img_upload($res['signature_url'], $order_res, $log_edi_arr);
                        }
                        /*
                         * get delivey item photos
                         */
                        if (isset($res['photos']) && !empty($res['photos'])) {
                            /*
                             * if is used for more then one photo ( delivey item photos)
                             */
                            if (is_array($res['photos']['photo_url'])) {
                                foreach ($res['photos']['photo_url'] as $url_key => $photo_url_data) {
                                    $order_res['doctype'] = 3;
                                    $photo_url_path = $this->img_upload($photo_url_data, $order_res, $log_edi_arr);
                                }
                            } else {
                                $order_res['doctype'] = 3;
                                $photo_url_data = $res['photos']['photo_url'];
                                $photo_url_path = $this->img_upload($photo_url_data, $order_res, $log_edi_arr);
                            }
                        }
                    }
                }
            }
            return true;
        }
    }

    /*
     * Bound pod file upload and insert data into tb_pod_uploads table
     */
    private function img_upload($url, $res, $log_edi_arr)
    {
        $img = explode("/", $url);
        $imgpath = end($img);
        $img_path =$imageSize = "";
        if ($imgpath != "") {
            $poddata = bonds_copy_image($url);
            $img_path = NEW_POD_PATH . $imgpath;
            $imageSize = filesize($img_path);
            $res_array = array(
                'order_id' => $res['id'],
                'msg_type' => "ePOD",
                'msg_status' => "ePOD",
                'request_path' => $res['filename'],
                'response' => $log_edi_arr['response'],
                'job_id' => $res['job_id'],
                'line_no' => $res['line_no']
            );

            $chksign = array(
                "trip_id" => $res['trip_id'],
                "shipment_id" => $res['shift_id'],
                "doc_type" => $res['doctype'],
                "imgpath" => $imgpath,
                "status" => 1
            );
            $signdata = $this->common->gettblrowdata($chksign, "id", "tb_pod_uploads", 0, 0);
            $newUuid = $this->uuid->v4();
            if (count($signdata) == 0) {
                if (file_put_contents($img_path, $poddata) != FALSE) {
                    $signarr = array(
                        "trip_id" => $res['trip_id'],
                        "shipment_id" => $res['shift_id'],
                        "stop_id" => 0,
                        "stop_detail_id" => 0,
                        "stop_type" => "D",
                        "doc_type" => $res['doctype'],
                        "imgpath" => $imgpath,
                        "latitude" => $res['lat'],
                        "longitude" => $res['lng'],
                        "user_id" => $res['user_id'],
                        "createdby" => 0,
                        "order_id" => $res['id'],
                        "receiver_name" => $res['receiver_name'],
                        "createdon" => $res['curdt'],
                        "filesize"=> $imageSize,
                        "hash" => $newUuid
                    );
                    $log_edi_arr['status'] = 1;
                    $ins = $this->common->insertTableData("tb_pod_uploads", $signarr);
                    $this->edilogtransactions($log_edi_arr);
                    $res_array['status'] = 1;
                } else {
                    log_message('error', "border POD request failed");
                    $res_array['status'] = 0;
                    $this->common->insertTableData('tb_bondscar_edi', $res_array);
                }
            }
        }
    }

    /*
     * BONDS TRANSPORT and BONDS DC request and response saved log transactions
     */
    private function edilogtransactions($data)
    {
        /* log_message('error', json_encode($data) . ":::----data------>"); */
        $user_id = isset($data['user_id']) ? $data['user_id'] : 0;
        $company_code = isset($data['company_code']) ? $data['company_code'] : "AUKN";
        $branch_code = isset($data['branch_code']) ? $data['branch_code'] : "";
        $ins_edi = $ins_obj_edi = array();
        $edi_id = $edi_name = $object_id = "";
        /*
         * Get vendor name
         */
        $vendors_res = $this->db->select("name")
            ->from('tb_vendors')
            ->where(array(
            'id' => isset($data['vendor_id']) ? $data['vendor_id'] : 0,
            'company_code' => 'AUKN',
            'status' => 1
        ))
            ->get();
        $vendor_name = "BONDS";
        if ((! empty($vendors_res)) && ($vendors_res->num_rows() > 0)) {
            $ven_result = $vendors_res->row_array();
            $vendor_name = $ven_result['name'];
        }
        /*
         * Get edi_name from tb_edi_types table if edi name is not exists insert edi name
         */
        $edi_types = $this->db->select("id,edi_name")
            ->from('tb_edi_types')
            ->where(array(
            'status' => '1'
        ))
            ->like(array(
            'edi_name' => $vendor_name
        ))
            ->get();
        if ((! empty($edi_types)) && ($edi_types->num_rows() > 0)) {
            $edi_result = $edi_types->row_array();
            $edi_name = $edi_result['edi_name'];
            $edi_id = $edi_result['id'];
        } else {
            $edi_name = $vendor_name;
            $ins_edi['edi_name'] = $edi_name;
            $edi_id = $this->common->insertTableData('tb_edi_types', $ins_edi);
        }
        /*
         * Get edi object from tb_edi_object_types table if edi object is not exists insert edi object
         */
        $obj_type_name = (isset($data['obj_type_name']) && ! empty($data['obj_type_name'])) ? $data['obj_type_name'] : "order-id";
        $object_types = $this->db->select("id,obj_type_name")
            ->from('tb_edi_object_types')
            ->where(array(
            'status' => '1'
        ))
            ->like(array(
            'obj_type_name' => $obj_type_name
        ))
            ->get();
        if ((! empty($object_types)) && ($object_types->num_rows() > 0)) {
            $edi_obj_result = $object_types->row_array();
            $object_id = $edi_obj_result['id'];
        } else {
            $ins_obj_edi['obj_type_name'] = $obj_type_name;
            $ins_obj_edi['description'] = "bounds carrier Status types";
            $object_id = $this->common->insertTableData('tb_edi_object_types', $ins_obj_edi);
        }

        /* get  delivery note number */
            $consignment_note=0;
            if(isset($data['order_row_id']) && !empty($data['order_row_id'])){
             $get_delivery_note = $this->common->gettblrowdata(array('order_row_id'=>$data['order_row_id']), "consignment_note", "tb_order_details", 0, 0);
              if(!empty($get_delivery_note)){
                $consignment_note=((isset($get_delivery_note['consignment_note'])) && (!empty($get_delivery_note['consignment_note'])))?$get_delivery_note['consignment_note']:0;
              }
            }

        $sts = isset($data['status']) ? ($data['status']) : 0;
        $params = array(
            'edi_type' => 2, // '1->EDI Transport Order,2->EDI Status'
            'transaction_id' => time(),
            'edi_id' => isset($edi_id) ? $edi_id : 0, // edi id based on name take it from tb_edi_types
            'edi_name' => isset($edi_name) ? $edi_name : "BONDS",
            'bounded_type' => 1, // '1->Inbound(partner => kN),2->Outbound (KN => partner)'
            'edi_format_type' => 'XML',
            'status' => isset($sts) ? $sts : "0",
            'obj_type' => isset($object_id) ? $object_id : "0",
            'txn_obj_id' => isset($data['order_id']) ? $data['order_id'] : "0",
            'ref_value' => $consignment_note,
            /*'txn_obj_id' => isset($data['job_id'])?$data['job_id']:0,*/
            'user_id' => $user_id,
            'company_code' => $company_code,
            'branch_code' => $branch_code,
            'edi_request' => isset($data['request']) ? $data['request'] : 'xml',
            'edi_response' => isset($data['response']) ? $data['response'] : "xml"
        );
        $this->common->insertTableData('tb_etn_edi_transactions', $params);

        /* log_message('error', "transaction data" . json_encode($params)); */
    }

    public function oldbondsapicall($order_id)
    {
        $this->load->helper('bonds_helper');
        $data = array(
            'ordid' => $order_id,
            'vehicle_type' => 115
        );
        $edi_res = [];
        $edi_res = bondsBooking($data,'callapi');
    }
     public function bondsapicall($shift_id)
    {
        $this->load->helper('bonds_helper');
        if($shift_id >0){
            $getorderid = $this->common->gettblrowdata(array('shift_id' => $shift_id), 'id', 'tb_orders', 0, 0);
            if(!empty($getorderid)){
                $order_id = $getorderid['id'];
                if($order_id >0){
                    $data = array(
                        'ordid' => $order_id,
                        'vehicle_type' => 115
                    );
                    $edi_res = [];
                    $edi_res = bondsBooking($data , 'callapi');
                    /* log_message("error","res data::" .json_encode($edi_res)."<----------------"); */
                }
            }
        }
    }
    public function bordersapicall($shift_id)
    {
        $this->load->helper('border_helper');
        $order_id = 0;
        if($shift_id >0){
            $getorderid = $this->common->gettblrowdata(array('shift_id' => $shift_id), 'id', 'tb_orders', 0, 0);
            if(!empty($getorderid)){
                $order_id = $getorderid['id'];
                if($order_id >0){
                    $data = array(
                        'ordid' => $order_id,
                    );
                    $edi_res = [];
                    $edi_res = borderconsignment($data,'callapi');
                    /* log_message("error","res data::" .json_encode($edi_res)."<----------------"); */
                }
            }
        }
    }
    public function checkstatus($response,$innr_array,$check_array,$log_edi_arr){
        $createdon = date('Y-m-d H:i:s');
         $curtz = "Australia/Sydney";
        $stop_id=$stop_type=$status_id=$code=0;
        if (isset($response) && ! empty($response['job_details']['time_allocated']) && ! empty($response['job_details']['time_picked_up']) && !empty($check_array) && !empty($innr_array)) {
            /*
             * driver accept checking
             */
            if (! empty($response['job_legs']['job_leg'][0]['event_date']) && ! empty($response['job_legs']['job_leg'][0]['event_time'])) {
                $date = $response['job_legs']['job_leg'][0]['event_date'];
                $time = $response['job_legs']['job_leg'][0]['event_time'];
                $puckup_date = date('Y-m-d H:i:s', strtotime("$date $time"));
                $getactual = getdatetimebytimezone(DFLT_TZ, $puckup_date, $curtz);
                $createdon = $getactual['datetime'];
            }
            /* log_message('error',$createdon."---createdon-------"); */
            $this->load->helper('bonds_helper');
            $au_trip_check = $this->common->gettblrowdata(array(
                'id' => $check_array['order_id'],
                'trip_id' => 0
            ), 'id', 'tb_orders', 0, 0);

            if (! empty($au_trip_check)) {
                $au_res_accept = auupdatestatusbymanifest($au_trip_check['id'], $createdon);
                $log_edi_arr['obj_type_name'] = 'Accepted-by-Driver';
                $this->edilogtransactions($log_edi_arr);
            }

            $status = "PICKUP"; // "Job is picked up";
            $status_name = 'Pickup Or Drop';
            $log_edi_arr['obj_type_name'] = 'PICKUP';
            $stop_type = "P";
            $code = '0500';



         /* getting stop data */
            $select = "id";
            $table = "tb_shiporder_stops";
            $where = array(
                "shipment_id" => $check_array['shipment_id'],
                'stoptype' => $stop_type,
                "status" => 1
            );
            $stopidinfo = $this->common->gettblrowdata($where, $select, $table, 0, 0);
            if (count($stopidinfo) > 0) {
                $stop_id = $stopidinfo['id'];
            }


            /* getting status code and id from status master */
            $select = "id,status_code";
            $table = "tb_status_master";
            if (! empty($code)) {
                $where = array(
                    "status_code" => $code,
                    'status' => 1
                );
                $statusinfo = $this->common->gettblrowdata($where, $select, $table, 0, 0);
                if (count($statusinfo) > 0) {
                    $status_id = $statusinfo['id'];
                }
            } else {
                $where = array(
                    "status_name" => $status_name,
                    'status' => 1
                );
                $statusinfo = $this->common->gettblrowdata($where, $select, $table, 0, 0);
                if (count($statusinfo) > 0) {
                    $status_id = $statusinfo['id'];
                    $code = $statusinfo['status_code'];
                }
            }
            /* trip id get */
            $get_trip_id = $this->common->gettblrowdata(array(
                'id' => $check_array['order_id']
            ), 'trip_id', 'tb_orders', 0, 0);

            /* check_array and  innr_array  override the varibles */
            if(!empty($get_trip_id)){
              $check_array['trip_id']=$get_trip_id['trip_id'];
              $innr_array['trip_id']=$get_trip_id['trip_id'];
            }
            $check_array['stop_id']=$stop_id;
            $innr_array['stop_id']=$stop_id;

            $check_array['stop_type']=$stop_type;
            $innr_array['stop_type']=$stop_type;

            $check_array['status_code']=$code;
            $innr_array['status_code']=$code;

            $check_array['status_id']=$status_id;
            $innr_array['status_id']=$status_id;

            $innr_array['createdon']=$createdon;


            $chk_qry = $this->db->select("id")->get_where('tb_stop_status', $check_array);
            if ($chk_qry->num_rows() == 0) {
                $stsins = $this->db->insert('tb_stop_status', $innr_array);
                /* log_message('error',"innr_array".$this->db->last_query()); */
                /* edi logs insertion */
                $this->edilogtransactions($log_edi_arr);
            } else {
                $stsins = $this->db->where_in("id", array(
                    "id" => $chk_qry->row()->id
                ))
                    ->update("tb_stop_status", $innr_array);
            }
            /* log_message('error',"innr_array".$this->db->last_query()); */

        }

        return $createdon;
    }

    public function bonds_api_cronjob(){
        /* *get missing API's  Bonds order info  */
      $get_order_data=$this->Aulabelmodel->get_apimissing_orders();
        $input=array();
        if(!empty($get_order_data)){
            foreach($get_order_data as $order_data){
                if((!empty($order_data['id'])) && (empty($order_data['job_id']))){
                    $this->bonds_api_call($order_data['id']);
                }
                $curtz = "Australia/Sydney";
                $logdate = date('Y-m-d H:i:s');
                $getactual = getdatetimebytimezone(DFLT_TZ, $logdate, $curtz);
                $curdt = $getactual['datetime'];
                $input['curtz'] = $curtz;
                $input['curdt'] = $curdt;
                $input['user_id'] = $order_data['user_id']??0;
                $input['company_code'] = $order_data['company_code']??'';
                $input['branch_code'] = $order_data['branch_code']??'';
                $input['ordid'] = $order_data['id']??0;
                $input['carrierid'] = $order_data['vendor_id']??0;
                $input['vehicle_type']=115;
                if((!empty($input['user_id'])) && (!empty($input['company_code'])) && (!empty($input['ordid'])) &&(!empty($input['carrierid'])) && (empty($order_data['shift_id']))){
                    $this->tripcreatemultiorder($input);
                }
            }

        }
        /**Border data*/
        $get_border_data=$this->Aulabelmodel->get_apimissing_border_orders();
        $input=array();
        if(!empty($get_border_data)){
            foreach($get_border_data as $border_data){
                $curtz = "Australia/Sydney";
                $logdate = date('Y-m-d H:i:s');
                $getactual = getdatetimebytimezone(DFLT_TZ, $logdate, $curtz);
                $curdt = $getactual['datetime'];
                $input['curtz'] = $curtz;
                $input['curdt'] = $curdt;
                $input['user_id'] = $border_data['user_id']??0;
                $input['company_code'] = $border_data['company_code']??'';
                $input['branch_code'] = $border_data['branch_code']??'';
                $input['ordid'] = $border_data['id']??0;
                $input['carrierid'] = $border_data['vendor_id']??0;
                $input['vehicle_type']=115;
                if((!empty($input['user_id'])) && (!empty($input['company_code'])) && (!empty($input['ordid'])) &&(!empty($input['carrierid'])) && (empty($border_data['shift_id']))){
                    $this->tripcreatemultiorder($input);
                }
                if((!empty($border_data['id'])) && (empty($border_data['response']))){
                    $this->borders_api_call($border_data['id']);
                }
            }

        }

    }

        public function bonds_api_call($order_id)
        {
            $this->load->helper('bonds_helper');
            $data = array(
                'ordid' => $order_id,
                'vehicle_type' => 115
            );
            $edi_res = [];
            $edi_res = bondsBooking($data,'cornjob');
        }

        public function borders_api_call($ordid)
        {
            $this->load->helper('border_helper');
        $res=borderconsignment(array(
                'ordid' => $ordid
            ),'cornjob');
        }



        /**
         * This method trip create
         *
         * @param  array $input
         * @return int
         */
        public function tripcreatemultiorder($input){
            $response = 0;
            $userid = $input['user_id'];
            $curtz = $input['curtz'];
            $logdate = $ordcreated = date('Y-m-d H:i:s');
            $curdt = $input['curdt'];
            $year = date('y');
            $week = date('W');
            $coun_sess = $input['company_code'];
            $count_code = substr($coun_sess, 0, 2);
            $where = " id IN(" . $input['ordid'] . ")";
            $select = "*";
            $table = "tb_orders";
        /**
            * Get orders
            */
            $orders = $this->common->gettbldata($where, $select, $table, 0, 0);
            $seq_num = 000001;
            $ordcnt = count($orders);
        /*
            * no of orders  checking
            */
            if ($ordcnt > 0) {
                $order_nm = $orders[0]['order_id'];
                $seq_num = substr($order_nm, - 6);
                $shipid = "T" . $count_code . $week . $year . $seq_num;
                $vendor_id = $input['carrierid'];
                $vehicle_id = isset($input['tvehnum']) ? $input['tvehnum'] : "";
                $driver_id = isset($input['tdrivernum']) ? $input['tdrivernum'] : "";
                $tpvehicle_type = isset($input['vehicle_type']) ? $input['vehicle_type'] : 0;
                $carrier_instructions = isset($input['carrier_instructions']) ? $input['carrier_instructions'] : "";
                $vehicle_type = "";
                /**
                * Shift id and carrier id checking
                */
                if ($shipid != "" && $vendor_id > 0) {
                    $i = $j = 0;
                    $weight = 0;
                    $volume = 0;
                    $quantity = 0;
                    foreach ($orders as $order) {
                        $j ++;
                        $i ++;
                        $ordid = $order['id'];
                        $ordcreated = $order['createdon'];
                        $pickup = $order['pickup_address1'];
                        if ($pickup == "") {
                            $pickup = $order['pickup_city'];
                        }
                        $delivery = $order['delivery_address1'];
                        if ($delivery == "") {
                            $delivery = $order['delivery_city'];
                        }
                        $address = $dropaddr = "";
                        if ($order['pickup_address1'] != "") {
                            $address .= $order['pickup_address1'];
                            $dropaddr .= $order['delivery_address1'];
                        }
                        if ($order['pickup_company'] != "") {
                            $address .= ", " . $order['pickup_company'];
                            $dropaddr .= ", " . $order['delivery_company'];
                        }
                        if ($order['pickup_country'] != "") {
                            $address .= ", " . $order['pickup_country'];
                            $dropaddr .= ", " . $order['delivery_country'];
                        }
                        if ($order['pickup_city'] != "") {
                            $address .= ", " . $order['pickup_city'];
                            $dropaddr .= ", " . $order['delivery_city'];
                        }
                        if ($order['pickup_pincode'] != "") {
                            $address .= ", " . $order['pickup_pincode'];
                            $dropaddr .= ", " . $order['delivery_pincode'];
                        }
                        if ($order['weight'] == "") {
                            $order['weight'] = 1;
                        }
                        if ($order['volume'] == "") {
                            $order['volume'] = 1;
                        }
                        if ($order['quantity'] == "") {
                            $order['quantity'] = 1;
                        }
                        $weight += $order['weight'];
                        $volume += $order['volume'];
                        $quantity += $order['quantity'];
                        $plat = $order['plat'];
                        $plng = $order['plng'];
                        $dlat = $order['dlat'];
                        $dlng = $order['dlng'];
                        $where = array(
                            "shipmentid" => $shipid
                        );
                        $select = "id,splace,slat,slng,eplace,elat,elng,vendor_id,weight,volume,units,vehicle_type";
                        $table = "tb_shifts";
                        /**
                         * get data from tb_shifts table
                        */
                        $shipment = $this->common->gettblrowdata($where, $select, $table, 0, 0);

                        if (count($shipment) == 0) {
                            $customer_id = $order['customer_id'];
                            $transport_mode = $order['transport_mode'];
                            $txnid = $shipid;
                            if ($tpvehicle_type != '' && $tpvehicle_type != 0) {
                                $vtwhere = array(
                                    "id" => $tpvehicle_type
                                );
                                $vtselect = "trucktype";
                                $vttable = "tb_trucktypes";
                            /**
                                * get data from tb_trucktypes table
                                */
                                $vtorder = $this->common->gettblrowdata($vtwhere, $vtselect, $vttable, 0, 0);
                                if (count($vtorder) > 0) {
                                    $vehicle_type = $vtorder['trucktype'];
                                } else {
                                    $vehicle_type = $order['vehicle_type'];
                                }
                            } else {
                                $vehicle_type = $order['vehicle_type'];
                            }
                            $startdate = $order['pickup_datetime'];
                            $starttime = date('H:i', strtotime($startdate));
                            $enddate = $order['delivery_datetime'];
                            $endtime = date('H:i', strtotime($enddate));
                            $insarr = array(
                                'user_id' => $userid,
                                'stime' => $starttime,
                                'etime' => $endtime,
                                'splace' => $order['pickup_city'],
                                'slat' => $plat,
                                'slng' => $plng,
                                'eplace' => $order['delivery_city'],
                                'elat' => $dlat,
                                'elng' => $dlng,
                                'scity' => $order['pickup_city'],
                                'dcity' => $order['delivery_city'],
                                'zone_id' => 1,
                                'empshift_start' => $starttime,
                                'empshift_end' => $endtime,
                                'trip_type' => 0,
                                'startdate' => $startdate,
                                'enddate' => $enddate,
                                'shipment_name' => 'Boxes',
                                'shipment_id' => 0,
                                'transport_mode' => $transport_mode,
                                'customer_id' => $customer_id,
                                'vendor_id' => $vendor_id,
                                'carrier_type' => 0,
                                'shipmentid' => $shipid,
                                'txnid' => $txnid,
                                'weight' => $weight,
                                'volume' => $volume,
                                'units' => $quantity,
                                'domainname' => 'INFD',
                                'vehicle_type' => $vehicle_type,
                                'company_code' => $order['company_code'],
                                'branch_code' => $order['branch_code'],
                                'carrier_instructions' => $carrier_instructions,
                                'status' => 1
                            );

                            /**
                                * insert tb_shifts
                                */
                            $ship_id = $this->common->insertTableData("tb_shifts", $insarr);
                        } else {
                            if ($ordcnt == $j) {
                                $enddate = $order['delivery_datetime'];
                                $endtime = date('H:i', strtotime($enddate));
                                $updarr = array(
                                    'etime' => $endtime,
                                    'eplace' => $order['delivery_city'],
                                    'elat' => $dlat,
                                    'elng' => $dlng,
                                    'dcity' => $order['delivery_city'],
                                    'empshift_end' => $endtime,
                                    'enddate' => $enddate,
                                    'weight' => $weight,
                                    'volume' => $volume,
                                    'units' => $quantity,
                                    'carrier_instructions' => $carrier_instructions
                                );
                                /**
                                * update tb_shifts
                                */
                                $upd = $this->common->updatetbledata("tb_shifts", $updarr, array(
                                    "id" => $shipment['id']
                                ));
                            }
                            $ship_id = $shipment['id'];
                        }
                        /**
                         * update order table
                         */
                        $upddt = array(
                            'vendor_id' => $vendor_id,
                            'shift_id' => $ship_id,
                            "shipmentid" => $shipid,
                            'status' => 2
                        );
                        $updwhr = array(
                            "id" => $ordid
                        );
                        $upd = $this->common->updatetbledata("tb_orders", $upddt, $updwhr);
                    /* $this->ordernotify('trip_create', $ordid); */
                        $capacity = $order['weight'];
                        if ($capacity == "") {
                            $capacity = "0";
                        }
                        /**
                         * insert stops records
                         * pickup data
                         */
                        $where = array(
                            "shipment_id" => $ship_id,
                            'plat' => $plat,
                            'plng' => $plng,
                            "stopcity" => $order['pickup_city'],
                            "stoptype" => "P"
                        );
                        $select = "id";
                        $table = "tb_shiporder_stops";
                        /**
                         * get data from tb_shiporder_stops table
                        */
                        $chkstop = $this->common->gettblrowdata($where, $select, $table, 0, 0);
                        if (count($chkstop) == 0) {
                            $insarr = array(
                                'stopname' => $order['pickup_city'],
                                'plat' => $plat,
                                'plng' => $plng,
                                'stopcity' => $order['pickup_city'],
                                'address' => $address,
                                'stoptype' => 'P',
                                'stopstatus' => 0,
                                'shipment_id' => $ship_id,
                                'ordernumber' => $j,
                                'startdate' => $order['pickup_datetime'],
                                'enddate' => $order['delivery_datetime'],
                                'weight' => $order['weight'],
                                'volume' => $order['volume'],
                                'shipmentstopid' => 0,
                                'ship_units' => $order['quantity'],
                                'txncode' => 'NP',
                                'status' => 1,
                                'created_on' => $curdt
                            );
                            /**
                             * insert tb_shiporder_stops
                             */
                            $ins = $this->db->insert("tb_shiporder_stops", $insarr);
                            $pickupstop_id = $this->db->insert_id();
                        } else {
                            $pickupstop_id = $chkstop['id'];
                        }

                        /**
                         * insert stops records
                         * delivery data
                         */
                        $where = array(
                            "shipment_id" => $ship_id,
                            'plat' => $dlat,
                            'plng' => $dlng,
                            "stopcity" => $order['delivery_city'],
                            "stoptype" => "D"
                        );
                        $select = "id";
                        $table = "tb_shiporder_stops";
                        $chkstop = $this->common->gettblrowdata($where, $select, $table, 0, 0);
                        if (count($chkstop) == 0) {
                            $insarr = array(
                                'stopname' => $order['delivery_city'],
                                'plat' => $dlat,
                                'plng' => $dlng,
                                'stopcity' => $order['delivery_city'],
                                'address' => $dropaddr,
                                'stoptype' => 'D',
                                'stopstatus' => 0,
                                'shipment_id' => $ship_id,
                                'ordernumber' => $i + 1,
                                'startdate' => $order['delivery_datetime'],
                                'enddate' => $order['delivery_datetime'],
                                'weight' => $order['weight'],
                                'volume' => $order['volume'],
                                'shipmentstopid' => 0,
                                'ship_units' => $order['quantity'],
                                'txncode' => 'NP',
                                'status' => 1,
                                'created_on' => $curdt
                            );
                            $ins = $this->db->insert("tb_shiporder_stops", $insarr);
                            $dropstop_id = $this->db->insert_id();
                        } else {
                            $dropstop_id = $chkstop['id'];
                        }

                        /**
                        *add pickupstop and drop stop id into details/tb_employee table
                        */

                        $where = array(
                            'stop_id' => $pickupstop_id,
                            'drop_stopid' => $dropstop_id,
                            'order_id' => $order['order_id'],
                            'shift_id' => $ship_id
                        );
                        $select = "id";
                        $table = "tb_employee";
                        /**
                         * get data from tb_employee table
                        */
                        $chkemp = $this->common->gettblrowdata($where, $select, $table, 0, 0);
                        if (count($chkemp) == 0) {
                            $insarr = array(
                                'assoc_id' => $shipid,
                                'pickup' => $pickup,
                                'plat' => $plat,
                                'plng' => $plng,
                                'drop' => $delivery,
                                'dlat' => $dlat,
                                'dlng' => $dlng,
                                'pickup_city' => $order['pickup_city'],
                                'drop_city' => $order['delivery_city'],
                                'pickup_datetime' => $order['pickup_datetime'],
                                'drop_datetime' => $order['delivery_datetime'],
                                'name' => 'Boxes',
                                'phone' => $order['customer_phone'],
                                'address' => $address,
                                'emailid' => $order['customer_email'],
                                'user_id' => $userid,
                                'status' => 1,
                                'createdon' => $curdt,
                                'material_id' => 0,
                                'capacity' => $capacity,
                                'information' => $order['customer_comments'],
                                'shipment_weight' => $order['weight'],
                                'shipment_volume' => $order['volume'],
                                'ship_type' => 'P',
                                'customer_id' => $order['customer_id'],
                                'vendor_id' => $vendor_id,
                                'shipment_id' => 0,
                                'startdate' => $order['pickup_datetime'],
                                'enddate' => $order['delivery_datetime'],
                                'shift_id' => $ship_id,
                                'stop_order' => 1,
                                'drop_order' => 0,
                                'basic_stop' => 0,
                                'stop_id' => $pickupstop_id,
                                'drop_stopid' => $dropstop_id,
                                'order_id' => $order['order_id'],
                                'pkgitemid' => 'BOXES',
                                'no_of_pkgs' => $order['quantity'],
                                'domainname' => 'INFD'
                            );
                            /**
                             * insert tb_employee
                             */
                            $detail_id = $this->common->insertTableData("tb_employee", $insarr);
                        } else {
                            $detail_id = $chkemp['id'];
                        }
                        $stops_units = $this->db->query("SELECT oc.id,oc.quantity,oc.width,oc.height,oc.length,oc.weight,im.unit_name FROM tb_order_cargodetails oc,tbl_shipunit_types im WHERE oc.order_id = '$ordid' AND im.id = oc.handling_unit AND oc.status='1'");
                        if ($stops_units->num_rows() > 1) {
                            $odata = $stops_units->row();
                            $upd = $this->db->query("UPDATE tb_order_cargodetails set stop_detail_id='$detail_id' WHERE id = '" . $odata->id . "'");
                        }
                        $chk1 = $this->db->select("id")->get_where("tb_shft_veh", array(
                            "shft_id" => $ship_id
                        ), 1, 0);
                        if ($chk1->num_rows() > 0) {
                            $shftvehid = $chk1->row()->id;
                            $chk = $this->db->select("id")->get_where("tb_shft_veh_emp", array(
                                "shft_veh_id" => $shftvehid,
                                "status" => 1
                            ), 1, 0);
                            if ($chk->num_rows() == 0) {
                                $getemp = $this->db->select("id,pickup_datetime,drop_datetime")->get_where("tb_employee", array(
                                    "shift_id" => $ship_id
                                ));
                                if ($getemp->num_rows() > 0) {
                                    $pri = 1;
                                    foreach ($getemp->result() as $gt) {
                                        $insveh1 = array(
                                            "user_id" => $userid,
                                            "shft_veh_id" => $shftvehid,
                                            "emp_id" => $gt->id,
                                            "priority" => $pri,
                                            "pickup_time" => $gt->pickup_datetime,
                                            'created_on' => $curdt,
                                            'updated_on' => $curdt,
                                            "status" => 1,
                                            "drop_time" => $gt->drop_datetime
                                        );
                                        $ins = $this->common->insertTableData("tb_shft_veh_emp", $insveh1);
                                        $pri ++;
                                    }
                                }
                            } else {
                                $chkemp = $this->db->select("id")->get_where("tb_shft_veh_emp", array(
                                    "shft_veh_id" => $shftvehid,
                                    "emp_id" => $detail_id,
                                    "status" => 1
                                ), 1, 0);
                                if ($chkemp->num_rows() == 0) {
                                    $insveh1 = array(
                                        "user_id" => $userid,
                                        "shft_veh_id" => $shftvehid,
                                        "emp_id" => $detail_id,
                                        "priority" => 3,
                                        "pickup_time" => $order['pickup_datetime'],
                                        'created_on' => $curdt,
                                        'updated_on' => $curdt,
                                        "status" => 1,
                                        "drop_time" => $order['delivery_datetime']
                                    );
                                    $ins = $this->common->insertTableData("tb_shft_veh_emp", $insveh1);
                                }
                            }
                        } else {
                            if ($vehicle_id != "") {
                                $veh_num = isset($input['vehicle_id']) ? $input['vehicle_id'] : "";
                                $arr = array(
                                    'user_id' => $userid,
                                    'route_id' => 0,
                                    'shft_id' => $ship_id,
                                    'carrier_id' => $vendor_id,
                                    'vehicle_id' => $vehicle_id,
                                    'register_number' => $veh_num,
                                    'created_on' => $curdt,
                                    'updated_on' => $curdt,
                                    'status' => 1
                                );
                                $shftvehid = $this->common->insertTableData("tb_shft_veh", $arr);
                                $getemp = $this->db->select("id,pickup_datetime,drop_datetime")->get_where("tb_employee", array(
                                    "shift_id" => $ship_id
                                ));
                                if ($getemp->num_rows() > 0) {
                                    $pri = 1;
                                    foreach ($getemp->result() as $gt) {
                                        $insveh1 = array(
                                            "user_id" => $userid,
                                            "shft_veh_id" => $shftvehid,
                                            "emp_id" => $gt->id,
                                            "priority" => $pri,
                                            "pickup_time" => $gt->pickup_datetime,
                                            'created_on' => $curdt,
                                            'updated_on' => $curdt,
                                            "status" => 1,
                                            "drop_time" => $gt->drop_datetime
                                        );
                                        $ins = $this->common->insertTableData("tb_shft_veh_emp", $insveh1);
                                        $pri ++;
                                    }
                                }
                            }
                        }
                        if ($vehicle_id != "" && $driver_id != "") {
                            $chk = $this->db->select("id,driver_id,status")
                                ->order_by("id", "DESC")
                                ->get_where("tb_vehicles_drivers", array(
                                "vehicle_id" => $vehicle_id
                            ));
                            if ($chk->num_rows() > 0) {
                                if ($driver_id == $chk->row()->driver_id) {
                                    $upd = $this->db->where(array(
                                        "id" => $chk->row()->id
                                    ))
                                        ->update("tb_vehicles_drivers", array(
                                        "status" => 1
                                    ));
                                } else {
                                    $arr = array(
                                        'vehicle_id' => $vehicle_id,
                                        'driver_id' => $driver_id,
                                        'imei' => "",
                                        'status' => 1,
                                        'createdon' => $curdt,
                                        'updatedon' => $curdt
                                    );
                                    $ins = $this->common->insertTableData("tb_vehicles_drivers", $arr);
                                }
                            } else {
                                $arr = array(
                                    'vehicle_id' => $vehicle_id,
                                    'driver_id' => $driver_id,
                                    'imei' => "",
                                    'status' => 1,
                                    'createdon' => $curdt,
                                    'updatedon' => $curdt
                                );
                                $ins = $this->common->insertTableData("tb_vehicles_drivers", $arr);
                            }
                            $chk11 = $this->db->select("id")->get_where("tbl_assigned_drivers", array(
                                "driver_id" => $driver_id,
                                "vehicle_id" => $vehicle_id
                            ), 1, 0);
                            if ($chk11->num_rows() > 0) {
                                $upd = $this->db->where(array(
                                    "id" => $chk11->row()->id
                                ))
                                    ->update("tbl_assigned_drivers", array(
                                    "status" => "1",
                                    'updated_on' => $curdt
                                ));
                            } else {
                                $chk111 = $this->db->select("id")->get_where("tbl_assigned_drivers", array(
                                    "driver_id <>" => $driver_id,
                                    "vehicle_id" => $vehicle_id,
                                    "status" => 1
                                ), 1, 0);
                                if ($chk111->num_rows() == 0) {
                                    $imei=0;
                                    $ins = $this->common->insertTableData("tbl_assigned_drivers", array(
                                        "vehicle_id" => $vehicle_id,
                                        "user_id" => $userid,
                                        "driver_id" => $driver_id,
                                        "mobile_no" => $driver_id,
                                        "imei" => $imei,
                                        "from_time" => $curdt,
                                        "to_time" => $curdt,
                                        "status" => "1",
                                        'created_on' => $curdt
                                    ));
                                } else {
                                    $upd = $this->db->where(array(
                                        "id" => $chk111->row()->id
                                    ))
                                        ->update("tbl_assigned_drivers", array(
                                        "driver_id" => $driver_id,
                                        'updated_on' => $curdt
                                    ));
                                }
                            }
                        }
                        $response = 1;
                        /* update status */
                        $chk = $this->db->select("id")->get_where("tb_stop_status", array(
                            "shipment_id" => $ship_id,
                            "status_id" => 9
                        ), 1, 0);
                        if ($chk->num_rows() == 0) {
                            $ins = array(
                                "shipment_id" => $ship_id,
                                "stop_id" => 0,
                                "stop_detail_id" => 0,
                                "stop_type" => "",
                                "trip_id" => 0,
                                "status_id" => 9,
                                "status" => 1,
                                "status_code" => "0100",
                                "order_id" => $ordid,
                                "reason" => "Coming from E-Booking",
                                "createdon" => $ordcreated
                            );
                            $insqry = $this->common->insertTableData("tb_stop_status", $ins);
                        }

                    }
                }
            }
            return $response;
        }

}

