<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Borderedi extends CI_Controller
{

    public function __construct()
    {
        parent::__construct();
        $this->load->model("common");
        $this->load->helper("curlfun_helper");
        $this->load->library('uuid');
        $this->load->helper('bonds_helper');
    }

    public function statuscron()
    {
        $fromDate= date('Y-m-d',strtotime("-31 days"));
        $toDate = date('Y-m-d');
        $this->db->select('id');
        $this->db->where_in("company_code", ["AUKN", "KNAU"]);
        $this->db->where("trip_sts=0 AND shift_id > 1 AND vendor_id='228'");
        $this->db->where("pickup_datetime between '$fromDate' AND '$toDate'");
        $this->db->order_by('id', 'DESC');
        $query = $this->db->get('tb_orders');
        $getOrderData=(!empty($query)) ? $query->result_array() : [];
        log_message(
            'error',
            'BorderEdi_statusCron:Query:' .
            $this->db->last_query()
        );
        foreach ($getOrderData as $getOrderId) {
            try {
                $this->consignmentinfo($getOrderId['id']);
            } catch (Throwable $exception) {
                log_message('error','error occurred for this order  :'.$getOrderId['id']);
                continue;
            }
        }
    }

    public function epodcron()
    {
        $fromDate = date('Y-m-d', strtotime("-30 days"));
        $toDate = date('Y-m-d');
        $this->db->select('o.id');
        $this->db->from("tb_orders o");
        $this->db->join("tb_stop_status s", "o.id=s.order_id and s.status_code='3000' and s.status=1", "INNER");
        $this->db->join("tb_pod_uploads p", "o.id =p.order_id", "LEFT");
        $this->db->where_in("o.company_code", ["AUKN", "KNAU"]);
        $this->db->where("o.trip_sts=1 and o.status > 0 AND p.order_id IS NULL AND o.vendor_id='228'");
        $this->db->where("o.pickup_datetime between '$fromDate'  AND  '$toDate'");
        $this->db->group_by('o.id');
        $query = $this->db->get();
        foreach ($query->result() as $getOrderId) {
            $this->getpod($getOrderId->id);
        }
    }
    /**
     * @throws JsonException
     */
    public function consignmentInfo(string $orderId)
    {
        try {
            log_message('error', 'orderId:::' . $orderId);
            $consignmentNote = $this->getConsignmentNote($orderId);
            if (empty($consignmentNote)) {
                return false;
            }
            $apiUrl = BORDER_API . '/api/v1/consignments/' . $consignmentNote;
            $getApiResponse = $this->getBorderEdiResponse($consignmentNote, $orderId, $apiUrl);
            if ((empty($getApiResponse)) || (empty($getApiResponse['Status'])) ||
                ($getApiResponse['Status'] === '404')) {
                return false;
            }
            $getBexResult = $this->insertOrUpdateBexEdiTable($getApiResponse, $orderId, $apiUrl);
            if ($getBexResult === false) {
                log_message(
                    'error',
                    'BorderEdi_consignmentInfo BexEdi Table insert or update failed' .
                    'order_id:' . $orderId
                );
            }
            $orderData = $this->getOrderData($orderId);
            $tripData = $this->getTriData($orderData);
            $this->StatusUpdate($getApiResponse, $orderData, $tripData);
        } catch (Exception $exc) {
            log_message(
                "error",
                "BorderEdi_consignmentInfo status Update failed Order_id "
                . $orderId . "  error msg " . $exc->getTraceAsString()
            );
        }
    }

    private function getConsignmentNote(string $orderId): string
    {
        $getOrderDetails = $this->common->gettblrowdata([
            'order_row_id' => $orderId
        ], 'order_id,consignment_note', 'tb_order_details', 0, 0);
        if (empty($getOrderDetails['consignment_note'])) {
            log_message(
                'error',
                'BorderEdi_consignmentInfo_emptyConsignmentNote:' .
                'order_id:' . $orderId
            );
            return '';
        }
        return (string)$getOrderDetails['consignment_note'];
    }

    /**
     * @throws JsonException
     */
    private function getBorderEdiResponse(string $consignmentNote, string $orderId, string $apiUrl): array
    {
        try {
            $getApiResponse = requestborderapi($apiUrl);
            if ($getApiResponse === "401" || $getApiResponse === 'expired') {
                $getApiResponse = requestborderapi($apiUrl);
            }
            $response=(array)(json_decode($getApiResponse));
            $logStatus = $response['Status'] ?? 'emptyStatus';
            log_message(
                'error',
                'BorderEdi_consignmentInfo_' .
                'DeliveryNote_' . $consignmentNote .
                '_order_id_' . $orderId .
                '_status_' . $logStatus .
                ':TimesTamp:' . date('Y-m-d H:i:s')
            );
            if ($logStatus === 'emptyStatus') {
                log_message(
                    'error',
                    'BorderEdi_consignmentInfo:' .
                    'response:' . json_encode($response, JSON_THROW_ON_ERROR)
                );
            }
        }catch(Exception $e) {
            log_message('error','Borderedi_consignmentInfo API Response error'. json_encode($e->getMessage(), JSON_THROW_ON_ERROR));
        }
        return (!empty($response)) ? $response : [];
    }

    /**
     * @throws JsonException
     */
    public function insertOrUpdateBexEdiTable(array $response, string $orderId, string $apiUrl)
    {
        $status = $response['Status'] ?? '';
        if (empty($status)) {
            return '';
        }
        $insertArray = [
            'req_type' => 'current_status',
            'response' => json_encode($response, JSON_THROW_ON_ERROR),
            'apiurl' => $apiUrl,
            'order_id' => $orderId,
            'res_status' => $status,
            'vendor_type' => 1,
            'status' => 1,
            'updatedon' => date('Y-m-d H:i:s')
        ];

        if (!empty($this->getBexTableId($orderId))) {
            return $this->common->updatetbledata(
                'tb_bexedi',
                [
                    'response' => json_encode($response, JSON_THROW_ON_ERROR)
                ],
                [
                    'req_type' => 'current_status',
                    'order_id' => $orderId
                ]

            );
        }
        $insertArray['createdon'] = date('Y-m-d H:i:s');
        $getBexId = $this->common->insertTableData('tb_bexedi', $insertArray);
        return !empty($getBexId);
    }

    private function StatusUpdate(array $apiResponse, array $orderData,array $tripData){
        try {
            switch ($apiResponse['Status']) {
                case 'Despatched':
                    return $this->insertDispatchStatus($orderData, $tripData,$apiResponse);
                case 'In Transit':
                    return $this->insertInTransitStatus($orderData, $tripData,$apiResponse);
                case 'On Board for Delivery':
                case 'On Board':
                    return $this->insertOnBoardForDeliveryStatus($orderData, $tripData,$apiResponse);
                case ('Delivered' || 'Shipment Data Received' ):
                    return $this->insertDeliveredStatus($orderData, $tripData,$apiResponse,$apiResponse);
                default:
                    log_message('error', 'Borderedi_consignmentInfo default status' . $apiResponse['Status']);
                    return false;
            }
        }catch(Exception $e) {
            log_message('error','Borderedi_consignmentInfo Status Update failed orderId:'
                .$orderData['id'].':'. json_encode($e->getMessage(), JSON_THROW_ON_ERROR));
        }
    }

    private function insertDispatchStatus(array $orderData, array $tripData,array $response): bool
    {
        $this->driverAccept($orderData);
        $insertData= $this->getStatusInsertArray($orderData,$tripData,$response,'0500','P');
        return $this->insertStopStatusTable($insertData,$orderData,$response);
    }
    private function insertInTransitStatus(array $orderData, array $tripData,array $response): bool
    {
        $insertData= $this->getStatusInsertArray($orderData,$tripData,$response,'1550','P');
        return $this->insertStopStatusTable($insertData,$orderData,$response);
    }
    private function insertOnBoardForDeliveryStatus(array $orderData, array $tripData,array $response): bool
    {
        $insertData= $this->getStatusInsertArray($orderData,$tripData,$response,'0191','P');
        return $this->insertStopStatusTable($insertData,$orderData,$response);
    }
    private function insertDeliveredStatus(array $orderData, array $tripData, array $apiResponse,array $response): bool
    {
        $insertData= $this->getStatusInsertArray($orderData,$tripData,$response,'3000','D');
        $this->driverAccept($orderData);
        $insertRes= $this->insertStopStatusTable($insertData,$orderData,$response);
        $this->tripClose($apiResponse,$orderData);
        return $insertRes;
    }

    private function insertStopStatusTable(array $insertData, array $orderData, array $response): bool
    {
        $getStatus= $this->statusCheck($insertData);
        if(empty($getStatus)){
            $getStatusId = $this->common->insertTableData('tb_stop_status', $insertData);
            $status= (!empty($getStatusId)) ? 1 :0;
            $this->saveEdiLogs($orderData, $response, $status);
            return !empty($getStatusId);
        }
        return $this->common->updatetbledata(
            'tb_stop_status',
            $insertData,
            [
                'id' => $getStatus['id']
            ]
        );
    }
    private function driverAccept(array $orderData){

        if ($orderData['trip_id']==='0') {
            auupdatestatusbymanifest(
                $orderData['id'],
                $orderData['pickup_datetime']);
        }
    }

    private function tripClose(array $response, array $orderData){

        $this->common->updatetbledata('tb_bexedi',
            [ "status" => 0, 'res_status' => $response['Status']],
            [ "order_id" => $orderData['id']]);
        $this->common->updatetbledata('tb_orders',
            [ "trip_sts" => 1],
            [ "id" => $orderData['id']]);
        $this->common->updatetbledata('tb_shifts',
            [ "status" => 0],
            [  "id" => $orderData['shift_id']]);

        $this->common->updatetbledata('tb_trips',
            [ "status" => 0],
            [  "id" => $orderData['trip_id']]);
    }

    public function saveEdiLogs($orderData, $response, $status)
    {
        $this->edilogtransactions([
            'user_id'=>$orderData['user_id'] ?? 0,
            'company_code'=>$orderData['company_code'] ?? '',
            'branch_code'=>$orderData['branch_code'] ?? '',
            'vendor_id'=>$orderData['vendor_id'] ?? '',
            'obj_type_name'=>$response['status'] ?? '',
            'status'=>$status,
            'order_id'=>$orderData['order_id'] ?? 0,
            'request'=>($this->getConsignmentNote($orderData['id'])) ?? '0',
            'response'=> json_encode($response, JSON_THROW_ON_ERROR),
        ]);
    }
    private function statusCheck($where){
        unset($where['reason'],$where['latitude'],$where['longitude'],
            $where['createdon']);
        $getStatusData = $this->common->gettblrowdata(
            $where,
            "id",
            "tb_stop_status",
            0,
            0
        );
        return (!empty($getStatusData)) ? $getStatusData : [];
    }

    /**
     * @throws JsonException
     */
    private function getStatusInsertArray(array $orderData,array $tripData, array $response,string $statusCode,string $statusType): array
    {
        $vehicleData=$this->getLatLang($tripData);
        $statusData=$this->getStatusId($statusCode);
        $stopData=$this->getStopsData($statusType,$orderData);
        $createdOn = date('Y-m-d H:i:s');
        if (!empty($response['StatusChanged'])) {
            $createdOn = date('Y-m-d H:i:s', strtotime($response['StatusChanged']));
        }
        return [
            'order_id' => (!empty($orderData['id'])) ? $orderData['id'] : 0,
            'shipment_id' => (!empty($orderData['shift_id'])) ? $orderData['shift_id'] : 0,
            'trip_id' => (!empty($orderData['trip_id'])) ? $orderData['trip_id'] : 0,
            'status' => 1,
            'reason' => 'From Border Express',
            'latitude' => $vehicleData['latitude'] ?? '',
            'longitude' => $vehicleData['longitude'] ?? '',
            'createdon' => $createdOn,
            'driver_id' => (!empty($tripData['driver_id'])) ? $tripData['driver_id'] : 0,
            'vehicle_id' => (!empty($tripData['vehicle_id'])) ? $tripData['vehicle_id'] : 0,
            'stop_id' => (!empty($stopData['id'])) ? $stopData['id'] : 0,
            'stop_detail_id' => 0,
            'stop_type' => $statusType ?? '',
            'status_id' => (!empty($statusData['id'])) ? $statusData['id'] : '',
            'status_code' => $statusCode ?? ''
        ];
    }

    private function getOrderData(string $orderId): array
    {
        if(empty($orderId)){
            return [];
        }
        $getOrderData= $this->common->gettblrowdata(array(
            'id' => $orderId
        ), 'id,order_id,shift_id,trip_id,pickup_pincode,delivery_pincode,
        plat,plng,dlat,dlng,vendor_id,user_id,company_code,branch_code,pickup_datetime',
            'tb_orders', 0, 0);
        return (!empty($getOrderData)) ? $getOrderData : [];
    }

    private function getTriData(array $orderData): array
    {
        if(empty($orderData)){
            return [];
        }
        $getTripData = $this->common->gettblrowdata(
            ['shift_id' => $orderData['shift_id']],
            "vehicle_id,driver_id",
            "tb_trips",
            0,
            0
        );
        return (!empty($getTripData)) ? $getTripData : [];
    }
    /**
     *  get the recent lat lng values from tb_trucks_data
     */
    private function getLatLang(array $tripData): array
    {

        if (empty($tripData['vehicle_id'])) {
            return [];
        }
        $getLatLang = $this->common->gettblrowdata(
            ['id' => $tripData['vehicle_id']],
            'latitude,longitude',
            'tb_trucks_data',
            0,
            0
        );
        return (!empty($getLatLang)) ? $getLatLang : [];

    }

    private function getStatusId(string $code): array
    {
        $statusData = $this->common->gettblrowdata(
            ["status_code" => $code,
                'status' => 1], 'id,status_code', 'tb_status_master', 0, 0);
        return (!empty($statusData)) ? $statusData : [];
    }

    private function getStopsData(string $stopType,array $orderData): array
    {

        $stopData = $this->common->gettblrowdata(
            ["shipment_id" => $orderData['shift_id'],
                'stoptype' => $stopType,
                "status" => 1], 'id', 'tb_shiporder_stops', 0, 0);
        return (!empty($stopData)) ? $stopData : [];
    }

    private function getBexTableId(string $orderId): array
    {
        $getBexTableId = $this->common->gettblrowdata([
            'req_type' => 'current_status',
            'order_id' => $orderId
        ], 'id', 'tb_bexedi', 0, 0);
        return (!empty($getBexTableId)) ? $getBexTableId : [];
    }

    public function consignmentinfo_old($ordid)
    {
        $log_edi_arr = array();
        $createdon = date('Y-m-d H:i:s');
        $curtz = "Australia/Sydney";
        $code = '0';
        $status_id = 0;
        $order_details = $this->common->gettblrowdata(array(
            'order_row_id' => $ordid
        ), 'order_id,consignment_note', 'tb_order_details', 0, 0);
        if (empty($order_details)) {
            log_message(
                'error',
                'BorderEdi_consignmentInfo:emptyConsignmentNote:' .
                'order_id:' . $ordid
            );
        }
        if (! empty($order_details) && ! empty($order_details['consignment_note'])) {
            $log_edi_arr['request'] = $order_details['consignment_note'];
            $apiurl = BORDER_API . '/api/v1/consignments/' . $order_details['consignment_note'];
            $res = requestborderapi($apiurl);

            if ($res == "401" || $res == 'expired') {
                $res = requestborderapi($apiurl);
            }

            $log_edi_arr['response'] = $res;
            $response = (array) (json_decode($res));
            $logStatus=$response['Status'] ?? 'emptyStatus';
            log_message(
                'error',
                'BorderEdi_consignmentInfo:' .
                'DeliveryNote:' . $order_details['consignment_note'] .
                ':order_id:' . $ordid .
                ':status:' . $logStatus .
                ':TimesTamp:' . $createdon
            );
            if($logStatus==='emptyStatus'){
                log_message(
                    'error',
                    'BorderEdi_consignmentInfo:' .
                    'response:' . json_encode($response, JSON_THROW_ON_ERROR)
                );
            }
            $order_row_id = $ordid;
            $order = $this->common->gettblrowdata(array(
                'id' => $order_row_id
            ), 'order_id,shift_id,trip_id,pickup_pincode,delivery_pincode,plat,plng,dlat,dlng,vendor_id,user_id,company_code,branch_code', 'tb_orders', 0, 0);
            /* edi log array */
            if (! empty($order)) {
                $log_edi_arr['order_id'] = $order['order_id'];
                $log_edi_arr['user_id'] = $order['user_id'];
                $log_edi_arr['company_code'] = $order['company_code'];
                $log_edi_arr['branch_code'] = $order['branch_code'];
                $log_edi_arr['vendor_id'] = $order['vendor_id'];
                $log_edi_arr['status'] = 0;
            }
            $edists = isset($response['Status']) ? $response['Status'] : "";
            $edidata = array(
                "status" => $edists,
                "txn_obj_id" => $order_details['order_id'],
                'bounded_type' => 2,
                'edi_type' => 1,
                'transaction_id' => time(),
                'edi_id' => 7,
                'edi_name' => 'BORDER EXPRESS',
                'edi_format_type' => 'XML',
                'obj_type' => 1,
                'user_id' => $order['user_id'],
                'company_code' => $order['company_code'],
                'branch_code' => $order['branch_code'],
                "edi_request" => $order_details['consignment_note'],
                "edi_response" => $res
            );
            if (! empty($response)) {
                $status = "";
                if (isset($response['Status'])) {
                    $status = $response['Status'];
                    $dt = date('Y-m-d H:i:s');
                    $insert = array(
                        'req_type' => 'current_status',
                        'response' => $res,
                        'apiurl' => $apiurl,
                        'order_id' => $ordid,
                        'res_status' => $status,
                        'vendor_type' => 1,
                        'status' => 1,
                        'updatedon' => $dt
                    );
                    $check = $this->common->gettblrowdata(array(
                        'req_type' => 'current_status',
                        'order_id' => $ordid
                    ), 'id', 'tb_bexedi', 0, 0);
                    if (! empty($check)) {
                        $id = $this->common->updatetbledata('tb_bexedi', array(
                            'response' => $res
                        ), array(
                            'req_type' => 'current_status',
                            'order_id' => $ordid
                        ));
                    } else {
                        $insert['createdon'] = $dt;
                        $id = $this->common->insertTableData('tb_bexedi', $insert);
                    }
                }

                if ($response['Status'] != '404') {


                    if (isset($response['StatusChanged'])) {
                        if ($response['StatusChanged'] != "") {
                            $createdon = date('Y-m-d H:i:s', strtotime($response['StatusChanged']));
                        }
                    }
                    $log_edi_arr['status'] = 1;
                    $stop_type = "P";
                    $status_name = "";
                    if ($status == 'Unsaved') {
                        $log_edi_arr['obj_type_name'] = 'UNSAVED';
                        $status_name = 'Unsaved';
                        $stop_type = "P";
                    } else if ($status == 'Despatched') {

                        $status_name = 'Pickup Or Drop';
                        $stop_type = "P";
                        /*
                         * driver accept checking
                         */
                        $this->load->helper('bonds_helper');
                        $au_trip_check = $this->common->gettblrowdata(array(
                            'id' => $order_row_id,
                            'trip_id' => 0
                        ), 'id', 'tb_orders', 0, 0);

                        if (! empty($au_trip_check)) {
                            $au_res_accept = auupdatestatusbymanifest($au_trip_check['id'], $createdon);
                            $log_edi_arr['obj_type_name'] = 'Accepted-by-Driver';
                            $this->edilogtransactions($log_edi_arr);
                        }
                        $code = '0500';
                        $log_edi_arr['obj_type_name'] = 'PICKUP';
                    } else if ($status == 'In Transit') {
                        $log_edi_arr['obj_type_name'] = 'IN-TRANSIT';
                        $status_name = 'Actual Transit Location';
                        $stop_type = "P";
                        $code = '1550';
                    } else if ($status == 'On Board') {
                        $log_edi_arr['obj_type_name'] = 'ON-BOARD';
                        $status_name = 'Gate Out';
                        $stop_type = "P";
                        $code = '0191';
                    } else if ($status == 'On Board for Delivery') {
                        $log_edi_arr['obj_type_name'] = 'ON-BOARD-FOR-DELIVERY';
                        $status_name = 'Gate OUT';
                        $stop_type = "P";
                        $code = '0191';
                    } else if ($status == 'Delivered') {
                        /*
                       * driver accept checking
                       */
                        $this->load->helper('bonds_helper');
                        $getOrderData = $this->common->gettblrowdata(array(
                            'id' => $order_row_id,
                            'trip_id' => 0
                        ), 'id,pickup_datetime', 'tb_orders', 0, 0);
                        if (! empty($getOrderData)) {
                            auupdatestatusbymanifest(
                                $order_row_id,
                                $getOrderData['pickup_datetime']);
                        }
                        $log_edi_arr['obj_type_name'] = 'DELIVERED';
                        $status_name = 'Delivered to Consignee';
                        $stop_type = "D";
                        $code = '3000';
                    }

                    $location = '';
                    $shipment_id = $stop_id = $stop_detail_id = $trip_id = $status_id = $lat = $lng = $status_code = $status = $driver_id = $vehicle_id = 0;
                    /* getting status code and id from status master */
                    $select = "id,status_code";
                    $table = "tb_status_master";
                    if (! empty($code)) {
                        $where = array(
                            "status_code" => $code,
                            'status' => 1
                        );
                        $statusinfo = $this->common->gettblrowdata($where, $select, $table, 0, 0);
                        if (count($statusinfo) > 0) {
                            $status_id = $statusinfo['id'];
                        }
                    } else {
                        $where = array(
                            "status_name" => $status_name,
                            'status' => 1
                        );
                        $statusinfo = $this->common->gettblrowdata($where, $select, $table, 0, 0);
                        if (count($statusinfo) > 0) {
                            $status_id = $statusinfo['id'];
                            $code = $statusinfo['status_code'];
                        }
                    }
                    $reason = 'From Border Express';
                    /* Getting vehicle and driver from trips table */
                    $where = array(
                        'shift_id' => $order['shift_id']
                    );
                    $select = "vehicle_id,driver_id";
                    $table = "tb_trips";
                    $dvinfo = $this->common->gettblrowdata($where, $select, $table, 0, 0);
                    if (count($dvinfo) > 0) {
                        $driver_id = $dvinfo['driver_id'];
                        $vehicle_id = $dvinfo['vehicle_id'];
                    }
                    /* getting stop data */
                    $select = "id";
                    $table = "tb_shiporder_stops";
                    $where = array(
                        "shipment_id" => $order['shift_id'],
                        'stoptype' => $stop_type,
                        "status" => 1
                    );
                    $stopidinfo = $this->common->gettblrowdata($where, $select, $table, 0, 0);
                    if (count($stopidinfo) > 0) {
                        $stop_id = $stopidinfo['id'];
                    }
                    /* get the recent lat lng values from tb_trucks_data */
                    if (! empty($vehicle_id)) {
                        $this->db->select('latitude,longitude');
                        $this->db->where('id', $vehicle_id);
                        $veh_qry = $this->db->get('tb_trucks_data');
                        if ($veh_qry->num_rows() == 0) {
                            $lat = $veh_qry->row()->latitude;
                            $lng = $veh_qry->row()->longitude;
                        }
                    }
                    $innr_array = array(
                        'order_id' => $order_row_id,
                        'shipment_id' => $order['shift_id'],
                        'stop_id' => $stop_id,
                        'stop_detail_id' => $stop_detail_id,
                        'stop_type' => $stop_type,
                        'trip_id' => $order['trip_id'],
                        'status_id' => $status_id,
                        'status_code' => $code,
                        'status' => 1,
                        'reason' => $reason,
                        'latitude' => $lat,
                        'longitude' => $lng,
                        'createdon' => $createdon,
                        'loc_name' => $location,
                        'driver_id' => $driver_id,
                        'vehicle_id' => $vehicle_id
                    );
                    $check_array = array(
                        'order_id' => $order_row_id,
                        'shipment_id' => $order['shift_id'],
                        'stop_id' => $stop_id,
                        'stop_detail_id' => $stop_detail_id,
                        'stop_type' => $stop_type,
                        'trip_id' => $order['trip_id'],
                        'status_id' => $status_id,
                        'status_code' => $code,
                        'loc_name' => $location,
                        'driver_id' => $driver_id,
                        'vehicle_id' => $vehicle_id
                    );
                    $chk_qry = $this->db->select("id")->get_where('tb_stop_status', $check_array);

                    if ($chk_qry->num_rows() == 0) {
                        $stsins = $this->db->insert('tb_stop_status', $innr_array);

                        $this->edilogtransactions($log_edi_arr);
                    } else {
                        $stsins = $this->db->where_in("id", array(
                            "id" => $chk_qry->row()->id
                        ))
                            ->update("tb_stop_status", $innr_array);
                    }
                    /* check trip close */
                    if ($status_name == "Delivered to Consignee") {
                        $upd = $this->common->updatetbledata("tb_bexedi", array(
                            "status" => 0,
                            'res_status' => $response['Status']
                        ), array(
                            "order_id" => $order_row_id
                        ));
                        $upd = $this->common->updatetbledata("tb_orders", array(
                            "trip_sts" => 1
                        ), array(
                            "id" => $order_row_id
                        ));
                        log_message('error', 'BorderEdi_consignmentInfo:OrderUpdate:' . $this->db->last_query());
                        $upd = $this->common->updatetbledata("tb_shifts", array(
                            "status" => 0
                        ), array(
                            "id" => $order['shift_id']
                        ));
                        $upd = $this->common->updatetbledata("tb_trips", array(
                            "status" => 0
                        ), array(
                            "id" => $order['trip_id']
                        ));
                        /* Generated Summary */
                        $curtz = "";
                        $user = $this->db->select("id,country_code")
                            ->get_where("tb_users", [
                                "id" => $order['user_id']
                            ], 1, 0)
                            ->row_array();
                        $tz = getUserTimeZone($user['country_code']);
                        $curtz = $tz['timezone'];
                        $gensum = $this->generatesummary($order['trip_id'], $curtz);
                    }
                }
            }
        }
    }

    public function updateOrderInfo($order_row_id, $createdon = null){
        if(empty($order_row_id) || empty($createdon)){
            echo "Invalid argument";
            return false;
        }else{
            $this->load->helper('bonds_helper');
            auupdatestatusbymanifest($order_row_id, urldecode($createdon));
        }
    }

    public function statusHistory($ordid)
    {
        $order_details = $this->common->gettblrowdata(array(
            'order_row_id' => $ordid
        ), 'consignment_note', 'tb_order_details', 0, 0);
        if (! empty($order_details) && ! empty($order_details['consignment_note'])) {
            $apiurl = BORDER_API . '/api/v1/consignments/' . $order_details['consignment_note'] . '/Statuses';
            $res = requestborderapi($apiurl);
            if ($res == "401") {
                $res = requestborderapi($apiurl);
            } else if ($res == 'expired') {
                $res = requestborderapi($apiurl);
            }
            $response = (array) (json_decode($res));
            $order_row_id = $ordid;
            $order = $this->common->gettblrowdata(array(
                'id' => $order_row_id
            ), 'order_id,user_id,company_code,branch_code', 'tb_orders', 0, 0);
            $edists = isset($response['Status']) ? $response['Status'] : "";
            $edidata = array(
                "status" => $edists,
                "txn_obj_id" => $order['order_id'],
                'bounded_type' => 2,
                'edi_type' => 1,
                'transaction_id' => time(),
                'edi_id' => 7,
                'edi_name' => 'BORDER EXPRESS',
                'edi_format_type' => 'XML',
                'obj_type' => 1,
                'user_id' => $order['user_id'],
                'company_code' => $order['company_code'],
                'branch_code' => $order['branch_code'],
                "edi_request" => $order_details['consignment_note'],
                "edi_response" => $res
            );
            if (! empty($response)) {
                $status = "";
                if (isset($response['Status'])) {
                    $status = $response['Status'];
                } else if (isset($response['Statuses'])) {
                    $resp = isset($response['Statuses'][0]) ? $response['Statuses'][0] : "";
                    $status = isset($resp['Status']) ? $resp['Status'] : "";
                }
                if ($status != "") {
                    $dt = date('Y-m-d H:i:s');
                    $insert = array(
                        'req_type' => 'status_history',
                        'response' => $res,
                        'apiurl' => $apiurl,
                        'order_id' => $ordid,
                        'res_status' => $status,
                        'vendor_type' => 1,
                        'status' => 1,
                        'createdon' => $dt,
                        'updatedon' => $dt
                    );
                    $id = $this->common->insertTableData('tb_bexedi', $insert);
                }
            }
        }
    }

    public function getpod($ordid)
    {
        $log_edi_arr = array();
        $order_details = $this->common->gettblrowdata(array(
            'order_row_id' => $ordid
        ), 'consignment_note', 'tb_order_details', 0, 0);

        if (! empty($order_details) && ! empty($order_details['consignment_note'])) {
            $log_edi_arr['request'] = $order_details['consignment_note'];

            $apiurl = BORDER_API . '/api/v1/consignments/' . $order_details['consignment_note'] . '/pods/PDF?base64=true';
            $res = requestborderapi($apiurl);
            if ($res == "401" || $res == 'expired') {
                $res = requestborderapi($apiurl);
            }

            /* Get pod information like pod date and receiver name  */

            $dt = date('Y-m-d H:i:s');
            $receiver_name='';
            $getdataapiurl = BORDER_API . '/api/v1/consignments/' . $order_details['consignment_note'] . '/pods/Metadata?wrap=false';
            $get_pod_info_res = requestborderapi($getdataapiurl);
            if ($get_pod_info_res == "401" || $get_pod_info_res == 'expired') {
                $get_pod_info_res = requestborderapi($getdataapiurl);
            }
            $get_info_res = (array)json_decode($get_pod_info_res);
            $get_Connote=isset($get_info_res[0]->ConnoteNumber)?$get_info_res[0]->ConnoteNumber:'';
            if((isset($get_info_res[0]->DateSigned)) && (!empty($get_info_res[0]->DateSigned))){
                $newdate=date('Y-m-d H:i:s', strtotime($get_info_res[0]->DateSigned));
                $curtz = "Australia/Sydney";
                $utc = "UTC";
                $getactual = getdatetimebytimezone($utc, $newdate, $curtz);
                $dt = $getactual['datetime'];
            }
            if((isset($get_info_res[0]->SignedBy)) && (!empty($get_info_res[0]->SignedBy))){
                $receiver_name=$get_info_res[0]->SignedBy;
            }

            $log_edi_arr['response'] = $res;
            if(is_array($get_info_res) && !empty($get_info_res)){
                $get_info_res['ImgBase64']=$res;
                $log_edi_arr['response'] = json_encode($get_info_res);
            }

            /* end pod info */

            $log_edi_arr['obj_type_name'] = 'ePOD';
            $order = $this->common->gettblrowdata(array(
                'id' => $ordid
            ), 'order_id,user_id,shift_id,trip_id,company_code,branch_code,vendor_id', 'tb_orders', 0, 0);
            $edists = isset($response['Status']) ? $response['Status'] : "";
            $edidata = array(
                "status" => 'ePOD',
                "txn_obj_id" => $order['order_id'],
                'bounded_type' => 2,
                'edi_type' => 1,
                'transaction_id' => time(),
                'edi_id' => 7,
                'edi_name' => 'BORDER EXPRESS',
                'edi_format_type' => 'XML',
                'obj_type' => 1,
                'user_id' => $order['user_id'],
                'company_code' => $order['company_code'],
                'branch_code' => $order['branch_code'],
                "edi_request" => $order_details['consignment_note'],
                "edi_response" => $res
            );
            $log_edi_arr['status'] = 0;
            if ($res != "" && $res != "404") {
                $log_edi_arr['status'] = 1;
                $status = "";
                $res1 = json_decode($res);

                if (isset($res1->Base64)) {
                    $res2 = $res1->Base64;
                    $pod_base64 = "./assets/border_epod.txt";
                    $decoded = base64_decode(preg_replace('#^data:application/pdf/\w+;base64,#i', '', $res2));
                    $curdt = date("YmdHis");
                    $file_name = $order_details['consignment_note'] . '_' . $curdt . '.pdf';
                    $file1 = NEW_POD_PATH . $file_name;
                    $imageSize = filesize($file1);
                    file_put_contents($file1, $decoded);
                    $shipment_id = $stop_id = $stop_detail_id = $trip_id = $status_id = $latitude = $longitude = $status_code = $status = $vehicle_id = $driver_id = 0;
                    if (count($order) > 0) {

                        $log_edi_arr['order_id'] = $order['order_id'];
                        $log_edi_arr['user_id'] = $order['user_id'];
                        $log_edi_arr['company_code'] = $order['company_code'];
                        $log_edi_arr['branch_code'] = $order['branch_code'];
                        $log_edi_arr['vendor_id'] = $order['vendor_id'];

                        $shipment_id = $order['shift_id'];
                        $trip_id = $order['trip_id'];
                        $user_id = $order['user_id'];
                        $select = "id";
                        $table = "tb_shiporder_stops";
                        $where = array(
                            "shipment_id" => $shipment_id,
                            'stoptype' => 'D',
                            "status" => 1
                        );
                        $stopidinfo = $this->common->gettblrowdata($where, $select, $table, 0, 0);
                        if (count($stopidinfo) > 0) {
                            $stop_id = $stopidinfo['id'];
                        }
                        $select = "id";
                        $table = "tb_employee";
                        $where = array(
                            "shift_id" => $shipment_id,
                            "status" => 1
                        );
                        $stop_detail_idinfo = $this->common->gettblrowdata($where, $select, $table, 0, 0);
                        if (count($stop_detail_idinfo) > 0) {
                            $stop_detail_id = $stop_detail_idinfo['id'];
                        }
                        $doc_type = 3;
                        $chqry = $this->db->select("latitude,longitude")->get_where("tb_stop_status", array(
                            "order_id" => $ordid
                        ), 1, 0);
                        $lati = $long = '';
                        if ($chqry->num_rows() > 0) {
                            $lati = $chqry->row()->latitude;
                            $long = $chqry->row()->longitude;
                        }
                        $newUuid = $this->uuid->v4();
                        $inrdata = [
                            'stop_id' => $stop_id,
                            "shipment_id" => $shipment_id,
                            'trip_id' => $trip_id,
                            'doc_type' => $doc_type,
                            'imgpath' => $file_name,
                            'stop_type' => 'D',
                            'order_id' => $ordid,
                            'status' => 1,
                            'createdon' => $dt,
                            'latitude' => $lati,
                            'longitude' => $long,
                            'receiver_name' => $receiver_name,
                            'user_id' => $user_id,
                            'createdby' => $user_id,
                            'filesize' => $imageSize,
                            'hash' => $newUuid
                        ];
                        $check_data = [
                            'stop_id' => $stop_id,
                            "shipment_id" => $shipment_id,
                            'trip_id' => $trip_id,
                            'doc_type' => $doc_type,
                            'stop_type' => 'D',
                            'order_id' => $ordid
                        ];
                        $chk_qry = $this->db->select("id")->get_where('tb_pod_uploads', $check_data);
                        if ($chk_qry->num_rows() == 0) {
                            $this->common->insertTableData('tb_pod_uploads', $inrdata);

                            $this->edilogtransactions($log_edi_arr);

                            $status = "ePOD";
                        }
                    }
                }
                if ($status != "") {
                    $insert = array(
                        'req_type' => 'pod',
                        'response' => $file_name,
                        'apiurl' => $apiurl,
                        'order_id' => $ordid,
                        'res_status' => $status,
                        'vendor_type' => 1,
                        'status' => 1,
                        'createdon' => $dt,
                        'updatedon' => $dt
                    );
                    $id = $this->common->insertTableData('tb_bexedi', $insert);
                }
            }
        }
    }

    public function podlist($ordid)
    {
        $order_details = $this->common->gettblrowdata(array(
            'order_row_id' => $ordid
        ), 'consignment_note', 'tb_order_details', 0, 0);
        if (! empty($order_details) && ! empty($order_details['consignment_note'])) {
            $apiurl = BORDER_API . '/api/v1/consignments/' . $order_details['consignment_note'] . '/pods/metadata';
            $res = requestborderapi($apiurl);
            if ($res == "401") {
                $res = requestborderapi($apiurl);
            } else if ($res == 'expired') {
                $res = requestborderapi($apiurl);
            }
            $response = (array) (json_decode($res));
            $status = $response['Id'];
            $dt = date('Y-m-d H:i:s');
            $insert = array(
                'req_type' => 'podlist',
                'response' => $res,
                'apiurl' => $apiurl,
                'order_id' => $ordid,
                'res_status' => $status,
                'vendor_type' => 1,
                'status' => 1,
                'createdon' => $dt,
                'updatedon' => $dt
            );
            $id = $this->common->insertTableData('tb_bexedi', $insert);
        }
    }

    public function generatesummary($tripid = null, $curtz = null)
    {
        if ($tripid != "") {
            $dist = $trip_type = $totalemp = $uid = 0;
            if ($curtz == "") {
                $curtz = date_default_timezone_get();
            }
            $logdate = date('Y-m-d H:i:s');
            $getactual = getdatetimebytimezone(DFLT_TZ, $logdate, $curtz);
            $curdt = $getactual['datetime'];
            $reg = "";
            $where = ['id' => $tripid, 'status' => 0];
            $this->db->select("
                shift_id,
                vehicle_id,
                driver_id,
                convertToClientTZ(stime,'" . $curtz . "') as stime,
                convertToClientTZ(etime,'" . $curtz . "') as etime,
                etime as tetime,
                start_imei,
                end_imei,
                start_reading,
                end_reading,
                trip_type,
                plat,
                plng
            ");
            $this->db->where($where);
            $this->db->limit(1);
            $sql = $this->db->get('tb_trips');
            if ($sql->num_rows() > 0) {
                $data = array();
                $data['driver_name'] = $data['driver_num'] = "";
                $shift = $sql->row()->shift_id;
                $this->db->select("
                    user_id,
                    stime as setime,
                    convertToClientTZ(startdate,'" . $curtz . "') as startdate,
                    convertToClientTZ(enddate,'" . $curtz . "') as enddate,
                    splace,
                    eplace,
                    elat,
                    elng
                ");
                $this->db->where('id', $shift);
                $this->db->limit(1);
                $sql1 = $this->db->get('tb_shifts');
                $data["trip"] = $sql1->row();
                $this->db->select("IFNULL(SUM(IF(e.status='1',1,0)),0) AS attcnt,
                count(e.employee_id) AS totcnt");
                $this->db->where('e.trip_id', $tripid);
                $emp = $this->db->get('tb_trip_employee');
                $start = $sql->row()->stime;
                $end = $sql->row()->etime;
                $imei = $sql->row()->start_imei;
                $eimei = $sql->row()->end_imei;
                $driverid = $sql->row()->driver_id;
                $vehicleid = $sql->row()->vehicle_id;
                $stime = $sql1->row()->startdate;
                $etime = $sql1->row()->enddate;
                $uid = $sql1->row()->user_id;
                $odometer_start = trim($sql->row()->start_reading);
                $odometer_end = trim($sql->row()->end_reading);
                $trip_type = $sql->row()->trip_type;
                $vendor_id = 0;
                $dlat = $dlng = "";
                $this->db->select("truck_capacity,register_number,vendor_id,truck_weight,truck_volume,latitude,longitude");
                $this->db->where('id', $vehicleid);
                $this->db->limit(1);
                $trucks_query = $this->db->get('tb_trucks_data');
                $cab_capacity = $truck_weight = $truck_volume = 0;
                if ($trucks_query->num_rows() > 0) {
                    $cab_capacity = $trucks_query->row()->truck_capacity;
                    $reg = $trucks_query->row()->register_number;
                    $vendor_id = $trucks_query->row()->vendor_id;
                    $truck_weight = $trucks_query->row()->truck_weight;
                    $truck_volume = $trucks_query->row()->truck_volume;
                    $dlat = $trucks_query->row()->latitude;
                    $dlng = $trucks_query->row()->longitude;
                }
                if ($dlat == "") {
                    $dlat = $sql->row()->plat;
                    $dlng = $sql->row()->plng;
                }
                if ($dlat == $sql->row()->plat) {
                    $dlat = $sql1->row()->elat;
                    $dlng = $sql1->row()->elng;
                }
                /* update end lat lng in trips */
                $whrtrip = array(
                    "id" => $tripid
                );
                $settrip = array(
                    "dlat" => $dlat,
                    "dlng" => $dlng
                );
                $upd = $this->db->where($whrtrip)->update("tb_trips", $settrip);
                $vtripinfo = array(
                    "plat" => $sql->row()->plat,
                    "plng" => $sql->row()->plng,
                    "dlat" => $dlat,
                    "dlng" => $dlng
                );
                $data['tripinfo'] = (object) $vtripinfo;
                if ($cab_capacity == "") {
                    $cab_capacity = 0;
                }
                $regg = $this->db->query("select name,contact_num,vendor_id from tb_truck_drivers WHERE id=$driverid LIMIT 1");
                if ($regg->num_rows() > 0) {
                    $data['driver_name'] = $regg->row()->name;
                    $data['driver_num'] = $regg->row()->contact_num;
                    $vnid = $regg->row()->vendor_id;
                    if ($vendor_id == 0 && $vnid != 0) {
                        $vendor_id = $vnid;
                    }
                }
                $where = ['mobileimei' => $imei, 'timestamp <='=>$end, 'timestamp >=' => $start];
                $this->db->select("latitude,longitude,convertToClientTZ(`timestamp`,'" . $curtz . "') as timestamp");
                $this->db->where($where);
                $this->db->order_by('timestamp', 'ASC');
                $sql2 = $this->db->get('tb_rtdrive_locations');
                $flag = 0;
                $lat = $lng = 0;
                $wflag = 0;
                $dist = 0;
                if ($sql2->num_rows() > 0) {
                    foreach ($sql2->result() as $row) {
                        if ($flag == 0) {
                            $flag = 1;
                        } else {
                            $a = calculateDistance12($lat, $lng, $row->latitude, $row->longitude);
                            $dist = $dist + $a;
                        }
                        $lat = $row->latitude;
                        $lng = $row->longitude;
                    }
                }
                $attendemp = 1;
                $totalemp = getempcount($tripid);
                if ($emp->num_rows() > 0) {
                    $attendemp = $emp->row()->attcnt;
                }
                $data["noofemp"] = $totalemp;
                $driver_late = 0.00;
                $setime = date("Y-m-d H:i:s", strtotime($sql1->row()->setime));
                $tetime = date("Y-m-d H:i:s", strtotime(date("H:i:s", strtotime($sql->row()->tetime))));
                $to_time = strtotime($setime);
                $from_time = strtotime($tetime);
                if ($from_time > $to_time) {
                    $driver_late = round(abs($from_time - $to_time) / 60, 2);
                }
                $arr = array(
                    'trip_id' => $tripid,
                    'vehicle_id' => $vehicleid,
                    'driver_id' => $driverid,
                    'vendor_id' => $vendor_id,
                    'trip_distance' => $dist,
                    'no_of_emp' => $totalemp,
                    'attended_emp' => $attendemp,
                    'start_imei' => $imei,
                    'end_imei' => $eimei,
                    'start_time' => $stime,
                    'end_time' => $etime,
                    'user_id' => $uid,
                    'cab_capacity' => $cab_capacity,
                    'trip_status' => 1,
                    'trip_type' => $trip_type,
                    'ship_delay' => $driver_late,
                    'createdon' => $curdt
                );
                $chktrip = $this->db->select("id")->get_where("tb_trip_summary", array(
                    "trip_id" => $tripid
                ), 1, 0);
                if ($chktrip->num_rows() == 0) {
                    $res = $this->db->insert("tb_trip_summary", $arr);
                }
            }
        }
    }

    public function bookingapi($ordid)
    {
        $this->load->library('Border_lib');
        $this->border_lib->borderBooking(array(
            'ordid' => $ordid
        ));
    }

    public function gettoken()
    {
        $curl = curl_init();
        curl_setopt_array($curl, array(
            CURLOPT_URL => "https://integrationapi.borderexpress.com.au/token",
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 30,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_SSL_VERIFYPEER => false,
            CURLOPT_CUSTOMREQUEST => "POST",
            CURLOPT_POSTFIELDS => "grant_type=client_credentials&client_id=989a8593.6e12.4754.bbca.c53d637a6a86&client_secret=".BORDER_CLIENT_SECRET,
            CURLOPT_HTTPHEADER => array(
                "content-type: application/x-www-form-urlencoded"
            )
        ));
        if (ENVIRONMENT !== "development") {
            curl_setopt($curl, CURLOPT_PROXY, PROXY_CONSTANT_HERE);
        }

        $response = curl_exec($curl);
        $err = curl_error($curl);
        curl_close($curl);
        if ($err) {
            echo "cURL Error #:" . $err;
        } else {
            echo $response;
        }
    }

    /*
     * BONDS TRANSPORT and BONDS DC request and response saved log transactions
     */
    private function edilogtransactions($data)
    {
        /* log_message('error', json_encode($data) . ":::----data------>"); */
        $user_id = isset($data['user_id']) ? $data['user_id'] : 0;
        $company_code = isset($data['company_code']) ? $data['company_code'] : "AUKN";
        $branch_code = isset($data['branch_code']) ? $data['branch_code'] : "";
        $ins_edi = $ins_obj_edi = array();
        $edi_id = $edi_name = $object_id = "";
        /*
         * Get vendor name
         */
        $vendors_res = $this->db->select("name")
            ->from('tb_vendors')
            ->where(array(
                'id' => isset($data['vendor_id']) ? $data['vendor_id'] : 0,
                'company_code' => 'AUKN',
                'status' => 1
            ))
            ->get();
        $vendor_name = "BONDS";
        if ((! empty($vendors_res)) && ($vendors_res->num_rows() > 0)) {
            $ven_result = $vendors_res->row_array();
            $vendor_name = $ven_result['name'];
        }
        /*
         * Get edi_name from tb_edi_types table if edi name is not exists insert edi name
         */
        $edi_types = $this->db->select("id,edi_name")
            ->from('tb_edi_types')
            ->where(array(
                'status' => '1'
            ))
            ->like(array(
                'edi_name' => $vendor_name
            ))
            ->get();
        if ((! empty($edi_types)) && ($edi_types->num_rows() > 0)) {
            $edi_result = $edi_types->row_array();
            $edi_name = $edi_result['edi_name'];
            $edi_id = $edi_result['id'];
        } else {
            $edi_name = $vendor_name;
            $ins_edi['edi_name'] = $edi_name;
            $edi_id = $this->common->insertTableData('tb_edi_types', $ins_edi);
        }
        /*
         * Get edi object from tb_edi_object_types table if edi object is not exists insert edi object
         */
        $obj_type_name = (isset($data['obj_type_name']) && ! empty($data['obj_type_name'])) ? $data['obj_type_name'] : "order-id";
        $object_types = $this->db->select("id,obj_type_name")
            ->from('tb_edi_object_types')
            ->where(array(
                'status' => '1'
            ))
            ->like(array(
                'obj_type_name' => $obj_type_name
            ))
            ->get();
        if ((! empty($object_types)) && ($object_types->num_rows() > 0)) {
            $edi_obj_result = $object_types->row_array();
            $object_id = $edi_obj_result['id'];
        } else {
            $ins_obj_edi['obj_type_name'] = $obj_type_name;
            $ins_obj_edi['description'] = "bounds carrier Status types";
            $object_id = $this->common->insertTableData('tb_edi_object_types', $ins_obj_edi);
        }
        $sts = isset($data['status']) ? ($data['status']) : 0;
        $params = array(
            'edi_type' => 2, // '1->EDI Transport Order,2->EDI Status'
            'transaction_id' => time(),
            'edi_id' => isset($edi_id) ? $edi_id : 0, // edi id based on name take it from tb_edi_types
            'edi_name' => isset($edi_name) ? $edi_name : "BONDS",
            'bounded_type' => 1, // '1->Inbound(partner => kN),2->Outbound (KN => partner)'
            'edi_format_type' => 'XML',
            'status' => isset($sts) ? $sts : "0",
            'obj_type' => isset($object_id) ? $object_id : "0",
            'txn_obj_id' => isset($data['order_id']) ? $data['order_id'] : "0",
            'ref_value' => isset($data['request']) ? $data['request'] : '0',
            'user_id' => $user_id,
            'company_code' => $company_code,
            'branch_code' => $branch_code,
            'edi_request' => isset($data['request']) ? $data['request'] : 'xml',
            'edi_response' => isset($data['response']) ? $data['response'] : "xml"
        );
        $this->common->insertTableData('tb_etn_edi_transactions', $params);

    }
    public function updatenewpod($ordid)
    {
        $log_edi_arr = array();
        $order_details = $this->common->gettblrowdata(array(
            'order_row_id' => $ordid
        ), 'consignment_note', 'tb_order_details', 0, 0);
        if (! empty($order_details) && ! empty($order_details['consignment_note'])) {
            $log_edi_arr['request'] = $order_details['consignment_note'];

            $apiurl = BORDER_API . '/api/v1/consignments/' . $order_details['consignment_note'] . '/pods/PDF?base64=true';
            $res = requestborderapi($apiurl);
            if ($res == "401" || $res == 'expired') {
                $res = requestborderapi($apiurl);
            }

            /* Get pod information like pod date and receiver name  */

            $dt = date('Y-m-d H:i:s');
            $receiver_name='';
            $getdataapiurl = BORDER_API . '/api/v1/consignments/' . $order_details['consignment_note'] . '/pods/Metadata?wrap=false';
            $get_pod_info_res = requestborderapi($getdataapiurl);
            if ($get_pod_info_res == "401" || $get_pod_info_res == 'expired') {
                $get_pod_info_res = requestborderapi($getdataapiurl);
            }
            $get_info_res = (array)json_decode($get_pod_info_res);
            $get_Connote=isset($get_info_res[0]->ConnoteNumber)?$get_info_res[0]->ConnoteNumber:'';
            if((isset($get_info_res[0]->DateSigned)) && (!empty($get_info_res[0]->DateSigned))){
                $newdate=date('Y-m-d H:i:s', strtotime($get_info_res[0]->DateSigned));
                $curtz = "Australia/Sydney";
                $utc = "UTC";
                $getactual = getdatetimebytimezone($utc, $newdate, $curtz);
                $dt = $getactual['datetime'];
            }
            if((isset($get_info_res[0]->SignedBy)) && (!empty($get_info_res[0]->SignedBy))){
                $receiver_name=$get_info_res[0]->SignedBy;
            }

            $log_edi_arr['response'] = $res;
            if(is_array($get_info_res) && !empty($get_info_res)){
                $get_info_res['ImgBase64']=$res;
                $log_edi_arr['response'] = json_encode($get_info_res);
            }

            /* end pod info */

            $log_edi_arr['obj_type_name'] = 'ePOD';
            $order = $this->common->gettblrowdata(array(
                'id' => $ordid
            ), 'order_id,user_id,shift_id,trip_id,company_code,branch_code,vendor_id', 'tb_orders', 0, 0);
            $edists = isset($response['Status']) ? $response['Status'] : "";
            $edidata = array(
                "status" => 'ePOD',
                "txn_obj_id" => $order['order_id'],
                'bounded_type' => 2,
                'edi_type' => 1,
                'transaction_id' => time(),
                'edi_id' => 7,
                'edi_name' => 'BORDER EXPRESS',
                'edi_format_type' => 'XML',
                'obj_type' => 1,
                'user_id' => $order['user_id'],
                'company_code' => $order['company_code'],
                'branch_code' => $order['branch_code'],
                "edi_request" => $order_details['consignment_note'],
                "edi_response" => $res
            );
            $log_edi_arr['status'] = 0;
            if ($res != "" && $res != "404") {
                $log_edi_arr['status'] = 1;
                $status = "";
                $res1 = json_decode($res);

                if (isset($res1->Base64)) {
                    $res2 = $res1->Base64;
                    $pod_base64 = "./assets/border_epod.txt";
                    $decoded = base64_decode(preg_replace('#^data:application/pdf/\w+;base64,#i', '', $res2));
                    $curdt = date("YmdHis");
                    $file_name = $order_details['consignment_note'] . '_' . $curdt . '.pdf';
                    $file1 = NEW_POD_PATH . $file_name;
                    $imageSize = filesize($file1);
                    file_put_contents($file1, $decoded);
                    $shipment_id = $stop_id = $stop_detail_id = $trip_id = $status_id = $latitude = $longitude = $status_code = $status = $vehicle_id = $driver_id = 0;
                    if (count($order) > 0) {

                        $log_edi_arr['order_id'] = $order['order_id'];
                        $log_edi_arr['user_id'] = $order['user_id'];
                        $log_edi_arr['company_code'] = $order['company_code'];
                        $log_edi_arr['branch_code'] = $order['branch_code'];
                        $log_edi_arr['vendor_id'] = $order['vendor_id'];

                        $shipment_id = $order['shift_id'];
                        $trip_id = $order['trip_id'];
                        $user_id = $order['user_id'];
                        $select = "id";
                        $table = "tb_shiporder_stops";
                        $where = array(
                            "shipment_id" => $shipment_id,
                            'stoptype' => 'D',
                            "status" => 1
                        );
                        $stopidinfo = $this->common->gettblrowdata($where, $select, $table, 0, 0);
                        if (count($stopidinfo) > 0) {
                            $stop_id = $stopidinfo['id'];
                        }
                        $select = "id";
                        $table = "tb_employee";
                        $where = array(
                            "shift_id" => $shipment_id,
                            "status" => 1
                        );
                        $stop_detail_idinfo = $this->common->gettblrowdata($where, $select, $table, 0, 0);
                        if (count($stop_detail_idinfo) > 0) {
                            $stop_detail_id = $stop_detail_idinfo['id'];
                        }
                        $doc_type = 3;
                        $chqry = $this->db->select("latitude,longitude")->get_where("tb_stop_status", array(
                            "order_id" => $ordid
                        ), 1, 0);
                        $lati = $long = '';
                        if ($chqry->num_rows() > 0) {
                            $lati = $chqry->row()->latitude;
                            $long = $chqry->row()->longitude;
                        }
                        $newUuid = $this->uuid->v4();
                        $inrdata = [
                            'stop_id' => $stop_id,
                            "shipment_id" => $shipment_id,
                            'trip_id' => $trip_id,
                            'doc_type' => $doc_type,
                            'imgpath' => $file_name,
                            'stop_type' => 'D',
                            'order_id' => $ordid,
                            'status' => 1,
                            'createdon' => $dt,
                            'latitude' => $lati,
                            'longitude' => $long,
                            'receiver_name' => $receiver_name,
                            'user_id' => $user_id,
                            'createdby' => $user_id,
                            'filesize' => $imageSize,
                            'hash' => $newUuid
                        ];
                        $check_data = [
                            'stop_id' => $stop_id,
                            "shipment_id" => $shipment_id,
                            'trip_id' => $trip_id,
                            'doc_type' => $doc_type,
                            'stop_type' => 'D',
                            'order_id' => $ordid
                        ];
                        $chk_qry = $this->db->select("id")->get_where('tb_pod_uploads', $check_data);
                        if ($chk_qry->num_rows() == 0) {
                            $this->common->insertTableData('tb_pod_uploads', $inrdata);

                            $this->edilogtransactions($log_edi_arr);

                            $status = "ePOD";
                        }elseif ($chk_qry->num_rows() == 1) {

                            $whrcond = array(
                                "id" => $chk_qry->result()[0]->id
                            );
                            $setdata = array(
                                'imgpath' => $file_name
                            );
                            $upd = $this->db->where($whrcond)->update("tb_pod_uploads", $setdata);

                        }
                    }
                }
                if ($status != "") {
                    $insert = [
                        'req_type' => 'pod',
                        'response' => $file_name,
                        'apiurl' => $apiurl,
                        'order_id' => $ordid,
                        'res_status' => $status,
                        'vendor_type' => 1,
                        'status' => 1,
                        'createdon' => $dt,
                        'updatedon' => $dt
                    ];
                    $id = $this->common->insertTableData('tb_bexedi', $insert);
                }
            }
        }
    }
}
