<?php if(!defined('BASEPATH')) exit('No direct script access allowed');
class Branch extends CI_Controller {

    public function __construct() {
        parent::__construct();
        if($this->session->userdata('user_id') == ''){
            redirect('login');
        }
        $this->load->library('form_validation');
        $this->load->model('common');
        if (!checkUrlAccessForUser('BRANCH')) {
            redirect("Forbiddenaccess");
        }
    }

    public function index() {
        $data['page_title'] = $this->lang->line('branch_info');
        $data['sub_title'] = $this->lang->line('branch');
        $where = array();
        if($this->input->post('company_code',true)){
            $where['company_code'] = $this->input->post('company_code',true);
        }
        $status=$this->input->post('status',true);
        if (isset($status) && $status!= "") {
            $where['status'] = $status;
        }
        if($this->input->post('branch_code',true)){
            $where['branch_code'] = $this->input->post('branch_code',true);
        }
        $data['branches'] = $this->common->gettbldata($where,'*','tb_branch_master',0,0);
        $this->newtemplate->dashboard("branch/index", $data);
    }

    public function checkBranchCode($branch_code){
        if(empty($branch_code)){
            $this->form_validation->set_message('checkBranchCode','Branch Code  Required');
            return FALSE;
        } else {
            $id = $this->uri->segment(3);
            $where = array('branch_code'=>$branch_code);
            if($id){
                $where['id !='] = $id;
            }
            $branch = $this->common->gettblrowdata($where,'branch_code','tb_branch_master',0,0);
            if(empty($branch)){
                return TRUE;
            } else {
                $this->form_validation->set_message('checkBranchCode',"Already This Branch Code Existed");
                return FALSE;
            }
        }
    }

    public function checkCompanyCode($company_code){
        if(empty($company_code)){
            $this->form_validation->set_message('checkCompanyCode','Company Code  Required');
            return FALSE;
        } else {
            $where = array('company_code'=>$company_code);
            $company_code = $this->common->gettblrowdata($where,'company_code','tb_company_master',0,0);
            if(empty($company_code)){
                $this->form_validation->set_message('checkCompanyCode',"Company Code not exist");
                return FALSE;
            } else {
                return TRUE;
            }
        }
    }

    public function checkBranchName($branch_name){
        if(empty($branch_name)){
            $this->form_validation->set_message('checkBranchName','Branch Code  Required');
            return FALSE;
        } else {
            $id = $this->uri->segment(3);
            $where = array('branch_name'=>$branch_name);
            if($id){
                $where['id !='] = $id;
            }
            $branch = $this->common->gettblrowdata($where,'branch_name','tb_branch_master',0,0);
            if(empty($branch)){
                return TRUE;
            } else {
                $this->form_validation->set_message('checkBranchName',"Already This Branch Name Existed");
                return FALSE;
            }
        }
    }

    public function add()   {
        $data['page_title'] = $this->lang->line('branch_info');
        $data['sub_title'] = $this->lang->line('branch');
        if($_POST){
            $this->form_validation->set_rules('branch_code', 'Branch Code', 'required|callback_checkBranchCode');
            $this->form_validation->set_rules('branch_name', 'Branch Name', 'required|callback_checkBranchName');
            $this->form_validation->set_rules('company_code', 'Company Code', 'required|callback_checkCompanyCode');
            if ($this->form_validation->run() == false) {
                $data['error']['company_code'] = form_error('company_code');
                $data['error']['branch_code'] = form_error('branch_code');
                $data['error']['branch_name'] = form_error('branch_name');
                $this->form_validation->set_error_delimiters('<div class="alert alert-danger" style="padding: 5px;margin-left: 10px; margin-right: 10px;" ><a href="#" class="close" data-dismiss="alert" aria-label="close">&times;</a>', '</div>');
                $this->newtemplate->dashboard('branch/add', $data);
            } else {
                $array['company_code'] = $this->input->post('company_code',true);
                $array['branch_name'] = $this->input->post('branch_name',true);
                $array['branch_code'] = $this->input->post('branch_code',true);
                $array['acon_country'] = $this->input->post('acon_country',true);
                $array['bill_type'] = $this->input->post('bill_type',true);
                $array['email_id'] = $this->input->post('email_id',true);
                $array['description'] = $this->input->post('description',true);
                $array['branch_officeno'] = $this->input->post('branch_officeno',true);
                if($array['branch_officeno'] == ""){
                    $array['branch_officeno'] = mt_rand(100000,999999);
                }
                $array['logical_sender'] = $this->input->post('logical_sender',true);
                if($array['logical_sender'] == ""){
                    $array['logical_sender'] = $array['branch_code'];
                }
                $array['status'] = $this->input->post('status',true);
                $array['updatedon'] = date('Y-m-d H:i:s');
                $array['createdon'] = date('Y-m-d H:i:s');
                $result = $this->common->insertTableData('tb_branch_master',$array);
                redirect('branch');
            }
        } else {
            $this->newtemplate->dashboard('branch/add', $data);
        }
    }

    public function edit($id) {
        $data['page_title'] = $this->lang->line('branch_info');
        $data['sub_title'] = $this->lang->line('branch');
        $data['branch'] = $this->common->gettblrowdata(array('id'=>$id),'id,status,company_code,branch_code,branch_name,description,branch_officeno,logical_sender,acon_country,bill_type,email_id','tb_branch_master',0,0);
        if(isset($data['branch']['id'])) {
            if($_POST){
                $this->form_validation->set_rules('company_code', 'Company Code', 'required|callback_checkCompanyCode');
                $this->form_validation->set_rules('branch_code', 'Branch Code', 'required|callback_checkBranchCode');
                $this->form_validation->set_rules('branch_name', 'Branch Name', 'required|callback_checkBranchName');
                if ($this->form_validation->run() == false) {
                    $data['error']['company_code'] = form_error('company_code');
                    $data['error']['branch_code'] = form_error('branch_code');
                    $data['error']['branch_name'] = form_error('branch_name');
                    $this->form_validation->set_error_delimiters('<div class="alert alert-danger" style="padding: 5px;margin-left: 10px; margin-right: 10px;" ><a href="#" class="close" data-dismiss="alert" aria-label="close">&times;</a>', '</div>');
                    $this->newtemplate->dashboard('branch/edit', $data);
                } else {

                    $array['company_code'] = $this->input->post('company_code',true);
                    $array['branch_name'] = $this->input->post('branch_name',true);
                    $array['branch_code'] = $this->input->post('branch_code',true);
                    $array['acon_country'] = $this->input->post('acon_country',true);
                    $array['bill_type'] = $this->input->post('bill_type',true);
                    $array['email_id'] = $this->input->post('email_id',true);
                    $array['description'] = $this->input->post('description',true);
                    $array['branch_officeno'] = $this->input->post('branch_officeno',true);
                    if($array['branch_officeno'] == ""){
                        $array['branch_officeno'] = mt_rand(100000,999999);
                    }
                    $array['logical_sender'] = $this->input->post('logical_sender',true);
                    if($array['logical_sender'] == ""){
                        $array['logical_sender'] = $array['branch_code'];
                    }
                    $array['updatedon'] = date('Y-m-d H:i:s');
                    $array['status'] = $this->input->post('status',true);
                    $result = $this->common->updatetbledata('tb_branch_master',$array,array('id'=>$id));
                    redirect('branch');
              }
            } else {
                $this->newtemplate->dashboard('branch/edit', $data);
            }
        } else {
            show_error('The Branch you are trying to Edit does not exist.');
        }
    }

    public function deletebranch($id){
        if($id != '' || $id != 0){
            $chk = $this->common->gettblrowdata(array('id'=>$id),'id','tb_branch_master',0,0);
            if($chk){
                $upd = $this->common->updatetbledata('tb_branch_master',array('status'=>0),array('id'=>$id));
                if($upd){
                    echo "1";
                }else{
                    echo "0";
                }
            }else{
                echo "0";
            }
        }
    }

    public function view($id){
        $data['page_title'] = $this->lang->line('branch_info');
        $data['sub_title'] = $this->lang->line('branch');
        $data['branch'] = $this->common->gettblrowdata(array('id'=>$id),'id,company_code,branch_name,branch_code,description,branch_officeno,logical_sender,acon_country,bill_type,status,email_id','tb_branch_master',0,0);
        $this->newtemplate->dashboard('branch/view', $data);
    }

}

