<?php

defined('BASEPATH') or exit('No direct script access allowed');

use App\Controllers\AuthenticatedUserAbstract\AuthenticatedUserAbstract;

class BulkOrderLabel extends AuthenticatedUserAbstract {

	public function __construct() {
		parent::__construct();
		$this->load->library( 'session' );
		$this->load->library( 'form_validation' );
		$this->load->model( 'Order' );
		$this->load->model( 'common' );
		$this->load->library('m_pdf');
	}

	public function orderlabel() {
			$orderArray=explode(',' , $this->input->post('orderIds'));
			$orderInfo = $this->getOrderDetails($orderArray);
			$orderInfo = $this->getOrderPartiesData($orderArray, $orderInfo);
			$html = "";
			foreach ( $orderArray as $order ) {
				$orderId = $order;
				$data = $orderTypes = [];
				$reference = $shipmentNumber = $communicationReference  = $date = '';
				$drop_details['name'] = $drop_details['street'] = $drop_details['country'] = '';
				$drop_details['pincode'] = $shipper_details['name'] = $shipper_details['street'] = '';
				$shipper_details['country'] = $shipper_details['pincode'] = $shipper_details['city'] = '';
				$data['count'] = $data['weight'] = '';
				$cargos = $drop_details = $shipper_details = $order_type = [];
				if ( $orderId != "" ) {
					if ( $this->session->userdata( 'cust_id' ) > 0  ) {
							$this->db->where( [ 'id' => $orderId  ] )
								->update( 'tb_orders',  [ 'order_status' => 'READY' ]
							);
					}

					if ( isset($orderInfo[$orderId]) ) {
						$orderDetails = $orderInfo[$orderId];
					}

					if ( !empty($orderDetails) ) {
						$date      = $orderDetails['pickup_datetime'];
						$reference = $orderDetails['shipment_id'];
						if ( $reference != "" && $reference != 0 ) {
							$getshipment_number = $this->db->select( 'shipid' )
								->get_where( 'tb_shipments',  [ 'id' => $reference ]
							);
							if ( $getshipment_number->num_rows() > 0 ) {
								$reference = $getshipment_number->row()->shipid;
							}
						}
						$shipmentNumber = $orderDetails['order_id'];
						$communicationReference  = $orderDetails['purchase_order'];

						$ordertype = $orderDetails['order_type'];
						if ( $ordertype!="" || $ordertype!=null ) {
							$getOrderType = $this->db->select( 'type_name' )
								->get_where( 'tb_order_types', [ 'id' => $ordertype  ], 1, 0 );
							if ( $getOrderType->num_rows() > 0 ) {
								$order_type['name'] =  $getOrderType->row()->type_name;
							}
						}
						$data['order_type'] = $order_type;

						$orderArrayData = [];
						if( isset($orderInfo[$orderId]) ){
							$orderArrayData = $orderInfo[$orderId];
						}
						$routingDetails  = $this->getRoutingDetails($orderId, $orderArrayData);
						$data = array_merge($routingDetails , $data);

                        $this->db->select('c.*');
                        $this->db->from('tb_cargo_details c');
                        $this->db->join('tb_order_cargodetails o', 'o.cargo_id=c.id', 'INNER');
                        $this->db->where('o.status', '1');
                        $this->db->where('o.order_id', $orderId);
                        $this->db->order_by('c.id', 'DESC');
                        $this->db->group_by('c.id');
                        $getwhr = $this->db->get();
                        if ($getwhr->num_rows() > 0) {
                            foreach ($getwhr->result() as $res) {
								$units = $res->weight_unit;
								if ( $units == '' ) {
									$units = "Kg";
								}
								$qty = $res->quantity;
								$weight  = @round( ( $res->weight / $qty ), 2 );
								$volume  = @round( ( $res->volume / $qty ), 2 );
								for ( $i = 1; $i <= $qty; $i ++ ) {
									$cargos[] = [
										'id' => $res->id,
										'weight' => $weight . " " . $units,
										'volume'=>$volume . " M3"
									];
								}
							}
						}
					}

					$data['reference']               = $reference;
					$data['shipmentnumber']          = $shipmentNumber;
					$data['communication_reference'] = $communicationReference ;

					if ( $date != "" ) {
                        $data['date'] = (new DateTime($date))->format('d M Y');
					} else {
						$data['date'] = $date;
					}

					$data['cargos'] = $cargos;
					$data['generator'] = new Picqer\Barcode\BarcodeGeneratorPNG();

					if ( $this->session->userdata( 'company_code' ) === "NZPG" ) {
						$data['trucknumber']='';
						$data['destination_branch']='';
					if($orderId!=''){
						$sql="select c.id,name,o.shift_id,o.destination_branch from tb_orders o
						inner join tb_customers c on c.id=o.customer_id
						where o.id=?;
						";
						$sql= $this->db->query($sql, [$orderId]);
						if ( $sql->num_rows() > 0 ) {
							$customerDetails=array('id'=>$sql->row()->id,'name'=>$sql->row()->name);
							$data['customer_details']=$customerDetails;
							$data['destination_branch']=$sql->row()->destination_branch;
						}
					}

						$mpdf           = new \Mpdf\Mpdf( [
							'mode'          => 'utf-8',
							'tempDir' 		=> FCPATH .'assets/tmp',
							'format'  => [ 100, 160 ],
							'margin_left'   => 0,
							'margin_right'  => 0,
							'margin_top'    => 0,
							'margin_bottom' => 0,
							'margin_header' => 0,
							'margin_footer' => 0,
						] );

					} else {
						$mpdf           = new \Mpdf\Mpdf( [
							'mode'          => 'utf-8',
							'tempDir' 		=> FCPATH .'assets/tmp',
							'format'        => [ 100, 110 ],
							'margin_left'   => 0,
							'margin_right'  => 0,
							'margin_top'    => 0,
							'margin_bottom' => 0,
							'margin_header' => 0,
							'margin_footer' => 0,
						] );
}
					$i = 1;
					$data['count']  = count( $cargos );
                    $data['vendorName']='';
                    if (!empty($orderInfo[$orderId]['vendor_id'])) {
                        $vendor = $this->common->gettblrowdata(['id' => $orderInfo[$orderId]['vendor_id']], 'name', 'tb_vendors', 0, 0);
                        $data['vendorName'] = $vendor['name'] ?? '';
                    }
                    $data['sendRef'] = getorderreftypeinfo('DQ', $orderId);
                    $data['receiverRef'] = getorderreftypeinfo('PO', $orderId);
                    $data['deliveryIns'] = getorderreftypeinfo('ORD_DLVINST', $orderId);
                    $data['pickupIns'] = getorderreftypeinfo('ORD_PIKINST', $orderId);
                    foreach ( $cargos as $cargo ) {
						$data['weight'] = $cargo['weight'];
						$data['volume'] = $cargo['volume'];
						$data['no']     = $i;
						if ( $this->session->userdata( 'company_code' ) === "NZPG" ) {
							$html.= $this->load->view( 'orders/orderlabel_pact', $data, TRUE );
						} else {
							$html.= $this->load->view( 'orders/orderlabel', $data, TRUE );
						}
						$i++;
					}
				}
			}
			$fileName = "labels_" . date( 'YmdHis' ) . ".pdf";
			$data1['labelcontent'] = $html;
			$output = $this->load->view( 'orders/order_label', $data1, TRUE );
			$mpdf->WriteHTML( $output );
			$mpdf->Output( $fileName, 'D' );
	}

	public function bulkMacpacLabels() {
		ini_set("pcre.backtrack_limit", "10000000");
		$this->load->model('Aulabelmodel');
		$orderArray=explode(',' , $this->input->post('orderIds'));
		$orderInfo = $this->getOrderDetails($orderArray);
		$orderInfo = $this->getOrderCargoDetails($orderArray, $orderInfo);
		$orderInfo = $this->getBarcodeCount($orderArray, $orderInfo);
		$orderInfo = $this->getCargoCount($orderArray, $orderInfo);

		$referenceCode = ['ORD_DLVINST'];
		if ( $this->session->userdata( 'company_code' ) != 'KNAU' ) {
			$referenceCode = ['ORD_DLVINST', 'CTR', 'COI'];
		}
		$orderInfo = $this->getOrderReferences($orderArray, $referenceCode, $orderInfo);
		$orderInfo = $this->getOrderPartiesData($orderArray, $orderInfo);

		$html = "";
		foreach ( $orderArray as $each ) {
			$ord_id = $each;
			$data = $orderTypes = [];
			$data['no'] = "";
			$reference = $shipmentNumber = $communicationReference  = $date = "";
			$drop_details['name'] = $drop_details['street'] = $drop_details['country'] = $drop_details['pincode'] = $shipper_details['name'] = $shipper_details['street'] = $shipper_details['country'] = $shipper_details['pincode'] = $shipper_details['city'] = $data['count'] = $data['weight'] = $data['delivery_ins'] = "";
			$cargos = $drop_details = $shipper_details = [];
			if (!empty($ord_id)) {
                $data['orderId']=$ord_id;
				$cargoCondition = [ 'r.id' => $ord_id, 'r.status !=' => 0 ];
				if ( isset($orderInfo[$ord_id]['order_cargo_data']) && !empty($orderInfo[$ord_id]['order_cargo_data']) ) {
					$cargos = $orderInfo[$ord_id]['order_cargo_data'];
				}

				if ( isset($orderInfo[$ord_id]['barcode_count']) && $orderInfo[$ord_id]['barcode_count']>0 ) {
					$barcode_count = $orderInfo[$ord_id]['barcode_count'];
				} else {
					$barcode_count = 0;
				}

				if( isset($orderInfo[$ord_id]['cargo_count']) && $orderInfo[$ord_id]['cargo_count']>0 ) {
					$cargo_count = $orderInfo[$ord_id]['cargo_count'];
				} else {
					$cargo_count = 0;
				}

				$total_barcodes = (int)$barcode_count;
				$total_quantity = (int)$cargo_count;
				if ( $this->session->userdata( 'company_code' ) == 'KNAU' ) {
					if ( empty($cargos) || $total_barcodes != $total_quantity ) {
						$this->load->helper('aulabel_helper');
						manifestoverride($ord_id);
						$cargos = $this->Aulabelmodel->getcargodetails($cargoCondition);
					}
				}

				if ( $ord_id != "" && !empty($cargos) ) {
					$data['delivery_ins'] = $data['container_no'] = '';
					$data['store_code'] = 0;
					$referenceCode = ['ORD_DLVINST'];

					if ( $this->session->userdata( 'company_code' ) != 'KNAU' ) {
						$referenceCode = ['ORD_DLVINST', 'CTR', 'COI'];
					}

					if( isset($orderInfo[$ord_id]['order_references']) ) {
						if ( isset($orderInfo[$ord_id]['order_references']['ORD_DLVINST']) ) {
							$data['delivery_ins'] = $orderInfo[$ord_id]['order_references']['ORD_DLVINST'];
						}

						if ( isset($orderInfo[$ord_id]['order_references']['CTR']) ) {
							$data['container_no'] = $orderInfo[$ord_id]['order_references']['CTR'];
						}

						if ( isset($orderInfo[$ord_id]['order_references']['COI']) ) {
							$data['store_code'] = $orderInfo[$ord_id]['order_references']['COI'];
						}
					}

					$data['carrier_img'] = $data['carrier_name'] = $data['carrier_new_name'] = $data['routecode'] = "";
					$orderArrayData = [];
					if ( isset($orderInfo[$ord_id]) ) {
						$orderArrayData = $orderInfo[$ord_id];
					}

					$routingDetails  = $this->getRoutingDetails($ord_id, $orderArrayData);
					$data = array_merge($routingDetails , $data);

					$carrierImages  = $this->getcarrierimgs($data['vendor_id']);
					$data = array_merge($data, $carrierImages );

					$carrierHeadports  = $this->getheadports($data);
					$data = array_merge($data, $carrierHeadports );

					$data['cargos'] = $cargos;

					$carton_number = 0;
					$data['count'] = count($cargos);
					$barcode_arr = [];

					if ( $this->session->userdata( 'company_code' ) != 'KNAU' ) {
						$barcodeValue = array_column($cargos, 'bar_code');
						array_multisort($barcodeValue, SORT_ASC, $cargos);
						$store_timings=$this->storetimings($data);
						if ( !empty($store_timings) ) {
							$data['store_timings']=$store_timings;
						}
					}

					$data['generator'] = new Picqer\Barcode\BarcodeGeneratorPNG();
                    $curtz = $this->session->userdata("usr_tzone")['timezone'];
					foreach ( $cargos as $cargo ) {
						if ( !in_array($cargo['id'], $barcode_arr) ) {
							$barcode_arr[] = $cargo['id'];
							if ( $this->session->userdata( 'company_code' ) == 'KNAU' && $cargo['quantity']>1  ) {
								$barCodeCondition=['cargo_id'=>$cargo['cargo_id'],'status'=>1];
								$barcodes = $this->Aulabelmodel->get_barcodes($barCodeCondition);
								$barcodes = array_column($barcodes, 'bar_code');
								for ( $i=0;$i<$cargo['quantity'];$i++ ) {
									$data['weight'] = $cargo['weight'];
									$data['cargo_type'] = $cargo['cargo_type'];
									$data['cargo_content'] = $cargo['cargo_content'];
								   	$request_data = array(
										'order_id' => $ord_id,
										'cargo_id' => $cargo['id']
									);
									$data['qty'] = $total_quantity;
									$data['no'] =$carton_number+1;
									$data['caseid'] = $cargo['qr_code'];
									$data['barcode_no'] = $barcodes[$i];
									$data['label_create_date'] = getdatetimebytimezone($curtz, $cargo['createdon'], DFLT_TZ)['datetime'];
									$html .= $this->load->view('aulabels/macpaclabel', $data, true);
									$carton_number= $data['no'];
								}
							} else {
								$barcode_arr[] = $cargo['id'];
								$data['weight'] = $cargo['weight'];
								$data['cargo_type'] = $cargo['cargo_type'];
								$data['cargo_content'] = $cargo['cargo_content'];
								$request_data =
								[
									'order_id' => $ord_id,
									'cargo_id' => $cargo['id']
								];

								$data['qty'] = $total_quantity;
								$data['no'] =$carton_number+1;
								$data['caseid'] = $cargo['qr_code'];
								$data['barcode_no'] = $cargo['bar_code'];
                                $data['label_create_date'] = getdatetimebytimezone($curtz, $cargo['createdon'], DFLT_TZ)['datetime'];
								if ( $this->session->userdata( 'company_code' ) == 'KNAU' ) {
									$html .= $this->load->view('aulabels/macpaclabel', $data, true);
								} else {
									$html .= $this->load->view('orders/aulabel', $data, true);
								}
								$carton_number= $data['no'];
							}
						}
					}
				}
			}

		}

			unset($orderInfo);
			$mpdf = new \Mpdf\Mpdf([
				'tempDir' => FCPATH . 'assets/tmp',
				'mode' => 'utf-8',
				'format' => [
					112.0,
					152.0
				],
				'margin_left' => 0,
				'margin_right' => 0,
				'margin_top' => 0,
				'margin_bottom' => 0,
				'margin_header' => 0,
				'margin_footer' => 0
			]);
			$mpdf->useSubstitutions = false;
			$mpdf->simpleTables = true;
			$data1['labelcontent'] = $html;
			$output = $this->load->view('orders/order_label', $data1, true);
			$mpdf->WriteHTML($output);
			$fileName = "labels_" . date( 'YmdHis' ) . ".pdf";
			$mpdf->Output( $fileName, 'D' );
	}

	public function getOrderPartiesData( $orderIds, $data ) : array {
		$partyTypeArray = ['Shipper', 'Consignee'];
		$this->db->select('o.order_id, p.id, p.party_type_id, p.name, p.mobile, p.email, p.code, p.fax, o.party_type,pt.name AS party_type_name');
		$this->db->from('tbl_party_master p');
		$this->db->join( 'tb_order_parties o', 'p.id = o.party_id AND o.status = 1', 'INNER' );
		$this->db->join( 'tbl_party_types pt', 'pt.id=o.party_type', 'INNER' );
		$this->db->where( 'p.status = 1' );
		$this->db->where_in( 'o.order_id', $orderIds );
		$this->db->where_in( 'pt.name', $partyTypeArray );
		$this->db->group_by( 'o.id' );
		$result = $this->db->get();
			if ( $result->num_rows() > 0 ) {
				$orderResult = $result->result_array();
				if( !empty($orderResult) ){
					foreach( $orderResult as $eachOrder ){
						$index = $eachOrder['order_id'];
						$partyTypename = $eachOrder['party_type_name'];
						$data[$index]['order_party_details'][$partyTypename] = $eachOrder;
					}
				}
			}
		return $data;
	}


	public function getRoutingDetails( $orderId,$orderData ) : array {
        $data = $shipper_details = $drop_details = [];
        if ( !empty($orderId) && !empty($orderData) ) {
            	$shipmentNumber = $orderData['order_id'];
				if( isset($orderData['order_party_details']) ) {
					if( isset($orderData['order_party_details']['Shipper']) ) {
						$shipper_details =
								[
									'id' => $orderData['order_party_details']['Shipper']['id'],
									'name' => $orderData['order_party_details']['Shipper']['name'],
									'phone' => $orderData['order_party_details']['Shipper']['mobile'],
									'email' => $orderData['order_party_details']['Shipper']['email'],
									'fax' => $orderData['order_party_details']['Shipper']['fax'],
									'party_id' => $orderData['order_party_details']['Shipper']['code']
								];
					}
					if( isset($orderData['order_party_details']['Consignee']) ) {
						$drop_details =
								[
                                    'id' => $orderData['order_party_details']['Consignee']['id'],
                                    'name' => $orderData['order_party_details']['Consignee']['name'],
                                    'phone' => $orderData['order_party_details']['Consignee']['mobile'],
                                    'email' => $orderData['order_party_details']['Consignee']['email'],
                                    'fax' => $orderData['order_party_details']['Consignee']['fax'],
                                    'party_id' => $orderData['order_party_details']['Consignee']['code']
                                ];
                    }
                }

            $data['delivery_date'] = (new DateTime($orderData['delivery_datetime']))->format('d M Y');
            $data['pickup_date'] = (new DateTime($orderData['pickup_datetime']))->format('d M Y');

            $data['consignment_no'] = $orderData['consignment_note'];
            if (empty($data['consignment_no'])) {
                $data['consignment_no'] = $orderData['order_id'];
            }

            $shipper_details['name'] = $orderData['pickup'];
            $shipper_details['street'] = $orderData['pickup_address1'];
            $shipper_details['state'] = $orderData['pickup_address2'];
            $shipper_details['city'] = $orderData['pickup_city'];
                $shipper_details['country'] = $orderData['pickup_country'];
                $shipper_details['pincode'] = $orderData['pickup_pincode'];

                $drop_details['name'] = $orderData['delivery'];
                $drop_details['street'] = $orderData['delivery_address1'];
                $drop_details['state'] = $orderData['delivery_address2'];
                $drop_details['city'] = $orderData['delivery_city'];
                $drop_details['country'] = $orderData['delivery_country'];
                $drop_details['pincode'] = $orderData['delivery_pincode'];

                $data['drop_details'] = $drop_details;
                $data['shipper_details'] = $shipper_details;
                $data['shipmentnumber'] = $shipmentNumber;
                $data['vendor_id'] = $orderData['vendor_id'];

        }
        return $data;
    }


	public function getcarrierimgs( $id ) {
        $data = [];
        if ( !empty($id) ) {
            $carrier_details = $this->common->gettblrowdata( [ 'id' => $id  ] , 'name', 'tb_vendors', 0, 0);

            if ( !empty($carrier_details) ) {
                $data['carrier_name'] = ((isset($carrier_details['name'])) && (!empty($carrier_details['name']))) ? $carrier_details['name'] : '';

                $data['carrier_name'] = (strtoupper($data['carrier_name']) == "BORDER EXPRESS") ? "BEX" : $data['carrier_name'];
                $data['carrier_new_name'] = "";

                if ( strtoupper($data['carrier_name']) == 'BEX' ) {
                    $data['carrier_img'] = 'BEX.jpg';
                    $data['carrier_new_name'] = 'REGIONAL';
                } else if ( strtoupper($data['carrier_name']) == 'BONDS TRANSPORT' ) {
                    $data['carrier_img'] = 'Bonds.jpg';
                    $data['carrier_new_name'] = 'METRO';
                } else if ( strtoupper($data['carrier_name']) == 'BONDS DC' ) {
                    $data['carrier_img'] = 'DC.jpg';
                    $data['carrier_new_name'] = 'DC';
                } else {
                    $data['carrier_img'] = "";
                }
            }
        }
        return $data;
    }

	public function getheadports( $h_data ) {
        $data = [];
        $data['routecode'] = '';
        $routeinfo['routing_code'] = "";
        if ( (!empty($h_data)) && (isset($h_data['carrier_name'])) && (!empty($h_data['carrier_name'])) ) {

            if ( $h_data['carrier_name'] == 'BONDS TRANSPORT') {
                $routeinfo = $this->common->gettblrowdata(
					[
						'correct_zip' => $h_data['drop_details']['pincode'],
						'status' => 1,
						'carrier_name' => 'Bonds'
					] ,
					'headport', 'tb_au_carrier_headports', 0, 0);
                $routeinfo['routing_code'] = $routeinfo['headport'];
            } else {
                $routeinfo = $this->common->gettblrowdata(
					[
						'postalcode' =>  $h_data['drop_details']['pincode'],
						'status' => 1,
						'type' => 2
					] ,
					'routing_code', 'tb_au_carrier_postalcodes', 0, 0);
            }
        }
        $data['routecode'] = !empty($routeinfo['routing_code']) ? $routeinfo['routing_code'] : '';
        return $data;
    }

	private function storetimings($data) {
        $storeCode = 0;
        $storeInfo = [];
        if ( !empty($data)  && isset($data['drop_details']) && !empty($data['drop_details']) ) {
			if ( isset($data['store_code']) ) {
				$storeCode = $data['store_code'];
			}
			$where = [
                'city' => isset($data['drop_details']['city'])?$data['drop_details']['city']:'',
                'state' => isset($data['drop_details']['state'])?$data['drop_details']['state']:'',
                'post_code' => isset($data['drop_details']['pincode'])?$data['drop_details']['pincode']:'',
                'name' => isset($data['drop_details']['name'])?$data['drop_details']['name']:'',
                'status' => 1
            ];
            if ( !empty($storeCode) ) {
                $where['store_code'] = $storeCode;
            }
            $storeData = $this->common->gettblrowdata($where, 'dock_hours,days', 'tb_au_store_timings', 0, 0);
            if ( !empty($storeData) && !empty($storeData['dock_hours']) ) {
                $storeInfo = $storeData;

            } else {
                unset($where['city']);
                unset($where['name']);
                $storeData = $this->common->gettblrowdata($where, 'dock_hours,days', 'tb_au_store_timings', 0, 0);
                if ( !empty($storeData) && !empty($storeData['dock_hours']) ) {
                    $storeInfo = $storeData;

                } else {
                    unset($where['state']);
                    $storeData = $this->common->gettblrowdata($where, 'dock_hours,days', 'tb_au_store_timings', 0, 0);
                    if ( !empty($storeData) && !empty($storeData['dock_hours']) ) {
                        $storeInfo = $storeData;
                    }
                }
            }

        }
        return $storeInfo;
    }

	public function getOrderReferences($orderIds, $referenceCode, $data) : array {
		if ( $orderIds != '' ) {
			$this->db->select( 'order_id, reference_id, ref_value' );
			$this->db->from( 'tb_order_references' );
			$this->db->where_in( 'order_id', $orderIds );
			$this->db->where_in( 'reference_id', $referenceCode );
			$result = $this->db->get();
			if ( $result->num_rows() > 0 ) {
				$orderResult = $result->result_array();
				if ( !empty($orderResult) ) {
					foreach( $orderResult as $eachOrder ) {
						$index = $eachOrder['order_id'];
						$key = $eachOrder['reference_id'];
						$value = $eachOrder['ref_value'];
						$data[$index]['order_references'][$key] = $value;
					}
				}
			}
		}
		return $data;
	}

	public function getOrderDetails($orderArray) : array {
		$data = [];
		if( !empty($orderArray) ) {
			$this->db->select( 'o.id,o.order_id,o.pickup_datetime,o.pickup_endtime,o.shipment_id,o.delivery_datetime,
			o.drop_endtime,o.pickup_company as pickup,o.delivery_company as delivery,
			o.pickup_address1,o.delivery_address1,o.pickup_address2,o.delivery_address2,
			o.pickup_city,o.delivery_city,o.pickup_country,o.delivery_country,
			o.pickup_pincode,o.delivery_pincode,o.company_code,o.branch_code,o.product,o.goods_value,
			o.currency,o.transport_mode,o.vehicle_type,o.quantity,o.customer_id,o.vendor_id,o.pickup_custid,
			o.pickup_partyid,o.drop_custid,o.drop_partyid,o.trip_sts,o.shift_id,o.trip_id,o.status,o.order_status,
			o.createdon,o.updatedon,o.shipmentid,o.consignee_id,o.shipper_id as o_shipper_id,d.order_type,
			d.shipper_id,d.service,d.delivery_term,d.incoterm,d.delivery_note,d.purchase_order,d.notify_party,
			d.lane_reference,d.distance,d.customs_required,d.high_cargo_value,d.valorance_insurance,d.temperature_control,
			d.department_code,d.docs_received_datetime,d.docs_sent_datetime,d.consignment_note,d.order_remarks,
			d.cost_center_id' );
			$this->db->from( 'tb_orders o' );
			$this->db->join( 'tb_order_details d', 'o.id=d.order_row_id', 'LEFT' );
			$this->db->where_in( 'o.id', $orderArray );
			$this->db->group_by( 'o.id' );
			$result = $this->db->get();
			if ( $result->num_rows() > 0 ) {
				$orderResult = $result->result_array();
				if ( !empty($orderResult) ){
					foreach ( $orderResult as $eachOrder ) {
						$index = $eachOrder['id'];
						$data[$index] = $eachOrder;
					}
				}
			}
		}
		return $data;
	}

	public function getOrderCargoDetails($orderIds, $data) : array {
		if ( !empty($orderIds) ) {
			$this->db->select( 'o.id, c.quantity, c.cargo_type, c.weight, o.cargo_content,
			o.order_id, o.qr_code, o.cargo_id, l.bar_code, l.createdon ' );
			$this->db->from( 'tb_order_cargodetails o' );
			$this->db->join( 'tb_cargo_details c', 'o.cargo_id=c.id', 'INNER' );
			$this->db->join( 'tb_orders r', 'o.order_id=r.id', 'INNER' );
			$this->db->join( 'tb_order_cargo_labels l', 'l.cargo_id=o.cargo_id', 'INNER' );
			$this->db->where_in( 'r.id', $orderIds );
			$this->db->where( 'r.status != 0' );
			$result = $this->db->get();
			if ( $result->num_rows() > 0 ) {
				$orderResult = $result->result_array();
				if ( !empty($orderResult) ) {
					foreach ( $orderResult as $eachOrder ) {
						$index = $eachOrder['order_id'];
						$data[$index]['order_cargo_data'][] = $eachOrder;
					}
				}
			}
		}
		return $data;
	}

	public function getBarcodeCount($orderIds, $data) : array {
		$select = 'count(id) as count_barcodes, r.order_id';
        $result = array();
        $this->db->select($select);
        $this->db->from( 'tb_order_cargo_labels r' );
        $this->db->where_in( 'r.order_id', $orderIds );
		$this->db->where( 'r.status = 1' );
        $this->db->group_by( 'r.order_id' );
       	$result = $this->db->get();
			if ( $result->num_rows() > 0 ) {
				$orderResult = $result->result_array();
				if ( !empty($orderResult) ) {
					foreach ( $orderResult as $eachOrder ) {
						$index = $eachOrder['order_id'];
						$data[$index]['barcode_count'] = $eachOrder['count_barcodes'];
					}
				}
			}
		return $data;
	}

	public function getCargoCount($orderIds, $data) : array {
		$select = 'SUM(Case When c.status = "1" Then c.quantity Else 0 End) as totqty, r.id';
        $result = array();
        $this->db->select($select);
        $this->db->from( 'tb_orders r' );
        $this->db->join( 'tb_order_cargodetails c', 'r.id=c.order_id', 'LEFT' );
        $this->db->where_in( 'r.id', $orderIds );
		$this->db->where( 'r.status != 0' );
		$this->db->group_by( 'r.id' );
       	$result = $this->db->get();
		   	if ( $result->num_rows() > 0 ) {
				$orderResult = $result->result_array();
				if ( !empty($orderResult) ) {
					foreach ( $orderResult as $eachOrder ) {
						$index = $eachOrder['id'];
						$data[$index]['cargo_count'] = $eachOrder['totqty'];
					}
				}
			}
		return $data;
	}

}
