<?php
defined('BASEPATH') OR exit('No direct script access allowed');
class Bulkupload extends CI_Controller {

    public function __construct()  {
        parent::__Construct();
        if($this->session->userdata('user_id') == ''){
            redirect('login');
        }
        $this->load->model('common');
        $this->load->library(['salogintegrateservice', 'uuid', 'InspectPdfLibrary']);
    }

    public function index(){
        $data['page_title'] = 'Bulkupload';
        $data['sub_title'] = 'Bulkupload';
        //$this->newtemplate->dashboard("bulkupload/multiorders", $data);
        $this->load->view("bulkupload/multiorders", $data);
    }

    public function upload(){
        require_once APPPATH . "/third_party/PHPExcel.php";
        require_once APPPATH . "/third_party/PHPExcel/Writer/Excel2007.php";
        $all_data = $sfiles = $ffiles = $maliciousFiles = $data = $errorline = $message = [];
        $files = array();
            if (isset($_FILES['upload_file']) && isset($_FILES['zip_file'])) {
                $extractinfo = $this->extractfiles();
                $extractpath = $extractinfo['fullpath'];
                $files_list = $extractinfo['list'];
                if ($files_list != null && count($files_list) > 0) {
                    $ext = pathinfo($_FILES['upload_file']['name'], PATHINFO_EXTENSION);
                    if ($ext == "xls" || $ext == "xlsx") {
                        $path = $_FILES['upload_file']['tmp_name'];
                        $objPHPExcel = PHPExcel_IOFactory::load($path);
                        $cell_collection = $objPHPExcel->getActiveSheet()->getCellCollection();
                        $data["arr_data"]=array();
                        foreach ($cell_collection as $cell) {
                            $column = $objPHPExcel->getActiveSheet()->getCell($cell)->getColumn();
                            $row = $objPHPExcel->getActiveSheet()->getCell($cell)->getRow();
                            $data_value = $objPHPExcel->getActiveSheet()->getCell($cell)->getValue();
                            $newdtat[] = $column;
                            if ($row == 1) {
                                $data["header"][$row][$column] = $data_value;
                            } else if($row > 1 && !empty($data_value)){
                                $data["arr_data"][$row][$column] = $data_value;
                            }
                        }
                        foreach($data['arr_data'] as $orderPOD){
                            if(!empty($orderPOD['C'])){
                                $server_file = $orderPOD['C'];
                                if (in_array($server_file, $files_list) && !empty($orderPOD['B']) && !empty($orderPOD['A']) && !empty($orderPOD['D'])) {
                                    $insert = [];
                                    $select = 'id,user_id,plat,plng,dlat,dlng,trip_id,shift_id,created_source';
                                    $whereCondition = [
                                        'order_id' => $orderPOD['B'],
                                        'status !=' => 0
                                    ];
                                    if ($this->session->userdata("business_type") == "Carrier") {
                                        $whereCondition['vendor_id'] = $this->session->userdata('id');
                                    } else {
                                        $whereCondition['user_id'] = $this->session->userdata('user_id');
                                    }
                                    $orderinfo = $this->common->gettblrowdata($whereCondition,$select,'tb_orders',0,0);
                                    $documentTypeWhere = [
                                        'type_name'=> $orderPOD['A']
                                    ];
                                    $doctype = $this->common->gettblrowdata($documentTypeWhere,'id','tb_document_types',0,0);
                                    $local = date('YmdHis').$orderPOD['C'];
                                    $localfile = NEW_POD_PATH.$local;
                                    $pdfFlag = true;
                                    $fileExtension = strtolower(pathinfo($extractpath.$orderPOD['C'], PATHINFO_EXTENSION));
                                    if($fileExtension == 'pdf'){
                                        if (!($this->inspectpdflibrary->validatepdf($extractpath.$orderPOD['C']))) {
                                            $pdfFlag = false;
                                        }
                                    }
                                    if($orderinfo && $doctype && $pdfFlag){
                                        copy($extractpath.$orderPOD['C'], $localfile);
                                        if($orderPOD['D'] != 'D'){
                                            $stopwhere = 'o.id = e.stop_id';
                                            $stoptype = 'P';
                                        } else {
                                            $stopwhere = 'o.id = e.drop_stopid';
                                            $stoptype = 'D';
                                        }
                                        $where = [
                                            'e.order_id' => $orderPOD['B'],
                                            'o.status' => 1,
                                            'e.status' => 1
                                        ];
                                        $imageSize = filesize($localfile);
                                        $newUuid = $this->uuid->v4();
                                        $this->db->select('o.id');
                                        $this->db->where($where);
                                        $this->db->join('tb_employee e', $stopwhere, 'left');
                                        $stop = $this->db->get('tb_shiporder_stops o')->row_array();
                                        $insert['order_id'] = $orderinfo['id'];
                                        $insert['trip_id'] = $orderinfo['trip_id'];
                                        $insert['shipment_id'] = $orderinfo['shift_id'];
                                        $insert['stop_id'] = ($stop['id']) ?? 0;
                                        $insert['stop_detail_id'] = 0;
                                        $insert['stop_type']= $stoptype;
                                        $insert['doc_type'] = $doctype['id'];
                                        $insert['latitude'] = ($orderPOD['D']=='D')?$orderinfo['dlat']:$orderinfo['plat'];
                                        $insert['longitude'] = ($orderPOD['D']=='D')?$orderinfo['dlng']:$orderinfo['plng'];
                                        $insert['user_id'] = $orderinfo['user_id'];
                                        $insert['status']= 1;
                                        $insert['createdon'] = $insert['updatedon'] = date('Y-m-d H:i:s');
                                        $insert['imgpath'] = $local;
                                        $insert['filesize'] = $imageSize;
                                        $insert['hash'] =$newUuid;
                                        $insertid = $this->common->insertTableData("tb_pod_uploads",$insert);
                                        if($insertid){
                                            /* send documents to Salog*/
                                            if($orderinfo['created_source'] == 5) {
                                                $orderData = [
                                                    'ord_id' => $orderinfo['id']
                                                ];
                                                $documentType = ($orderPOD['A'] == "PUP") ? "PUP" : "DEL";
                                                /* We need to be apply salogintegrateservice library in later for this library call in required places in other controllers */
                                                $sendDocument = $this->salogintegrateservice->sendePodToSalog($orderData, $documentType);
                                            }
                                            $sfiles[] = $orderPOD['B'].' - '.$orderPOD['C'];
                                        }
                                    } else {
                                        if (!empty($orderPOD['B'])) {
                                            if (!$pdfFlag) {
                                                $maliciousFiles[] = $orderPOD['B'];
                                            } else {
                                                $ffiles[] = $orderPOD['B'];
                                            }
                                        }
                                    }
                                } else if(!empty($orderPOD['B'])){
                                    $ffiles[] = $orderPOD['B'];
                                }
                            } else if(!empty($orderPOD['B'])){
                                $ffiles[] = $orderPOD['B'];
                            }
                        }
                        $deletepath = './assets/bulkupload/'.$extractinfo['dirname'];
                        $this->load->helper("file"); // load the helper
                        delete_files($deletepath.'/', true);
                        rmdir($deletepath);
                    }
                }
            }
        echo json_encode(['success' => $sfiles, 'fail' => $ffiles, 'maliciousFiles' => $maliciousFiles]);
    }

    public function extractfiles(){
        $filesinfo = array();
        $dirname = $this->session->userdata('company_code').time();
        mkdir('./assets/bulkupload/'.$dirname, 0710, TRUE);
        $extractpath = './assets/bulkupload/'.$dirname.'/';
        $config['upload_path'] = $extractpath;
        $config['allowed_types'] = 'zip';
        $config['file_name'] = $_FILES['zip_file']['name'];
        $this->load->library('upload',$config);
        if($this->upload->do_upload('zip_file')){
            $uploadData = $this->upload->data();
            $filepath = $extractpath . $uploadData['file_name'];
            $zip = new ZipArchive();
            $res = $zip->open($filepath);
            if ($res === TRUE) {
                $zip->extractTo($extractpath);
                $flag = 0;
                for($i = 0; $i < $zip->numFiles; $i++){
                    $filename = $zip->getNameIndex($i);
                    $fileinfo = pathinfo($filename);
                    $file_ext= @strtolower(end(explode('.',$fileinfo['basename'])));
                    $expensions= array("jpeg","jpg","png","gif","pdf");
                    if(in_array($file_ext,$expensions)){
                        if($flag == 0){
                            if($fileinfo['dirname'] == '.'){
                                $filesinfo['fullpath'] = $extractpath.'/';
                                $flag = 1;
                            } else {
                                $filesinfo['fullpath'] = $extractpath.$fileinfo['dirname'].'/';
                                $flag = 1;
                            }
                        }
                        $filesinfo['list'][] = $fileinfo['basename'];
                    }
                }
                $filesinfo['dirname'] = $dirname;
                $zip->close();
            }
        }
        return $filesinfo;
    }

}
