<?php if(!defined('BASEPATH')) exit('No direct script access allowed');
require_once APPPATH . "/third_party/PHPExcel.php";
class Businesspartners extends CI_Controller {

	public function __construct() {
		parent::__construct();
		if ($this->session->userdata('user_id') == '') {
			redirect('login');
		}
		$this->load->library('form_validation');
        $this->load->model(['common','bpartners','Mastersmodel']);
        $this->load->helper('log');
        if (!checkUrlAccessForUser('BUSINESSPARTNERS')) {
            redirect("Forbiddenaccess");
        }
	}

	public function index(?int $id = null): void
	{
		$data['reftypes'] = $data['getparties'] = $data['partners'] = $data['branches'] = $data['countries'] = $data['partytypes'] =  $userids = $condata = $refdata = $ediapidata = $accountndata = $contractsdata = [];

		$data['page_title'] = $this->lang->line('business_partners');
		$data['sub_title'] = $this->lang->line('general_search');
		$uid = $this->session->userdata('user_id');
		$company_code = $this->session->userdata('company_code');
		$branch_code = $this->session->userdata('branch_code');
		$excel_uploaddata = [];
		$listType = 0;
		if ($id === 1) {
			$filedata = file_get_contents($_SERVER['DOCUMENT_ROOT'] . "/svkonekt_test/assets/businesspartners/customersexceldata.txt");
			$excel_uploaddata = json_decode($filedata);
			if (!empty($excel_uploaddata)) {
				$listType = 1;
				file_put_contents($_SERVER['DOCUMENT_ROOT'] . "/svkonekt_test/assets/businesspartners/customersexceldata.txt", "");
			}
		}
		if(isset($_POST['searchsubmit']) && $_POST['searchsubmit'] =="Search")
		{
			$post = $this->input->post(NULL,TRUE);
		}
		else
		{
			$post = [];

			//display country names as per JIRA 1483, add country filter in business patner screen
            $where = [
                'country !='=> '',
                'company_code' => $company_code,
                'status' => 1,
                'parent_id' => 0
            ];
            $this->db->select('country');
            $this->db->where($where);
            $this->db->group_by('country');
            $this->db->order_by('country','ASC');
            $getCountries = $this->db->get('tbl_party_master');
            if($getCountries->num_rows() > 0) {
				foreach ($getCountries->result() as $countries) {
					$data['countries'][] = ['country_code'=>$countries->country,'country_name'=>$countries->country];
				}
			}

			//display branch names as per JIRA 1484, , add Branch filter in business patner screen
            $where = [
                'company_code' => $company_code,
                'status' => 1
            ];
            $this->db->select('branch_code');
            $this->db->where($where);
            $this->db->group_by('branch_code');
            $getBranches = $this->db->get('tbl_party_master');
            if($getBranches->num_rows() > 0) {
				foreach ($getBranches->result() as $branch) {
					$data['branches'][] = ['branch_code'=>$branch->branch_code];
				}
			}

			//display party types as per JIRA 1485, , add party type filter in business patner screen
			$partytypes = $this->bpartners->getpartytypes($uid,$company_code);
			if($partytypes->num_rows() > 0) {
				foreach ($partytypes->result() as $gparty) {
					$data['partytypes'][] = ['name'=>ucfirst(strtolower($gparty->name))];
				}
			}
		}
		$obsolete_add = isset($post['obsolete_add']) ? $post['obsolete_add'] : 0;
		$whr = $data['partners'] = [];
		$findPartyTypes = [];

		if(!empty($post))
		{
			if (isset($post['customer_code']) &&  $post['customer_code'] != "")
			{
				$whr['customeridentifier'] = $post['customer_code'];
			}
			if (isset($post['name']) && $post['name'] != "")
			{
				$whr['name'] = $post['name'];
			}
			if (isset($post['street']) && $post['street'] != "")
			{
				$whr['street'] = $post['street'];
			}
			if (isset($post['country']) && $post['country'] != "")
			{
				$whr['country'] = $post['country'];
			}

			if (isset($post['branch_code']) && $post['branch_code'] != "")
			{
				$whr['branch_code'] = $post['branch_code'];
			}

			if (isset($post['party_type']) && $post['party_type'] != "")
			{
				$findPartyTypes = $post['party_type'];
			}

			if (isset($post['house_no']) && $post['house_no'] != "")
			{
				$whr['house_number'] = $post['house_no'];
			}

			if (isset($post['location_id']) && $post['location_id'] != "")
			{
				$whr['location_id'] = $post['location_id'];
			}

			if (isset($post['zipcode']) && $post['zipcode'] != "")
			{
				$whr['pincode'] = $post['zipcode'];
			}

			if (isset($post['cid']) && $post['cid'] != "")
			{
				$whr['code'] = $post['cid'];
			}

			if (isset($post['debitor_code']) && $post['debitor_code'] != "")
			{
				$whr['acon_debitor_code'] = $post['debitor_code'];
			}

			if (isset($post['fromdate']) && $post['fromdate'] != "")
			{
				$fromdate = date('Y-m-d', strtotime($post['fromdate']));
				$whr["DATE_FORMAT(created_on,'%Y-%m-%d') >="] = $fromdate;
			}

			if (isset($post['todate']) && $post['todate'] != "")
			{
				$todate  = date('Y-m-d', strtotime($post['todate']));
				$whr["DATE_FORMAT(created_on,'%Y-%m-%d') <="] = $todate;
			}

			$ArrayCountry = [];
			$ArrayBranch  = [];
			$ptypesArray  = [];

			$getpartners = $this->bpartners->getpartnerdata($uid,$obsolete_add,$whr,$company_code,$findPartyTypes);
			if($getpartners->num_rows() > 0){
				foreach ($getpartners->result() as $partner) {
					$userids[] = $partner->id;
					$partytypes=$ptypes=[];
					$party_types = $partner->party_types;
					$party_type_id = $partner->party_type_id;
					if($party_types != "") {
						$ptypes = explode(',', $party_types);
					}
					array_push($ptypes, $party_type_id);
					$partytypes = array_unique($ptypes);
					$party_type_names = $this->bpartners->getPartyTypeNamesByIdAndCompanyCode($partytypes,$company_code);

					$ArrayCountry[] = $partner->country;
					$ArrayBranch[] = $partner->branch_code;
					for($j=0; $j<count($party_type_names); $j++)
					{
						$ptypesArray[] = $party_type_names[$j];
					}

					$data['partners'][] = [
                        'id' => $partner->id,
                        'name' => $partner->name,
                        'location_id' => $partner->location_id,
                        'division_name' => $partner->division_name,
                        'sub_district' => $partner->sub_district,
                        'street' => $partner->street,
                        'street_2' => $partner->street_2,
                        'house_number' => $partner->house_number,
                        'building' => $partner->building,
                        'country' => $partner->country,
                        'state' => $partner->state,
                        'branch' => $partner->branch_code,
                        'pincode' => $partner->pincode,
                        'code' => $partner->code,
                        'customer_code' => $partner->customeridentifier,
                        'acon_debitor_code' => $partner->acon_debitor_code,
                        'kn_login_account' => $partner->kn_login_account,
                        'offering_type' => $partner->offering_type,
                        'carrier_grade' => $partner->carrier_grade,
                        'party_types' => $partner->party_types,
                        'party_type_id' => $partner->party_type_id,
                        'bpartner_partytys' => $party_type_names
                    ];
				}

				foreach ( array_unique($ArrayCountry) as $country) {
					$data['countries'][] = ['country_name'=>$country];
				}

				foreach ( array_unique($ArrayBranch) as $branch) {
					$data['branches'][] = ['branch_code'=>$branch];
				}

				foreach (array_unique($ptypesArray) as $party) {
					$data['partytypes'][] = ['name'=>ucfirst(strtolower($party))];
				}

			}
		}
		$data['listType'] = $listType;
		$data['excel_uploaddata'] = $excel_uploaddata;
		log_message("error","Data:".json_encode($data));
		$this->newtemplate->dashboard("businesspartners/index", $data);

	}

	public function addbusinesspartners(){
		//$data = [];
		$data = $contracts = $accounts = $data['actions'] = $data['ordertypes'] = $data['products'] =$data['services'] = $data['editypes'] = $data['transmodes'] = $data['incoterms'] = $data['orderstatuses'] = $data['currencies'] = [];
		$data['page_title'] = $this->lang->line('business_partners');
		$data['sub_title'] = $this->lang->line('general_add');
		$company_code = $this->session->userdata('company_code');
		$branch_code = $this->session->userdata('branch_code');
		$data['company_code'] = $company_code;
		$data['branch_code'] = $branch_code;
		$data['reftypes'] = $data['getparties'] = $data['partners'] = [];
		$uid = $this->session->userdata('user_id');
		$company_code = $this->session->userdata('company_code');
		$branch_code = $this->session->userdata('branch_code');
		$getParties = $this->bpartners->getpartytypes($uid,$company_code);
		if($getParties->num_rows() > 0){
			foreach ($getParties->result() as $gparty) {
				$data['getparties'][] = ['id'=>$gparty->id,'name'=>ucfirst(strtolower($gparty->name)),'description'=>$gparty->description];
			}
		}
		//---------------------ediapi---------

		$uid = $this->session->userdata('user_id');
		$company_code = $this->session->userdata('company_code');
		$branch_code = $this->session->userdata('branch_code');
        $this->db->select('id,name');
        $this->db->where('status', 1);
        $getActions = $this->db->get('tbl_txn_actions');
		if($getActions->num_rows() > 0){
			foreach ($getActions->result() as $actions) {
				$data['actions'][] = ['id'=>$actions->id,'name'=>$actions->name];
			}
		}
        $where = [
            'user_id' => 1,
            'status' => 1
        ];
        $this->db->select('id,name');
        $this->db->where($where);
        $getOrderTypes = $this->db->get('tbl_order_types');
        if($getOrderTypes->num_rows() > 0){
			foreach ($getOrderTypes->result() as $ordertype) {
				$data['ordertypes'][] = ['id'=>$ordertype->id,'name'=>$ordertype->name];
			}
		}
        $this->db->select('id,name');
        $this->db->where('status', 1);
        $getProducts = $this->db->get('tb_products_master');
		if($getProducts->num_rows() > 0){
			foreach ($getProducts->result() as $products) {
				$data['products'][] = ['id'=>$products->id,'name'=>$products->name];
			}
		}
        $this->db->select('id,name');
        $this->db->where('status', 1);
        $getServices = $this->db->get('tb_service_master');
		if($getServices->num_rows() > 0){
			foreach ($getServices->result() as $services) {
				$data['services'][] = ['id'=>$services->id,'name'=>$services->name];
			}
		}
        $this->db->select('id,code');
        $this->db->where('status', 1);
        $getTransportmode = $this->db->get('tb_transportmode');
		if($getTransportmode->num_rows() > 0){
			foreach ($getTransportmode->result() as $transmode) {
				$data['transmodes'][] = ['id'=>$transmode->id,'name'=>$transmode->code];
			}
		}
        $this->db->select('id,name');
        $this->db->where('status', 1);
        $getEdiTypes = $this->db->get('tbl_edi_types');
		if($getEdiTypes->num_rows() > 0){
			foreach ($getEdiTypes->result() as $editypes) {
				$data['editypes'][] = ['id'=>$editypes->id,'name'=>$editypes->name];
			}
		}
        $this->db->select('id,name');
        $this->db->where('status', 1);
        $getIncoterms = $this->db->get('tb_incoterms_master');
		if($getIncoterms->num_rows() > 0){
			foreach ($getIncoterms->result() as $incoterms) {
				$data['incoterms'][] = ['id'=>$incoterms->id,'name'=>$incoterms->name];
			}
		}
        $this->db->select('id,name');
        $this->db->where('status', 1);
        $getOrderStatuses = $this->db->get('tb_statuses');
		if($getOrderStatuses->num_rows() > 0){
			foreach ($getOrderStatuses->result() as $orderstatuses) {
				$data['orderstatuses'][] = ['id'=>$orderstatuses->id,'name'=>$orderstatuses->name];
			}
		}

		$data['contracts'] = $contracts;
		$data['accounts'] = $accounts;
		$data['company_code'] = $company_code;
		$data['branch_code'] = $branch_code;
		$country_code = substr($company_code, 0,2);
		$data['actual_currency'] = "";
		$getcurrencies =$this->common->gettbldata(['status'=>1],'country_code,currency','tbl_country_master',0,0);
		if(count($getcurrencies)>0){
			foreach($getcurrencies as $cury){
				$data['currencies'][] = $cury['currency'];
				if($country_code == $cury['country_code'] ){
					$data['actual_currency'] = $cury['currency'];
				}
			}
		}
        $getRefIds = $this->common->gettbldata(['status'=>1], "id,name,reference_type", 'tb_reference_types', 0, 0);
        $eBookingMasterData = $integrationMasterData = $visibilityMasterData = [];
        foreach ($getRefIds as $eachType) {
            $referenceType = $eachType['reference_type'];
            if ($referenceType == "eBooking") {
                $eBookingMasterData[] = ['id'=>$eachType['id'],'name'=>$eachType['name']];
            }
            if ($referenceType == "integration") {
                $integrationMasterData[] = ['id'=>$eachType['id'],'name'=>$eachType['name']];
            }
            if ($referenceType == "visibility") {
                $visibilityMasterData[] = ['id'=>$eachType['id'],'name'=>$eachType['name']];
            }
            $reftypes[] = ['id'=>$eachType['id'],'name'=>$eachType['name']];
        }
        $data['reftypes'] = $reftypes;
        $data['visibilityMasterData'] = $visibilityMasterData;
        $data['integrationMasterData'] = $integrationMasterData;
        $data['eBookingMasterData'] = $eBookingMasterData;
		//--------------------- End    ediapi---------
		//$this->newtemplate->dashboard("businesspartners/addbusinesspartner", $data);
		//-------- Vehicle Constarints-----------
		// Fetch all vehicle types
		$data['vehicletypes'] = [];
		$this->db->select('id, trucktype');
		$this->db->where('status', 1);
		$this->db->order_by('id', 'DESC');
		$getVehicleTypes = $this->db->get('tb_trucktypes');
		if($getVehicleTypes->num_rows() > 0){
			foreach ($getVehicleTypes->result() as $vehicle) {
				$data['vehicletypes'][] = ['id'=>$vehicle->id, 'name'=>$vehicle->trucktype,];
			}
		}

		$this->load->view("businesspartners/addbusinesspartner", $data);
	}



	/*insert Partner Data */
	public function insertpartnerdata(){

		$data = [];
		$uid = $this->session->userdata('user_id');
		$custid = $this->session->userdata("cust_id");
		$post = $this->input->post(NULL,TRUE);
        $eBooking = $post['ebooking'] ?? [];
        $integrations = $post['integration'] ?? [];
        $visibility = $post['visibility'] ?? [];
		$selected_vehicle_ids = isset($post['selected_vehicle_ids']) ? $post['selected_vehicle_ids'] : "";
		$customer_code = isset($post['customercode']) ? $post['customercode'] : "";
		$companycode = isset($post['company_code']) ? $post['company_code'] : "";
		$cid = isset($post['partner_cid']) ? $post['partner_cid'] : "";
		$cid = trim($cid);
		$branchcode = isset($post['branch_code']) ? $post['branch_code'] : "";
		$debitor_code = isset($post['partner_debitor_code']) ? $post['partner_debitor_code'] : "";
		$departmentcode = isset($post['departmentcode']) ? $post['departmentcode'] : "";
		$kn_login = isset($post['kn_login']) ? $post['kn_login'] : "";
		$bpassword = isset($post['password']) ? $post['password'] : "";
		$partytypes = implode(',', $post['partytypes']);
		$offering_type = isset($post['offering_type']) ? $post['offering_type'] : "";
		$carrier_grade = isset($post['carrier_grade']) ? $post['carrier_grade'] : "";
		$autoaccept = isset($post['autoaccept']) ? $post['autoaccept'] : 0;
		if($autoaccept == ""){ $autoaccept = 0; }
		$addrs_name = isset($post['addrs_name']) ? $post['addrs_name'] : "";
		$addrs_email = isset($post['addrs_email']) ? $post['addrs_email'] : "";
		$addrs_phone = isset($post['addrs_phone']) ? $post['addrs_phone'] : "";
		$division_name = isset($post['division_name']) ? $post['division_name'] : "";
		$sub_district = isset($post['sub_district']) ? $post['sub_district'] : "";
		$addrs_street = isset($post['addrs_street']) ? $post['addrs_street'] : "";
		$street_2 = isset($post['street_2']) ? $post['street_2'] : "";
		$street_3 = isset($post['street_3']) ? $post['street_3'] : "";
		$house_number = isset($post['house_number']) ? $post['house_number'] : "";
		$addrs_building = isset($post['addrs_building']) ? $post['addrs_building'] : "";
		$addrs_country = isset($post['addrs_country']) ? $post['addrs_country'] : "";
		$postal_code = isset($post['postal_code']) ? $post['postal_code'] : "";
		$addrs_city = isset($post['addrs_city']) ? $post['addrs_city'] : "";
		$addrs_province = isset($post['addrs_province']) ? $post['addrs_province'] : "";
		$addrs_extension = isset($post['addrs_extension']) ? $post['addrs_extension'] : "";
		$addrs_latitude = isset($post['addrs_latitude']) ? $post['addrs_latitude'] : "";
		$addrs_longitude = isset($post['addrs_longitude']) ? $post['addrs_longitude'] : "";
		$main_homepage = isset($post['main_homepage']) ? $post['main_homepage'] : "";
		$addrs_cid = isset($post['addrs_cid']) ? $post['addrs_cid'] : "";
		$category_type = isset($post['addrs_category']) ? $post['addrs_category'] : 0;
		if($category_type == ""){ $category_type = 0; }
		$category_id = isset($post['addrs_catid']) ? $post['addrs_catid'] : 0;
		if($category_id == ""){ $category_id = 0; }
		$zone_city = isset($post['zone_city']) ? $post['zone_city'] : "";
		$zone_code = isset($post['zone_code']) ? $post['zone_code'] : "";
		$zone_name = isset($post['zone_name']) ? $post['zone_name'] : "";
		$cargo_limit = isset($post['cargo_limit']) ? $post['cargo_limit'] : 0;
		if($cargo_limit == ""){ $cargo_limit = 0; }
		$limit_amount = isset($post['limit_amount']) ? $post['limit_amount'] : 0;
		if($limit_amount == ""){ $limit_amount = 0; }
		$currency = isset($post['currency']) ? $post['currency'] : "";

		$creditlimit = isset($post['creditlimit']) ? $post['creditlimit'] : 0;
		if($creditlimit == ""){ $creditlimit = 0; }
		$credit_limit_amount = isset($post['c_limit_amount']) ? $post['c_limit_amount'] : 0;
		if($credit_limit_amount == ""){ $credit_limit_amount = 0; }
		$credit_currency = isset($post['c_currency']) ? $post['c_currency'] : "";

		$invoice_type = isset($post['invoice_type']) ? $post['invoice_type'] : 0;
		if($invoice_type == ""){ $invoice_type = 0; }

		$cust_profile_id = isset($post['cust_profile_id']) ? $post['cust_profile_id'] : 0;
		if($cust_profile_id == ""){ $cust_profile_id = 0; }

		$ven_profile_id = isset($post['ven_profile_id']) ? $post['ven_profile_id'] : 0;
		if($ven_profile_id == ""){ $ven_profile_id = 0; }

		$vat_reg_no = isset($post['vat_reg_no']) ? $post['vat_reg_no'] : "";
		$tax_payer_no = isset($post['tax_payer_no']) ? $post['tax_payer_no'] : "";
		$contract_no = isset($post['contract_no']) ? $post['contract_no'] : "";
		$contract_date = isset($post['contract_date']) ? $post['contract_date'] : "";
		if($contract_date !=""){
			$contract_date=date('Y-m-d',strtotime($contract_date));
		}
		$auto_trip = isset($post['auto_trip']) ? $post['auto_trip'] : 0;
        if($auto_trip == ""){ $auto_trip = 0; }
		$tms_auto_trip = isset($post['tms_auto_trip']) ? $post['tms_auto_trip'] : 0;
        if($tms_auto_trip == ""){ $tms_auto_trip = 0; }
		$partnercontacts = $partnerrefs = $partneraccounts = $partnercontracts = $savedediapiid = [];
		if(isset($post['partnercontact'])){
			$partnercontacts = $post['partnercontact'];
		}
		if(isset($post['partnerrefs'])){
			$partnerrefs = $post['partnerrefs'];
		}
		if(isset($post['partneraccounts'])){
			$partneraccounts = $post['partneraccounts'];
		}
		if(isset($post['partnercontracts'])){
			$partnercontracts = $post['partnercontracts'];
		}
		if(isset($post['savedediapiid'])){
			$savedediapiid = $post['savedediapiid'];
		}
		$curdt = date('Y-m-d H:i:s');
		$data['partnerid'] = $customer_code;
		if($bpassword != ""){
			$bpassword =  password_hash($bpassword,PASSWORD_DEFAULT);
		}
		$custsessioncode = "";
		if($custid > 0){
            $where = [
                'id' => $custid,
                'status' => 1
            ];
            $this->db->select('code');
            $this->db->where($where);
            $this->db->limit(1);
            $getCustomers = $this->db->get('tb_customers');
            if($getCustomers->num_rows() > 0 ){
				$custsessioncode = $getCustomers->row()->code;
			}
		}
		$tariff_type = isset($post['tariff_type']) ? $post['tariff_type'] : 0;
		if($tariff_type == ""){ $tariff_type = 0; }
		$sendto_knlogin = isset($post['sendto_knlogin']) ? $post['sendto_knlogin'] : 0;
		if($sendto_knlogin == ""){ $sendto_knlogin = 0; }


		if($partytypes !=""){
			$partnerdata = [
				'party_type_id'=>0,
				'name'=>$addrs_name,
				'email'=>$addrs_email,
				'mobile'=>$addrs_phone,
				'user_id'=>$uid,
				'code'=>$cid,
				'company_code'=>$companycode,
				'branch_code'=>$branchcode,
				'department_code'=>$departmentcode,
				'customer_code'=>$custsessioncode,
				'parent_id'=>0,
				'location_id'=>$addrs_city,
				'country'=>$addrs_country,
				'state'=>$addrs_province,
				'division_name'=>$division_name,
				'sub_district'=>$sub_district,
				'street'=>$addrs_street,
				'pincode'=>$postal_code,
				'street_2'=>$street_2,
				'street_3'=>$street_3,
				'building'=>$addrs_building,
				'house_number'=>$house_number,
				'party_types'=>$partytypes,
				'extension'=>$addrs_extension,
				'latitude'=>$addrs_latitude,
				'longitude'=>$addrs_longitude,
				'homepage'=>$main_homepage,
				'category_type'=>$category_type,
				'category_id'=>$category_id,
				'time_zone_city'=>$zone_city,
				'time_zone_code'=>$zone_code,
				'time_zone_name'=>$zone_name,
				'acon_debitor_code'=>$debitor_code,
				'kn_login_account'=>$kn_login,
				'password'=>$bpassword,
				'offering_type'=>$offering_type,
				'carrier_grade'=>$carrier_grade,
				'autoaccept'=>$autoaccept,
				'cargo_limit'=>$cargo_limit,
				'limit_amount'=>$limit_amount,
				'currency'=>$currency,
				'credit_limit'=>$creditlimit,
				'credit_limit_amount'=>$credit_limit_amount,
				'credit_currency'=>$credit_currency,
				'vat_reg_no'=> $vat_reg_no,
				'tax_payer_no'=>$tax_payer_no,
				'contract_no'=>$contract_no,
				'contract_date'=>$contract_date,
				'invoice_type'=>$invoice_type,
				'status'=>1,
				'created_on'=>$curdt,
				'updated_on'=>$curdt
			];
			$partnerid = $this->common->insertTableData("tbl_party_master",$partnerdata);
			$ccode = mb_substr($companycode, 0, 2);
			$idlength = strlen($partnerid);
			$id = $partnerid;
			if($idlength =='1'){
				$id = "00000".$id;
			}else if($idlength == '2'){
				$id = "0000".$id;
			}else if($idlength == '3'){
				$id = "000".$id;
			}else if($idlength == '4'){
				$id ="00".$id;
			}else if($idlength == '5'){
				$id ="0".$id;
			}else{
				$id = $id;
			}
			$custcode = $ccode.$id;

			if($partnerid >0){
				$customer_id = $vendor_id = 0;
				$cus_companycode = $companycode;
				$cus_branchcode = $branchcode;
				$partytypesary = explode(',' ,$partytypes);
				$address = $addrs_street;
				if($street_2 != ""){
					$address .= ','.$street_2;
				}
				if($street_3 != ""){
					$address .= ','.$street_3;
				}
				if($house_number != ""){
					$address .= ','.$house_number;
				}
				if($addrs_city != ""){
					$address .= ','.$addrs_city;
				}
				if($addrs_province != ""){
					$address .= ','.$addrs_province;
				}
				$vendor_partyid = $customer_partyid = 0;
				$chkcarrierparty = $this->bpartners->chkpartytype($partytypesary,'Carrier');
				if($chkcarrierparty->num_rows() > 0){
					$vendor_partyid = $chkcarrierparty->row()->id;
					$vendarr = [
						'name'=>$addrs_name,
						'mobile'=>$addrs_phone,
						'location'=>$addrs_city,
						'address'=>$address,
						'pincode'=>$postal_code,
						'country'=>$addrs_country,
						'code'=>$cid,
						'offering_type'=>$offering_type,
						'carrier_grade'=>$carrier_grade,
						'email'=>$addrs_email,
						'password'=>$bpassword,
						'user_id'=>$uid,
                        'partyid'=>$partnerid,
						'company_code'=>$companycode,
						'branch_code'=>$branchcode,
						'status'=>1,
						'auto_accept'=>$auto_trip,
						'tms_auto_accept'=>$tms_auto_trip,
						'updated_on'=>$curdt
					];
                    $chk = $this->db->select('id')->get_where("tb_vendors", ['name' => $addrs_name, 'mobile' => $addrs_phone, 'code' => $cid, 'company_code' => $companycode, 'branch_code' => $branchcode]);
                    if($chk->num_rows()>0){
						$vendor_id = $chk->row()->id;
						$upd = $this->bpartners->updatedata('tb_vendors',$vendor_id,$vendarr);


						/* vendor profile code */
						if(!empty($ven_profile_id)){
							$chk_pro = $this->common->gettblrowdata(['party_id'=>$vendor_id],"id,vp_id","tb_vendor_profile_list",0,0);
							$pro_list=["vp_id"=>$ven_profile_id,"profile_id"=>$cid,"party_id"=>$vendor_id,"status"=>1];
							if(!empty($chk_pro)){
							$upd = $this->common->updatetbledata('tb_vendor_profile_list',$pro_list,['id'=>$chk_pro['id']]);
							}else{
								 $this->common->insertTableData("tb_vendor_profile_list",$pro_list);
							}
						}

					}else{
						$vendarr['created_on'] = $curdt;
						$vendor_id = $this->common->insertTableData("tb_vendors",$vendarr);
						/* vendor profile code */
						if(!empty($ven_profile_id)){
						$pro_list=["vp_id"=>$ven_profile_id,"profile_id"=>$cid,"party_id"=>$vendor_id,"status"=>1];
						$this->common->insertTableData("tb_vendor_profile_list",$pro_list);
						}
					}
					$rules = ['vendor_id'=>$vendor_id,'company_code'=>$companycode,'branch_code'=>$branchcode,'user_id'=>$uid,'createdon'=>$curdt,'rule_status'=>'Direct','status'=>1,'autoaccept'=>$autoaccept];
					$ins_vendor_rules = $this->common->insertTableData("tb_vendor_rules",$rules);
				}
				$chkcustparty = $this->bpartners->chkpartytype($partytypesary,'Customer');
				if($chkcustparty->num_rows() > 0){
					if($cid != ""){
						$customer_partyid = $chkcustparty->row()->id;
						$customer = [
							'partner_id'=>$partnerid,
							'name'=>$addrs_name,
							'phone'=>$addrs_phone,
							'street'=>$addrs_street,
							'location'=>$addrs_city,
							'pincode'=>$postal_code,
							'country'=>$addrs_country,
							'address'=>$address,
							'email_id'=>$addrs_email,
							'state'=>$addrs_province,
							'code'=>$cid,
							'password'=>$bpassword,
							'user_id'=>$uid,
							'updatedon'=>$curdt,
							'lat'=>$addrs_latitude,
							'lng'=>$addrs_longitude,
							'company_code'=>$cus_companycode,
							'branch_code'=>$cus_branchcode,
							'Tarifftype'=>$tariff_type,
							'sendto_knlogin'=>$sendto_knlogin
						];
						if(preg_match('/[A-Za-z].*[0-9]|[0-9].*[A-Za-z]/', $kn_login)){
							$knlen = strlen($kn_login);
							if(($knlen > 9) && ($knlen < 16)){
								$customer['kn_login'] = 1;
							}
						}
                        $chk = $this->db->select('id')->get_where("tb_customers", ['code' => $cid, 'company_code' => $companycode, 'status' => 1]);
						if($chk->num_rows()>0){
							$customer_id = $chk->row()->id;
							$upd = $this->bpartners->updatedata('tb_customers',$customer_id,$customer);

							/* customer profile code */
							if(!empty($cust_profile_id)){
								$chk_pro = $this->common->gettblrowdata(['party_id'=>$customer_id],"id,cp_id","tb_customer_profile_list",0,0);
								$cus_pro_list=["cp_id"=>$cust_profile_id,"profile_id"=>$cid,"party_id"=>$customer_id,"status"=>1];
								if(!empty($chk_pro)){

								$upd = $this->common->updatetbledata('tb_customer_profile_list',$cus_pro_list,['id'=>$chk_pro['id']]);
								}else{
									$customer_id1 = $this->common->insertTableData("tb_customer_profile_list",$cus_pro_list);
								}


							}
						}else{

							$customer['createdon'] = $curdt;
							$customer_id = $this->common->insertTableData("tb_customers",$customer);
							if(!empty($cust_profile_id)){
								$cus_pro_list=["cp_id"=>$cust_profile_id,"profile_id"=>$cid,"party_id"=>$customer_id,"status"=>1];
								$customer_id1 = $this->common->insertTableData("tb_customer_profile_list",$cus_pro_list);
							}
						}
					}
				}
				$upd = ['customeridentifier'=>$custcode];
				if($customer_partyid > 0){
					$upd['party_type_id'] = $customer_partyid;
				}else if($vendor_partyid > 0){
					$upd['party_type_id'] = $vendor_partyid;
				}else if(isset($post['partytypes'][0])){
					$upd['party_type_id'] = $post['partytypes'][0];
				}
				if($upd['party_type_id'] == "" ){ $upd['party_type_id'] = 0;}
				$updatecode = $this->bpartners->updatedata('tbl_party_master',$partnerid,$upd);

				if(count($partnercontacts)>0){
					$contactdata = ["partnerid"=>$partnerid,"party_type_id"=>$upd['party_type_id'],"uid"=>$uid,"curdt"=>$curdt];
					$savecontacts = $this->savepartnercontacts($partnercontacts,$contactdata,$partnerdata);
				}
				if(count($partnerrefs)>0) {
                    // $refdata = [];
                    $refdata = $uniqueRecords= [];
                    $reference_type = $name = $value = $gstin = $description = "";
                    foreach ($partnerrefs as $refs) {
                        $refs = explode('||', $refs);
                        if (isset($refs[0])) {
                            $reference_type = $refs[0];
                        }
                        if (isset($refs[1])) {
                            $name = $refs[1];
                        }
                        if (isset($refs[2])) {
                            $value = $refs[2];
                        }
                        if (isset($refs[3])) {
                            $description = $refs[3];
                        }
                        if (isset($refs[4])) {
                            $gstin = $refs[4];
                        }
                        $refdata = ['reference_type'=>$reference_type,'partner_id'=>$partnerid,'name'=>$name,'value'=>$value,'description'=>$description,'gstin'=>$gstin,'user_id'=>$uid,'status'=>1,'createdon'=>$curdt,'updatedon'=>$curdt];
                        $lrefid = $this->common->insertTableData("tb_party_reference",$refdata);
                    }
                }
				if(count($partneraccounts)>0){
					$accountdata = [];
					$acon_environment =  $acc_company = $source_system = $billable = $pre_payment = $mutiple_invoices = "";
					foreach ($partneraccounts as $account) {
						$account = explode('||',$account);
						if(isset($account[0])){ $account_number = $account[0]; }
						if(isset($account[1])){ $acon_environment = $account[1]; }
						if(isset($account[2])){ $acc_company = $account[2]; }
						if(isset($account[3])){ $source_system = $account[3]; }
						if(isset($account[4])){ $billable = $account[4]; }
						if(isset($account[5])){ $pre_payment = $account[5]; }
						if(isset($account[6])){ $mutiple_invoices = $account[6]; }
						$accountdata = ['partner_id'=>$partnerid,'account_number'=>$account_number,'acon_environment'=>$acon_environment,'company_code'=>$acc_company,'source_system'=>$source_system,'billable'=>$billable,'pre_payment'=>$pre_payment,'mutiple_invoices'=>$mutiple_invoices,'user_id'=>$uid,'status'=>1,'created_on'=>$curdt,'updated_on'=>$curdt];
						$acc_id = $this->common->insertTableData("tbl_partner_accounts",$accountdata);
					}
				}
				if(count($partnercontracts)>0){
					$contractdata = [];
					$contract_company =  $contract_branch = $contract_id = $rate_derivation  = "";
					foreach ($partnercontracts as $contract) {
						$contract = explode('||',$contract);
						if(isset($contract[0])){ $contract_company = $contract[0]; }
						if(isset($contract[1])){ $contract_branch = $contract[1]; }
						if(isset($contract[2])){ $contract_id = $contract[2]; }
						if(isset($contract[3])){ $rate_derivation = $contract[3]; }
						$contractdata = ['partner_id'=>$partnerid,'company_code'=>$contract_company,'branch_code'=>$contract_branch,'contract_id'=>$contract_id,'rate_derivation'=>$rate_derivation,'user_id'=>$uid,'status'=>1,'created_on'=>$curdt,'updated_on'=>$curdt];
						$cntr_id = $this->common->insertTableData("tbl_partner_contracts",$contractdata);
					}
				}
				if(count($savedediapiid)>0){
					foreach ($savedediapiid as $ediapiid) {
						$pid = ['partner_id'=>$partnerid];
						$upd = $this->bpartners->updatedata('tbl_partner_ediapi',$ediapiid,$pid);
						if($customer_id > 0){
                            $this->db->select('o.name as ordertype');
                            $this->db->where('pe.id',$ediapiid);
                            $this->db->join('tbl_order_types o', 'o.id = pe.order_type');
                            $getOrderType = $this->db->get('tbl_partner_ediapi pe');
                            if($getOrderType->num_rows() > 0){
								$order_type = $getOrderType->row()->ordertype;
								if($order_type != ""){
									$this->db->select("id");
									$this->db->from("tb_order_types");
									$this->db->where("type_name", $order_type);
									$this->db->where("company_code", $cus_companycode);
									$this->db->where("branch_code", $cus_branchcode);
									$this->db->where("customer_id", $customer_id);
									$this->db->where("status", 1);
									$chkordtype = $this->db->get();
									if($chkordtype->num_rows() == 0){
										$ordtype_code = mb_substr($order_type, 0, 1);
										$orderdata = ['type_name'=>$order_type, 'description'=>$order_type, 'company_code'=>$cus_companycode, 'branch_code'=>$cus_branchcode, 'customer_id'=>$customer_id, 'ordtype_code'=>$ordtype_code, 'status'=>'1', 'createdon'=>$curdt, 'updatedon'=>$curdt];
										$insordtype = $this->common->insertTableData("tb_order_types",$orderdata);
									}
								}
							}
						}
					}
				}
                if (!empty($eBooking)) {
                    foreach ($eBooking as $eachRow) {
                        $referenceName = $this->common->gettblrowdata(['id' => $eachRow], 'name', 'tb_reference_types', 0, 0);
                        $partyReferenceData = ['reference_type' => $eachRow, 'partner_id' => $partnerid, 'name' => $referenceName['name'], 'value' => 'Y', 'user_id' => $uid, 'status' => 1, 'createdon' => $curdt, 'updatedon' => $curdt];
                        $this->common->insertTableData("tb_party_reference", $partyReferenceData);
                    }
                }
                if (!empty($integrations)) {
                    foreach ($integrations as $eachRow) {
                        $referenceName = $this->common->gettblrowdata(['id' => $eachRow], 'name', 'tb_reference_types', 0, 0);
                        $partyReferenceData = ['reference_type' => $eachRow, 'partner_id' => $partnerid, 'name' => $referenceName['name'], 'value' => 'Y', 'user_id' => $uid, 'status' => 1, 'createdon' => $curdt, 'updatedon' => $curdt];
                        $this->common->insertTableData("tb_party_reference", $partyReferenceData);
                    }
                }
                if (!empty($visibility)) {
                    foreach ($visibility as $eachRow) {
                        $referenceName = $this->common->gettblrowdata(['id' => $eachRow], 'name', 'tb_reference_types', 0, 0);
                        $partyReferenceData = ['reference_type' => $eachRow, 'partner_id' => $partnerid, 'name' => $referenceName['name'], 'value' => 'Y', 'user_id' => $uid, 'status' => 1, 'createdon' => $curdt, 'updatedon' => $curdt];
                        $this->common->insertTableData("tb_party_reference", $partyReferenceData);
                    }
                }

				$days = $this->input->post('days');
				$start_times = $this->input->post('start_time');
				$end_times = $this->input->post('end_time');
				$operation_types = $this->input->post('operation_type');
				$row_active = $this->input->post('row_active');

				if (!empty($days) && is_array($days)) {
					foreach ($days as $i => $day) {
						if (empty($row_active[$i])) continue;
						if (empty($day) || empty($operation_types[$i])) continue;

						$opType = ($operation_types[$i] == 'pickup') ? 1 : 2;

						$constraint_data = [
							'partner_id'         => $partnerid,
							'day'                => $day,
							'type'               => $opType,
							'pickup_start_time'  => ($opType == 1) ? ($start_times[$i] ?: "00:00:00") : "00:00:00",
							'pickup_end_time'    => ($opType == 1) ? ($end_times[$i]   ?: "00:00:00") : "00:00:00",
							'drop_start_time'    => ($opType == 2) ? ($start_times[$i] ?: "00:00:00") : "00:00:00",
							'drop_end_time'      => ($opType == 2) ? ($end_times[$i]   ?: "00:00:00") : "00:00:00",
							'status'             => 1,
							'createdon'          => $curdt,
							
						];
						$this->common->insertTableData('partner_timeconstraints', $constraint_data);
					}
				}

				if($partnerid > 0 && !empty($selected_vehicle_ids)){
					// Convert comma-separated string to array
					$vehicleIdsArray = explode(',', $selected_vehicle_ids);
					
					// Remove any empty values and trim whitespace
					$vehicleIdsArray = array_filter(array_map('trim', $vehicleIdsArray));
					
					// Insert each vehicle type for this partner
					foreach($vehicleIdsArray as $vehicleId){
						if(!empty($vehicleId) && is_numeric($vehicleId)){
							$vehicleData = [
								'partner_id' => $partnerid,
								'trucktype_id' => $vehicleId,
								'status' => 1,
								'createdon'=> $curdt,
							];
							$this->common->insertTableData("partner_vehicletypes", $vehicleData);
							
						}
					}
				}

				$data = ['partnerid'=>$partnerid];
			}
		}
		echo json_encode($partnerid);

	}



	public function editBusinesspartner($id){

		$ediapidata =  $data['actions'] = $data['ordertypes'] = $data['products'] =$data['services'] = $data['editypes'] = $data['transmodes'] = $data['incoterms'] = $data['orderstatuses'] = [];

		$data = $partnerdata = $condata = $refdata = $reftypes = $party_type_names = $accountndata = $contractsdata = $ediapidata =  $partytypes = $ptypes = [];
		if($id !=""){
			$getParties =[];
			$uid = $this->session->userdata('user_id');
			$company_code = $this->session->userdata('company_code');
			$branch_code = $this->session->userdata('branch_code');
			$getParties1 = $this->bpartners->getpartytypes($uid,$company_code);
			if($getParties1->num_rows() > 0){
				foreach ($getParties1->result() as $gparty) {
					$getParties[] = ['id'=>$gparty->id,'name'=>ucfirst(strtolower($gparty->name)),'description'=>$gparty->description];
				}
			}
			$party_type_id = 0;
            $where = [
                'id' => $id,
                'status' => 1
            ];
            $this->db->select('*');
            $this->db->where($where);
            $this->db->order_by('created_on','DESC');
            $getParty = $this->db->get('tbl_party_master');
            if($getParty->num_rows() >0){
				$party_types = $getParty->row()->party_types;
				$party_type_id = $getParty->row()->party_type_id;
				if($party_types != ""){
					$ptypes = explode(',', $party_types);
				}
				array_push($ptypes, $party_type_id);
				$partytypes = array_unique($ptypes);
				$party_type_names = $this->bpartners->getpartytypenamesbyids($partytypes,$company_code,$uid);
				$bpassword = $getParty->row()->password;
				if($bpassword != ""){
					$bpassword = (($bpassword));
				}
				$category_id = $getParty->row()->category_id;
				$categorydata =	[];
				if($category_id > 0){
					$getcatname = $this->bpartners->getcategoryname($category_id);
					$categorydata =	['id'=>$category_id,'name'=>$getcatname];
				}
				$chkcarrierparty = $this->bpartners->chkpartytype($partytypes,'Carrier');
				$auto_accept_trip=0;
				$tms_auto_accept_trip=0;
				$carrier_p_id=0;
				if($chkcarrierparty->num_rows() > 0){
					$code_cid=trim($getParty->row()->code);
                    $where = [
                        'partyid' => $id,
                        'code' => $code_cid,
                        'status' => 1
                    ];
                    $this->db->select('id,auto_accept,tms_auto_accept');
                    $this->db->where($where);
                    $getVendors = $this->db->get('tb_vendors');
                    if($getVendors->num_rows() >0){
                        $auto_accept_trip = $getVendors->row()->auto_accept;
						$tms_auto_accept_trip = $getVendors->row()->tms_auto_accept;
						$carrier_p_id = $getVendors->row()->id;

					}
				}
				$cus_p_id=$sendto_knlogin=$Tarifftype=0;
				$chkcusparty = $this->bpartners->chkpartytype($partytypes,'Customer');
				if($chkcusparty->num_rows() > 0){
					$code_cid=trim($getParty->row()->code);
					$chk_p_id =$this->common->gettblrowdata(['code'=>$code_cid,'company_code'=>$company_code,'status'=>'1'],'*','tb_customers',0,0);
					if(!empty($chk_p_id)){
					  $cus_p_id = $chk_p_id['id'];
					  $sendto_knlogin = $chk_p_id['sendto_knlogin'];
					  $Tarifftype = $chk_p_id['Tarifftype'];
					}
				}
				$customer_profile_id= $vendor_profile_id=$cus_profile_id=$ven_profile_id="";
				$cus_pro_id = $this->bpartners->getcustprofile($getParty->row()->id);
				if(!empty($cus_pro_id)){
					$customer_profile_id=$cus_pro_id['cust_profile_id'];
					$cus_profile_id=$cus_pro_id['cp_id'];
				}
				$ven_pro_id = $this->bpartners->getvendorprofile($getParty->row()->code);
				if(!empty($ven_pro_id)){
					$vendor_profile_id=$ven_pro_id['vend_profile_id'];
					$ven_profile_id=$ven_pro_id['vp_id'];
				}

				$data = [
					'party_type_names'=>$party_type_names,
					'partytypes'=>$partytypes,
					'carrier_p_id'=>$carrier_p_id,
					'cus_p_id'=>$cus_p_id,
					'auto_accept'=>$auto_accept_trip,
					'tms_auto_accept'=>$tms_auto_accept_trip,
					'name'=>$getParty->row()->name,
					'email'=>$getParty->row()->email,
					'mobile'=>$getParty->row()->mobile,
					'location_id'=>$getParty->row()->location_id,
					'division_name'=>$getParty->row()->division_name,
					'sub_district'=>$getParty->row()->sub_district,
					'street'=>$getParty->row()->street,
					'street_2'=>$getParty->row()->street_2,
					'street_3'=>$getParty->row()->street_3,
					'house_number'=>$getParty->row()->house_number,
					'building'=>$getParty->row()->building,
					'state'=>$getParty->row()->state,
					'pincode'=>$getParty->row()->pincode,
					'country'=>$getParty->row()->country,
					'extension'=>$getParty->row()->extension,
					'latitude'=>$getParty->row()->latitude,
					'longitude'=>$getParty->row()->longitude,
					'homepage'=>$getParty->row()->homepage,
					'category_type'=>$getParty->row()->category_type,
					'categorydata'=>$categorydata,
					'time_zone_city'=>$getParty->row()->time_zone_city,
					'time_zone_code'=>$getParty->row()->time_zone_code,
					'time_zone_name'=>$getParty->row()->time_zone_name,
					'code'=>$getParty->row()->code,
					'company_code'=>$getParty->row()->company_code,
					'branch_code'=>$getParty->row()->branch_code,
					'department_code'=>$getParty->row()->department_code,
					'customer_code'=>$getParty->row()->customeridentifier,
					'acon_debitor_code'=>$getParty->row()->acon_debitor_code,'kn_login_account'=>$getParty->row()->kn_login_account,
					'password'=>$bpassword,
					'offering_type'=>$getParty->row()->offering_type,
					'carrier_grade'=>$getParty->row()->carrier_grade,
					'autoaccept'=>$getParty->row()->autoaccept,
					'cargo_limit'=>$getParty->row()->cargo_limit,
					'limit_amount'=>$getParty->row()->limit_amount,
					'currency'=>$getParty->row()->currency,
					'credit_limit'=>$getParty->row()->credit_limit,
					'credit_limit_amount'=>$getParty->row()->credit_limit_amount,
					'credit_currency'=>$getParty->row()->credit_currency,
					'vat_reg_no'=>$getParty->row()->vat_reg_no,
					'tax_payer_no'=>$getParty->row()->tax_payer_no,
					'contract_no'=>$getParty->row()->contract_no,
					'contract_date'=>$getParty->row()->contract_date,
					'invoice_type'=>$getParty->row()->invoice_type,
					'cust_profile_id'=>$cus_profile_id,
					'customer_profile_id'=>$customer_profile_id,
					'ven_profile_id'=>$ven_profile_id,
					'vendor_profile_id'=>$vendor_profile_id,
					'Tarifftype'=>$Tarifftype,
					'sendto_knlogin'=>$sendto_knlogin,
					'partner_id'=>$id
				];
			}
            $where = [
                'partner_id' => $id,
                'status' => 1
            ];
            $this->db->select('*');
            $this->db->where($where);
            $getPartnerContacts = $this->db->get('tbl_partner_contacts');
            if($getPartnerContacts->num_rows() >0){
				foreach ($getPartnerContacts->result() as $contact) {
					$condata[] = ['id'=>$contact->id,'name'=>$contact->name,'street'=>$contact->street,'city'=>$contact->city,'state'=>$contact->state,'country'=>$contact->country,'zipcode'=>$contact->zipcode,'phone'=>$contact->phone,'fax'=>$contact->fax,'email'=>$contact->email];
				}

			}

            $where = [
                'partner_id' => $id,
                'status' => 1
            ];
            $this->db->select('*');
            $this->db->where($where);
            $this->db->group_by('name');
            $getPartyReference = $this->db->get('tb_party_reference');
            if($getPartyReference->num_rows() >0){
				$reftype = "";
				foreach ($getPartyReference->result() as $refs) {
                    $where = [
                        'id' => $refs->reference_type,
                        'status' => 1
                    ];
                    $this->db->select('name');
                    $this->db->where($where);
                    $getReferenceTypes = $this->db->get('tb_reference_types');
                    if($getReferenceTypes->num_rows() >0){
						$reftype = $getReferenceTypes->row()->name;
					}
					$refdata[] = ['id'=>$refs->id,'reference_type'=>$refs->reference_type,'reftype'=>$reftype,'name'=>$refs->name,'value'=>$refs->value,'description'=>$refs->description,'gstin'=>$refs->gstin];
				}
			}
		}
		$data['condata'] = $condata;
		$data['refdata'] = $refdata;
		$data['getparties'] = $getParties;
		$data['partner_id'] = $id;

      //$this->load->view('businesspartners/partnerdetails',$data);

	  ///------------financials data------------------
		if($id !=""){
            $where = [
                'partner_id' => $id,
                'status' => 1
            ];
            $this->db->select('*');
            $this->db->where($where);
            $getPartnerAccounts = $this->db->get('tbl_partner_accounts');
            if($getPartnerAccounts->num_rows() >0){
				foreach ($getPartnerAccounts->result() as $account) {
					$accountndata[] = ['id'=>$account->id,'account_number'=>$account->account_number,'acon_environment'=>$account->acon_environment,'company_code'=>$account->company_code,'source_system'=>$account->source_system,'billable'=>$account->billable,'pre_payment'=>$account->pre_payment,'mutiple_invoices'=>$account->mutiple_invoices];
				}
			}
            $where = [
                'partner_id' => $id,
                'status' => 1
            ];
            $this->db->select('*');
            $this->db->where($where);
            $getPartnerContracts = $this->db->get('tbl_partner_contracts');
            if($getPartnerContracts->num_rows() >0){
				foreach ($getPartnerContracts->result() as $contract) {
					$contractsdata[] = ['id'=>$contract->id,'company_code'=>$contract->company_code,'branch_code'=>$contract->branch_code,'contract_id'=>$contract->contract_id,'rate_derivation'=>$contract->rate_derivation];
				}
			}
		}
		$data['accountndata'] = $accountndata;
		$data['contractsdata'] = $contractsdata;
	  ///------------END financials data------------------
	  ///------------Ediapi data------------------
        $this->db->select('id,name');
        $this->db->where('status',1);
        $getActions = $this->db->get('tbl_txn_actions');
		if($getActions->num_rows() > 0){
			foreach ($getActions->result() as $actions) {
				$data['actions'][] = ['id'=>$actions->id,'name'=>$actions->name];
			}
		}
        $where = [
            'user_id' => 1,
            'status' => 1
        ];
        $this->db->select('id,name');
        $this->db->where($where);
        $getOrderTypes = $this->db->get('tbl_order_types');
        if($getOrderTypes->num_rows() > 0){
			foreach ($getOrderTypes->result() as $ordertype) {
				$data['ordertypes'][] = ['id'=>$ordertype->id,'name'=>$ordertype->name];
			}
		}
        $this->db->select('id,name');
        $this->db->where('status',1);
        $getProducts = $this->db->get('tb_products_master');
		if($getProducts->num_rows() > 0){
			foreach ($getProducts->result() as $products) {
				$data['products'][] = ['id'=>$products->id,'name'=>$products->name];
			}
		}
        $this->db->select('id,name');
        $this->db->where('status',1);
        $getServices = $this->db->get('tb_service_master');
		if($getServices->num_rows() > 0){
			foreach ($getServices->result() as $services) {
				$data['services'][] = ['id'=>$services->id,'name'=>$services->name];
			}
		}
        $this->db->select('id,code');
        $this->db->where('status',1);
        $getTransportmode = $this->db->get('tb_transportmode');
		if($getTransportmode->num_rows() > 0){
			foreach ($getTransportmode->result() as $transmode) {
				$data['transmodes'][] = ['id'=>$transmode->id,'name'=>$transmode->code];
			}
		}
        $this->db->select('id,name');
        $this->db->where('status',1);
        $getEdiTypes = $this->db->get('tbl_edi_types');
		if($getEdiTypes->num_rows() > 0){
			foreach ($getEdiTypes->result() as $editypes) {
				$data['editypes'][] = ['id'=>$editypes->id,'name'=>$editypes->name];
			}
		}
        $this->db->select('id,name');
        $this->db->where('status',1);
        $getIncoterms = $this->db->get('tb_incoterms_master');
		if($getIncoterms->num_rows() > 0){
			foreach ($getIncoterms->result() as $incoterms) {
				$data['incoterms'][] = ['id'=>$incoterms->id,'name'=>$incoterms->name];
			}
		}
        $this->db->select('id,name');
        $this->db->where('status',1);
        $getOrderStatuses = $this->db->get('tb_statuses');
		if($getOrderStatuses->num_rows() > 0){
			foreach ($getOrderStatuses->result() as $orderstatuses) {
				$data['orderstatuses'][] = ['id'=>$orderstatuses->id,'name'=>$orderstatuses->name];
			}
		}
		if($id !=""){
            $this->db->select(
                'pe.id as ediid,
                t.name as action,
                i.name as inco_terms,
                pe.triggered_at,
                pe.retrigger,
                o.name as ordertype,
                st.name as orderstatus,
                p.name as ediproduct,
                s.name as ediservice,
                m.code as editransport,
                pe.pickup,
                pe.destination,
                pe.commodity,
                e.name as ediapitype,
                pe.edi_url,
                f.name as filename'
            );
            $where = [
                'partner_id' => $id,
                'pe.status' => '1'
            ];
            $this->db->join('tbl_txn_actions t', 't.id=pe.transaction_action', 'left');
            $this->db->join('tb_incoterms_master i', 'i.id=pe.inco_terms', 'left');
            $this->db->join('tbl_order_types o', 'o.id=pe.order_type', 'left');
            $this->db->join('tb_products_master p', 'p.id=pe.product', 'left');
            $this->db->join('tb_service_master s', 's.id=pe.service', 'left');
            $this->db->join('tb_transportmode m', 'm.id=pe.mode_transport', 'left');
            $this->db->join('tbl_edi_types e', 'e.id=pe.type', 'left');
            $this->db->join('tbl_edi_files f', 'f.id=pe.file_id', 'left');
            $this->db->join('tb_statuses st', 'st.id=pe.order_status', 'left');
            $this->db->where($where);
            $getPartnerEdiApi = $this->db->get('tbl_partner_ediapi pe');
			if($getPartnerEdiApi->num_rows() >0){
				foreach($getPartnerEdiApi->result() as $ediapidt){

					if($ediapidt->triggered_at > 0){
						if($ediapidt->triggered_at == 1){
							$triggeredat = "Order Booked";
						}else if($ediapidt->triggered_at == 2){
							$triggeredat = "Trip Created";
						}
					}else{
						$triggeredat = "";
					}
					if($ediapidt->retrigger > 0){
						if($ediapidt->retrigger == 1){
							$retriggerat = "Updated";
						}else if($ediapidt->retrigger == 2){
							$retriggerat = "None";
						}
					}else{
						$retriggerat = "";
					}
					$file = "";
					if($ediapidt->filename != ""){
						$documentlink = base_url()."assets/xsduploads/".$ediapidt->filename;
						$document = "<a href=".$documentlink." download>File</a>";
						$file = $document;
					}
					$actionbut =  "<button class='btn btn-primary' id='editedi' title='Edit' ><small><i class='glyphicon glyphicon-pencil'></i></small></button>
					<button class='btn btn-primary' id='deleteedi' title='Delete' ><small><i class='glyphicon glyphicon-trash'></i></small></button>";
					$ediapidata[] = ['action'=>$ediapidt->action, 'inco_terms'=>$ediapidt->inco_terms,'triggeredat'=>$triggeredat,'retriggerat'=>$retriggerat,'ordertype'=>$ediapidt->ordertype,'order_status'=>$ediapidt->orderstatus,'ediproduct'=> $ediapidt->ediproduct,'ediservice'=> $ediapidt->ediservice,'editransport'=> $ediapidt->editransport,'edi_pickup'=>$ediapidt->pickup,'edi_destination'=>$ediapidt->destination,'edi_commodity'=>$ediapidt->commodity,'ediapitype'=> $ediapidt->ediapitype,'edi_url'=>$ediapidt->edi_url,'file'=>$file,'ediid'=>$ediapidt->ediid,'actionbut'=>$actionbut];
				}
			}
		}
		$getcurrencies =$this->common->gettbldata(['status'=>1],'country_code,currency','tbl_country_master',0,0);
		if(count($getcurrencies)>0){
			foreach($getcurrencies as $cury){
				$data['currencies'][] = $cury['currency'];
			}
		}
        $getRefIds = $this->common->gettbldata(['status'=>1], "id,name,reference_type", 'tb_reference_types', 0, 0);
        $eBookingMasterData = $integrationMasterData = $visibilityMasterData = [];
        foreach ($getRefIds as $eachType) {
            $referenceType = $eachType['reference_type'];
            if ($referenceType == "eBooking") {
                $eBookingMasterData[] = ['id'=>$eachType['id'],'name'=>$eachType['name']];
            }
            if ($referenceType == "integration") {
                $integrationMasterData[] = ['id'=>$eachType['id'],'name'=>$eachType['name']];
            }
            if ($referenceType == "visibility") {
                $visibilityMasterData[] = ['id'=>$eachType['id'],'name'=>$eachType['name']];
            }
            $reftypes[] = ['id'=>$eachType['id'],'name'=>$eachType['name']];
        }

		// --------------Constraints--------------
		 // 1. Get all vehicle types
		$this->db->select('id, trucktype');
		$this->db->where('status', 1);
		$this->db->order_by('id', 'DESC');
		$q = $this->db->get('tb_trucktypes');
		$allVehicleTypes = [];
		foreach ($q->result() as $row) {
			$allVehicleTypes[$row->id] = $row->trucktype;
		}

		// 2. Get assigned vehicle types for this partner
		$this->db->select('trucktype_id');
		$this->db->where('partner_id', $id);
		$this->db->where('status', 1);
		$a = $this->db->get('partner_vehicletypes');
		$assignedTypeIds = [];
		foreach ($a->result() as $row) {
			$assignedTypeIds[] = $row->trucktype_id;
		}

		// 3. Prepare arrays for view
		$assignedTypes = [];
		$unassignedTypes = [];
		foreach ($allVehicleTypes as $vid => $vname) {
			if (in_array($vid, $assignedTypeIds)) {
				$assignedTypes[] = ['id' => $vid, 'vehiclename' => $vname];
			} else {
				$unassignedTypes[] = ['id' => $vid, 'vehiclename' => $vname];
			}
		}

		$data['assignedTypes'] = $assignedTypes;
		$data['unassignedTypes'] = $unassignedTypes;

		if ($id) {
        // Existing partner data queries...
        
      
        $this->db->where('partner_id', $id);
        $this->db->where('status', 1);
        $constraints = $this->db->get('partner_timeconstraints')->result_array();
        $data['time_constraints'] = $constraints;
        
    	}
		// -----------END Constraints-------------

        $data['reftypes'] = $reftypes;
        $data['visibilityMasterData'] = $visibilityMasterData;
        $data['integrationMasterData'] = $integrationMasterData;
        $data['eBookingMasterData'] = $eBookingMasterData;
		$data['ediapidata'] = $ediapidata;
		$data['page_title'] = $this->lang->line('business_partners');
		$data['sub_title'] = $this->lang->line('general_edit');
		//$this->newtemplate->dashboard("businesspartners/editbusinesspartner", $data);
		$this->load->view("businesspartners/editbusinesspartner", $data);
	}


	/*Update Partner Data */
    public function updatepartnerdata(){
    	$data = [];
    	$data['status'] = 0;
    	$uid = $this->session->userdata('user_id');
    	$post = $this->input->post(NULL,TRUE);
        $eBooking = $post['ebooking'] ?? [];
        $integrations = $post['integration'] ?? [];
        $visibility = $post['visibility'] ?? [];
    	$partner_id = isset($post['partner_id']) ? $post['partner_id'] : '0';
    	if($partner_id > 0){
    		$customer_code = isset($post['customer_code']) ? $post['customer_code'] : "";
    		$companycode = isset($post['company_code']) ? $post['company_code'] : "";
    		$cid = isset($post['partner_cid']) ? $post['partner_cid'] : "";
    		$cid = trim($cid);
    		$branchcode = isset($post['branch_code']) ? $post['branch_code'] : "";
    		$debitor_code = isset($post['partner_debitor_code']) ? $post['partner_debitor_code'] : "";
    		$departmentcode = isset($post['departmentcode']) ? $post['departmentcode'] : "";
    		$kn_login = isset($post['kn_login']) ? $post['kn_login'] : "";
    		$bpassword = isset($post['password']) ? $post['password'] : "";
    		$partytypes = "";
    		if(isset($post['partytypes'])){
    			$partytypes = implode(',', $post['partytypes']);
    		}
    		$offering_type = isset($post['offering_type']) ? $post['offering_type'] : "";
    		$carrier_grade = isset($post['carrier_grade']) ? $post['carrier_grade'] : "";
    		$autoaccept = isset($post['autoaccept']) ? $post['autoaccept'] : 0;
    		if($autoaccept == ""){ $autoaccept = 0; }
    		$addrs_name = isset($post['addrs_name']) ? $post['addrs_name'] : "";
    		$addrs_email = isset($post['addrs_email']) ? $post['addrs_email'] : "";
    		$addrs_phone = isset($post['addrs_phone']) ? $post['addrs_phone'] : "";
    		$division_name = isset($post['division_name']) ? $post['division_name'] : "";
    		$sub_district = isset($post['sub_district']) ? $post['sub_district'] : "";
    		$addrs_street = isset($post['addrs_street']) ? $post['addrs_street'] : "";
    		$street_2 = isset($post['street_2']) ? $post['street_2'] : "";
    		$street_3 = isset($post['street_3']) ? $post['street_3'] : "";
    		$house_number = isset($post['house_number']) ? $post['house_number'] : "";
    		$addrs_building = isset($post['addrs_building']) ? $post['addrs_building'] : "";
    		$addrs_country = isset($post['addrs_country']) ? $post['addrs_country'] : "";
    		$postal_code = isset($post['postal_code']) ? $post['postal_code'] : "";
    		$addrs_city = isset($post['addrs_city']) ? $post['addrs_city'] : "";
    		$addrs_province = isset($post['addrs_province']) ? $post['addrs_province'] : "";
    		$addrs_extension = isset($post['addrs_extension']) ? $post['addrs_extension'] : "";
    		$addrs_latitude = isset($post['addrs_latitude']) ? $post['addrs_latitude'] : "";
    		$addrs_longitude = isset($post['addrs_longitude']) ? $post['addrs_longitude'] : "";
    		$main_homepage = isset($post['main_homepage']) ? $post['main_homepage'] : "";
    		$addrs_cid = isset($post['addrs_cid']) ? $post['addrs_cid'] : "";
    		$category_type = isset($post['addrs_category']) ? $post['addrs_category'] : 0;
    		if($category_type == ""){ $category_type = 0; }
    		$category_id = isset($post['addrs_catid']) ? $post['addrs_catid'] : 0;
    		if($category_id == ""){ $category_id = 0; }
    		$external_partner = isset($post['external_partner']) ? $post['external_partner'] : 0;
    		if($external_partner == ""){ $external_partner = 0; }
    		$zone_city = isset($post['zone_city']) ? $post['zone_city'] : "";
    		$zone_code = isset($post['zone_code']) ? $post['zone_code'] : "";
    		$zone_name = isset($post['zone_name']) ? $post['zone_name'] : "";
    		$cargo_limit = isset($post['cargo_limit']) ? $post['cargo_limit'] : 0;
    		if($cargo_limit == ""){ $cargo_limit = 0; }
    		$limit_amount = isset($post['limit_amount']) ? $post['limit_amount'] : 0;
    		if($limit_amount == ""){ $limit_amount = 0; }
    		$currency = isset($post['currency']) ? $post['currency'] : "";
			$creditlimit = isset($post['creditlimit']) ? $post['creditlimit'] : 0;
		if($creditlimit == ""){ $creditlimit = 0; }
		$credit_limit_amount = isset($post['c_limit_amount']) ? $post['c_limit_amount'] : 0;
		if($credit_limit_amount == ""){ $credit_limit_amount = 0; }
		$credit_currency = isset($post['c_currency']) ? $post['c_currency'] : "";
		$vat_reg_no = isset($post['vat_reg_no']) ? $post['vat_reg_no'] : "";
		$tax_payer_no = isset($post['tax_payer_no']) ? $post['tax_payer_no'] : "";
		$contract_no = isset($post['contract_no']) ? $post['contract_no'] : "";
		$contract_date = isset($post['contract_date']) ? $post['contract_date'] : "";
		$carrier_p_id = isset($post['carrier_p_id']) ? $post['carrier_p_id'] :0;
		$cus_p_id = isset($post['cus_p_id']) ? $post['cus_p_id'] :0;

		$invoice_type = isset($post['invoice_type']) ? $post['invoice_type'] : 0;
		if($invoice_type == ""){ $invoice_type = 0; }

		$cust_profile_id = isset($post['cust_profile_id']) ? $post['cust_profile_id'] : 0;
		if($cust_profile_id == ""){ $cust_profile_id = 0; }

		$ven_profile_id = isset($post['ven_profile_id']) ? $post['ven_profile_id'] : 0;
		if($ven_profile_id == ""){ $ven_profile_id = 0; }

		if($contract_date !=""){
			$contract_date=date('Y-m-d',strtotime($contract_date));
		}
		$auto_trip = isset($post['auto_trip']) ? $post['auto_trip'] : 0;
		 if($auto_trip == ""){ $auto_trip = 0; }
		$tms_auto_trip = isset($post['tms_auto_trip']) ? $post['tms_auto_trip'] : 0;
		 if($tms_auto_trip == ""){ $tms_auto_trip = 0; }
            if (($bpassword != "") && password_get_info($bpassword)['algoName'] === 'unknown') {
                $bpassword = password_hash($bpassword, PASSWORD_DEFAULT);
            }
		$tariff_type = isset($post['tariff_type']) ? $post['tariff_type'] : 0;
		if($tariff_type == ""){ $tariff_type = 0; }
		$sendto_knlogin = isset($post['sendto_knlogin']) ? $post['sendto_knlogin'] : 0;
		if($sendto_knlogin == ""){ $sendto_knlogin = 0; }
		$curdt = date('Y-m-d H:i:s');
		$partnerdata = ['party_type_id'=>0,'name'=>$addrs_name,'email'=>$addrs_email,'mobile'=>$addrs_phone,'user_id'=>$uid,'code'=>$cid,'company_code'=>$companycode,'branch_code'=>$branchcode,'department_code'=>$departmentcode,'location_id'=>$addrs_city,'country'=>$addrs_country,'state'=>$addrs_province,'division_name'=>$division_name,'sub_district'=>$sub_district,'street'=>$addrs_street,'pincode'=>$postal_code,'street_2'=>$street_2,'street_3'=>$street_3,'building'=>$addrs_building,'house_number'=>$house_number,'party_types'=>$partytypes,'extension'=>$addrs_extension,'latitude'=>$addrs_latitude,'longitude'=>$addrs_longitude,'homepage'=>$main_homepage,'category_type'=>$category_type,'category_id'=>$category_id,'time_zone_city'=>$zone_city,'time_zone_code'=>$zone_code,'time_zone_name'=>$zone_name,'acon_debitor_code'=>$debitor_code,'kn_login_account'=>$kn_login,'password'=>$bpassword,'offering_type'=>$offering_type,'carrier_grade'=>$carrier_grade,'autoaccept'=>$autoaccept,'cargo_limit'=>$cargo_limit,'limit_amount'=>$limit_amount,'currency'=>$currency,'credit_limit'=>$creditlimit,'credit_limit_amount'=>$credit_limit_amount,'credit_currency'=>$credit_currency,'vat_reg_no'=> $vat_reg_no,'tax_payer_no'=>$tax_payer_no,'contract_no'=>$contract_no,'invoice_type'=>$invoice_type,'contract_date'=>$contract_date,'updated_on'=>$curdt];
		$update = $this->bpartners->updatedata('tbl_party_master',$partner_id,$partnerdata);
		if($update){
			$customer_id = 0;
			$cus_companycode = $companycode;
			$cus_branchcode = $branchcode;
			$partytypesary = explode(',' ,$partytypes);
			$address = $addrs_street;
			if($street_2 != ""){
				$address .= ','.$street_2;
			}
			if($street_3 != ""){
				$address .= ','.$street_3;
			}
			if($house_number != ""){
				$address .= ','.$house_number;
			}
			if($addrs_city != ""){
				$address .= ','.$addrs_city;
			}
			if($addrs_province != ""){
				$address .= ','.$addrs_province;
			}
			$vendor_partyid = $customer_partyid = $vendor_id = 0;
			$chkcarrierparty = $this->bpartners->chkpartytype($partytypesary,'Carrier');
			if($chkcarrierparty->num_rows() > 0){
				$vendor_partyid = $chkcarrierparty->row()->id;
                $vendarr = [
                    'name' => $addrs_name,
                    'mobile' => $addrs_phone,
                    'location' => $addrs_city,
                    'address' => $address,
                    'pincode' => $postal_code,
                    'country' => $addrs_country,
                    'code' => $cid,
                    'offering_type' => $offering_type,
                    'carrier_grade' => $carrier_grade,
                    'email' => $addrs_email,
                    'password' => $bpassword,
                    'user_id' => $uid,
                    'partyid' => $partner_id,
                    'company_code' => $companycode,
                    'branch_code' => $branchcode,
                    'status' => 1,
                    'auto_accept' => $auto_trip,
                    'tms_auto_accept' => $tms_auto_trip,
                    'updated_on' => $curdt
                ];
				if(!empty($carrier_p_id)){
						 $upd = $this->bpartners->updatedata('tb_vendors',$carrier_p_id,$vendarr);

						 /* vendor profile code */
						 if(!empty($ven_profile_id)){
							$chk_pro = $this->common->gettblrowdata(['party_id'=>$carrier_p_id],"id,vp_id","tb_vendor_profile_list",0,0);
							$pro_list=["vp_id"=>$ven_profile_id,"profile_id"=>$cid,"party_id"=>$carrier_p_id,"status"=>1];
							if(!empty($chk_pro)){
							$upd = $this->common->updatetbledata('tb_vendor_profile_list',$pro_list,['id'=>$chk_pro['id']]);
							}else{
								 $this->common->insertTableData("tb_vendor_profile_list",$pro_list);
							}
				      }
				}
				else{
					$chk = $this->db->select('id')->get_where("tb_vendors",['name' => $addrs_name, 'code' => $cid, 'company_code' => $companycode]);
					if($chk->num_rows()>0){
						$vendor_id = $chk->row()->id;
						$upd = $this->bpartners->updatedata('tb_vendors',$vendor_id,$vendarr);
					}else{
						$vendarr['created_on'] = $curdt;
						$vendor_id = $this->common->insertTableData("tb_vendors",$vendarr);
					}
                    if(!empty($ven_profile_id)){
						$chk_pro = $this->common->gettblrowdata(['party_id'=>$vendor_id],"id,vp_id","tb_vendor_profile_list",0,0);
                       $pro_list=["vp_id"=>$ven_profile_id,"profile_id"=>$cid,"party_id"=>$vendor_id,"status"=>1];
							if(!empty($chk_pro)){
							$upd = $this->common->updatetbledata('tb_vendor_profile_list',$pro_list,['id'=>$chk_pro['id']]);
							}else{
								 $this->common->insertTableData("tb_vendor_profile_list",$pro_list);
							}
                    }

				}
				 if($vendor_id >0 || $carrier_p_id >0){
				 	if($carrier_p_id >0){
				 		$vendor_id = $carrier_p_id;
				 	}
					$rules = ['vendor_id'=>$vendor_id,'company_code'=>$companycode,'branch_code'=>$branchcode,'user_id'=>$uid,'createdon'=>$curdt,'rule_status'=>'Direct','status'=>1,'autoaccept'=>$autoaccept];
					$chkvendor_rules = $this->common->gettblrowdata(['vendor_id'=>$vendor_id,'company_code'=>$companycode],"id","tb_vendor_rules",0,0);
					if(!empty($chkvendor_rules)){
						$vendor_rules_id = $chkvendor_rules['id'];
						$upd = $this->common->updatetbledata('tb_vendor_rules',['autoaccept'=>$autoaccept],['id'=>$vendor_rules_id]);
					}else{
						$ins_vendor_rules = $this->common->insertTableData("tb_vendor_rules",$rules);
					}
				}
			}
			$chkcustparty = $this->bpartners->chkpartytype($partytypesary,'Customer');
			if($chkcustparty->num_rows() > 0){
				$customer_partyid = $chkcustparty->row()->id;
				if($cid != ""){
					$customer = ['partner_id'=>$partner_id,'name'=>$addrs_name,'phone'=>$addrs_phone,'street'=>$addrs_street,'location'=>$addrs_city,'pincode'=>$postal_code,'country'=>$addrs_country,'address'=>$address,'email_id'=>$addrs_email,'state'=>$addrs_province,'code'=>$cid,'password'=>$bpassword,'user_id'=>$uid,'updatedon'=>$curdt,'lat'=>$addrs_latitude,'lng'=>$addrs_longitude,'company_code'=>$cus_companycode,'branch_code'=>$cus_branchcode,'Tarifftype'=>$tariff_type,'sendto_knlogin'=>$sendto_knlogin];
					$customer['kn_login'] = 0;
					if(preg_match('/[A-Za-z].*[0-9]|[0-9].*[A-Za-z]/', $kn_login)){
						$knlen = strlen($kn_login);
						if(($knlen > 9) && ($knlen < 16)){
							$customer['kn_login'] = 1;
						}
					}
					if($cus_p_id > 0){
                        $this->bpartners->updatedata('tb_customers',$cus_p_id,$customer);
						/* customer profile code */
						 if(!empty($cust_profile_id)){
							$chk_pro = $this->common->gettblrowdata(['party_id'=>$cus_p_id],"id,cp_id","tb_customer_profile_list",0,0);
							$cus_pro_list=["cp_id"=>$cust_profile_id,"profile_id"=>$cid,"party_id"=>$cus_p_id,"status"=>1];
							if(!empty($chk_pro)){
							$upd = $this->common->updatetbledata('tb_customer_profile_list',$cus_pro_list,['id'=>$chk_pro['id']]);
							}else{
								$customer_id1 = $this->common->insertTableData("tb_customer_profile_list",$cus_pro_list);

							}
						}
					}
					else{
                        $chk = $this->db->select('id')->get_where("tb_customers", ['code' => $cid, 'company_code' => $cus_companycode, 'status' => '1']);
                        if($chk->num_rows()>0){
							$customer_id = $chk->row()->id;
							$upd = $this->bpartners->updatedata('tb_customers',$customer_id,$customer);
						}else{
							$customer['createdon'] = $curdt;
							$customer_id1 = $this->common->insertTableData("tb_customers",$customer);
						}

                        /* customer profile code */
						if(!empty($cust_profile_id)){
							$chk_pro = $this->common->gettblrowdata(['profile_id'=>$cid],"id,cp_id","tb_customer_profile_list",0,0);
							$cus_pro_list=["cp_id"=>$cust_profile_id,"profile_id"=>$cid,"party_id"=>$cus_p_id,"status"=>1];
							if(!empty($chk_pro)){

							$upd = $this->common->updatetbledata('tb_customer_profile_list',$cus_pro_list,['id'=>$chk_pro['id']]);
							}else{
								$customer_id = $this->common->insertTableData("tb_customer_profile_list",$cus_pro_list);
							}
						}


					}
				}
			}
			if($customer_id  > 0){
                $where = [
                    'pe.status' => 1,
                    'pe.partner_id' => $partner_id
                ];
                $this->db->select('o.name as ordertype');
                $this->db->where($where);
                $this->db->join('tbl_order_types o', 'o.id = pe.order_type');
                $getOrderTypes = $this->db->get('tbl_partner_ediapi pe');
                if($getOrderTypes->num_rows() > 0 )
					foreach ($getOrderTypes->result() as $ordertype) {
						$ordertypename = $ordertype->ordertype;
						if($ordertypename != ""){
							$this->db->select("id");
							$this->db->from("tb_order_types");
							$this->db->where("type_name", $ordertypename);
							$this->db->where("company_code", $cus_companycode);
							$this->db->where("branch_code", $cus_branchcode);
							$this->db->where("customer_id", $customer_id);
							$this->db->where("status", 1);
							$chkordtype = $this->db->get();
							if($chkordtype->num_rows() == 0){
								$ordtype_code = mb_substr($ordertypename, 0, 1);
								$orderdata = ['type_name'=>$ordertypename, 'description'=>$ordertypename, 'company_code'=>$cus_companycode, 'branch_code'=>$cus_branchcode, 'customer_id'=>$customer_id, 'ordtype_code'=>$ordtype_code, 'status'=>'1', 'createdon'=>$curdt, 'updatedon'=>$curdt];
								$insordtype = $this->common->insertTableData("tb_order_types",$orderdata);
							}
						}
					}

				}
				$upd = ['status'=>1];

				if($customer_partyid > 0){
					$upd['party_type_id'] = $customer_partyid;
				}else if($vendor_partyid > 0){
					$upd['party_type_id'] = $vendor_partyid;
				}else if(isset($post['partytypes'][0])){
					$upd['party_type_id'] = $post['partytypes'][0];
				}
				if($upd['party_type_id'] == "" ){ $upd['party_type_id'] = 0; }
				$updatecode = $this->bpartners->updatedata('tbl_party_master',$partner_id,$upd);
				$data['status'] = 1;
			}

			// --- VEHICLE TYPE UPDATE LOGIC START ---
			$partner_id = $this->input->post('partner_id');
			$selected_vehicleids = $this->input->post('selectedvehicleids'); // CSV or empty

			// Get all existing active vehicle types (status = 1)
			$existing = $this->db
				->select('id, trucktype_id')
				->where('partner_id', $partner_id)
				->where('status', 1)
				->get('partner_vehicletypes')
				->result_array();

			$existing_ids = array_map('intval', array_column($existing, 'trucktype_id'));

			if ($selected_vehicleids !== null && trim($selected_vehicleids) !== '') {
				// When some vehicles are selected
				$selected_ids = array_map('intval', array_filter(array_map('trim', explode(',', $selected_vehicleids))));

				// Vehicles to deactivate are those in existing but not in selected
				$todeactivate = array_diff($existing_ids, $selected_ids);
				$toadd = array_diff($selected_ids, $existing_ids);

				// Deactivate removed vehicles
				if (!empty($todeactivate)) {
					$this->db->where('partner_id', $partner_id);
					$this->db->where_in('trucktype_id', $todeactivate);
					$this->db->update('partner_vehicletypes', [
						'status' => 0,
						'updatedon' => date('Y-m-d H:i:s')
					]);
				}

				// Add or reactivate new vehicles
				foreach ($toadd as $trucktype_id) {
					$row = $this->db
						->where('partner_id', $partner_id)
						->where('trucktype_id', $trucktype_id)
						->get('partner_vehicletypes')
						->row();

					if ($row) {
						$this->db
							->where('id', $row->id)
							->update('partner_vehicletypes', [
								'status' => 1,
								'updatedon' => date('Y-m-d H:i:s')
							]);
					} else {
						$this->db->insert('partner_vehicletypes', [
							'partner_id' => $partner_id,
							'trucktype_id' => $trucktype_id,
							'status' => 1,
							'createdon' => date('Y-m-d H:i:s'),
							'updatedon' => date('Y-m-d H:i:s')
						]);
					}
				}
			} else {
				// When no vehicles are selected (all removed), deactivate all existing
				if (!empty($existing_ids)) {
					$this->db->where('partner_id', $partner_id);
					$this->db->where_in('trucktype_id', $existing_ids);
					$this->db->update('partner_vehicletypes', [
						'status' => 0,
						'updatedon' => date('Y-m-d H:i:s')
					]);
				}
			}

			// --- VEHICLE TYPE UPDATE LOGIC END ---

			// ---------Time Update Code--------------

			$partner_id = $this->input->post('partner_id');  

			$days          = $this->input->post('days');
			$start_times   = $this->input->post('start_time');
			$end_times     = $this->input->post('end_time');
			$operation_types = $this->input->post('operation_type');
			$row_actives   = $this->input->post('row_active');
			
			$active_indexes = is_array($row_actives) ? array_keys($row_actives) : [];

			$existing_constraints = $this->db
				->where('partner_id', $partner_id)
				->where('status', 1)
				->get('partner_timeconstraints')
				->result_array();

			foreach ($days as $idx => $day) {
				$is_active = isset($row_actives[$idx]);
				$type = $operation_types[$idx] === "pickup" ? 1 : 2;

				// Check if this row matches an existing constraint (match on day + type + partner_id)
				$existing = null;
				foreach ($existing_constraints as $ec) {
					if (
						strtolower($ec['day']) === strtolower($day) &&
						intval($ec['type']) === $type
					) {
						$existing = $ec;
						break;
					}
				}

				$data = [
					'partner_id'         => $partner_id,
					'day'                => $day,
					'type'               => $type,
					'pickup_start_time'  => $type == 1 ? $start_times[$idx] : '00:00:00',
					'pickup_end_time'    => $type == 1 ? $end_times[$idx] : '00:00:00',
					'drop_start_time'    => $type == 2 ? $start_times[$idx] : '00:00:00',
					'drop_end_time'      => $type == 2 ? $end_times[$idx] : '00:00:00',
					'status'             => $is_active ? 1 : 0,
					'updatedon'          => date('Y-m-d H:i:s'),
				];

				if ($existing) {
					// update existing
					$this->db->where('id', $existing['id'])->update('partner_timeconstraints', $data);
				} else if ($is_active) {
					// insert new only if checked
					$data['createdon'] = date('Y-m-d H:i:s');
					$this->db->insert('partner_timeconstraints', $data);
				}
			}

			// Deactivate any constraints that are not present as active in the current submitted data
			foreach ($existing_constraints as $ec) {
				$found = false;
				foreach ($days as $idx => $day) {
					$type = $operation_types[$idx] === "pickup" ? 1 : 2;
					if (
						strtolower($ec['day']) === strtolower($day) &&
						intval($ec['type']) === $type &&
						isset($row_actives[$idx])
					) {
						$found = true;
						break;
					}
				}
				if (!$found) {
					// row no longer checked or on page: deactivate
					$this->db->where('id', $ec['id'])->update('partner_timeconstraints', ['status' => 0, 'updatedon' => date('Y-m-d H:i:s')]);
				}
			}

			$removed_constraint_ids = $this->input->post('removed_constraint_ids'); // the hidden input from JS
			if ($removed_constraint_ids) {
				$ids = array_filter(array_map('trim', explode(',', $removed_constraint_ids)));
				if (!empty($ids)) {
					$this->db->where_in('id', $ids)
						->update('partner_timeconstraints', [
							'status' => 0,
							'updatedon' => date('Y-m-d H:i:s')
						]);
				}
			}


			// ---------Time Update Code END--------------

            $getPartyRefs = $this->common->gettbldata("partner_id ='" . $partner_id . "' AND value IN ('Y','y','YES','Yes','yes') AND status ='1' ", "reference_type", 'tb_party_reference', 0, 0);
            $partyRefs = [];
            foreach ($getPartyRefs as $eachType) {
                $partyRefs[] = $eachType['reference_type'];
            }
            $getRefIds = $this->common->gettbldata("reference_type IN ('eBooking','integration','visibility')", "id,reference_type", 'tb_reference_types', 0, 0);
            $eBookingMasterData = $integrationMasterData = $visibilityMasterData = [];
            foreach ($getRefIds as $eachType) {
                $referenceType = $eachType['reference_type'];
                if ($referenceType == "eBooking") {
                    $eBookingMasterData[] = $eachType['id'];
                }
                if ($referenceType == "integration") {
                    $integrationMasterData[] = $eachType['id'];
                }
                if ($referenceType == "visibility") {
                    $visibilityMasterData[] = $eachType['id'];
                }
            }
            $eBookingDiffernece = array_diff($eBookingMasterData, $eBooking);
            $visibilityDifference = array_diff($visibilityMasterData, $visibility);
            $integrationDifference = array_diff($integrationMasterData, $integrations);
            $visibilityToDelete = array_intersect($visibilityDifference, $partyRefs);
            if (!empty($visibilityToDelete)) {
                $this->common->updatetbledata("tb_party_reference", ['status' => '0'], "reference_type IN (" . implode(',', $visibilityToDelete) . ") AND status=1  AND partner_id=$partner_id ");
            }
            foreach ($visibility as $eachRef) {
                $partyType = $this->common->gettblrowdata(["partner_id" => $partner_id, "reference_type" => $eachRef], "id", "tb_party_reference", 0, 0);
                if (empty($partyType)) {
                    $referenceName = $this->common->gettblrowdata(['id' => $eachRef], 'name', 'tb_reference_types', 0, 0);
                    $partyRefData = ['reference_type' => $eachRef, 'partner_id' => $partner_id, 'name' => $referenceName['name'], 'value' => 'Y', 'user_id' => $uid, 'status' => 1, 'createdon' => $curdt, 'updatedon' => $curdt];
                    $this->common->insertTableData("tb_party_reference", $partyRefData);
                } else {
                    $rowId = $partyType['id'];
                    $this->common->updatetbledata("tb_party_reference", ['status' => '1', 'value' => 'Y'], ['id' => $rowId]);
                }
            }
            $integrationsToDelete = array_intersect($integrationDifference, $partyRefs);
            if (!empty($integrationsToDelete)) {
                $this->common->updatetbledata("tb_party_reference", ['status' => '0'], "reference_type IN (" . implode(',', $integrationsToDelete) . ") AND status=1  AND partner_id=$partner_id");
            }
            foreach ($integrations as $eachRef) {
                $partyType = $this->common->gettblrowdata(["partner_id" => $partner_id, "reference_type" =>$eachRef], "id", "tb_party_reference", 0, 0);
                if (empty($partyType)) {
                    $referenceName = $this->common->gettblrowdata(['id' => $eachRef], 'name', 'tb_reference_types', 0, 0);
                    $partyRefData = ['reference_type' => $eachRef, 'partner_id' => $partner_id, 'name' => $referenceName['name'], 'value' => 'Y', 'user_id' => $uid, 'status' => 1, 'createdon' => $curdt, 'updatedon' => $curdt];
                    $this->common->insertTableData("tb_party_reference", $partyRefData);
                } else {
                    $rowId = $partyType['id'];
                    $this->common->updatetbledata("tb_party_reference", ['status' => '1', 'value' => 'Y'], ['id' => $rowId]);
                }
            }
            $eBookingToDelete = array_intersect($eBookingDiffernece, $partyRefs);
            if (!empty($eBookingToDelete)) {
                $this->common->updatetbledata("tb_party_reference", ['status' => '0'], "reference_type IN (" . implode(',', $eBookingToDelete) . ") AND status=1  AND partner_id=$partner_id");
            }
            foreach ($eBooking as $eachRef) {
                $partyType = $this->common->gettblrowdata(["partner_id" => $partner_id, "reference_type" => $eachRef], "id", "tb_party_reference", 0, 0);
                if (empty($partyType)) {
                    $referenceName = $this->common->gettblrowdata(['id' => $eachRef], 'name', 'tb_reference_types', 0, 0);
                    $partyRefData = ['reference_type' => $eachRef, 'partner_id' => $partner_id, 'name' => $referenceName['name'], 'value' => 'Y', 'user_id' => $uid, 'status' => 1, 'createdon' => $curdt, 'updatedon' => $curdt];
                    $this->common->insertTableData("tb_party_reference", $partyRefData);
                } else {
                    $rowId = $partyType['id'];
                    $this->common->updatetbledata("tb_party_reference", ['status' => '1', 'value' => 'Y'], ['id' => $rowId]);
                }
            }
		}
		echo json_encode($data);
	}



	public function vieweditpartner($id){
		$data['page_title'] = $this->lang->line('business_partners');
		$data['sub_title'] = $this->lang->line('general_view');

		$data = $partnerdata = $condata = $refdata = $reftypes = $party_type_names = $partytypes = $ptypes = [];
		$accountndata = $contractsdata = [];
		$ediapidata =  [];
		if($id !=""){
			$getParties =[];
			$uid = $this->session->userdata('user_id');
			$company_code = $this->session->userdata('company_code');
			$branch_code = $this->session->userdata('branch_code');
			$getParties1 = $this->bpartners->getpartytypes($uid,$company_code);
			if($getParties1->num_rows() > 0){
				foreach ($getParties1->result() as $gparty) {
					$getParties[] = ['id'=>$gparty->id,'name'=>ucfirst(strtolower($gparty->name)),'description'=>$gparty->description];
				}
			}
            $where = [
                'id' => $id,
                'status' => 1
            ];
            $this->db->select('*');
            $this->db->where($where);
            $this->db->order_by('created_on','DESC');
            $getParty = $this->db->get('tbl_party_master');
            if($getParty->num_rows() >0){
				$party_types = $getParty->row()->party_types;
				$party_type_id = $getParty->row()->party_type_id;
				if($party_types != ""){
					$ptypes = explode(',', $party_types);
				}
				array_push($ptypes, $party_type_id);
				$partytypes = array_unique($ptypes);
				$party_type_names = $this->bpartners->getpartytypenamesbyids($partytypes,$company_code,$uid);
				$bpassword = $getParty->row()->password;
				if($bpassword != ""){
					$bpassword = (($bpassword));
				}
				$category_id = $getParty->row()->category_id;
				$categorydata =	['id'=>"",'name'=>""];
				if($category_id > 0){
					$getcatname = $this->bpartners->getcategoryname($category_id);
					$categorydata =	['id'=>$category_id,'name'=>$getcatname];
				}
				$chkcarrierparty = $this->bpartners->chkpartytype($partytypes,'Carrier');
				$auto_accept_trip=0;
				$tms_auto_accept_trip=0;

				if($chkcarrierparty->num_rows() > 0){
					$code_cid=trim($getParty->row()->code);
                    $where = [
                        'partyid' => $id,
                        'code' => $code_cid,
                        'status' => 1
                    ];
                    $this->db->select('auto_accept,tms_auto_accept');
                    $this->db->where($where);
                    $getVendors = $this->db->get('tb_vendors');
                    if($getVendors->num_rows() >0){
						$auto_accept_trip = $getVendors->row()->auto_accept;
                        $tms_auto_accept_trip = $getVendors->row()->tms_auto_accept;
					}
				}
				$cus_p_id=$sendto_knlogin=$Tarifftype=0;
				$chkcusparty = $this->bpartners->chkpartytype($partytypes,'Customer');
				if($chkcusparty->num_rows() > 0){
					$code_cid=trim($getParty->row()->code);
					$chk_p_id =$this->common->gettblrowdata(['code'=>$code_cid,'status'=>'1'],'*','tb_customers',0,0);
					if(!empty($chk_p_id)){
					  $cus_p_id = $chk_p_id['id'];
					  $sendto_knlogin = $chk_p_id['sendto_knlogin'];
					  $Tarifftype = $chk_p_id['Tarifftype'];
					}
				}
				$customer_profile_id= $vendor_profile_id=$cus_profile_id=$ven_profile_id="";
				$cus_pro_id = $this->bpartners->getcustprofile($getParty->row()->id);
				if(!empty($cus_pro_id)){
					$customer_profile_id=$cus_pro_id['cust_profile_id'];
					$cus_profile_id=$cus_pro_id['cp_id'];
				}
				$ven_pro_id = $this->bpartners->getvendorprofile($getParty->row()->code);
				if(!empty($ven_pro_id)){
					$vendor_profile_id=$ven_pro_id['vend_profile_id'];
					$ven_profile_id=$ven_pro_id['vp_id'];
				}
				$data = [
					'party_type_names'=>$party_type_names,
					'partytypes'=>$partytypes,
					'auto_accept'=>$auto_accept_trip,
					'tms_auto_accept'=>$tms_auto_accept_trip,
					'name'=>$getParty->row()->name,
					'email'=>$getParty->row()->email,
					'mobile'=>$getParty->row()->mobile,
					'location_id'=>$getParty->row()->location_id,
					'division_name'=>$getParty->row()->division_name,
					'sub_district'=>$getParty->row()->sub_district,
					'street'=>$getParty->row()->street,
					'street_2'=>$getParty->row()->street_2,
					'street_3'=>$getParty->row()->street_3,
					'house_number'=>$getParty->row()->house_number,
					'building'=>$getParty->row()->building,
					'state'=>$getParty->row()->state,
					'pincode'=>$getParty->row()->pincode,
					'country'=>$getParty->row()->country,
					'extension'=>$getParty->row()->extension,
					'latitude'=>$getParty->row()->latitude,
					'longitude'=>$getParty->row()->longitude,
					'homepage'=>$getParty->row()->homepage,
					'category_type'=>$getParty->row()->category_type,
					'categorydata'=>$categorydata,
					'time_zone_city'=>$getParty->row()->time_zone_city,
					'time_zone_code'=>$getParty->row()->time_zone_code,
					'time_zone_name'=>$getParty->row()->time_zone_name,
					'code'=>$getParty->row()->code,
					'company_code'=>$getParty->row()->company_code,
					'branch_code'=>$getParty->row()->branch_code,
					'department_code'=>$getParty->row()->department_code,
					'customer_code'=>$getParty->row()->customeridentifier,
					'acon_debitor_code'=>$getParty->row()->acon_debitor_code,'kn_login_account'=>$getParty->row()->kn_login_account,
					'password'=>$bpassword,
					'offering_type'=>$getParty->row()->offering_type,
					'carrier_grade'=>$getParty->row()->carrier_grade,
					'autoaccept'=>$getParty->row()->autoaccept,
					'cargo_limit'=>$getParty->row()->cargo_limit,
					'limit_amount'=>$getParty->row()->limit_amount,
					'currency'=>$getParty->row()->currency,
					'credit_limit'=>$getParty->row()->credit_limit,
					'credit_limit_amount'=>$getParty->row()->credit_limit_amount,'credit_currency'=>$getParty->row()->credit_currency,
					'vat_reg_no'=>$getParty->row()->vat_reg_no,
					'tax_payer_no'=>$getParty->row()->tax_payer_no,
					'contract_no'=>$getParty->row()->contract_no,
					'contract_date'=>$getParty->row()->contract_date,
					'invoice_type'=>$getParty->row()->invoice_type,
					'customer_profile_id'=>$customer_profile_id,
					'vendor_profile_id'=>$vendor_profile_id,
					'Tarifftype'=>$Tarifftype,
					'sendto_knlogin'=>$sendto_knlogin,
					'partner_id'=>$id
				];
			}
            $where = [
                'partner_id' => $id,
                'status' => 1
            ];
            $this->db->select('*');
            $this->db->where($where);
            $getPartnerContacts = $this->db->get('tbl_partner_contacts');
            if($getPartnerContacts->num_rows() >0){
				foreach ($getPartnerContacts->result() as $contact) {
					$condata[] = [
                        'id'=>$contact->id,
                        'name'=>$contact->name,
                        'street'=>$contact->street,
                        'city'=>$contact->city,
                        'state'=>$contact->state,
                        'country'=>$contact->country,
                        'zipcode'=>$contact->zipcode,
                        'phone'=>$contact->phone,
                        'fax'=>$contact->fax,
                        'email'=>$contact->email
                    ];
				}

			}
            $where = [
                'partner_id' => $id,
                'status' => 1
            ];
            $this->db->select('*');
            $this->db->where($where);
            $getPartyReference = $this->db->get('tb_party_reference');
            if($getPartyReference->num_rows() >0){
				$reftype = "";
				foreach ($getPartyReference->result() as $refs) {
                    $where = [
                        'id' => $refs->reference_type,
                        'status' => 1
                    ];
                    $this->db->select('name');
                    $this->db->where($where);
                    $getRefType = $this->db->get('tb_reference_types');
                    if($getRefType->num_rows() >0){
						$reftype = $getRefType->row()->name;
					}
					$refdata[] = [
                        'id'=>$refs->id,
                        'reference_type'=>$refs->reference_type,
                        'reftype'=>$reftype,
                        'name'=>$refs->name,
                        'value'=>$refs->value,
                        'description'=>$refs->description,
                        'gstin'=>$refs->gstin
                    ];
				}
			}
            $getRefIds = $this->common->gettbldata(['status'=>1], "id,name,reference_type", 'tb_reference_types', 0, 0);
            $eBookingMasterData = $integrationMasterData = $visibilityMasterData = [];
            foreach ($getRefIds as $eachType) {
                $referenceType = $eachType['reference_type'];
                if ($referenceType == "eBooking") {
                    $eBookingMasterData[] = ['id'=>$eachType['id'],'name'=>$eachType['name']];
                }
                if ($referenceType == "integration") {
                    $integrationMasterData[] = ['id'=>$eachType['id'],'name'=>$eachType['name']];
                }
                if ($referenceType == "visibility") {
                    $visibilityMasterData[] = ['id'=>$eachType['id'],'name'=>$eachType['name']];
                }
                $reftypes[] = ['id'=>$eachType['id'],'name'=>$eachType['name']];
            }
		}
        $data['visibilityMasterData'] = $visibilityMasterData;
        $data['integrationMasterData'] = $integrationMasterData;
        $data['eBookingMasterData'] = $eBookingMasterData;
		$data['condata'] = $condata;
		$data['refdata'] = $refdata;
		$data['getparties'] = $getParties;
		$data['reftypes'] = $reftypes;
		$data['partner_id'] = $id;

      //$this->load->view('businesspartners/partnerdetails',$data);

	  ///------------financials data------------------
		if($id !=""){
            $where = [
                'partner_id' => $id,
                'status' => 1
            ];
            $this->db->select('*');
            $this->db->where($where);
            $getPartnerAccounts = $this->db->get('tbl_partner_accounts');
            if($getPartnerAccounts->num_rows() >0){
				foreach ($getPartnerAccounts->result() as $account) {
					$accountndata[] = [
                        'id'=>$account->id,
                        'account_number'=>$account->account_number,
                        'acon_environment'=>$account->acon_environment,
                        'company_code'=>$account->company_code,
                        'source_system'=>$account->source_system,
                        'billable'=>$account->billable,
                        'pre_payment'=>$account->pre_payment,
                        'mutiple_invoices'=>$account->mutiple_invoices
                    ];
				}
			}
            $where = [
                'partner_id' => $id,
                'status' => 1
            ];
            $this->db->select('*');
            $this->db->where($where);
            $getPartnerContracts = $this->db->get('tbl_partner_contracts');
            if($getPartnerContracts->num_rows() >0){
				foreach ($getPartnerContracts->result() as $contract) {
					$contractsdata[] = [
                        'id'=>$contract->id,
                        'company_code'=>$contract->company_code,
                        'branch_code'=>$contract->branch_code,
                        'contract_id'=>$contract->contract_id,
                        'rate_derivation'=>$contract->rate_derivation
                    ];
				}
			}
		}
		$data['accountndata'] = $accountndata;
		$data['contractsdata'] = $contractsdata;

	  ///------------END financials data------------------

	  ///------------Ediapi data------------------

		if($id !=""){
			$triggeredat = $retriggerat = "";
            $this->db->select(
                'pe.id as ediid,
                t.name as action,
                i.name as inco_terms,
                pe.triggered_at,
                pe.retrigger,
                o.name as ordertype,
                st.name as orderstatus,
                p.name as ediproduct,
                s.name as ediservice,
                m.code as editransport,
                pe.pickup,
                pe.destination,
                pe.commodity,
                e.name as ediapitype,
                pe.edi_url,
                f.name as filename'
            );
            $where = [
                'partner_id' => $id,
                'pe.status' => '1'
            ];
            $this->db->join('tbl_txn_actions t', 't.id=pe.transaction_action', 'left');
            $this->db->join('tb_incoterms_master i', 'i.id=pe.inco_terms', 'left');
            $this->db->join('tbl_order_types o', 'o.id=pe.order_type', 'left');
            $this->db->join('tb_products_master p', 'p.id=pe.product', 'left');
            $this->db->join('tb_service_master s', 's.id=pe.service', 'left');
            $this->db->join('tb_transportmode m', 'm.id=pe.mode_transport', 'left');
            $this->db->join('tbl_edi_types e', 'e.id=pe.type', 'left');
            $this->db->join('tbl_edi_files f', 'f.id=pe.file_id', 'left');
            $this->db->join('tb_statuses st', 'st.id=pe.order_status', 'left');
            $this->db->where($where);
            $getPartnerEdiApi = $this->db->get('tbl_partner_ediapi pe');
			if($getPartnerEdiApi->num_rows() >0){
				foreach($getPartnerEdiApi->result() as $ediapidt){
					if($ediapidt->triggered_at > 0){
						if($ediapidt->triggered_at == 1){
							$triggeredat = "Order Booked";
						}else if($ediapidt->triggered_at == 2){
							$triggeredat = "Trip Created";
						}
					}
					if($ediapidt->retrigger > 0){
						if($ediapidt->retrigger == 1){
							$retriggerat = "Updated";
						}else if($ediapidt->retrigger == 2){
							$retriggerat = "None";
						}
					}
					$file = "";
					if($ediapidt->filename != ""){
						$documentlink = base_url()."assets/xsduploads/".$ediapidt->filename;
						$document = "<a href=".$documentlink." download>File</a>";
						$file = $document;
					}
					$ediapidata[] = ['action'=>$ediapidt->action, 'inco_terms'=>$ediapidt->inco_terms,'triggeredat'=>$triggeredat,'retriggerat'=>$retriggerat,'ordertype'=>$ediapidt->ordertype,'order_status'=>$ediapidt->orderstatus,'ediproduct'=> $ediapidt->ediproduct,'ediservice'=> $ediapidt->ediservice,'editransport'=> $ediapidt->editransport,'edi_pickup'=>$ediapidt->pickup,'edi_destination'=>$ediapidt->destination,'edi_commodity'=>$ediapidt->commodity,'ediapitype'=> $ediapidt->ediapitype,'edi_url'=>$ediapidt->edi_url,'file'=>$file,'ediid'=>$ediapidt->ediid];
				}
			}
		}
		$data['ediapidata'] = $ediapidata;

		//  -------------------Constraints------------------
		if($id !=""){
			$where = [
                'partner_id' => $id,
                'status' => 1
            ];
			$this->db->select('*');
            $this->db->where($where);
            $getConstraints = $this->db->get('partner_timeconstraints');
			if ($getConstraints->num_rows() > 0) {
				foreach ($getConstraints->result() as $row) {
					$timeConstraints[] = [
						'day' => $row->day,
						'type' => ($row->type == 1 ? 'Pickup' : 'Delivery'),
						'start_time' => ($row->type == 1 ? $row->pickup_start_time : $row->drop_start_time),
						'end_time' => ($row->type == 1 ? $row->pickup_end_time : $row->drop_end_time),
					];
				}
			}
		}
		$data['timeConstraints'] = $timeConstraints;

		if($id !=""){
			// 1. Get all vehicle type IDs and names in DESC order
			$allVehicleTypes = [];
			$this->db->select('id, trucktype');
			$this->db->from('tb_trucktypes');
			$this->db->order_by('id', 'DESC');
			$types_query = $this->db->get();
			if ($types_query->num_rows() > 0) {
				foreach ($types_query->result() as $row) {
					$allVehicleTypes[$row->id] = $row->trucktype;
				}
			}

			// 2. Get assigned vehicle type IDs for this partner
			$assignedTypeIds = [];
			$this->db->select('trucktype_id');
			$this->db->from('partner_vehicletypes');
			$this->db->where('partner_id', $id);
			$this->db->where('status', 1);
			$assigned_q = $this->db->get();
			if ($assigned_q->num_rows() > 0) {
				foreach ($assigned_q->result() as $row) {
					$assignedTypeIds[] = $row->trucktype_id;
				}
			}

			// 3. Find vehicle names NOT assigned to this partner (desc order)
			$unassignedNames = [];
			foreach ($allVehicleTypes as $vid => $vname) {
				if (!in_array($vid, $assignedTypeIds)) {
					$unassignedNames[] = $vname;
				}
			}

		}
		$data['unassignedNames'] = $unassignedNames;

		if($id !=""){
			$vehicleData = [];
			$this->db->select('pvt.trucktype_id, tt.trucktype');
			$this->db->from('partner_vehicletypes pvt');
			$this->db->join('tb_trucktypes tt', 'tt.id = pvt.trucktype_id', 'left');
			$this->db->where('pvt.partner_id', $id);
			$this->db->where('pvt.status', 1);
			$getVehicles = $this->db->get();

			if ($getVehicles->num_rows() > 0) {
				foreach ($getVehicles->result() as $row) {
					$vehicleData[] = [
						'trucktype_id' => $row->trucktype_id,
						'trucktype'    => $row->trucktype
					];
				}
			}
		}
		$data['vehicleData'] = $vehicleData;

		// -----------------------End Constraints--------------------

		//$this->newtemplate->dashboard("businesspartners/viewbusinesspartner", $data);
		$this->load->view("businesspartners/viewbusinesspartner", $data);
	}

	public function deletepartners(int $id): void
	{
		$response = 0;
		if ($id > 0) {
			$checkPartyMaster = $this->common->gettblrowdata(['id' => $id], "id,party_type_id,name,code,company_code,party_types", "tbl_party_master", 0, 0);
			if (!empty($checkPartyMaster)) {
				$userName = $checkPartyMaster['name'];
				$userCode = $checkPartyMaster['code'];
				$partyTypeId = $checkPartyMaster['party_type_id'];
				$partyTypes = $checkPartyMaster['party_types'];
				$userCompanyCode = $checkPartyMaster['company_code'] === '' ? $this->session->userdata('company_code') : $checkPartyMaster['company_code'];
				$updatePartyMaster = $this->common->updatetbledata("tbl_party_master", ['status' => '0'], ['id' => $id]);
				$partyTypesArray = [];
				if ($updatePartyMaster) {
					$partyTypesArray = explode(",", $partyTypes);
					$partyTypesArray[] = $partyTypeId;
					if (!empty($partyTypesArray)) {
						$checkCarrier = $this->bpartners->chkpartytype($partyTypesArray, 'Carrier');
						if ($checkCarrier->num_rows() > 0) {
							$checkCarrierMaster = $this->common->gettblrowdata(['name' => $userName, 'code' => $userCode, 'company_code' => $userCompanyCode, 'status' => '1'], "id", "tb_vendors", 0, 0);
							if (!empty($checkCarrierMaster) && $checkCarrierMaster['id'] > 0) {
								$this->common->updatetbledata("tb_vendors", ['status' => '0'], ['id' => $checkCarrierMaster['id']]);
							}
						} else {
							$checkCustomer = $this->bpartners->chkpartytype($partyTypesArray, 'Customer');
							if ($checkCustomer->num_rows() > 0) {
								$checkCustomerMaster = $this->common->gettblrowdata(['name' => $userName, 'code' => $userCode, 'company_code' => $userCompanyCode, 'status' => '1'], "id", "tb_customers", 0, 0);
								if (!empty($checkCustomerMaster) && $checkCustomerMaster['id'] >0) {
									$this->common->updatetbledata("tb_customers", ['status' => '0'], ['id' => $checkCustomerMaster['id']]);
								}
							}
						}
					}
					$response = 1;
					$this->common->updatetbledata("partner_timeconstraints", ['status' => '0'], ['partner_id' => $id]);
					$this->common->updatetbledata("partner_vehicletypes", ['status' => '0'], ['partner_id' => $id]);
				}
			}
		}
		echo $response;
	}

	public function partnercontacts(){
		$data = [];
		$this->load->view('businesspartners/contacts',$data);
	}
	public function financials(){
		$data = [];
		$this->load->view('businesspartners/financials',$data);
	}
	/*insert party reference*/
    public function insertpartyref(): void
    {
        $data = [];
        $post = $this->input->post(NULL,TRUE);
        $partnerid = $post['partner_id'] ?? 0;
        $referenceid = $post['referenceid'] ?? 0;
        $reference_type = $post['reference_type'] ?? 0;
        $name = $post['ref_name'] ?? "";
        $value = $post['ref_value'] ?? "";
        $gstin = $post['ref_gstin'] ?? "";
        $description = $post['ref_description'] ?? "";
        $curdt = date('Y-m-d H:i:s');
        $uid = $this->session->userdata('user_id');
        $reftype = "";
        $addFlag = true;

        $getRefType = $this->bpartners->gettblrowdata(['id' => $reference_type], "name", "tb_reference_types", 0, 0);
        $reftype = $getRefType['name'];
        if ($name == "eBooking") {
            $this->load->model('Bpartners');
            $checkEbookingRefCount = $this->Bpartners->getEbookingRef();
            if ($checkEbookingRefCount > 0) {
                $addFlag = false;
                $partyreference = ['reference_type' => $reference_type, 'partner_id' => $partnerid, 'name' => $name, 'value' => $value, 'description' => $description, 'gstin' => $gstin, 'user_id' => $uid, 'status' => 1, 'updatedon' => $curdt];
                $update = $this->bpartners->updatedata('tb_party_reference', $referenceid, $partyreference);
				if ($this->db->affected_rows() > 0) {
                    $data = ['reftype' => $reftype, 'referenceid' => $referenceid, 'reference_type' => $reference_type, 'name' => $name, 'value' => $value,
					'description' => $description, 'gstin' => $gstin,
					'message'=>"Reference for eBooking updated successfully!",'refresh'=>1];
                }else{
					$data = ['reftype' => $reftype, 'referenceid' => $referenceid, 'reference_type' => $reference_type, 'name' => $name, 'value' => $value,
					'description' => $description, 'gstin' => $gstin,
					'message'=>"Reference for eBooking already exists. Please try editing it!",'refresh'=>0];
				}
            } else {
                $addFlag = true;
            }
        }
        if ($addFlag) {
            if ($referenceid > 0) {
                $partyreference = ['reference_type' => $reference_type, 'partner_id' => $partnerid, 'name' => $name, 'value' => $value, 'description' => $description, 'gstin' => $gstin, 'user_id' => $uid, 'status' => 1, 'updatedon' => $curdt];
                $update = $this->bpartners->updatedata('tb_party_reference', $referenceid, $partyreference);

                if ($update) {
                    $data = ['reftype' => $reftype, 'referenceid' => $referenceid,
					'reference_type' => $reference_type, 'name' => $name, 'value' => $value,
					'description' => $description, 'gstin' => $gstin,
					'refresh'=>0,'message'=>'Reference for eBooking has been updated!'];
                }
            } else {
                $partyreference = ['reference_type' => $reference_type, 'partner_id' => $partnerid, 'name' => $name, 'value' => $value, 'gstin' => $gstin, 'description' => $description, 'user_id' => $uid, 'status' => 1, 'createdon' => $curdt, 'updatedon' => $curdt];
                if ($partnerid > 0) {
                    $checkPartner = $this->bpartners->gettblrowdata(['reference_type' => $reference_type, 'partner_id' => $partnerid, 'value' => $value, 'status' => 1], "id", "tb_party_reference", 0, 0);
                    if (empty($checkPartner)) {
                        $refid = $this->common->insertTableData("tb_party_reference", $partyreference);
                    } else {
                        $refid = $checkPartner['id'];
                        $update = $this->bpartners->updatedata('tb_party_reference', $refid, $partyreference);
                    }
                } else {
                    $refid = $this->common->insertTableData("tb_party_reference", $partyreference);
                }
                if ($refid > 0) {
                    $data = ['reftype' => $reftype, 'referenceid' => $refid,
					'reference_type' => $reference_type, 'name' => $name, 'value' => $value,
					'description' => $description, 'gstin' => $gstin,
					'refresh'=>1,'message'=>'Reference for eBooking has been added!'];
                }
            }
        }

        echo json_encode($data);
    }
	/*Delete party reference*/
	public function deletepartyref(){
		$data['status'] = 0;
        $referenceid = $this->input->post('referenceid',true);
		if($referenceid > 0){
			$curdt = date('Y-m-d H:i:s');
			$partyreference = ['status'=>0,'updatedon'=>$curdt];
			$update = $this->bpartners->updatedata('tb_party_reference',$referenceid,$partyreference);
			if($update){
				$data['status'] = 1;
			}
		}

		echo json_encode($data);
	}

	/*insert and update party Contact*/
	public function insertpartycon(){
		$data = [];
		$post = $this->input->post(NULL,TRUE);
		$partnerid = isset($post['partner_id']) ? $post['partner_id'] : 0;
		$contactid = (isset($post['contactid']) && ($post['contactid'] != '')) ? $post['contactid'] : 0;
		$partner_name = isset($post['partner_name']) ? $post['partner_name'] : "";
		$partner_street = isset($post['partner_street']) ? $post['partner_street'] : "";
		$partner_city = isset($post['partner_city']) ? $post['partner_city'] : "";
		$partner_state = isset($post['partner_state']) ? $post['partner_state'] : "";
		$partner_country = isset($post['partner_country']) ? $post['partner_country'] : "";
		$partner_zipcode = isset($post['partner_zipcode']) ? $post['partner_zipcode'] : "";
		$partner_phone = isset($post['partner_phone']) ? $post['partner_phone'] : "";
		$partner_fax = isset($post['partner_fax']) ? $post['partner_fax'] : "";
		$partner_email = isset($post['partner_email']) ? $post['partner_email'] : "";
		$curdt = date('Y-m-d H:i:s');
		$uid = $this->session->userdata('user_id');
		if($contactid == 0 ){
			$condata = ['partner_id'=>$partnerid,'name'=>$partner_name,'street'=>$partner_street,'city'=>$partner_city,'state'=>$partner_state,'country'=>$partner_country,'zipcode'=>$partner_zipcode,'phone'=>$partner_phone,'fax'=>$partner_fax,'email'=>$partner_email,'user_id'=>$uid,'status'=>1,'created_on'=>$curdt,'updated_on'=>$curdt];
			$conid = $this->common->insertTableData("tbl_partner_contacts",$condata);
			$newpartnerdata =[];
			$whr['id']= $partnerid;
			$getpartnerdata = $this->bpartners->gettblrowdata($whr,"party_type_id,company_code,branch_code,department_code,party_types,category_type,category_id,acon_debitor_code,kn_login_account,","tbl_party_master",0,0);
			if(count($getpartnerdata) > 0){
				$newpartnerdata = 	$getpartnerdata;
			}
			$newpartnerdata['name'] = $partner_name;
			$newpartnerdata['email'] = $partner_email;
			$newpartnerdata['mobile'] = $partner_phone;
			$newpartnerdata['user_id'] = $uid;
			$newpartnerdata['parent_id'] = $partnerid;
			$newpartnerdata['location_id'] = $partner_city;
			$newpartnerdata['country'] = $partner_country;
			$newpartnerdata['state'] = $partner_state;
			$newpartnerdata['street'] = $partner_street;
			$newpartnerdata['pincode'] = $partner_zipcode;
			$newpartnerdata['fax'] = $partner_fax;
			$newpartnerid = $this->common->insertTableData("tbl_party_master",$newpartnerdata);
			if($newpartnerid >0){
				$countrycode = $this->bpartners->getcountrycode($uid);
				$code = $countrycode.date('y').date('W').$newpartnerid;
				$upd = ['code'=>$code];
				$updatecode = $this->bpartners->updatedata('tbl_party_master',$newpartnerid,$upd);
				$upcontact = ['child_partnerid'=>$newpartnerid];
				$updatecode = $this->bpartners->updatedata('tbl_partner_contacts',$conid,$upcontact);
			}
			if($conid >0){
				$data = ['contactid'=>$conid,'name'=>$partner_name,'street'=>$partner_street,'city'=>$partner_city,'state'=>$partner_state,'country'=>$partner_country,'zipcode'=>$partner_zipcode,'phone'=>$partner_phone,'fax'=>$partner_fax,'email'=>$partner_email];
			}
		}else if($contactid > 0){
			$condata = ['partner_id'=>$partnerid,'name'=>$partner_name,'street'=>$partner_street,'city'=>$partner_city,'state'=>$partner_state,'country'=>$partner_country,'zipcode'=>$partner_zipcode,'phone'=>$partner_phone,'fax'=>$partner_fax,'email'=>$partner_email,'user_id'=>$uid,'status'=>1,'updated_on'=>$curdt];
			$update = $this->bpartners->updatedata('tbl_partner_contacts',$contactid,$condata);
			if($update){
				$getchild_partnerid = $this->bpartners->getchildpartnerid($contactid);
				if($getchild_partnerid > 0){
					$newpartnerdata = ["name"=>$partner_name,"email"=>$partner_email,"mobile"=>$partner_phone,"location_id"=>$partner_city,"country"=>$partner_country,"state"=>$partner_state,"street"=>$partner_street,"pincode"=>$partner_zipcode,"fax"=>$partner_fax,"updated_on"=>$curdt];
					$update = $this->bpartners->updatedata('tbl_party_master',$getchild_partnerid,$newpartnerdata);
				}
				$data = ['contactid'=>$contactid,'name'=>$partner_name,'street'=>$partner_street,'city'=>$partner_city,'state'=>$partner_state,'country'=>$partner_country,'zipcode'=>$partner_zipcode,'phone'=>$partner_phone,'fax'=>$partner_fax,'email'=>$partner_email];
			}
		}
		echo json_encode($data);
	}
	/*Delete party Contact*/
	public function deletepartycon(){
		$data['status'] = 0;
		$post = $this->input->post(NULL,TRUE);
		$contactid = isset($post['contactid']) ? $post['contactid'] : 0;
		if($contactid > 0){
			$curdt = date('Y-m-d H:i:s');
			$partyreference = ['status'=>0,'updated_on'=>$curdt];
			$update = $this->bpartners->updatedata('tbl_partner_contacts',$contactid,$partyreference);
			if($update){
				$data['status'] = 1;
			}
		}
		echo json_encode($data);
	}
	/*insert  reference name*/
	public function getrefname($id){
		$data['name'] = "";
		if($id != ""){
            $where = [
                'id' => $id,
                'status' => 1
            ];
            $this->db->select('name');
            $this->db->where($where);
            $getName = $this->db->get('tb_reference_types');
			if($getName->num_rows() > 0){
				$data['name'] = $getName->row()->name;
			}
		}
		echo json_encode($data);
	}



	/*insert Partner Details*/
	public function insertpartnerdetails(){
		$data = [];
		$post = $this->input->post(NULL,TRUE);
		$uid = $this->session->userdata('user_id');
		$customer_code = isset($post['customer_code']) ? $post['customer_code'] : "";
		$companycode = isset($post['companycode']) ? $post['companycode'] : "";
		$cid = isset($post['cid']) ? $post['cid'] : "";
		$branchcode = isset($post['branchcode']) ? $post['branchcode'] : "";
		$debitor_code = isset($post['debitor_code']) ? $post['debitor_code'] : "";
		$departmentcode = isset($post['departmentcode']) ? $post['departmentcode'] : "";
		$kn_login = isset($post['kn_login']) ? $post['kn_login'] : "";
		$partytypes = implode(',', $post['partytypes']);

		$addrs_name = isset($post['addrs_name']) ? $post['addrs_name'] : "";
		$division_name = isset($post['division_name']) ? $post['division_name'] : "";
		$sub_district = isset($post['sub_district']) ? $post['sub_district'] : "";
		$addrs_street = isset($post['addrs_street']) ? $post['addrs_street'] : "";
		$street_2 = isset($post['street_2']) ? $post['street_2'] : "";
		$street_3 = isset($post['street_3']) ? $post['street_3'] : "";
		$house_number = isset($post['house_number']) ? $post['house_number'] : "";
		$addrs_building = isset($post['addrs_building']) ? $post['addrs_building'] : "";
		$addrs_country = isset($post['addrs_country']) ? $post['addrs_country'] : "";
		$postal_code = isset($post['postal_code']) ? $post['postal_code'] : "";
		$addrs_city = isset($post['addrs_city']) ? $post['addrs_city'] : "";
		$addrs_province = isset($post['addrs_province']) ? $post['addrs_province'] : "";
		$addrs_extension = isset($post['addrs_extension']) ? $post['addrs_extension'] : "";
		$addrs_latitude = isset($post['addrs_latitude']) ? $post['addrs_latitude'] : "";
		$addrs_longitude = isset($post['addrs_longitude']) ? $post['addrs_longitude'] : "";
		$main_homepage = isset($post['main_homepage']) ? $post['main_homepage'] : "";
		$addrs_cid = isset($post['addrs_cid']) ? $post['addrs_cid'] : "";
		$kn_office = isset($post['kn_office']) ? $post['kn_office'] : 0;
		$external_partner = isset($post['external_partner']) ? $post['external_partner'] : 0;
		$zone_city = isset($post['zone_city']) ? $post['zone_city'] : "";
		$zone_code = isset($post['zone_code']) ? $post['zone_code'] : "";
		$zone_name = isset($post['zone_name']) ? $post['zone_name'] : "";


		$curdt = date('Y-m-d H:i:s');

		if($customer_code !="" && $companycode !=""){
			$partnerdata = ['party_types'=>$partytypes,'user_id'=>$uid,'code'=>$cid,'company_code'=>$companycode,'	branch_code'=>$branchcode,'department_code'=>$departmentcode,'customer_code'=>$customer_code,'acon_debitor_code'=>$debitor_code,'kn_login_account'=>$kn_login,'created_on'=>$curdt,'updated_on'=>$curdt];
			$partnerid = $this->common->insertTableData("tbl_party_master",$partnerdata);
			if($partnerid >0){
				$data = ['partnerid'=>$partnerid,'customer_code'=>$customer_code,'companycode'=>$companycode,'cid'=>$cid,'branchcode'=>$branchcode,'debitor_code'=>$debitor_code];
			}
		}
		echo json_encode($data);
	}



	public function savepartnercontacts($partnercontacts,$contactdata,$partnerdata){
		$condata = [];
		$name =  $street = $city = $state = $country = $zipcode = $phone = $fax = $email = "";
		$newpartnerdata = [];
		foreach ($partnercontacts as $contact) {
			$newpartnerdata = $partnerdata;
			$contact = explode('||',$contact);
			if(isset($contact[0])){ $name = $contact[0]; }
			if(isset($contact[1])){ $street = $contact[1]; }
			if(isset($contact[2])){ $city = $contact[2]; }
			if(isset($contact[3])){ $state = $contact[3]; }
			if(isset($contact[4])){ $country = $contact[4]; }
			if(isset($contact[5])){ $zipcode = $contact[5]; }
			if(isset($contact[6])){ $phone = $contact[6]; }
			if(isset($contact[7])){ $fax = $contact[7]; }
			if(isset($contact[8])){ $email = $contact[8]; }
			$condata = ['partner_id'=>$contactdata['partnerid'],'name'=>$name,'street'=>$street,'city'=>$city,'state'=>$state,'country'=>$country,'zipcode'=>$zipcode,'phone'=>$phone,'fax'=>$fax,'email'=>$email,'user_id'=>$contactdata['uid'],'status'=>1,'created_on'=>$contactdata['curdt'],'updated_on'=>$contactdata['curdt']];
			$contact_id = $this->common->insertTableData("tbl_partner_contacts",$condata);
			$newpartnerdata['party_type_id'] = $contactdata['party_type_id'];
			$newpartnerdata['name'] = $name;
			$newpartnerdata['email'] = $email;
			$newpartnerdata['mobile'] = $phone;
			$newpartnerdata['code'] = 0;
			$newpartnerdata['parent_id'] = $contactdata['partnerid'];
			$newpartnerdata['location_id'] = $city;
			$newpartnerdata['country'] = $country;
			$newpartnerdata['state'] = $state;
			$newpartnerdata['street'] = $street;
			$newpartnerdata['pincode'] = $zipcode;
			$newpartnerdata['fax'] = $fax;

			$newpartnerid = $this->common->insertTableData("tbl_party_master",$newpartnerdata);
			if($newpartnerid >0){
				$countrycode = $this->bpartners->getcountrycode($contactdata['uid']);
				$code = $countrycode.date('y').date('W').$newpartnerid;
				$upd = ['code'=>$code];
				$updatecode = $this->bpartners->updatedata('tbl_party_master',$newpartnerid,$upd);
				$upcontact = ['child_partnerid'=>$newpartnerid];
				$updatecode = $this->bpartners->updatedata('tbl_partner_contacts',$contact_id,$upcontact);
			}
		}

	}
	public function editpartnerdata($id){
		$data = $partnerdata = $condata = $refdata =  [];
		if($id !=""){
            $where = [
                'id' => $id,
                'status' => 1
            ];
            $this->db->select('*');
            $this->db->where($where);
            $this->db->order_by('created_on','DESC');
            $getParty = $this->db->get('tbl_party_master');
            if($getParty->num_rows() >0){
				$party_types = $getParty->row()->party_types;
				$partytypes = [];
				if($party_types != ""){
					$partytypes = explode(',', $party_types);
				}
				$data = [
                    'party_types'=>$partytypes,
                    'name'=>$getParty->row()->name,
                    'location_id'=>$getParty->row()->location_id,
                    'division_name'=>$getParty->row()->division_name,
                    'sub_district'=>$getParty->row()->sub_district,
                    'street'=>$getParty->row()->street,
                    'street_2'=>$getParty->row()->street_2,
                    'street_3'=>$getParty->row()->street_3,
                    'house_number'=>$getParty->row()->street,
                    'building'=>$getParty->row()->street,
                    'state'=>$getParty->row()->state,
                    'pincode'=>$getParty->row()->pincode,
                    'country'=>$getParty->row()->country,
                    'extension'=>$getParty->row()->extension,
                    'latitude'=>$getParty->row()->latitude,
                    'longitude'=>$getParty->row()->longitude,
                    'homepage'=>$getParty->row()->homepage,
                    'external_partner'=>$getParty->row()->external_partner,
                    'time_zone_city'=>$getParty->row()->time_zone_city,
                    'time_zone_code'=>$getParty->row()->time_zone_code,
                    'time_zone_name'=>$getParty->row()->time_zone_name,
                    'code'=>$getParty->row()->code,
                    'company_code'=>$getParty->row()->company_code,
                    'branch_code'=>$getParty->row()->branch_code,
                    'department_code'=>$getParty->row()->department_code,
                    'customer_code'=>$getParty->row()->customeridentifier,
                    'acon_debitor_code'=>$getParty->row()->acon_debitor_code,
                    'kn_login_account'=>$getParty->row()->kn_login_account,
                    'partner_id'=>$id
                ];
			}

            $where = [
                'partner_id' => $id,
                'status' => 1
            ];
            $this->db->select('*');
            $this->db->where($where);
            $getPartnerContacts = $this->db->get('tbl_partner_contacts');
            if($getPartnerContacts->num_rows() >0){
				foreach ($getPartnerContacts->result() as $contact) {
					$condata[] = [
                        'id'=>$contact->id,
                        'name'=>$contact->name,
                        'street'=>$contact->street,
                        'city'=>$contact->city,
                        'state'=>$contact->state,
                        'country'=>$contact->country,
                        'zipcode'=>$contact->zipcode,
                        'phone'=>$contact->phone,
                        'fax'=>$contact->fax,
                        'email'=>$contact->email
                    ];
				}
			}
            $where = [
                'partner_id' => $id,
                'status' => 1
            ];
            $this->db->select('*');
            $this->db->where($where);
            $getPartyReference = $this->db->get('tb_party_reference');
            if($getPartyReference->num_rows() >0){
				$reftype = "";
				foreach ($getPartyReference->result() as $refs) {
                    $where = [
                        'id' => $refs->reference_type,
                        'status' => 1
                    ];
                    $this->db->select('name');
                    $this->db->where($where);
                    $getReferenceTypes = $this->db->get('tb_reference_types');
                    if($getReferenceTypes->num_rows() >0){
						$reftype = $getReferenceTypes->row()->name;
					}
					$refdata[] = [
                        'id'=>$refs->id,
                        'reference_type'=>$refs->reference_type,
                        'reftype'=>$reftype,
                        'name'=>$refs->name,
                        'value'=>$refs->value,
                        'description'=>$refs->description,
                        'gstin'=>$refs->gstin
                    ];
				}
			}
		}
		$data['condata'] = $condata;
		$data['refdata'] = $refdata;
		$data['partners'] =[];
        echo json_encode($data);
    }


    /*view partner details*/
    public function viewpartnerdata($id){
    	$data = $partnerdata = $condata = $refdata =  [];
    	if($id !=""){
    		$getParties =[];
    		$uid = $this->session->userdata('user_id');
    		$company_code = $this->session->userdata('company_code');
    		$branch_code = $this->session->userdata('branch_code');
    		$getParties1 = $this->bpartners->getpartytypes($uid,$company_code);
    		if($getParties1->num_rows() > 0){
    			foreach ($getParties1->result() as $gparty) {
    				$getParties[] = ['id'=>$gparty->id,'name'=>ucfirst(strtolower($gparty->name)),'description'=>$gparty->description];
    			}
    		}
            $where = [
                'id' => $id,
                'status' => 1
            ];
            $this->db->select('*');
            $this->db->where($where);
            $this->db->order_by('created_on','DESC');
            $getParty = $this->db->get('tbl_party_master');
            if($getParty->num_rows() >0){
    			$party_types = $getParty->row()->party_types;
    			$partytypes = [];
    			if($party_types != ""){
    				$partytypes = explode(',', $party_types);
    			}
    			$bpassword = $getParty->row()->password;
    			if($bpassword != ""){
    				$bpassword = (($bpassword));
    			}
    			$category_id = $getParty->row()->category_id;
    			$catname =	"";
    			if($category_id > 0){
    				$catname = $this->bpartners->getcategoryname($category_id);
    			}
    			$data = [
                    'partytypes'=>$partytypes,
                    'name'=>$getParty->row()->name,
                    'email'=>$getParty->row()->email,
                    'mobile'=>$getParty->row()->mobile,
                    'location_id'=>$getParty->row()->location_id,
                    'division_name'=>$getParty->row()->division_name,
                    'sub_district'=>$getParty->row()->sub_district,
                    'street'=>$getParty->row()->street,
                    'street_2'=>$getParty->row()->street_2,
                    'street_3'=>$getParty->row()->street_3,
                    'house_number'=>$getParty->row()->house_number,
                    'building'=>$getParty->row()->building,
                    'state'=>$getParty->row()->state,
                    'pincode'=>$getParty->row()->pincode,
                    'country'=>$getParty->row()->country,
                    'extension'=>$getParty->row()->extension,
                    'latitude'=>$getParty->row()->latitude,
                    'longitude'=>$getParty->row()->longitude,
                    'homepage'=>$getParty->row()->homepage,
                    'category_type'=>$getParty->row()->category_type,
                    'catname'=>$catname,
                    'time_zone_city'=>$getParty->row()->time_zone_city,
                    'time_zone_code'=>$getParty->row()->time_zone_code,
                    'time_zone_name'=>$getParty->row()->time_zone_name,
                    'code'=>$getParty->row()->code,
                    'company_code'=>$getParty->row()->company_code,
                    'branch_code'=>$getParty->row()->branch_code,
                    'department_code'=>$getParty->row()->department_code,
                    'customer_code'=>$getParty->row()->customeridentifier,
                    'acon_debitor_code'=>$getParty->row()->acon_debitor_code,
                    'kn_login_account'=>$getParty->row()->kn_login_account,
                    'password'=>$bpassword,'partner_id'=>$id
                ];
    		}
            $where = [
                'partner_id' => $id,
                'status' => 1
            ];
            $this->db->select('*');
            $this->db->where($where);
            $getPartnerContacts = $this->db->get('tbl_partner_contacts');
            if($getPartnerContacts->num_rows() >0){
    			foreach ($getPartnerContacts->result() as $contact) {
    				$condata[] = [
                        'id'=>$contact->id,
                        'name'=>$contact->name,
                        'street'=>$contact->street,
                        'city'=>$contact->city,
                        'state'=>$contact->state,
                        'country'=>$contact->country,
                        'zipcode'=>$contact->zipcode,
                        'phone'=>$contact->phone,
                        'fax'=>$contact->fax,
                        'email'=>$contact->email
                    ];
    			}

    		}
            $where = [
                'partner_id' => $id,
                'status' => 1
            ];
            $this->db->select('*');
            $this->db->where($where);
            $getPartyReference = $this->db->get('tb_party_reference');
            if($getPartyReference->num_rows() >0){
    			$reftype = "";
    			foreach ($getPartyReference->result() as $refs) {
                    $where = [
                        'id' => $refs->reference_type,
                        'status' => 1
                    ];
                    $this->db->select('name');
                    $this->db->where($where);
                    $getRefType = $this->db->get('tb_reference_types');
                    if($getRefType->num_rows() >0){
    					$reftype = $getRefType->row()->name;
    				}
    				$refdata[] = [
                        'id'=>$refs->id,
                        'reference_type'=>$refs->reference_type,
                        'reftype'=>$reftype,
                        'name'=>$refs->name,
                        'value'=>$refs->value,
                        'description'=>$refs->description,
                        'gstin'=>$refs->gstin
                    ];
    			}
    		}
    	}
    	$data['condata'] = $condata;
    	$data['refdata'] = $refdata;
    	$data['getparties'] = $getParties;
    	$data['partners'] = [];
    	$this->load->view('businesspartners/detailsview',$data);
    }
    /*view contacts*/
    public function viewcontacts($id){
    	$data = $condata = [];
    	if($id !=""){
            $where = [
                'partner_id' => $id,
                'status' => 1
            ];
            $this->db->select('*');
            $this->db->where($where);
            $getPartnerContacts = $this->db->get('tbl_partner_contacts');
            if($getPartnerContacts->num_rows() >0){
    			foreach ($getPartnerContacts->result() as $contact) {
    				$condata[] = [
                        'id'=>$contact->id,
                        'name'=>$contact->name,
                        'street'=>$contact->street,
                        'city'=>$contact->city,
                        'state'=>$contact->state,
                        'country'=>$contact->country,
                        'zipcode'=>$contact->zipcode,
                        'phone'=>$contact->phone,
                        'fax'=>$contact->fax,
                        'email'=>$contact->email
                    ];
    			}

    		}
    	}
    	$data['condata'] = $condata;
    	$this->load->view('businesspartners/contactsview',$data);
    }


    /*view edit partner details*/
    public function vieweditpartnerdata($id){
    	$data = $partnerdata = $condata = $refdata = $reftypes =  [];
    	if($id !=""){
    		$getParties =[];
    		$uid = $this->session->userdata('user_id');
    		$company_code = $this->session->userdata('company_code');
    		$branch_code = $this->session->userdata('branch_code');
    		$getParties1 = $this->bpartners->getpartytypes($uid,$company_code);
    		if($getParties1->num_rows() > 0){
    			foreach ($getParties1->result() as $gparty) {
    				$getParties[] = ['id'=>$gparty->id,'name'=>ucfirst(strtolower($gparty->name)),'description'=>$gparty->description];
    			}
    		}
            $this->db->select('id,name');
            $this->db->where('status', 1);
            $getRefTypes = $this->db->get('tb_reference_types');
    		if($getRefTypes->num_rows() > 0){
    			foreach ($getRefTypes->result() as $reftype) {
    				$reftypes[] = ['id'=>$reftype->id,'name'=>$reftype->name];
    			}
    		}
            $where = [
                'id' => $id,
                'status' => 1
            ];
            $this->db->select('*');
            $this->db->where($where);
            $this->db->order_by('created_on','DESC');
            $getParty = $this->db->get('tbl_party_master');
            if($getParty->num_rows() >0){
    			$party_types = $getParty->row()->party_types;
    			$partytypes = [];
    			if($party_types != ""){
    				$partytypes = explode(',', $party_types);
    			}else{
    				$partytypes = [$getParty->row()->party_type_id];
    			}
    			$bpassword = $getParty->row()->password;
    			if($bpassword != ""){
    				$bpassword = (($bpassword));
    			}
    			$category_id = $getParty->row()->category_id;
    			$categorydata =	[];
    			if($category_id > 0){
    				$getcatname = $this->bpartners->getcategoryname($category_id);
    				$categorydata =	['id'=>$category_id,'name'=>$getcatname];
    			}
    			$data = [
                    'partytypes'=>$partytypes,
                    'name'=>$getParty->row()->name,
                    'email'=>$getParty->row()->email,
                    'mobile'=>$getParty->row()->mobile,
                    'location_id'=>$getParty->row()->location_id,
                    'division_name'=>$getParty->row()->division_name,
                    'sub_district'=>$getParty->row()->sub_district,
                    'street'=>$getParty->row()->street,
                    'street_2'=>$getParty->row()->street_2,
                    'street_3'=>$getParty->row()->street_3,
                    'house_number'=>$getParty->row()->house_number,
                    'building'=>$getParty->row()->building,
                    'state'=>$getParty->row()->state,
                    'pincode'=>$getParty->row()->pincode,
                    'country'=>$getParty->row()->country,
                    'extension'=>$getParty->row()->extension,
                    'latitude'=>$getParty->row()->latitude,
                    'longitude'=>$getParty->row()->longitude,
                    'homepage'=>$getParty->row()->homepage,
                    'category_type'=>$getParty->row()->category_type,
                    'categorydata'=>$categorydata,
                    'time_zone_city'=>$getParty->row()->time_zone_city,
                    'time_zone_code'=>$getParty->row()->time_zone_code,
                    'time_zone_name'=>$getParty->row()->time_zone_name,
                    'code'=>$getParty->row()->code,
                    'company_code'=>$getParty->row()->company_code,
                    'branch_code'=>$getParty->row()->branch_code,
                    'department_code'=>$getParty->row()->department_code,
                    'customer_code'=>$getParty->row()->customeridentifier,
                    'acon_debitor_code'=>$getParty->row()->acon_debitor_code,
                    'kn_login_account'=>$getParty->row()->kn_login_account,
                    'password'=>$bpassword,
                    'partner_id'=>$id
                ];
    		}
            $where = [
                'partner_id' => $id,
                'status' => 1
            ];
            $this->db->select('*');
            $this->db->where($where);
            $getPartnerContacts = $this->db->get('tbl_partner_contacts');
            if($getPartnerContacts->num_rows() >0){
    			foreach ($getPartnerContacts->result() as $contact) {
    				$condata[] = [
                        'id'=>$contact->id,
                        'name'=>$contact->name,
                        'street'=>$contact->street,
                        'city'=>$contact->city,
                        'state'=>$contact->state,
                        'country'=>$contact->country,
                        'zipcode'=>$contact->zipcode,
                        'phone'=>$contact->phone,
                        'fax'=>$contact->fax,
                        'email'=>$contact->email
                    ];
    			}
    		}
            $where = [
                'partner_id' => $id,
                'status' => 1
            ];
            $this->db->select('*');
            $this->db->where($where);
            $getPartyReference = $this->db->get('tb_party_reference');
            if($getPartyReference->num_rows() >0){
    			$reftype = "";
    			foreach ($getPartyReference->result() as $refs) {
                    $where = [
                        'id' => $refs->reference_type,
                        'status' => 1
                    ];
                    $this->db->select('name');
                    $this->db->where($where);
                    $getRefType = $this->db->get('tb_reference_types');
                    if($getRefType->num_rows() >0){
    					$reftype = $getRefType->row()->name;
    				}
    				$refdata[] = [
                        'id'=>$refs->id,
                        'reference_type'=>$refs->reference_type,
                        'reftype'=>$reftype,
                        'name'=>$refs->name,
                        'value'=>$refs->value,
                        'description'=>$refs->description
                    ];
    			}
    		}
    	}
    	$data['condata'] = $condata;
    	$data['refdata'] = $refdata;
    	$data['getparties'] = $getParties;
    	$data['reftypes'] = $reftypes;
    	$data['partner_id'] = $id;
    	$this->load->view('businesspartners/partnerdetails',$data);
    }

    /*view edit contacts*/
    public function vieweditcontacts($id){
    	$data = $condata = [];
    	if($id !=""){
            $where = [
                'partner_id' => $id,
                'status' => 1
            ];
            $this->db->select('*');
            $this->db->where($where);
            $getPartnerContacts = $this->db->get('tbl_partner_contacts');
            if($getPartnerContacts->num_rows() >0){
    			foreach ($getPartnerContacts->result() as $contact) {
    				$condata[] = [
                        'id'=>$contact->id,
                        'name'=>$contact->name,
                        'street'=>$contact->street,
                        'city'=>$contact->city,
                        'state'=>$contact->state,
                        'country'=>$contact->country,
                        'zipcode'=>$contact->zipcode,
                        'phone'=>$contact->phone,
                        'fax'=>$contact->fax,
                        'email'=>$contact->email
                    ];
    			}

    		}
    	}
    	$data['condata'] = $condata;
    	$this->load->view('businesspartners/contacts',$data);
    }




	/* insert/update party Accounts*/
	public function insertpartyaccounts(){
		$data = [];
		$post = $this->input->post(NULL,TRUE);
        $partnerid = isset($post['partner_id']) ? $post['partner_id'] : 0;
        $accountid = isset($post['accountid']) ? $post['accountid'] : 0;
        $account_number = isset($post['account_number']) ? $post['account_number'] : "";
        $acon_environment = isset($post['acon_environment']) ? $post['acon_environment'] : "";
        $company_code = isset($post['company_code']) ? $post['company_code'] : "";
        $source_system = isset($post['source_system']) ? $post['source_system'] : "";
        $billable = isset($post['billable']) ? $post['billable'] : 0;
        $pre_payment = isset($post['prepayment']) ? $post['prepayment'] : 0;
        $mutiple_invoices = isset($post['invoices']) ? $post['invoices'] : 0;
        $curdt = date('Y-m-d H:i:s');

        $uid = $this->session->userdata('user_id');
        if($accountid == 0 ){
        	$accdata = ['partner_id'=>$partnerid,'account_number'=>$account_number,'acon_environment'=>$acon_environment,'company_code'=>$company_code,'source_system'=>$source_system,'billable'=>$billable,'pre_payment'=>$pre_payment,'mutiple_invoices'=>$mutiple_invoices,'user_id'=>$uid,'status'=>1,'created_on'=>$curdt,'updated_on'=>$curdt];
        	$accid = $this->common->insertTableData("tbl_partner_accounts",$accdata);
        	if($accid >0){
        		$data = ['accountid'=>$accid,'account_number'=>$account_number,'acon_environment'=>$acon_environment,'company_code'=>$company_code,'source_system'=>$source_system,'billable'=>$billable,'pre_payment'=>$pre_payment,'mutiple_invoices'=>$mutiple_invoices];
        	}
        }else if($accountid > 0){
        	$accdata = ['partner_id'=>$partnerid,'account_number'=>$account_number,'acon_environment'=>$acon_environment,'company_code'=>$company_code,'source_system'=>$source_system,'billable'=>$billable,'pre_payment'=>$pre_payment,'mutiple_invoices'=>$mutiple_invoices,'user_id'=>$uid,'status'=>1,'updated_on'=>$curdt];
        	$update = $this->bpartners->updatedata('tbl_partner_accounts',$accountid,$accdata);
        	if($update){
        		$data = ['accountid'=>$accountid,'account_number'=>$account_number,'acon_environment'=>$acon_environment,'company_code'=>$company_code,'source_system'=>$source_system,'billable'=>$billable,'pre_payment'=>$pre_payment,'mutiple_invoices'=>$mutiple_invoices];
        	}
        }
        echo json_encode($data);
    }
    /* Delete party Accounts*/
    public function deletepartyaccount(){
    	$data['status'] = 0;
    	$post = $this->input->post(NULL,TRUE);
    	$accountid = isset($post['accountid']) ? $post['accountid'] : 0;
    	if($accountid > 0){
    		$curdt = date('Y-m-d H:i:s');
    		$partyaccount = ['status'=>0,'updated_on'=>$curdt];
    		$update = $this->bpartners->updatedata('tbl_partner_accounts',$accountid,$partyaccount);
    		if($update){
    			$data['status'] = 1;
    		}
    	}
    	echo json_encode($data);
    }

    /*insert/update party Contract*/
    public function insertpartycontract(){
    	$data = [];
    	$post = $this->input->post(NULL,TRUE);
    	$partnerid = isset($post['partner_id']) ? $post['partner_id'] : 0;
    	$contractid = isset($post['contractid']) ? $post['contractid'] : 0;
    	$company_code = isset($post['contract_company']) ? $post['contract_company'] : "";
    	$branch_code = isset($post['contract_branch']) ? $post['contract_branch'] : "";
    	$contract_id = isset($post['contract_id']) ? $post['contract_id'] : "";
    	$rate_derivation = isset($post['rate_derivation']) ? $post['rate_derivation'] : 0;
    	$curdt = date('Y-m-d H:i:s');
    	$uid = $this->session->userdata('user_id');
    	if($contractid == 0 ){
    		$condata = ['partner_id'=>$partnerid,'company_code'=>$company_code, 'branch_code'=>$branch_code, 'contract_id'=>$contract_id, 'rate_derivation'=>$rate_derivation,'user_id'=>$uid,'status'=>1,'created_on'=>$curdt,'updated_on'=>$curdt];
    		$conid = $this->common->insertTableData("tbl_partner_contracts",$condata);
    		if($conid >0){
    			$ratederivation = "";
    			if($rate_derivation == 1){ $ratederivation ="Specific"; }else{ $ratederivation ="Generic"; }
    			$data = ['contractid'=>$conid,'company_code'=>$company_code, 'branch_code'=>$branch_code, 'contract_id'=>$contract_id, 'rate_derivation'=>$ratederivation];
    		}
    	}else if($contractid > 0){
    		$condata = ['partner_id'=>$partnerid,'company_code'=>$company_code, 'branch_code'=>$branch_code, 'contract_id'=>$contract_id, 'rate_derivation'=>$rate_derivation,'user_id'=>$uid,'status'=>1,'updated_on'=>$curdt];
    		$update = $this->bpartners->updatedata('tbl_partner_contracts',$contractid,$condata);
    		if($update){
    			$ratederivation = "";
    			if($rate_derivation == 1){ $ratederivation ="Specific"; }else{ $ratederivation ="Generic"; }
    			$data = ['contractid'=>$contractid,'company_code'=>$company_code, 'branch_code'=>$branch_code, 'contract_id'=>$contract_id, 'rate_derivation'=>$ratederivation];
    		}
    	}
    	echo json_encode($data);
    }
    /* Delete party Contract*/
    public function deletepartycontract(){
    	$data['status'] = 0;
    	$post = $this->input->post(NULL,TRUE);
    	$contractid = isset($post['contractid']) ? $post['contractid'] : 0;
    	if($contractid > 0){
    		$curdt = date('Y-m-d H:i:s');
    		$partycontract = ['status'=>0,'updated_on'=>$curdt];
    		$update = $this->bpartners->updatedata('tbl_partner_contracts',$contractid,$partycontract);
    		if($update){
    			$data['status'] = 1;
    		}
    	}
    	echo json_encode($data);
    }



    public function getLatLng(){
    	$data = [];
    	$data['latitude'] = $data['longitude'] = "";
    	$post = $this->input->post(NULL,TRUE);
    	$street = isset($post['addrs_street']) ? $post['addrs_street'] : "";
    	$city = isset($post['addrs_city']) ? $post['addrs_city'] : "";
    	$country = isset($post['addrs_country']) ? $post['addrs_country'] : "";
    	$postal_code = isset($post['postal_code']) ? $post['postal_code'] : "";
    	$address = implode(",",[$street,$city ,$country,$postal_code]);
    	$latlngdata = [];
    	$latlngdata = getlatlngsbyplace($address);
    	if(!empty($latlngdata)){
    		$lat1 = @$latlngdata[0];
    		$lng1 = @$latlngdata[1];
    		$data['latitude'] = $lat1;
    		$data['longitude'] = $lng1;
    	}
    	echo json_encode($data);
    }

    /* insert/update party Edi-api*/
    public function insertpartyediapi(){
    	$data = [];
    	$post = $this->input->post(NULL,TRUE);
        $partner_id = (isset($post['partner_id']) && !empty($post['partner_id'])) ? (int) ($post['partner_id']) : 0;
        $transaction_action = (isset($post['transaction_action']) && !empty($post['transaction_action'])) ? (int) ($post['transaction_action']) : 0;
        $ediapiid = (isset($post['ediapiid']) && !empty($post['ediapiid'])) ? (int) ($post['ediapiid']) : 0;

        $inco_terms = (isset($post['inco_terms']) && !empty($post['inco_terms'])) ? (int) ($post['inco_terms']) : 0;
        $triggered_at = (isset($post['triggered_at']) && !empty($post['triggered_at'])) ? (int) ($post['triggered_at']) : 0;
        $retrigger = (isset($post['retrigger']) && !empty($post['retrigger'])) ? (int) ($post['retrigger']) : 0;
        $order_type = (isset($post['order_type']) && !empty($post['order_type'])) ? (int) ($post['order_type']) : 0;
        $order_status = (isset($post['order_status']) && !empty($post['order_status'])) ? (string) ($post['order_status']) : 0;
        $edi_product = (isset($post['edi_product']) && !empty($post['edi_product'])) ? (int) ($post['edi_product']) : 0;
        $edi_service = (isset($post['edi_service']) && !empty($post['edi_service'])) ? (int) ($post['edi_service']) : 0;
        $edi_transport = (isset($post['edi_transport']) && !empty($post['edi_transport'])) ? (int) ($post['edi_transport']) : 0;
        $edi_pickup = (isset($post['edi_pickup']) && !empty($post['edi_pickup'])) ? (string) ($post['edi_pickup']) : "";
        $edi_destination = (isset($post['edi_destination']) && !empty($post['edi_destination'])) ? (string) ($post['edi_destination']) : "";
        $edi_commodity = (isset($post['edi_commodity']) && !empty($post['edi_commodity'])) ? (string) ($post['edi_commodity']) : "";
        $ediapi_type = (isset($post['ediapi_type']) && !empty($post['ediapi_type'])) ? (int) ($post['ediapi_type']) : 0;
        $edi_username = isset($post['edi_username']) ? $post['edi_username'] : "";
        $edi_password = isset($post['edi_password']) ? $post['edi_password'] : "";
        $edi_url = (isset($post['edi_url']) && !empty($post['edi_url'])) ? (string) ($post['edi_url']) : "";
        $curdt = date('Y-m-d H:i:s');
        $uid = $this->session->userdata('user_id');
        $action = $triggeredat = $retriggerat = $ordertype = $ediproduct = $ediservice = $editransport = $ediapitype =
        $incoterm = $orderstatus ="";
        if($transaction_action > 0){
            $this->db->select('name');
            $this->db->where('id', $transaction_action);
            $getActions = $this->db->get('tbl_txn_actions');
            if($getActions->num_rows() >0){
        		$action = $getActions->row()->name;
        	}
        }
        if($inco_terms > 0){
            $this->db->select('name');
            $this->db->where('id', $inco_terms);
            $getIncotermsName = $this->db->get('tb_incoterms_master');
            if($getIncotermsName->num_rows() >0){
        		$incoterm = $getIncotermsName->row()->name;
        	}
        }
        if($triggered_at > 0){
        	if($triggered_at == 1){
        		$triggeredat = "Order Booked";
        	}else if($triggered_at == 2){
        		$triggeredat = "Trip Created";
        	}
        }
        if($retrigger > 0){
        	if($retrigger == 1){
        		$retriggerat = "Updated";
        	}else if($retrigger == 2){
        		$retriggerat = "None";
        	}
        }
        if($order_type > 0){
            $this->db->select('name');
            $this->db->where('id', $order_type);
            $getOrderTypes = $this->db->get('tbl_order_types');
            if($getOrderTypes->num_rows() >0){
        		$ordertype = $getOrderTypes->row()->name;
        	}
        }
        if($edi_product > 0){
            $this->db->select('name');
            $this->db->where('id', $edi_product);
            $getProductsName = $this->db->get('tb_products_master');
            if($getProductsName->num_rows() >0){
        		$ediproduct = $getProductsName->row()->name;
        	}
        }
        if($edi_service > 0){
            $this->db->select('name');
            $this->db->where('id', $edi_product);
            $getServiceName = $this->db->get('tb_service_master');
            if($getServiceName->num_rows() >0){
        		$ediservice = $getServiceName->row()->name;
        	}
        }
        if($edi_transport > 0){
            $this->db->select('code');
            $this->db->where('id', $edi_transport);
            $getTransportmodeCode = $this->db->get('tb_transportmode');
            if($getTransportmodeCode->num_rows() >0){
        		$editransport = $getTransportmodeCode->row()->code;
        	}
        }
        if($ediapi_type > 0){
            $this->db->select('name');
            $this->db->where('id', $ediapi_type);
            $getEdiTypesName = $this->db->get('tbl_edi_types');
            if($getEdiTypesName->num_rows() >0){
        		$ediapitype = $getEdiTypesName->row()->name;
        	}
        }
        if($order_status > 0){
            $this->db->select('name');
            $this->db->where('id', $order_status);
            $getStatusesName = $this->db->get('tb_statuses');
            if($getStatusesName->num_rows() >0){
        		$orderstatus = $getStatusesName->row()->name;
        	}
        }
        $newediapiid = 0;
        if($ediapiid == 0 ){
        	$epidata = ['partner_id'=>$partner_id, 'transaction_action'=>$transaction_action, 'inco_terms'=>$inco_terms, 'triggered_at'=>$triggered_at, 'retrigger'=>$retrigger, 'order_type'=>$order_type, 'order_status'=>$order_status, 'product'=>$edi_product, 'service'=>$edi_service, 'mode_transport'=>$edi_transport, 'pickup'=>$edi_pickup, 'destination'=>$edi_destination, 'commodity'=>$edi_commodity, 'type'=>$ediapi_type,'user_name'=>$edi_username,'password'=>$edi_password, 'edi_url'=>$edi_url,'user_id'=>$uid,'status'=>1,'created_on'=>$curdt,'updated_on'=>$curdt];
        	$newediapiid = $this->common->insertTableData("tbl_partner_ediapi",$epidata);
        	if($newediapiid >0){
        		$data = ['newediapiid'=>$newediapiid,'action'=>$action, 'inco_terms'=>$incoterm,'triggeredat'=>$triggeredat,'retriggerat'=>$retriggerat,'ordertype'=>$ordertype,'order_status'=>$orderstatus,'ediproduct'=> $ediproduct,'ediservice'=> $ediservice,'editransport'=> $editransport,'edi_pickup'=>$edi_pickup,'edi_destination'=>$edi_destination,'edi_commodity'=>$edi_commodity,'ediapitype'=> $ediapitype,'user_name'=>$edi_username,'password'=>$edi_password,'edi_url'=>$edi_url,'file'=>""];
        	}
        }else if($ediapiid > 0){
        	$filename = "";
        	$epidata = [ 'transaction_action'=>$transaction_action, 'inco_terms'=>$inco_terms, 'triggered_at'=>$triggered_at, 'retrigger'=>$retrigger, 'order_type'=>$order_type, 'order_status'=>$order_status, 'product'=>$edi_product, 'service'=>$edi_service, 'mode_transport'=>$edi_transport, 'pickup'=>$edi_pickup, 'destination'=>$edi_destination, 'commodity'=>$edi_commodity, 'type'=>$ediapi_type,'user_name'=>$edi_username,'password'=>$edi_password, 'edi_url'=>$edi_url,'user_id'=>$uid,'status'=>1,'updated_on'=>$curdt];
        	$update = $this->bpartners->updatedata('tbl_partner_ediapi',$ediapiid,$epidata);
        	if($update){
        		$data = ['newediapiid'=>$ediapiid,'action'=>$action, 'inco_terms'=>$incoterm,'triggeredat'=>$triggeredat,'retriggerat'=>$retriggerat,'ordertype'=>$ordertype,'order_status'=>$orderstatus,'ediproduct'=> $ediproduct,'ediservice'=> $ediservice,'editransport'=> $editransport,'edi_pickup'=>$edi_pickup,'edi_destination'=>$edi_destination,'edi_commodity'=>$edi_commodity,'ediapitype'=> $ediapitype,'user_name'=>$edi_username,'password'=>$edi_password,'edi_url'=>$edi_url,'file'=>""];
        	}
        }
        if($newediapiid > 0 || $ediapiid > 0){
        	$filename = "";
        	if (isset($_FILES)) {
        		if(isset($_FILES['file']['name'])){
        			if($newediapiid > 0){
        				$edi_id = $newediapiid;
        			}else{
        				$edi_id = $ediapiid;
        			}
        			$ext = pathinfo($_FILES['file']['name'], PATHINFO_EXTENSION);
        			if ($ext == "xsd") {
        				$fname = date('dmyhis').'_'.$_FILES['file']['name'];
        				if ( move_uploaded_file($_FILES['file']['tmp_name'], "./assets/xsduploads/".$fname) ){
        					$filename = $fname;
        					$epifiledata = [ 'edi_id'=>$edi_id, 'name'=>$filename, 'actual_name'=>$_FILES['file']['name'], 'description'=>$filename, 'user_id'=>$uid, 'status'=>1, 'craetedon'=>$curdt, 'updatedon'=>$curdt];
        					$newfileid = $this->common->insertTableData("tbl_edi_files",$epifiledata);
        					if($newfileid > 0){
        						$epifileiddata = ['file_id'=>$newfileid];
        						$update = $this->bpartners->updatedata('tbl_partner_ediapi',$edi_id,$epifileiddata);
        						$documentlink = base_url()."assets/xsduploads/".$filename;
        						$document = "<a href=".$documentlink." download >File </a>";
        						$data['file'] = $document;
        					}

        				}
        			}
        		}
        	}
        }
        echo json_encode($data);

    }
    /* Delete party EDI-API*/
    public function deletepartyedi(){
    	$data['status'] = 0;
    	$post = $this->input->post(NULL,TRUE);
    	$epiapiid = isset($post['epiapiid']) ? $post['epiapiid'] : 0;
    	if($epiapiid > 0){
    		$curdt = date('Y-m-d H:i:s');
    		$partyedi = ['status'=>0,'updated_on'=>$curdt];
    		$update = $this->bpartners->updatedata('tbl_partner_ediapi',$epiapiid,$partyedi);
    		if($update){
    			$data['status'] = 1;
    		}
    	}
    	echo json_encode($data);
    }
    /* Get Edit values EDI-API*/
    public function geteditpartyedivals(){
    	$data = [];
    	$post = $this->input->post(NULL,TRUE);
    	$epiapiid = isset($post['epiapiid']) ? $post['epiapiid'] : 0;
    	if($epiapiid > 0){
    		$curdt = date('Y-m-d H:i:s');
            $this->db->select('*');
            $this->db->where('id', $epiapiid);
            $getEdiApi = $this->db->get('tbl_partner_ediapi');
            if($getEdiApi->num_rows() > 0){
    			$data = [
                    'transaction_action'=>$getEdiApi->row()->transaction_action,
                    'inco_terms'=>$getEdiApi->row()->inco_terms,
                    'triggered_at'=>$getEdiApi->row()->triggered_at,
                    'retrigger'=>$getEdiApi->row()->retrigger,
                    'order_type'=>$getEdiApi->row()->order_type,
                    'order_status'=>$getEdiApi->row()->order_status,
                    'edi_product'=>$getEdiApi->row()->product,
                    'edi_service'=>$getEdiApi->row()->service,
                    'edi_transport'=>$getEdiApi->row()->mode_transport,
                    'edi_pickup'=>$getEdiApi->row()->pickup,
                    'edi_destination'=>$getEdiApi->row()->destination,
                    'edi_commodity'=>$getEdiApi->row()->commodity,
                    'ediapi_type'=>$getEdiApi->row()->type,
                    'user_name'=>$getEdiApi->row()->user_name,
                    'password'=>$getEdiApi->row()->password,
                    'edi_url'=>$getEdiApi->row()->edi_url,
                    'file'=>""
                ];
    			if($getEdiApi->row()->file_id > 0){
    				$fileid= $getEdiApi->row()->file_id;
                    $where = [
                        'id' => $fileid,
                        'status' => 1
                    ];
                    $this->db->select('*');
                    $this->db->where($where);
                    $getEdiFiles = $this->db->get('tbl_edi_files');
                    if($getEdiFiles->num_rows() > 0){
    					$documentlink = base_url()."assets/xsduploads/".$getEdiFiles->row()->name;
    					$document = "<a href=".$documentlink." download style='padding-right: 4px;'>File</a>";
    					$button = "<button class='btn btn-primary' id='filedelete' onclick='deletealert(".$fileid.")' title='Delete' value=".$fileid."><small><i class='glyphicon glyphicon-trash'></i></small></button>";
    					$data['file'] = $document.$button;

    				}
    			}
    		}
    	}
    	echo json_encode($data);
    }

    /* Delete party EDI-API File*/
    public function deletepartyedifile(){
    	$data['status'] = 0;
    	$post = $this->input->post(NULL,TRUE);
    	$fileid = isset($post['fileid']) ? $post['fileid'] : 0;
    	if($fileid > 0){
    		$curdt = date('Y-m-d H:i:s');
    		$partyedi = ['status'=>0,'updatedon'=>$curdt];
    		$update = $this->bpartners->updatedata('tbl_edi_files',$fileid,$partyedi);
    		if($update){
    			$data['status'] = 1;
    		}
    	}
    	echo json_encode($data);
    }

    public function getcountrieslist(){
    	$cun = isset($_POST["country"]) ? $_POST["country"] : "";
    	if($cun == ""){
    		$cun = $this->session->userdata('usr_tzone')['country_name'];
    	}
    	$data = [];
        $this->db->select('country_name');
        $this->db->like('country_name', $cun, 'both');
        $getCountry = $this->db->get('tbl_country_master');
        if($getCountry->num_rows() > 0){
    		foreach ($getCountry->result() as $country) {
    			$data[] = $country->country_name;
    		}
    	}
    	echo json_encode($data);
    }
    public function getcompanycategory(){
    	$post = $this->input->post(NULL,TRUE);
    	$data = [];
    	$type = isset($post['ctype']) ? $post['ctype'] : "";
    	if($type != ""){
    		$categories = $this->bpartners->getcmpcategory($type);
    		if($categories->num_rows() > 0){
    			foreach ($categories->result() as $cat) {
    				$data[] = ['id'=>$cat->id,'name'=>$cat->name];
    			}
    		}
    	}
    	echo json_encode($data);
    }
    public function customercodes(){
    	$getidncmp = $this->bpartners->getidncmp();
    	if($getidncmp->num_rows() > 0){
    		foreach($getidncmp->result()  as $res){
    			$companycode = $res->company_code;
    			if($companycode != ""){
    				$ccode = mb_substr($companycode, 0, 2);
    				$id = $res->id;
    				$idlength = strlen($id);

    				if($idlength =='1'){
    					$id = "00000".$id;
    				}else if($idlength == '2'){
    					$id = "0000".$id;
    				}else if($idlength == '3'){
    					$id = "000".$id;
    				}else if($idlength == '4'){
    					$id ="00".$id;
    				}else if($idlength == '5'){
    					$id ="0".$id;
    				}else{
    					$id = $id;
    				}
    				$custcode = $ccode.$id;
    				$upd = ['customeridentifier'=>$custcode];
    				$updatecode = $this->bpartners->updatedata('tbl_party_master',$id,$upd);
    			}
    		}
    	}
    }

    public function sendpassword(){
    	$this->load->library("sms");
    	$uid = $this->session->userdata("user_id");
    	$post = $this->input->post(NULL,TRUE);
    	$data['status'] = 0;
    	$data["mobile"] = $post['user_mobile'];
    	$data["name"] = $post['user_name'];
    	$data["password"] = $post['user_password'];
    	$data["type"] = $post['type'];
    	$params=[];
    	$params['user_id']= $uid;
    	if($data["name"] !="" && $data["mobile"] !="" && $data["password"] !=""){
    		if($data["type"] == "Vendor"){
    			$params['mobile']=$data["mobile"];
    			$params['module']="Driver Account Confirmation";
    			$params['message']="Dear ".$data["name"].", Your ".$data["mobile"]." as LoginID and Password is ".$data["password"].", You can login into http://vendor.trac247.in/ for more details";
    			$res = $this->sms->send($params);
    			$data['status'] = 1;
    		}else if($data["type"] == "Customer"){
    			$params['mobile']  = $data["mobile"];
    			$params['module']  = "Customer Password Confirmation";
    			$params['message'] = "Dear " . $data["name"] . ", Your " . $data["mobile"] . " as LoginID and Password is " . $data["password"] . ", You can login into our RT TMS Shipment APP for more details";
    			$res = $this->sms->send($params);
    			$data['status'] = 1;
    		}
    	}
    	echo json_encode($data);
    }
    public function checkpartytype($code){

    	$data['customer'] = $data['vendor'] = [];
    	$chkcust = $this->common->gettblrowdata(["code"=>$code],"name,phone,password","tb_customers",0,0);
    	if(count($chkcust)>0){
    		$pwd=(($chkcust["password"]));
    		$data['customer'] = ['type'=>"Customer",'name'=>$chkcust['name'],'mobile'=>$chkcust['phone'],'password'=>$pwd];
    	}else {
    		$chkvendor = $this->common->gettblrowdata(["code"=>$code],"name,mobile,password","tb_vendors",0,0);
    		if(count($chkvendor)>0){
    			$pwd=(($chkvendor["password"]));
    			$data['customer'] = ['type'=>"Vendor",'name'=>$chkvendor['name'],'mobile'=>$chkvendor['mobile'],'password'=>$pwd];

    		}
    	}
    	echo json_encode($data);
    }
    public function getbusinessname(){
    	$uid = $this->session->userdata('user_id');
    	$company_code = $this->session->userdata('company_code');
    	$name = isset($_POST["name"]) ? $_POST["name"] : "";
    	$data = [];
    	if($company_code == "RUKN"){
          $this->db->select('name');
          $this->db->where('company_code', $company_code);
          $this->db->like('name', $name, 'both');
            $getPartyName = $this->db->get('tbl_party_master');
        }else{
          $this->db->select('name');
          $this->db->where('user_id', $uid);
          $this->db->like('name', $name, 'both');
          $getPartyName = $this->db->get('tbl_party_master');
        }
    	if($getPartyName->num_rows() > 0){
    		foreach ($getPartyName->result() as $get_data_f) {
    			$data[] = $get_data_f->name;
    		}
    	}
    	echo json_encode($data);
    }

    public function getbusinesscuscode(){
    	$uid = $this->session->userdata('user_id');
    	$company_code = $this->session->userdata('company_code');

    	$customer_code = isset($_POST["customer_code"]) ? $this->input->post("customer_code",TRUE) : "";
    	$permission   = checkuserpermissions();
    	if(in_array("businesspartners", $permission)){
            $where = [
                'company_code' => $company_code,
                'status' => 1
            ];
            $this->db->select('customeridentifier');
            $this->db->where($where);
            $this->db->like('customeridentifier', $customer_code, 'both');
            $getPartyCustomerIdentifier = $this->db->get('tbl_party_master');
        }else{
            $where = [
                'user_id' => $uid,
                'status' => 1
            ];
            $this->db->select('customeridentifier');
            $this->db->where($where);
            $this->db->like('customeridentifier', $customer_code, 'both');
            $getPartyCustomerIdentifier = $this->db->get('tbl_party_master');
        }
    	$data = [];
    	if($getPartyCustomerIdentifier->num_rows() > 0){
    		foreach ($getPartyCustomerIdentifier->result() as $get_data_f) {
    			$data[] = $get_data_f->customeridentifier;
    		}
    	}
    	echo json_encode($data);
    }
    public function getbusinesscid(){
    	$uid = $this->session->userdata('user_id');
    	$company_code = $this->session->userdata('company_code');
    	$cid = isset($_POST["cid"]) ? $_POST["cid"] : "";
    	$permission   = checkuserpermissions();
    	if(in_array("businesspartners", $permission)){
            $where = [
                'company_code' => $company_code,
                'status' => 1
            ];
            $this->db->select('code');
            $this->db->where($where);
            $this->db->like('code', $cid, 'both');
            $getPartyCode = $this->db->get('tbl_party_master');
        }else{
            $where = [
                'user_id' => $uid,
                'status' => 1
            ];
            $this->db->select('code');
            $this->db->where($where);
            $this->db->like('code', $cid, 'both');
            $getPartyCode = $this->db->get('tbl_party_master');
        }
    	$data = [];
    	if($getPartyCode->num_rows() > 0){
    		foreach ($getPartyCode->result() as $get_data_f) {
    			$data[] = $get_data_f->code;
    		}
    	}
    	echo json_encode($data);
    }
    public function getbusinesscountry(){
    	$uid = $this->session->userdata('user_id');
    	$country = isset($_POST["country"]) ? $_POST["country"] : "";
    	if($country == ""){
    		$country = $this->session->userdata('usr_tzone')['country_name'];
    	}
        $this->db->select('country');
        $this->db->where('user_id', $uid);
        $this->db->like('country', $country, 'both');
        $this->db->group_by('country');
        $getPartyCountry = $this->db->get('tbl_party_master');
        $data = [];
    	if($getPartyCountry->num_rows() > 0){
    		foreach ($getPartyCountry->result() as $get_data_f) {
    			$data[] = $get_data_f->country;
    		}
    	}
    	echo json_encode($data);
    }
    public function getbusinesslocation(){
    	$uid = $this->session->userdata('user_id');
    	$company_code = $this->session->userdata('company_code');
    	$location_id = isset($_POST["location_id"]) ? $_POST["location_id"] : "";
    	$permission   = checkuserpermissions();
    	if(in_array("businesspartners", $permission)){
            $this->db->select('location_id');
            $this->db->where('company_code', $company_code);
            $this->db->like('location_id', $location_id, 'both');
            $this->db->group_by('location_id');
            $getPartyLocationId = $this->db->get('tbl_party_master');
        }else{
            $this->db->select('location_id');
            $this->db->where('user_id', $uid);
            $this->db->like('location_id', $location_id, 'both');
            $this->db->group_by('location_id');
            $getPartyLocationId = $this->db->get('tbl_party_master');
        }
    	$data = [];
    	if($getPartyLocationId->num_rows() > 0){
    		foreach ($getPartyLocationId->result() as $get_data_f) {
    			$data[] = $get_data_f->location_id;
    		}
    	}
    	echo json_encode($data);
    }
    public function getbusinesszipcode(){
    	$uid = $this->session->userdata('user_id');
    	$company_code = $this->session->userdata('company_code');
    	$zipcode =  isset($_POST["zipcode"]) ? $_POST["zipcode"] : "";
    	$permission   = checkuserpermissions();
    	if(in_array("businesspartners", $permission)){
            $this->db->select('pincode');
            $this->db->where('company_code', $company_code);
            $this->db->like('pincode', $zipcode, 'both');
            $this->db->group_by('pincode');
            $getPartyPincode = $this->db->get('tbl_party_master');
        }else{
            $this->db->select('pincode');
            $this->db->where('user_id', $uid);
            $this->db->like('pincode', $zipcode, 'both');
            $this->db->group_by('pincode');
            $getPartyPincode = $this->db->get('tbl_party_master');
        }

    	$data = [];
    	if($getPartyPincode->num_rows() > 0){
    		foreach ($getPartyPincode->result() as $get_data_f) {
    			$data[] = $get_data_f->pincode;
    		}
    	}
    	echo json_encode($data);
    }
	 public function getbusinessdebitor_code(){
    	$uid = $this->session->userdata('user_id');
    	$company_code = $this->session->userdata('company_code');
    	$debitor_code =  isset($_POST["debitor_code"]) ? $_POST["debitor_code"] : "";
    	$permission   = checkuserpermissions();
		if(in_array("businesspartners", $permission)){
            $this->db->select('acon_debitor_code');
            $this->db->where('company_code', $company_code);
            $this->db->like('acon_debitor_code', $debitor_code, 'both');
            $getPartyAconDebitorCode = $this->db->get('tbl_party_master');
        }else{
            $this->db->select('acon_debitor_code');
            $this->db->where('user_id', $uid);
            $this->db->like('acon_debitor_code', $debitor_code, 'both');
            $getPartyAconDebitorCode = $this->db->get('tbl_party_master');
        }
    	$data = [];
    	if($getPartyAconDebitorCode->num_rows() > 0){
    		foreach ($getPartyAconDebitorCode->result() as $get_data_f) {
    			$data[] = $get_data_f->acon_debitor_code;
    		}
    	}
    	echo json_encode($data);
    }

    public function checkphone(){
    	$post = $this->input->post(NULL,TRUE);
    	$phone = isset($post['mob']) ? $post['mob'] : "";
    	$phone = trim($phone);
    	$id = isset($post['id']) ? $post['id'] : "0";
    	$where = [
    		'phone' => $phone,
    		'status' =>'1'
		];
    	if ($id > 0) {
    		$where = [
    			'id !=' =>$id,
    			'phone' => $phone,
    			'status' =>'1'
			];
    	}
    	$company = $this->common->gettblrowdata($where, 'phone', 'tb_customers', 0, 0);
    	if (empty($company)) {
    		echo "2";
    	} else {
    		echo "1";
    	}
    }
    public function checkphonecarr(){
    	$post = $this->input->post(NULL,TRUE);
        $name = $post['name'] ?? "";
    	$mobile = $post['mob'] ?? "";
    	$mobile = trim($mobile);
    	$id = $post['id'] ?? 0;
    	$where = [
            'name != '=>$name,
    		'mobile' => $mobile,
    		'status' =>'1'
    	];
    	if ($id >0) {
    		$where['id !='] = $id;
    	}
    	$company = $this->common->gettblrowdata($where, 'mobile', 'tb_vendors', 0, 0);
    	if (empty($company)) {
    		echo "2";
    	} else {
    		echo "1";
    	}
    }
	public function checkcid(){
    	$post = $this->input->post(NULL,TRUE);
    	$cid = isset($post['cid']) ? $post['cid'] : "";
    	$cid1 = trim($cid);
    	$company_code = isset($post['company_code']) ? $post['company_code'] : "";
    	$branch_code = isset($post['branch_code']) ? $post['branch_code'] : "";
    	$id = isset($post['id']) ? $post['id'] : "0";
    	$where = [
    		'code' => $cid1,
    		'company_code' => $company_code,
    		'branch_code' => $branch_code,
    		'status' =>'1'
		];
    	if ($id >0) {
    		$where = [
    			'id != '=>$id,
	    		'code' => $cid1,
	    		'company_code' => $company_code,
	    		'branch_code' => $branch_code,
	    		'status' =>'1'
			];
    	}
    	$company = $this->common->gettblrowdata($where, 'code', 'tbl_party_master', 0, 0);
    	if (empty($company)) {
    		echo "2";
    	} else {
    		echo "1";
    	}
    }

	/* customer profile */
	public function getcustomerpflist() {
        $result = [];
        $select = 'id,cust_profile_id,name,company_code,branch_code';
		$company_code=$this->session->userdata('company_code');
		if($company_code == "RUKN"){
			 $where = ['status'=>1,'company_code'=>$company_code];
		}else{
			 $where = ['status'=>1,'company_code'=>$company_code,'branch_code'=>$this->session->userdata('branch_code')];
		}

        if($this->input->post('term')){
            $like['cust_profile_id'] = $this->input->post('term');
        } else {
            $like = [];
        }
        $chkqry = $this->Mastersmodel->getsearchdata($like,$where,$select,'tb_customer_profile');
        if (!empty($chkqry)) {
            foreach ($chkqry as $res) {
                $check    = "<input type='radio' name='listcustomerpf' id='listcustomerpf_" . $res['id'] . "' class='listcustomerpf' onchange='selectcustomerpf(" . $res['id'] . ")' value='" . $res['cust_profile_id'] . "'>";
                $result[] = ['check' => $check,'cust_profile_id'=> $res['cust_profile_id'],'name'=>$res['name'],'company_code' => $res['company_code'],'branch_code'=>$res['branch_code']];
            }
        }
        echo json_encode($result);
    }
	/* Vendor profile */

    public function getvendorpflist() {
        $result = [];
        $select = 'id,vend_profile_id,name,company_code,branch_code';
		$company_code=$this->session->userdata('company_code');
		if($company_code == "RUKN"){
			 $where = ['status'=>1,'company_code'=>$company_code];
		}else{
			 $where = ['status'=>1,'company_code'=>$company_code,'branch_code'=>$this->session->userdata('branch_code')];
		}

        if($this->input->post('term')){
            $like['vend_profile_id'] = $this->input->post('term');
        } else {
            $like = [];
        }
        $chkqry = $this->Mastersmodel->getsearchdata($like,$where,$select,'tb_vendor_profile');
        if (!empty($chkqry)) {
            foreach ($chkqry as $res) {
                $check    = "<input type='radio' name='listvendorpf' id='listvendorpf_" . $res['id'] . "' class='listvendorpf' onchange='selectvendorpf(" . $res['id'] . ")' value='" . $res['vend_profile_id'] . "'>";
                $result[] = ['check' => $check,'vend_profile_id'=> $res['vend_profile_id'],'name'=>$res['name'],'company_code' => $res['company_code'],'branch_code'=>$res['branch_code']];
            }
        }
        echo json_encode($result);
    }

	/**
	@author: Gangachari
	@Description:
	**/
	public function getPartTypesbyBranch()
	{
		$data = "<option value=''>Select</option>";
		$company_code = $this->session->userdata('company_code');
		$branchCode = isset($_POST['branchCode']) ? $_POST['branchCode'] : "";

		if($branchCode != "") {
            $where = [
                'company_code' => $company_code,
                'branch_code' => $branchCode,
                'status' => 1
            ];
            $this->db->select('id,name');
            $this->db->where($where);
            $this->db->group_by('name');
            $getPartyTypes = $this->db->get('tbl_party_types');
            if($getPartyTypes->num_rows() > 0) {
				foreach ($getPartyTypes->result() as $party) {
					$data .= "<option value='".$party->id."'>".$party->name."</option>";
				}
			}
		} else {
			$data = "No data Found";
		}
		echo $data;
    }

    public function uploadcustomerexcel(): void
    {
        $loginCompanyCode = $this->session->userdata('company_code');
        $createdOn = date("Y-m-d H:i:s");
        $userId = $this->session->userdata('user_id');
        $excelResponse = [];
        $subCategoryId = 0;
        try {
            if ($_FILES['import_file']['size'] > 0) {
                $inputExcel = $_FILES['import_file']['tmp_name'];
                $objPHPExcel = PHPExcel_IOFactory::load($inputExcel);
                $sheetData = $objPHPExcel->getActiveSheet()->toArray(null, true, true, true);
                for ($i = 2; $i <= count($sheetData); $i++) {
                    $partyName = $sheetData[$i]['A'] ?? "";
                    $category = $sheetData[$i]['B'] ?? "";
                    $subCategory = $sheetData[$i]['C'] ?? "";
                    $codeId = $sheetData[$i]['D'] ?? "";
                    $aconDebitorCode = $sheetData[$i]['E'] ?? "";
                    $companyCode = $sheetData[$i]['F'] ?? "";
                    $knLoginAccount = $sheetData[$i]['G'] ?? "";
                    $password = $sheetData[$i]['H'] ?? "";
                    $branchCode = $sheetData[$i]['J'] ?? "";
                    $departmentCode = $sheetData[$i]['L'] ?? "";
                    $name = $sheetData[$i]['M'] ?? "";
                    $email = $sheetData[$i]['N'] ?? "";
                    $phone = $sheetData[$i]['O'] ?? "";
                    $street = $sheetData[$i]['P'] ?? "";
                    $country = $sheetData[$i]['Q'] ?? "";
                    $zipcode = $sheetData[$i]['R'] ?? "";
                    $street2 = $sheetData[$i]['S'] ?? "";
                    $street3 = $sheetData[$i]['T'] ?? "";
                    $houseNum = $sheetData[$i]['U'] ?? "";
                    $building = $sheetData[$i]['V'] ?? "";
                    $divisionName = $sheetData[$i]['W'] ?? "";
                    $subDistrict = $sheetData[$i]['X'] ?? "";
                    $city = $sheetData[$i]['Y'] ?? "";
                    $province = $sheetData[$i]['Z'] ?? "";
                    $extension = $sheetData[$i]['AA'] ?? "";
                    $latitude = $sheetData[$i]['AB'] ?? "";
                    $longitude = $sheetData[$i]['AC'] ?? "";
                    $mainHomePage = $sheetData[$i]['AD'] ?? "";
                    $timeZoneCity = $sheetData[$i]['AE'] ?? "";
                    $timeZoneCode = $sheetData[$i]['AF'] ?? "";
                    $timeZoneName = $sheetData[$i]['AG'] ?? "";
                    $gstRegistration = $sheetData[$i]['AH'] ?? "";
                    $taxPayerId = $sheetData[$i]['AI'] ?? "";
                    $contractNumber = $sheetData[$i]['AJ'] ?? "";
                    $contractDate = $sheetData[$i]['AK'] ?? "";
                    $finalContractDate = "";
                    if (strlen($contractDate) == '8') {
                        $givenDate = str_split($contractDate, 4);
                        if (!empty($givenDate)) {
                            $contractYear = $givenDate[0] ?? "";
                            $finalDate = $givenDate[1] ?? "";
                            if (strlen($finalDate) == '4') {
                                $splitDates = str_split($finalDate, 2);
                                $contractMonth = $splitDates[0] ?? "";
                                $contractDate = $splitDates[1] ?? "";
                                if (checkdate($contractMonth, $contractDate, $contractYear)) {
                                    $finalContractDate = $contractYear . "-" . $contractMonth . "-" . $contractDate;
                                }
                            }
                        }
                    }
                    if ("" == $password) {
                        $password = $codeId;
                    }
                    if (strtolower($category) == "kn office") {
                        $category = "KN Office";
                    }
                    if (strtolower($category) == "external partner") {
                        $category = "External";
                    }
                    $md5Password = password_hash($password,PASSWORD_DEFAULT);
                    if ($loginCompanyCode == $companyCode) {
                        $partyTypeId = $this->bpartners->getPartyTypeByName($partyName, $companyCode, $branchCode);
                        if (!in_array(
                                "",
                                [$name, $codeId, $aconDebitorCode, $password, $partyName, $knLoginAccount, $partyTypeId]
                            ) && ("nodata" != $partyTypeId)) {
                            $getCustomerData = $this->common->gettblrowdata(
                                ['code' => $codeId, 'company_code' => $companyCode, 'status' => '1'],
                                "id",
                                "tbl_party_master",
                                0,
                                0
                            );

                            if (!empty($getCustomerData)) {
                                // Update to ensure vendor is linked with party_master
                                $this->common->updatetbledata('tb_vendors', [
                                    'partyid' => $getCustomerData['id']
                                ], [
                                    'name' => $name,
                                    'code' => $codeId,
                                    'company_code' => $companyCode,
                                ]);
                                $excelResponse[] = [
                                    'name' => $name,
                                    'code' => $codeId,
                                    'company_code' => $companyCode,
                                    'status' => 'Already Exists',
                                ];
                            } else {
                                if (!in_array("", [$category, $subCategory])) {
                                    $getSubCategoryId = $this->common->gettblrowdata(["name" => $subCategory, 'type' => $category, 'status' => '1'], "id", "tb_company_category", 0, 0);
                                    if (!empty($getSubCategoryId)) {
                                        $subCategoryId = $getSubCategoryId['id'];
                                    } else {
                                        $excelResponse[] = [
                                            'name' => $name,
                                            'code' => $codeId,
                                            'company_code' => $companyCode,
                                            'status' => 'Sub Category not matcheded with selected Category',
                                        ];
                                    }
                                }
                                $partyTypes = explode(",", $partyTypeId);
                                $partnerData = [
                                    'party_type_id' => $partyTypes[0],
                                    'name' => $name,
                                    'email' => $email,
                                    'mobile' => $phone,
                                    'user_id' => $userId,
                                    'code' => $codeId,
                                    'company_code' => $companyCode,
                                    'branch_code' => $branchCode,
                                    'department_code' => $departmentCode,
                                    'parent_id' => 0,
                                    'country' => $country,
                                    'state' => $province,
                                    'street' => $street,
                                    'street_2' => $street2,
                                    'street_3' => $street3,
                                    'building' => $building,
                                    'division_name' => $divisionName,
                                    'sub_district' => $subDistrict,
                                    'extension' => $extension,
                                    'latitude' => $latitude,
                                    'longitude' => $longitude,
                                    'homepage' => $mainHomePage,
                                    'time_zone_city' => $timeZoneCity,
                                    'time_zone_name' => $timeZoneName,
                                    'vat_reg_no' => $gstRegistration,
                                    'tax_payer_no' => $taxPayerId,
                                    'contract_no' => $contractNumber,
                                    'contract_date' => $finalContractDate,
                                    'time_zone_code' => $timeZoneCode,
                                    'pincode' => $zipcode,
                                    'house_number' => $houseNum,
                                    'party_types' => $partyTypeId,
                                    'category_type' => $category,
                                    'category_id' => $subCategoryId,
                                    'acon_debitor_code' => $aconDebitorCode,
                                    'kn_login_account' => $knLoginAccount,
                                    'password' => $md5Password,
                                    'status' => 1,
                                    'location_id' => $city,
                                    'created_on' => $createdOn,
                                    'updated_on' => $createdOn,
                                ];
                                $partnerId = $this->common->insertTableData("tbl_party_master", $partnerData);
                                $customerIdentifier = str_pad($partnerId, 6, '0', STR_PAD_LEFT);
                                if (strlen($customerIdentifier) > 0) {
                                    $countryCode = mb_substr($companyCode, 0, 2);
                                    $finalCustomerIdentifier = $countryCode . $customerIdentifier;
                                    $this->common->updatetbledata(
                                        "tbl_party_master",
                                        ['customeridentifier' => $finalCustomerIdentifier],
                                        ['id' => $partnerId]
                                    );
                                }
                                if ($partyName == "Carrier") {
                                    $vendorPartyId = $partyTypeId;
                                    $carrierData = [
                                        'name' => $name,
                                        'partyid' => $partnerId, // Link to tb_party_master
                                        'mobile' => $phone,
                                        'location' => $city,
                                        'address' => $street,
                                        'pincode' => $zipcode,
                                        'country' => $country,
                                        'code' => $codeId,
                                        'email' => $email,
                                        'password' => $md5Password,
                                        'user_id' => $userId,
                                        'company_code' => $companyCode,
                                        'branch_code' => $branchCode,
                                        'status' => 1,
                                        'updated_on' => $createdOn,
                                        'updated_on' => $createdOn,
                                    ];
                                    $vendorId = $this->common->insertTableData("tb_vendors", $carrierData);
                                    $rules = [
                                        'vendor_id' => $vendorId,
                                        'company_code' => $companyCode,
                                        'branch_code' => $branchCode,
                                        'user_id' => $userId,
                                        'createdon' => $createdOn,
                                        'rule_status' => 'Direct',
                                        'status' => 1,
                                        'autoaccept' => 0,
                                    ];
                                    $this->common->insertTableData("tb_vendor_rules", $rules);
                                } elseif ($partyName == "Customer") {
                                    $customerData = [
                                        'partner_id' => $partnerId,
                                        'name' => $name,
                                        'phone' => $phone,
                                        'street' => $street,
                                        'location' => $city,
                                        'pincode' => $zipcode,
                                        'country' => $country,
                                        'email_id' => $email,
                                        'state' => $province,
                                        'code' => $codeId,
                                        'password' => $md5Password,
                                        'user_id' => $userId,
                                        'company_code' => $companyCode,
                                        'branch_code' => $branchCode,
                                        'createdon' => $createdOn,
                                        'updatedon' => $createdOn,
                                    ];
                                    $customerId = $this->common->insertTableData("tb_customers", $customerData);
                                }
                                $excelResponse[] = [
                                    'name' => $name,
                                    'code' => $codeId,
                                    'company_code' => $companyCode,
                                    'status' => 'Success',
                                ];
                            }
                        } else {
                            $excelResponse[] = [
                                'name' => $name,
                                'code' => $codeId,
                                'company_code' => $companyCode,
                                'status' => 'Please Check Party Type Column',
                            ];
                        }
                    } else {
                        $excelResponse[] = [
                            'name' => $name,
                            'code' => $codeId,
                            'company_code' => $companyCode,
                            'status' => 'Please Check Company Code',
                        ];
                    }
                }
            }

            if (!empty($excelResponse)) {
                @file_put_contents(
                    $_SERVER['DOCUMENT_ROOT'] . "/svkonekt_test/assets/businesspartners/customersexceldata.txt",
                    json_encode($excelResponse)
                );
            }
            redirect('businesspartners/index/01');
        } catch (Exception $e) {
            log_error($e->getMessage());
        }
    }
	public function bulkdeletepartners(): void
    {
        if($_SERVER['REQUEST_METHOD'] === 'POST') {
            $deleterecorids = implode(",",$this->input->post('deleteids'));
            $this->db->where_in('id', $deleterecorids);
            $resultOfDelete = $this->db->delete('tbl_party_master');
			echo $resultOfDelete ? "success" : "failed";
        }
    }

    public function fetchBusinessPartnerByCIP():void
    {
    	$this->load->library("cip");
    	$CIP_number 	= $this->input->post('cip_number',true);
    	$this->cip->request_url = CIP_REQUEST_URL.$CIP_number;
    	$response 		= $this->cip->fetch_details_by_cip();
    	$status 		= $response['status'];
    	$message 		= $response['message'];
    	$data 			= $response['data'];
    	if(!empty($data) && !empty($data['physicalAddressEnvelope']['internationalAddress']) && $data['status']==='ACTIVE')
    	{
    		$data['email'] = 'info@svkonekt.com';
    		$countryIso2Code = $data['physicalAddressEnvelope']['internationalAddress']['countryIso2Code'];
    		if(!empty($countryIso2Code))
    		$country_name = (string)$this->db->select(['country_name'])->where(['LOWER(country_code)'=>strtolower($countryIso2Code)])->get('tbl_country_master')->row()->country_name;
    		$data['physicalAddressEnvelope']['internationalAddress']['country_name'] = $country_name;
    	}
    	$finance_data 	= [];
    	if($status===1)
    	{
    		$this->cip->request_url  = CIP_REQUEST_URL."{$CIP_number}/financial-accounts";
    		$finance_response   = $this->cip->fetch_details_by_cip();
			$finance_data 		= $finance_response['data'];
    	}
        echo json_encode(compact('status','message','data', 'finance_data'));
    }

    public function searchCIP(): void
    {
    	$this->load->library("cip");
    	$CIP_number 	= $this->input->post('cip_number',true);
    	$url = CIP_SEARCH_URL;
    	$params = ['cid' => $CIP_number,'maxResults'=>10];
		$url .= '?' . http_build_query($params);
		$this->cip->request_url = $url;
    	$response 		= $this->cip->fetch_details_by_cip();
    	$status 		= $response['status'];
    	$message 		= $response['message'];
    	$data 			= $response['data'] ? $response['data']['items'] : [];
        echo json_encode(compact('status','message','data'));
    }
}
