<?php if (!defined('BASEPATH')) {
    exit('No direct script access allowed');
}

class Cab extends CI_Controller
{
    public function __Construct()
    {
        parent::__Construct();
    }
    public function index()
    {
         redirect("Forbiddenaccess");
         $this->load->library("stsintegrate");
         exit;
    }

    public function track($data)
    {
        $d = decryptIt($data);
        $driver = $d[0];
        $trip = $d[1];
        $imei = '';

        $res = $this->db->select("id,shift_id,vehicle_id")->get_where("tb_trips", array("id" => $trip, "status" => '1'), 1, 0);

        if ($res->num_rows() > 0) {
            $shft_id = $res->row()->shift_id;
            $vehicle_id = $res->row()->vehicle_id;

            $shft_veh_id = $this->db->where(["shft_id" => $shft_id, "vehicle_id" => $vehicle_id, "status" => "1"])->get(
                "tb_shft_veh"
            )->row()->id;

            $this->db->select(
                'sve.priority, e.pickup, e.plat, e.plng, e.drop, e.dlat, e.dlng, e.name, e.phone,
                               e.address, e.shipment_weight, e.shipment_volume, e.ship_type, e.startdate, e.enddate'
            );
            $this->db->from('tb_shft_veh_emp sve');
            $this->db->join("tb_employee e", "sve.emp_id=e.id", "INNER");
            $this->db->where('sve.shft_veh_id', $shft_veh_id);
            $this->db->where('sve.status', '1');
            $this->db->order_by('sve.priority', 'ASC');
            $getShftEmployee = $this->db->get();

            $dt["stops"] = [];

            if ($getShftEmployee->num_rows() > 0) {
                foreach ($getShftEmployee->result_array() as $row) {
                    if ($row['ship_type'] == "P") {
                        $row["name"]=$row['pickup'];
                        $loc=$this->getLatLng($row['pickup']);
                    }else{
                        $loc=$this->getLatLng($row['drop']);
                        $row["name"]=$row['drop'];
                    }
                    $row["lat"]=$loc[0];
                    $row["lng"]=$loc[1];
                    $dt["stops"][]=$row;
                }
            }

            $qu = $this->db->select("name,contact_num")->get_where("tb_truck_drivers",array("id"=> $driver),1,0)->row();

            $dt["name"]   = $qu->name;
            $dt["num"]    = $qu->contact_num;
            $dt["record"] = [];
            $dt['pos'] = ['name'=>'current','latitude'=>'','longitude'=>''];

            $pos = $this->db->query("select imei, latitude,longitude from tb_trucks_data where id='" . $vehicle_id . "' limit 1");

            if($pos->num_rows() > 0){
                $dt["record"] = $pos->row();
                $imei = $pos->row()->imei ?? '';

                $dt['pos'] = array('ship_type'=>'','name'=>'current','latitude'=>$pos->row()->latitude,'longitude'=>$pos->row()->longitude);
            }

            $dt["driver"] = $driver;
            $dt["trip"]   = $trip;
            $dt["data"]   = $data;
            $dt["imei"]   = $imei;
            $dt["vehicle"] = (Object) array("register_number"=>'');

            if ($this->session->userdata('company_code') == "CNKN") {
                $this->load->view("map/shift_china", $dt);
            } else  {
                $this->load->view("map/shift", $dt);
           }
        } else {
            show_404();exit;
        }
    }

    public function getLatLng($address){
        $response = getlatlngsbyplace($address);
        return [
            $response[0] ?? 0,
            $response[1] ?? 0
        ];
    }

    public function getlatestpos()
    {
        $data   = isset($_POST["data"]) ? $_POST["data"] : '';
        $d      = decryptIt($data);
        $driver = $d[0];
        $trip   = $d[1];
        $res = $this->db->select("id,vehicle_id")->get_where("tb_trips", array("id" => $trip, "status" => 1), 1, 0);
        if ($res->num_rows() > 0) {
            $sql = $this->db->query("select latitude,receivedon,longitude from tb_trucks_data where id='" . $res->row()->vehicle_id . "' limit 1");
            if ($sql->num_rows() > 0) {
                $dt["lat"]    = $sql->row()->latitude;
                $dt["lng"]    = $sql->row()->longitude;
                $dt["time"]   = date("d M,Y H:i a", strtotime($sql->row()->receivedon));
                $dt['status'] = 1;
            }
            $this->db->select("e.name,e.phone,s.latitude,s.longitude,s.register_number,s.alert_reason,s.createdon");
            $this->db->from("tbl_sms_logs s");
            $this->db->join("tb_employee e", "s.emp_id=e.id", "INNER");
            $this->db->where("s.trip_id", $trip);
            $this->db->where("s.module", 'SOS Alert');
            $dt['sos'] = $this->db->get()->result_array();
        } else {
            $dt['status'] = 0;
        }
        echo json_encode($dt);
    }
}
