<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Cabcron extends CI_Controller
{


    public function __construct()
    {
        parent::__construct();
        $this->load->model('cabmodel');
        $this->load->library('email');
    }

    public function index()
    {
        $data = array();
        $flag = 0;
        $uid = 18145;
        $sts = 0;
        $result = "<table width='100%'>";
        $result .= "<tr>";
        $result .= "<td colspan='8' style='border-right:none;border-left:none;border-bottom:none;border-top:none'> Dear Admin,";
        $result .= "</td></tr>";
        $result .= "<tr style='background-color: #14A3E1;'>";
        $excel_data = array();
        $excel = array(
            "DATE",
            "Cab Details",
            "Shift",
            "Cab Arrival Time",
            "Employees Scheduled",
            "Employees Boarded",
            "Occupancy",
            "Remarks"
        );
        array_push($excel_data, $excel);
        foreach ($excel as $e) {
            $result .= "<td>$e</td>";
        }
        $result .= "</tr>";
        $data1["page_title"] = "Trips Report";
        $curtime = date("Y-m-d H:i:00");
        $cdate = date('Y-m-d');
        $this->db->select(
            's.etime,s.trip_type,t.id as trip_id,t.shift_id,s.empshift_start,s.empshift_end,t.etime as endtime,t.vehicle_id,t.driver_id'
        );
        $this->db->from('tb_shifts s');
        $this->db->join('tb_trips t', 's.id=t.shift_id', 'INNER');
        $this->db->join('tb_trip_summary ts', 't.id=ts.trip_id', 'INNER');
        $this->db->where('t.status', $sts);
        $this->db->where('t.trip_type!=2');
        $this->db->where('s.trip_type!=2');
        $this->db->where('ts.user_id', $uid);
        $this->db->where('DATE(t.created_on)', $cdate);
        $this->db->order_by('s.id', 'ASC');
        $getwhr = $this->db->get();
        if ($getwhr->num_rows() > 0) {
            $i = 1;
            foreach ($getwhr->result() as $rw) {
                $shifttime = date('Y-m-d H:i:00', strtotime('+30 minutes', strtotime($rw->etime)));
                $diff = abs(strtotime($shifttime) - strtotime($curtime));
                $years = floor($diff / (365 * 60 * 60 * 24));
                $months = floor(($diff - $years * 365 * 60 * 60 * 24) / (30 * 60 * 60 * 24));
                $days = floor(($diff - $years * 365 * 60 * 60 * 24 - $months * 30 * 60 * 60 * 24) / (60 * 60 * 24));
                $hours = floor(
                    ($diff - $years * 365 * 60 * 60 * 24 - $months * 30 * 60 * 60 * 24 - $days * 60 * 60 * 24) / (60 * 60)
                );
                $shiftid = $rw->shift_id;
                $tripid = $rw->trip_id;
                $routeid = 0;
                $this->db->select('v.route_id');
                $this->db->from('tb_trips t');
                $this->db->join("tb_shifts s", "s.id = t.shift_id", "INNER");
                $this->db->join('tb_shft_veh v', "v.shft_id = s.id", "INNER");
                $this->db->where('s.id', $shiftid);
                $this->db->where('t.id', $tripid);
                $this->db->where('t.status', '0');
                $this->db->order_by('v.id', 'DESC');
                $this->db->limit(1);
                $getRouteId = $this->db->get();
                if ($getRouteId->num_rows() > 0) {
                    $routeid = $getRouteId->row()->route_id;
                }
                $driverveh = 0;
                $ddtail1 = $this->db->select('register_number')->get_where(
                    'tb_trucks_data',
                    array('id' => $rw->vehicle_id),
                    1,
                    0
                );
                if ($ddtail1->num_rows() > 0) {
                    $driverveh = $ddtail1->row()->register_number;
                }
                $driverno = 0;
                $ddetail = $this->db->select('contact_num')->get_where(
                    'tb_truck_drivers',
                    array('id' => $rw->driver_id),
                    1,
                    0
                );
                if ($ddetail->num_rows() > 0) {
                    $driverno = $ddetail->row()->contact_num;
                }
                $dt = array(
                    'routeid' => $routeid,
                    'shiftstart' => $rw->empshift_start,
                    'shiftend' => $rw->empshift_end,
                    'endtime' => $rw->endtime,
                    'trip_type' => $rw->trip_type,
                    'driverveh' => $driverveh,
                    'driverno' => $driverno
                );
                $chk = $this->db->select('*')->get_where(
                    'tb_trips_mails',
                    array('trip_id' => $tripid, 'shift_id' => $shiftid),
                    1,
                    0
                );
                if ($chk->num_rows() > 0) {
                    $sts = $chk->row()->status;
                    if ($sts == 0) {
                        $this->db->select(
                            'e.name,te.stime as in_time,te.status as emp_status,te.driver_late,te.emp_late,te.absent_reason,te.check_in'
                        );
                        $this->db->from('tb_employee e');
                        $this->db->join('tb_trip_employee te', 'te.employee_id=e.id', 'INNER');
                        $this->db->where('te.trip_id', $tripid);
                        $getEmployeeData = $this->db->get();
                        $data['empdata'] = $getEmployeeData;
                        $data['tripdata'] = $chk->row();
                        $rid = $chk->row()->id;
                        $resultset = "";
                        $res = $this->sendmailfun($data, $resultset, $i, $dt);
                        array_push($excel_data, $res);
                        if (count($res) > 0) {
                            $flag = 1;
                            $result .= "<tr>";
                            foreach ($res as $e) {
                                $result .= "<td>$e</td>";
                            }
                            $result .= "</tr>";
                        }
                        $this->db->set(array('status' => 1))->where(array('id' => $rid))->update('tb_trips_mails');
                        $i++;
                    }
                }
            }
            $result .= "<tr><td colspan='8' style='border-right:none;border-left:none;border-bottom:none;border-top:none'></td>";
            $result .= "</tr>";
            $result .= "<tr><td colspan='8' style='border-right:none;border-left:none;border-bottom:none;border-top:none'>Thank you,</td>";
            $result .= "</tr>";
            $result .= "<tr><td colspan='8' style='border-right:none;border-left:none;border-top:none'>Support Team, <br /><a href='" . base_url(
                ) . "'>Svkonekt.in</a></td>";
            $result .= "</tr>";
            $result .= "</table>";
            $data1['alldata'] = $result;
            if ($flag == 1) {
                $attachment = $this->create_csv($excel_data, "Cabs_Trips_Status");
                $this->load->library('email');
                $getusermail = $this->db->select("name,emailid,alternate_mails")->get_where(
                    "tb_users",
                    array(
                        "id" => $uid,
                        "emailid !=" => ""
                    ),
                    1,
                    0
                );
                $ccemail = "";
                if ($getusermail->num_rows() > 0) {
                    $receivemail = $getusermail->row()->emailid;
                    $receivename = $getusermail->row()->name;
                    $ccemail = $getusermail->row()->alternate_mails;
                }
                $this->email->to($receivemail, $receivename);
                $this->email->attach($attachment);
                if ($uid == '18145') {
                    $this->email->cc('narendra.n@inspiredgeit.com,' . $ccemail);
                } else {
                    $this->email->cc($ccemail);
                }

                $this->email->from('svkonekt@kuehne-nagel.com', 'RT Cabs');
                $this->email->subject('Cabs trip status for shift on :' . date('Y-m-d'));
                $this->email->set_mailtype('html');
                $body = $this->load->view('mail_forms/finalreport', $data1, true);
                $this->email->message($body);
                $this->email->send();
            }
        }
    }

    public function create_csv($records, $name)
    {
        if (!$records) {
            $records = [];
        }

        $filepath = APPPATH . '/reports/' . $name . date("YmdHis") . '.csv';

        $fd = fopen($filepath, 'w');
        if ($fd === false) {
            die('Failed to open temporary file');
        }

        foreach ($records as $record) {
            fputcsv($fd, $record);
        }

        rewind($fd);
        fclose($fd);
        return $filepath;
    }

    public function sendmailfun($data, $result, $i, $dt)
    {
        $excel = array();
        if ($data['tripdata']->attcnt != 0) {
            if ($dt["trip_type"] != 2) {
                $date = "";
                if ($i == 1) {
                    $date = date('m/d/Y');
                }
                $excel[] = $date;
                /*$result .= "<td> IE ".$dt['routeid']."</td>";*/
                $excel[] = $dt['driverveh'] . " (" . $dt['driverno'] . ")";
                $excel[] = $dt['shiftstart'];
                $excel[] = $dt['endtime'];
                $occupance = @round(($data['tripdata']->attcnt / $data['tripdata']->totcnt) * 100, 2);
                $excel[] = $data['tripdata']->totcnt;
                $excel[] = $data['tripdata']->attcnt;
                $excel[] = $occupance;
                $empd = "";
                if ($data['empdata']->num_rows() > 0) {
                    $empd = "";
                    foreach ($data['empdata']->result() as $res) {
                        if ($res->emp_status == 0 && strlen($res->check_in) == 0) {
                            $empd .= $res->name . " - " . $res->absent_reason . ", ";
                        }
                    }
                }
                $excel[] = $empd;
                $shftend = "";
                if ($dt['trip_type'] == 0) {
                    $shftend = $dt['shiftend'];
                }
            }
        }
        return $excel;
    }

    public function enddaywise()
    {
        $data = array();
        $flag = 0;
        $uid = 18145;
        $sts = 0;
        $result = "<table width='100%'>";
        $result .= "<tr>";
        $result .= "<td colspan='8' style='border-right:none;border-left:none;border-bottom:none;border-top:none'> Dear Admin,";
        $result .= "</td></tr>";
        $result .= "<tr style='background-color: #14A3E1;'>";
        $excel_data = array();
        $excel = array(
            "DATE",
            "Cab Details",
            "Shift",
            "Cab Arrival Time",
            "Employees Scheduled",
            "Employees Boarded",
            "Occupancy",
            "Remarks"
        );
        array_push($excel_data, $excel);
        foreach ($excel as $e) {
            $result .= "<td>$e</td>";
        }
        $result .= "</tr>";
        $data1["page_title"] = "Trips Report";
        $curtime = date("Y-m-d H:i:00");
        $cdate = date('Y-m-d');
        $this->db->select(
            's.etime,s.trip_type,t.id as trip_id,t.shift_id,s.empshift_start,s.empshift_end,t.etime as endtime,t.vehicle_id,t.driver_id'
        );
        $this->db->from('tb_shifts s');
        $this->db->join('tb_trips t', 's.id=t.shift_id', 'INNER');
        $this->db->join('tb_trip_summary ts', 't.id=ts.trip_id', 'INNER');
        $this->db->where('t.status', $sts);
        $this->db->where('t.trip_type!=2');
        $this->db->where('s.trip_type!=2');
        $this->db->where('ts.user_id', $uid);
        $this->db->where('DATE(t.created_on)', $cdate);
        $this->db->order_by('s.id', 'ASC');
        $getwhr = $this->db->get();
        if ($getwhr->num_rows() > 0) {
            $i = 1;
            foreach ($getwhr->result() as $rw) {
                $shifttime = date('Y-m-d H:i:00', strtotime('+30 minutes', strtotime($rw->etime)));
                $diff = abs(strtotime($shifttime) - strtotime($curtime));
                $years = floor($diff / (365 * 60 * 60 * 24));
                $months = floor(($diff - $years * 365 * 60 * 60 * 24) / (30 * 60 * 60 * 24));
                $days = floor(($diff - $years * 365 * 60 * 60 * 24 - $months * 30 * 60 * 60 * 24) / (60 * 60 * 24));
                $hours = floor(
                    ($diff - $years * 365 * 60 * 60 * 24 - $months * 30 * 60 * 60 * 24 - $days * 60 * 60 * 24) / (60 * 60)
                );
                $shiftid = $rw->shift_id;
                $tripid = $rw->trip_id;
                $routeid = 0;
                $this->db->select('v.route_id');
                $this->db->from('tb_trips t');
                $this->db->join('tb_shifts s', 's.id = t.shift_id', 'inner');
                $this->db->join('tb_shft_veh v', 'v.shft_id = s.id', 'inner');
                $this->db->where('s.id', $shiftid);
                $this->db->where('t.id', $tripid);
                $this->db->where('t.status', '0');
                $this->db->order_by('v.id', 'DESC');
                $this->db->limit(1);
                $trips = $this->db->get();
                if ($trips->num_rows() > 0) {
                    $routeid = $trips->row()->route_id;
                }
                $driverveh = 0;
                $ddtail1 = $this->db->select('register_number')->get_where(
                    'tb_trucks_data',
                    array('id' => $rw->vehicle_id),
                    1,
                    0
                );
                if ($ddtail1->num_rows() > 0) {
                    $driverveh = $ddtail1->row()->register_number;
                }
                $driverno = 0;
                $ddetail = $this->db->select('contact_num')->get_where(
                    'tb_truck_drivers',
                    array('id' => $rw->driver_id),
                    1,
                    0
                );
                if ($ddetail->num_rows() > 0) {
                    $driverno = $ddetail->row()->contact_num;
                }
                $dt = array(
                    'routeid' => $routeid,
                    'shiftstart' => $rw->empshift_start,
                    'shiftend' => $rw->empshift_end,
                    'endtime' => $rw->endtime,
                    'trip_type' => $rw->trip_type,
                    'driverveh' => $driverveh,
                    'driverno' => $driverno
                );
                $chk = $this->db->select('*')->get_where(
                    'tb_trips_mails',
                    array('trip_id' => $tripid, 'shift_id' => $shiftid),
                    1,
                    0
                );

                if ($chk->num_rows() > 0) {
                    $sts = $chk->row()->status;
                    $this->db->select(
                        'e.name,te.stime as in_time,te.status as emp_status,te.driver_late,te.emp_late,te.absent_reason,te.check_in'
                    );
                    $this->db->from('tb_employee e');
                    $this->db->join('tb_trip_employee te', 'te.employee_id=e.id', 'INNER');
                    $this->db->where('te.trip_id', $tripid);
                    $getEmployeeData = $this->db->get();
                    $data['empdata'] = $getEmployeeData;
                    $data['tripdata'] = $chk->row();
                    $rid = $chk->row()->id;
                    $resultset = "";
                    $res = $this->sendmailendday($data, $resultset, $i, $dt);
                    array_push($excel_data, $res);
                    if (count($res) > 0) {
                        $flag = 1;
                        $result .= "<tr>";
                        foreach ($res as $e) {
                            $result .= "<td>$e</td>";
                        }
                        $result .= "</tr>";
                    }
                    $i++;
                }
            }
            $result .= "<tr><td colspan='8' style='border-right:none;border-left:none;border-bottom:none;border-top:none'></td>";
            $result .= "</tr>";
            $result .= "<tr><td colspan='8' style='border-right:none;border-left:none;border-bottom:none;border-top:none'>Thank you,</td>";
            $result .= "</tr>";
            $result .= "<tr><td colspan='8' style='border-right:none;border-left:none;border-top:none'>Support Team, <br /><a href='" . base_url(
                ) . "'>Svkonekt.in</a></td>";
            $result .= "</tr>";
            $result .= "</table>";
            if ($flag == 1) {
                $data1['alldata'] = $result;

                $this->load->library('email');
                $getusermail = $this->db->select("name,emailid,alternate_mails")->get_where(
                    "tb_users",
                    array(
                        "id" => $uid,
                        "emailid !=" => ""
                    ),
                    1,
                    0
                );
                $ccemail = "";
                if ($getusermail->num_rows() > 0) {
                    $receivemail = $getusermail->row()->emailid;
                    $receivename = $getusermail->row()->name;
                    $ccemail = $getusermail->row()->alternate_mails;
                }
                $attachment = $this->create_csv($excel_data, "Cabs_Trips_Daily_Status");
                $this->email->attach($attachment);
                $this->email->to($receivemail, $receivename);
                /*$this->email->to('kambhamramachandra@gmail.com');*/
                if ($uid == '18145') {
                    $this->email->cc('narendra.n@inspiredgeit.com,' . $ccemail);
                } else {
                    $this->email->cc($ccemail);
                }
                $this->email->from('svkonekt@kuehne-nagel.com', 'RT Cabs');
                $this->email->subject('Cabs trips status on :' . date('Y-m-d'));
                $this->email->set_mailtype('html');
                $body = $this->load->view('mail_forms/finalreport', $data1, true);
                $this->email->message($body);
                $this->email->send();
            }
        }
    }

    public function sendmailendday($data, $result, $i, $dt)
    {
        $excel = array();
        if ($data['tripdata']->attcnt != 0) {
            if ($dt["trip_type"] != 2) {
                $date = "";
                if ($i == 1) {
                    $date = date('m/d/Y');
                }
                $result .= "<tr><td border='0'>" . $date . "</td>";
                $excel[] = $date;
                /*$result .= "<td> IE ".$dt['routeid']."</td>";*/
                $result .= "<td>" . $dt['driverveh'] . " (" . $dt['driverno'] . ")</td>";
                $excel[] = $dt['driverveh'] . " (" . $dt['driverno'] . ")";
                $result .= "<td>" . $dt['shiftstart'] . "</td>";
                $excel[] = $dt['shiftstart'];
                $result .= "<td>" . $dt['endtime'] . "</td>";
                $excel[] = $dt['endtime'];
                $occupance = @round(($data['tripdata']->attcnt / $data['tripdata']->totcnt) * 100, 2);
                $result .= "<td>" . $data['tripdata']->totcnt . "</td>";
                $excel[] = $data['tripdata']->totcnt;
                $result .= "<td>" . $data['tripdata']->attcnt . "</td>";
                $excel[] = $data['tripdata']->attcnt;
                $result .= "<td>" . $occupance . " %</td>";
                $excel[] = $occupance;
                $empd = "";
                $result .= "<td>";
                if ($data['empdata']->num_rows() > 0) {
                    $empd = "";
                    foreach ($data['empdata']->result() as $res) {
                        if ($res->emp_status == 0 && strlen($res->check_in) == 0) {
                            $result .= $res->name . " - " . $res->absent_reason . ", ";
                            $empd .= $res->name . " - " . $res->absent_reason . ", ";
                        }
                    }
                }
                $result .= "</td>";
                $excel[] = $empd;
                $shftend = "";
                if ($dt['trip_type'] == 0) {
                    $shftend = $dt['shiftend'];
                }
                $result .= "<td>" . $shftend . "</td>";
                $result .= "</tr>";
            }
        }
        return $excel;
    }

    public function overspeedalert()
    {
        $current = date("Y-m-d H:i:s");
        $before = date("Y-m-d H:i:s", time() - 800);
        $this->db->select('d.name, d.id as driverid, d.contact_num, d.user_id, t.register_number, t.id as vehid, o.* ');
        $this->db->from('tb_truck_drivers d');
        $this->db->join('tbl_assigned_drivers ad', 'ad.driver_id = d.id');
        $this->db->join('tb_over_speed o', 'ad.imei = o.mobileimei');
        $this->db->join('tb_trucks_data t', 't.id = ad.vehicle_id');
        $this->db->where('o.receivedon >=', $before);
        $this->db->where('o.receivedon <=', $current);
        $this->db->where('d.status', 'Active');
        $this->db->where('ad.status', '1');
        $this->db->order_by('user_id', 'ASC');
        $this->db->group_by('register_number');
        $res = $this->db->get();
        $duid = "";
        $txt = "";
        $i = 1;
        if ($res->num_rows() > 0) {
            foreach ($res->result() as $row) {
                $uid = $row->user_id;
                $shft = $this->getShiftFromDriver($row->driverid, $row->vehid, $current, $before);
                if ($duid != $uid) {
                    if ($txt != "") {
                        $this->sendoverspeedmail($duid, $txt);
                        $txt = "";
                    }
                }
                $kms = $row->speed * 3.6;
                $txt .= "<tr><td>" . $row->name . "</td><td>" . $row->contact_num . "</td><td>" . $row->register_number . "</td><td>" . $shft['shiftstart'] . "-" . $shft['shiftend'] . "</td><td>" . getLocationname(
                        $row->latitude,
                        $row->longitude
                    ) . "</td><td>" . $kms . " KM</td><td>" . $row->receivedon . "</td></tr>";
                $duid = $uid;
                if ($i == $records->num_rows()) {
                    $this->sendoverspeedmail($uid, $txt);
                }
                $i++;
            }
        }
    }

    public function getShiftFromDriver($driverid, $vehid, $current, $before)
    {
        $result = array();
        $this->db->select('s.id,s.empshift_start,s.empshift_end');
        $this->db->from('tb_trips t');
        $this->db->join('tb_shifts s', 't.shift_id=s.id', 'INNER');
        $this->db->where('t.vehicle_id', $vehid);
        $this->db->where('t.driver_id', $driverid);
        $this->db->order_by('t.id', 'DESC');
        $this->db->limit(1);
        $res = $this->db->get();
        $result['shiftid'] = '';
        $result['shiftstart'] = '';
        $result['shiftend'] = '';
        if ($res->num_rows() > 0) {
            $result['shiftid'] = $res->row()->id;
            $result['shiftstart'] = $res->row()->empshift_start;
            $result['shiftend'] = $res->row()->empshift_end;
        }
        return $result;
    }

    public function sendoverspeedmail($uid, $txt)
    {
        $getusermail = $this->db->select("name,emailid,alternate_mails")->get_where(
            "tb_users",
            array(
                "id" => $uid,
                "emailid !=" => ""
            ),
            1,
            0
        );
        $ccemail = "";
        if ($getusermail->num_rows() > 0) {
            $receivemail = $getusermail->row()->emailid;
            $receivename = $getusermail->row()->name;
            $ccemail = $getusermail->row()->alternate_mails;
        }
        $html = "Dear $receivename,<br><br><br><strong>Cab Over Speed Alert</strong><br><br><table border='0'><tr style='background-color: #14A3E1;color: white;'><td>Driver Name</td><td>Driver No</td><td>Vehicle</td><td>Shift</td><td>Location</td><td>Speed</td><td>Time</td></tr>" . $txt . "</table><br><br>Thanks,<br><b>Return Trucks</b><br>";
        $this->email->to($receivemail, $receivename);
        $this->email->cc($ccemail);
        $this->email->from('svkonekt@kuehne-nagel.com', 'RT Cabs');
        $this->email->subject('Over Speed Alarm ');
        $this->email->set_mailtype('html');
        $this->email->message($html);
    }
}
