<?php

defined('BASEPATH') or exit('No direct script access allowed');

require_once APPPATH . "/third_party/PHPExcel.php";

class CarrierDailyReportForPhilippines extends CI_Controller
{
    public function __construct()
    {
        parent::__construct();
        $this->load->model('CarrierDailyReportModel');
        $this->load->library(['PhpMailerLibrary']);
    }

    public function index()
    {
        $ordersData = $this->CarrierDailyReportModel->getCarrierOrdersReport();
        $ordersGroupedByCarrierCode = $customerEmails = [];
        foreach ($ordersData as $eachOrderData) {
            $ordersGroupedByCarrierCode[$eachOrderData['carrier_code']][] = $eachOrderData;
            $customerEmails[$eachOrderData['carrier_code']] = ['email_id' => $eachOrderData['carrier_email'],'name' => $eachOrderData['carrier_name']];
        }
        if (empty($ordersGroupedByCarrierCode)) {
            return false;
        }
        $mailData = [
            'cc_mail_ids' => ['m.sivakumar@kuehne-nagel.com', 'joel.padua@kuehne-nagel.com', 'florylie-joy.gumboc@kuehne-nagel.com', 'angelie.omes@kuehne-nagel.com'],
            'bcc_mail_ids' => ['sol.ignacio@kuehne-nagel.com'],
        ];
        foreach ($ordersGroupedByCarrierCode as $key => $value) {
            $fileName = $this->generateExcelReport($key, $value);
            switch ($key) {
                case '1004672594':
                    $mailData['subject'] = 'AUTOEMAIL - JEUNNEJAREL TRANSPORT SERVICES ORDER STATUS (PENDING/ACTIVE)';
                    $mailData['to_mail_ids'] = ['jojopadilla73@gmail.com', 'mbanacay@yahoo.com'];
                    break;
                case '1003091557':
                    $mailData['subject'] = 'AUTOEMAIL - GAPUZAN TRUCKING INC. ORDER STATUS (PENDING/ACTIVE)';
                    $mailData['to_mail_ids'] = ['hazelmacaraig@yahoo.com','booking.gapuzan@gmail.com','billing02@gapuzancares.com'];
                    break;
                case '1000317753':
                    $mailData['subject'] = 'AUTOEMAIL - Cargo Bayan Incorporated ORDER STATUS (PENDING/ACTIVE)';
                    $mailData['to_mail_ids'] = ['aglara@cargobayaninc.com.ph','operations@cargobayaninc.com.ph','wayne.villaflor1220@gmail.com'];
                    break;
                case '1000332030':
                    $mailData['subject'] = 'AUTOEMAIL - Lao Customs Brokerage ORDER STATUS (PENDING/ACTIVE)';
                    $mailData['to_mail_ids'] = ['echavez_lao@gmail.com','echavez_lao@yahoo.com','maryjoyamoin@gmail.com','amoinmj.laocustoms@gmail.com'];
                    break;
                case '1004854643':
                    $mailData['subject'] = 'AUTOEMAIL - SEVEN LOGISTICS SOLUTION CORP. ORDER STATUS (PENDING/ACTIVE)';
                    $mailData['to_mail_ids'] = ['operation_dept@sevenlogisticscorp.com','noel.j.espulgar@sevenlogisticscorp.com'];
                    break;
                case '1003866908':
                    $mailData['subject'] = 'AUTOEMAIL - RSEAN ENTERPRISES ORDER STATUS (PENDING/ACTIVE)';
                    $mailData['to_mail_ids'] = ['celbaligad29@gmail.com'];
                    break;
                case '1004444302':
                    $mailData['subject'] = 'AUTOEMAIL - RMLR ORDER STATUS ORDER STATUS (PENDING/ACTIVE)';
                    $mailData['to_mail_ids'] = ['aguirrerp@yahoo.com','calidajohnbernard684@gmail.com'];
                    break;
                case '1001737572':
                    $mailData['subject'] = 'AUTOEMAIL - TIMECARGO LOGISTICS CORPORATION ORDER STATUS ORDER STATUS (PENDING/ACTIVE)';
                    $mailData['to_mail_ids'] = ['andrewcastillo@timecargo.ph','ruelcabral@timecargo.ph','suzzy@timecargo.ph'];
                    break;
                default:
                    $mailData['subject'] = 'AUTOEMAIL - '.($customerEmails[$key]['name'] ?? '').' (PENDING/ACTIVE)';
                    $mailData['to_mail_ids'] = [($customerEmails[$key]['email_id'] ?? '')];
            }
            if ($fileName != '') {
                $this->sendMail($fileName, $mailData);
            }
        }
        return true;
    }

    private function generateExcelReport(string $carrierCode, array $ordersData): string
    {
        if (!empty($ordersData)) {
            $styleArray = [
                'font' => [
                    'bold' => true,
                    'color' => ['rgb' => 'FFFFFF'],
                    'size' => 10,
                    'name' => 'Verdana'
                ]
            ];
            $cacheMethod = PHPExcel_CachedObjectStorageFactory::cache_to_sqlite;
            $cacheSettings = ['memoryCacheSize' => '512MB'];
            PHPExcel_Settings::setCacheStorageMethod($cacheMethod, $cacheSettings);
            $objPHPExcel = new PHPExcel();
            $objPHPExcel->setActiveSheetIndex(0);
            $objPHPExcel->getActiveSheet()
                ->getStyle('A1:Q1')
                ->applyFromArray(
                    [
                        'fill' => [
                            'type' => PHPExcel_Style_Fill::FILL_SOLID,
                            'color' => ['rgb' => '0c3b81']
                        ]
                    ]
                );
            $objPHPExcel->getActiveSheet()->SetCellValue('A1', 'Carrier');
            $objPHPExcel->getActiveSheet()->getColumnDimension('A')->setWidth(15);
            $objPHPExcel->getActiveSheet()->getStyle('A1')->applyFromArray($styleArray);
            $objPHPExcel->getActiveSheet()->SetCellValue('B1', 'Booking ID');
            $objPHPExcel->getActiveSheet()->getColumnDimension('B')->setWidth(15);
            $objPHPExcel->getActiveSheet()->getStyle('B1')->applyFromArray($styleArray);
            $objPHPExcel->getActiveSheet()->SetCellValue('C1', 'Salog Ref');
            $objPHPExcel->getActiveSheet()->getColumnDimension('C')->setWidth(15);
            $objPHPExcel->getActiveSheet()->getStyle('C1')->applyFromArray($styleArray);
            $objPHPExcel->getActiveSheet()->SetCellValue('D1', 'Department');
            $objPHPExcel->getActiveSheet()->getColumnDimension('D')->setWidth(13);
            $objPHPExcel->getActiveSheet()->getStyle('D1')->applyFromArray($styleArray);
            $objPHPExcel->getActiveSheet()->SetCellValue('E1', 'SDT');
            $objPHPExcel->getActiveSheet()->getColumnDimension('E')->setWidth(10);
            $objPHPExcel->getActiveSheet()->getStyle('E1')->applyFromArray($styleArray);
            $objPHPExcel->getActiveSheet()->SetCellValue('F1', 'Customer');
            $objPHPExcel->getActiveSheet()->getColumnDimension('F')->setWidth(15);
            $objPHPExcel->getActiveSheet()->getStyle('F1')->applyFromArray($styleArray);
            $objPHPExcel->getActiveSheet()->SetCellValue('G1', 'PickUp Address');
            $objPHPExcel->getActiveSheet()->getColumnDimension('G')->setWidth(30);
            $objPHPExcel->getActiveSheet()->getStyle('G1')->applyFromArray($styleArray);
            $objPHPExcel->getActiveSheet()->SetCellValue('H1', 'Delivery Address');
            $objPHPExcel->getActiveSheet()->getColumnDimension('H')->setWidth(30);
            $objPHPExcel->getActiveSheet()->getStyle('H1')->applyFromArray($styleArray);
            $objPHPExcel->getActiveSheet()->SetCellValue('I1', 'PickUp Status Date & Time');
            $objPHPExcel->getActiveSheet()->getColumnDimension('I')->setWidth(20);
            $objPHPExcel->getActiveSheet()->getStyle('I1')->applyFromArray($styleArray);
            $objPHPExcel->getActiveSheet()->SetCellValue('J1', 'Delivery Date / Time');
            $objPHPExcel->getActiveSheet()->getColumnDimension('J')->setWidth(20);
            $objPHPExcel->getActiveSheet()->getStyle('J1')->applyFromArray($styleArray);
            $objPHPExcel->getActiveSheet()->SetCellValue('K1', 'Delivery Note');
            $objPHPExcel->getActiveSheet()->getColumnDimension('K')->setWidth(20);
            $objPHPExcel->getActiveSheet()->getStyle('K1')->applyFromArray($styleArray);
            $objPHPExcel->getActiveSheet()->SetCellValue('L1', 'Trip ID');
            $objPHPExcel->getActiveSheet()->getColumnDimension('L')->setWidth(15);
            $objPHPExcel->getActiveSheet()->getStyle('L1')->applyFromArray($styleArray);
            $objPHPExcel->getActiveSheet()->SetCellValue('M1', 'Shipper Name');
            $objPHPExcel->getActiveSheet()->getColumnDimension('M')->setWidth(20);
            $objPHPExcel->getActiveSheet()->getStyle('M1')->applyFromArray($styleArray);
            $objPHPExcel->getActiveSheet()->SetCellValue('N1', 'Consignee Name');
            $objPHPExcel->getActiveSheet()->getColumnDimension('N')->setWidth(30);
            $objPHPExcel->getActiveSheet()->getStyle('N1')->applyFromArray($styleArray);
            $objPHPExcel->getActiveSheet()->SetCellValue('O1', 'Actual Pick-Up');
            $objPHPExcel->getActiveSheet()->getColumnDimension('O')->setWidth(15);
            $objPHPExcel->getActiveSheet()->getStyle('O1')->applyFromArray($styleArray);
            $objPHPExcel->getActiveSheet()->SetCellValue('P1', 'Actual Delivery');
            $objPHPExcel->getActiveSheet()->getColumnDimension('P')->setWidth(15);
            $objPHPExcel->getActiveSheet()->getStyle('P1')->applyFromArray($styleArray);
            $objPHPExcel->getActiveSheet()->SetCellValue('Q1', 'POD Status');
            $objPHPExcel->getActiveSheet()->getColumnDimension('Q')->setWidth(15);
            $objPHPExcel->getActiveSheet()->getStyle('Q1')->applyFromArray($styleArray);
            $activeWorksheet = $objPHPExcel->getActiveSheet();
            $rowCount = 2;
            try {
                foreach ($ordersData as $eachOrderData) {
                    $references = explode('?????', $eachOrderData['order_references']);
                    $DQReferenceValue = $salogReferenceValue = $SDReference = $SDTReference = '';
                    foreach ($references as $eachReference) {
                        $reference = explode(' - ', $eachReference);
                        if (isset($reference[0]) && $reference[0] == 'DQ') {
                            $DQReferenceValue = $reference[1];
                        }
                        if (isset($reference[0]) && $reference[0] == 'XSR') {
                            $salogReferenceValue = $reference[1];
                        }
                        if (isset($reference[0]) && $reference[0] == 'SD') {
                            $SDReference = $reference[1];
                        }
                        if (isset($reference[0]) && $reference[0] == 'SDT') {
                            $SDTReference = $reference[1];
                        }
                    }
                    $activeWorksheet->SetCellValue('A' . $rowCount, $eachOrderData['carrier_name']);
                    $activeWorksheet->SetCellValue('B' . $rowCount, $eachOrderData['order_id']);
                    $activeWorksheet->SetCellValue('C' . $rowCount, $salogReferenceValue);
                    $activeWorksheet->SetCellValue('D' . $rowCount, $SDReference);
                    $activeWorksheet->SetCellValue('E' . $rowCount, $SDTReference);
                    $activeWorksheet->SetCellValue('F' . $rowCount, $eachOrderData['customer_name']);
                    $activeWorksheet->SetCellValue('G' . $rowCount, $eachOrderData['pickupAddress']);
                    $activeWorksheet->SetCellValue('H' . $rowCount, $eachOrderData['deliveryAddress']);
                    $activeWorksheet->SetCellValue('I' . $rowCount, $eachOrderData['early_pickup_datetime']);
                    $activeWorksheet->SetCellValue('J' . $rowCount, $eachOrderData['early_drop_datetime']);
                    $activeWorksheet->SetCellValue('K' . $rowCount, $DQReferenceValue);
                    $activeWorksheet->SetCellValue('L' . $rowCount, $eachOrderData['shipmentid']);
                    $activeWorksheet->SetCellValue('M' . $rowCount, $eachOrderData['pickup_company']);
                    $activeWorksheet->SetCellValue('N' . $rowCount, $eachOrderData['delivery_company']);
                    $activeWorksheet->SetCellValue('O' . $rowCount, $eachOrderData['actual_pickup_datetime']);
                    $activeWorksheet->SetCellValue('P' . $rowCount, $eachOrderData['actual_delivery_datetime']);
                    $activeWorksheet->SetCellValue('Q' . $rowCount, $eachOrderData['pod_status']);
                    $rowCount++;
                }
            } catch (\Throwable $exception) {
                log_message("error", "Philippines Carrier report cannot set cell value - " . $exception->getMessage());
            }
            $fileName = 'Philippines_Carrier_Report_' . date("dM_") . $carrierCode . '.xlsx';
            $objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel2007');
            if (!file_exists('assets/HKDailyReport')) {
                mkdir('assets/HKDailyReport', 0710, true);
            }
            try {
                $objWriter->save(str_replace(__FILE__, 'assets/HKDailyReport/' . $fileName, __FILE__));
                return $fileName;
            } catch (PHPExcel_Writer_Exception $e) {
                log_message("error", "Philippines Carrier report PHPExel_Writer_Exception - " . $e->getMessage());
            }
        }
        return '';
    }

    private function sendMail(string $filename, array $mailData): bool
    {
        $message = "Hello,<br>";
        $message .= "Please find attached for above mentioned subject. " . "<br><br>";
        $message .= "Sincerely,<br>";
        $message .= "Road Logistics<br>";
        $attachmentPath = sprintf('%s/assets/HKDailyReport/%s', FCPATH, $filename);
        $status = false;
        try {
            if ($this->phpmailerlibrary->sendMultipleToMail($mailData['to_mail_ids'], $mailData['subject'], $message, $mailData['cc_mail_ids'], [$attachmentPath], $mailData['bcc_mail_ids'])) {
                $status = true;
                log_message("error", "Philippines Carrier report data success - " . json_encode($mailData)." filename- ".$filename);
            }
        } catch (Exception $e) {
            log_message("error", "Philippines Carrier report email failed - "  . json_encode($mailData)." filename- ".$filename);
        }
        return $status;
    }

}
