<?php

if (!defined('BASEPATH')) {
    exit('No direct script access allowed');
}

class Carriercommonedi extends CI_Controller
{

    public function __Construct()
    {
        parent::__Construct();
        $this->load->library(["carriercommonedilib", "carrierstandardtripoutbound", "CarrierDocumentOutbound"]);
        $this->load->library(["tollcarrieredi", "Altovaordercreation"]);
        $this->load->model(["common", "carriercommonmodel"]);
    }

    public function call_edi($shift_id = "")
    {
        $edidata = $this->carriercommonedilib->shipmentdata($shift_id);
        echo $edidata ?? 0;
    }
    
    public function call_edi_cargo($shift_id = "", $order_id = "")
    {
        $edidata = $this->carriercommonedilib->CargoExchangeShipmentData($shift_id, $order_id);
        echo $edidata ?? 0;
    }

    public function callTollEdi($shift_id = "")
    {
        $tollEdidata = $this->tollcarrieredi->shipmentdata($shift_id);
        echo 0;
    }

    public function callStandrdEdi($shift_id = "")
    {

        $tripdatavendordetails = $this->carriercommonmodel->getShipmentCarrier($shift_id);
        $carrierID = $tripdatavendordetails['id'];
        $getCarrierEDIIfo = $this->carriercommonmodel->getCarrierEDIDetails($carrierID);
        if (empty($getCarrierEDIIfo)) {
            if (checkAccessConditions('WECHAT_COUNTRY', $this->session->userdata('company_code'))) {
                $getOrders = $this->common->gettbldata(["shift_id" => $shift_id], "order_id", "tb_orders", 0, 0);
                if (!empty($getOrders)) {
                    foreach ($getOrders as $order) {
                        $this->load->library('Wechat');
                        $this->wechat->orderId = $order['order_id'];
                        $this->wechat->sendNotificationsToWeChat();
                    }
                }
            }
            log_message("error", "Carriercommonedi -> Carrier Does not have permission for shipment:" . $shift_id);
            return;
        }
        $edidata = $this->carrierstandardtripoutbound->shipmentdata($shift_id);
        try {
            $this->carrierstandardtripoutbound->tripOutboundToEportal($shift_id);
        } catch (Exception $ex) {
            log_message("error", "Trip sending Failed to Eportal " . $shift_id . $ex->getMessage());
        }
        echo $edidata ?? 0;
    }
    public function sendDocumets($orderid = "")
    {
        $edidata = $this->carrierdocumentoutbound->sendDocumentsToCarrier($orderid);
        echo $edidata ?? 0;
    }

    public function sendAltovaOrder($orderid = "")
    {
        try {
            $edidata = $this->altovaordercreation->sendOrderToAltova($orderid);
        } catch (Exception $ex) {
            log_message("error", "Some Problem occured!, While Sending Order to Altova " . $ex->getMessage());
        }
        $this->session->set_flashdata('success_msg', "Order Successfully Sent to ROADLOG");
        redirect("orders/orderslist/" . $orderid);
    }

}
