<?php

defined('BASEPATH') or exit('No direct script access allowed');

class Carrierorderlistspecification extends CI_Controller
{


    public function __Construct()
    {
        parent::__Construct();
        if ($this->session->userdata('business_type') != "Carrier") {
            redirect('welcome/logout');
        }
        $this->load->model("common");
    }

    public function index(): void
    {
        $data["page_title"] = $this->lang->line('order_list_spec');
        $data["sub_title"] = $this->lang->line('cust_search');
        $data['companyCode'] = $this->session->userdata('company_code');
        $data['branchCode'] = $this->session->userdata('branch_code');
        $data['cid'] = $this->session->userdata('mobile');
        $data['carrierName'] = $this->session->userdata('name');
        $data['carrierOrderColumns'] = $this->common->getorderlistspecs();
        $this->newtemplate->dashboard("carrierorderlistspecs/index", $data);
    }

    public function add(): void
    {
        $data["page_title"] = $this->lang->line('order_list_spec');
        $data["sub_title"] = $this->lang->line('general_add');
        $data['companyCode'] = $this->session->userdata('company_code');
        $data['branchCode'] = $this->session->userdata('branch_code');
        $data['cid'] = $this->session->userdata('mobile');
        $data['carrierName'] = $this->session->userdata('name');
        $data["selected_columns"] = [
            'S.No',
            'Booking ID',
            'SALOG Ref',
            'Pickup',
            'Delivery',
            'Delivery city',
            'Trip No',
            'Status',
            'Created Date',
            'Pickup Date',
            'Total Packages',
            'Actual Weight',
            'Actual Volume',
            'POD'
        ];
        $data["columns"] = [
            's_no' => "S.No",
            'ord_id' => "Booking ID",
            'salog_ref' => "SALOG Ref",
            'pickup' => "Pickup",
            'delivery' => "Delivery",
            'deliverycity' => "Delivery city",
            'status' => "Status",
            'created_date' => "Created Date",
            'pickup_date' => "Pickup Date",
            'total_packages' => "Total Packages",
            'actual_weight' => "Actual Weight",
            'actual_volume' => "Actual Volume",
            'pod' => "POD"
        ];
        $this->newtemplate->dashboard("carrierorderlistspecs/add", $data);
    }

    public function edit(int $id): void
    {
        $data["page_title"] = $this->lang->line('order_list_spec');
        $data["sub_title"] = $this->lang->line('cutomer_edit');
        $data['companyCode'] = $this->session->userdata('company_code');
        $data['branchCode'] = $this->session->userdata('branch_code');
        $data['user_id'] = $this->session->userdata('user_id');
        $data['code'] = $data['name'] = "";
        $data['cid'] = $this->session->userdata('mobile');
        $data['carrierName'] = $this->session->userdata('name');
        $data["custaprlcols"] = [];
        $getcustaprlcols = $this->common->gettblrowdata(['id' => $id], '*', 'tb_orderlist_spec_cols', 0, 0);
        if (!empty($getcustaprlcols)) {
            $data['custaprlcols'] = $getcustaprlcols;
        }
        $data["columns"] = [
            's_no' => "S.No",
            'ord_id' => "Booking ID",
            'salog_ref' => "SALOG Ref",
            'pickup' => "Pickup",
            'delivery' => "Delivery",
            'deliverycity' => "Delivery city",
            'status' => "Status",
            'created_date' => "Created Date",
            'pickup_date' => "Pickup Date",
            'total_packages' => "Total Packages",
            'actual_weight' => "Actual Weight",
            'actual_volume' => "Actual Volume",
            'pod' => "POD"
        ];
        $this->newtemplate->dashboard("carrierorderlistspecs/edit", $data);
    }

    public function view(int $id): void
    {
        $data["page_title"] = $this->lang->line('order_list_spec');
        $data["sub_title"] = $this->lang->line('cutomer_edit');
        $data['companyCode'] = $this->session->userdata('company_code');
        $data['branchCode'] = $this->session->userdata('branch_code');
        $data['user_id'] = $this->session->userdata('user_id');
        $data['code'] = $data['name'] = "";
        $data['cid'] = $this->session->userdata('mobile');
        $data['carrierName'] = $this->session->userdata('name');
        $data["custaprlcols"] = [];
        $getcustaprlcols = $this->common->gettblrowdata(['id' => $id], '*', 'tb_orderlist_spec_cols', 0, 0);
        if (!empty($getcustaprlcols)) {
            $data['custaprlcols'] = $getcustaprlcols;
        }
        $data["columns"] = [
            's_no' => "S.No",
            'ord_id' => "Booking ID",
            'salog_ref' => "SALOG Ref",
            'pickup' => "Pickup",
            'delivery' => "Delivery",
            'deliverycity' => "Delivery city",
            'status' => "Status",
            'created_date' => "Created Date",
            'pickup_date' => "Pickup Date",
            'total_packages' => "Total Packages",
            'actual_weight' => "Actual Weight",
            'actual_volume' => "Actual Volume",
            'pod' => "POD"
        ];
        $this->newtemplate->dashboard("carrierorderlistspecs/view", $data);
    }

    public function save(): void
    {
        $post = $this->input->post(null, true);
        $currentDate = date('Y-m-d H:i:s');
        $userId = $this->session->userdata('user_id');
        $carrierId = $this->session->userdata('id');
        $orderlistColId = (isset($post['orderlistColId']) && !empty($post['orderlistColId'])) ? ($post['orderlistColId']) : 0;
        $sNo = (isset($post['s_no']) && !empty($post['s_no'])) ? ($post['s_no']) : 0;
        $orderId = (isset($post['ord_id']) && !empty($post['ord_id'])) ? ($post['ord_id']) : 0;
        $salogRef = (isset($post['salog_ref']) && !empty($post['salog_ref'])) ? ($post['salog_ref']) : 0;
        $pickUp = (isset($post['pickup']) && !empty($post['pickup'])) ? ($post['pickup']) : 0;
        $delivery = (isset($post['delivery']) && !empty($post['delivery'])) ? ($post['delivery']) : 0;
        $deliveryCity = $post['deliverycity'] ?? 0;
        $status = (isset($post['status']) && !empty($post['status'])) ? ($post['status']) : 0;
        $createdDate = (isset($post['created_date']) && !empty($post['created_date'])) ? ($post['created_date']) : 0;
        $pickupDate = (isset($post['pickup_date']) && !empty($post['pickup_date'])) ? ($post['pickup_date']) : 0;
        $totalPackages = (isset($post['total_packages']) && !empty($post['total_packages'])) ? ($post['total_packages']) : 0;
        $actualWeight = (isset($post['actual_weight']) && !empty($post['actual_weight'])) ? ($post['actual_weight']) : 0;
        $actualVolume = (isset($post['actual_volume']) && !empty($post['actual_volume'])) ? ($post['actual_volume']) : 0;
        $pod = (isset($post['pod']) && !empty($post['pod'])) ? ($post['pod']) : 0;

        /*  sequences  */
        $sNoSeq = (isset($post['s_no_seq']) && !empty($post['s_no_seq'])) ? ($post['s_no_seq']) : 0;
        $orderIdSeq = (isset($post['ord_id_seq']) && !empty($post['ord_id_seq'])) ? ($post['ord_id_seq']) : 0;
        $salogRefSeq = (isset($post['salog_ref_seq']) && !empty($post['salog_ref_seq'])) ? ($post['salog_ref_seq']) : 0;
        $pickupSeq = (isset($post['pickup_seq']) && !empty($post['pickup_seq'])) ? ($post['pickup_seq']) : 0;
        $deliverySeq = (isset($post['delivery_seq']) && !empty($post['delivery_seq'])) ? ($post['delivery_seq']) : 0;
        $deliveryCitySeq = $post['deliverycity_seq'] ?? 0;
        $statusSeq = (isset($post['status_seq']) && !empty($post['status_seq'])) ? ($post['status_seq']) : 0;
        $createdDateSeq = (isset($post['created_date_seq']) && !empty($post['created_date_seq'])) ? ($post['created_date_seq']) : 0;
        $pickupDateSeq = (isset($post['pickup_date_seq']) && !empty($post['pickup_date_seq'])) ? ($post['pickup_date_seq']) : 0;
        $totalPackagesSeq = (isset($post['total_packages_seq']) && !empty($post['total_packages_seq'])) ? ($post['total_packages_seq']) : 0;
        $actualWeightSeq = (isset($post['actual_weight_seq']) && !empty($post['actual_weight_seq'])) ? ($post['actual_weight_seq']) : 0;
        $actualVolumeSeq = (isset($post['actual_volume_seq']) && !empty($post['actual_volume_seq'])) ? ($post['actual_volume_seq']) : 0;
        $podSeq = (isset($post['pod_seq']) && !empty($post['pod_seq'])) ? ($post['pod_seq']) : 0;
        $insdata = [
            's_no' => $sNo . "_" . $sNoSeq . '_2',
            'ord_id' => $orderId . "_" . $orderIdSeq . '_3',
            'salog_ref' => $salogRef . "_" . $salogRefSeq . '_4',
            'pickup' => $pickUp . "_" . $pickupSeq . '_5',
            'delivery' => $delivery . "_" . $deliverySeq . '_6',
            'deliverycity' => $deliveryCity . "_" . $deliveryCitySeq . '_7',
            'status' => $status . "_" . $statusSeq . '_8',
            'created_date' => $createdDate . "_" . $createdDateSeq . '_9',
            'pickup_date' => $pickupDate . "_" . $pickupDateSeq . '_10',
            'total_packages' => $totalPackages . "_" . $totalPackagesSeq . '_11',
            'actual_weight' => $actualWeight . "_" . $actualWeightSeq . '_12',
            'actual_volume' => $actualVolume . "_" . $actualVolumeSeq . '_13',
            'pod' => $pod . "_" . $podSeq . '_14',
            'user_id' => $userId,
            'is_active' => 1,
            'carrier_id' => $carrierId,
            'created_on' => $currentDate,
            'updated_on' => $currentDate
        ];
        $checkDataExist = $this->common->gettblrowdata(['carrier_id' => $carrierId, 'user_id' => $userId, 'is_active' => 1], 'id', 'tb_orderlist_spec_cols', 0, 0);
        if ($orderlistColId > 0) {
            $update = $this->common->updatetbledata("tb_orderlist_spec_cols", $insdata, ['id' => $orderlistColId]);
            $caprl_id = $orderlistColId;
        } else {
            if (!empty($checkDataExist)) {
                $caprl_id = 'already_exist';
            } else {
                $caprl_id = $this->common->insertTableData("tb_orderlist_spec_cols", $insdata);
                $caprl_id = 'inserted';
            }
        }
        echo json_encode($caprl_id);
    }

    public function getorderlistspec(): void
    {
        $carrierId = $this->session->userdata('id');
        $result = $this->common->getCarrierOrderlistColumns($carrierId);
        $columns = [
            's_no' => "S.No",
            'ord_id' => "Booking ID",
            'salog_ref' => "SALOG Ref",
            'pickup' => "Pickup",
            'delivery' => "Delivery",
            'deliverycity' => "Delivery city",
            'status' => "Status",
            'created_date' => "Created Date",
            'pickup_date' => "Pickup Date",
            'total_packages' => "Total Packages",
            'actual_weight' => "Actual Weight",
            'actual_volume' => "Actual Volume",
            'pod' => "POD"
        ];
        $not_selected_colum = $selected_colum = [];

        if (!empty($result)) {
            foreach ($columns as $key => $value) {
                $col_val = explode("_", $result[$key]);
                if (isset($col_val[0])) {
                    if ($col_val[0] == 0) {
                        if (isset($col_val[2])) {
                            $not_selected_colum[$col_val[1]] = $col_val[2];
                        }
                    } else {
                        if (isset($col_val[2])) {
                            $selected_colum[$col_val[1]] = ($col_val[2]);
                        }
                    }
                }
            }
        }
        ksort($selected_colum);
        ksort($not_selected_colum);
        $selected_columId = $not_selected_columId = [];

        foreach ($selected_colum as $values) {
            $selected_columId[] = $values;
        }

        foreach ($not_selected_colum as $values) {
            $not_selected_columId[] = $values;
        }

        $obj['selected_colum'] = $selected_columId;
        $obj['not_selected_colum'] = $not_selected_columId;
        echo json_encode($obj);
    }

    public function delete(int $id): void
    {
        if ($id == null) {
            redirect("Carrierorderlistspecification");
        } else {
            if ($id != '0') {
                $update = $this->common->updatetbledata('tb_orderlist_spec_cols', ["is_active" => 0], ["id" => $id]);
                if ($update) {
                    echo "1";
                } else {
                    echo "0";
                }
            }
        }
    }
}
