<?php if (!defined('BASEPATH')) {
    exit('No direct script access allowed');
}

class Chargesdistribution extends CI_Controller
{
    public function __Construct()
    {
        parent::__Construct();
        if ($this->session->userdata('user_id') == '') {
            redirect('login');
        }
        $this->load->model(['common', 'consolidationmodel', 'Order']);
    }

    public function index()
    {
        $user_id = $this->session->userdata('user_id');
        $company_code = $this->session->userdata('company_code');
        $branch_code = $this->session->userdata('branch_code');
        $data['vatcategory'] = $data['chargecodes'] = $data['currencies'] = array();
        $data['session_currency'] = $this->session->userdata("usr_tzone")['currency'];
        $res = $this->common->gettbldata(array('status' => '1'), "currency", "tbl_country_master", 0, 0);
        if (!empty($res)) {
            foreach ($res as $result) {
                $data['currencies'][] = $result['currency'];
            }
        }
        $data['vatcategory'] = $data['chargecodes'] = array();
        $getvatcategory = $this->common->gettbldata(array('company_code' => $company_code, 'status' => '1'), "id,description,vat_category,vat_percentage", "tb_vat_category", 0, 0);
        if (!empty($getvatcategory)) {
            foreach ($getvatcategory as $res) {
                $desc = $res['description'] . " (" . $res['vat_category'] . "-" . $res['vat_percentage'] . ")";
                $data['vatcategory'][] = array('val' => $res['id'], 'desc' => $desc);
            }
        }
        $getchargecodes =  $this->common->gettbldata(array('status' => '1'), "id,charge_code", "tb_charge_codes", 0, 0);
        if (!empty($getchargecodes)) {
            foreach ($getchargecodes as $res) {
                $data['chargecodes'][] = array('charge_id' => $res['id'], 'charge_code' => $res['charge_code']);
            }
        }
        echo json_encode($data);
    }
    public function applylogic()
    {
        $post = $this->input->post(NULL, TRUE);
        $user_id = $this->session->userdata('user_id');
        $company_code = $this->session->userdata('company_code');
        $party_type = $post['party_type'] ?? "";
        $party_code = $post['party_code'] ?? "";
        $amount_distribute = $post['amount_distribute'] ?? 0;
        $charge_code = $post['charge_code'] ?? "";
        $distribution_currency = $post['distribution_currency'] ?? "";
        $distribution_basement = $post['distribution_basement'] ?? "";
        $vat_category_id = $post['vat_category'] ?? "";
        $order_ids = $post['order_ids'] ?? "";
        $status = 0;
        if ($order_ids != "") {
            $order_ids =  explode(",", $order_ids);
        }
        if ($party_type == "Customer") {
            $type = 0;
        } else {
            $type = 1;
        }
        $party_name = "";
        $getparty_details = $this->common->gettblrowdata(array('code' => $party_code, 'company_code' => $company_code, 'status' => '1'), 'name', "tbl_party_master", 0, 0);
        if (!empty($getparty_details)) {
            $party_name = $getparty_details['name'];
        }
        switch ($distribution_basement) {
            case 'QUANTITY':
                $select_uom = "order_id,sum(cd.quantity) as total_uom";
                break;
            case 'VOLUME':
                $select_uom = "order_id,sum(cd.second_volume) as total_uom";
                break;
            case 'WEIGHT':
                $select_uom = "order_id,sum(cd.second_weight) as total_uom";
                break;
            case 'ACTUAL VOLUME':
                $select_uom = "order_id,sum(cd.volume) as total_uom";
                break;
            case 'ACTUAL WEIGHT':
                $select_uom = "order_id,sum(cd.weight) as total_uom";
                break;
            case 'VOLUMETRIC WEIGHT':
                $select_uom = "order_id,sum(cd.volumetric_weight) as total_uom";
                break;
            case 'LDM':
                $select_uom = "order_id,sum(cd.ldm) as total_uom";
                break;
            default:
                $select_uom = "";
        }
        $data['orders'] = array();
        $total_uom = 0;
        for ($i = 0; $i < count($order_ids); $i++) {
            $index = $order_ids[$i];
            $data['orders'][$index] = array(
                'order_id' => $index,
                'order_uom' => 0
            );
        }
        $get_charge_discription = $this->common->gettblrowdata(array('id' => $charge_code), "description", "tb_charge_codes", 0, 0);
        $charge_discription = "";
        if (!empty($get_charge_discription)) {
            $charge_discription = $get_charge_discription['description'];
        }
        $getvatcategory = $this->common->gettblrowdata(array('id' => $vat_category_id), "vat_category,vat_percentage", "tb_vat_category", 0, 0);
        $vat_percentage = 0;
        $vat_category = "";
        if (!empty($getvatcategory)) {
            $vat_category = $getvatcategory['vat_category'];
            $vat_percentage = $getvatcategory['vat_percentage'];
        }
        if ($select_uom != "" && !empty($order_ids)) {
            $get_cargo_uom = $this->consolidationmodel->get_cargo_uom($order_ids, $select_uom);
            if (!empty($get_cargo_uom)) {
                for ($i = 0; $i < count($get_cargo_uom); $i++) {
                    $index = $get_cargo_uom[$i]['order_id'];
                    $data['orders'][$index]['order_uom'] = $get_cargo_uom[$i]['total_uom'];
                    $total_uom += $get_cargo_uom[$i]['total_uom'];
                }
            }
        }
        if ($select_uom == "" && $distribution_basement == "GOODS VALUE") {
            $select_uom = "id,goods_value";
            $get_goods_value = $this->consolidationmodel->get_goods_value($order_ids, $select_uom);
            if (!empty($get_goods_value)) {
                for ($i = 0; $i < count($get_goods_value); $i++) {
                    $index = $get_goods_value[$i]['id'];
                    $data['orders'][$index]['order_uom'] = $get_goods_value[$i]['goods_value'];
                    $total_uom += $get_goods_value[$i]['goods_value'];
                }
            }
        }
        $invoice_date = $inv_createddate = $inv_receiveddate = '0000-00-00 00:00:00';
        if($vat_percentage == ""){
            $vat_percentage = 0;
        }
        if (!empty($order_ids)) {
            foreach ($order_ids as $order_id) {
                $each_order_uom = $data['orders'][$order_id]['order_uom'];
                $vat_amount = $amount_withoutvat = $total_amount = 0;
                if ($total_uom > 0 && $each_order_uom > 0 && $amount_distribute > 0) {
                    $amount_withoutvat = ($each_order_uom / $total_uom) *  ($amount_distribute);
                    $amount_withoutvat = round($amount_withoutvat, 4);
                    if (($vat_percentage > 0) && ($amount_withoutvat > 0)) {
                        $vat_amount = ($amount_withoutvat * $vat_percentage) / 100;
                    }
                    $vat_amount = round($vat_amount, 4);
                    $total_amount = $amount_withoutvat +  $vat_amount;
                    $revenue_data   = array(
                        'order_id' => $order_id,
                        'type' => $type,
                        'recipient_role' => $party_type,
                        'recipient_code' => $party_code,
                        'recipient_name' => $party_name,
                        'invoice_date' => $invoice_date,
                        'invoice_creation_date' => $inv_createddate,
                        'invoice_receivdon_date' => $inv_receiveddate,
                        'amount' => $total_amount,
                        'currency' => $distribution_currency,
                        'status' => 1,
                        'user_id' => $user_id,
                        'exchange_rate' => 0,
                        'invoice_status' => 0
                    );
                    $revenue_id = $this->common->insertTableData("tb_reveneus", $revenue_data);
                    if ($revenue_id > 0) {
                        $charge_data = array(
                            'revenue_id' => $revenue_id,
                            'charge_code' => $charge_code,
                            'description' => $charge_discription,
                            'quantity_unit' => '1',
                            'value' => '1',
                            'rate_id' => '1',
                            'amount' => $amount_withoutvat,
                            'currency' => $distribution_currency,
                            'local_amount' => $amount_withoutvat,
                            'local_currency' => $distribution_currency,
                            'local_vat_amount' => $vat_amount,
                            'local_total_amount' => $total_amount,
                            'vat_percentage' => $vat_percentage,
                            'vat_amount' => $vat_amount,
                            'total_amount' => $total_amount,
                            'cat_id' => $vat_category_id,
                            'cat_val' => $vat_category,
                            'status' => '1',
                            'user_id' => $user_id,
                            'source_created' => "MI - Manual Input"
                        );
                    }
                    $charge_id = $this->common->insertTableData("tb_charges", $charge_data);
                    if (($revenue_id > 0) && ($charge_id > 0)) {
                        $status = 1;
                    }
                }
            }
        }
        echo $status;
    }
}
