<?php
if ( ! defined( 'BASEPATH' ) ) {
    exit( 'No direct script access allowed' );
}

require_once APPPATH . "/third_party/PHPExcel.php";

class CollinsMassStatus extends CI_Controller {

    /**
     * Class Constructor
     */
    public function __construct() {
        parent::__construct();
        if (!$this->session->userdata( 'user_id' )) {
            redirect( 'login' );
        }
        $this->load->model( "common" );
        $this->load->library(["statusintigration", "etrucknowquote", "shippeostatusintigration", "Standard_status_execution","Altovaordercreation"]);
    }

    public function orderstatuses() {
        try {
            if ( $_FILES['import_file']['size'] > 0 ) {
                $data = [];

                // Load Sheet into Array
                $j             = 0;
                $inputFilename = $_FILES['import_file']['tmp_name'];

                $objPHPExcel = PHPExcel_IOFactory::load( $inputFilename );
                $sheetData   = $objPHPExcel->getActiveSheet()->toArray( NULL, TRUE, TRUE, TRUE );

                $counterData = count($sheetData);
                for ( $i = 2; $i <= $counterData; $i ++ ) {
                    if ( ! empty( $sheetData[ $i ]['A'] ) && ! empty( $sheetData[ $i ]['B'] ) && ! empty( $sheetData[ $i ]['C'] ) && ! empty( $sheetData[ $i ]['D'] ) ) {
                        #$data[$j]['trip_id'] = $sheetData[$i]['A'];
                        $data[ $j ]['order_id']    = $sheetData[ $i ]['A'];
                        $data[ $j ]['status_code'] = $sheetData[ $i ]['B'];

                        // $data[$j]['date'] = date('Y-m-d', strtotime($sheetData[$i]['D']));
                        // $data[$j]['time'] = date('H:i:s', strtotime($sheetData[$i]['E']));
                        $data[ $j ]['datetime'] = $sheetData[ $i ]['C'] . ' ' . $sheetData[ $i ]['D'];
                        $data[ $j ]['datetime'] = date( 'Y-m-d H:i:s', strtotime( str_replace( '/', '-', $data[ $j ]['datetime'] ) ) );
                        $j ++;
                    }
                }
               /* print_r($data);*/
                if ( count( $data ) > 0 ) {
                    foreach ( $data as $li ) {
                        $final = $this->processData( $li );
                        $count = count( $final );
                        for ( $k = 0; $k < $count; $k ++ ) {
                            if ( $final[0]['stop_type'] == 'P' && $final[0]['stsid'] == 35 && $k > 0 && $final[ $k ]['trip_id'] == 0 ) {
                                $tripinfo               = $this->common->gettblrowdata( array( 'id' => $final[0]['ord_id'] ), 'trip_id', 'tb_orders', 0, 0 );
                                $final[ $k ]['trip_id'] = $tripinfo['trip_id'];
                            }
                            $updateStatus=$this->update_order_status( $final[ $k ] );
                        }
                    }
                }
                
                redirect('admin/collinsMassStatus', 'refresh');
            }
        } catch ( \Exception $e ) {
            echo $e->getMessage();
        }
    }

    /**
     * Process Orders
     *
     * @param array $post
     */
    private function processData( $data ) {
        try {
            $j       = 0;
            $pdcnt   = 0;
            $gicnt   = 0;
            $gocnt   = 0;
            $stype   = "";
            $final   = array();
            $custord = $this->db->query(
                "SELECT
                        o.id,o.order_id,o.shift_id,o.trip_id,o.shipmentid,v.vehicle_id,a.driver_id,a.imei,d.
                        contact_num,d.track_type,d.track_vendor,d.sim_carrier
                    FROM tb_orders o,tb_shft_veh v,tb_vendors c,tbl_assigned_drivers a,tb_truck_drivers d
                    WHERE
                        o.shift_id=v.shft_id AND v.carrier_id=c.id AND v.vehicle_id=a.vehicle_id
                        AND a.driver_id=d.id AND v.status=1 AND a.status=1
                        AND d.status='Active' AND o.status!=0 AND o.shift_id >0
                        AND  o.trip_sts=0 AND o.order_id = ? ",
                [ $data['order_id'] ]
            );
            if ( $custord->num_rows() != 0 ) {
                $res         = $custord->row();
                $ship_id     = $res->shift_id;
                $multiship   = 0;
                $tripid      = $driver_id = 0;
                $vehicle_id  = $res->vehicle_id;
                $contact_num = "";
                $shipmentid  = $res->shipmentid;
                if ( $res->trip_id != 0 && $res->trip_id != "" ) {
                    $checktrip = $this->getQueryTripByShiftId($ship_id);
                    if ( $checktrip->num_rows() > 0 ) {
                        $contact_num = $checktrip->row()->start_imei;
                        $tripid      = $checktrip->row()->id;
                        $vehicle_id  = $checktrip->row()->vehicle_id;
                        $driver_id   = $checktrip->row()->driver_id;
                    }
                }
                if ( $tripid == 0 && $vehicle_id != "" ) {
                    $driver_id   = $res->driver_id;
                    $contact_num = $res->imei;
                }
                $tracktype   = 0;
                $trackvendor = $simcarrier = $contact_num = "";
                if ( $res->track_type == 1 ) {
                    $tracktype   = 1;
                    $trackvendor = $res->track_vendor;
                    $simcarrier  = $res->sim_carrier;
                    $contact_num = $res->contact_num;
                }
                $ordid    = $res->id;
                $order_id = $res->order_id;
                $refers   = array();
                $ref      = $this->db->query(
                    "SELECT reference_id,ref_value
                        FROM tb_order_references
                        WHERE order_id= ?
                          AND reference_id IN ('DQ','AAM','AWB','XSR','SD','INN') AND status=1 AND ref_value!='' ",
                    [ $ordid ] );

                if ( $ref->num_rows() > 0 ) {
                    $refers = $ref->result_array();
                }
                $saccept     = $sgatein = $spickup = $sgateout = $intransit = $dgatein = $dpickup = $dgateout = 0;
                $s_saccept   = $s_sgatein = $s_spickup = $s_sgateout = $s_intransit = $s_dgatein = $s_dpickup = $s_dgateout = 0;
                $s_sacceptcr = $s_sgateincr = $s_spickupcr = $s_sgateoutcr = $s_intransitcr = $s_dgateincr = $s_dpickupcr = $s_dgateoutcr = "";
                $pstpid      = $dstpid = $pstodetailid = $dstodetailid = "";

                $stopsts = $this->db->query(
                    "SELECT sm.id as sid,sm.status_name,ts.id,ts.stop_id,ts.stop_detail_id,ts.stop_type,ts.status_id,
                               ts.createdon as createdon
                        FROM tb_status_master sm
                            LEFT JOIN tb_stop_status ts ON sm.id=ts.status_id
                                AND ts.shipment_id= ? AND ts.order_id= ? AND ts.trip_id= ?
                                AND ts.status=1
                        WHERE sm.id IN (1,2,3,4,35)",
                    [ $ship_id, $ordid, $tripid ]
                );
                if ( $stopsts->num_rows() > 0 ) {
                    foreach ( $stopsts->result() as $st ) {
                        if ( $st->sid == 35 ) {
                            if ( $st->id != "" && $st->status_id == 35 ) {
                                $pstpid       = $st->stop_id;
                                $pstodetailid = $st->stop_detail_id;
                                $saccept      = $st->status_id;
                                $s_saccept    = 1;
                                $s_sacceptcr  = $st->createdon;
                                if ( $pstpid == "0" || $pstpid == "" ) {

                                    $chkq = $this->getQueryStopDetailsIdOnStopId($ship_id, $order_id);
                                    if ( $chkq->num_rows() > 0 ) {
                                        $pstpid       = $chkq->row()->id;
                                        $pstodetailid = $chkq->row()->stopdetailsid;
                                    }
                                }
                            } else {

                                $chkq = $this->getQueryStopDetailsIdOnStopId($ship_id, $order_id);
                                if ( $chkq->num_rows() > 0 ) {
                                    $pstpid       = $chkq->row()->id;
                                    $pstodetailid = $chkq->row()->stopdetailsid;
                                    $saccept      = $st->sid;
                                }
                            }
                        }
                        if ( $st->sid == 2 ) {
                            if ( $st->id != "" && $st->status_id == 2 && $st->stop_type === "P" ) {
                                $pstpid       = $st->stop_id;
                                $pstodetailid = $st->stop_detail_id;
                                $sgatein      = $st->status_id;
                                $s_sgatein    = 1;
                                $s_sgateincr  = $st->createdon;
                            } else {

                                $chkq = $this->getQueryStopDetailsIdOnStopOrDropId($ship_id, $order_id);
                                if ( $chkq->num_rows() > 0 ) {
                                    $pstpid       = $chkq->row()->id;
                                    $pstodetailid = $chkq->row()->stopdetailsid;
                                    $sgatein      = $st->sid;
                                }
                            }
                            if ( $st->id != "" && $st->status_id == 2 && $st->stop_type === "D" ) {
                                $dstpid       = $st->stop_id;
                                $dstodetailid = $st->stop_detail_id;
                                $dgatein      = $st->status_id;
                                $s_dgatein    = 1;
                                $s_dgateincr  = $st->createdon;
                            } else {

                                $chkq = $this->getQueryStopDetailsIdOnStopId($ship_id, $order_id);
                                if ( $chkq->num_rows() > 0 ) {
                                    $dstpid       = $chkq->row()->id;
                                    $dstodetailid = $chkq->row()->stopdetailsid;
                                    $dgatein      = $st->sid;
                                }
                            }
                        }
                        if ( $st->sid == 1 ) {
                            if ( $st->id != "" && $st->status_id == 1 && $st->stop_type == "P" ) {
                                $pstpid       = $st->stop_id;
                                $pstodetailid = $st->stop_detail_id;
                                $spickup      = $st->status_id;
                                $s_spickup    = 1;
                                $s_spickupcr  = $st->createdon;
                            } else {
                                $chkq = $this->getQueryStopDetailsIdOnStopId($ship_id, $order_id);
                                if ( $chkq->num_rows() > 0 ) {
                                    $pstpid       = $chkq->row()->id;
                                    $pstodetailid = $chkq->row()->stopdetailsid;
                                    $spickup      = $st->sid;
                                }
                            }
                            if ( $st->id != "" && $st->status_id == 1 && $st->stop_type == "D" ) {
                                $dstpid       = $st->stop_id;
                                $dstodetailid = $st->stop_detail_id;
                                $dpickup      = $st->status_id;
                                $s_dpickup    = 1;
                                $s_dpickupcr  = $st->createdon;
                            } else {

                                $chkq = $this->getQueryStopDetailsIdOnDropStopId($ship_id, $order_id);
                                if ( $chkq->num_rows() > 0 ) {
                                    $dstpid       = $chkq->row()->id;
                                    $dstodetailid = $chkq->row()->stopdetailsid;
                                    $dpickup      = $st->sid;
                                }
                            }
                        }
                        if ( $st->sid == 3 ) {
                            if ( $st->id != "" && $st->status_id == 3 && $st->stop_type == "P" ) {
                                $pstpid       = $st->stop_id;
                                $pstodetailid = $st->stop_detail_id;
                                $sgateout     = $st->status_id;
                                $s_sgateout   = 1;
                                $s_sgateoutcr = $st->createdon;
                            } else {

                                $chkq = $this->getQueryStopDetailsIdOnStopId($ship_id, $order_id);

                                if ( $chkq->num_rows() > 0 ) {
                                    $pstpid       = $chkq->row()->id;
                                    $pstodetailid = $chkq->row()->stopdetailsid;
                                    $sgateout     = $st->sid;
                                }
                            }
                            if ( $st->id != "" && $st->status_id == 3 && $st->stop_type == "D" ) {
                                $dstpid       = $st->stop_id;
                                $dstodetailid = $st->stop_detail_id;
                                $dgateout     = $st->status_id;
                                $s_dgateout   = 1;
                                $s_dgateoutcr = $st->createdon;
                            } else {
                                $chkq = $this->getQueryStopDetailsIdOnDropStopId($ship_id, $order_id);
                                if ( $chkq->num_rows() > 0 ) {
                                    $dstpid       = $chkq->row()->id;
                                    $dstodetailid = $chkq->row()->stopdetailsid;
                                    $dgateout     = $st->sid;
                                }
                            }
                        }
                        if ( $st->sid == 4 ) {
                            if ( $st->id != "" && $st->status_id == 4 ) {
                                $pstpid        = $st->stop_id;
                                $pstodetailid  = $st->stop_detail_id;
                                $intransit     = $st->status_id;
                                $s_intransit   = 1;
                                $s_intransitcr = $st->createdon;
                            } else {

                                $chkq = $this->getQueryStopDetailsIdOnStopId($ship_id, $order_id);

                                if ( $chkq->num_rows() > 0 ) {
                                    $pstpid       = $chkq->row()->id;
                                    $pstodetailid = $chkq->row()->stopdetailsid;
                                    $intransit    = $st->sid;
                                }
                            }
                        }
                    }
                } else {
                    $emp = $this->db->query(
                        "SELECT s.id,s.stoptype,s.ordernumber,e.id as stopdetailsid,s.status
                                FROM tb_shiporder_stops s,tb_employee e
                                WHERE s.shipment_id= ? AND s.status=1 AND s.id=e.stop_id AND e.status=1
                                    AND e.shift_id= ? AND e.order_id= ?
                            UNION
                            SELECT s.id,s.stoptype,s.ordernumber,e.id as stopdetailsid,s.status
                                FROM tb_shiporder_stops s,tb_employee e
                                WHERE s.shipment_id= ? AND s.status=1 AND s.id=e.drop_stopid AND e.status=1
                                    AND e.shift_id= ? AND e.order_id= ?
                                ORDER BY ordernumber ASC ",
                        [ $ship_id, $ship_id, $order_id, $ship_id, $ship_id, $order_id ]
                    );
                    if ( $emp->num_rows() > 0 ) {
                        foreach ( $emp->result_array() as $res1 ) {
                            if ( $res1['stoptype'] == "P" ) {
                                $saccept      = 35;
                                $sgatein      = 2;
                                $spickup      = 1;
                                $sgateout     = 3;
                                $intransit    = 4;
                                $pstpid       = $res1['id'];
                                $pstodetailid = $res1['stopdetailsid'];
                            }
                            if ( $res1['stoptype'] == "D" ) {
                                $dgatein      = 2;
                                $dpickup      = 1;
                                $dgateout     = 3;
                                $dstpid       = $res1['id'];
                                $dstodetailid = $res1['stopdetailsid'];
                            }
                        }
                    }
                }

                $stype = strtoupper( $data['status_code'] );
                $stsid = 1;
                /*  $data['tripsdata'] = array("trip_id"=>$tripid,"ship_id"=>$ship_id,"ord_id"=>$ordid,"shipmentid"=>$shipmentid,"order_id"=>$res->order_id,"refers"=>$refers,"saccept"=>$saccept,"sgatein"=>$sgatein,"spickup"=>$spickup,"sgateout"=>$sgateout,"intransit"=>$intransit,"dgatein"=>$dgatein,"dpickup"=>$dpickup,"dgateout"=>$dgateout,"s_saccept"=>$s_saccept,"s_sgatein"=>$s_sgatein,"s_spickup"=>$s_spickup,"s_sgateout"=>$s_sgateout,"s_intransit"=>$s_intransit,"s_dgatein"=>$s_dgatein,"s_dpickup"=>$s_dpickup,"s_dgateout"=>$s_dgateout,"s_sacceptcr"=>$s_sacceptcr,"s_sgateincr"=>$s_sgateincr,"s_spickupcr"=>$s_spickupcr,"s_sgateoutcr"=>$s_sgateoutcr,"s_intransitcr"=>$s_intransitcr,"s_dgateincr"=>$s_dgateincr,"s_dpickupcr"=>$s_dpickupcr,"s_dgateoutcr"=>$s_dgateoutcr,"pstpid"=>$pstpid,"dstpid"=>$dstpid,"pstodetailid"=>$pstodetailid,"dstodetailid"=>$dstodetailid,"vehicle_id"=>$vehicle_id,"driver_id"=>$driver_id,"tracktype"=>$tracktype,"trackvendor"=>$trackvendor,"simcarrier"=>$simcarrier,"contact_num"=>$contact_num,"multiship"=>$multiship,'order_id'=>$order_id); */
                $info['trip_id']     = $tripid;
                $info['ship_id']     = $ship_id;
                $info['ord_id']      = $ordid;
                $info['orderid']     = $data['order_id'];
                $info['stopid']      = $pstpid;
                $info['stopdetid']   = $pstodetailid;
                $info['vehicle_id']  = $vehicle_id;
                $info['driver_id']   = $driver_id;
                $info['tracktype']   = $tracktype;
                $info['trackvendor'] = $trackvendor;
                $info['contact_num'] = $contact_num;
                $info['stop_type']   = $stype;
                $info['stsid']       = $stsid;
                $info['status']      = 0;
                $info['sts_date']    = date( 'Y-m-d H:i:s', strtotime( $data['datetime'] ) );
                if ( $stype == 'P' ) {
                    if ( $s_saccept == 0 ) { //accept check
                        $final[ $j ]             = $info;
                        $final[ $j ]['sts_date'] = date( 'Y-m-d H:i:s', strtotime( $info['sts_date'] . '-60 minutes' ) );
                        $final[ $j ]['stsid']    = 35; //Accept
                        $j ++;
                    }
                    if ( $s_sgatein == 0 ) { // gate in check
                        $final[ $j ]             = $info;
                        $final[ $j ]['sts_date'] = date( 'Y-m-d H:i:s', strtotime( $info['sts_date'] . '-30 minutes' ) );
                        $final[ $j ]['stsid']    = 2; // gate in for source
                        $j ++;
                    }
                    if ( $s_spickup == 0 ) {
                        $final[ $j ] = $info;
                        $j ++;
                    }
                    if ( $this->session->userdata( 'company_code' ) == 'VNKN' ) {
                        if ( $s_sgateout == 0 ) { //gateout check
                            $final[ $j ]              = $info;
                            $final[ $j ]['sts_date']  = date( 'Y-m-d H:i:s', strtotime( $info['sts_date'] . '+30 minutes' ) );//accept status

                            $final[ $j ]['stsid']     = 3;
                            $final[ $j ]['stop_type'] = 'P'; // gateout
                            $j ++;
                        }
                        if ( $s_intransit == 0 ) { //In-transit
                            $final[ $j ]              = $info;
                            $final[ $j ]['sts_date']  = date( 'Y-m-d H:i:s', strtotime( $info['sts_date'] . '+60 minutes' ) );//accept status
                            $final[ $j ]['stsid']     = 4; // In-transit
                            $final[ $j ]['stop_type'] = 'P';
                            $j ++;
                        }
                    }
                }
                if ( $stype == 'D' ) {
                    if ( $this->session->userdata( 'company_code' ) != 'VNKN' ) {
                        if ( $s_sgateout == 0 ) { //gateout check
                            $final[ $j ]             = $info;
                            $final[ $j ]['sts_date'] = date( 'Y-m-d H:i:s', strtotime( $info['sts_date'] . '-90 minutes' ) );//accept status
                            $final[ $j ]['stsid']     = 3;
                            $final[ $j ]['stop_type'] = 'P'; // gateout
                            $j ++;
                        }
                        if ( $s_intransit == 0 ) { //In-transit
                            $final[ $j ]             = $info;
                            $final[ $j ]['sts_date'] = date( 'Y-m-d H:i:s', strtotime( $info['sts_date'] . '-60 minutes' ) );//accept status
                            $final[ $j ]['stsid']     = 4; // In-transit
                            $final[ $j ]['stop_type'] = 'P';
                            $j ++;
                        }
                    }
                    if ( $s_dgatein == 0 ) { //gate in
                        $final[ $j ]              = $info;
                        $final[ $j ]['sts_date']  = date( 'Y-m-d H:i:s', strtotime( $info['sts_date'] . '-30 minutes' ) );//accept status
                        $final[ $j ]['stsid']     = 2; // gate in
                        $final[ $j ]['stop_type'] = 'D';
                        $final[ $j ]['stopdetid'] = $dstodetailid;
                        $final[ $j ]['stopid']    = $dstpid;
                        $j ++;
                    }

                    if ( $s_dpickup == 0 ) {
                        $final[ $j ]              = $info;
                        $final[ $j ]['stopdetid'] = $dstodetailid;
                        $final[ $j ]['stopid']    = $dstpid;
                        $j ++;
                    }
                }
            }

            return $final;
        } catch ( \Exception $e ) {
            echo $e->getMessage();
        }
    }

	private function updaterOderExcelStatus($final)
	{
		$arr = array();
		$trip_id = $arr['trip'] = $final['trip_id'];
		$shipId = $arr['ship'] = $final['ship_id'];
		$ordId = $arr['ord_id'] = $final['ord_id'];
		$orderid = $arr['orderid'] = $final['orderid'];
		$stopId = $arr['stopid'] = $final['stopid'];
		$stopDetailId = $arr['stopdetailid'] = $final['stopdetid'];
		$vehicleId = $arr['vehicle_id'] = $final['vehicle_id'];
		$driverId = $arr['driver_id'] = $final['driver_id'];
		$trackType = $arr['tracktype'] = $final['tracktype'];
		$trackVendor = $arr['trackvendor'] = $final['trackvendor'];
		$contactNum = $arr['contact_num'] = $final['contact_num'];
		$sType = $final['stop_type'];
		$stsId = $final['stsid'];
		$sts = $final['status'];
		$curTz = $this->session->userdata("usr_tzone")['timezone'];
		$selDt = $final['sts_date'];
		if (checkstsvaliddate($selDt)) {
			$gentime = getdatetimebytimezone(DFLT_TZ, $selDt, $curTz);
			$stsDate = $gentime['datetime'];
		} else {
			$stsDate = "";
		}
		$logdate = date('Y-m-d H:i:s');
		$getactual = getdatetimebytimezone(DFLT_TZ, $logdate, $curTz);
		$curdt = $getactual['datetime'];
		$hrs = $this->session->userdata("usr_tzone")['hrs'];
		$lgusrid = $this->session->userdata("user_id");
		$latiTude = $longiTude = "";
		$createdSource = "";
		$plat = $plng = $dlat = $dlng = "";
		$chkCs = $this->db->select("plat,plng,dlat,dlng,created_source")->get_where("tb_orders", ["id" => $ordId], 1, 0);
		if ($chkCs->num_rows() > 0) {
			$createdSource = $chkCs->row()->created_source;
			if ($chkCs->row()->plat != "") {
				$plat = $chkCs->row()->plat;
				$plng = $chkCs->row()->plng;
			} else {
				$chklatlng = $this->db->select("latitude,longitude")->get_where("tb_site_settings", ["user_id" => $lgusrid], 1, 0);
				if ($chklatlng->num_rows() > 0) {
					$plat = $chklatlng->row()->latitude;
					$plng = $chklatlng->row()->longitude;
				}
			}
			if ($chkCs->row()->dlat != "") {
				$dlat = $chkCs->row()->dlat;
				$dlng = $chkCs->row()->dlng;
			} else {
				$chklatlng = $this->db->select("latitude,longitude")->get_where("tb_site_settings", ["user_id" => $lgusrid], 1, 0);
				if ($chklatlng->num_rows() > 0) {
					$dlat = $chklatlng->row()->latitude;
					$dlng = $chklatlng->row()->longitude;
				}
			}
		}
		$tripid = $trip_id;
		$chkarr = [];
		$resultsts = 2;
		if ($stsDate != "" && $sts == "0") {
			$stId = $stsId;
			if ($stsId == "35") {
				$stcode = "1600";
			}
			if ($stsId == "2" && $sType == "P") {
				$stcode = "0420";
			}
			if ($stsId == "1" && $sType == "P") {
				$stcode = "0500";
			}
			if ($stsId == "3" && $sType == "P") {
				$stcode = "0191";
			}
			if ($stsId == "4") {
				$stcode = "1550";
			}
			if ($stsId == "2" && $sType == "D") {
				$stcode = "0192";
			}
			if ($stsId == "1" && $sType == "D") {
				$stcode = "2300";
			}
			if ($stsId == "3" && $sType == "D") {
				$stcode = "3000";
			}
			if ($stsId == "11") {
				$stcode = "0218";
			}
			/*start trip*/
			$chQry = $this->db->select("id")->get_where("tb_trips", ['shift_id' => $arr['ship'], 'vehicle_id' => $arr['vehicle_id'], 'driver_id' => $arr['driver_id']], 1, 0);
			if ($chQry->num_rows() == 0) {

				if ($arr['contact_num'] == "") {
					$newimei = $this->db->select("imei")->get_where("tbl_assigned_drivers", ['vehicle_id' => $arr['vehicle_id'], 'driver_id' => $arr['driver_id'], 'status' => 1], 1, 0);
					if ($newimei->num_rows() > 0) {
						$arr['contact_num'] = $newimei->row()->imei;
					}
				}
				$latiTude = $plat;
				$longiTude = $plng;
				$triparr = [
					'shift_id' => $arr['ship'],
					'vehicle_id' => $arr['vehicle_id'],
					'driver_id' => $arr['driver_id'],
					'stime' => $stsDate,
					'start_imei' => $arr['contact_num'],
					'splace' => "",
					'eplace' => "",
					'start_reading' => 0,
					'end_reading' => 0,
					'created_on' => $stsDate,
					'updated_on' => $curdt,
					'status' => 1,
					'trip_type' => 0,
					'transit_status' => 0,
					"plat" => $latiTude,
					"plng" => $longiTude
				];
				$arr['trip'] = $this->common->insertTableData('tb_trips', $triparr);
				$insArry = ["shipment_id" => $arr['ship'],
					"stop_id" => 0,
					"order_id" => $ordId,
					"stop_detail_id" => 0,
					"stop_type" => "",
					"trip_id" => $arr['trip'],
					"status_id" => $stId,
					"latitude" => $latiTude,
					"longitude" => $longiTude,
					"status" => 1,
					"reason" => "From Admin",
					"vehicle_id" => $arr['vehicle_id'],
					"driver_id" => $arr['driver_id'],
					"status_code" => $stcode,
					"createdon" => $stsDate
				];
				$ins = $this->db->insert("tb_stop_status", $insArry);
				/* update orders table */
				$ordwhr = ["shift_id" => $arr['ship']];
				$ordset = ["trip_id" => $arr['trip']];
				$upd = $this->db->set($ordset)->where($ordwhr)->update("tb_orders");
				$postData = [
					"shipment_id" => $arr['ship'],
					"trip_id" => $arr['trip'],
					"driver_id" => $arr['driver_id'],
					"vehicle_id" => $arr['vehicle_id'],
					"order_id" => $arr['orderid'],
					"user_id" => $lgusrid,
					"stop_id" => '',
					"latitude" => $latiTude,
					"longitude" => $longiTude,
					"curtz" => $curTz,
					"hrs" => $hrs,
					"web" => $selDt,
					"status_code" => $stcode,
					"ord_id" => $ordId,
				];
				/*send to roadlog*/
				if ($createdSource == "18") {
					$sts = $this->statusintigration->roadlogshipmentconfirm($postData);
				} elseif ($createdSource == "5") {
				} elseif ($createdSource == "9") {
					$sts = $this->etrucknowquote->getstatusresponse($postData);
				} elseif ($createdSource == "8") {
					$curTz = $this->session->userdata("usr_tzone")['timezone'];
					$logdate = date('Y-m-d H:i:s');
					$getactual = getdatetimebytimezone(DFLT_TZ, $logdate, $curTz);
					$cur_date = $getactual['datetime'];
					$postData['date_transmission'] = $cur_date;
					$postData["truck_number"] = $this->getTruckNumberById($arr['vehicle_id']);

					if ($stId == "35") {
						// Driver Accept
						$postData['situation_code'] = 'EML';
						$postData['justification_code'] = 'CFM';
						$sts = $this->shippeostatusintigration->shippeoStatusUpdate($postData);
					}
					if ($stId == "2" && $sType == "P") {
						// GATEIN
						$postData['situation_code'] = 'EML';
						$postData['justification_code'] = 'ARS';
						$sts = $this->shippeostatusintigration->shippeoStatusUpdate($postData);
					}
					if ($stId == "1" && $sType == "P") {
						// GATEIN PICKUP
						$postData['situation_code'] = 'ECH';
						$postData['justification_code'] = 'CFM';
						$sts = $this->shippeostatusintigration->shippeoStatusUpdate($postData);
					}
					if ($stId == "4" && $sType == "P") {
						// In-Transit
						$postData['situation_code'] = 'MLV';
						$postData['justification_code'] = 'CFM';
						$sts = $this->shippeostatusintigration->shippeoStatusUpdate($postData);
					}
					if ($stId == "1" && $sType == "D") {
						// Destination - delivery
						$postData['situation_code'] = 'LIV';
						$postData['justification_code'] = 'CFM';
						$sts = $this->shippeostatusintigration->shippeoStatusUpdate($postData);
					}
					if ($stId == "3" && $sType == "D") {
						// Destination - Gateout
						$postData['situation_code'] = 'LIV';
						$postData['justification_code'] = 'DES';
						$sts = $this->shippeostatusintigration->shippeoStatusUpdate($postData);
					}
				}

				$this->sendnotify('driver_accept', $arr['ord_id']);
				if ($lgusrid == "17") {
					$chkven = $this->db->select("vendor_id")->get_where("tb_shifts", ["id" => $arr['ship']], 1, 0);
					if ($chkven->num_rows() > 0) {
						if ($chkven->row()->vendor_id == "143") {
							$getcsvfile = $this->getcsvfile($arr['orderid']);
						}
					}
				}
			}else{
                $arr['trip'] = $chQry->row()->id;
            }
			$resultsts = 1;
			if ($arr['trip'] > 0) {
				$triplId = $arr['trip'];
				$chqry = $this->db->select("id")->get_where("tb_stop_status", ["order_id" => $ordId, "shipment_id" => $arr['ship'], "stop_id" => $stopId, "stop_detail_id" => $stopDetailId, "stop_type" => $sType, "trip_id" => $arr['trip'], "status_id" => $stId, 'status' => '1'], 1, 0);
				if ($chqry->num_rows() == 0) {
					if ($stId == "2" && $sType == "P") {
						$ttdata = array("id" => $triplId);
						$data2["updated_on"] = $curdt;
						$data2["transit_status"] = '1';
						$res = $this->db->set($data2)->where($ttdata)->update("tb_trips");
					}
					if ($sType == "P" || $stId == "4") {
						$latiTude = $plat;
						$longiTude = $plng;
					}
					if ($sType == "D") {
						$latiTude = $dlat;
						$longiTude = $dlng;
					}
					$checkStatusId = $this->db->query(
                        "SELECT id
                                FROM tb_stop_status
                                WHERE order_id= ? AND status_id= ? AND status_code= ? ",
                        [ $ordId, $stId, $stcode ]
                    );
					if ($checkStatusId->num_rows() == 0) {
						$stcode = !empty($stcode) ? $stcode : '';
						$insArry = ["shipment_id" => $arr['ship'],
							"stop_id" => $stopId,
							"order_id" => $ordId,
							"stop_detail_id" => $stopDetailId,
							"stop_type" => $sType,
							"trip_id" => $triplId,
							"status_id" => $stId,
							"latitude" => $latiTude,
							"longitude" => $longiTude,
							"status" => 1,
							"reason" => "From Admin",
							"vehicle_id" => $arr['vehicle_id'],
							"driver_id" => $arr['driver_id'],
							"status_code" => $stcode,
							"createdon" => $stsDate
						];
						$ins = $this->db->insert("tb_stop_status", $insArry);
                        if ($stsId == "11") {
                            if (checkAccessConditions('RELATED_TO_KPIREPORTS', $this->session->userdata('company_code'))) {
                                $this->load->library("kpireportinsertion");
                                $this->kpireportinsertion->insertDataIntoKpiReports($ordId);
                            }
                        }
					}
					$chQry1 = $this->db->select("id")->get_where("tb_trip_employee", ["employee_id" => $stopDetailId, "stop_id" => $stopId, "trip_id" => $triplId, "status" => 1], 1, 0);
					if ($chQry1->num_rows() == 0) {
						$insArr = ["employee_id" => $stopDetailId, "stop_id" => $stopId, "trip_id" => $triplId, "status" => 1, 'driver_late' => 0, 'emp_late' => 0, 'stime' => $curdt, 'check_in' => $curdt, 'absent_reason' => 'Closed', 'created_on' => $curdt, 'updated_on' => $curdt, 'pd_status' => 1];
						$ins = $this->db->insert("tb_trip_employee", $insArr);
					}
					$postData = [
						"shipment_id" => $arr['ship'],
						"trip_id" => $triplId,
						"driver_id" => $arr['driver_id'],
						"stop_id" => $stopId,
						"order_id" => $arr['orderid'],
						"inc_id" => 0,
						"pod_type" => '',
						"latitude" => $latiTude,
						"longitude" => $longiTude,
						"stop_type" => $sType,
						"vehicle_id" => $arr['vehicle_id'],
						"curtz" => $curTz,
						"hrs" => $hrs,
						"web" => $selDt,
						"status_code" => $stcode,
						"ord_id" => $ordId,
					];
                    $companyCode = $this->session->userdata('company_code');
                    $checkStatus = "RELATED_2_" . $companyCode . "_CONSIGNEE_NOTIFICATION_STATUSES";
                    if (checkAccessConditions('RELATED_2_CONSIGNEE_NOTIFICATION', $companyCode) && checkAccessConditions($checkStatus, $stcode)) {
                        $this->load->library('notifytrigger');
                        $this->notifytrigger->sendNotificationToConsignee($ordId, $stcode);
                    }
                    if ($stcode != "1600") {
                        try {
                            $statusPayload = [
                                "trip" => $trip_id,
                                "ship" => $arr['ship'],
                                "ord_id" => $ordId,
                                "orderid" => $arr['orderid'],
                                "stop_id" => 0,
                                "stop_detail_id" => 0,
                                "vehicle_id" => $arr['vehicle_id'],
                                "driver_id" => $arr['driver_id'],
                                "stop_type" => "P",
                                "timezone" => $curTz,
                                "sts_date" => $stsDate,
                                "status_code" => $stcode
                            ];
                            $this->standard_status_execution->sendStandardXMLtoAltova($statusPayload);
                            $this->altovaordercreation->sendOrderToAltova($ordId, $stcode);
                        } catch (Exception $ex) {
                            log_message("error", "Some Problem occured!, While Sending Order Status to Altova " . $ex->getMessage());
                        }
                    }
					if ($createdSource == "18") {
						if ($stId == "4") {
							/*$sts = $this->statusintigration->shipmentintransit($postData);*/
							/*send to roadlog*/
							$sts = $this->statusintigration->roadlogshipmentintransit($postData);
						}
						if ($stId == "2" && $sType == "P") {
							/*$sts = $this->statusintigration->shipmentorderpicked($postData);*/
							$sts = $this->statusintigration->roadlogshipmentpgatein($postData);
						}
						if ($stId == "1" && $sType == "P") {
							/*$sts = $this->statusintigration->shipmentorderpicked($postData);*/
							$sts = $this->statusintigration->roadlogshipmentpicked($postData);
							$this->sendnotify('pickup_note', $arr['ord_id']);
						}
						if ($stId == "3" && $sType == "P") {
							/*send to roadlog*/
							$sts = $this->statusintigration->roadlogshipmentpgateout($postData);
						}
						if ($stId == "2" && $sType == "D") {
							/*$sts = $this->statusintigration->shipmentorderpicked($postData);*/
							$sts = $this->statusintigration->roadlogshipmentdgatein($postData);
						}
						if ($stId == "1" && $sType == "D") {
							/*$sts = $this->statusintigration->shipmentdelivered($postData);*/
							/*send to roadlog*/
							$this->sendnotify('delivery_note', $arr['ord_id']);
							$sts = $this->statusintigration->roadlogshipmentdelivered($postData);
						}
					} elseif ($createdSource == "5") {
						if ($stId == "1" && $sType == "D") {
							$sts = $this->statusintigration->salogshipmentstatus($postData);
							$this->sendnotify('delivery_note', $arr['ord_id']);
						}
						if ($stId == "1" && $sType == "P") {
							$sts = $this->statusintigration->salogshipmentstatus($postData);
							$this->sendnotify('pickup_note', $arr['ord_id']);
						}
					} elseif ($createdSource == '9') {
						if ($stId == '4' || ($stId == "1" && $sType == "P") || ($stId == "3" && $sType == "D")) {
							$postData['user_id'] = $lgusrid;
							if ($stId == "1" && $sType == "P") {
								$this->sendnotify('pickup_note', $arr['ord_id']);
							}
							if ($stId == "1" && $sType == "D") {
								$this->sendnotify('delivery_note', $arr['ord_id']);
							}
							$sts = $this->etrucknowquote->getstatusresponse($postData);
						}
					} elseif ($createdSource == "8") {
						$curTz = $this->session->userdata("usr_tzone")['timezone'];
						$logdate = date('Y-m-d H:i:s');
						$getactual = getdatetimebytimezone(DFLT_TZ, $logdate, $curTz);
						$cur_date = $getactual['datetime'];
						$postData['date_transmission'] = $cur_date;
						$postData["truck_number"] = $this->getTruckNumberById($arr['vehicle_id']);
						if ($stId == "35") {
							// Driver Accept
							$postData['situation_code'] = 'EML';
							$postData['justification_code'] = 'CFM';
							$sts = $this->shippeostatusintigration->shippeoStatusUpdate($postData);
						}
						if ($stId == "2" && $sType == "P") {
							// GATEIN
							$postData['situation_code'] = 'EML';
							$postData['justification_code'] = 'ARS';
							$sts = $this->shippeostatusintigration->shippeoStatusUpdate($postData);
						}
						if ($stId == "1" && $sType == "P") {
							// GATEIN PICKUP
							$postData['situation_code'] = 'ECH';
							$postData['justification_code'] = 'CFM';
							$sts = $this->shippeostatusintigration->shippeoStatusUpdate($postData);
						}
						if ($stId == "4" && $sType == "P") {
							// In-Transit
							$postData['situation_code'] = 'MLV';
							$postData['justification_code'] = 'CFM';
							$sts = $this->shippeostatusintigration->shippeoStatusUpdate($postData);
						}
						if ($stId == "1" && $sType == "D") {
							// Destination - delivery
							$postData['situation_code'] = 'LIV';
							$postData['justification_code'] = 'CFM';
							$sts = $this->shippeostatusintigration->shippeoStatusUpdate($postData);
						}
						if ($stId == "3" && $sType == "D") {
							// Destination - Gateout
							$postData['situation_code'] = 'LIV';
							$postData['justification_code'] = 'DES';
							$sts = $this->shippeostatusintigration->shippeoStatusUpdate($postData);
						}
					}
					if ($stId == "3" && $sType == "D") {
						if ($createdSource == "5") {
							$sts = $this->statusintigration->salogshipmentstatus($postData);
						}
						$sts = $this->sendepodgateoutnotify($postData);
						$this->sendnotify('delivery_note', $arr['ord_id']);
					}
					$resultsts = 1;
                    $checkCloseStatusId = $this->db->query("SELECT status_id FROM tb_stop_status WHERE order_id= ? AND trip_id= ? AND status_code= ? ", [$ordId,$triplId,'0218']);
                    if ($checkCloseStatusId->num_rows() > 0) {
                        $statusId = $checkCloseStatusId->row()->status_id;
                        if ($statusId == 11) {
                            $postData = [
                                "shipment_id" => $arr['ship'],
                                "trip_id" => $arr['trip'],
                                "driver_id" => $arr["driver_id"],
                                "stop_id" => '',
                                "order_id" => $arr['orderid'],
                                "latitude" => $latiTude,
                                "longitude" => $longiTude,
                                "curtz" => $curTz,
                                "hrs" => $hrs,
                                "web" => $selDt,
                            ];
                            /*send to roadlog*/
                            if ($createdSource == "18") {
                                $sts = $this->statusintigration->roadlogshipmenttripdelivered($postData);
                            }
                            if ($arr['ship'] > 0) {
                                $chkMulitiple = $this->db->select("id")->get_where("tb_orders", ["shift_id" => $arr['ship'], "trip_sts" => '0']);
                                if ($chkMulitiple->num_rows() > 1) {
                                    $upd = $this->db->where(["id" => $ordId, "trip_id !=" => 0])->update("tb_orders", ["trip_sts" => '1']);
                                } else {
                                    $updwhr = ["id" => $arr['ship']];
                                    $upddata = ["status" => '0', "updated_on" => $curdt];
                                    $upd = $this->db->set($upddata)->where($updwhr)->update("tb_shifts");
                                    $data1 = [];
                                    $tdata = ["id" => $triplId];
                                    $data1["end_imei"] = $arr['contact_num'];
                                    $data1["end_reading"] = '0';
                                    $data1["etime"] = $data1["updated_on"] = $curdt;
                                    $data1["status"] = '0';
                                    $data1["transit_status"] = '1';
                                    $res = $this->db->set($data1)->where($tdata)->update("tb_trips");
                                    $upd = $this->db->where(["shift_id" => $arr['ship']])->update("tb_orders", ["trip_sts" => '1']);
                                }
                            }
                        }
                    }
                }
            }
        }

		return $resultsts;
	}

    private function update_order_status( $final ) {
        /*  log_message("error","update_order_status".json_encode($final));*/
      /*  print_r($final);exit;*/
        $arr          = array();
        $trip_id      = $arr['trip'] = $final['trip_id'];
        $ship_id      = $arr['ship'] = $final['ship_id'];
        $ord_id       = $arr['ord_id'] = $final['ord_id'];
        $orderid      = $arr['orderid'] = $final['orderid'];
        $stopid       = $arr['stopid'] = $final['stopid'];
        $stopdetailid = $arr['stopdetailid'] = $final['stopdetid'];
        $vehicle_id   = $arr['vehicle_id'] = $final['vehicle_id'];
        $driver_id    = $arr['driver_id'] = $final['driver_id'];
        $tracktype    = $arr['tracktype'] = $final['tracktype'];
        $trackvendor  = $arr['trackvendor'] = $final['trackvendor'];
        $contact_num  = $arr['contact_num'] = $final['contact_num'];
        $stype        = $final['stop_type'];
        $stsid        = $final['stsid'];
        $sts          = $final['status'];
        $curtz        = $this->session->userdata( "usr_tzone" )['timezone'];
        $seldt        = $final['sts_date'];
        if ( checkstsvaliddate( $seldt ) ) {
            $gentime = getdatetimebytimezone( DFLT_TZ, $seldt, $curtz );
            $stsdate = $gentime['datetime'];
        } else {
            $stsdate = "";
        }
        $logdate = date('Y-m-d H:i:s');
        $getactual = getdatetimebytimezone(DFLT_TZ, $logdate, $curtz);
        $curdt = $getactual['datetime'];
        $hrs = $this->session->userdata("usr_tzone")['hrs'];
        $lgusrid = $this->session->userdata("user_id");
        $companyCode = $this->session->userdata("company_code");
        $latitude = $longitude = "";
        $createdSource = "";
        $plat          = $plng = $dlat = $dlng = "";
        $chkcs         = $this->db->select( "plat,plng,dlat,dlng,created_source" )->get_where( "tb_orders", array( "id" => $ord_id ), 1, 0 );
        if ( $chkcs->num_rows() > 0 ) {
            $createdSource = $chkcs->row()->created_source;
            if ( $chkcs->row()->plat != "" ) {
                $plat = $chkcs->row()->plat;
                $plng = $chkcs->row()->plng;
            } else {
                $chklatlng = $this->db->select( "latitude,longitude" )->get_where( "tb_site_settings", array( "user_id" => $lgusrid ), 1, 0 );
                if ( $chklatlng->num_rows() > 0 ) {
                    $plat = $chklatlng->row()->latitude;
                    $plng = $chklatlng->row()->longitude;
                }
            }
            if ( $chkcs->row()->dlat != "" ) {
                $dlat = $chkcs->row()->dlat;
                $dlng = $chkcs->row()->dlng;
            } else {
                $chklatlng = $this->db->select( "latitude,longitude" )->get_where( "tb_site_settings", array( "user_id" => $lgusrid ), 1, 0 );
                if ( $chklatlng->num_rows() > 0 ) {
                    $dlat = $chklatlng->row()->latitude;
                    $dlng = $chklatlng->row()->longitude;
                }
            }
        }
        $tripid    = $trip_id;
        $chkarr    = array();
        $resultsts = 2;
        /* log_message("error","stsdate ".json_encode($stsdate));
        log_message("error","sts ".json_encode($sts));*/
        if ( $stsdate != "" && $sts == "0" ) {
            $stid = $stsid;
            if ( $stsid == "35" ) {
                $stcode = "1600";
            }
            if ( $stsid == "2" && $stype == "P" ) {
                $stcode = "0420";
            }
            if ( $stsid == "1" && $stype == "P" ) {
                $stcode = "0500";
            }
            if ( $stsid == "3" && $stype == "P" ) {
                $stcode = "0191";
            }
            if ( $stsid == "4" ) {
                $stcode = "1550";
            }
            if ( $stsid == "2" && $stype == "D" ) {
                $stcode = "0192";
            }
            if ( $stsid == "1" && $stype == "D" ) {
                $stcode = "2300";
            }
            if ( $stsid == "3" && $stype == "D" ) {
                $stcode = "3000";
            }
            if ( $stsid == "11" ) {
                $stcode = "0218";
            }
            /* log_message("error","stsid ".json_encode($stsid));
            log_message("error","trip ".json_encode($arr['trip']));*/
           if ($stsid == "35" && (empty($arr['trip']) || $arr['trip'] == "0")) {

                $stcode = "1600";
                /*start trip*/
                $chqry = $this->db->select( "id" )->get_where( "tb_trips", array( 'shift_id' => $arr['ship'], 'vehicle_id' => $arr['vehicle_id'], 'driver_id' => $arr['driver_id'] ), 1, 0 );
                if ( $chqry->num_rows() == 0 ) {

                    if ( $arr['contact_num'] == "" ) {
                        $newimei = $this->db->select( "imei" )->get_where( "tbl_assigned_drivers", array( 'vehicle_id' => $arr['vehicle_id'], 'driver_id' => $arr['driver_id'], 'status' => 1 ), 1, 0 );
                        if ( $newimei->num_rows() > 0 ) {
                            $arr['contact_num'] = $newimei->row()->imei;
                        }
                    }
                    $latitude    = $plat;
                    $longitude   = $plng;
                    $triparr     = array(
                        'shift_id'       => $arr['ship'],
                        'vehicle_id'     => $arr['vehicle_id'],
                        'driver_id'      => $arr['driver_id'],
                        'stime'          => $stsdate,
                        'start_imei'     => $arr['contact_num'],
                        'splace'         => "",
                        'eplace'         => "",
                        'start_reading'  => 0,
                        'end_reading'    => 0,
                        'created_on'     => $stsdate,
                        'updated_on'     => $curdt,
                        'status'         => 1,
                        'trip_type'      => 0,
                        'transit_status' => 0,
                        "plat"           => $latitude,
                        "plng"           => $longitude
                    );
                    $arr['trip'] = $this->common->insertTableData( 'tb_trips', $triparr );
                    $insarry = array( "shipment_id"    => $arr['ship'],
                                      "stop_id"        => 0,
                                      "order_id"       => $ord_id,
                                      "stop_detail_id" => 0,
                                      "stop_type"      => "",
                                      "trip_id"        => $arr['trip'],
                                      "status_id"      => $stid,
                                      "latitude"       => $latitude,
                                      "longitude"      => $longitude,
                                      "status"         => 1,
                                      "reason"         => "From Admin",
                                      "vehicle_id"     => $arr['vehicle_id'],
                                      "driver_id"      => $arr['driver_id'],
                                      "status_code"    => $stcode,
                                      "createdon"      => $stsdate
                    );
                    $ins     = $this->db->insert( "tb_stop_status", $insarry );
                    /* update orders table */
                    $ordwhr   = array( "shift_id" => $arr['ship'] );
                    $ordset   = array( "trip_id" => $arr['trip'] );
                    $upd      = $this->db->set( $ordset )->where( $ordwhr )->update( "tb_orders" );
                    $postdata = array(
                        "shipment_id" => $arr['ship'],
                        "trip_id"     => $arr['trip'],
                        "driver_id"   => $arr['driver_id'],
                        "vehicle_id"  => $arr['vehicle_id'],
                        "order_id"    => $arr['orderid'],
                        "user_id"     => $lgusrid,
                        "stop_id"     => '',
                        "latitude"    => $latitude,
                        "longitude"   => $longitude,
                        "curtz"       => $curtz,
                        "hrs"         => $hrs,
                        "web"         => $seldt,
                        "status_code" => $stcode,
                        "ord_id"      => $ord_id,
                    );
                    /*$sts = $this->statusintigration->shipmentconfirm($postdata);*/
                    /*send to roadlog*/
                    if ( $createdSource == "18" ) {
                        $sts = $this->statusintigration->roadlogshipmentconfirm( $postdata );
                    } elseif ( $createdSource == "5" ) {
                        /*$sts = $this->statusintigration->salogshipmentstatus($postdata);*/
                    } elseif ( $createdSource == "9" ) {
                        $sts = $this->etrucknowquote->getstatusresponse( $postdata );
                    } elseif ( $createdSource == "8" ) {
                        $curtz                         = $this->session->userdata( "usr_tzone" )['timezone'];
                        $logdate                       = date( 'Y-m-d H:i:s' );
                        $getactual                     = getdatetimebytimezone( DFLT_TZ, $logdate, $curtz );
                        $cur_date                      = $getactual['datetime'];
                        $postdata['date_transmission'] = $cur_date;
                        $postdata["truck_number"]      = $this->getTruckNumberById($arr['vehicle_id']);
                        if ( $stid == "35" ) {
                            // Driver Accept
                            $postdata['situation_code']     = 'EML';
                            $postdata['justification_code'] = 'CFM';
                            $sts                            = $this->shippeostatusintigration->shippeoStatusUpdate( $postdata );
                        }
                        if ( $stid == "2" && $stype == "P" ) {
                            // GATEIN
                            $postdata['situation_code']     = 'EML';
                            $postdata['justification_code'] = 'ARS';
                            $sts                            = $this->shippeostatusintigration->shippeoStatusUpdate( $postdata );
                        }
                        if ( $stid == "1" && $stype == "P" ) {
                            // GATEIN PICKUP
                            $postdata['situation_code']     = 'ECH';
                            $postdata['justification_code'] = 'CFM';
                            $sts                            = $this->shippeostatusintigration->shippeoStatusUpdate( $postdata );
                        }
                        if ( $stid == "4" && $stype == "P" ) {
                            // In-Transit
                            $postdata['situation_code']     = 'MLV';
                            $postdata['justification_code'] = 'CFM';
                            $sts                            = $this->shippeostatusintigration->shippeoStatusUpdate( $postdata );
                        }
                        if ( $stid == "1" && $stype == "D" ) {
                            // Destination - delivery
                            $postdata['situation_code']     = 'LIV';
                            $postdata['justification_code'] = 'CFM';
                            $sts                            = $this->shippeostatusintigration->shippeoStatusUpdate( $postdata );
                        }
                        if ( $stid == "3" && $stype == "D" ) {
                            // Destination - Gateout
                            $postdata['situation_code']     = 'LIV';
                            $postdata['justification_code'] = 'DES';
                            $sts                            = $this->shippeostatusintigration->shippeoStatusUpdate( $postdata );
                        }
                    }

                    $this->sendnotify( 'driver_accept', $arr['ord_id'] );
                    /* send notify mail to admin */
                    /*if($lgusrid == "12"){
                    $sndmail = $this->loadconfirmmail($postdata);
                    }*/
                    if ( $lgusrid == "17" ) {
                        $chkven = $this->db->select( "vendor_id" )->get_where( "tb_shifts", array( "id" => $arr['ship'] ), 1, 0 );
                        if ( $chkven->num_rows() > 0 ) {
                            if ( $chkven->row()->vendor_id == "143" ) {
                                $getcsvfile = $this->getcsvfile( $arr['orderid'] );
                            }
                        }
                    }
                    $checkStatus = "RELATED_2_" . $companyCode . "_CONSIGNEE_NOTIFICATION_STATUSES";
                    if (checkAccessConditions('RELATED_2_CONSIGNEE_NOTIFICATION', $companyCode) && checkAccessConditions($checkStatus, $stcode)) {
                        $this->load->library('notifytrigger');
                        $this->notifytrigger->sendNotificationToConsignee($arr['orderid'], $stcode);
                    }
                } else {
    $arr['trip'] = $chqry->row()->id;
    
    // ✅ FIX: Check if status already exists and insert if not
    $this->db->select("id");
    $this->db->from("tb_stop_status");
    $this->db->where("order_id", $ord_id);
    $this->db->where("status_id", $stid);
    
    // Handle shipment_id whether it's empty or has a value
    if (!empty($arr['ship'])) {
        $this->db->where("shipment_id", $arr['ship']);
    } else {
        $this->db->group_start();
        $this->db->where("shipment_id IS NULL");
        $this->db->or_where("shipment_id", 0);
        $this->db->or_where("shipment_id", '');
        $this->db->group_end();
    }
    
    $this->db->limit(1);
    $chqryx = $this->db->get();
    
    if($chqryx->num_rows() == 0){
        $insarry = array( 
            "shipment_id"    => $arr['ship'],
            "stop_id"        => 0,
            "order_id"       => $ord_id,
            "stop_detail_id" => 0,
            "stop_type"      => "",
            "trip_id"        => $arr['trip'],
            "status_id"      => $stid,
            "latitude"       => $latitude,
            "longitude"      => $longitude,
            "status"         => 1,
            "reason"         => "From Admin",
            "vehicle_id"     => $arr['vehicle_id'],
            "driver_id"      => $arr['driver_id'],
            "status_code"    => $stcode,
            "createdon"      => $stsdate
        );
        $ins = $this->db->insert("tb_stop_status", $insarry);
    }
}
                
                $resultsts = 1;
            } elseif ( $arr['trip'] != "0" && $stid != "11" ) {
                $chqry = $this->db->select( "id" )->get_where( "tb_stop_status", array( "order_id"=> $ord_id, "shipment_id" => $arr['ship'], "stop_id" => $stopid, "stop_detail_id" => $stopdetailid, "stop_type" => $stype, "trip_id" => $arr['trip'], "status_id" => $stid,'status'=>'1' ), 1, 0 );
                if ( $chqry->num_rows() == 0 ) {
                    if ( $stid == "2" && $stype == "P" ) {
                        $ttdata                  = array( "id" => $arr['trip'] );
                        $data2["updated_on"]     = $curdt;
                        $data2["transit_status"] = '1';
                        $res                     = $this->db->set( $data2 )->where( $ttdata )->update( "tb_trips" );
                    }
                    if ( $stype == "P" || $stid == "4" ) {
                        $latitude  = $plat;
                        $longitude = $plng;
                    }
                    if ( $stype == "D" ) {
                        $latitude  = $dlat;
                        $longitude = $dlng;
                    }

                    $stcode  = ! empty( $stcode ) ? $stcode : '';
                    $insarry = array( "shipment_id"    => $arr['ship'],
                                      "stop_id"        => $stopid,
                                      "order_id"       => $ord_id,
                                      "stop_detail_id" => $stopdetailid,
                                      "stop_type"      => $stype,
                                      "trip_id"        => $arr['trip'],
                                      "status_id"      => $stid,
                                      "latitude"       => $latitude,
                                      "longitude"      => $longitude,
                                      "status"         => 1,
                                      "reason"         => "From Admin",
                                      "vehicle_id"     => $arr['vehicle_id'],
                                      "driver_id"      => $arr['driver_id'],
                                      "status_code"    => $stcode,
                                      "createdon"      => $stsdate
                    );
                    $ins     = $this->db->insert( "tb_stop_status", $insarry );
                    $chqry1  = $this->db->select( "id" )->get_where( "tb_trip_employee", array( "employee_id" => $stopdetailid, "stop_id" => $stopid, "trip_id" => $arr['trip'], "status" => 1 ), 1, 0 );
                    if ( $chqry1->num_rows() == 0 ) {
                        $insarr = array( "employee_id" => $stopdetailid, "stop_id" => $stopid, "trip_id" => $arr['trip'], "status" => 1, 'driver_late' => 0, 'emp_late' => 0, 'stime' => $curdt, 'check_in' => $curdt, 'absent_reason' => 'Closed', 'created_on' => $curdt, 'updated_on' => $curdt, 'pd_status' => 1 );
                        $ins    = $this->db->insert( "tb_trip_employee", $insarr );
                    }
                    $checkStatus = "RELATED_2_" . $companyCode . "_CONSIGNEE_NOTIFICATION_STATUSES";
                    if (checkAccessConditions('RELATED_2_CONSIGNEE_NOTIFICATION', $companyCode) && checkAccessConditions($checkStatus, $stcode)) {
                        $this->load->library('notifytrigger');
                        $this->notifytrigger->sendNotificationToConsignee($arr['orderid'], $stcode);
                    }
                    $postdata = array(
                        "shipment_id" => $arr['ship'],
                        "trip_id"     => $arr['trip'],
                        "driver_id"   => $arr['driver_id'],
                        "stop_id"     => $stopid,
                        "order_id"    => $arr['orderid'],
                        "inc_id"      => 0,
                        "pod_type"    => '',
                        "latitude"    => $latitude,
                        "longitude"   => $longitude,
                        "stop_type"   => $stype,
                        "vehicle_id"  => $arr['vehicle_id'],
                        "curtz"       => $curtz,
                        "hrs"         => $hrs,
                        "web"         => $seldt,
                        "status_code" => $stcode,
                        "ord_id"      => $ord_id,
                    );
                    try {
                        $statusPayload = [
                            "trip" => $trip_id,
                            "ship" => $arr['ship'],
                            "ord_id" => $ord_id,
                            "orderid" => $arr['orderid'],
                            "stop_id" => 0,
                            "stop_detail_id" => 0,
                            "vehicle_id" => $arr['vehicle_id'],
                            "driver_id" => $arr['driver_id'],
                            "stop_type" => "P",
                            "timezone" => $curtz,
                            "sts_date" => $stsdate,
                            "status_code" => $stcode
                        ];
                        $this->standard_status_execution->sendStandardXMLtoAltova($statusPayload);
                        $this->altovaordercreation->sendOrderToAltova($ord_id, $stcode);
                    } catch (Exception $ex) {
                        log_message("error", "Some Problem occured!, While Sending Order Status to Altova " . $ex->getMessage());
                    }

                    if ( $createdSource == "18" ) {
                        if ( $stid == "4" ) {
                            /*$sts = $this->statusintigration->shipmentintransit($postdata);*/
                            /*send to roadlog*/
                            $sts = $this->statusintigration->roadlogshipmentintransit( $postdata );
                        }
                        if ( $stid == "2" && $stype == "P" ) {
                            /*$sts = $this->statusintigration->shipmentorderpicked($postdata);*/
                            $sts = $this->statusintigration->roadlogshipmentpgatein( $postdata );
                        }
                        if ( $stid == "1" && $stype == "P" ) {
                            /*$sts = $this->statusintigration->shipmentorderpicked($postdata);*/
                            $sts = $this->statusintigration->roadlogshipmentpicked( $postdata );
                            $this->sendnotify( 'pickup_note', $arr['ord_id'] );
                        }
                        if ( $stid == "3" && $stype == "P" ) {
                            /*send to roadlog*/
                            $sts = $this->statusintigration->roadlogshipmentpgateout( $postdata );
                        }
                        if ( $stid == "2" && $stype == "D" ) {
                            /*$sts = $this->statusintigration->shipmentorderpicked($postdata);*/
                            $sts = $this->statusintigration->roadlogshipmentdgatein( $postdata );
                        }
                        if ( $stid == "1" && $stype == "D" ) {
                            /*$sts = $this->statusintigration->shipmentdelivered($postdata);*/
                            /*send to roadlog*/
                            $this->sendnotify( 'delivery_note', $arr['ord_id'] );
                            $sts = $this->statusintigration->roadlogshipmentdelivered( $postdata );
                        }
                    } elseif ( $createdSource == "5" ) {
                        if ( $stid == "1" && $stype == "D" ) {
                            $sts = $this->statusintigration->salogshipmentstatus( $postdata );
                            $this->sendnotify( 'delivery_note', $arr['ord_id'] );
                        }
                        if ( $stid == "1" && $stype == "P" ) {
                            $sts = $this->statusintigration->salogshipmentstatus( $postdata );
                            $this->sendnotify( 'pickup_note', $arr['ord_id'] );
                        }
                    } elseif ( $createdSource == '9' ) {
                        if ( $stid == '4' || ( $stid == "1" && $stype == "P" ) || ( $stid == "3" && $stype == "D" ) ) {
                            $postdata['user_id'] = $lgusrid;
                            if ( $stid == "1" && $stype == "P" ) {
                                $this->sendnotify( 'pickup_note', $arr['ord_id'] );
                            }
                            if ( $stid == "1" && $stype == "D" ) {
                                $this->sendnotify( 'delivery_note', $arr['ord_id'] );
                            }
                            $sts = $this->etrucknowquote->getstatusresponse( $postdata );
                        }
                    } elseif ( $createdSource == "8" ) {
                        $curtz                         = $this->session->userdata( "usr_tzone" )['timezone'];
                        $logdate                       = date( 'Y-m-d H:i:s' );
                        $getactual                     = getdatetimebytimezone( DFLT_TZ, $logdate, $curtz );
                        $cur_date                      = $getactual['datetime'];
                        $postdata['date_transmission'] = $cur_date;
                        $postdata["truck_number"]      = $this->getTruckNumberById($arr['vehicle_id']);
                        if ( $stid == "35" ) {
                            // Driver Accept
                            $postdata['situation_code']     = 'EML';
                            $postdata['justification_code'] = 'CFM';
                            $sts                            = $this->shippeostatusintigration->shippeoStatusUpdate( $postdata );
                        }
                        if ( $stid == "2" && $stype == "P" ) {
                            // GATEIN
                            $postdata['situation_code']     = 'EML';
                            $postdata['justification_code'] = 'ARS';
                            $sts                            = $this->shippeostatusintigration->shippeoStatusUpdate( $postdata );
                        }
                        if ( $stid == "1" && $stype == "P" ) {
                            // GATEIN PICKUP
                            $postdata['situation_code']     = 'ECH';
                            $postdata['justification_code'] = 'CFM';
                            $sts                            = $this->shippeostatusintigration->shippeoStatusUpdate( $postdata );
                        }
                        if ( $stid == "4" && $stype == "P" ) {
                            // In-Transit
                            $postdata['situation_code']     = 'MLV';
                            $postdata['justification_code'] = 'CFM';
                            $sts                            = $this->shippeostatusintigration->shippeoStatusUpdate( $postdata );
                        }
                        if ( $stid == "1" && $stype == "D" ) {
                            // Destination - delivery
                            $postdata['situation_code']     = 'LIV';
                            $postdata['justification_code'] = 'CFM';
                            $sts                            = $this->shippeostatusintigration->shippeoStatusUpdate( $postdata );
                        }
                        if ( $stid == "3" && $stype == "D" ) {
                            // Destination - Gateout
                            $postdata['situation_code']     = 'LIV';
                            $postdata['justification_code'] = 'DES';
                            $sts                            = $this->shippeostatusintigration->shippeoStatusUpdate( $postdata );
                        }
                    }
                    if ( $stid == "3" && $stype == "D" ) {
                        if ( $createdSource == "5" ) {
                            $sts = $this->statusintigration->salogshipmentstatus( $postdata );
                        }
                        $sts = $this->sendepodgateoutnotify( $postdata );
                        $this->sendnotify( 'delivery_note', $arr['ord_id'] );
                    }
                    $resultsts = 1;
                }
            } elseif ( $stsid == "11" && $arr['trip'] != 0 && $arr['trip'] != "" ) {

                $latitude  = $dlat;
                $longitude = $dlng;
                $postdata  = array(
                    "shipment_id" => $arr['ship'],
                    "trip_id"     => $arr['trip'],
                    "driver_id"   => $arr["driver_id"],
                    "stop_id"     => '',
                    "order_id"    => $arr['orderid'],
                    "latitude"    => $latitude,
                    "longitude"   => $longitude,
                    "curtz"       => $curtz,
                    "hrs"         => $hrs,
                    "web"         => $seldt,
                );
                /*send to roadlog*/
                if ( $createdSource == "18" ) {
                    $sts = $this->statusintigration->roadlogshipmenttripdelivered( $postdata );
                }
                $this->sendnotify( 'delivery_note', $arr['ord_id'] );
                if($arr['ship'] >0){
                    $chkmuliti = $this->db->select( "id" )->get_where( "tb_orders", array( "shift_id" => $arr['ship'], "trip_sts" => '0' ) );
                    if ( $chkmuliti->num_rows() > 1 ) {
                        $upd = $this->db->where( array( "id" => $ord_id, "trip_id !=" => 0 ) )->update( "tb_orders", array( "trip_sts" => '1' ) );
                    } else {
                        $updwhr                  = array( "id" => $arr['ship'] );
                        $upddata                 = array( "status" => '0', "updated_on" => $curdt );
                        $upd                     = $this->db->set( $upddata )->where( $updwhr )->update( "tb_shifts" );
                        $data1                   = array();
                        $tdata                   = array( "id" => $arr['trip'] );
                        $data1["end_imei"]       = $arr['contact_num'];
                        $data1["end_reading"]    = '0';
                        $data1["etime"]          = $data1["updated_on"] = $curdt;
                        $data1["status"]         = '0';
                        $data1["transit_status"] = '1';
                        $res                     = $this->db->set( $data1 )->where( $tdata )->update( "tb_trips" );
                        $upd                     = $this->db->where( array( "shift_id" => $arr['ship'] ) )->update( "tb_orders", array( "trip_sts" => '1' ) );
                        $gensum                  = $this->generatesummary( $arr['trip'], $curtz );
                    }
                }
                $resultsts = 1;
            }
        }


        return $resultsts;
    }

    private function sendepodgateoutnotify( $postdata ) {
        //
    }

    private function sendnotify( $note, $ord_id ) {
        //
    }

      public function orderstatusesglobel() {
        try {
            if ( $_FILES['import_file']['size'] > 0 ) {
                $data = [];

                // Load Sheet into Array
                $j             = 0;
                $inputFilename = $_FILES['import_file']['tmp_name'];

                $objPHPExcel = PHPExcel_IOFactory::load( $inputFilename );
                $sheetData   = $objPHPExcel->getActiveSheet()->toArray( NULL, TRUE, TRUE, TRUE );


                $counterData = count($sheetData);
                for ( $i = 3; $i <= $counterData; $i ++ ) {
                    if ( ! empty( $sheetData[ $i ]['A'] ) ) {

                        $data[$j]['order_id']    = $sheetData[ $i ]['A'];
                        $data[$j]['shift_id'] = $sheetData[ $i ]['B'];
						$data[$j]['p_accpect_in'] = $sheetData[ $i ]['C']!=""?date('Y-m-d H:i:s', strtotime($sheetData[ $i ]['C'] ) ) :"";
                        $data[$j]['p_gate_in'] = $sheetData[ $i ]['D']!=""?date('Y-m-d H:i:s', strtotime($sheetData[ $i ]['D'] ) ) :"";
                        if($data[$j]['p_accpect_in']=="" && $data[$j]['p_gate_in']!=""){
                            $data[$j]['p_accpect_in']=$data[$j]['p_gate_in'];
                        }
                        $data[$j]['pickup'] = $sheetData[ $i ]['E']!=""?date( 'Y-m-d H:i:s', strtotime($sheetData[ $i ]['E'] ) ) :"";
                        if($data[$j]['p_gate_in']=="" && $data[$j]['pickup']!=""){
                            $data[$j]['p_gate_in']=$data[$j]['pickup'];
                            if($data[$j]['p_accpect_in']==""){
                                $data[$j]['p_accpect_in']=date( 'Y-m-d H:i:s', strtotime( $data[$j]['pickup'] . '-10 minutes' ) );
                            }
                        }
                        $data[$j]['p_gate_out'] = $sheetData[ $i ]['F']!=""?date( 'Y-m-d H:i:s', strtotime($sheetData[ $i ]['F'] )  ):"";
                        if($data[$j]['pickup']=="" && $data[$j]['p_gate_out']!=""){
                            $data[$j]['pickup']=$data[$j]['p_gate_out'];
                           if($data[$j]['p_gate_in']==""){
                                 $data[$j]['p_gate_in']=date( 'Y-m-d H:i:s', strtotime( $data[$j]['p_gate_out'] . '-10 minutes' ) );
                               if($data[$j]['p_accpect_in']==""){
                                   $data[$j]['p_accpect_in']=date( 'Y-m-d H:i:s', strtotime( $data[$j]['p_gate_out'] . '-10 minutes' ) );
                               }
                           }
                        }

                        $data[$j]['intransit'] = $sheetData[ $i ]['G']!=""?date('Y-m-d H:i:s', strtotime($sheetData[ $i ]['G'] ) ):"";
						if($data[$j]['p_gate_out']=="" && $data[$j]['intransit']!=""){
                                $data[$j]['p_gate_out']=date( 'Y-m-d H:i:s', strtotime( $data[$j]['intransit'] . '-10 minutes' ) );
                                if($data[$j]['pickup']==""){
                                    $data[$j]['pickup']=date( 'Y-m-d H:i:s', strtotime( $data[$j]['intransit'] . '-20 minutes' ) );
                                    if($data[$j]['p_gate_in']==""){
                                         $data[$j]['p_gate_in']=date( 'Y-m-d H:i:s', strtotime( $data[$j]['intransit'] . '-30 minutes' ) );;
                                        if($data[$j]['p_accpect_in']==""){
                                            $data[$j]['p_accpect_in']=date( 'Y-m-d H:i:s', strtotime( $data[$j]['intransit'] . '-10 minutes' ) );
                                        }
                                     }
                              }

                        }


                        $data[$j]['d_gate_in'] = $sheetData[ $i ]['H']!=""?date( 'Y-m-d H:i:s', strtotime($sheetData[ $i ]['H'] ) ) :"";


                        if($data[$j]['p_gate_out']=="" && $data[$j]['d_gate_in']!=""){
                                $data[$j]['p_gate_out']=date( 'Y-m-d H:i:s', strtotime( $data[$j]['d_gate_in'] . '-10 minutes' ) );
                                if($data[$j]['intransit']==""){
                                    $data[$j]['intransit']=date( 'Y-m-d H:i:s', strtotime( $data[$j]['d_gate_in'] . '-10 minutes' ) );
                                }
                                if($data[$j]['pickup']==""){
                                    $data[$j]['pickup']=date( 'Y-m-d H:i:s', strtotime( $data[$j]['d_gate_in'] . '-20 minutes' ) );
                                    if($data[$j]['p_gate_in']==""){
                                         $data[$j]['p_gate_in']=date( 'Y-m-d H:i:s', strtotime( $data[$j]['d_gate_in'] . '-30 minutes' ) );;
                                            if($data[$j]['p_accpect_in']==""){
                                                $data[$j]['p_accpect_in']=date( 'Y-m-d H:i:s', strtotime( $data[$j]['d_gate_in'] . '-10 minutes' ) );
                                            }
                                     }
                              }

                        }


                        $data[$j]['delivery'] = $sheetData[ $i ]['I']!=""?date( 'Y-m-d H:i:s', strtotime($sheetData[ $i ]['I'] ) ) :"";

                        if($data[$j]['d_gate_in']=="" && $data[$j]['delivery']!=""){

                            if($data[$j]['intransit']==""){
                                $data[$j]['intransit']=date( 'Y-m-d H:i:s', strtotime( $data[$j]['delivery'] . '-10 minutes' ) );
                            }
                            $data[$j]['d_gate_in']=date( 'Y-m-d H:i:s', strtotime( $data[$j]['delivery'] . '-10 minutes' ) );
                            if($data[$j]['p_gate_out']==""){
                                    $data[$j]['p_gate_out']=date( 'Y-m-d H:i:s', strtotime( $data[$j]['delivery'] . '-10 minutes' ) );
                                    if($data[$j]['pickup']==""){
                                        $data[$j]['pickup']=date( 'Y-m-d H:i:s', strtotime( $data[$j]['delivery'] . '-20 minutes' ) );
                                        if($data[$j]['p_gate_in']==""){
                                             $data[$j]['p_gate_in']=date( 'Y-m-d H:i:s', strtotime( $data[$j]['delivery'] . '-30 minutes' ) );;
                                                if($data[$j]['p_accpect_in']==""){
                                                    $data[$j]['p_accpect_in']=date( 'Y-m-d H:i:s', strtotime( $data[$j]['delivery'] . '-10 minutes' ) );
                                                }
                                         }
                              }

                             }


                         }



                        $data[$j]['d_gate_out'] = $sheetData[ $i ]['J']!=""?date( 'Y-m-d H:i:s', strtotime($sheetData[ $i ]['J'] ) ) :"";


                         if($data[$j]['delivery']=="" && $data[$j]['d_gate_out']!=""){

                             $data[$j]['delivery']=date( 'Y-m-d H:i:s', strtotime( $data[$j]['d_gate_out'] . '-10 minutes' ) );
                             if($data[$j]['intransit']==""){
                                    $data[$j]['intransit']=date( 'Y-m-d H:i:s', strtotime( $data[$j]['d_gate_out'] . '-10 minutes' ) );
                             }

                             if($data[$j]['d_gate_in']==""){
                                 $data[$j]['d_gate_in']=date( 'Y-m-d H:i:s', strtotime( $data[$j]['d_gate_out'] . '- 10 minutes' ) );
                                 if($data[$j]['p_gate_out']==""){
                                    $data[$j]['p_gate_out']=date( 'Y-m-d H:i:s', strtotime( $data[$j]['d_gate_out'] . '- 20 minutes' ) );
                                    if($data[$j]['pickup']==""){
                                        $data[$j]['pickup']=date( 'Y-m-d H:i:s', strtotime( $data[$j]['d_gate_out'] . '- 30 minutes' ) );
                                        if($data[$j]['p_gate_in']==""){
                                             $data[$j]['p_gate_in']=date( 'Y-m-d H:i:s', strtotime( $data[$j]['d_gate_out'] . '- 40 minutes' ) );;
                                            if($data[$j]['p_accpect_in']==""){
                                                $data[$j]['p_accpect_in']=date( 'Y-m-d H:i:s', strtotime( $data[$j]['d_gate_out'] . '-10 minutes' ) );
                                            }
                                         }
                                     }

                                 }

                            }

                        }
                        $data[$j]['close'] = $sheetData[$i]['K'] != "" ? date('Y-m-d H:i:s', strtotime($sheetData[$i]['K'])) : "";
                        if($data[$j]['d_gate_out']=="" && $data[$j]['close']!=""){

                            $data[$j]['d_gate_out']=date( 'Y-m-d H:i:s', strtotime( $data[$j]['close'] . '-10 minutes' ) );
                            if($data[$j]['delivery']==""){
                                $data[$j]['delivery']=date( 'Y-m-d H:i:s', strtotime( $data[$j]['close'] . '-10 minutes' ) );
                            }
                            if($data[$j]['intransit']==""){
                                $data[$j]['intransit']=date( 'Y-m-d H:i:s', strtotime( $data[$j]['close'] . '-10 minutes' ) );
                            }

                            if($data[$j]['d_gate_in']==""){
                                $data[$j]['d_gate_in']=date( 'Y-m-d H:i:s', strtotime( $data[$j]['close'] . '- 10 minutes' ) );
                                if($data[$j]['p_gate_out']==""){
                                    $data[$j]['p_gate_out']=date( 'Y-m-d H:i:s', strtotime( $data[$j]['close'] . '- 20 minutes' ) );
                                    if($data[$j]['pickup']==""){
                                        $data[$j]['pickup']=date( 'Y-m-d H:i:s', strtotime( $data[$j]['close'] . '- 30 minutes' ) );
                                        if($data[$j]['p_gate_in']==""){
                                            $data[$j]['p_gate_in']=date( 'Y-m-d H:i:s', strtotime( $data[$j]['close'] . '- 40 minutes' ) );;
                                            if($data[$j]['p_accpect_in']==""){
                                                $data[$j]['p_accpect_in']=date( 'Y-m-d H:i:s', strtotime( $data[$j]['close'] . '-10 minutes' ) );
                                            }
                                        }
                                    }

                                }

                            }

                        }
                        $j ++;
                    }
                }

				if (count($data) > 0) {
                    foreach ($data as $li) {
                        if ($li['order_id'] == '' || $li['shift_id'] == '') {
                            $excel_sorders[] = ['order_id' => $order_id, 'shift_id' => $shift_id, 'status_type' => "Trip", 'status' => 'Order ID and Shipment ID is manditory to update the Statuses'];
                        } else {
                            $order_id = $li['order_id'];
                            $shift_id = $li['shift_id'];
                            $p_accpect_in = $li['p_accpect_in'];
                            if ($p_accpect_in != "") {
                                if ($order_id != "" && $shift_id != "") {
                                    $getorderrow_id = $this->db->select("trip_id")->get_where("tb_orders", ['order_id' => $order_id, 'shipmentid' => $shift_id]);
                                    if ($getorderrow_id->num_rows() > 0) {
                                        $trip_id = $getorderrow_id->row()->trip_id;
                                        $final = $this->processexceluploadData($li);
                                        $count = count($final);
                                        for ($k = 0; $k < $count; $k++) {
                                            $final[$k]['trip_id'] = $trip_id;
                                            $thisvaue = $this->updaterOderExcelStatus($final[$k]);
                                            $stype = $final[$k]['stop_name'];
                                            $excel_sorders[] = ['order_id' => $order_id, 'shift_id' => $shift_id, 'status_type' => $stype, 'status' => 'Success'];
                                        }
                                    }
                                }
                            } else {
                                $excel_sorders[] = ['order_id' => $order_id, 'shift_id' => $shift_id, 'status_type' => "Trip", 'status' => 'Driver Not Accepted the Trip'];
                            }
                        }
                    }
                } else {
                    $excel_sorders[] = ['order_id' => $order_id, 'shift_id' => $shift_id, 'status_type' => "Trip", 'status' => 'Order ID and Shipment ID is manditory to update the Statuses'];
                }
				if (!empty($excel_sorders)) {
                @file_put_contents(
                    $_SERVER['DOCUMENT_ROOT'] . "/svkonekt_test/assets/ordertemplate/massstatusdata.txt",
                    json_encode($excel_sorders)
                );
            }
               if($this->session->userdata('company_code') == "NZKN"){
                   redirect('nzmassstatus/massupdate');
               }
               redirect('admin/collinsMassStatus/01');
            }
        } catch ( \Exception $e ) {
            echo $e->getMessage();
        }
    }

	 private function processexceluploadData( $data ) {
        try {
            $j       = 0;
            $pdcnt   = 0;
            $gicnt   = 0;
            $gocnt   = 0;
            $stype   = "";
            $final   = array();

            $custord = $this->db->query(
                "SELECT o.id,o.order_id,o.shift_id,o.trip_id,o.shipmentid,v.vehicle_id,a.driver_id,a.imei,d.contact_num,d.track_type,d.track_vendor,d.sim_carrier
                        FROM tb_orders o,tb_shft_veh v,tb_vendors c,tbl_assigned_drivers a,tb_truck_drivers d
                        WHERE o.shift_id=v.shft_id AND v.carrier_id=c.id AND v.vehicle_id=a.vehicle_id
                          AND a.driver_id=d.id AND v.status=1 AND a.status=1 AND d.status='Active' AND o.status!=0 AND o.shift_id >0 AND o.trip_sts=0
                          AND o.order_id = ? AND o.shipmentid= ?",
            [ $data['order_id'], $data['shift_id'] ]);
            if ( $custord->num_rows() != 0 ) {
                $res         = $custord->row();
                $ship_id     = $res->shift_id;
                $multiship   = 0;
                $tripid      = $driver_id = 0;
                $vehicle_id  = $res->vehicle_id;
                $contact_num = "";
                $shipmentid  = $res->shipmentid;
                if ( $res->trip_id != 0 && $res->trip_id != "" ) {
                    $checktrip = $this->getQueryTripByShiftId($ship_id);
                    if ( $checktrip->num_rows() > 0 ) {
                        $contact_num = $checktrip->row()->start_imei;
                        $tripid      = $checktrip->row()->id;
                        $vehicle_id  = $checktrip->row()->vehicle_id;
                        $driver_id   = $checktrip->row()->driver_id;
                    }
                }
                if ( $tripid == 0 && $vehicle_id != "" ) {
                    $driver_id   = $res->driver_id;
                    $contact_num = $res->imei;
                }
                $tracktype   = 0;
                $trackvendor = $simcarrier = $contact_num = "";
                if ( $res->track_type == 1 ) {
                    $tracktype   = 1;
                    $trackvendor = $res->track_vendor;
                    $simcarrier  = $res->sim_carrier;
                    $contact_num = $res->contact_num;
                }
                $ordid    = $res->id;
                $order_id = $res->order_id;
                $refers   = array();
                $ref      = $this->db->query(
                    "SELECT reference_id,ref_value
                            FROM tb_order_references
                            WHERE order_id= ? AND reference_id IN ('DQ','AAM','AWB','XSR','SD','INN') AND status=1 AND ref_value!='' ",
                    [ $ordid ]
                );
                if ( $ref->num_rows() > 0 ) {
                    $refers = $ref->result_array();
                }
                $saccept     = $sgatein = $spickup = $sgateout = $intransit = $dgatein = $dpickup = $dgateout = 0;
                $s_saccept   = $s_sgatein = $s_spickup = $s_sgateout = $s_intransit = $s_dgatein = $s_dpickup = $s_dgateout = 0;
                $s_sacceptcr = $s_sgateincr = $s_spickupcr = $s_sgateoutcr = $s_intransitcr = $s_dgateincr = $s_dpickupcr = $s_dgateoutcr = "";
                $pstpid      = $dstpid = $pstodetailid = $dstodetailid = "";
                $stopsts = $this->db->query(
                    "SELECT sm.id as sid,sm.status_name,ts.id,ts.stop_id,ts.stop_detail_id,ts.stop_type,ts.status_id,ts.createdon as createdon
                            FROM tb_status_master sm
                                LEFT JOIN tb_stop_status ts ON sm.id=ts.status_id AND ts.shipment_id= ?
                                    AND ts.order_id= ? AND ts.trip_id= ? AND ts.status=1
                            WHERE sm.id IN(1,2,3,4,35)",
                    [ $ship_id, $ordid, $tripid ]
                );
                if ( $stopsts->num_rows() > 0 ) {
                    foreach ( $stopsts->result() as $st ) {
                        if ( $st->sid == 35 ) {
                            if ( $st->id != "" && $st->status_id == 35 ) {
                                $pstpid       = $st->stop_id;
                                $pstodetailid = $st->stop_detail_id;
                                $saccept      = $st->status_id;
                                $s_saccept    = 1;
                                $s_sacceptcr  = $st->createdon;
                                if ( $pstpid == "0" || $pstpid == "" ) {
                                    $chkq = $this->getQueryStopDetailsIdOnStopId($ship_id, $order_id);
                                    if ( $chkq->num_rows() > 0 ) {
                                        $pstpid       = $chkq->row()->id;
                                        $pstodetailid = $chkq->row()->stopdetailsid;
                                    }
                                }
                            } else {
                                $chkq = $this->getQueryStopDetailsIdOnStopId($ship_id, $order_id);
                                if ( $chkq->num_rows() > 0 ) {
                                    $pstpid       = $chkq->row()->id;
                                    $pstodetailid = $chkq->row()->stopdetailsid;
                                    $saccept      = $st->sid;
                                }
                            }
                        }
                        if ( $st->sid == 2 ) {
                            if ( $st->id != "" && $st->status_id == 2 && $st->stop_type == "P" ) {
                                $pstpid       = $st->stop_id;
                                $pstodetailid = $st->stop_detail_id;
                                $sgatein      = $st->status_id;
                                $s_sgatein    = 1;
                                $s_sgateincr  = $st->createdon;
                            } else {
                                $chkq = $this->getQueryStopDetailsIdOnStopOrDropId($ship_id, $order_id);
                                if ( $chkq->num_rows() > 0 ) {
                                    $pstpid       = $chkq->row()->id;
                                    $pstodetailid = $chkq->row()->stopdetailsid;
                                    $sgatein      = $st->sid;
                                }
                            }
                            if ( $st->id != "" && $st->status_id == 2 && $st->stop_type == "D" ) {
                                $dstpid       = $st->stop_id;
                                $dstodetailid = $st->stop_detail_id;
                                $dgatein      = $st->status_id;
                                $s_dgatein    = 1;
                                $s_dgateincr  = $st->createdon;
                            } else {
                                $chkq = $this->getQueryStopDetailsIdOnDropStopId($ship_id, $order_id);
                                if ( $chkq->num_rows() > 0 ) {
                                    $dstpid       = $chkq->row()->id;
                                    $dstodetailid = $chkq->row()->stopdetailsid;
                                    $dgatein      = $st->sid;
                                }
                            }
                        }
                        if ( $st->sid == 1 ) {
                            if ( $st->id != "" && $st->status_id == 1 && $st->stop_type == "P" ) {
                                $pstpid       = $st->stop_id;
                                $pstodetailid = $st->stop_detail_id;
                                $spickup      = $st->status_id;
                                $s_spickup    = 1;
                                $s_spickupcr  = $st->createdon;
                            } else {
                                $chkq = $this->getQueryStopDetailsIdOnStopId($ship_id, $order_id);
                                if ( $chkq->num_rows() > 0 ) {
                                    $pstpid       = $chkq->row()->id;
                                    $pstodetailid = $chkq->row()->stopdetailsid;
                                    $spickup      = $st->sid;
                                }
                            }
                            if ( $st->id != "" && $st->status_id == 1 && $st->stop_type == "D" ) {
                                $dstpid       = $st->stop_id;
                                $dstodetailid = $st->stop_detail_id;
                                $dpickup      = $st->status_id;
                                $s_dpickup    = 1;
                                $s_dpickupcr  = $st->createdon;
                            } else {
                                $chkq = $this->getQueryStopDetailsIdOnDropStopId($ship_id, $order_id);
                                if ( $chkq->num_rows() > 0 ) {
                                    $dstpid       = $chkq->row()->id;
                                    $dstodetailid = $chkq->row()->stopdetailsid;
                                    $dpickup      = $st->sid;
                                }
                            }
                        }
                        if ( $st->sid == 3 ) {
                            if ( $st->id != "" && $st->status_id == 3 && $st->stop_type == "P" ) {
                                $pstpid       = $st->stop_id;
                                $pstodetailid = $st->stop_detail_id;
                                $sgateout     = $st->status_id;
                                $s_sgateout   = 1;
                                $s_sgateoutcr = $st->createdon;
                            } else {
                                $chkq = $this->getQueryStopDetailsIdOnStopId($ship_id, $order_id);
                                if ( $chkq->num_rows() > 0 ) {
                                    $pstpid       = $chkq->row()->id;
                                    $pstodetailid = $chkq->row()->stopdetailsid;
                                    $sgateout     = $st->sid;
                                }
                            }
                            if ( $st->id != "" && $st->status_id == 3 && $st->stop_type == "D" ) {
                                $dstpid       = $st->stop_id;
                                $dstodetailid = $st->stop_detail_id;
                                $dgateout     = $st->status_id;
                                $s_dgateout   = 1;
                                $s_dgateoutcr = $st->createdon;
                            } else {
                                $chkq = $this->getQueryStopDetailsIdOnDropStopId($ship_id, $order_id);
                                if ( $chkq->num_rows() > 0 ) {
                                    $dstpid       = $chkq->row()->id;
                                    $dstodetailid = $chkq->row()->stopdetailsid;
                                    $dgateout     = $st->sid;
                                }
                            }
                        }
                        if ( $st->sid == 4 ) {
                            if ( $st->id != "" && $st->status_id == 4 ) {
                                $pstpid        = $st->stop_id;
                                $pstodetailid  = $st->stop_detail_id;
                                $intransit     = $st->status_id;
                                $s_intransit   = 1;
                                $s_intransitcr = $st->createdon;
                            } else {
                                $chkq = $this->getQueryStopDetailsIdOnStopId($ship_id, $order_id);
                                if ( $chkq->num_rows() > 0 ) {
                                    $pstpid       = $chkq->row()->id;
                                    $pstodetailid = $chkq->row()->stopdetailsid;
                                    $intransit    = $st->sid;
                                }
                            }
                        }
                    }
                } else {
                    $emp = $this->db->query(
                        "SELECT s.id,s.stoptype,s.ordernumber,e.id as stopdetailsid,s.status
                                FROM tb_shiporder_stops s,tb_employee e
                                WHERE s.shipment_id= ? AND s.status=1 AND s.id=e.stop_id AND e.status=1 AND e.shift_id= ? AND e.order_id= ?
                            UNION
                            SELECT s.id,s.stoptype,s.ordernumber,e.id as stopdetailsid,s.status
                                FROM tb_shiporder_stops s,tb_employee e
                                WHERE s.shipment_id= ? AND s.status=1 AND s.id=e.drop_stopid AND e.status=1 AND e.shift_id= ? AND e.order_id= ?
                            ORDER BY ordernumber  ",
                        [ $ship_id, $ship_id, $order_id, $ship_id, $ship_id, $order_id ]
                    );
                    if ( $emp->num_rows() > 0 ) {
                        foreach ( $emp->result_array() as $res1 ) {
                            if ( $res1['stoptype'] == "P" ) {
                                $saccept      = 35;
                                $sgatein      = 2;
                                $spickup      = 1;
                                $sgateout     = 3;
                                $intransit    = 4;
                                $pstpid       = $res1['id'];
                                $pstodetailid = $res1['stopdetailsid'];
                            }
                            if ( $res1['stoptype'] == "D" ) {
                                $dgatein      = 2;
                                $dpickup      = 1;
                                $dgateout     = 3;
                                $dstpid       = $res1['id'];
                                $dstodetailid = $res1['stopdetailsid'];
                            }
                        }
                    }
                }


                $stsid = 1;

                $info['trip_id']     = $tripid;
                $info['ship_id']     = $ship_id;
                $info['ord_id']      = $ordid;
                $info['orderid']     = $data['order_id'];
                $info['stopid']      = $pstpid;
                $info['stopdetid']   = $pstodetailid;
                $info['vehicle_id']  = $vehicle_id;
                $info['driver_id']   = $driver_id;
                $info['tracktype']   = $tracktype;
                $info['trackvendor'] = $trackvendor;
                $info['contact_num'] = $contact_num;
                $info['stsid']       = $stsid;
                $info['status']      = 0;

				if($data['p_accpect_in']!=""){
					$info['stop_type']   = "P";
					$info['stop_name']   = "Accepted by Driver";

					$final[ $j ]             = $info;
					$final[ $j ]['sts_date'] = $data['p_accpect_in'];
					$final[ $j ]['stsid']    = 35; // Pickup gate in
                    $j ++;
                    if (checkAccessConditions('WECHAT_COUNTRY', $this->session->userdata('company_code')))
                    {
                        $this->load->library('Wechat');
                        $this->wechat->orderId = $data['order_id'];
                        $this->wechat->sendNotificationsToWeChat();
                    }
				}

				if($data['p_gate_in']!=""){
					 $info['stop_type']   = "P";
					 $info['stop_name']   = "Origin Gate In";

					 $final[ $j ]             = $info;
					 $final[ $j ]['sts_date'] = $data['p_gate_in'];
					  $final[ $j ]['stsid']    = 2; // Pickup gate in
                       $j ++;
				}

				if($data['pickup']!=""){
					$info['stop_type']   = "P";
					$info['stop_name']   = "Pickup";
					$final[ $j ]             = $info;
					$final[ $j ]['sts_date'] = $data['pickup'];
					$final[ $j ]['stsid']    = 1; // Pickup
					$j ++;
				}

				if($data['p_gate_out']!=""){
					 $info['stop_type']   = "P";
					$info['stop_name']   = "Origin Gate Out";
					 $final[ $j ]             = $info;
					 $final[ $j ]['sts_date'] = $data['p_gate_out'];
					  $final[ $j ]['stsid']    = 3; // Pickup gate our
                       $j ++;
				}

				if($data['intransit']!=""){
					 $info['stop_type']   = "P";
					$info['stop_name']   = "In Transit";
					 $final[ $j ]             = $info;
					 $final[ $j ]['sts_date'] = $data['intransit'];
					  $final[ $j ]['stsid']    = 4; // Pickup gate in
                       $j ++;
				}


				if($data['d_gate_in']!=""){
					 $info['stop_type']   = "D";
					$info['stop_name']   = "delivery Gate In";
					 $final[ $j ]             = $info;
					 $final[ $j ]['sts_date'] = $data['d_gate_in'];
					  $final[ $j ]['stsid']    = 2; // Pickup gate in
                       $j ++;
				}

				if($data['delivery']!=""){
					  $info['stop_type']   = "D";
					$info['stop_name']   = "delivery";
					 $final[ $j ]             = $info;
					 $final[ $j ]['sts_date'] = $data['delivery'];
					  $final[ $j ]['stsid']    = 1; // Pickup gate in
                       $j ++;
				}

				if($data['d_gate_out']!=""){
					 $info['stop_type']   = "D";
					 $info['stop_name']   = "delivery Gate out";
					 $final[ $j ]             = $info;
					 $final[ $j ]['sts_date'] = $data['d_gate_out'];
					  $final[ $j ]['stsid']    = 3; // Pickup gate in
                       $j ++;
				}
                if ($data['close'] != "") {
                    $info['stop_type'] = "D";
                    $info['stop_name'] = "Planned Delivery Date";
                    $final[$j] = $info;
                    $final[$j]['sts_date'] = $data['close'];
                    $final[$j]['stsid'] = 11; // Pickup gate in
                    $j++;
                }


            }
            return $final;
        } catch ( \Exception $e ) {
            echo $e->getMessage();
        }
    }

    private function getTruckNumberById($vehicle_id)
    {
        return $this->db->query(
            "SELECT truck_number
                    FROM tb_trucks_data
                    WHERE id = ?
                    LIMIT 1",
            [$vehicle_id]
        )->row();
    }

    private function getQueryStopDetailsIdOnStopId($ship_id, $order_id)
    {
        return $this->db->query(
            "SELECT s.id,e.id as stopdetailsid
                    FROM tb_shiporder_stops s,tb_employee e
                    WHERE s.shipment_id= ? AND s.status=1 AND s.id=e.stop_id AND e.status=1
                      AND e.shift_id= ? AND e.order_id= ?
                    LIMIT 1",
            [$ship_id, $ship_id, $order_id]
        );
    }

    private function getQueryStopDetailsIdOnStopOrDropId($ship_id, $order_id)
    {
        return $this->db->query(
            "SELECT s.id,e.id as stopdetailsid
                    FROM tb_shiporder_stops s,tb_employee e
                    WHERE s.shipment_id= ? AND s.status=1 AND (s.id=e.stop_id OR s.id=e.drop_stopid) AND e.status=1
                      AND e.shift_id= ? AND e.order_id= ?
                    LIMIT 1",
            [$ship_id, $ship_id, $order_id]
        );
    }

    private function getQueryStopDetailsIdOnDropStopId($ship_id, $order_id)
    {
        return $this->db->query(
            "SELECT s.id,e.id as stopdetailsid
                    FROM tb_shiporder_stops s,tb_employee e
                    WHERE s.shipment_id= ? AND s.status=1 AND s.id=e.drop_stopid AND e.status=1
                        AND e.shift_id= ? AND e.order_id= ?
                    LIMIT 1",
            [$ship_id, $ship_id, $order_id]
        );
    }

    private function getQueryTripByShiftId($shift_id)
    {
        return $this->db->query(
            "SELECT id,vehicle_id,driver_id,start_imei
                    FROM tb_trips
                    WHERE shift_id= ? AND status=1",
            [$shift_id]
        );
    }


}
