<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');
ini_set('memory_limit', '4096M');
ini_set('max_execution_time', 2000);
require_once APPPATH . "/third_party/PHPExcel.php";
class CommonCRON extends CI_Controller {
    function __construct() {
        parent::__construct();
    }
    public function downloadSALOGSpecificDocsAfterUpdate() {
        $this->load->model('Roadlogtosalogmodel','salog_m');
        $ordersList = $this->salog_m->getUpdatedSALOGOrders();
        if (!empty($ordersList)) {
            $documentTypes = $this->salog_m->getSpecificSALOGDocTypes();
            $documentTypes = explode(',', $documentTypes['condition']);
            $this->load->library(['SALOGDownloadDocuments', 'CarrierDocumentOutbound']);
            foreach ($ordersList as $orders) {
                $orderId = $orders['id'];
                $companyCode = $orders['company_code'];
                $branchCode = $orders['branch_code'];
                if (checkAccessConditions('CHECK_SALOG_DOCUMENT_COUNTRY', $companyCode)) {
                    if ($companyCode === 'CNKN') {
                        $this->downloadCNKNSpecificDocuments($orderId, $orders['ref_value'], $branchCode);
                    } else {
                        foreach ($documentTypes as $document) {
                            $status = $this->salog_m->checkDocumentDownloadStatus($orderId, $document);
                            if ($status === 0) {
                                $this->salogdownloaddocuments->downloadSALOGByDocumentType($orderId, $orders['ref_value'], $document);
                            }
                        }
                    }
                }
                $this->db->delete("salog_updated_orders",["order_row_id"=>$orderId]);
            }
        }
    }
    public function downloadSALOGSpecificDocs() {
        $this->load->model('Roadlogtosalogmodel','salog_m');
        $ordersList = $this->salog_m->getRecentSALOGOrders();
        if (!empty($ordersList)) {
            $documentTypes = $this->salog_m->getSpecificSALOGDocTypes();
            $documentTypes = explode(',', $documentTypes['condition']);
            $this->load->library(['SALOGDownloadDocuments', 'CarrierDocumentOutbound']);
            foreach ($ordersList as $orders) {
                $orderId = $orders['id'];
                $companyCode = $orders['company_code'];
                $branchCode = $orders['branch_code'];
                if (checkAccessConditions('CHECK_SALOG_DOCUMENT_COUNTRY', $companyCode)) {
                    if ($companyCode === 'CNKN') {
                        $this->downloadCNKNSpecificDocuments($orderId, $orders['ref_value'], $branchCode);
                    } else {
                        foreach ($documentTypes as $document) {
                            $status = $this->salog_m->checkDocumentDownloadStatus($orderId, $document);
                            if ($status === 0) {
                                $this->salogdownloaddocuments->downloadSALOGByDocumentType($orderId, $orders['ref_value'], $document);
                            }
                        }
                    }
                    $checkOrderStatus = $this->salog_m->checkOrderStatus($orderId);
                    if ($checkOrderStatus != 0) {
                        try {
                            $this->carrierdocumentoutbound->sendDocumentsToCarrier($orderId);
                        } catch (Exception $ex) {
                            log_message("error", "Salog Documents sending Failed to Carrier " . $ex->getMessage());
                        }
                    }
                }

            }
        }
    }

    private function downloadCNKNSpecificDocuments(int $orderId, string $referenceValue, string $branchCode) {
        $SALOGOrderRequestType = $this->salog_m->getSALOGOrderRequestType($orderId);
        if ($SALOGOrderRequestType) {
            $documentTypes = [];
            if ($SALOGOrderRequestType === 'PUP') {
                $documentTypes = $this->salog_m->getSALOGOrderTypeDocTypes('CNKN_SALOG_ORDER_TYPE_PUP_DOCS');
            }

            if ($SALOGOrderRequestType === 'DEL') {
                $documents[] = $this->salog_m->getSALOGOrderTypeDocTypes('CNKN_SALOG_ORDER_TYPE_DEL_DOCS');
                if ($branchCode==='CNCTU') {
                    $documents[] = $this->salog_m->getSALOGOrderTypeDocTypes('CNCTU_SALOG_ORDER_TYPE_DEL_DOCS');
                }
                $documentTypes = implode(',', $documents);
            }
            if ($documentTypes) {
                $documentTypes = explode(',', $documentTypes);
                foreach ($documentTypes as $document) {
                    $status = $this->salog_m->checkDocumentDownloadStatus($orderId, $document);
                    if ($status === 0) {
                        $this->salogdownloaddocuments->downloadSALOGByDocumentType($orderId, $referenceValue, $document);
                    }
                }
            }
        }
    }

    public function sendOrderStatusEmailReport() {
        $this->load->library(['parser', 'PhpMailerLibrary']);
        $this->load->model('common');
        $fromDate 	= date("Y-m-d",strtotime("-1 month"));
        $toDate 	= date("Y-m-d");
        $this->sendAdminReport($fromDate, $toDate);
        $this->sendCarrierReport($fromDate, $toDate);
    }

    private function sendAdminReport(string $fromDate, string $toDate): void {
        $countryListSQL = $this->common->fetchRecordsByCustomQry("SELECT `condition` FROM `access_conditions` WHERE `title` = ?",['BUFO_EMAIL_REPORT_COUNTRIES'], FALSE);
        $countryList = explode(',', $countryListSQL['condition']);
        $result = $emailList = [];
        foreach ($countryList as $countryCode) {
            $sql = "SELECT report_emails_to,report_emails_cc, report_emails_bcc FROM tb_users WHERE `company_indv_name`=? AND report_emails_to !='' LIMIT ?";
            $emailList = $this->common->fetchRecordsByCustomQry($sql,[$countryCode, 1], FALSE);
            if ($emailList) {
                $sql = "SELECT c.cntry_timezone FROM tb_users u
						LEFT JOIN tbl_country_master c ON (c.country_code = u.country_code)
						WHERE u.company_indv_name = ? LIMIT ?";
                $timeZoneSQL = $this->common->fetchRecordsByCustomQry($sql,[$countryCode, 1], FALSE);
                $timeZone = $timeZoneSQL['cntry_timezone'];
                $bindParams = [];
                $sql = "SELECT
				`o`.`order_id`,
				convertToClientTZ(`o`.`pickup_datetime`,?) AS pickup_datetime,
				convertToClientTZ(`o`.`delivery_datetime`,?) AS delivery_datetime,
				`o`.`pickup_company`,
				`o`.`delivery_company`,
				`o`.`pickup_address1`,
				`o`.`pickup_city`,
				`o`.`delivery_address1`,
				`o`.`delivery_city`,
				`o`.`pickup_pincode`,
				`o`.`delivery_pincode`,
				`o`.`pickup_address2`,
				`o`.`delivery_address2`,
				`o`.`status`,
				`o`.`trip_id`,
				`o`.`shipmentid`,
				`o`.`vendor_id`,
				`o`.`product`,
				convertToClientTZ(`o`.`createdon`,?) AS createdon,
				(SELECT `v`.`name` FROM `tb_vendors` `v` WHERE `o`.`vendor_id`=`v`.`id`) AS `vendor_name`,
				(SELECT `c`.`name` FROM `tb_customers` `c` WHERE `o`.`customer_id`=`c`.`id`) AS `customer_name`,
				(SELECT `tor`.`ref_value` FROM `tb_order_references` `tor` WHERE `o`.`id`=`tor`.`order_id` AND `tor`.`reference_id`=? AND `tor`.`status`=? ORDER BY `tor`.`id` DESC LIMIT ?) AS `salog_ref`,
				(SELECT `tor`.`ref_value` FROM `tb_order_references` `tor` WHERE `o`.`id`=`tor`.`order_id` AND `tor`.`reference_id`=? AND `tor`.`status`=? ORDER BY `tor`.`id` DESC LIMIT ?) AS `delivery_note`,
				(SELECT `tor`.`ref_value` FROM `tb_order_references` `tor` WHERE `o`.`id`=`tor`.`order_id` AND `tor`.`reference_id`=? AND `tor`.`status`=? ORDER BY `tor`.`id` DESC LIMIT ?) AS `sd_reference`,
				(SELECT `tor`.`ref_value` FROM `tb_order_references` `tor` WHERE `o`.`id`=`tor`.`order_id` AND `tor`.`reference_id`=? AND `tor`.`status`=? ORDER BY `tor`.`id` DESC LIMIT ?) AS `sdt_reference`,
				(SELECT convertToClientTZ(`tps`.`createdon`,?) AS createdon FROM `tb_stop_status` `tps` WHERE `o`.`id`=`tps`.`order_id` AND `tps`.`stop_type`=? AND `tps`.`status_code`=? AND `tps`.`status`=? LIMIT ?) AS actual_pickup,
				(SELECT convertToClientTZ(`tps`.`createdon`,?) AS createdon FROM `tb_stop_status` `tps` WHERE `o`.`id`=`tps`.`order_id` AND `tps`.`stop_type`=? AND `tps`.`status_code`=? AND `tps`.`status`=? LIMIT ?) AS actual_delivery,
				(SELECT convertToClientTZ(`tps`.`createdon`,?) AS createdon FROM `tb_stop_status` `tps` WHERE `o`.`id`=`tps`.`order_id` AND `tps`.`status_code`=? AND `tps`.`status`=? LIMIT ?) AS booked_by_supplier,
				CASE WHEN (SELECT COUNT(`tpu`.`id`) AS `is_pod` FROM `tb_pod_uploads` `tpu` WHERE `o`.`id`=`tpu`.`order_id` AND `doc_type`=? AND `status`=?) > 0 THEN 'YES' ELSE 'NO' END AS pod_status,
                (SELECT `tor`.`ref_value` FROM `tb_order_references` `tor` WHERE `o`.`id`=`tor`.`order_id` AND `tor`.`reference_id`=? AND `tor`.`status`=? ORDER BY `tor`.`id` DESC LIMIT ?) AS `delivery_instruction`,
                (SELECT `tor`.`ref_value` FROM `tb_order_references` `tor` WHERE `o`.`id`=`tor`.`order_id` AND `tor`.`reference_id`=? AND `tor`.`status`=? ORDER BY `tor`.`id` DESC LIMIT ?) AS `pickup_instruction`
				FROM `tb_orders` `o`
				WHERE `o`.`status` IN ? AND trip_sts = ? AND DATE(`o`.`createdon`) >= ? AND DATE(`o`.`createdon`) <= ? AND `o`.`company_code` = ?
				ORDER BY `o`.`id` DESC";
                $bindParams[] = $timeZone;
                $bindParams[] = $timeZone;
                $bindParams[] = $timeZone;
                $bindParams[] = 'XSR';
                $bindParams[] = 1;
                $bindParams[] = 1;
                $bindParams[] = 'DQ';
                $bindParams[] = 1;
                $bindParams[] = 1;
                $bindParams[] = 'SD';
                $bindParams[] = 1;
                $bindParams[] = 1;
                $bindParams[] = 'SDT';
                $bindParams[] = 1;
                $bindParams[] = 1;
                $bindParams[] = $timeZone;
                $bindParams[] = 'P';
                $bindParams[] = '0500';
                $bindParams[] = 1;
                $bindParams[] = 1;
                $bindParams[] = $timeZone;
                $bindParams[] = 'D';
                $bindParams[] = '2300';
                $bindParams[] = 1;
                $bindParams[] = 1;
                $bindParams[] = $timeZone;
                $bindParams[] = '0100';
                $bindParams[] = 1;
                $bindParams[] = 1;
                $bindParams[] = 3;
                $bindParams[] = 1;
                $bindParams[] = 'ORD_DLVINST';
                $bindParams[] = 1;
                $bindParams[] = 1;
                $bindParams[] = 'ORD_PIKINST';
                $bindParams[] = 1;
                $bindParams[] = 1;
                $bindParams[] = [1,2];
                $bindParams[] = 0;
                $bindParams[] = $fromDate;
                $bindParams[] = $toDate;
                $bindParams[] = $countryCode;
                $result = $this->common->fetchRecordsByCustomQry($sql,$bindParams);
            }
        }
        if ($result && $emailList) {
            $fileName = "";
            $styleArray = [
                'font' => [
                    'bold' => true,
                    'color' => ['rgb' => '000000'],
                    'size' => 10,
                    'name' => 'Verdana'
                ]
            ];
            $cacheMethod = PHPExcel_CachedObjectStorageFactory::cache_to_sqlite;
            $cacheSettings = array('memoryCacheSize' => '512MB');
            PHPExcel_Settings::setCacheStorageMethod($cacheMethod, $cacheSettings);
            $objPHPExcel = new PHPExcel();
            $objPHPExcel->setActiveSheetIndex(0);
            $objPHPExcel->getActiveSheet()
                ->getStyle('A1:U1')
                ->applyFromArray(
                    [
                        'fill' => [
                            'type' => PHPExcel_Style_Fill::FILL_SOLID,
                            'color' => ['rgb' => 'FFFFFF']
                        ],
                        'alignment' => [
                            'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER
                        ]
                    ]
                );
            $objPHPExcel->getActiveSheet()->mergeCells('A1:W1');
            $objPHPExcel->getActiveSheet()->SetCellValue('A1', 'Customer Daily Status Report - svkonekt');
            $objPHPExcel->getActiveSheet()->SetCellValue('B2', 'Booking ID');
            $objPHPExcel->getActiveSheet()->SetCellValue('C2', 'Product');
            $objPHPExcel->getActiveSheet()->SetCellValue('D2', 'Customer');
            $objPHPExcel->getActiveSheet()->SetCellValue('E2', 'Department');
            $objPHPExcel->getActiveSheet()->SetCellValue('F2', 'SDT');
            $objPHPExcel->getActiveSheet()->SetCellValue('G2', 'Order Created On');
            $objPHPExcel->getActiveSheet()->SetCellValue('H2', 'Booked by Supplier');
            $objPHPExcel->getActiveSheet()->SetCellValue('I2', 'Driver Pickup Instructions');
            $objPHPExcel->getActiveSheet()->SetCellValue('J2', 'Pickup Address');
            $objPHPExcel->getActiveSheet()->SetCellValue('K2', 'Pickup Status Date & Time');
            $objPHPExcel->getActiveSheet()->SetCellValue('L2', 'Driver Delivery Instructions');
            $objPHPExcel->getActiveSheet()->SetCellValue('M2', 'Delivery Address');
            $objPHPExcel->getActiveSheet()->SetCellValue('N2', 'Delivery Date/Time');
            $objPHPExcel->getActiveSheet()->SetCellValue('O2', 'Delivery Note');
            $objPHPExcel->getActiveSheet()->SetCellValue('P2', 'SALOG Ref');
            $objPHPExcel->getActiveSheet()->SetCellValue('Q2', 'Trip ID');
            $objPHPExcel->getActiveSheet()->SetCellValue('R2', 'Carrier');
            $objPHPExcel->getActiveSheet()->SetCellValue('S2', 'Shipper Name');
            $objPHPExcel->getActiveSheet()->SetCellValue('T2', 'Consignee Name');
            $objPHPExcel->getActiveSheet()->SetCellValue('U2', 'Actual Pickup');
            $objPHPExcel->getActiveSheet()->SetCellValue('V2', 'Actual Delivery');
            $objPHPExcel->getActiveSheet()->SetCellValue('W2', 'POD Status');
            $objPHPExcel->getActiveSheet()->getStyle('A2:W2')->applyFromArray($styleArray);
            $rowCount = 3;
            foreach ($result as $i => $data) {
                $pickupAddress = $deliveryAddress = [];
                $pickupAddress[] = $data['pickup_address1'];
                $pickupAddress[] = $data['pickup_city'];
                $pickupAddress[] = $data['pickup_pincode'];
                $deliveryAddress[] = $data['delivery_address1'];
                $deliveryAddress[] = $data['delivery_city'];
                $deliveryAddress[] = $data['delivery_pincode'];
                $objPHPExcel->getActiveSheet()->SetCellValue('B'.$rowCount, $data['order_id']);
                $objPHPExcel->getActiveSheet()->SetCellValue('C'.$rowCount, $data['product']);
                $objPHPExcel->getActiveSheet()->SetCellValue('D'.$rowCount, $data['customer_name']);
                $objPHPExcel->getActiveSheet()->SetCellValue('E'.$rowCount, $data['sd_reference']);
                $objPHPExcel->getActiveSheet()->SetCellValue('F'.$rowCount, $data['sdt_reference']);
                $objPHPExcel->getActiveSheet()->SetCellValue('G'.$rowCount, date('d-m-Y h:i A',strtotime($data['createdon'])));
                $objPHPExcel->getActiveSheet()->SetCellValue('H'.$rowCount, date('d-m-Y h:i A',strtotime($data['booked_by_supplier'])));
                $objPHPExcel->getActiveSheet()->SetCellValue('I'.$rowCount, $data['pickup_instruction']);
                $objPHPExcel->getActiveSheet()->SetCellValue('J'.$rowCount, implode(',', $pickupAddress));
                $objPHPExcel->getActiveSheet()->SetCellValue('K'.$rowCount, date('d-m-Y h:i A',strtotime($data['pickup_datetime'])));
                $objPHPExcel->getActiveSheet()->SetCellValue('L'.$rowCount, $data['delivery_instruction']);
                $objPHPExcel->getActiveSheet()->SetCellValue('M'.$rowCount, implode(',', $deliveryAddress));
                $objPHPExcel->getActiveSheet()->SetCellValue('N'.$rowCount, date('d-m-Y h:i A',strtotime($data['delivery_datetime'])));
                $objPHPExcel->getActiveSheet()->SetCellValue('O'.$rowCount, $data['delivery_note']);
                $objPHPExcel->getActiveSheet()->SetCellValue('P'.$rowCount, $data['salog_ref']);
                $objPHPExcel->getActiveSheet()->SetCellValue('Q'.$rowCount, $data['shipmentid']);
                $objPHPExcel->getActiveSheet()->SetCellValue('R'.$rowCount, $data['vendor_name']);
                $objPHPExcel->getActiveSheet()->SetCellValue('S'.$rowCount, $data['pickup_company']);
                $objPHPExcel->getActiveSheet()->SetCellValue('T'.$rowCount, $data['delivery_company']);
                $objPHPExcel->getActiveSheet()->SetCellValue('U'.$rowCount, $data['actual_pickup'] ? date('d-m-Y h:i A', strtotime($data['actual_pickup'])) : '');
                $objPHPExcel->getActiveSheet()->SetCellValue('V'.$rowCount, $data['actual_delivery'] ? date('d-m-Y h:i A', strtotime($data['actual_delivery'])) : '');
                $objPHPExcel->getActiveSheet()->SetCellValue('W'.$rowCount, $data['pod_status']);
                $rowCount++;
            }
            $fileName = 'BUFO_Svkonekt_LMV_'.date("Ymdhis").'.xlsx';
            $objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel2007');
            if (!file_exists('assets/general_reports')) {
                mkdir('assets/general_reports', 0710, true);
            }
            try {
                $objWriter->save(str_replace(__FILE__, 'assets/general_reports/' . $fileName, __FILE__));
            } catch (PHPExcel_Writer_Exception $e) {
                log_error("BUFO Order Report PHPExel_Writer_Exception " . $e->getMessage());
            }
            $toAddressList = explode(',', $emailList['report_emails_to']);
            $ccAddressList = explode(',', $emailList['report_emails_cc']);
            $bccAddressList = explode(',', $emailList['report_emails_bcc']);
            try {
                $subject = "AUTOEMAIL - BUFO ORDER MONITORING";
                $filePath = sprintf('%s/assets/general_reports/%s', FCPATH, $fileName);
                $files = [$filePath];
                $body = $this->getEmailBody();
                if (!$this->phpmailerlibrary->sendMultipleToMail($toAddressList, $subject, $body, $ccAddressList, $files,$bccAddressList)) {
                    log_message("error", "Unable to send the BUFO email of ORDER STATUS MONITORING");
                } else {
                    log_message("error", "BUFO email of ORDER STATUS MONITORING report has been sent successfully");
                }
            } catch (Exception $e) {
                log_message("error", "Email of BUFO ORDER STATUS MONITORING report not send on ".date('d-m-Y h:i A')."-".$e->getMessage());
            }
        }
    }

    private function sendCarrierReport(string $fromDate, string $toDate): void {
        $carrierListSQL = $this->common->fetchRecordsByCustomQry("SELECT `condition` FROM `access_conditions` WHERE `title` = ?",['BUFO_EMAIL_REPORT_CARRIERS'], FALSE);
        $carrierList = explode(',', $carrierListSQL['condition']);
        $result = $emailList = [];
        foreach ($carrierList as $carrierCode) {
            $sql = "SELECT report_emails_to,report_emails_cc, report_emails_bcc FROM tbl_party_master WHERE `code`=? AND report_emails_to !='' LIMIT ?";
            $emailList = $this->common->fetchRecordsByCustomQry($sql,[$carrierCode, 1], FALSE);
            if ($emailList) {
                $sql = "SELECT `c`.`cntry_timezone`,`v`.`id`
						FROM tbl_party_master p
						INNER JOIN tb_vendors v ON (`v`.`code` = `p`.`code`)
						LEFT JOIN tb_users u ON (u.id = p.user_id)
						LEFT JOIN tbl_country_master c ON (c.country_code = u.country_code)
						WHERE `p`.`code` = ? LIMIT ?";
                $timeZoneSQL = $this->common->fetchRecordsByCustomQry($sql,[$carrierCode, 1], FALSE);
                $timeZone = $timeZoneSQL['cntry_timezone'];
                $bindParams = [];
                $sql = "SELECT
				`o`.`order_id`,
				convertToClientTZ(`o`.`pickup_datetime`,?) AS pickup_datetime,
				convertToClientTZ(`o`.`delivery_datetime`,?) AS delivery_datetime,
				`o`.`pickup_company`,
				`o`.`delivery_company`,
				`o`.`pickup_address1`,
				`o`.`pickup_city`,
				`o`.`delivery_address1`,
				`o`.`delivery_city`,
				`o`.`pickup_pincode`,
				`o`.`delivery_pincode`,
				`o`.`pickup_address2`,
				`o`.`delivery_address2`,
				`o`.`status`,
				`o`.`trip_id`,
				`o`.`shipmentid`,
				`o`.`product`,
				convertToClientTZ(`o`.`createdon`,?) AS createdon,
				(SELECT `v`.`name` FROM `tb_vendors` `v` WHERE `o`.`vendor_id`=`v`.`id`) AS `vendor_name`,
				(SELECT `c`.`name` FROM `tb_customers` `c` WHERE `o`.`customer_id`=`c`.`id`) AS `customer_name`,
				(SELECT `tor`.`ref_value` FROM `tb_order_references` `tor` WHERE `o`.`id`=`tor`.`order_id` AND `tor`.`reference_id`=? ORDER BY `tor`.`id` DESC LIMIT ?) AS `salog_ref`,
				(SELECT `tor`.`ref_value` FROM `tb_order_references` `tor` WHERE `o`.`id`=`tor`.`order_id` AND `tor`.`reference_id`=? ORDER BY `tor`.`id` DESC LIMIT ?) AS `delivery_note`,
				(SELECT convertToClientTZ(`tps`.`createdon`,?) AS createdon FROM `tb_stop_status` `tps` WHERE `o`.`id`=`tps`.`order_id` AND `tps`.`stop_type`=? AND `tps`.`status_code`=? AND `tps`.`status`=? LIMIT ?) AS actual_pickup,
				(SELECT convertToClientTZ(`tps`.`createdon`,?) AS createdon FROM `tb_stop_status` `tps` WHERE `o`.`id`=`tps`.`order_id` AND `tps`.`stop_type`=? AND `tps`.`status_code`=? AND `tps`.`status`=? LIMIT ?) AS actual_delivery,
				(SELECT convertToClientTZ(`tps`.`createdon`,?) AS createdon FROM `tb_stop_status` `tps` WHERE `o`.`id`=`tps`.`order_id` AND `tps`.`status_code`=? AND `tps`.`status`=? LIMIT ?) AS booked_by_supplier,
				CASE WHEN (SELECT COUNT(`tpu`.`id`) AS `is_pod` FROM `tb_pod_uploads` `tpu` WHERE `o`.`id`=`tpu`.`order_id` AND `doc_type`=? AND `status`=?) > 0 THEN 'YES' ELSE 'NO' END AS pod_status,
                (SELECT `tor`.`ref_value` FROM `tb_order_references` `tor` WHERE `o`.`id`=`tor`.`order_id` AND `tor`.`reference_id`=? AND `tor`.`status`=? ORDER BY `tor`.`id` DESC LIMIT ?) AS `delivery_instruction`,
                (SELECT `tor`.`ref_value` FROM `tb_order_references` `tor` WHERE `o`.`id`=`tor`.`order_id` AND `tor`.`reference_id`=? AND `tor`.`status`=? ORDER BY `tor`.`id` DESC LIMIT ?) AS `pickup_instruction`
				FROM `tb_orders` `o`
				WHERE `o`.`status` IN ? AND trip_sts = ? AND DATE(`o`.`createdon`) >= ? AND DATE(`o`.`createdon`) <= ? AND `o`.`vendor_id` = ?
				ORDER BY `o`.`id` DESC";
                $bindParams[] = $timeZone;
                $bindParams[] = $timeZone;
                $bindParams[] = $timeZone;
                $bindParams[] = 'XSR';
                $bindParams[] = 1;
                $bindParams[] = 'DQ';
                $bindParams[] = 1;
                $bindParams[] = $timeZone;
                $bindParams[] = 'P';
                $bindParams[] = '0500';
                $bindParams[] = 1;
                $bindParams[] = 1;
                $bindParams[] = $timeZone;
                $bindParams[] = 'D';
                $bindParams[] = '2300';
                $bindParams[] = 1;
                $bindParams[] = 1;
                $bindParams[] = $timeZone;
                $bindParams[] = '0100';
                $bindParams[] = 1;
                $bindParams[] = 1;
                $bindParams[] = 3;
                $bindParams[] = 1;
                $bindParams[] = 'ORD_DLVINST';
                $bindParams[] = 1;
                $bindParams[] = 1;
                $bindParams[] = 'ORD_PIKINST';
                $bindParams[] = 1;
                $bindParams[] = 1;
                $bindParams[] = [1,2];
                $bindParams[] = 0;
                $bindParams[] = $fromDate;
                $bindParams[] = $toDate;
                $bindParams[] = $timeZoneSQL['id'];
                $result = $this->common->fetchRecordsByCustomQry($sql,$bindParams);
            }
        }
        if ($result && $emailList) {
            $styleArray = [
                'font' => [
                    'bold' => true,
                    'color' => ['rgb' => '000000'],
                    'size' => 10,
                    'name' => 'Verdana'
                ]
            ];

            $cacheMethod = PHPExcel_CachedObjectStorageFactory::cache_to_sqlite;
            $cacheSettings = array('memoryCacheSize' => '512MB');
            PHPExcel_Settings::setCacheStorageMethod($cacheMethod, $cacheSettings);

            $objPHPExcel = new PHPExcel();
            $objPHPExcel->setActiveSheetIndex(0);
            $objPHPExcel->getActiveSheet()
                ->getStyle('A1:R1')
                ->applyFromArray(
                    [
                        'fill' => [
                            'type' => PHPExcel_Style_Fill::FILL_SOLID,
                            'color' => ['rgb' => 'FFFFFF']
                        ],
                        'alignment' => [
                            'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER
                        ]
                    ]
                );
            $objPHPExcel->getActiveSheet()->mergeCells('A1:R1');
            $objPHPExcel->getActiveSheet()->SetCellValue('A1', 'Customer Daily Status Report - svkonekt');
            $objPHPExcel->getActiveSheet()->SetCellValue('B2', 'Carrier');
            $objPHPExcel->getActiveSheet()->SetCellValue('C2', 'Booking ID');
            $objPHPExcel->getActiveSheet()->SetCellValue('D2', 'SALOG Ref');
            $objPHPExcel->getActiveSheet()->SetCellValue('E2', 'Customer');
            $objPHPExcel->getActiveSheet()->SetCellValue('F2', 'Driver Pickup Instructions');
            $objPHPExcel->getActiveSheet()->SetCellValue('G2', 'Pickup Address');
            $objPHPExcel->getActiveSheet()->SetCellValue('H2', 'Delivery Address');
            $objPHPExcel->getActiveSheet()->SetCellValue('I2', 'Pickup Status Date & Time');
            $objPHPExcel->getActiveSheet()->SetCellValue('J2', 'Driver Delivery Instructions');
            $objPHPExcel->getActiveSheet()->SetCellValue('K2', 'Delivery Date/Time');
            $objPHPExcel->getActiveSheet()->SetCellValue('L2', 'Delivery Note');
            $objPHPExcel->getActiveSheet()->SetCellValue('M2', 'Trip ID');
            $objPHPExcel->getActiveSheet()->SetCellValue('N2', 'Shipper Name');
            $objPHPExcel->getActiveSheet()->SetCellValue('O2', 'Consignee Name');
            $objPHPExcel->getActiveSheet()->SetCellValue('P2', 'Actual Pickup');
            $objPHPExcel->getActiveSheet()->SetCellValue('Q2', 'Actual Delivery');
            $objPHPExcel->getActiveSheet()->SetCellValue('R2', 'POD Status');

            $objPHPExcel->getActiveSheet()->getStyle('A2:R2')->applyFromArray($styleArray);
            $rowCount = 3;
            foreach ($result as $i => $data) {
                $pickupAddress = $deliveryAddress = [];
                $pickupAddress[] = $data['pickup_address1'];
                $pickupAddress[] = $data['pickup_city'];
                $pickupAddress[] = $data['pickup_pincode'];
                $deliveryAddress[] = $data['delivery_address1'];
                $deliveryAddress[] = $data['delivery_city'];
                $deliveryAddress[] = $data['delivery_pincode'];
                $objPHPExcel->getActiveSheet()->SetCellValue('B'.$rowCount, $data['vendor_name']);
                $objPHPExcel->getActiveSheet()->SetCellValue('C'.$rowCount, $data['order_id']);
                $objPHPExcel->getActiveSheet()->SetCellValue('D'.$rowCount, $data['salog_ref']);
                $objPHPExcel->getActiveSheet()->SetCellValue('E'.$rowCount, $data['customer_name']);
                $objPHPExcel->getActiveSheet()->SetCellValue('F'.$rowCount, $data['pickup_instruction']);
                $objPHPExcel->getActiveSheet()->SetCellValue('G'.$rowCount, implode(',', $pickupAddress));
                $objPHPExcel->getActiveSheet()->SetCellValue('H'.$rowCount, implode(',', $deliveryAddress));
                $objPHPExcel->getActiveSheet()->SetCellValue('I'.$rowCount, date('d-m-Y h:i A',strtotime($data['pickup_datetime'])));
                $objPHPExcel->getActiveSheet()->SetCellValue('J'.$rowCount, $data['delivery_instruction']);
                $objPHPExcel->getActiveSheet()->SetCellValue('K'.$rowCount, date('d-m-Y h:i A',strtotime($data['delivery_datetime'])));
                $objPHPExcel->getActiveSheet()->SetCellValue('L'.$rowCount, $data['delivery_note']);
                $objPHPExcel->getActiveSheet()->SetCellValue('M'.$rowCount, $data['shipmentid']);
                $objPHPExcel->getActiveSheet()->SetCellValue('N'.$rowCount, $data['pickup_company']);
                $objPHPExcel->getActiveSheet()->SetCellValue('O'.$rowCount, $data['delivery_company']);
                $objPHPExcel->getActiveSheet()->SetCellValue('P'.$rowCount, $data['actual_pickup'] ? date('d-m-Y h:i A', strtotime($data['actual_pickup'])) : '');
                $objPHPExcel->getActiveSheet()->SetCellValue('Q'.$rowCount, $data['actual_delivery'] ? date('d-m-Y h:i A', strtotime($data['actual_delivery'])) : '');
                $objPHPExcel->getActiveSheet()->SetCellValue('R'.$rowCount, $data['pod_status']);
                $rowCount++;
            }
            $fileName = 'CARRIER_Svkonekt_LMV_'.date("Ymdhis").'.xlsx';
            $objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel2007');
            if (!file_exists('assets/general_reports')) {
                mkdir('assets/general_reports', 0710, true);
            }
            try {
                $objWriter->save(str_replace(__FILE__, 'assets/general_reports/' . $fileName, __FILE__));
            } catch (PHPExcel_Writer_Exception $e) {
                log_error("Carrier Report PHPExel_Writer_Exception " . $e->getMessage());
            }

            $toAddressList = explode(',', $emailList['report_emails_to']);
            $ccAddressList = explode(',', $emailList['report_emails_cc']);
            $bccAddressList = explode(',', $emailList['report_emails_bcc']);
            try {
                $subject = "AUTOEMAIL - DV MOVERS ORDER STATUS (OPEN/ACTIVE)";
                $filePath = sprintf('%s/assets/general_reports/%s', FCPATH, $fileName);
                $files = [$filePath];
                $body = $this->getEmailBody();
                if (!$this->phpmailerlibrary->sendMultipleToMail($toAddressList, $subject, $body, $ccAddressList, $files,$bccAddressList)) {
                    log_message("error", "Unable to send the CARRIER email of ORDER STATUS MONITORING");
                } else {
                    log_message("error", "CARRIER email of ORDER STATUS MONITORING report has been sent successfully");
                }
            } catch (Exception $e) {
                log_message("error", "Email of CARRIER ORDER STATUS MONITORING report not send on ".date('d-m-Y h:i A')."-".$e->getMessage());
            }
        }
    }

    public function getEmailBody(): string {
        $html   = "Hello, <br>";
        $html  .= "Please find attached for above mentioned subject.<br>";
        $html  .= "Sincerely,<br>";
        $html  .= "Road Logistics";
        return $html;
    }

    public function sendEmailOfTWBReport(int $sessionType=0) {
        $this->load->library(['parser', 'PhpMailerLibrary']);
        $this->load->model('common');
        $fromDate 	= date("Y-m-d",strtotime("-1 month"));
        $toDate 	= ($sessionType === 1) ? date("Y-m-d") : date("Y-m-d",strtotime("-1 day"));
        $this->generateTWBReport($fromDate, $toDate);
    }

    private function generateTWBReport(string $fromDate, string $toDate) {
        $customersListSQL = $this->common->fetchRecordsByCustomQry("SELECT `condition` FROM `access_conditions` WHERE `title` = ?",['TWB_REPORT_EMAIL_TO_CUSTOMERS'], FALSE);
        $customersList = explode(',', $customersListSQL['condition']);
        foreach ($customersList as $customerCode) {
            $result = $emailList = [];
            $bccAddressList = [];
            $sql = "SELECT id,user_id,email_id,report_emails_to FROM `tb_customers` WHERE `code`= ? AND `status`=? AND report_emails_to !='' ORDER BY id DESC LIMIT ?";
            $emailList = $this->common->fetchRecordsByCustomQry($sql,[$customerCode, 1, 1], FALSE);
            if ($emailList) {
                if ($emailList['email_id']) {
                    $bccAddressList[] = $emailList['email_id'];
                }
                $sql = "SELECT c.cntry_timezone FROM tb_users u
						LEFT JOIN tbl_country_master c ON (c.country_code = u.country_code)
						WHERE u.id = ? LIMIT ?";
                $timeZoneSQL = $this->common->fetchRecordsByCustomQry($sql,[$emailList['user_id'], 1], FALSE);
                $timeZone = $timeZoneSQL['cntry_timezone'];
                $bindParams = [];
                $sql = "SELECT
				`o`.`id`,
				`o`.`order_id`,
				convertToClientTZ(`o`.`pickup_datetime`,?) AS pickup_datetime,
				convertToClientTZ(`o`.`delivery_datetime`,?) AS delivery_datetime,
				`o`.`pickup_company`,
				`o`.`delivery_company`,
				`o`.`shipmentid`,
				`o`.`pickup_address1`,
				`o`.`pickup_city`,
				`o`.`delivery_address1`,
				`o`.`delivery_city`,
				`o`.`pickup_pincode`,
				`o`.`delivery_pincode`,
				`o`.`pickup_address2`,
				`o`.`delivery_address2`,
				`o`.`status`,
				`o`.`trip_sts`,
				`o`.`trip_id`,
				`o`.`shipmentid`,
				`o`.`vendor_id`,
				`o`.`product`,
				convertToClientTZ(`o`.`createdon`,?) AS createdon,
				(SELECT `v`.`name` FROM `tb_vendors` `v` WHERE `o`.`vendor_id`=`v`.`id`) AS `vendor_name`,
				(SELECT `v`.`email` FROM `tb_vendors` `v` WHERE `o`.`vendor_id`=`v`.`id`) AS `vendor_email_id`,
				(SELECT `c`.`name` FROM `tb_customers` `c` WHERE `o`.`customer_id`=`c`.`id`) AS `customer_name`,
				(SELECT `tor`.`ref_value` FROM `tb_order_references` `tor` WHERE `o`.`id`=`tor`.`order_id` AND `tor`.`reference_id`=? ORDER BY `tor`.`id` DESC LIMIT ?) AS `salog_ref`,
				(SELECT `tor`.`ref_value` FROM `tb_order_references` `tor` WHERE `o`.`id`=`tor`.`order_id` AND `tor`.`reference_id`=? ORDER BY `tor`.`id` DESC LIMIT ?) AS `delivery_note`,
				(SELECT convertToClientTZ(`tps`.`createdon`,?) AS createdon FROM `tb_stop_status` `tps` WHERE `o`.`id`=`tps`.`order_id` AND `tps`.`stop_type`=? AND `tps`.`status_code`=? AND `tps`.`status`=? LIMIT ?) AS actual_pickup,
				(SELECT convertToClientTZ(`tps`.`createdon`,?) AS createdon FROM `tb_stop_status` `tps` WHERE `o`.`id`=`tps`.`order_id` AND `tps`.`stop_type`=? AND `tps`.`status_code`=? AND `tps`.`status`=? LIMIT ?) AS actual_delivery,
				(SELECT convertToClientTZ(`tps`.`createdon`,?) AS createdon FROM `tb_stop_status` `tps` WHERE `o`.`id`=`tps`.`order_id` AND `tps`.`status_code`=? AND `tps`.`status`=? LIMIT ?) AS booked_by_supplier,
				CASE WHEN (SELECT COUNT(`tpu`.`id`) AS `is_pod` FROM `tb_pod_uploads` `tpu` WHERE `o`.`id`=`tpu`.`order_id` AND `doc_type`=? AND `status`=?) > 0 THEN 'YES' ELSE 'NO' END AS pod_status
				FROM `tb_orders` `o`
				WHERE DATE(`o`.`createdon`) >= ? AND DATE(`o`.`createdon`) <= ? AND `o`.`customer_id` = ? AND `o`.`status` != ? AND `o`.`trip_sts` != ?
				ORDER BY `o`.`id` DESC";
                $bindParams[] = $timeZone;
                $bindParams[] = $timeZone;
                $bindParams[] = $timeZone;
                $bindParams[] = 'XSR';
                $bindParams[] = 1;
                $bindParams[] = 'DQ';
                $bindParams[] = 1;
                $bindParams[] = $timeZone;
                $bindParams[] = 'P';
                $bindParams[] = '0500';
                $bindParams[] = 1;
                $bindParams[] = 1;
                $bindParams[] = $timeZone;
                $bindParams[] = 'D';
                $bindParams[] = '2300';
                $bindParams[] = 1;
                $bindParams[] = 1;
                $bindParams[] = $timeZone;
                $bindParams[] = '0100';
                $bindParams[] = 1;
                $bindParams[] = 1;
                $bindParams[] = 3;
                $bindParams[] = 1;
                $bindParams[] = $fromDate;
                $bindParams[] = $toDate;
                $bindParams[] = $emailList['id'];
                $bindParams[] = 0;
                $bindParams[] = 1;
                $result = $this->common->fetchRecordsByCustomQry($sql,$bindParams);
            }
            if ($result && $emailList) {
                $styleArray = [
                    'font' => [
                        'bold' => true,
                        'color' => ['rgb' => '000000'],
                        'size' => 10,
                        'name' => 'Verdana'
                    ]
                ];

                $cacheMethod = PHPExcel_CachedObjectStorageFactory::cache_to_sqlite;
                $cacheSettings = array('memoryCacheSize' => '512MB');
                PHPExcel_Settings::setCacheStorageMethod($cacheMethod, $cacheSettings);

                $objPHPExcel = new PHPExcel();
                $objPHPExcel->setActiveSheetIndex(0);
                $objPHPExcel->getActiveSheet()
                    ->getStyle('A1:R1')
                    ->applyFromArray(
                        [
                            'fill' => [
                                'type' => PHPExcel_Style_Fill::FILL_SOLID,
                                'color' => ['rgb' => 'FFFFFF']
                            ],
                            'alignment' => [
                                'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER
                            ]
                        ]
                    );
                $objPHPExcel->getActiveSheet()->mergeCells('A1:T1');
                $objPHPExcel->getActiveSheet()->SetCellValue('A1', 'Customer Daily Status Report - SVKONEKT');
                $objPHPExcel->getActiveSheet()->SetCellValue('B2', 'Customer');
                $objPHPExcel->getActiveSheet()->SetCellValue('C2', 'Booking ID');
                $objPHPExcel->getActiveSheet()->SetCellValue('D2', 'Truck Way Bill no.');
                $objPHPExcel->getActiveSheet()->SetCellValue('E2', 'Trip ID');
                $objPHPExcel->getActiveSheet()->SetCellValue('F2', 'Pickup Address');
                $objPHPExcel->getActiveSheet()->SetCellValue('G2', 'Delivery Address');
                $objPHPExcel->getActiveSheet()->SetCellValue('H2', 'Pickup Status Date & Time');
                $objPHPExcel->getActiveSheet()->SetCellValue('I2', 'Delivery Date/Time');
                $objPHPExcel->getActiveSheet()->SetCellValue('J2', 'Delivery Note');
                $objPHPExcel->getActiveSheet()->SetCellValue('K2', 'Shipper Name');
                $objPHPExcel->getActiveSheet()->SetCellValue('L2', 'Consignee Name');
                $objPHPExcel->getActiveSheet()->SetCellValue('M2', 'Status');
                $objPHPExcel->getActiveSheet()->SetCellValue('N2', 'Actual Pickup');
                $objPHPExcel->getActiveSheet()->SetCellValue('O2', 'Actual Delivery');
                $objPHPExcel->getActiveSheet()->SetCellValue('P2', 'POD Status');
                $objPHPExcel->getActiveSheet()->SetCellValue('Q2', 'Cargo Type');
                $objPHPExcel->getActiveSheet()->SetCellValue('R2', 'Goods Description');
                $objPHPExcel->getActiveSheet()->SetCellValue('S2', 'Quantity');
                $objPHPExcel->getActiveSheet()->SetCellValue('T2', 'Weight');
                $objPHPExcel->getActiveSheet()->getStyle('A2:T2')->applyFromArray($styleArray);
                $rowCount = 3;
                $bccAddressList[] = 'sol.ignacio@kuehne-nagel.com';
                foreach ($result as $i => $data) {
                    if (!empty($data['vendor_email_id']) && !(in_array($data['vendor_email_id'], $bccAddressList))) {
                        $bccAddressList[] = $data['vendor_email_id'];
                    }
                    $statusName = ((int)$data['trip_id'] > 0 && (int)$data['trip_sts'] === 0) ? "ACTIVE" : "PENDING";
    				$cargoSQL  = "SELECT quantity_type,cargo_content,quantity,weight,volweight_uom FROM tb_order_cargodetails WHERE `order_id`=? AND `status`=?";
    				$cargoList = $this->common->fetchRecordsByCustomQry($cargoSQL,[$data['id'], 1]);
    				$pickupAddress = $deliveryAddress = [];
    				$pickupAddress[] = $data['pickup_address1'];
    				$pickupAddress[] = $data['pickup_city'];
    				$pickupAddress[] = $data['pickup_pincode'];
    				$deliveryAddress[] = $data['delivery_address1'];
    				$deliveryAddress[] = $data['delivery_city'];
    				$deliveryAddress[] = $data['delivery_pincode'];
                    $objPHPExcel->getActiveSheet()->SetCellValue('B'.$rowCount, $data['customer_name']);
    				$objPHPExcel->getActiveSheet()->SetCellValue('C'.$rowCount, $data['order_id']);
    				$objPHPExcel->getActiveSheet()->SetCellValue('D'.$rowCount, $data['salog_ref'] ? $data['salog_ref'] : $data['order_id']);
                    $objPHPExcel->getActiveSheet()->SetCellValue('E'.$rowCount, $data['shipmentid']);
                    $objPHPExcel->getActiveSheet()->SetCellValue('F'.$rowCount, implode(',', $pickupAddress));
                    $objPHPExcel->getActiveSheet()->SetCellValue('G'.$rowCount, implode(',', $deliveryAddress));
                    $objPHPExcel->getActiveSheet()->SetCellValue('H'.$rowCount, date('d-m-Y h:i A',strtotime($data['pickup_datetime'])));
                    $objPHPExcel->getActiveSheet()->SetCellValue('I'.$rowCount, date('d-m-Y h:i A',strtotime($data['delivery_datetime'])));
                    $objPHPExcel->getActiveSheet()->SetCellValue('J'.$rowCount, $data['delivery_note']);
                    $objPHPExcel->getActiveSheet()->SetCellValue('K'.$rowCount, $data['pickup_company']);
                    $objPHPExcel->getActiveSheet()->SetCellValue('L'.$rowCount, $data['delivery_company']);
                    $objPHPExcel->getActiveSheet()->SetCellValue('M'.$rowCount, $statusName);
                    $objPHPExcel->getActiveSheet()->SetCellValue('N'.$rowCount, $data['actual_pickup'] ? date('d-m-Y h:i A', strtotime($data['actual_pickup'])) : '');
                    $objPHPExcel->getActiveSheet()->SetCellValue('O'.$rowCount, $data['actual_delivery'] ? date('d-m-Y h:i A', strtotime($data['actual_delivery'])) : '');
                    $objPHPExcel->getActiveSheet()->SetCellValue('P'.$rowCount, $data['pod_status']);
                    if ($cargoList) {
                        foreach ($cargoList as $cargo) {
                            $objPHPExcel->getActiveSheet()->SetCellValue('Q'.$rowCount, $cargo['quantity_type']);
                            $objPHPExcel->getActiveSheet()->SetCellValue('R'.$rowCount, $cargo['cargo_content']);
                            $objPHPExcel->getActiveSheet()->SetCellValue('S'.$rowCount, $cargo['quantity']);
                            $objPHPExcel->getActiveSheet()->SetCellValue('T'.$rowCount, $cargo['weight'].' '.$cargo['volweight_uom']);
                            if (count($cargoList) > 1) {
                                $rowCount++;
                            }
                        }
                    }
    				$rowCount++;
    			}
                $fileName = 'TWB_Svkonekt_LMV_'.date("Ymdhis").'.xlsx';
                $objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel2007');
                if (!file_exists('assets/general_reports')) {
                    mkdir('assets/general_reports', 0710, true);
                }
                try {
                    $objWriter->save(str_replace(__FILE__, 'assets/general_reports/' . $fileName, __FILE__));
                } catch (PHPExcel_Writer_Exception $e) {
                    log_error("TWB Report PHPExel_Writer_Exception " . $e->getMessage());
                }
                $toAddressList = explode(',', $emailList['report_emails_to']);
                $ccAddressList = [];
                try {
                    $subject = "AUTOEMAIL - TWB ORDER MONITORING of ".$customerCode;
                    $filePath = sprintf('%s/assets/general_reports/%s', FCPATH, $fileName);
                    $files = [$filePath];
                    $body = $this->getEmailBody();
                    if (!$this->phpmailerlibrary->sendMultipleToMail($toAddressList, $subject, $body, $ccAddressList, $files,$bccAddressList)) {
                        log_message("error", "Unable to send the TWB email of ORDER STATUS MONITORING");
                    } else {
                        log_message("error", "TWB email of ORDER STATUS MONITORING report has been sent successfully");
                    }
                } catch (Exception $e) {
                    log_message("error", "Email of TWB ORDER STATUS MONITORING report not send on ".date('d-m-Y h:i A')."-".$e->getMessage());
                }
            }
        }
    }
}
