<?php if(!defined('BASEPATH')) exit('No direct script access allowed');
class Company extends CI_Controller {

    public function __construct() {
        parent::__construct();
        if($this->session->userdata('user_id') == ''){
            redirect('login');
        }
        $this->load->library('form_validation');
        $this->load->model('common');
        $this->load->model('mastersmodel');
        if (!checkUrlAccessForUser('COMPANY')) {
            redirect("Forbiddenaccess");
        }
    }

    public function index() {
        $data['page_title'] = $this->lang->line('company_info');
        $data['sub_title'] = $this->lang->line('company');
        //$where = array('status'=>1);
        $where = array();
        if($this->input->post('company_code')){
            $where['company_code'] = $this->input->post('company_code');
        }
        $status=$this->input->post('status');
        if (isset($status) && $status!= "") {
            $where['status'] = $status;
        }
        $like = array();
        if($this->input->post('search_string')){
            $like['company_code'] = $this->input->post('search_string');
            $like['company_name'] = $this->input->post('search_string');
            $like['description'] = $this->input->post('search_string');
        }
        $data['companies'] = $this->mastersmodel->getsearchdata($like,$where,'*','tb_company_master');
        $this->newtemplate->dashboard("company/index", $data);
    }

    public function checkCompanyCode($company_code){
        if(empty($company_code)){
            $this->form_validation->set_message('checkCompanyCode','Company Code  Required');
            return FALSE;
        } else {
            $id = $this->uri->segment(3);
            $where = array('company_code'=>$company_code);
            if($id){
                $where['id !='] = $id;
            }
            $company = $this->common->gettblrowdata($where,'company_code','tb_company_master',0,0);
            if(empty($company)){
                return TRUE;
            } else {
                $this->form_validation->set_message('checkCompanyCode',"Already This Company Code Existed");
                return FALSE;
            }
        }
    }

    public function checkCompanyName($company_name){
        if(empty($company_name)){
            $this->form_validation->set_message('checkCompanyName','Company Code  Required');
            return FALSE;
        } else {
            $id = $this->uri->segment(3);
            $where = array('company_name'=>$company_name);
            if($id){
                $where['id !='] = $id;
            }
            $company = $this->common->gettblrowdata($where,'company_name','tb_company_master',0,0);
            if(empty($company)){
                return TRUE;
            } else {
                $this->form_validation->set_message('checkCompanyName',"Already This Company Name Existed");
                return FALSE;
            }
        }
    }

    public function add()   {
        $data['page_title'] = $this->lang->line('company_info');
        $data['sub_title'] = $this->lang->line('company');

        $query = $this->db->query('SELECT company_code FROM tb_company_master');
        $data['code']=$query->result();

        if($_POST){
            $this->form_validation->set_rules('company_code', 'Company Code', 'required|callback_checkCompanyCode');
            $this->form_validation->set_rules('company_name', 'Company Name', 'required|callback_checkCompanyName');
            if ($this->form_validation->run() == false) {
                $data['error']['company_code'] = form_error('company_code');
                $data['error']['company_name'] = form_error('company_name');
                $this->form_validation->set_error_delimiters('<div class="alert alert-danger" style="padding: 5px;margin-left: 10px; margin-right: 10px;" ><a href="#" class="close" data-dismiss="alert" aria-label="close">&times;</a>', '</div>');
                $this->newtemplate->dashboard('company/add', $data);
            } else {
                $array['company_name'] = $this->input->post('company_name');
                $array['company_code'] = $this->input->post('company_code');
                $array['acon_company_code'] = $this->input->post('acon_company_code');
                $array['description'] = $this->input->post('description');
                $array['status'] = 1;
                $array['updatedon'] = date('Y-m-d H:i:s');
                $array['createdon'] = date('Y-m-d H:i:s');
                $result = $this->common->insertTableData('tb_company_master',$array);

                if($this->input->post('xbrdr')!=""){
                    $XborderCountries=implode(",",$this->input->post('xbrdr'));
                    $curntdate=date('Y-m-d H:i:s');
                    $companycode=$this->input->post('company_code');
                    $xborder_array['company_code'] = $companycode;
                    $xborder_array['xborder_code'] = $XborderCountries;
                    $xborder_array['updateon'] =$curntdate;
                    $xborder_array['createdon'] = $curntdate;

                    $getXborderid=$this->common->gettblrowdata(array('company_code'=>$companycode),'id','tb_xborder_country',0,0);
                    if(count($getXborderid)>0){
                        $Xborderid = $getXborderid['id'];
                        $results = $this->common->updatetbledata('tb_xborder_country',$xborder_array,array('company_code'=>$companycode));

                    }else{
                        $results = $this->common->insertTableData('tb_xborder_country',$xborder_array);
                    }
                }
                if(isset($result)){
                    $this->session->set_flashdata('success_msgi','Successfully Created New Company');
                } else {
                    $this->session->set_flashdata('error_msgi','An error occured while inserting data');
                }
                redirect('company');
            }
        } else {
            $this->newtemplate->dashboard('company/add', $data);
        }
    }

    public function edit($id) {
        $data['page_title'] = $this->lang->line('company_info');
        $data['sub_title'] = $this->lang->line('company');
        $data['company'] = $this->common->gettblrowdata(array('id'=>$id),'id,company_code,company_name,description,status,acon_company_code','tb_company_master','tb_company_master',0,0);

        $company_code=$data['company']['company_code'];

        $xborders=$this->db->query("SELECT txc.xborder_code FROM tb_xborder_country txc, tb_company_master tcm WHERE tcm.id='$id' AND txc.company_code='$company_code' AND tcm.status='1'");
        $data['companys'] = $xborders->result_array();




        $query = $this->db->query('SELECT company_code FROM tb_company_master');
        $data['code']=$query->result();

        if(isset($data['company']['id'])) {

            if($_POST){
                if($company_code!=$this->input->post('company_code')){
                     $this->form_validation->set_rules('company_code', 'Company Code', 'required|callback_checkCompanyCode');
                    $this->form_validation->set_rules('company_name', 'Company Name', 'required|callback_checkCompanyName');
                    if ($this->form_validation->run() == false) {
                        $data['error']['company_code'] = form_error('company_code');
                        $data['error']['company_name'] = form_error('company_name');
                        $this->form_validation->set_error_delimiters('<div class="alert alert-danger" style="padding: 5px;margin-left: 10px; margin-right: 10px;" ><a href="#" class="close" data-dismiss="alert" aria-label="close">&times;</a>', '</div>');
                        $this->newtemplate->dashboard('company/edit', $data);
                    } else {
                        $array['company_name'] = $this->input->post('company_name');
                        $array['company_code'] = $this->input->post('company_code');
                        $array['acon_company_code'] = $this->input->post('acon_company_code');
                        $array['description'] = $this->input->post('description');
                        $array['status'] = $this->input->post('status');
                        $array['updatedon'] = date('Y-m-d H:i:s');
                        $result = $this->common->updatetbledata('tb_company_master',$array,array('id'=>$id));
                    }
                }else{
                    $array['company_name'] = $this->input->post('company_name');
                    $array['company_code'] = $this->input->post('company_code');
                    $array['description'] = $this->input->post('description');
                    $array['acon_company_code'] = $this->input->post('acon_company_code');
                    $array['status'] = $this->input->post('status');
                    $array['updatedon'] = date('Y-m-d H:i:s');
                    $result = $this->common->updatetbledata('tb_company_master',$array,array('id'=>$id));

                    if($this->input->post('xbrdr')!=""){
                        $XborderCountries=implode(",",$this->input->post('xbrdr'));
                    }else{
                        $XborderCountries="";
                    }

                    $curntdate=date('Y-m-d H:i:s');
                    $companycode=$this->input->post('company_code');
                    $xborder_array['company_code'] = $companycode;
                    $xborder_array['xborder_code'] = $XborderCountries;
                    $xborder_array['updateon'] =$curntdate;
                    $xborder_array['createdon'] = $curntdate;

                    $getXborderid=$this->common->gettblrowdata(array('company_code'=>$companycode),'id','tb_xborder_country',0,0);
                    if(count($getXborderid)>0){
                        $Xborderid = $getXborderid['id'];
                        $results = $this->common->updatetbledata('tb_xborder_country',$xborder_array,array('company_code'=>$companycode));

                    }else{
                        $results = $this->common->insertTableData('tb_xborder_country',$xborder_array);
                    }

                     /* if ($result) {
                        $this->session->set_flashdata('success_msg', 'Succefully Updated Order Types Info');
                    } else {
                        $this->session->set_flashdata('error_msg', 'An error occurred while Updated data');
                    } */

                    redirect('company');
                }

            } else {
                $this->newtemplate->dashboard('company/edit', $data);
            }
        } else {
            show_error('The Company you are trying to Edit does not exist.');
        }
    }

    public function deletecompany($id){
        if($id != '' || $id != 0){
            $chk = $this->common->gettblrowdata(array('id'=>$id),'id','tb_company_master',0,0);
            if($chk){
                $upd = $this->common->updatetbledata('tb_company_master',array('status'=>0),array('id'=>$id));
                if($upd){
                    echo "1";
                }else{
                    echo "0";
                }
            }else{
                echo "0";
            }
        }
    }

    public function view($id){
        $data['page_title'] = $this->lang->line('company_info');
        $data['sub_title'] = $this->lang->line('company');
        $data['company'] = $this->common->gettblrowdata(array('id'=>$id),'id,company_name,company_code,description,status,acon_company_code','tb_company_master',0,0);

        $company_code=$data['company']['company_code'];

        $xborders=$this->db->query("SELECT txc.xborder_code FROM tb_xborder_country txc, tb_company_master tcm WHERE tcm.id='$id' AND txc.company_code='$company_code' AND tcm.status='1'");
        $data['companys'] = $xborders->result_array();
        $this->newtemplate->dashboard('company/view', $data);
    }

}

