<?php
if (!defined('BASEPATH')) {
    exit('No direct script access allowed');
}

require_once APPPATH . "/third_party/PHPExcel.php";

class Costaudit extends CI_Controller
{
    public function __construct()
    {
        parent::__construct();
        if ($this->session->userdata('user_id') == '') {
            redirect('login');
        }
        $this->load->model("common");
        $this->load->model('costauditmodel');
        if (!checkUrlAccessForUser('COSTAUDIT')) {
            redirect("Forbiddenaccess");
        }
    }

    public function index()
    {
        $this->getsearchresult();
    }

    public function getsearchresult()
    {
        $data['page_title'] = $this->lang->line('menu_costaudit');
        $data['sub_title'] = $this->lang->line('general_search');
        $user_id = $this->session->userdata("user_id");
        $branch_code = $this->session->userdata('branch_code');
        $company_code = $this->session->userdata('company_code');
        $all_limits = [];
        $data['current_currency'] = $this->session->userdata['usr_tzone']['currency'];
        $approvetype_bookings = [];
        $checking_array = ['user_id' => $user_id, 'branch_code' => $branch_code, 'company_code' => $company_code];
        $resoluton_master = $this->common->gettbldata(['status' => 1], "id,code,name", "tbl_resolution_master", 0, 0);
        $data['resoluton_master'] = $resoluton_master;
        $currencies = $this->common->gettbldata(['status' => 1], "id,currency", "tbl_country_master", 0, 0);
        $data['currencies'] = $currencies;
        $post = [];
        $post1 = $this->input->post(null, true);
        if (isset($post1['searchsubmit']) && $post1['searchsubmit'] == "Search") {
            $post = $post1;
        }
        $data['order_ids'] = [];
        if (!empty($post)) {
            $whr = $this->searchsubmitdata($post);
            if (isset($whr['order_ids'])) {
                $checking_array['order_ids'] = $whr['order_ids'];
                unset($whr['order_ids']);
            }
            $isDocumentNumberSet = $flagForPost = 0;
            if (isset($post['doc_number']) && $post['doc_number'] != "") {
                $isDocumentNumberSet = 1;
            }
            $orderdata = $this->costauditmodel->getauditdata($checking_array, $whr, $isDocumentNumberSet);
            foreach ($orderdata as $res) {
                $revenuedata = $this->costauditmodel->getrevenuedata($res['id'], $res['code']);
                $eligible_currency = '-';
                $order_amount = '0.00';
                $b_partner_id = '0';
                $accrualAmount = 0;
                if (!empty($revenuedata)) {
                    $eligible_currency = $revenuedata['ecurrency'];
                    $order_amount = round($revenuedata['order_cost'], 2);
                    $b_partner_id = $revenuedata['business_partner_id'];
                    $accrualAmount = round($revenuedata['accrual_amount'], 2);
                }
                $eligible_amount = round($res['excelamount'], 2);
                $approvedAmount = round($res['approved_amount'], 2);
                $data['order_ids'][] = $res['id'];
                $statusArray = explode(',', $res['audit_status']);
                if ($isDocumentNumberSet == 1) {
                    $statusArrayWithDocumentNumber = $this->costauditmodel->getDocumentStatus($res['id'], $res['vendor_id'], $post['doc_number']);
                    if (!empty($statusArrayWithDocumentNumber)) {
                        $statusArray = $statusArrayWithDocumentNumber;
                    }
                }
                $auditStatus = max($statusArray);
                $eachOrderData = $isDocumentNumberSet > 0 ? $res['id'] . '?????' . $b_partner_id . '?????' . $eligible_amount . '?????' . $res['vendor_id'] . '?????' . $auditStatus . '?????' . $order_amount . '?????' . $res['customer_id'] : '';
                if (array_intersect([1, 3], $statusArray)) {
                    $eligible_amount = $approvedAmount;
                }
                $disputeAmount = $order_amount - $eligible_amount;
                if ($auditStatus == 3) {
                    $disputeAmount = $accrualAmount;
                }
                if (!in_array(0, $statusArray)) {
                    $flagForPost = 1;
                }
                $approvetype_bookings[] = [
                    'each_order_data' => $eachOrderData,
                    'order_row_id' => $res['id'],
                    'order_id' => $res['order_id'],
                    'name' => $res['name'],
                    'code' => $res['code'],
                    'eligible_amount' => $eligible_amount,
                    'utilized_amount' => $order_amount,
                    'eligible_currency' => $eligible_currency,
                    'ccurrency' => $res['ccurrency'],
                    'disputeAmount' => round($disputeAmount, 2),
                    'resolution_id' => $res['resolution_id'],
                    'business_partner_id' => $b_partner_id,
                    'cost_audit_id' => $res['cost_audit_id'],
                    'remarks' => $res['remarks'],
                    'audit_status' => $auditStatus,
                    'doc_num' => $res['doc_num'],
                    'doc_type' => $res['doc_type'],
                    'doc_date' => $res['doc_date'],
                    'vendor_id' => $res['vendor_id']
                ];
            }
        }
        $data['approvetype_bookings'] = $approvetype_bookings;
        $data['all_limits'] = $all_limits;
        $data['isDocumentNumberSet'] = $isDocumentNumberSet ?? 0;
        $data['flagForPost'] = $flagForPost ?? 0;
        $this->newtemplate->dashboard('costaudit/index', $data);
    }

    public function searchsubmitdata($post)
    {
        $whr = [];
        if (isset($post['fromdate_search']) && $post['fromdate_search'] != "") {
            $fromdate_search = date('Y-m-d', strtotime($post['fromdate_search']));
            $whr["DATE_FORMAT(o.createdon,'%Y-%m-%d') >="] = $fromdate_search;
        }
        if (isset($post['todate_search']) && $post['todate_search'] != "") {
            $todate_search = date('Y-m-d', strtotime($post['todate_search']));
            $whr["DATE_FORMAT(o.createdon,'%Y-%m-%d') <="] = $todate_search;
        }

        if (isset($post['cid']) && $post['cid'] != "") {
            $cid = $post['cid'];
            $whr["tv.code="] = $cid;
        }

        if (isset($post['audit_status']) && $post['audit_status'] != "") {
            $audit_status = $post['audit_status'];
            $whr["ca.status="] = $audit_status;
        }
        if (isset($post['doc_number']) && $post['doc_number'] != "") {
            $whr['order_ids'] = $this->costauditmodel->getOrderIdsByDocumentNo($post['doc_number']);
        }
        return $whr;
    }

    public function getbusinesscid()
    {
        $uid = $this->session->userdata('user_id');
        $cid = isset($_REQUEST['cid']) ? $_REQUEST['cid'] : "";
        $cid = trim($cid);
        $branch_code = $this->session->userdata('branch_code');
        $company_code = $this->session->userdata('company_code');
        $get_data = $this->db->query("SELECT o.id, o.order_id,SUM(ca.amount) AS excelamont,ca.vendor_id,ca.order_id,pm.amount AS order_cost,pm.currency,ca.currency,tv.name,tv.code,pm.id AS business_partner_id,o.resolution_id FROM `tb_orders` `o`
		LEFT JOIN `tb_carrier_cost_audit` `ca` ON ca.order_id=o.id
        LEFT JOIN `tb_reveneus` `pm` ON `pm`.`order_id`=`ca`.`order_id`
        LEFT JOIN `tb_vendors` `tv` ON tv.id=ca.vendor_id
        WHERE `o`.`status` !=? AND `pm`.`TYPE` = ? AND `pm`.`recipient_role` = ?
        AND tv.code like ? AND ca.user_id=? GROUP BY ca.order_id",[0, 1, 'Carrier', '%$cid%', $uid]);
        $data = [];
        if($get_data->num_rows() > 0){
            foreach ($get_data->result() as $get_data_f) {
                $data[] = $get_data_f->code;
            }
        }
        echo json_encode($data);
    }

    public function upload()
    {
        ini_set('display_errors', 1);
        ini_set('display_startup_errors', 1);
        error_reporting(E_ALL);
        require_once APPPATH . "/third_party/PHPExcel.php";
        require_once APPPATH . "/third_party/PHPExcel/Writer/Excel2007.php";
        $data = [];
        $bookingIdArray = [];
        if (isset($_FILES['upload_file'])) {
            $ext = pathinfo($_FILES['upload_file']['name'], PATHINFO_EXTENSION);
            if ($ext == "xls" || $ext == "xlsx") {
                $path = $_FILES['upload_file']['tmp_name'];
                $objPHPExcel = PHPExcel_IOFactory::load($path);
                $cell_collection = $objPHPExcel->getActiveSheet()->getCellCollection();
                $data["arr_data"] = [];
                foreach ($cell_collection as $cell) {
                    $column = $objPHPExcel->getActiveSheet()->getCell($cell)->getColumn();
                    $row = $objPHPExcel->getActiveSheet()->getCell($cell)->getRow();
                    $data_value = $objPHPExcel->getActiveSheet()->getCell($cell)->getValue();
                    $newdtat[] = $column;
                    if ($row == 1) {
                        $data["header"][$row][$column] = $data_value;
                    } else {
                        if ($row > 1 && !empty($data_value)) {
                            $data["arr_data"][$row][$column] = $data_value;
                        }
                    }
                    if ($column == 'A' && $data_value != '' && $row > 1) {
                        $bookingIdArray[] = $data_value;
                    }
                }
                if (!empty($data['arr_data']) && sizeof($data['arr_data']) > 0) {
                    $costAuditArray = $this->getBookingsFromCostAudit($bookingIdArray);
                    $resultant = $data["arr_data"];
                    $company_code = $this->session->userdata('company_code');
                    $user_id = $this->session->userdata('user_id');
                    $cdate = date('Y-m-d H:i:s');
                    $insertArr = $updateArr = [];
                    foreach ($resultant as $each) {
                        $searchElement = $each['A'];
                        $doc_date = date('Y-m-d', PHPExcel_Shared_Date::ExcelToPHP($each['G']));
                        $insertArr[] = [
                            'booking_id' => $each['A'],
                            'trip_id' => $each['B'],
                            'amount' => $each['C'],
                            'currency' => $each['D'],
                            'doc_type' => $each['E'],
                            'doc_num' => $each['F'],
                            'doc_date' => $doc_date,
                            'company_code' => $company_code,
                            'created_on' => $cdate,
                            'created_by' => $user_id,
                        ];
                        $select = "id,trip_id,vendor_id";
                        $table = "tb_orders";
                        $where = ["order_id" => $each['A']];
                        $orders_data = $this->common->gettbldata($where, $select, $table, 0, 0);
                        $response_status = 'Fail';
                        if (count($orders_data) > 0) {
                            $response_status = 'Success';
                            $insertArrCA[] = [
                                'order_id' => $orders_data[0]['id'],
                                'vendor_id' => $orders_data[0]['vendor_id'],
                                'amount' => $each['C'],
                                'currency' => $each['D'],
                                'doc_type' => $each['E'],
                                'doc_num' => $each['F'],
                                'doc_date' => $doc_date,
                                'createdon' => $cdate,
                                'createdby' => $user_id,
                                'user_id' => $user_id,
                            ];
                        }
                        $response[] = [
                            'order_id' => $each['A'],
                            'doc_num' => $each['F'],
                            'actual_amount' => $each['C'],
                            'resp_status' => $response_status,

                        ];
                    }
                    if (count($orders_data) > 0) {
                        $this->db->insert_batch('tb_carrier_cost_audit_uploads', $insertArr);
                        $this->db->insert_batch('tb_carrier_cost_audit', $insertArrCA);
                    }
                }
            } else {
                echo json_encode(['error' => '1', 'message' => 'Unsupported File Format']);
            }
        }
        if (count($response) > 0) {
            $html = '';
            foreach ($response as $res) {
                $sclass = 'text-success';
                if ($res['resp_status'] == 'Fail') {
                    $sclass = 'text-danger';
                }
                $html .= "<tr><td>" . $res['order_id'] . "</td><td>" . $res['doc_num'] . "</td><td>" . $res['actual_amount'] . "</td><td class='" . $sclass . "'>" . $res['resp_status'] . "</td></tr>";
            }
        }
        echo json_encode(['error' => '0', 'message' => 'Data Uploaded Successfully', 'html' => $html]);
    }

    public function removeDuplicates($array)
    {
        $finalArray = [];
        if (!empty($array) && sizeof($array) > 0) {
            foreach ($array as $each) {
                $index = $each['A'];
                $finalArray[$index] = $each;
            }
        }
        return $finalArray;
    }


    public function getBookingsFromCostAudit($bookingIdArray)
    {
        $commaseparated = $bookingIds = '';
        $reqArray = [];
        if (!empty($bookingIdArray) && sizeof($bookingIdArray) > 0) {
            foreach ($bookingIdArray as $each) {
                $commaseparated = $commaseparated . "'$each'" . ',';
            }
            $bookingIds = trim($commaseparated, ',');
            $sql = "SELECT booking_id FROM tb_carrier_cost_audit_uploads where booking_id in ($bookingIds)";
            $res = $this->db->query($sql);
            if ($res->num_rows() > 0) {
                $result = $res->result_array();
                if (!empty($result) && sizeof($result) > 0) {
                    foreach ($result as $each) {
                        $reqArray[] = $each['booking_id'];
                    }
                }
            }
        }
        return $reqArray;
    }


    public function updateapprovestatus()
    {
        $post = $this->input->post(null, true);
        $costAuditRecordIds = $post ['costaudit_record_ids'];
        if (empty($costAuditRecordIds)) {
            $sts = ['status' => 'failed', 'message' => "operation failed"];
        }
        if ($post ['btn_approve'] == 1) {
            $this->db->where_in('tcca_id', $costAuditRecordIds)->update("tb_carrier_cost_audit", ['status' => 1]);
            $sts = ['status' => 'success', 'message' => "approved"];
        }
        if ($post ['btn_approve'] == 2) {
            $this->db->where_in('tcca_id', $costAuditRecordIds)->update("tb_carrier_cost_audit", ['status' => '2', 'remarks' => $post['comments']]);
            $sts = ['status' => 'success', 'message' => "rejected"];
        }

        echo json_encode($sts);
    }


    function getcostauditbyorder()
    {
        $post = $this->input->post(null, true);
        if ($post ['order_row_id'] > 0) {
            if (isset($post['order_row_id']) && $post['order_row_id'] != "") {
                $whr["o.id="] = $post['order_row_id'];
            }
            if (isset($post['vendor_id']) && $post['vendor_id'] != "") {
                $whr["ca.vendor_id="] = $post['vendor_id'];
            }
            $data = $this->costauditmodel->getcostauditbyorder($whr);
            echo json_encode($data);
        }
    }


    public function donwloadcareport()
    {
        $data[] = '';
        $whr[] = '';
        $post = $this->input->post(null, true);
        if (isset($post['order_ids'])) {
            $whr_in = json_decode($post['order_ids'], true);
            $data['list'] = $this->costauditmodel->getcostauditbyorder($whr, $whr_in);
        }
        if ($post['download_type'] == 'PDF' || $post['download_type'] == 'PRINT') {
            $mpdf = new \Mpdf\Mpdf([
                'mode' => 'utf-8',
                'tempDir' => FCPATH . 'assets/tmp',
                'format' => [100, 160],
                'margin_left' => 0,
                'margin_right' => 0,
                'margin_top' => 0,
                'margin_bottom' => 0,
                'margin_header' => 0,
                'margin_footer' => 0,
            ]);
            $output = $this->load->view('costaudit/printdata', $data, true);
            $mpdf->WriteHTML($output);

            if ($post['download_type'] == 'PDF') {
                $mpdf->Output("CostAudit_" . date('YmdHis') . ".pdf", 'D');
            } else {
                $mpdf->Output("CostAudit_" . date('YmdHis') . ".pdf", 'I');
            }
        }

        if ($_POST['download_type'] == 'EXCEL') {
            $styleArray = [
                'font' => [
                    'bold' => true,
                    'color' => ['rgb' => 'FFFFFF'],
                    'size' => 10,
                    'name' => 'Verdana'
                ]
            ];
            $objPHPExcel = new PHPExcel();
            $objPHPExcel->setActiveSheetIndex(0);
            $objPHPExcel->getActiveSheet()
                ->getStyle('A1:O1')
                ->applyFromArray(
                    [
                        'fill' => [
                            'type' => PHPExcel_Style_Fill::FILL_SOLID,
                            'color' => ['rgb' => '0c3b81']
                        ]
                    ]
                );
            $objPHPExcel->getActiveSheet()->SetCellValue('A1', 'Booking ID');
            $objPHPExcel->getActiveSheet()->getStyle('A1')->applyFromArray($styleArray);
            $objPHPExcel->getActiveSheet()->SetCellValue('B1', 'Doc #');
            $objPHPExcel->getActiveSheet()->getStyle('B1')->applyFromArray($styleArray);
            $objPHPExcel->getActiveSheet()->SetCellValue('C1', 'Doc Type');
            $objPHPExcel->getActiveSheet()->getStyle('C1')->applyFromArray($styleArray);
            $objPHPExcel->getActiveSheet()->SetCellValue('D1', 'Doc Date');
            $objPHPExcel->getActiveSheet()->getStyle('D1')->applyFromArray($styleArray);
            $objPHPExcel->getActiveSheet()->SetCellValue('E1', 'Carrier ID');
            $objPHPExcel->getActiveSheet()->getStyle('E1')->applyFromArray($styleArray);
            $objPHPExcel->getActiveSheet()->SetCellValue('F1', 'Name');
            $objPHPExcel->getActiveSheet()->getStyle('F1')->applyFromArray($styleArray);
            $objPHPExcel->getActiveSheet()->SetCellValue('G1', 'Actual Amount');
            $objPHPExcel->getActiveSheet()->getStyle('G1')->applyFromArray($styleArray);
            $objPHPExcel->getActiveSheet()->SetCellValue('H1', 'Currency');
            $objPHPExcel->getActiveSheet()->getStyle('H1')->applyFromArray($styleArray);
            $objPHPExcel->getActiveSheet()->SetCellValue('I1', 'Accrual Amount');
            $objPHPExcel->getActiveSheet()->getStyle('I1')->applyFromArray($styleArray);
            $objPHPExcel->getActiveSheet()->SetCellValue('J1', 'Currency');
            $objPHPExcel->getActiveSheet()->getStyle('J1')->applyFromArray($styleArray);
            $objPHPExcel->getActiveSheet()->SetCellValue('K1', 'Dispute');
            $objPHPExcel->getActiveSheet()->getStyle('K1')->applyFromArray($styleArray);
            $objPHPExcel->getActiveSheet()->SetCellValue('L1', 'Currency');
            $objPHPExcel->getActiveSheet()->getStyle('L1')->applyFromArray($styleArray);
            $objPHPExcel->getActiveSheet()->SetCellValue('M1', 'status');
            $objPHPExcel->getActiveSheet()->getStyle('M1')->applyFromArray($styleArray);
            $objPHPExcel->getActiveSheet()->SetCellValue('N1', 'remarks');
            $objPHPExcel->getActiveSheet()->getStyle('N1')->applyFromArray($styleArray);

            $rowCount = 2;
            if (!empty($data['list'])) {
                foreach ($data['list'] as $result) {
                    $objPHPExcel->getActiveSheet()->SetCellValue('A' . $rowCount, $result['order_id']);
                    $objPHPExcel->getActiveSheet()->SetCellValue('B' . $rowCount, $result['doc_num']);
                    $objPHPExcel->getActiveSheet()->SetCellValue('C' . $rowCount, $result['doc_type']);
                    $objPHPExcel->getActiveSheet()->SetCellValue('D' . $rowCount, $result['doc_date']);
                    $objPHPExcel->getActiveSheet()->SetCellValue('E' . $rowCount, $result['code']);
                    $objPHPExcel->getActiveSheet()->SetCellValue('F' . $rowCount, $result['vendor_name']);
                    $objPHPExcel->getActiveSheet()->SetCellValue('G' . $rowCount, $result['amount']);
                    $objPHPExcel->getActiveSheet()->SetCellValue('H' . $rowCount, $result['currency']);
                    $objPHPExcel->getActiveSheet()->SetCellValue('I' . $rowCount, $result['order_cost']);
                    $objPHPExcel->getActiveSheet()->SetCellValue('J' . $rowCount, $result['ecurrency']);
                    $dispute = '-';
                    $dispute_cur = '-';
                    if ($result['doc_type'] == 'KR') {
                        $dispute = $result['order_cost'] - $result['amount'];
                        $dispute_cur = $result['ecurrency'];
                    }
                    $objPHPExcel->getActiveSheet()->SetCellValue('K' . $rowCount, $dispute);
                    $objPHPExcel->getActiveSheet()->SetCellValue('L' . $rowCount, $dispute_cur);
                    $status = 'Pending';
                    if ($result['status'] == 1) {
                        $status = 'Approved';
                    } elseif ($result['status'] == 2) {
                        $status = 'Rejected';
                    }
                    $objPHPExcel->getActiveSheet()->SetCellValue('M' . $rowCount, $result['currency']);
                    $objPHPExcel->getActiveSheet()->SetCellValue('N' . $rowCount, $result['remarks']);
                    $rowCount++;
                }
            }
            $fileName = 'CostAudit' . "_" . date("Ymdhis") . '.xlsx';
            @ob_end_clean();
            header('Content-Type: application/vnd.ms-excel');
            header('Content-Disposition: attachment;filename="' . $fileName . '"');
            header('Cache-Control: max-age=0');
            $objWriter = new PHPExcel_Writer_Excel2007($objPHPExcel);
            $objWriter->save('php://output');
        }
    }

    public function approveStatuses(): void
    {
        $post = $this->input->post(null, true);
        $status = ['status' => 'failed', 'message' => "rejected"];
        if (empty($post['selected_records'])) {
            echo json_encode($status);
            return;
        }
        foreach ($post['selected_records'] as $eachRecord) {
            $eachData = explode("?????", $eachRecord);
            if ($eachData[4] == 0) {
                $this->common->updatetbledata("tb_carrier_cost_audit", ['status' => 1], ['order_id' => $eachData[0], 'vendor_id' => $eachData[3]]);
                $status = ['status' => 'success', 'message' => "approved"];
            }
        }
        echo json_encode($status);
    }

    public function postStatuses(): void
    {
        $post = $this->input->post(null, true);
        $date = date('Y-m-d');
        $status = ['status' => 'failed', 'message' => "post failed"];
        if (empty($post['selected_records'])) {
            echo json_encode($status);
            return;
        }
        $companyCode = $this->session->userdata('company_code');
        $branchCode = $this->session->userdata('branch_code');
        $costAuditDisputeAllowances = $this->common->gettbldata(['branch_code' => $branchCode, 'company_code' => $companyCode, 'status' => 1], "allowance_amount,customer_id,vendor_id", "cost_audit_dispute_allowance", 0, 0);
        if (empty($costAuditDisputeAllowances)) {
            echo json_encode($status);
            return;
        }
        $orderIds = $vendorIds = $revenueIds = $orderIdAndRevenueId = [];
        foreach ($post['selected_records'] as $eachRecord) {
            $eachData = explode("?????", $eachRecord);
            if (isset($eachData[4]) && ($eachData[4] == 1)) {
                $orderId = $eachData[0];
                $revenueId = $eachData[1];
                $vendorId = $eachData[3];
                $eligibleAmount = $this->costauditmodel->getApprovedAmountSum($orderId, $vendorId);
                $revenueAmount = $eachData[5];
                $customerId = $eachData[6];
                $costAuditAllowance = $this->getAllowanceAmount($costAuditDisputeAllowances, $customerId, $vendorId);
                $differenceAmount = round(($revenueAmount - $eligibleAmount), 2);
                if ($differenceAmount > 0) {
                    if ($differenceAmount > $costAuditAllowance) {
                        $costRevenueRecordsForUpdate[] = ['id' => $revenueId, 'amount' => $revenueAmount, 'accrual_amount' => $differenceAmount, 'actual_amount' => $eligibleAmount];
                    } elseif ($differenceAmount < $costAuditAllowance) {
                        $costRevenueRecordsForUpdate[] = ['id' => $revenueId, 'amount' => $revenueAmount, 'accrual_amount' => 0, 'actual_amount' => $eligibleAmount];
                    }
                } else {
                    $costRevenueRecordsForUpdate[] = ['id' => $revenueId, 'amount' => $revenueAmount, 'accrual_amount' => $differenceAmount, 'actual_amount' => $eligibleAmount];
                }
                $orderIds[] = $orderId;
                $vendorIds[] = $vendorId;
                $revenueIds[] = $revenueId;
                $orderIdAndRevenueId[] = ['order_id' => $orderId, 'revenue_id' => $revenueId];
                $this->common->updatetbledata("tb_carrier_cost_audit", ['status' => 3, 'posted_on' => $date], ['order_id' => $orderId, 'vendor_id' => $vendorId, 'status' => 1]);
            }
        }
        if (!empty($costRevenueRecordsForUpdate ?? [])) {
            $this->costauditmodel->batchUpdate('tb_reveneus', $costRevenueRecordsForUpdate, 'id');
            $this->saveDocumentNumbers([
                'orderIds' => $orderIds,
                'vendorIds' => $vendorIds,
                'revenueIds' => $revenueIds,
                'orderIdAndRevenueId' => $orderIdAndRevenueId
            ]);
            $status = ['status' => 'success', 'message' => "posted"];
        }
        echo json_encode($status);
    }

    private function getAllowanceAmount($costAuditDisputeAllowances, $customerId, $vendorId): float
    {
        $allowanceAmount = $allowanceAmountByCustomerVendor = $allowanceAmountByCustomer = 0;
        if (empty($costAuditDisputeAllowances)) {
            return $allowanceAmount;
        }
        foreach ($costAuditDisputeAllowances as $eachAllowance) {
            if ($eachAllowance['customer_id'] == $customerId && $eachAllowance['vendor_id'] == $vendorId) {
                $allowanceAmountByCustomerVendor = $eachAllowance['allowance_amount'];
            }
            if ($eachAllowance['customer_id'] == $customerId) {
                $allowanceAmountByCustomer = $eachAllowance['allowance_amount'];
            }
            $allowanceAmount = $eachAllowance['allowance_amount'];
        }
        if ($allowanceAmountByCustomerVendor > 0) {
            return $allowanceAmountByCustomerVendor;
        } elseif ($allowanceAmountByCustomer > 0) {
            return $allowanceAmountByCustomer;
        }
        return $allowanceAmount;
    }

    private function saveDocumentNumbers(array $data): void
    {
        $documentNosWithOrderIds = $this->costauditmodel->getDocumentNosWithOrderIds($data['orderIds'], $data['vendorIds']);
        $revenueDataForUpdate = [];
        if (!empty($documentNosWithOrderIds)) {
            foreach ($data['orderIdAndRevenueId'] as $eachOrderIdAndRevenueId) {
                if (isset($documentNosWithOrderIds[$eachOrderIdAndRevenueId['order_id']])) {
                    $eachRevenueData = $documentNosWithOrderIds[$eachOrderIdAndRevenueId['order_id']];
                    $revenueDataForUpdate[] = [
                        'id' => $eachOrderIdAndRevenueId['revenue_id'],
                        'invoice_number' => $eachRevenueData['invoice_number'] ?? '',
                        'credit_note_number' => $eachRevenueData['credit_note_number'] ?? '',
                        'invoice_date' => implode(",", array_filter([($eachRevenueData['invoice_date'] ?? ''), ($eachRevenueData['credit_date'] ?? '')]))
                    ];
                }
            }
        }
        if (!empty($revenueDataForUpdate)) {
            $this->costauditmodel->batchUpdate('tb_reveneus', $revenueDataForUpdate, 'id');
        }
    }

}
