<?php
if (!defined('BASEPATH')) {
    exit('No direct script access allowed');
}

class CostauditReports extends CI_Controller
{
    public function __construct()
    {
        parent::__construct();
        if ($this->session->userdata('user_id') == '') {
            redirect('login');
        }
        $this->userRoleId = $this->session->userdata('user_role_id');
        if ($this->session->userdata('company_code') != "NZPG" && !in_array($this->userRoleId,[1,2])) {
            redirect("Forbiddenaccess");
        }
        $this->load->model('CostauditReportsmodel');
    }

    public function weeklyUploadFile()
    {
        $data['page_title'] = 'Weekly Upload File' ;
        $data['sub_title'] = $this->lang->line('general_search');
        $userId = $this->session->userdata("user_id");
        $countryUserIds = is_array($this->session->userdata( "country_user_ids" )) ? $this->session->userdata( "country_user_ids" ) : [];
        $data['current_currency'] = $this->session->userdata['usr_tzone']['currency'];
        $post = [];
        $checkPost = $this->input->post(null, true);
        if (isset($checkPost['searchsubmit']) && $checkPost['searchsubmit'] == "Search") {
            $post = $checkPost;
        }
        if (!empty($post)) {
            $where = $this->getSearchCondition($post);
            $where['o.user_id'] = $userId;
            $where['o.status !='] = 0;
            $where['ca.vendor_id !='] = '';
            $where['r.reference_id'] = 'DQ';
            $where['r.status'] = '1';
            $getPostedOrders = $this->CostauditReportsmodel->getPostedOrders($where, $countryUserIds);
            foreach ($getPostedOrders as $eachOrder) {
                $postedBookings[] = [
                    'posting_date' => '',
                    'doc_date' => $eachOrder['doc_date'] != '' ? date("d-m-Y", strtotime($eachOrder['doc_date'])) : '',
                    'currency' => $eachOrder['currency'],
                    'document_no' => $eachOrder['document_no'],
                    'vendor_name' => $eachOrder['vendor_name'],
                    'order_id' => $eachOrder['order_id'],
                    'doc_type' => $eachOrder['doc_type'],
                    'order_type' => $eachOrder['order_type'],
                    'actual_amount' => $eachOrder['actual_amount'],
                    'customer_code' => $eachOrder['customer_code'],
                    'cost_center' => $eachOrder['cost_center'],
                    'delivery_note' => $eachOrder['delivery_note']
                ];
            }
        }
        $data['posted_bookings'] = $postedBookings ?? [];
        $this->newtemplate->dashboard('costauditreports/weeklyuploadfile', $data);
    }

    private function getSearchCondition(array $post): array
    {
        if (isset($post['fromdate_search']) && $post['fromdate_search'] != "") {
            $fromDateSearch = date('Y-m-d', strtotime($post['fromdate_search']));
            $where["DATE_FORMAT(o.createdon,'%Y-%m-%d') >="] = $fromDateSearch;
        }
        if (isset($post['todate_search']) && $post['todate_search'] != "") {
            $toDateSearch = date('Y-m-d', strtotime($post['todate_search']));
            $where["DATE_FORMAT(o.createdon,'%Y-%m-%d') <="] = $toDateSearch;
        }
        return $where ?? [];
    }
}
