<?php

defined('BASEPATH') or exit('No direct script access allowed');

class Costcenter extends CI_Controller {

    public function __construct() {
        parent::__construct();
        $app_admin_id = "30";
        if ($this->session->userdata('user_id') == "") {
            redirect("login");
        } else if ($this->session->userdata('user_id') == $app_admin_id) {
            echo "<script type='text/javascript'>alert('Managed at the admin level by KN Operator');window.location.href='login';</script>";
        }
        $this->load->library('form_validation');
        $this->load->model("common");
        $this->load->model("costcentermodel");
        if (!checkUrlAccessForUser('COSTCENTER')) {
            redirect("Forbiddenaccess");
        }
    }

    public function index() {
        $data["page_title"] = $this->lang->line('bpartner_costcenter');
        $data["sub_title"] = $this->lang->line('general_search');
        $where = [];
        $whr = [];
        $company_code = $this->session->userdata('company_code');
        $whr['tt.status'] = 1;

        $whr['tt.company_code'] = $company_code;
        $whr['tt.branch_code'] = $this->session->userdata('branch_code');

        if (isset($_POST['searchsubmit']) && $_POST['searchsubmit'] == "Search") {
            $name = $this->input->post('name1',TRUE);

            if (isset($name) && $name != "") {
                $where['tt.type_name'] = $name;
            }
        } elseif (isset($_POST['searchsubmita']) && $_POST['searchsubmita'] == "Search") {
            $department_code = $this->input->post('department_code',TRUE);
            $customer_name = $this->input->post('customer_name',TRUE);
            $status = $this->input->post('status',TRUE);
            if (isset($department_code) && $department_code != "") {
                $where['tt.department_code'] = $department_code;
            }
            if (isset($customer_name) && $customer_name != "") {
                $where['c.name'] = $customer_name;
            }
            if (isset($status) && $status != "") {
                $where['tt.status'] = $status;
                unset($whr['tt.status']);
            }
        }
        $data['order_list'] = $this->costcentermodel->getsearchdata($whr, $where);
        /* log_message('error',$this->db->last_query()); */
        $this->newtemplate->dashboard("costcenter/index", $data);
    }

    public function add() {
        if ($this->session->userdata('business_type') == "Carrier") {
            redirect('welcome/logout');
        }

        $company_code = $this->session->userdata('company_code');
        $branch_code = $this->session->userdata('branch_code');
        $user_id = $this->session->userdata('user_id');
        $data['company_code'] = $company_code;
        $data['branch_code'] = $branch_code;
        $data['user_id'] = $user_id;
        $table = 'tb_customers';
        $whr = [];
            $whr = array(
                "user_id" => $user_id,
                "status" => 1
            );
        $cusname = $this->costcentermodel->selectlist('id,name', $table, $whr, 'name');
        $data['cusname'] = $cusname;
        $table1 = 'tb_department_master';
        $whr1 = array(
            "company_code" => $company_code,
            "branch_code" => $branch_code
        );
        $deprt = $this->costcentermodel->selectlist('id,department_name', $table1, $whr1, 'department_name');
        $data['depat'] = $deprt;

        $data["page_title"] = $this->lang->line('bpartner_costcenter');
        $data["sub_title"] = $this->lang->line('general_add');

        //$this->newtemplate->dashboard("costcenter/add", $data);
        $this->load->view("costcenter/add", $data);
    }

    public function update() {
        $id = $this->input->post('id',TRUE);
        if (isset($id)) {
            $post = $this->input->post(NULL,TRUE);
            extract($post);
            $name = isset($name) ? $name : "";
            $description = isset($desc) ? $desc : "";
            $company_code = isset($company_code) ? $company_code : "";
            $branch_code = isset($branch_code) ? $branch_code : "";
            $department_code = isset($department_code) ? $department_code : "";
            $customer_id = isset($customer_id) ? $customer_id : 0;
            $status = isset($status) ? $status : 0;
            $ordtype_code = isset($name) ? $name[0] : "";
            $data = [
                'type_name' => $name,
                'description' => $description,
                'company_code' => $company_code,
                'branch_code' => $branch_code,
                'department_code' => $department_code,
                'customer_id' => $customer_id,
                'ordtype_code' => $ordtype_code,
                'status' => $status
            ];
            $data['updatedon'] = date('Y-m-d H:i:s');
            $table = 'tb_cost_center';
            $whr = array(
                'id' => $id
            );

            $result = $this->common->updatetbledata($table, $data, $whr);
            echo json_encode($result);
            /*
             * if ($result) {
             * $this->session->set_flashdata('success_msg', 'Succefully Updated Order Types Info');
             * } else {
             * $this->session->set_flashdata('error_msg', 'An error occurred while Updated data');
             * }
             * redirect('ordertype');
             */
        }
    }

    public function edit($id) {
        $data["page_title"] = $this->lang->line('bpartner_costcenter');
        $data["sub_title"] = $this->lang->line('general_edit');
        $company_code = $this->session->userdata('company_code');
        $branch_code = $this->session->userdata('branch_code');
        $user_id = $this->session->userdata('user_id');
        $data['company_code'] = $company_code;
        $data['branch_code'] = $branch_code;
        $data['user_id'] = $user_id;
        $table = 'tb_customers';
        $whr = [];
        if ($company_code == 'RUKN') {
            $whr = [
                "company_code" => $company_code,
                "status" => 1
            ];
        } else {
            $whr = [
                "user_id" => $user_id,
                "status" => 1
            ];
        }
        $cusname = $this->costcentermodel->selectlist('id,name', $table, $whr, 'name');
        $data['cusname'] = $cusname;
        $table1 = 'tb_department_master';
        $whr1 = [
            'company_code' => $company_code,
            'branch_code' => $branch_code
        ];
        $deprt = $this->costcentermodel->selectlist('id,department_name', $table1, $whr1, 'department_name');
        $data['depat'] = $deprt;
        $data['or_type'] = $this->costcentermodel->editdata($id);
        //$this->newtemplate->dashboard('costcenter/edit', $data);
        $this->load->view("costcenter/edit", $data);
    }

    public function view($id) {
        $data["page_title"] = $this->lang->line('bpartner_costcenter');
        $data["sub_title"] = $this->lang->line('general_view');
        $data['or_type'] = $this->costcentermodel->viewdata($id);
        //$this->newtemplate->dashboard('costcenter/view', $data);
        $this->load->view("costcenter/view", $data);
    }

    public function delete($id) {
        if ($id != '') {
            $this->db->where('id', $id);
            $this->db->set('status', 0);
            $result = $this->db->update('tb_cost_center');
            if ($result) {
                echo "1";
            } else {
                echo "0";
            }
        }
    }

    public function checkordername() {
        $post = $this->input->post(NULL,TRUE);
        $name = isset($post['name']) ? $post['name'] : "";
        $id = isset($post['id']) ? $post['id'] : "";
        $where = [];
        $company_code = isset($post['company_code']) ? $post['company_code'] : "";
        $branch_code = isset($post['branch_code']) ? $post['branch_code'] : "";
        if ($company_code == 'RUKN') {
            $where = array(
                'type_name' => $name,
                'company_code' => $company_code,
                'status' => 1
                    ,);
        } else {
            $where = array(
                'type_name' => $name,
                'company_code' => $company_code,
                'branch_code' => $branch_code,
                'status' => 1
            );
        }

        if ($id) {
            $where['id !='] = $id;
        }
        $company = $this->common->gettblrowdata($where, 'type_name', 'tb_cost_center', 0, 0);
        if (empty($company)) {
            echo "2";
        } else {

            echo "1";
        }
    }

    public function save() {
        $result = [];

        $post = $this->input->post(NULL,TRUE);
        extract($post);
        $name = isset($name) ? $name : "";
        $description = isset($desc) ? $desc : "";
        $company_code = isset($company_code) ? $company_code : "";
        $branch_code = isset($branch_code) ? $branch_code : "";
        $department_code = isset($department_code) ? $department_code : "";
        $customer_id = isset($customer_id) ? $customer_id : 0;
        // $status = isset($status) ? $status : 0;
        $ordtype_code = isset($name) ? $name[0] : "";
        $data = [
            'type_name' => $name,
            'description' => $description,
            'company_code' => $company_code,
            'branch_code' => $branch_code,
            'department_code' => $department_code,
            'customer_id' => $customer_id,
            'ordtype_code' => $ordtype_code,
            'status' => 1
        ];
        $data['createdon'] = date('Y-m-d H:i:s');
        $table = 'tb_cost_center';
        $whr = [];
        $result = $this->common->insertTableData($table, $data);

        echo json_encode($result);
    }

}
