<?php defined('BASEPATH') OR exit('No direct script access allowed');
class Custdashboard extends CI_Controller {

	public function __construct()
	{
		parent::__construct();
		if ($this->session->userdata('user_id') == '') {
			redirect('login');
		}
		$this->load->model('cabmodel');
	}
	
	public function index()
	{
		$data["page_title"]="Home";
		$uid = $this->session->userdata('user_id');
		$data["sub_title"]="Dashboard";
		$imei=$this->input->get_post('imei');
		$groupid=$this->input->get_post('groupid');
		$data['imei']=$imei;
		$data['groupid']=$groupid;
		$enddt = date('Y-m-d');
       	$startdt = date('Y-m-d', strtotime('-7 days'));
		$post = array('fromdate_search'=>$startdt,'todate_search'=>$enddt,'dbsearchvehicle'=>'','durationwise'=>1);
		if(isset($_POST['durationwise'])){
			$post = $_POST;
		}
		$data['post'] = $post; 
		// need to put it in model after complete it
		$rdata = $this->cabmodel->custdashbsearch($post,$uid);
		$data['totalshipments'] = $rdata['totalshipments'];
		$data['liveshipscount'] = $rdata['liveshipscount'];
		$data['openshipscount'] = $rdata['openshipscount'];
		$data['closeshipscount'] = $rdata['closeshipscount'];
		$data['totaltrips'] = $rdata['totaltrips'];
		$data['ontimetrips'] = $rdata['ontimetrips'];
		$data['delaytrips'] = $rdata['delaytrips'];
		$chartdata[0] = $this->db->query("select count(id) as cabcnt from tb_shifts WHERE customer_id=1")->row_array();
		$chartdata[1] = $this->db->query("select count(id) as cabcnt from tb_employee WHERE status=1 AND customer_id=1")->row_array();
		$chartdata[2] = $this->db->query("select SUM(shipment_weight)/2000 as cabcnt from tb_employee WHERE status=1 AND customer_id=1")->row_array();
		$arr = array();
		$colorarr[0] = "#f56954";
		$colorarr[1] = "#00a65a";
		$colorarr[2] = "#f39c12";
		$arr1[0] = "Shipments";
		$arr1[1] = "Stops";
		$arr1[2] = "Capacity";
		$i = 0; 
		for($i = 0;$i< 3 ; $i++){
			$arr[] = array('value'=> $chartdata[$i]['cabcnt'],
		      'color'=> $colorarr[$i],
		      'highlight'=> $colorarr[$i],
		      'label'=> $arr1[$i]);
		}
		$data['chartdata'] = $arr;
		$this->settemplate->dashboard("customers/dashboard", $data);
	}

	function loadvehicleinfo(){
		$uid=$this->session->userdata("user_id");
		$data=array();
		$start=$_GET["start"];
		$length=$_GET["length"];
		$search=$_GET["search"];
		$order=$_GET["order"];
		$sql="select e.id,e.name,e.shipment_weight,e.shipment_volume,e.ship_type,t.driver_id from tb_employee e,tb_trips t,tb_shft_veh sv,tb_shft_veh_emp sve where t.shift_id=sv.shft_id and t.vehicle_id=sv.vehicle_id and sve.shft_veh_id=sv.id and sve.emp_id=e.id and sv.status=1 and sve.status=1 AND t.status=1 AND e.customer_id=1"; 
		$qr=$this->db->query($sql);
		$tot=$qr->num_rows();
		if($_GET){
			$s=isset($search["value"])?$search["value"]:"";
			if($s!=""){
				$sql.=" and (e.name like '%".$s."%' or e.ship_type like '%".$s."%')";
			}
			$o=isset($order["0"]["column"])?$order["0"]["column"]:"";
			$so=isset($order["0"]["dir"])?$order["0"]["dir"]:"";
			if($o!=""){
				if($o=="0"){
					$sql.=" order by e.name $so";
				}else if($o=="1"){
					$sql.=" order by e.id $so";
				}
			}

		}
		$sql.=" limit $start,$length";
		$qr=$this->db->query($sql);
		if($qr->num_rows()>0){
			$data["recordsTotal"]=$tot;
			$data["recordsFiltered"]=$qr->num_rows();
			$data["columns"]["2"]["searchable"]="false";
			$data["columns"]["3"]["searchable"]="false";
			$data["columns"]["4"]["searchable"]="false";
			$data["columns"]["2"]["orderable"]="false";
			$data["columns"]["3"]["orderable"]="false";
			$data["columns"]["4"]["orderable"]="false";
			foreach($qr->result() as $row){
				$d=array();
				$ships = $row->id.')'.$row->name.' (weight: '.$row->shipment_weight.',volume'.$row->shipment_volume.') ('.$row->ship_type.')';
				$d[] = $ships;
				$driv = $this->getdriverbyshipment($row->driver_id);
				$d[] = $driv['name'];
				$d[] = $driv['vehicle_number'];
				$d[] = $driv['location'];
				$d[] = $driv['date'];
				$data["data"][]=$d;
			}
		}
		echo json_encode($data);
	}

	function getdriverbyshipment($driver_id){
		$res['name'] = "";
		$res['vehicle_number'] = "";
		$res['location'] = "";
		$res['date'] = "";
		$sql="select d.id,d.name,t.register_number,IFNULL(CONCAT(t.latitude,'@',t.longitude,'@',t.speed,'@',t.receivedon),'') as dtt from tbl_assigned_drivers a,tb_truck_drivers d,tb_trucks_data t where a.driver_id=$driver_id and a.status=1 and a.driver_id=d.id and a.vehicle_id=t.id LIMIT 1";
		$qr=$this->db->query($sql);
		if($qr->num_rows()>0){
			$row = $qr->row();
			$res['name'] = $row->name;
			$res['vehicle_number'] = $row->register_number;
			$dt=explode("@", $row->dtt);
				if(count($dt)!= 4){
					$dt = array("","","","");
				}
			$res['location'] = getLocationName($dt[0],$dt[1]);
			$res['date'] = date('d M,Y H:i a',strtotime($dt[3]));
		}
		return $res;
	} 

	public function livecabdetails()
	{
		$data['page_title'] = "Dashboard";
		$data['sub_title'] = "Shipments Live Track Details";
		$this->settemplate->dashboard("customers/livecabdetails",$data);
	}
	function ajaxdashboard(){
		$userid = $this->session->userdata('user_id');
		$data["vehicles"] = $data['vshiftsdata'] = array();
		$qry = "SELECT t.vehicle_id FROM tb_trips t,tb_shifts s WHERE t.shift_id=s.id AND t.status=1 AND s.customer_id=2 GROUP BY t.vehicle_id";
		$res = $this->db->query($qry);
		$vehs = array();
		if($res->num_rows() > 0){
			foreach ($res->result() as $k) {
				$vehs[] = $k->vehicle_id;
			}
			$data["vehicles"]=$this->db->query("SELECT v.route_id,v.vehicle_id,v.register_number,ifnull(t.status,0) as status,ifnull(t.id,0) as tripid FROM tb_shifts s,tb_shft_veh v left outer join tb_trips t on t.vehicle_id=v.vehicle_id and t.status=1 WHERE s.customer_id=2 and v.user_id=s.user_id and s.status=1 and v.status=s.status and v.shft_id=s.id AND t.vehicle_id IN(".implode(',', $vehs).") GROUP BY vehicle_id order by tripid desc,register_number desc");
			$data['vshiftsdata'] = $this->db->query("SELECT s.id,s.stime,s.etime,s.empshift_start,s.startdate,s.trip_type,s.splace,s.eplace,v.id as shft_veh_id,v.route_id,v.vehicle_id,v.register_number,ifnull(t.status,0) as status,ifnull(t.id,0) as tripid,ifnull(t.driver_id,0) as driver_id FROM tb_shifts s,tb_shft_veh v left outer join tb_trips t on t.shift_id=v.shft_id and t.vehicle_id=v.vehicle_id and t.status=1 WHERE s.customer_id=2 and v.user_id=s.user_id and s.status=1 and v.status=s.status and v.shft_id=s.id GROUP BY shft_veh_id order by tripid desc");
		}
		echo $this->load->view("customers/livecabdetailsajax",$data,TRUE);
	}

	public function shipmentreports()
	{
		$data["table_search"] = $whr = "";
		$userid = $this->session->userdata('user_id');
		$enddt = date('Y-m-d');
        $startdt = date('Y-m-d', strtotime('-7 days'));
		$post = array('fromdate_search'=>$startdt,'todate_search'=>$enddt,'vehicle_search'=>'','shift_search'=>array(),'emp_search'=>'','user_id'=>$userid,'zone_search'=>'','type_search'=>'');
		if ($_POST) {
			if(isset($_POST['searchsubmit'])){
				$post = $_POST;
			}else if(isset($_POST['searchexportsubmit'])){
				$post = $_POST;
				$this->dwnshipreport($post);
			}
		}
		$post['user_id']=$userid;
		$data['page_title'] = "Reports";
		$data['sub_title'] = "Shipment Level Reports";
		$tripscount = $this->cabmodel->getshipreports($post,0,0)->num_rows();
		$data['tripscount']=$tripscount;
		$config = array();
        $config["base_url"] = base_url() . "custdashboard/shipmentreports";
        $config["total_rows"] = $tripscount;
        $config["per_page"] = 10;
        $config["uri_segment"] = 3;
		$config['display_pages'] = TRUE;
        $this->pagination->initialize($config);
        $page = ($this->uri->segment(3)) ? $this->uri->segment(3) : 0;
		$data['tripsdata'] = $this->cabmodel->getshipreports($post,$config["per_page"],$page);
		$data['post'] = $post;
		$data['empdelaysummarydata'] = $this->cabmodel->getempsummary($post);
		$whr = array("id >"=>0);
		$select = "id,stime,etime,splace,eplace,created_on";
		$data['shifts'] = $this->db->query("select id,empshift_start as stime,empshift_end as etime,trip_type,startdate,enddate from tb_shifts where customer_id=1 and status=1")->result_array();
		$zwhr = array("id >"=>0,"status"=>'Active',"user_id"=>$userid);
		$zselect = "id,zone_name,splace,eplace";
		$data['zones'] = $this->cabmodel->getTableData('tb_shift_zones',$zwhr,$zselect);
		$this->settemplate->dashboard("customers/shipmentreports", $data);
	}

	public function dwnshipreport($search = null) {
		$post = $_POST;
		$data["table_search"] = $whr = "";
		$userid = $this->session->userdata('user_id');
		$post['user_id']=$userid;
		$data['page_title'] = "Reports";
		$data['post'] = $post;
		$data['sub_title'] = "Shipment Level Reports";
		$data['searchtype'] = $search;
		if($search == "" || $search == 1){
			$data['empdelaysummarydata'] = $this->cabmodel->getshipsummary($post);
		}else{
			$data['tripsdata'] = $this->cabmodel->getshipreports($post,0,0);
		}
		$file = 'Shipment_Report' . date("Ymdhis") . '.xls';
		header ("Cache-Control: no-cache, must-revalidate");    
		header ("Pragma: no-cache");    
		header ('Content-type: application/x-msexcel');
		header ("Content-Disposition: attachment; filename=$file" );  
		$this->load->view('excelexport/empreport',$data);
	}
}