<?php

if (!defined('BASEPATH')) {
    exit('No direct script access allowed');
}

class CustomReport extends CI_Controller
{

    public function __construct()
    {
        parent::__construct();
        if ($this->session->userdata('user_id') == '') {
            redirect('login');
        }

        $this->load->library('CustomReportService');
        $modals = [
            'common' => 'common',
            'CustomReportModel' => 'CustomReportModel',
            'DataArrayFormatter_model' => 'DataArrayFormatter_model',
            'DataQueryFormatter_model' => 'DataQueryFormatter_model',
            'Datatables_model' => 'Datatables_model'
        ];
        $this->load->model($modals);
        if (!checkUrlAccessForUser('CUSTOMREPORT')) {
            redirect("Forbiddenaccess");
        }
    }

    public function index(): void
    {
        $data = [
            'final_array' => 'beforeSearch',
            'page_title' => $this->lang->line('menu_customreport'),
            'sub_title' => $this->lang->line('general_search'),
            'reporter_data' => $this->CustomReportModel->getCustomReportDataByCompanycode($this->session->userdata('company_code'), $this->session->userdata('branch_code'))
        ];

        $this->newtemplate->dashboard("customreportpage/customReport", $data);
    }

    public function searchSubmitData(array $post): array
    {
        $whr = $this->customreportservice->getCustomReportfilterWhereConditionData($post);
        return $whr;
    }

    public function customReportGeneration(): void
    {
        $data = ['page_title' => $this->lang->line('menu_customreport'), 'sub_title' => $this->lang->line('general_search')];
        $whr = $post = $dataTableSortOrdering = [];
        $status_search = $wherecondition = "";

        $indexColumn = 'o.id';
        $post1 = $this->input->post(null, true);

        $data['reporter_data'] = $this->CustomReportModel->getCustomReportDataByCompanycode($this->session->userdata('company_code'), $this->session->userdata('branch_code'));

        if (isset($post1['reporter_id'])) {
            $reporter_id = $post1['reporter_id'];
        } else {
            $reporter_id = $post1['adv_reporter_id'];
        }

        $order = $country_userids = [];
        $userid = $this->session->userdata("user_id");
        $custid = $this->session->userdata("cust_id");
        $country_userids = $this->session->userdata("country_user_ids");
        $orderByCondition = '';
        if (isset($orderBy[0])) {
            if ($orderBy[0] != '') {
                $ordColIndex = $orderBy[0]['column'];
                $ordColDir = $orderBy[0]['dir'];
                if ($ordColDir == '') {
                    $ordColDir = 'asc';
                }
                if (isset($dataTableSortOrdering[$ordColIndex]) && $dataTableSortOrdering[$ordColIndex] != '') {
                    $orderByCondition = '  ' . $dataTableSortOrdering[$ordColIndex] . ' ' . $ordColDir . ' ';
                }
            }
        }
        if (isset($post1['searchsubmit']) && $post1['searchsubmit'] == "Search") {
            $post = $post1;
        }

        if (!empty($post)) {
            $whr = $this->searchSubmitData($post);
            $order_status = isset($post['status']) ? $post['status'] : "";
            $ad_orderstatus = isset($post['order_status']) ? $post['order_status'] : "";
            $status_search = $order_status;
            if ($status_search == "") {
                $status_search = $ad_orderstatus;
            }
            $company_code = $sessionCompanyCode = $this->session->userdata('company_code');
            $branch_code = $this->session->userdata('branch_code');
            $subcusts = [];
            $role_id = $this->session->userdata('user_role_id');
            if ($role_id == "4") {
                if ($this->session->userdata('sub_cust')) {
                    $subcusts = $this->session->userdata('sub_cust');
                    if (!empty($subcusts)) {
                        array_push($subcusts, $custid);
                    }
                }
            }
            $searchids = [];
            if (isset($post['bookingid']) && $post['bookingid'] != "") {
                $searchids = isset($post['bookingid']) ? $post['bookingid'] : [];
            }

            $whereArray = $ordids = [];
            if (isset($whr['ordids'])) {
                if (!empty($whr['ordids'])) {
                    $ordids = $whr['ordids'];
                }
            }
            unset($whr['ordids']);
            if (!empty($whr) && sizeof($whr) > 0) {
                foreach ($whr as $key => $value) {
                    $value = "'$value'";
                    if ($key == "DATE_FORMAT(o.createdon,'%Y-%m-%d') >=" || $key == "DATE_FORMAT(o.createdon,'%Y-%m-%d') <=" || $key == "DATE_FORMAT(o.pickup_datetime,'%Y-%m-%d') >=" || $key == "DATE_FORMAT(o.pickup_datetime,'%Y-%m-%d') <=") {
                        $whereArray[] = $key . $value;
                    } else {
                        $whereArray[] = $key . ' = ' . $value;
                    }
                }
            }

            if (!empty($whereArray)) {
                $wherecondition .= 'AND ' . implode(' AND ', $whereArray);
            }

            if (!empty($searchids)) {
                $tempSearchId = '';
                if (!empty($searchids) && sizeof($searchids) > 0) {
                    foreach ($searchids as $eachSearchKey) {
                        $tempSearchId .= "'$eachSearchKey',";
                    }
                }
                $tempSearchId = trim($tempSearchId, ',');

                if ($tempSearchId != '') {
                    $wherecondition .= " and o.order_id in ($tempSearchId) ";
                }
            }
            if (!empty($ordids)) {
                if (!empty($ordids) && sizeof($ordids) > 0) {
                    $searchordids = implode("','", $ordids);
                    $wherecondition .= " AND o.id IN('" . $searchordids . "')";
                }
            }
            if ($userid != '0') {
                if (!empty($countryuids)) {
                    $tempCountryId = implode(',', $countryuids);
                    $wherecondition .= " and o.user_id in ($tempCountryId) ";
                } else {
                    $wherecondition .= "  and o.user_id = '$userid' ";
                }
            }

            $searchsts = $status_search;

            if ($searchsts == 'PENDING') {
                $wherecondition .= " and o.trip_id = 0 ";
            }

            if ($searchsts == 'ACTIVE') {
                $wherecondition .= " and o.trip_id != 0  and  o.trip_sts=0 ";
            }

            if ($searchsts == 'CLOSED') {
                $wherecondition .= " and o.trip_id != 0  and  o.trip_sts = 1 ";
            }

            if (!empty($subcusts)) {
                $tempSubCusts = implode(',', $subcusts);
                if ($tempSubCusts != '') {
                    $wherecondition .= " and o.customer_id in ($tempSubCusts) ";
                }
            } else {
                if ($custid != "") {
                    $wherecondition .= " and o.customer_id = '$custid' ";
                }
            }

            if (!empty($post['shipper_name']) || !empty($post['consignee_name'])) {
                $shipper_name_cond = $post['shipper_name'] ?? '';
                $consignee_name_cond = $post['consignee_name'] ?? '';

                if ($consignee_name_cond != '') {
                    $wherecondition .= " and o.delivery_company like '%$consignee_name_cond%' ";
                }
                if ($shipper_name_cond != '') {
                    $wherecondition .= " and o.pickup_company like '%$shipper_name_cond%' ";
                }
            }

            $countQueryResult = $this->db->query("select count(o.id) as count from tb_orders o left join tb_order_details d on d.order_row_id=o.id where o.status!=0  $wherecondition ");
            $rowCount = $countQueryResult->result();
            $wherecondition .= " and o.status !=0 ";
            $totalRecords = 0;
            $totalRecords = $rowCount[0]->count;
            $company_code = '"' . $company_code . '"';
            $orderByCondition = '"' . $orderByCondition . '"';
            $curtz = $this->session->userdata("usr_tzone")['timezone'];
            $timeZone = $curtz;
            $selectColumns = [
                'o.id',
                'o.order_id',
                'o.pickup_datetime',
                'o.delivery_datetime',
                'o.pickup_company',
                'o.delivery_company',
                'o.transport_mode',
                'o.company_code',
                'o.branch_code',
                'o.shipment_id',
                'o.status',
                'o.order_status',
                'o.trip_sts',
                'o.shift_id',
                'o.trip_id',
                'o.shipmentid',
                'o.createdon',
                'o.pickup_address1',
                'o.delivery_address1',
                'o.pickup_country',
                'o.pickup_city',
                'o.delivery_city',
                'o.pickup_pincode',
                'o.delivery_country',
                'o.delivery_pincode',
                'o.pickup_address2',
                'o.delivery_address2',
                'o.vendor_id',
                'o.goods_value',
                'o.product',
                'o.customer_id',
                'd.delivery_note',
                'd.department_code',
                'd.service',
                'd.incoterm',
                'd.delivery_term',
                'd.order_type',
                'd.purchase_order',
                'd.docs_received_datetime',
                'd.docs_sent_datetime',
                'v.name as vendor_name',
                'smas.name as name_of_service',
                'ot.type_name as order_type_name',
                'dt.name as delivery_term_name',
                'or.ref_value as salog_ref',
                'or.reference_id as ref_id',
                'IF(tbo.shipment_id > 0, "YES","NO") AS pod',
                "(SELECT convertToClientTZ(`tos`.`createdon`,'".$timeZone."') AS `rap_date` FROM `tb_order_status` `tos` WHERE `tos`.`order_id` = o.id AND `tos`.`status_code`='2500' AND `tos`.`status`= 1 LIMIT 1) AS rap_date",
                "(SELECT CASE WHEN `tos`.`createdon` > tss.createdon THEN 'Y' ELSE 'N' END AS rap_date
                FROM tb_order_status tos
                INNER JOIN tb_stop_status tss ON (tss.order_id = tos.order_id)
                WHERE `tos`.`order_id` = o.id AND `tos`.`status_code` = '2500' AND `tos`.`status` = 1 AND `tss`.`stop_type` = 'D' AND `tss`.`status_code` = '0192' AND tss.status = 1 LIMIT 1) AS rap_status"
            ];

            $table_name = 'tb_orders o';
            $indexColumn = 'o.id';
            $groupBy = 'o.id';
            $excludeCountQuery = 'Yes';

            $joinsArray[] = ['table_name' => 'tb_order_details as d', 'condition' => "o.id=d.order_row_id", 'join_type' => 'left'];
            $joinsArray[] = ['table_name' => 'tb_vendors as v', 'condition' => "v.id=o.id", 'join_type' => 'left'];
            $joinsArray[] = ['table_name' => 'tb_service_master as smas', 'condition' => "smas.id=d.service and smas.status=1", 'join_type' => 'left'];
            $joinsArray[] = ['table_name' => 'tb_order_types as ot', 'condition' => "ot.id=d.order_type and  ot.company_code=o.company_code and  ot.status=1", 'join_type' => 'left'];
            $joinsArray[] = ['table_name' => 'tb_delivery_terms as dt', 'condition' => "dt.term_id=d.delivery_term", 'join_type' => 'left'];
            $joinsArray[] = ['table_name' => 'tb_order_references as or', 'condition' => "or.order_id=o.id and  or.status=1", 'join_type' => 'left'];
            $joinsArray[] = ['table_name' => 'tb_pod_uploads as tbo', 'condition' => "tbo.order_id=o.id", 'join_type' => 'left'];
            $wherecondition = $indexColumn . "!='' " . $wherecondition;

            $orderByCondition = $orderByCondition;
            $totalRecords = $totalRecords;
            $dataTableSortOrdering = [];
            $getRecordListing = $this->Datatables_model->datatablesQuery($selectColumns, $dataTableSortOrdering, $table_name, $joinsArray, $wherecondition, $indexColumn, 'TRUE', $groupBy, $excludeCountQuery, 'POST');
            $reqData = ['id', 'order_id', 'shift_id', 'customer_id','trip_id'];
            $this->db->query('SET SESSION  group_concat_max_len=10240');
            $formattedData = $this->DataArrayFormatter_model->getCommaSeparatedFields($reqData, $getRecordListing['data']);
            if (isset($formattedData['commaSeparated']['id']) && $formattedData['commaSeparated']['id'] != '') {
                $formattedData = $this->DataQueryFormatter_model->getRevenueDetails($formattedData['commaSeparated']['id'], $formattedData);
                $formattedData = $this->DataQueryFormatter_model->getOrderReferences($formattedData['commaSeparated']['id'], $formattedData);
                $formattedData = $this->DataQueryFormatter_model->getPartyDetails($formattedData['commaSeparated']['id'], $formattedData);
                $formattedData = $this->DataQueryFormatter_model->getValueAddedServices($formattedData['commaSeparated']['id'], $formattedData);
                $formattedData = $this->DataQueryFormatter_model->getBillDetails($formattedData['commaSeparated']['id'], $formattedData);
                $formattedData = $this->DataQueryFormatter_model->getCompleteOrderCargoDetails($formattedData['commaSeparated']['id'], $formattedData);
                $formattedData = $this->DataQueryFormatter_model->getChargeInfo($formattedData['commaSeparated']['id'], $formattedData);
                $formattedData = $this->DataQueryFormatter_model->getPODDelivered($formattedData['commaSeparated']['id'], $formattedData);
                $formattedData = $this->DataQueryFormatter_model->getTransitTimeDetails($formattedData['commaSeparated']['id'], $formattedData);
            }
            if (isset($formattedData['commaSeparated']['customer_id']) && $formattedData['commaSeparated']['customer_id'] != '') {
                $customerDetailsArray = $this->DataQueryFormatter_model->getCustomerDetails($formattedData['commaSeparated']['customer_id']);
            }
            $tripInfoArray = $vehicleAndDriverArray = [];
            if (isset($formattedData['commaSeparated']['shift_id']) && $formattedData['commaSeparated']['shift_id'] != '') {
                $tripInfoArray = $this->DataQueryFormatter_model->getTripInfo($formattedData['commaSeparated']['shift_id']);
            }
            if (isset($formattedData['commaSeparated']['shift_id']) && $formattedData['commaSeparated']['shift_id'] != '') {
                $vehicleAndDriverArray = $this->DataQueryFormatter_model->getDriverVehicleDetails($formattedData['commaSeparated']['shift_id']);
            }
            $getRecordListing = $finalDriverDetails = [];
            if (isset($formattedData['orders'])) {
                $getRecordListing = $formattedData['orders'];
                krsort($getRecordListing);
            }
            if (!empty($getRecordListing)) {
                $data['final_array'] = $this->customreportservice->getAllRecordList($getRecordListing, $customerDetailsArray, $tripInfoArray, $vehicleAndDriverArray);

            }
        }
        $reporter_wise_show_fields = $this->getCustomReportSettingData($reporter_id);
        asort($reporter_wise_show_fields);
        $data['reprt_wise_show_fileds'] = array_keys($reporter_wise_show_fields);

       if($this->hasSpecificConditionsForTWCN($data, $formattedData, $sessionCompanyCode)){
           $driverDetails = $this->DataQueryFormatter_model->GetSecureLinkDriverDetails($formattedData['commaSeparated']['trip_id']);
           if($driverDetails != ""){
               $finalDriverDetails = $this->getDriverDetailsInArrayFormat($driverDetails);
           }
       }

        $data['finalDriverDetails'] = $finalDriverDetails;
        $this->newtemplate->dashboard("customreportpage/customReport", $data);
    }

    private function hasSpecificConditionsForTWCN (array $data, array $formattedData, string $sessionCompanyCode):bool
    {
        return (bool) (
            in_array('driver_number', $data['reprt_wise_show_fileds'], true)
            && isset($formattedData['commaSeparated']['trip_id'])
            && $formattedData['commaSeparated']['trip_id'] != ''
            && in_array($sessionCompanyCode, ['TWKN', 'CNKN'])
        );
    }

    public function getCustomReportSettingData(int $reportId): array
    {
        $reporter_wise_show_fields = [];
        $reportData = $this->CustomReportModel->getCustomReportData($reportId);
        foreach ($reportData as $row => $val) {
            if ($row != 'id' && $row != 'name' && $row != 'company_code' && $row != 'branch_code' && $row != 'status' && $row != 'created_on' && $row != 'updated_on') {
                $val_check = explode('_', $val);
                if ($val_check['0'] > 0) {
                    $reporter_wise_show_fields[$row] = $val_check['1'] ?? 0;
                }
            }
        }
        return $reporter_wise_show_fields;
    }

    public function getDriverDetailsInArrayFormat(array $driverDetails):array
    {
        $finalReqArray = [];
        foreach ($driverDetails as $eachLine) {
            $tripId = $eachLine['trip_id'];
            $tripDriverDetails = trim($eachLine['driver_details']);
            if ($tripDriverDetails == "") {
                continue;
            }

            $firstString = explode("?????", $tripDriverDetails);
            foreach ($firstString as $eachRow) {
                $secondString = explode("=====", $eachRow);
                $driverName = $secondString[0] ?? "";
                $driverNumber = $secondString[1] ?? "";
                $driverTruck = $secondString[2] ?? "";
                $finalReqArray[$tripId][] = $driverName . " ::: " . $driverNumber . " ::: " . $driverTruck;
            }
        }
        return $finalReqArray;
    }

}
